#include "plasma.h" 

// Call for Fortran

void PLASMA_INIT(int *M,int* N, int* NRHS, int * INFO)
{
	*INFO = plasma_Init(*M,*N,*NRHS);
}

void PLASMA_FINALIZE(int * INFO)
{
	*INFO = plasma_Finalize();
}


void PLASMA_DPOSV(PLASMA_enum* uplo, int* N, int* NRHS, double *A, int* LDA,
                 double *B, int* LDB, int* INFO)
{
	*INFO = plasma_DPOSV(*uplo,*N,*NRHS,A,*LDA,
                 B,*LDB);
}


void PLASMA_DPOTRF(PLASMA_enum* uplo, int* N, double *A, int* LDA, int* INFO)
{
	*INFO = plasma_DPOTRF(*uplo,*N,A,*LDA);
}


void PLASMA_DPOTRS(PLASMA_enum* uplo, int* N, int* NRHS, double *A, int* LDA,
                  double *B, int* LDB, int * INFO)
{
	*INFO = plasma_DPOTRS(*uplo, *N, *NRHS, A, *LDA,
                  B, *LDB);
}


void PLASMA_DTRSM(PLASMA_enum* side, PLASMA_enum* uplo, PLASMA_enum* transA,
                 PLASMA_enum* diag, int* N, int* NRHS, double *A, int* LDA,
                 double *B, int* LDB, int *INFO)
{
	*INFO = plasma_DTRSM(*side, *uplo,*transA,
                 *diag, *N, *NRHS, A, *LDA,
                 B, *LDB);
}


void PLASMA_DGELS(PLASMA_enum* trans, int* M, int* N, int* NRHS, double *A,
                 int* LDA,long long int* T, double *B, int* LDB, int * INFO)
{
	*INFO = plasma_DGELS(*trans, *M, *N, *NRHS, A,
                 * LDA, (double*)(*T),B, *LDB);
}

void PLASMA_DGEQRF(int* M, int* N, double *A, int* LDA, long long int *T, int *INFO)
{
	*INFO = plasma_DGEQRF(*M,  *N, A, *LDA, (double *)(*T));
}

void PLASMA_DORMQR(PLASMA_enum* side, PLASMA_enum* trans, int* M, int* NRHS, int* N,
                  double *A, int* LDA, long long int *T, double *B, int* LDB, int* INFO)
{
	*INFO = plasma_DORMQR(*side,*trans, *M, *NRHS, *N,
                A, *LDA, (double*)(*T), B, *LDB);
} 

void PLASMA_DGESV(int* N, int* NRHS, double *A, int* LDA, long long int *L, int *IPIV,
                 double *B, int* LDB, int *INFO)
{
	*INFO = plasma_DGESV(*N, *NRHS,A, *LDA, (double *)(*L), IPIV,
                B, *LDB);
}

void PLASMA_DGETRF(int *M, int *N, double *A, int *LDA, long long int *L,long long int *IPIV, int *INFO)
{
	*INFO = plasma_DGETRF(*M, *N, A, *LDA, (double*) (*L), (int *)(*IPIV));
}


void PLASMA_DGETRS(int *M, int *NRHS, int *N, double *A, int *LDA, long long int *L, long long int *IPIV,
                  double *B, int *LDB, int * INFO)
{
	*INFO = plasma_DGETRS(*M, *NRHS, *N, A, *LDA, (double*) (*L), (int *)(*IPIV),B, * LDB);
}

void PLASMA_DTRSMPL(int *M, int *NRHS, int *N, double *A, int *LDA, long long int *L,long long int *IPIV,
                   double *B, int *LDB, int *INFO)
{
	*INFO = plasma_DTRSMPL(*M, *NRHS, *N, A, *LDA, (double*) (*L),(int *)(*IPIV),B, *LDB);
}

//////////////////////////////////////////////////////////////////////////////////////////
//  Auxiliary function prototypes
//

void PLASMA_ALLOCATE_T(long long int* T,int* M, int* N)
{
	*T = (long long int) plasma_Allocate_T(*M, *N);
}

void PLASMA_FREE_T(long long int* T, int * INFO)
{
	*INFO = plasma_Free_T((double*)(*T));
}

void PLASMA_ALLOCATE_L(long long int *L, int* M, int* N)
{
	*L = (long long int) plasma_Allocate_L(* M, *N);
}


void PLASMA_FREE_L(long long int *L, int *INFO)
{
	*INFO = plasma_Free_L((double*)(*L));
}


void PLASMA_ALLOCATE_IPIV(long long int* IPIV ,int *M, int *N)
{
	*IPIV= (long long int ) plasma_Allocate_IPIV(*M,*N);
}

void PLASMA_FREE_IPIV(long long int *IPIV,int * INFO)
{
	*INFO = plasma_Free_IPIV((int *)(*IPIV));
}
