/*////////////////////////////////////////////////////////////////////////////////////////
 *  -- PLASMA --
 *     University of Tennessee
 */
#include "common.h"
#include "core_blas.h"

/*////////////////////////////////////////////////////////////////////////////////////////
 *  Parallel Cholesky factorization
 */
#define A(m,n) &A[NBNBSIZE*(m)+NBNBSIZE*NT*(n)]
#define progress(m,n) plasma_aux.progress[(m)+NT*(n)]

void plasma_pDPOTRF(PLASMA_enum uplo, int N, double *A, int NB, int NBNBSIZE, int NT,
                    int *INFO, int cores_num, int my_core_id)
{
    int k, m, n;
    int next_k;
    int next_m;
    int next_n;

    k = 0;
    m = my_core_id;
    while (m >= NT) {
        k++;
        m = m-NT+k;
    }
    n = 0;

    while (k < NT && m < NT) {
        next_n = n;
        next_m = m;
        next_k = k;

        next_n++;
        if (next_n > next_k) {
            next_m += cores_num;
            while (next_m >= NT && next_k < NT) {
                next_k++;
                next_m = next_m-NT+next_k;
            }
            next_n = 0;
        }

        if (m == k) {
            if (n == k) {
                if (uplo == PlasmaLower)
                    core_DPOTRF(
                        PlasmaLower,
                        k == NT-1 ? N-k*NB : NB,
                        A(k, k), NB,
                        INFO);
                else
                    core_DPOTRF(
                        PlasmaUpper,
                        k == NT-1 ? N-k*NB : NB,
                        A(k, k), NB,
                        INFO);
                  if (*INFO != 0)
                      *INFO += NB*k;
                progress(k, k) = 1;
            }
            else {
                while(progress(k, n) != 1 && *INFO == 0);
                if (uplo == PlasmaLower)
                    core_DSYRK(
                         PlasmaLower, PlasmaNoTrans,
                         k == NT-1 ? N-k*NB : NB,
                         NB,
                        -1.0, A(k, n), NB,
                         1.0, A(k, k), NB);
                else
                    core_DSYRK(
                         PlasmaUpper, PlasmaTrans,
                         k == NT-1 ? N-k*NB : NB,
                         NB,
                        -1.0, A(n, k), NB,
                         1.0, A(k, k), NB);
            }
        }
        else {
            if (n == k) {
                while(progress(k, k) != 1 && *INFO == 0);
                if (uplo == PlasmaLower)
                    core_DTRSM(
                        PlasmaRight, PlasmaLower, PlasmaTrans, PlasmaNonUnit,
                        m == NT-1 ? N-m*NB : NB,
                        NB,
                        1.0, A(k, k), NB,
                             A(m, k), NB);
                else
                    core_DTRSM(
                        PlasmaLeft, PlasmaUpper, PlasmaTrans, PlasmaNonUnit,
                        NB,
                        m == NT-1 ? N-m*NB : NB,
                        1.0, A(k, k), NB,
                             A(k, m), NB);
                progress(m, k) = 1;
            }
            else {
                while(progress(k, n) != 1 && *INFO == 0);
                while(progress(m, n) != 1 && *INFO == 0);
                if (uplo == PlasmaLower)
                    core_DGEMM(
                        PlasmaNoTrans, PlasmaTrans,
                        m == NT-1 ? N-m*NB : NB,
                        NB,
                        NB,
                       -1.0, A(m, n), NB,
                             A(k, n), NB,
                        1.0, A(m, k), NB);
                else
                    core_DGEMM(
                        PlasmaTrans, PlasmaNoTrans,
                        NB,
                        m == NT-1 ? N-m*NB : NB,
                        NB,
                       -1.0, A(n, k), NB,
                             A(n, m), NB,
                        1.0, A(k, m), NB);
            }
        }
        if (*INFO != 0)
            return;

        n = next_n;
        m = next_m;
        k = next_k;
    }
}
#undef A
#undef progress
