/*////////////////////////////////////////////////////////////////////////////////////////
 *  -- PLASMA --
 *     University of Tennessee
 */
#include "common.h"
#include "core_blas.h"

/*////////////////////////////////////////////////////////////////////////////////////////
 *  Parallel construction of Q using tile V (application to identity)
 */
#define A(m,n) &A[NBNBSIZE*(m)+NBNBSIZE*MT*(n)]
#define B(m,n) &B[NBNBSIZE*(m)+NBNBSIZE*MT*(n)]
#define T(m,n) &T[IBNBSIZE*(m)+IBNBSIZE*MT*(n)]
#define progress(m,n) plasma_aux.progress[(m)+MT*(n)]

void plasma_pDORGQR(int M, int NRHS, int N, double *A, int NB, int NBNBSIZE,
                    int IBNBSIZE, int IB, int MT, int NTRHS, int NT, double *T,
                    double *B, int *INFO, int cores_num, int my_core_id)
{
    double *WORK = plasma_aux.WORK[my_core_id];
    int k, m, n;
    int next_k;
    int next_m;
    int next_n;

    k = 0;
    n = my_core_id;
    while (n >= NTRHS) {
        k++;
        n = n-NTRHS;
    }
    m = k;

    while (k < min(MT, NT) && n < NTRHS) {
        next_n = n;
        next_m = m;
        next_k = k;

        next_m++;
        if (next_m == MT) {
            next_n += cores_num;
            while (next_n >= NTRHS && next_k < min(MT, NT)) {
                next_k++;
                next_n = next_n-NTRHS;
            }
            next_m = next_k;
        }

        if (m == k) {
            while (progress(k, n) != k-1);
            if (n < min(k+1, NTRHS))
                core_DLARFB(
                    PlasmaLeft, PlasmaNoTrans,
                    PlasmaForward, PlasmaColumnwise,
                    k == MT-1 ? M-k*NB : NB,
                    n == NTRHS-1 ? NRHS-n*NB : NB,
                    k == NT-1 ? min(M-k*NB, N-k*NB) : NB,
                    IB,
                    A(k, k), NB,
                    T(k, k), IB,
                    B(k, n), NB,
                    WORK, NB);
            progress(k, n) = k;
        }
        else {
            while (progress(k, n) != k);
            while (progress(m, n) != k-1);
            if (n < (m+1, NTRHS))
                core_DSSRFB(
                    PlasmaLeft, PlasmaColumnwise,
                    NB,
                    m == MT-1 ? M-m*NB : NB,
                    n == NTRHS-1 ? NRHS-n*NB : NB,
                    IB,
                    k == NT-1 ? N-k*NB : NB,
                    B(k, n), NB,
                    B(m, n), NB,
                    A(m, k), NB,
                    T(m, k), IB,
                    WORK);
            progress(m, n) = k;
        }
        n = next_n;
        m = next_m;
        k = next_k;
    }
}

#undef A
#undef B
#undef T
#undef progress
