/*////////////////////////////////////////////////////////////////////////////////////////
 *  -- PLASMA --
 *     University of Tennessee
 */
#include "common.h"
#include "core_blas.h"

/*////////////////////////////////////////////////////////////////////////////////////////
 *  Parallel tile LU factorization
 */
#define A(m,n) &A[NBNBSIZE*(m)+NBNBSIZE*MT*(n)]
#define L(m,n) &L[IBNBSIZE*(m)+IBNBSIZE*MT*(n)]
#define IPIV(m,n) &IPIV[NB*(m)+NB*MT*(n)]
#define progress(m,n) plasma_aux.progress[(m)+MT*(n)]

void plasma_pDGETRF(int M, int N, double *A, int NB, int NBNBSIZE, int IBNBSIZE,
                    int IB, int MT, int NT, double *L, int *IPIV, int *INFO,
                    int cores_num, int my_core_id)
{
    int k, m, n;
    int next_k;
    int next_m;
    int next_n;

    k = 0;
    n = my_core_id;
    while (n >= NT) {
        k++;
        n = n-NT+k;
    }
    m = k;

    while (k < min(MT, NT) && n < NT) {
        next_n = n;
        next_m = m;
        next_k = k;

        next_m++;
        if (next_m == MT) {
            next_n += cores_num;
            while (next_n >= NT && next_k < min(MT, NT)) {
                next_k++;
                next_n = next_n-NT+next_k;
            }
            next_m = next_k;
        }

        if (n == k) {
            if (m == k) {
                while(progress(k, k) != k-1);
                core_DGETRF(
                    k == MT-1 ? M-k*NB : NB,
                    k == NT-1 ? N-k*NB : NB,
                    IB,
                    A(k, k), NB,
                    L(k, k), NB,
                    IPIV(k, k), INFO);
                  if (*INFO != 0)
                      *INFO += NB*k;
                progress(k, k) = k;
            }
            else {
                while(progress(m, k) != k-1);
                core_DTSTRF(
                    m == MT-1 ? M-m*NB : NB,
                    k == NT-1 ? N-k*NB : NB,
                    IB,
                    NB,
                    A(k, k), NB,
                    A(m, k), NB,
                    L(m, k), IB,
                    IPIV(m, k), INFO);
                  if (*INFO != 0)
                      *INFO += NB*k;
                progress(m, k) = k;
            }
        }
        else {
            if (m == k) {
                while(progress(k, k) != k);
                while(progress(k, n) != k-1);
                core_DGESSM(
                    k == MT-1 ? M-k*NB : NB,
                    n == NT-1 ? N-n*NB : NB,
                    NB,
                    IB,
                    IPIV(k, k),
                    A(k, k), NB,
                    A(k, n), NB);
            }
            else {
                while(progress(m, k) != k);
                while(progress(m, n) != k-1);
                core_DSSSSM(
                    NB,
                    m == MT-1 ? M-m*NB : NB,
                    n == NT-1 ? N-n*NB : NB,
                    IB,
                    NB,
                    IPIV(m, k),
                    L(m, k), IB,
                    A(m, k), NB,
                    A(k, n), NB,
                    A(m, n), NB);
                progress(m, n) = k;
            }
        }
        n = next_n;
        m = next_m;
        k = next_k;
    }
}

#undef A
#undef L
#undef IPIV
#undef progress
