/*////////////////////////////////////////////////////////////////////////////////////////
 *  -- PLASMA --
 *     University of Tennessee
 */
#include "global.h"

/*////////////////////////////////////////////////////////////////////////////////////////
 *  Main control data structure
 */
struct plasma_cntrl_t plasma_cntrl = {
    PTHREAD_MUTEX_INITIALIZER,  // action_mutex
    PTHREAD_COND_INITIALIZER,   // action_condt
    PLASMA_ACT_STAND_BY,        // action
    PLASMA_FALSE,               // initialized
    PLASMA_FALSE,               // bdl_huge_pages
    256,                        // NB_max
    5,                          // NB_min          --- eventualy change to 32
    128                         // IB_max
};

/*////////////////////////////////////////////////////////////////////////////////////////
 *  Auxiliary storage
 */
struct plasma_aux_t plasma_aux = {
    NULL,       // bdl_mem
    NULL,       // progress
    {NULL},     // WORK[0]
    {NULL}      // TAU[0]
};

/*////////////////////////////////////////////////////////////////////////////////////////
 *  Master->workers communication of arguments
 */
struct plasma_args_t plasma_args;

/*////////////////////////////////////////////////////////////////////////////////////////
 *  LAPACK Constants
 */
char *plasma_lapack_constants[] =
{
    "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
    "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
    "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
    "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
    "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
    "", "", "", "", "", "",
    "Row",                  // 101
    "Column",               // 102
    "", "", "", "", "", "", "", "",
    "No transpose",         // 111
    "Transpose",            // 112
    "Conjugate transpose",  // 113
    "", "", "", "", "", "", "",
    "Upper",                // 121
    "Lower",                // 122
    "", "", "", "", "", "", "", "",
    "Non-unit",             // 131
    "Unit",                 // 132
    "", "", "", "", "", "", "", "",
    "Left",                 // 141
    "Right"                 // 142
    "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
    "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
    "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
    "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
    "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
    "", "", "", "", "", "",
    "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
    "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
    "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
    "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
    "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
    "", "", "", "", "", "",
    "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
    "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
    "", "", "", "", "", "", "", "", "",
    "Forward",              // 391
    "Backward",             // 391
    "", "", "", "", "", "", "", "",
    "Columnwise",           // 401
    "Rowwise"               // 402
};
