/*////////////////////////////////////////////////////////////////////////////////////////
 *  -- PLASMA --
 *     University of Tennessee
 */
#ifndef _PLASMA_CORE_BLAS_H_
#define _PLASMA_CORE_BLAS_H_

/*////////////////////////////////////////////////////////////////////////////////////////
 *  MKL related
 */
#ifdef MKL
    #include <mkl_cblas.h>
#else
    #include <cblas.h>

    #define CBLAS_TRANSPOSE enum CBLAS_TRANSPOSE
    #define CBLAS_UPLO enum CBLAS_UPLO
    #define CBLAS_DIAG enum CBLAS_DIAG
    #define CBLAS_SIDE enum CBLAS_SIDE
#endif

/*////////////////////////////////////////////////////////////////////////////////////////
 *  FORTRAN prototypes
 */
#define core_dgeqrt core_dgeqrt_
#define core_dtsqrt core_dtsqrt_
#define core_dlarfb core_dlarfb_
#define core_dssrfb core_dssrfb_
#define core_dgelqt core_dgelqt_
#define core_dtslqt core_dtslqt_
#define core_dgetrf core_dgetrf_
#define core_dtstrf core_dtstrf_
#define core_dgessm core_dgessm_
#define core_dssssm core_dssssm_

void core_dgeqrt(int*, int*, int*, double*, int*, double*, int*, double*, double*, int*);
void core_dtsqrt(int*, int*, int*, double*, int*, double*, int*, double*, int*, double*,
            double*, int*);
void core_dlarfb(char*, char*, char*, char*, int*, int*, int*, int*, double*, int*,
            double*, int*, double*, int*, double*, int*, int*);
void core_dssrfb(char*, char*, int*, int*, int*, int*, int*, double*, int*, double*, int*,
                 double*, int*, double*, int*, double*, int*);
void core_dgelqt(int*, int*, int*, double*, int*, double*, int*, double*, double*, int*);
void core_dtslqt(int*, int*, int*, double*, int*, double*, int*, double*, int*, double*,
            double*, int*);
void core_dgetrf(int*, int*, int*, double*, int*, double*, int*, int*, int*);
void core_dtstrf(int*, int*, int*, int*, double*, int*, double*, int*, double*, int*,
                 int*, int*);
void core_dgessm(int*, int*, int*, int*, int*, double*, int*, double*, int*, int*);
void core_dssssm(int*, int*, int*, int*, int*, int*, double*, int*, double*, int*,
                 double*, int*, double*, int*, int*);


/*////////////////////////////////////////////////////////////////////////////////////////
 *  C prototypes
 */
void core_DPOTRF(int uplo, int N, double *A, int LDA, int *INFO);

void core_DSYRK(int uplo, int trans, int N, int K, double alpha, double *A, int LDA,
                double beta, double *C, int LDC);

void core_DTRSM(int side, int uplo, int transA, int diag, int M, int N, double alpha,
                double *A, int LDA, double *B, int LDB);

void core_DGEMM(int transA, int transB, int M, int N, int K, double alpha, double *A,
                int LDA, double *B, int LDB, double beta, double *C, int LDC);

void core_DGEQRT(int M, int N, int IB, double *A, int LDA, double *T , int LDT,
                 double *TAU, double *WORK);

void core_DTSQRT(int M, int N, int IB, double *A1, int LDA1, double *A2, int LDA2,
                 double *T, int LDT, double *TAU, double *WORK);

void core_DLARFB(int side, int trans, int direct, int storev, int M, int N, int K,
                 int IB, double *V, int LDV, double *T, int LDT, double *C, int LDC,
                 double *WORK, int LDWORK);

void core_DSSRFB(int side, int storev, int M1, int M2, int NN, int IB, int K,
                 double *A1, int LDA1, double *A2, int LDA2, double *V, int LDV,
                 double *T, int LDT, double *WORK);

void core_DGELQT(int M, int N, int IB, double *A, int LDA, double *T , int LDT,
                 double *TAU, double *WORK);

void core_DTSLQT(int M, int N, int IB, double *A1, int LDA1, double *A2, int LDA2,
                 double *T, int LDT, double *TAU, double *WORK);

void core_DGETRF(int M, int N, int IB, double *A, int LDA, double *L, int LDL,
                 int *IPIV, int *INFO);

void core_DTSTRF(int M, int N, int IB, int NB, double *U, int LDU, double *A, int LDA,
                 double *L, int LDL, int *IPIV, int *INFO);

void core_DGESSM(int M, int N, int K, int IB, int *IPIV, double *L, int LDL,
                 double *A, int LDA);

void core_DSSSSM(int M1, int M2, int NN, int IB, int K, int *IPIV, double *L0, int LDL0,
                 double *L1, int LDL1, double *A0, int LDA0, double *A1, int LDA1);

#endif
