/*////////////////////////////////////////////////////////////////////////////////////////
 *  -- PLASMA --
 *     University of Tennessee
 */
#include "common.h"
#include "core_blas.h"
#include "lapack.h"

/*////////////////////////////////////////////////////////////////////////////////////////
 */
void core_DPOTRF(int uplo, int N, double *A, int LDA, int *INFO)
{
    dpotrf(lapack_const(uplo), &N, A, &LDA, INFO);
}

/*////////////////////////////////////////////////////////////////////////////////////////
 */
void core_DSYRK(int uplo, int trans, int N, int K, double alpha, double *A,
                int LDA, double beta, double *C, int LDC)
{
    cblas_dsyrk(
        CblasColMajor,
        (CBLAS_UPLO)uplo, (CBLAS_TRANSPOSE)trans,
        N, K,
        alpha, A, LDA,
         beta, C, LDC);
}

/*////////////////////////////////////////////////////////////////////////////////////////
 */
void core_DTRSM(int side, int uplo, int transA, int diag, int M, int N,
                double alpha, double *A, int LDA, double *B, int LDB)
{
    cblas_dtrsm(
        CblasColMajor,
        (CBLAS_SIDE)side, (CBLAS_UPLO)uplo,
        (CBLAS_TRANSPOSE)transA, (CBLAS_DIAG)diag,
        M, N,
        alpha, A, LDA,
               B, LDB);
}

/*////////////////////////////////////////////////////////////////////////////////////////
 */
void core_DGEMM(int transA, int transB, int M, int N, int K, double alpha,
                double *A, int LDA, double *B, int LDB, double beta, double *C,
                int LDC)
{
    cblas_dgemm(
        CblasColMajor,
        (CBLAS_TRANSPOSE)transA, (CBLAS_TRANSPOSE)transB,
        M, N, K,
        alpha, A, LDA,
               B, LDB,
         beta, C, LDC);
}

/*////////////////////////////////////////////////////////////////////////////////////////
 */
void core_DGEQRT(int M, int N, int IB, double *A, int LDA, double *T , int LDT,
                 double *TAU, double *WORK)
{
    int INFO;

    core_dgeqrt(
        &M, &N, &IB,
        A, &LDA,
        T , &LDT,
        TAU, WORK, &INFO);
}

/*////////////////////////////////////////////////////////////////////////////////////////
 */
void core_DTSQRT(int M, int N, int IB, double *A1, int LDA1, double *A2,
                 int LDA2, double *T, int LDT, double *TAU, double *WORK)
{
    int INFO;

    core_dtsqrt(
        &M, &N, &IB,
        A1, &LDA1,
        A2, &LDA2,
        T, &LDT,
        TAU, WORK, &INFO);
}

/*////////////////////////////////////////////////////////////////////////////////////////
 */
void core_DLARFB(int side, int trans, int direct, int storev, int M, int N,
                 int K, int IB, double *V, int LDV, double *T, int LDT,
                 double *C, int LDC, double *WORK, int LDWORK)
{
    int INFO;

    core_dlarfb(
        lapack_const(side), lapack_const(trans),
        lapack_const(direct), lapack_const(storev),
        &M, &N, &K, &IB,
        V, &LDV,
        T, &LDT,
        C, &LDC,
        WORK, &LDWORK, &INFO);
}

/*////////////////////////////////////////////////////////////////////////////////////////
 */
void core_DSSRFB(int side, int storev, int M1, int M2, int NN, int IB, int K,
                 double *A1, int LDA1, double *A2, int LDA2, double *V, int LDV,
                 double *T, int LDT, double *WORK)
{
    int INFO;

    core_dssrfb(
        lapack_const(side), lapack_const(storev),
        &M1, &M2, &NN, &IB, &K,
        A1, &LDA1,
        A2, &LDA2,
        V, &LDV,
        T, &LDT,
        WORK, &INFO);
}

/*////////////////////////////////////////////////////////////////////////////////////////
 */
void core_DGELQT(int M, int N, int IB, double *A, int LDA, double *T , int LDT,
                 double *TAU, double *WORK)
{
    int INFO;

    core_dgelqt(
        &M, &N, &IB,
        A, &LDA,
        T , &LDT,
        TAU, WORK, &INFO);
}

/*////////////////////////////////////////////////////////////////////////////////////////
 */
void core_DTSLQT(int M, int N, int IB, double *A1, int LDA1, double *A2,
                 int LDA2, double *T, int LDT, double *TAU, double *WORK)
{
    int INFO;

    core_dtslqt(
        &M, &N, &IB,
        A1, &LDA1,
        A2, &LDA2,
        T, &LDT,
        TAU, WORK, &INFO);
}

/*////////////////////////////////////////////////////////////////////////////////////////
 */
void core_DGETRF(int M, int N, int IB, double *A, int LDA, double *L, int LDL,
                 int *IPIV, int *INFO)
{
    core_dgetrf(
        &M, &N, &IB,
        A, &LDA,
        L, &LDL,
        IPIV, INFO);
}

/*////////////////////////////////////////////////////////////////////////////////////////
 */
void core_DTSTRF(int M, int N, int IB, int NB, double *U, int LDU, double *A, int LDA,
                 double *L, int LDL, int *IPIV, int *INFO)
{
    core_dtstrf(
        &M, &N, &IB, &NB,
        U, &LDU,
        A, &LDA,
        L, &LDL,
        IPIV, INFO);
}

/*////////////////////////////////////////////////////////////////////////////////////////
 */
void core_DGESSM(int M, int N, int K, int IB, int *IPIV, double *L, int LDL,
                 double *A, int LDA)
{
    int INFO;

    core_dgessm(
        &M, &N, &K, &IB,
        IPIV,
        L, &LDL,
        A, &LDA,
        &INFO);
}

/*////////////////////////////////////////////////////////////////////////////////////////
 */
void core_DSSSSM(int M1, int M2, int NN, int IB, int K, int *IPIV, double *L0, int LDL0,
                 double *L1, int LDL1, double *A0, int LDA0, double *A1, int LDA1)
{
    int INFO;

    core_dssssm(
        &M1, &M2, &NN, &IB, &K,
        IPIV,
        L0, &LDL0,
        L1, &LDL1,
        A0, &LDA0,
        A1, &LDA1,
        &INFO);
}
