/*////////////////////////////////////////////////////////////////////////////////////////
 *  -- PLASMA --
 *     University of Tennessee
 */
#ifndef _PLASMA_COMMON_H_
#define _PLASMA_COMMON_H_

#include "global.h"

#include <pthread.h>

/*////////////////////////////////////////////////////////////////////////////////////////
 *  Global structures
 */
extern struct plasma_cntrl_t plasma_cntrl;
extern struct plasma_aux_t plasma_aux;
extern struct plasma_args_t plasma_args;

extern char *plasma_lapack_constants[];

/*////////////////////////////////////////////////////////////////////////////////////////
 *  Parallel numerical functions prototypes
 */
void plasma_pDPOTRF(PLASMA_enum uplo, int N, double *A, int NB, int NBNBSIZE, int NT,
                    int *INFO, int cores_num, int my_core_id);

void plasma_pDTRSM(PLASMA_enum side, PLASMA_enum uplo, PLASMA_enum transA, PLASMA_enum diag,
                   int N, int NRHS, double alpha, double *A, int NB, int NBNBSIZE, int NT,
                   int MT, double *B, int MTB, int NTRHS, int cores_num, int my_core_id);

void plasma_pDGEQRF(int M, int N, double *A, int NB, int NBNBSIZE, int IBNBSIZE,
                    int IB, int MT, int NT, double *T, int *INFO, int cores_num,
                    int my_core_id);

void plasma_pDORMQR(int M, int NRHS, int N, double *A, int NB, int NBNBSIZE,
                    int IBNBSIZE, int IB, int MT, int NTRHS, int NT, double *T,
                    double *B, int *INFO, int cores_num, int my_core_id);

void plasma_pDORGQR(int M, int NRHS, int N, double *A, int NB, int NBNBSIZE,
                    int IBNBSIZE, int IB,int MT, int NTRHS, int NT, double *T,
                    double *B, int *INFO, int cores_num, int my_core_id);

void plasma_pDGELQF(int M, int N, double *A, int NB, int NBNBSIZE, int IBNBSIZE,
                    int IB, int MT, int NT, double *T, int *INFO, int cores_num,
                    int my_core_id);

void plasma_pDORMLQ(int M, int NRHS, int N, double *A, int NB, int NBNBSIZE,
                    int IBNBSIZE, int IB, int MT, int NTRHS, int NT, double *T,
                    double *B, int *INFO, int cores_num, int my_core_id);

void plasma_pDGETRF(int M, int N, double *A, int NB, int NBNBSIZE, int IBNBSIZE,
                    int IB, int MT, int NT, double *L, int *IPIV, int *INFO,
                    int cores_num, int my_core_id);

void plasma_pDTRSMPL(int M, int NRHS, int N, double *A, int NB, int NBNBSIZE,
                     int IBNBSIZE, int IB, int MT, int NTRHS, int NT, double *L,
                     int *IPIV, double *B, int *INFO, int cores_num, int my_core_id);

#endif
