/*////////////////////////////////////////////////////////////////////////////////////////
 *  -- PLASMA --
 *     University of Tennessee
 */
#include "common.h"
#include "bdl_convert.h"

/*////////////////////////////////////////////////////////////////////////////////////////
 *  Conversion from LAPACK F77 matrix layout to Block Data Layout
 */
void plasma_lapack_to_bdl(double *Af77, double *Abdl, int M, int N, int LDA, int NB,
                          int MT, int NT, int NBNBSIZE, int cores_num, int my_core_id)
{
    double *F77;
    double *BDL;
    int x, y;
    int X, Y;
    int n, m;
    int next_m;
    int next_n;

    n = 0;
    m = my_core_id;
    while (m >= MT && n < NT) {
        n++;
        m = m-MT;
    }

    while (n < NT) {
        next_m = m;
        next_n = n;

        next_m += cores_num;
        while (next_m >= MT && next_n < NT) {
            next_n++;
            next_m = next_m-MT;
        }

        X = n == NT-1 ? N-NB*n : NB;
        Y = m == MT-1 ? M-NB*m : NB;
        F77 = &Af77[NB*(LDA*n+m)];
        BDL = &Abdl[NBNBSIZE*(MT*n+m)];

        for (x = 0; x < X; x++)
            for (y = 0; y < Y; y++)
                BDL[NB*x+y] = F77[LDA*x+y];

        m = next_m;
        n = next_n;
    }
}

/*////////////////////////////////////////////////////////////////////////////////////////
 *  Conversion from Block Data Layout to LAPACK F77 matrix layout
 */
void plasma_bdl_to_lapack(double *Abdl, double *Af77, int M, int N, int LDA, int NB,
                          int MT, int NT, int NBNBSIZE, int cores_num, int my_core_id)
{
    double *F77;
    double *BDL;
    int x, y;
    int X, Y;
    int n, m;
    int next_m;
    int next_n;

    n = 0;
    m = my_core_id;
    while (m >= MT && n < NT) {
        n++;
        m = m-MT;
    }

    while (n < NT) {
        next_m = m;
        next_n = n;

        next_m += cores_num;
        while (next_m >= MT && next_n < NT) {
            next_n++;
            next_m = next_m-MT;
        }

        X = n == NT-1 ? N-NB*n : NB;
        Y = m == MT-1 ? M-NB*m : NB;
        F77 = &Af77[NB*(LDA*n+m)];
        BDL = &Abdl[NBNBSIZE*(MT*n+m)];

        for (x = 0; x < X; x++)
            for (y = 0; y < Y; y++)
                F77[LDA*x+y] = BDL[NB*x+y];

        m = next_m;
        n = next_n;
    }
}
