/*////////////////////////////////////////////////////////////////////////////////////////
 *  -- PLASMA --
 *     University of Tennessee
 */
#include "common.h"
#include "barrier.h"

static volatile int barrier_in[CORES_MAX];
static volatile int barrier_out[CORES_MAX];

/*////////////////////////////////////////////////////////////////////////////////////////
 *  Busy-waiting barrier initialization
 */
void plasma_barrier_init()
{
    int core;

    for (core = 0; core < CORES_MAX; core++) {
        barrier_in[core] = 0;
        barrier_out[core] = 0;
    }
}

/*////////////////////////////////////////////////////////////////////////////////////////
 *  Busy-waiting barrier
 */
void plasma_barrier(int my_core_id, int cores_num)
{
    int core;

    if (my_core_id == 0)    {
        for (core = 1; core < cores_num; core++)
            while (barrier_in[core] == 0);

        for (core = 1; core < cores_num; core++)
            barrier_in[core] = 0;

        for (core = 1; core < cores_num; core++)
            barrier_out[core] = 1;
    }
    else
    {
        barrier_in[my_core_id] = 1;
        while (barrier_out[my_core_id] == 0);
        barrier_out[my_core_id] = 0;
    }
}
