#! /usr/bin/env python
# -*- coding: utf-8 -*-

# -----------------------------------------
# PLASMA installer
# University of Tennessee Knoxville
# July 4, 2009
# ----------------------------------------

import sys
import os

VERSION_MAJOR = 1
VERSION_MINOR = 2
VERSION_MICRO = 0

import script
from script.blas        import Blas
from script.cblas       import CBlas
from script.lapack      import Lapack
from script.tmg         import Tmg
from script.lapcwrapper import Lapcwrapper
from script.plasma      import Plasma

import netlib

def main(argv):
  
  ### Store history of executed commands in config.log
  cmd = ""
  for arg in argv:
      cmd += arg+" "
  cmd += "\n"
  fp = open("history.log",'a')
  fp.write(cmd)
  fp.close()
  ### END

  config = netlib.Config((VERSION_MAJOR, VERSION_MINOR, VERSION_MICRO))

  plasma = Plasma(argv, config)

  if plasma.testing or plasma.src or plasma.downblas :
    blas_inst     = Blas(config, plasma);

  if plasma.testing or plasma.src or plasma.downcblas :
    cblas_inst    = CBlas(config, plasma);

  if plasma.testing or plasma.src or plasma.downlapack :
    lapack_inst   = Lapack(config, plasma);

  # plasma.downtmg set to 1 by lapack if necessary
  if plasma.needtmg :
    tmg_inst      = Tmg(config, plasma)

  # Always required for the lapack.h
  lapc_inst = Lapcwrapper(config, plasma)

  plasma.resume()

  return 0

if "__main__" == __name__:
  sys.exit(main(sys.argv))
