/*******************************************************************************
 *  This file is AUTOMATICALLY GENERATED by:
 *  tools/fortran_wrappers.pl include/magma_z.i
 *  Do not edit.
 ******************************************************************************/

#include <stdint.h>  // for uintptr_t

#include "magma_v2.h"
#include "magma_mangling.h"

// typedef from CUDADIR/src/fortran.h directory
typedef size_t devptr_t;

#ifdef PGI_FORTRAN
    #define magma_devptr(ptr_)  ((void*)              (ptr_))
    #define magma_idevptr(ptr_) ((magma_int_t*)       (ptr_))
    #define magma_zdevptr(ptr_) ((magmaDoubleComplex*)(ptr_))
    #define magma_cdevptr(ptr_) ((magmaFloatComplex*) (ptr_))
    #define magma_ddevptr(ptr_) ((double*)            (ptr_))
    #define magma_sdevptr(ptr_) ((float*)             (ptr_))
#else
    #define magma_devptr(ptr_)  ((void*)              (uintptr_t)(*(ptr_)))
    #define magma_idevptr(ptr_) ((magma_int_t*)       (uintptr_t)(*(ptr_)))
    #define magma_zdevptr(ptr_) ((magmaDoubleComplex*)(uintptr_t)(*(ptr_)))
    #define magma_cdevptr(ptr_) ((magmaFloatComplex*) (uintptr_t)(*(ptr_)))
    #define magma_ddevptr(ptr_) ((double*)            (uintptr_t)(*(ptr_)))
    #define magma_sdevptr(ptr_) ((float*)             (uintptr_t)(*(ptr_)))
#endif

#ifdef __cplusplus
extern "C" {
#endif

#define magmaf_get_zpotrf_nb FORTRAN_NAME( magmaf_get_zpotrf_nb, MAGMAF_GET_ZPOTRF_NB )
magma_int_t magmaf_get_zpotrf_nb(
    magma_int_t *n )
{
    return magma_get_zpotrf_nb(
        *n );
}

#define magmaf_get_zgetrf_nb FORTRAN_NAME( magmaf_get_zgetrf_nb, MAGMAF_GET_ZGETRF_NB )
magma_int_t magmaf_get_zgetrf_nb(
    magma_int_t *m, magma_int_t *n )
{
    return magma_get_zgetrf_nb(
        *m, *n );
}

#define magmaf_get_zgetrf_native_nb FORTRAN_NAME( magmaf_get_zgetrf_native_nb, MAGMAF_GET_ZGETRF_NATIVE_NB )
magma_int_t magmaf_get_zgetrf_native_nb(
    magma_int_t *m, magma_int_t *n )
{
    return magma_get_zgetrf_native_nb(
        *m, *n );
}

#define magmaf_get_zgetri_nb FORTRAN_NAME( magmaf_get_zgetri_nb, MAGMAF_GET_ZGETRI_NB )
magma_int_t magmaf_get_zgetri_nb(
    magma_int_t *n )
{
    return magma_get_zgetri_nb(
        *n );
}

#define magmaf_get_zhetrf_nb FORTRAN_NAME( magmaf_get_zhetrf_nb, MAGMAF_GET_ZHETRF_NB )
magma_int_t magmaf_get_zhetrf_nb(
    magma_int_t *n )
{
    return magma_get_zhetrf_nb(
        *n );
}

#define magmaf_get_zhetrf_nopiv_nb FORTRAN_NAME( magmaf_get_zhetrf_nopiv_nb, MAGMAF_GET_ZHETRF_NOPIV_NB )
magma_int_t magmaf_get_zhetrf_nopiv_nb(
    magma_int_t *n )
{
    return magma_get_zhetrf_nopiv_nb(
        *n );
}

#define magmaf_get_zhetrf_aasen_nb FORTRAN_NAME( magmaf_get_zhetrf_aasen_nb, MAGMAF_GET_ZHETRF_AASEN_NB )
magma_int_t magmaf_get_zhetrf_aasen_nb(
    magma_int_t *n )
{
    return magma_get_zhetrf_aasen_nb(
        *n );
}

#define magmaf_get_zgeqp3_nb FORTRAN_NAME( magmaf_get_zgeqp3_nb, MAGMAF_GET_ZGEQP3_NB )
magma_int_t magmaf_get_zgeqp3_nb(
    magma_int_t *m, magma_int_t *n )
{
    return magma_get_zgeqp3_nb(
        *m, *n );
}

#define magmaf_get_zgeqrf_nb FORTRAN_NAME( magmaf_get_zgeqrf_nb, MAGMAF_GET_ZGEQRF_NB )
magma_int_t magmaf_get_zgeqrf_nb(
    magma_int_t *m, magma_int_t *n )
{
    return magma_get_zgeqrf_nb(
        *m, *n );
}

#define magmaf_get_zgeqlf_nb FORTRAN_NAME( magmaf_get_zgeqlf_nb, MAGMAF_GET_ZGEQLF_NB )
magma_int_t magmaf_get_zgeqlf_nb(
    magma_int_t *m, magma_int_t *n )
{
    return magma_get_zgeqlf_nb(
        *m, *n );
}

#define magmaf_get_zgelqf_nb FORTRAN_NAME( magmaf_get_zgelqf_nb, MAGMAF_GET_ZGELQF_NB )
magma_int_t magmaf_get_zgelqf_nb(
    magma_int_t *m, magma_int_t *n )
{
    return magma_get_zgelqf_nb(
        *m, *n );
}

#define magmaf_get_zgehrd_nb FORTRAN_NAME( magmaf_get_zgehrd_nb, MAGMAF_GET_ZGEHRD_NB )
magma_int_t magmaf_get_zgehrd_nb(
    magma_int_t *n )
{
    return magma_get_zgehrd_nb(
        *n );
}

#define magmaf_get_zhetrd_nb FORTRAN_NAME( magmaf_get_zhetrd_nb, MAGMAF_GET_ZHETRD_NB )
magma_int_t magmaf_get_zhetrd_nb(
    magma_int_t *n )
{
    return magma_get_zhetrd_nb(
        *n );
}

#define magmaf_get_zhegst_nb FORTRAN_NAME( magmaf_get_zhegst_nb, MAGMAF_GET_ZHEGST_NB )
magma_int_t magmaf_get_zhegst_nb(
    magma_int_t *n )
{
    return magma_get_zhegst_nb(
        *n );
}

#define magmaf_get_zhegst_m_nb FORTRAN_NAME( magmaf_get_zhegst_m_nb, MAGMAF_GET_ZHEGST_M_NB )
magma_int_t magmaf_get_zhegst_m_nb(
    magma_int_t *n )
{
    return magma_get_zhegst_m_nb(
        *n );
}

#define magmaf_get_zgebrd_nb FORTRAN_NAME( magmaf_get_zgebrd_nb, MAGMAF_GET_ZGEBRD_NB )
magma_int_t magmaf_get_zgebrd_nb(
    magma_int_t *m, magma_int_t *n )
{
    return magma_get_zgebrd_nb(
        *m, *n );
}

#define magmaf_get_zgesvd_nb FORTRAN_NAME( magmaf_get_zgesvd_nb, MAGMAF_GET_ZGESVD_NB )
magma_int_t magmaf_get_zgesvd_nb(
    magma_int_t *m, magma_int_t *n )
{
    return magma_get_zgesvd_nb(
        *m, *n );
}

#define magmaf_get_zbulge_nb FORTRAN_NAME( magmaf_get_zbulge_nb, MAGMAF_GET_ZBULGE_NB )
magma_int_t magmaf_get_zbulge_nb(
    magma_int_t *n, magma_int_t *nbthreads )
{
    return magma_get_zbulge_nb(
        *n, *nbthreads );
}

#define magmaf_get_zbulge_vblksiz FORTRAN_NAME( magmaf_get_zbulge_vblksiz, MAGMAF_GET_ZBULGE_VBLKSIZ )
magma_int_t magmaf_get_zbulge_vblksiz(
    magma_int_t *n, magma_int_t *nb, magma_int_t *nbthreads )
{
    return magma_get_zbulge_vblksiz(
        *n, *nb, *nbthreads );
}

#define magmaf_get_zbulge_gcperf FORTRAN_NAME( magmaf_get_zbulge_gcperf, MAGMAF_GET_ZBULGE_GCPERF )
magma_int_t magmaf_get_zbulge_gcperf(
     )
{
    return magma_get_zbulge_gcperf(
         );
}

#define magmaf_zgbsv_native FORTRAN_NAME( magmaf_zgbsv_native, MAGMAF_ZGBSV_NATIVE )
void magmaf_zgbsv_native(
    magma_int_t *n, magma_int_t *kl, magma_int_t *ku, magma_int_t *nrhs,
    magmaDoubleComplex* dA, magma_int_t *ldda,
    magma_int_t* dipiv,
    magmaDoubleComplex* dB, magma_int_t *lddb,
    magma_int_t *info )
{
    magma_zgbsv_native(
        *n, *kl, *ku, *nrhs,
        dA, *ldda,
        dipiv,
        dB, *lddb,
        info );
}

#define magmaf_zgbtrf_native FORTRAN_NAME( magmaf_zgbtrf_native, MAGMAF_ZGBTRF_NATIVE )
void magmaf_zgbtrf_native(
    magma_int_t *m, magma_int_t *n, magma_int_t *kl, magma_int_t *ku,
    magmaDoubleComplex* dAB, magma_int_t *lddab,
    magma_int_t* dipiv,
    magma_int_t *info )
{
    magma_zgbtrf_native(
        *m, *n, *kl, *ku,
        dAB, *lddab,
        dipiv,
        info );
}

#define magmaf_zgebrd FORTRAN_NAME( magmaf_zgebrd, MAGMAF_ZGEBRD )
void magmaf_zgebrd(
    magma_int_t *m, magma_int_t *n,
    magmaDoubleComplex *A, magma_int_t *lda,
    double *d,
    double *e,
    magmaDoubleComplex *tauq,
    magmaDoubleComplex *taup,
    magmaDoubleComplex *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_zgebrd(
        *m, *n,
        A, *lda,
        d,
        e,
        tauq,
        taup,
        work, *lwork,
        info );
}

#define magmaf_zgeev FORTRAN_NAME( magmaf_zgeev, MAGMAF_ZGEEV )
void magmaf_zgeev(
    const char* jobvl, const char* jobvr, magma_int_t *n,
    magmaDoubleComplex *A, magma_int_t *lda,
    magmaDoubleComplex *w,
    magmaDoubleComplex *VL, magma_int_t *ldvl,
    magmaDoubleComplex *VR, magma_int_t *ldvr,
    magmaDoubleComplex *work, magma_int_t *lwork,
    double *rwork,
    magma_int_t *info )
{
    magma_zgeev(
        magma_vec_const(*jobvl), magma_vec_const(*jobvr), *n,
        A, *lda,
        w,
        VL, *ldvl,
        VR, *ldvr,
        work, *lwork,
        rwork,
        info );
}

#define magmaf_zgeev_m FORTRAN_NAME( magmaf_zgeev_m, MAGMAF_ZGEEV_M )
void magmaf_zgeev_m(
    const char* jobvl, const char* jobvr, magma_int_t *n,
    magmaDoubleComplex *A, magma_int_t *lda,
    magmaDoubleComplex *w,
    magmaDoubleComplex *VL, magma_int_t *ldvl,
    magmaDoubleComplex *VR, magma_int_t *ldvr,
    magmaDoubleComplex *work, magma_int_t *lwork,
    double *rwork,
    magma_int_t *info )
{
    magma_zgeev_m(
        magma_vec_const(*jobvl), magma_vec_const(*jobvr), *n,
        A, *lda,
        w,
        VL, *ldvl,
        VR, *ldvr,
        work, *lwork,
        rwork,
        info );
}

#define magmaf_zgegqr_gpu FORTRAN_NAME( magmaf_zgegqr_gpu, MAGMAF_ZGEGQR_GPU )
void magmaf_zgegqr_gpu(
    magma_int_t *ikind, magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dwork,
    magmaDoubleComplex *work,
    magma_int_t *info )
{
    magma_zgegqr_gpu(
        *ikind, *m, *n,
        magma_zdevptr(dA), *ldda,
        magma_zdevptr(dwork),
        work,
        info );
}

#define magmaf_zgehrd FORTRAN_NAME( magmaf_zgehrd, MAGMAF_ZGEHRD )
void magmaf_zgehrd(
    magma_int_t *n, magma_int_t *ilo, magma_int_t *ihi,
    magmaDoubleComplex *A, magma_int_t *lda,
    magmaDoubleComplex *tau,
    magmaDoubleComplex *work, magma_int_t *lwork,
    devptr_t *dT,
    magma_int_t *info )
{
    magma_zgehrd(
        *n, *ilo, *ihi,
        A, *lda,
        tau,
        work, *lwork,
        magma_zdevptr(dT),
        info );
}

#define magmaf_zgehrd_m FORTRAN_NAME( magmaf_zgehrd_m, MAGMAF_ZGEHRD_M )
void magmaf_zgehrd_m(
    magma_int_t *n, magma_int_t *ilo, magma_int_t *ihi,
    magmaDoubleComplex *A, magma_int_t *lda,
    magmaDoubleComplex *tau,
    magmaDoubleComplex *work, magma_int_t *lwork,
    magmaDoubleComplex *T,
    magma_int_t *info )
{
    magma_zgehrd_m(
        *n, *ilo, *ihi,
        A, *lda,
        tau,
        work, *lwork,
        T,
        info );
}

#define magmaf_zgehrd2 FORTRAN_NAME( magmaf_zgehrd2, MAGMAF_ZGEHRD2 )
void magmaf_zgehrd2(
    magma_int_t *n, magma_int_t *ilo, magma_int_t *ihi,
    magmaDoubleComplex *A, magma_int_t *lda,
    magmaDoubleComplex *tau,
    magmaDoubleComplex *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_zgehrd2(
        *n, *ilo, *ihi,
        A, *lda,
        tau,
        work, *lwork,
        info );
}

#define magmaf_zgelqf FORTRAN_NAME( magmaf_zgelqf, MAGMAF_ZGELQF )
void magmaf_zgelqf(
    magma_int_t *m, magma_int_t *n,
    magmaDoubleComplex *A, magma_int_t *lda,
    magmaDoubleComplex *tau,
    magmaDoubleComplex *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_zgelqf(
        *m, *n,
        A, *lda,
        tau,
        work, *lwork,
        info );
}

#define magmaf_zgelqf_gpu FORTRAN_NAME( magmaf_zgelqf_gpu, MAGMAF_ZGELQF_GPU )
void magmaf_zgelqf_gpu(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magmaDoubleComplex *tau,
    magmaDoubleComplex *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_zgelqf_gpu(
        *m, *n,
        magma_zdevptr(dA), *ldda,
        tau,
        work, *lwork,
        info );
}

#define magmaf_zgels FORTRAN_NAME( magmaf_zgels, MAGMAF_ZGELS )
void magmaf_zgels(
    const char* trans, magma_int_t *m, magma_int_t *n, magma_int_t *nrhs,
    devptr_t *A, magma_int_t *lda,
    devptr_t *B, magma_int_t *ldb,
    magmaDoubleComplex *hwork, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_zgels(
        magma_trans_const(*trans), *m, *n, *nrhs,
        magma_zdevptr(A), *lda,
        magma_zdevptr(B), *ldb,
        hwork, *lwork,
        info );
}

#define magmaf_zggrqf FORTRAN_NAME( magmaf_zggrqf, MAGMAF_ZGGRQF )
void magmaf_zggrqf(
    magma_int_t *m, magma_int_t *p, magma_int_t *n,
    magmaDoubleComplex *A, magma_int_t *lda,
    magmaDoubleComplex *taua,
    magmaDoubleComplex *B, magma_int_t *ldb,
    magmaDoubleComplex *taub,
    magmaDoubleComplex *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_zggrqf(
        *m, *p, *n,
        A, *lda,
        taua,
        B, *ldb,
        taub,
        work, *lwork,
        info );
}

#define magmaf_zgglse FORTRAN_NAME( magmaf_zgglse, MAGMAF_ZGGLSE )
void magmaf_zgglse(
    magma_int_t *m, magma_int_t *n, magma_int_t *p,
    magmaDoubleComplex *A, magma_int_t *lda,
    magmaDoubleComplex *B, magma_int_t *ldb,
    magmaDoubleComplex *c,
    magmaDoubleComplex *d,
    magmaDoubleComplex *x,
    magmaDoubleComplex *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_zgglse(
        *m, *n, *p,
        A, *lda,
        B, *ldb,
        c,
        d,
        x,
        work, *lwork,
        info );
}

#define magmaf_zgels_gpu FORTRAN_NAME( magmaf_zgels_gpu, MAGMAF_ZGELS_GPU )
void magmaf_zgels_gpu(
    const char* trans, magma_int_t *m, magma_int_t *n, magma_int_t *nrhs,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb,
    magmaDoubleComplex *hwork, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_zgels_gpu(
        magma_trans_const(*trans), *m, *n, *nrhs,
        magma_zdevptr(dA), *ldda,
        magma_zdevptr(dB), *lddb,
        hwork, *lwork,
        info );
}

#define magmaf_zgels3_gpu FORTRAN_NAME( magmaf_zgels3_gpu, MAGMAF_ZGELS3_GPU )
void magmaf_zgels3_gpu(
    const char* trans, magma_int_t *m, magma_int_t *n, magma_int_t *nrhs,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb,
    magmaDoubleComplex *hwork, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_zgels3_gpu(
        magma_trans_const(*trans), *m, *n, *nrhs,
        magma_zdevptr(dA), *ldda,
        magma_zdevptr(dB), *lddb,
        hwork, *lwork,
        info );
}

#define magmaf_zgeqlf FORTRAN_NAME( magmaf_zgeqlf, MAGMAF_ZGEQLF )
void magmaf_zgeqlf(
    magma_int_t *m, magma_int_t *n,
    magmaDoubleComplex *A, magma_int_t *lda,
    magmaDoubleComplex *tau,
    magmaDoubleComplex *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_zgeqlf(
        *m, *n,
        A, *lda,
        tau,
        work, *lwork,
        info );
}

#define magmaf_zgeqp3 FORTRAN_NAME( magmaf_zgeqp3, MAGMAF_ZGEQP3 )
void magmaf_zgeqp3(
    magma_int_t *m, magma_int_t *n,
    magmaDoubleComplex *A, magma_int_t *lda,
    magma_int_t *jpvt,
    magmaDoubleComplex *tau,
    magmaDoubleComplex *work, magma_int_t *lwork,
    double *rwork,
    magma_int_t *info )
{
    magma_zgeqp3(
        *m, *n,
        A, *lda,
        jpvt,
        tau,
        work, *lwork,
        rwork,
        info );
}

#define magmaf_zgeqp3_gpu FORTRAN_NAME( magmaf_zgeqp3_gpu, MAGMAF_ZGEQP3_GPU )
void magmaf_zgeqp3_gpu(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t *jpvt,
    magmaDoubleComplex *tau,
    devptr_t *dwork, magma_int_t *lwork,
    double *rwork,
    magma_int_t *info )
{
    magma_zgeqp3_gpu(
        *m, *n,
        magma_zdevptr(dA), *ldda,
        jpvt,
        tau,
        magma_zdevptr(dwork), *lwork,
        rwork,
        info );
}

#define magmaf_zgeqr2x_gpu FORTRAN_NAME( magmaf_zgeqr2x_gpu, MAGMAF_ZGEQR2X_GPU )
void magmaf_zgeqr2x_gpu(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dtau,
    devptr_t *dT,
    devptr_t *ddA,
    devptr_t *dwork,
    magma_int_t *info )
{
    magma_zgeqr2x_gpu(
        *m, *n,
        magma_zdevptr(dA), *ldda,
        magma_zdevptr(dtau),
        magma_zdevptr(dT),
        magma_zdevptr(ddA),
        magma_ddevptr(dwork),
        info );
}

#define magmaf_zgeqr2x2_gpu FORTRAN_NAME( magmaf_zgeqr2x2_gpu, MAGMAF_ZGEQR2X2_GPU )
void magmaf_zgeqr2x2_gpu(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dtau,
    devptr_t *dT,
    devptr_t *ddA,
    devptr_t *dwork,
    magma_int_t *info )
{
    magma_zgeqr2x2_gpu(
        *m, *n,
        magma_zdevptr(dA), *ldda,
        magma_zdevptr(dtau),
        magma_zdevptr(dT),
        magma_zdevptr(ddA),
        magma_ddevptr(dwork),
        info );
}

#define magmaf_zgeqr2x3_gpu FORTRAN_NAME( magmaf_zgeqr2x3_gpu, MAGMAF_ZGEQR2X3_GPU )
void magmaf_zgeqr2x3_gpu(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dtau,
    devptr_t *dT,
    devptr_t *ddA,
    devptr_t *dwork,
    magma_int_t *info )
{
    magma_zgeqr2x3_gpu(
        *m, *n,
        magma_zdevptr(dA), *ldda,
        magma_zdevptr(dtau),
        magma_zdevptr(dT),
        magma_zdevptr(ddA),
        magma_ddevptr(dwork),
        info );
}

#define magmaf_zgeqr2x4_gpu FORTRAN_NAME( magmaf_zgeqr2x4_gpu, MAGMAF_ZGEQR2X4_GPU )
void magmaf_zgeqr2x4_gpu(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dtau,
    devptr_t *dT,
    devptr_t *ddA,
    devptr_t *dwork, magma_queue_t *queue,
    magma_int_t *info )
{
    magma_zgeqr2x4_gpu(
        *m, *n,
        magma_zdevptr(dA), *ldda,
        magma_zdevptr(dtau),
        magma_zdevptr(dT),
        magma_zdevptr(ddA),
        magma_ddevptr(dwork), *queue,
        info );
}

#define magmaf_zgeqrf FORTRAN_NAME( magmaf_zgeqrf, MAGMAF_ZGEQRF )
void magmaf_zgeqrf(
    magma_int_t *m, magma_int_t *n,
    magmaDoubleComplex *A, magma_int_t *lda,
    magmaDoubleComplex *tau,
    magmaDoubleComplex *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_zgeqrf(
        *m, *n,
        A, *lda,
        tau,
        work, *lwork,
        info );
}

#define magmaf_zgeqrf_gpu FORTRAN_NAME( magmaf_zgeqrf_gpu, MAGMAF_ZGEQRF_GPU )
void magmaf_zgeqrf_gpu(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magmaDoubleComplex *tau,
    devptr_t *dT,
    magma_int_t *info )
{
    magma_zgeqrf_gpu(
        *m, *n,
        magma_zdevptr(dA), *ldda,
        tau,
        magma_zdevptr(dT),
        info );
}

#define magmaf_zgeqrf_m FORTRAN_NAME( magmaf_zgeqrf_m, MAGMAF_ZGEQRF_M )
void magmaf_zgeqrf_m(
    magma_int_t *ngpu, magma_int_t *m, magma_int_t *n,
    magmaDoubleComplex *A, magma_int_t *lda,
    magmaDoubleComplex *tau,
    magmaDoubleComplex *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_zgeqrf_m(
        *ngpu, *m, *n,
        A, *lda,
        tau,
        work, *lwork,
        info );
}

#define magmaf_zgeqrf_ooc FORTRAN_NAME( magmaf_zgeqrf_ooc, MAGMAF_ZGEQRF_OOC )
void magmaf_zgeqrf_ooc(
    magma_int_t *m, magma_int_t *n,
    magmaDoubleComplex *A, magma_int_t *lda,
    magmaDoubleComplex *tau,
    magmaDoubleComplex *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_zgeqrf_ooc(
        *m, *n,
        A, *lda,
        tau,
        work, *lwork,
        info );
}

#define magmaf_zgeqrf2_gpu FORTRAN_NAME( magmaf_zgeqrf2_gpu, MAGMAF_ZGEQRF2_GPU )
void magmaf_zgeqrf2_gpu(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magmaDoubleComplex *tau,
    magma_int_t *info )
{
    magma_zgeqrf2_gpu(
        *m, *n,
        magma_zdevptr(dA), *ldda,
        tau,
        info );
}

#define magmaf_zgeqrf3_gpu FORTRAN_NAME( magmaf_zgeqrf3_gpu, MAGMAF_ZGEQRF3_GPU )
void magmaf_zgeqrf3_gpu(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magmaDoubleComplex *tau,
    devptr_t *dT,
    magma_int_t *info )
{
    magma_zgeqrf3_gpu(
        *m, *n,
        magma_zdevptr(dA), *ldda,
        tau,
        magma_zdevptr(dT),
        info );
}

#define magmaf_zgeqrs_gpu FORTRAN_NAME( magmaf_zgeqrs_gpu, MAGMAF_ZGEQRS_GPU )
void magmaf_zgeqrs_gpu(
    magma_int_t *m, magma_int_t *n, magma_int_t *nrhs,
    devptr_t *dA, magma_int_t *ldda,
    magmaDoubleComplex *tau,
    devptr_t *dT,
    devptr_t *dB, magma_int_t *lddb,
    magmaDoubleComplex *hwork, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_zgeqrs_gpu(
        *m, *n, *nrhs,
        magma_zdevptr(dA), *ldda,
        tau,
        magma_zdevptr(dT),
        magma_zdevptr(dB), *lddb,
        hwork, *lwork,
        info );
}

#define magmaf_zgeqrs3_gpu FORTRAN_NAME( magmaf_zgeqrs3_gpu, MAGMAF_ZGEQRS3_GPU )
void magmaf_zgeqrs3_gpu(
    magma_int_t *m, magma_int_t *n, magma_int_t *nrhs,
    devptr_t *dA, magma_int_t *ldda,
    magmaDoubleComplex *tau,
    devptr_t *dT,
    devptr_t *dB, magma_int_t *lddb,
    magmaDoubleComplex *hwork, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_zgeqrs3_gpu(
        *m, *n, *nrhs,
        magma_zdevptr(dA), *ldda,
        tau,
        magma_zdevptr(dT),
        magma_zdevptr(dB), *lddb,
        hwork, *lwork,
        info );
}

#define magmaf_zgerbt_gpu FORTRAN_NAME( magmaf_zgerbt_gpu, MAGMAF_ZGERBT_GPU )
void magmaf_zgerbt_gpu(
    const char* gen, magma_int_t *n, magma_int_t *nrhs,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb,
    magmaDoubleComplex *U,
    magmaDoubleComplex *V,
    magma_int_t *info )
{
    magma_zgerbt_gpu(
        magma_bool_const(*gen), *n, *nrhs,
        magma_zdevptr(dA), *ldda,
        magma_zdevptr(dB), *lddb,
        U,
        V,
        info );
}

#define magmaf_zgerfs_nopiv_gpu FORTRAN_NAME( magmaf_zgerfs_nopiv_gpu, MAGMAF_ZGERFS_NOPIV_GPU )
void magmaf_zgerfs_nopiv_gpu(
    const char* trans, magma_int_t *n, magma_int_t *nrhs,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb,
    devptr_t *dX, magma_int_t *lddx,
    devptr_t *dworkd,
    devptr_t *dAF,
    magma_int_t *iter,
    magma_int_t *info )
{
    magma_zgerfs_nopiv_gpu(
        magma_trans_const(*trans), *n, *nrhs,
        magma_zdevptr(dA), *ldda,
        magma_zdevptr(dB), *lddb,
        magma_zdevptr(dX), *lddx,
        magma_zdevptr(dworkd),
        magma_zdevptr(dAF),
        iter,
        info );
}

#define magmaf_zgesdd FORTRAN_NAME( magmaf_zgesdd, MAGMAF_ZGESDD )
void magmaf_zgesdd(
    const char* jobz, magma_int_t *m, magma_int_t *n,
    magmaDoubleComplex *A, magma_int_t *lda,
    double *s,
    magmaDoubleComplex *U, magma_int_t *ldu,
    magmaDoubleComplex *VT, magma_int_t *ldvt,
    magmaDoubleComplex *work, magma_int_t *lwork,
    double *rwork,
    magma_int_t *iwork,
    magma_int_t *info )
{
    magma_zgesdd(
        magma_vec_const(*jobz), *m, *n,
        A, *lda,
        s,
        U, *ldu,
        VT, *ldvt,
        work, *lwork,
        rwork,
        iwork,
        info );
}

#define magmaf_zgesv FORTRAN_NAME( magmaf_zgesv, MAGMAF_ZGESV )
void magmaf_zgesv(
    magma_int_t *n, magma_int_t *nrhs,
    magmaDoubleComplex *A, magma_int_t *lda,
    magma_int_t *ipiv,
    magmaDoubleComplex *B, magma_int_t *ldb,
    magma_int_t *info )
{
    magma_zgesv(
        *n, *nrhs,
        A, *lda,
        ipiv,
        B, *ldb,
        info );
}

#define magmaf_zgesv_gpu FORTRAN_NAME( magmaf_zgesv_gpu, MAGMAF_ZGESV_GPU )
void magmaf_zgesv_gpu(
    magma_int_t *n, magma_int_t *nrhs,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t *ipiv,
    devptr_t *dB, magma_int_t *lddb,
    magma_int_t *info )
{
    magma_zgesv_gpu(
        *n, *nrhs,
        magma_zdevptr(dA), *ldda,
        ipiv,
        magma_zdevptr(dB), *lddb,
        info );
}

#define magmaf_zgesv_nopiv_gpu FORTRAN_NAME( magmaf_zgesv_nopiv_gpu, MAGMAF_ZGESV_NOPIV_GPU )
void magmaf_zgesv_nopiv_gpu(
    magma_int_t *n, magma_int_t *nrhs,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb,
    magma_int_t *info )
{
    magma_zgesv_nopiv_gpu(
        *n, *nrhs,
        magma_zdevptr(dA), *ldda,
        magma_zdevptr(dB), *lddb,
        info );
}

#define magmaf_zgesv_rbt FORTRAN_NAME( magmaf_zgesv_rbt, MAGMAF_ZGESV_RBT )
void magmaf_zgesv_rbt(
    const char* ref, magma_int_t *n, magma_int_t *nrhs,
    magmaDoubleComplex *A, magma_int_t *lda,
    magmaDoubleComplex *B, magma_int_t *ldb,
    magma_int_t *info )
{
    magma_zgesv_rbt(
        magma_bool_const(*ref), *n, *nrhs,
        A, *lda,
        B, *ldb,
        info );
}

#define magmaf_zgesvd FORTRAN_NAME( magmaf_zgesvd, MAGMAF_ZGESVD )
void magmaf_zgesvd(
    const char* jobu, const char* jobvt, magma_int_t *m, magma_int_t *n,
    magmaDoubleComplex *A, magma_int_t *lda,
    double *s,
    magmaDoubleComplex *U, magma_int_t *ldu,
    magmaDoubleComplex *VT, magma_int_t *ldvt,
    magmaDoubleComplex *work, magma_int_t *lwork,
    double *rwork,
    magma_int_t *info )
{
    magma_zgesvd(
        magma_vec_const(*jobu), magma_vec_const(*jobvt), *m, *n,
        A, *lda,
        s,
        U, *ldu,
        VT, *ldvt,
        work, *lwork,
        rwork,
        info );
}

#define magmaf_zgesvj_batched_strided FORTRAN_NAME( magmaf_zgesvj_batched_strided, MAGMAF_ZGESVJ_BATCHED_STRIDED )
void magmaf_zgesvj_batched_strided(
    const char* jobu, const char* jobv, magma_int_t *morg, magma_int_t *norg,
    devptr_t *dA, magma_int_t *ldda, magma_int_t *strideA,
    devptr_t *dS, magma_int_t *strideS,
    devptr_t *dU, magma_int_t *lddu, magma_int_t *strideU,
    devptr_t *dV, magma_int_t *lddv, magma_int_t *strideV,
    devptr_t *dinfo_array, magma_int_t *batchCount, magma_queue_t *queue )
{
    magma_zgesvj_batched_strided(
        magma_vec_const(*jobu), magma_vec_const(*jobv), *morg, *norg,
        magma_zdevptr(dA), *ldda, *strideA,
        magma_ddevptr(dS), *strideS,
        magma_zdevptr(dU), *lddu, *strideU,
        magma_zdevptr(dV), *lddv, *strideV,
        magma_idevptr(dinfo_array), *batchCount, *queue );
}

#define magmaf_zgetf2_gpu FORTRAN_NAME( magmaf_zgetf2_gpu, MAGMAF_ZGETF2_GPU )
void magmaf_zgetf2_gpu(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t *ipiv, magma_queue_t *queue,
    magma_int_t *info )
{
    magma_zgetf2_gpu(
        *m, *n,
        magma_zdevptr(dA), *ldda,
        ipiv, *queue,
        info );
}

#define magmaf_zgetf2_native_fused FORTRAN_NAME( magmaf_zgetf2_native_fused, MAGMAF_ZGETF2_NATIVE_FUSED )
void magmaf_zgetf2_native_fused(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t *ipiv, magma_int_t *gbstep,
    magma_int_t *flags,
    magma_int_t *info, magma_queue_t *queue )
{
    magma_zgetf2_native_fused(
        *m, *n,
        magma_zdevptr(dA), *ldda,
        ipiv, *gbstep,
        flags,
        info, *queue );
}

#define magmaf_zgetf2_native FORTRAN_NAME( magmaf_zgetf2_native, MAGMAF_ZGETF2_NATIVE )
magma_int_t magmaf_zgetf2_native(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t *dipiv,
    magma_int_t* dipivinfo,
    magma_int_t *dinfo, magma_int_t *gbstep,
    magma_event_t events[2], magma_queue_t *queue, magma_queue_t *update_queue )
{
    return magma_zgetf2_native(
        *m, *n,
        magma_zdevptr(dA), *ldda,
        dipiv,
        dipivinfo,
        dinfo, *gbstep,
        events, *queue, *update_queue );
}

#define magmaf_zgetf2_nopiv FORTRAN_NAME( magmaf_zgetf2_nopiv, MAGMAF_ZGETF2_NOPIV )
void magmaf_zgetf2_nopiv(
    magma_int_t *m, magma_int_t *n,
    magmaDoubleComplex *A, magma_int_t *lda,
    magma_int_t *info )
{
    magma_zgetf2_nopiv(
        *m, *n,
        A, *lda,
        info );
}

#define magmaf_zgetrf_recpanel_native FORTRAN_NAME( magmaf_zgetrf_recpanel_native, MAGMAF_ZGETRF_RECPANEL_NATIVE )
magma_int_t magmaf_zgetrf_recpanel_native(
    magma_int_t *m, magma_int_t *n, magma_int_t *recnb,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t* dipiv,
    magma_int_t* dipivinfo,
    magma_int_t *dinfo, magma_int_t *gbstep,
    magma_event_t events[2], magma_queue_t *queue, magma_queue_t *update_queue )
{
    return magma_zgetrf_recpanel_native(
        *m, *n, *recnb,
        magma_zdevptr(dA), *ldda,
        dipiv,
        dipivinfo,
        dinfo, *gbstep,
        events, *queue, *update_queue );
}

#define magmaf_zgetrf FORTRAN_NAME( magmaf_zgetrf, MAGMAF_ZGETRF )
void magmaf_zgetrf(
    magma_int_t *m, magma_int_t *n,
    magmaDoubleComplex *A, magma_int_t *lda,
    magma_int_t *ipiv,
    magma_int_t *info )
{
    magma_zgetrf(
        *m, *n,
        A, *lda,
        ipiv,
        info );
}

#define magmaf_zgetrf_gpu FORTRAN_NAME( magmaf_zgetrf_gpu, MAGMAF_ZGETRF_GPU )
void magmaf_zgetrf_gpu(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t *ipiv,
    magma_int_t *info )
{
    magma_zgetrf_gpu(
        *m, *n,
        magma_zdevptr(dA), *ldda,
        ipiv,
        info );
}

#define magmaf_zgetrf_native FORTRAN_NAME( magmaf_zgetrf_native, MAGMAF_ZGETRF_NATIVE )
void magmaf_zgetrf_native(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t *ipiv,
    magma_int_t *info )
{
    magma_zgetrf_native(
        *m, *n,
        magma_zdevptr(dA), *ldda,
        ipiv,
        info );
}

#define magmaf_zgetrf_m FORTRAN_NAME( magmaf_zgetrf_m, MAGMAF_ZGETRF_M )
void magmaf_zgetrf_m(
    magma_int_t *ngpu, magma_int_t *m, magma_int_t *n,
    magmaDoubleComplex *A, magma_int_t *lda,
    magma_int_t *ipiv,
    magma_int_t *info )
{
    magma_zgetrf_m(
        *ngpu, *m, *n,
        A, *lda,
        ipiv,
        info );
}

#define magmaf_zgetrf_nopiv FORTRAN_NAME( magmaf_zgetrf_nopiv, MAGMAF_ZGETRF_NOPIV )
void magmaf_zgetrf_nopiv(
    magma_int_t *m, magma_int_t *n,
    magmaDoubleComplex *A, magma_int_t *lda,
    magma_int_t *info )
{
    magma_zgetrf_nopiv(
        *m, *n,
        A, *lda,
        info );
}

#define magmaf_zgetrf_nopiv_gpu FORTRAN_NAME( magmaf_zgetrf_nopiv_gpu, MAGMAF_ZGETRF_NOPIV_GPU )
void magmaf_zgetrf_nopiv_gpu(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t *info )
{
    magma_zgetrf_nopiv_gpu(
        *m, *n,
        magma_zdevptr(dA), *ldda,
        info );
}

#define magmaf_zgetri_gpu FORTRAN_NAME( magmaf_zgetri_gpu, MAGMAF_ZGETRI_GPU )
void magmaf_zgetri_gpu(
    magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t *ipiv,
    devptr_t *dwork, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_zgetri_gpu(
        *n,
        magma_zdevptr(dA), *ldda,
        ipiv,
        magma_zdevptr(dwork), *lwork,
        info );
}

#define magmaf_zgetrs_gpu FORTRAN_NAME( magmaf_zgetrs_gpu, MAGMAF_ZGETRS_GPU )
void magmaf_zgetrs_gpu(
    const char* trans, magma_int_t *n, magma_int_t *nrhs,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t *ipiv,
    devptr_t *dB, magma_int_t *lddb,
    magma_int_t *info )
{
    magma_zgetrs_gpu(
        magma_trans_const(*trans), *n, *nrhs,
        magma_zdevptr(dA), *ldda,
        ipiv,
        magma_zdevptr(dB), *lddb,
        info );
}

#define magmaf_zgetrs_nopiv_gpu FORTRAN_NAME( magmaf_zgetrs_nopiv_gpu, MAGMAF_ZGETRS_NOPIV_GPU )
void magmaf_zgetrs_nopiv_gpu(
    const char* trans, magma_int_t *n, magma_int_t *nrhs,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb,
    magma_int_t *info )
{
    magma_zgetrs_nopiv_gpu(
        magma_trans_const(*trans), *n, *nrhs,
        magma_zdevptr(dA), *ldda,
        magma_zdevptr(dB), *lddb,
        info );
}

#define magmaf_zheevd FORTRAN_NAME( magmaf_zheevd, MAGMAF_ZHEEVD )
void magmaf_zheevd(
    const char* jobz, const char* uplo, magma_int_t *n,
    magmaDoubleComplex *A, magma_int_t *lda,
    double *w,
    magmaDoubleComplex *work, magma_int_t *lwork,
    double *rwork, magma_int_t *lrwork,
    magma_int_t *iwork, magma_int_t *liwork,
    magma_int_t *info )
{
    magma_zheevd(
        magma_vec_const(*jobz), magma_uplo_const(*uplo), *n,
        A, *lda,
        w,
        work, *lwork,
        rwork, *lrwork,
        iwork, *liwork,
        info );
}

#define magmaf_zheevd_gpu FORTRAN_NAME( magmaf_zheevd_gpu, MAGMAF_ZHEEVD_GPU )
void magmaf_zheevd_gpu(
    const char* jobz, const char* uplo, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    double *w,
    magmaDoubleComplex *wA, magma_int_t *ldwa,
    magmaDoubleComplex *work, magma_int_t *lwork,
    double *rwork, magma_int_t *lrwork,
    magma_int_t *iwork, magma_int_t *liwork,
    magma_int_t *info )
{
    magma_zheevd_gpu(
        magma_vec_const(*jobz), magma_uplo_const(*uplo), *n,
        magma_zdevptr(dA), *ldda,
        w,
        wA, *ldwa,
        work, *lwork,
        rwork, *lrwork,
        iwork, *liwork,
        info );
}

#define magmaf_zheevd_m FORTRAN_NAME( magmaf_zheevd_m, MAGMAF_ZHEEVD_M )
void magmaf_zheevd_m(
    magma_int_t *ngpu, const char* jobz, const char* uplo, magma_int_t *n,
    magmaDoubleComplex *A, magma_int_t *lda,
    double *w,
    magmaDoubleComplex *work, magma_int_t *lwork,
    double *rwork, magma_int_t *lrwork,
    magma_int_t *iwork, magma_int_t *liwork,
    magma_int_t *info )
{
    magma_zheevd_m(
        *ngpu, magma_vec_const(*jobz), magma_uplo_const(*uplo), *n,
        A, *lda,
        w,
        work, *lwork,
        rwork, *lrwork,
        iwork, *liwork,
        info );
}

#define magmaf_zheevdx FORTRAN_NAME( magmaf_zheevdx, MAGMAF_ZHEEVDX )
void magmaf_zheevdx(
    const char* jobz, const char* range, const char* uplo, magma_int_t *n,
    magmaDoubleComplex *A, magma_int_t *lda, double *vl, double *vu, magma_int_t *il, magma_int_t *iu,
    magma_int_t *mout,
    double *w,
    magmaDoubleComplex *work, magma_int_t *lwork,
    double *rwork, magma_int_t *lrwork,
    magma_int_t *iwork, magma_int_t *liwork,
    magma_int_t *info )
{
    magma_zheevdx(
        magma_vec_const(*jobz), magma_range_const(*range), magma_uplo_const(*uplo), *n,
        A, *lda, *vl, *vu, *il, *iu,
        mout,
        w,
        work, *lwork,
        rwork, *lrwork,
        iwork, *liwork,
        info );
}

#define magmaf_zheevdx_gpu FORTRAN_NAME( magmaf_zheevdx_gpu, MAGMAF_ZHEEVDX_GPU )
void magmaf_zheevdx_gpu(
    const char* jobz, const char* range, const char* uplo, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda, double *vl, double *vu, magma_int_t *il, magma_int_t *iu,
    magma_int_t *mout,
    double *w,
    magmaDoubleComplex *wA, magma_int_t *ldwa,
    magmaDoubleComplex *work, magma_int_t *lwork,
    double *rwork, magma_int_t *lrwork,
    magma_int_t *iwork, magma_int_t *liwork,
    magma_int_t *info )
{
    magma_zheevdx_gpu(
        magma_vec_const(*jobz), magma_range_const(*range), magma_uplo_const(*uplo), *n,
        magma_zdevptr(dA), *ldda, *vl, *vu, *il, *iu,
        mout,
        w,
        wA, *ldwa,
        work, *lwork,
        rwork, *lrwork,
        iwork, *liwork,
        info );
}

#define magmaf_zheevdx_m FORTRAN_NAME( magmaf_zheevdx_m, MAGMAF_ZHEEVDX_M )
void magmaf_zheevdx_m(
    magma_int_t *ngpu, const char* jobz, const char* range, const char* uplo, magma_int_t *n,
    magmaDoubleComplex *A, magma_int_t *lda, double *vl, double *vu, magma_int_t *il, magma_int_t *iu,
    magma_int_t *mout,
    double *w,
    magmaDoubleComplex *work, magma_int_t *lwork,
    double *rwork, magma_int_t *lrwork,
    magma_int_t *iwork, magma_int_t *liwork,
    magma_int_t *info )
{
    magma_zheevdx_m(
        *ngpu, magma_vec_const(*jobz), magma_range_const(*range), magma_uplo_const(*uplo), *n,
        A, *lda, *vl, *vu, *il, *iu,
        mout,
        w,
        work, *lwork,
        rwork, *lrwork,
        iwork, *liwork,
        info );
}

#define magmaf_zheevdx_2stage FORTRAN_NAME( magmaf_zheevdx_2stage, MAGMAF_ZHEEVDX_2STAGE )
void magmaf_zheevdx_2stage(
    const char* jobz, const char* range, const char* uplo, magma_int_t *n,
    magmaDoubleComplex *A, magma_int_t *lda, double *vl, double *vu, magma_int_t *il, magma_int_t *iu,
    magma_int_t *mout,
    double *w,
    magmaDoubleComplex *work, magma_int_t *lwork,
    double *rwork, magma_int_t *lrwork,
    magma_int_t *iwork, magma_int_t *liwork,
    magma_int_t *info )
{
    magma_zheevdx_2stage(
        magma_vec_const(*jobz), magma_range_const(*range), magma_uplo_const(*uplo), *n,
        A, *lda, *vl, *vu, *il, *iu,
        mout,
        w,
        work, *lwork,
        rwork, *lrwork,
        iwork, *liwork,
        info );
}

#define magmaf_zheevdx_2stage_m FORTRAN_NAME( magmaf_zheevdx_2stage_m, MAGMAF_ZHEEVDX_2STAGE_M )
void magmaf_zheevdx_2stage_m(
    magma_int_t *ngpu, const char* jobz, const char* range, const char* uplo, magma_int_t *n,
    magmaDoubleComplex *A, magma_int_t *lda, double *vl, double *vu, magma_int_t *il, magma_int_t *iu,
    magma_int_t *mout,
    double *w,
    magmaDoubleComplex *work, magma_int_t *lwork,
    double *rwork, magma_int_t *lrwork,
    magma_int_t *iwork, magma_int_t *liwork,
    magma_int_t *info )
{
    magma_zheevdx_2stage_m(
        *ngpu, magma_vec_const(*jobz), magma_range_const(*range), magma_uplo_const(*uplo), *n,
        A, *lda, *vl, *vu, *il, *iu,
        mout,
        w,
        work, *lwork,
        rwork, *lrwork,
        iwork, *liwork,
        info );
}

#define magmaf_zheevr FORTRAN_NAME( magmaf_zheevr, MAGMAF_ZHEEVR )
void magmaf_zheevr(
    const char* jobz, const char* range, const char* uplo, magma_int_t *n,
    magmaDoubleComplex *A, magma_int_t *lda, double *vl, double *vu, magma_int_t *il, magma_int_t *iu, double *abstol,
    magma_int_t *mout,
    double *w,
    magmaDoubleComplex *Z, magma_int_t *ldz,
    magma_int_t *isuppz,
    magmaDoubleComplex *work, magma_int_t *lwork,
    double *rwork, magma_int_t *lrwork,
    magma_int_t *iwork, magma_int_t *liwork,
    magma_int_t *info )
{
    magma_zheevr(
        magma_vec_const(*jobz), magma_range_const(*range), magma_uplo_const(*uplo), *n,
        A, *lda, *vl, *vu, *il, *iu, *abstol,
        mout,
        w,
        Z, *ldz,
        isuppz,
        work, *lwork,
        rwork, *lrwork,
        iwork, *liwork,
        info );
}

#define magmaf_zheevr_gpu FORTRAN_NAME( magmaf_zheevr_gpu, MAGMAF_ZHEEVR_GPU )
void magmaf_zheevr_gpu(
    const char* jobz, const char* range, const char* uplo, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda, double *vl, double *vu, magma_int_t *il, magma_int_t *iu, double *abstol,
    magma_int_t *mout,
    double *w,
    devptr_t *dZ, magma_int_t *lddz,
    magma_int_t *isuppz,
    magmaDoubleComplex *wA, magma_int_t *ldwa,
    magmaDoubleComplex *wZ, magma_int_t *ldwz,
    magmaDoubleComplex *work, magma_int_t *lwork,
    double *rwork, magma_int_t *lrwork,
    magma_int_t *iwork, magma_int_t *liwork,
    magma_int_t *info )
{
    magma_zheevr_gpu(
        magma_vec_const(*jobz), magma_range_const(*range), magma_uplo_const(*uplo), *n,
        magma_zdevptr(dA), *ldda, *vl, *vu, *il, *iu, *abstol,
        mout,
        w,
        magma_zdevptr(dZ), *lddz,
        isuppz,
        wA, *ldwa,
        wZ, *ldwz,
        work, *lwork,
        rwork, *lrwork,
        iwork, *liwork,
        info );
}

#define magmaf_zheevx FORTRAN_NAME( magmaf_zheevx, MAGMAF_ZHEEVX )
void magmaf_zheevx(
    const char* jobz, const char* range, const char* uplo, magma_int_t *n,
    magmaDoubleComplex *A, magma_int_t *lda, double *vl, double *vu, magma_int_t *il, magma_int_t *iu, double *abstol,
    magma_int_t *mout,
    double *w,
    magmaDoubleComplex *Z, magma_int_t *ldz,
    magmaDoubleComplex *work, magma_int_t *lwork,
    double *rwork,
    magma_int_t *iwork,
    magma_int_t *ifail,
    magma_int_t *info )
{
    magma_zheevx(
        magma_vec_const(*jobz), magma_range_const(*range), magma_uplo_const(*uplo), *n,
        A, *lda, *vl, *vu, *il, *iu, *abstol,
        mout,
        w,
        Z, *ldz,
        work, *lwork,
        rwork,
        iwork,
        ifail,
        info );
}

#define magmaf_zheevx_gpu FORTRAN_NAME( magmaf_zheevx_gpu, MAGMAF_ZHEEVX_GPU )
void magmaf_zheevx_gpu(
    const char* jobz, const char* range, const char* uplo, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda, double *vl, double *vu, magma_int_t *il, magma_int_t *iu, double *abstol,
    magma_int_t *mout,
    double *w,
    devptr_t *dZ, magma_int_t *lddz,
    magmaDoubleComplex *wA, magma_int_t *ldwa,
    magmaDoubleComplex *wZ, magma_int_t *ldwz,
    magmaDoubleComplex *work, magma_int_t *lwork,
    double *rwork,
    magma_int_t *iwork,
    magma_int_t *ifail,
    magma_int_t *info )
{
    magma_zheevx_gpu(
        magma_vec_const(*jobz), magma_range_const(*range), magma_uplo_const(*uplo), *n,
        magma_zdevptr(dA), *ldda, *vl, *vu, *il, *iu, *abstol,
        mout,
        w,
        magma_zdevptr(dZ), *lddz,
        wA, *ldwa,
        wZ, *ldwz,
        work, *lwork,
        rwork,
        iwork,
        ifail,
        info );
}

#define magmaf_zhegst FORTRAN_NAME( magmaf_zhegst, MAGMAF_ZHEGST )
void magmaf_zhegst(
    magma_int_t *itype, const char* uplo, magma_int_t *n,
    magmaDoubleComplex *A, magma_int_t *lda,
    magmaDoubleComplex *B, magma_int_t *ldb,
    magma_int_t *info )
{
    magma_zhegst(
        *itype, magma_uplo_const(*uplo), *n,
        A, *lda,
        B, *ldb,
        info );
}

#define magmaf_zhegst_gpu FORTRAN_NAME( magmaf_zhegst_gpu, MAGMAF_ZHEGST_GPU )
void magmaf_zhegst_gpu(
    magma_int_t *itype, const char* uplo, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb,
    magma_int_t *info )
{
    magma_zhegst_gpu(
        *itype, magma_uplo_const(*uplo), *n,
        magma_zdevptr(dA), *ldda,
        magma_zdevptr(dB), *lddb,
        info );
}

#define magmaf_zhegst_m FORTRAN_NAME( magmaf_zhegst_m, MAGMAF_ZHEGST_M )
void magmaf_zhegst_m(
    magma_int_t *ngpu, magma_int_t *itype, const char* uplo, magma_int_t *n,
    magmaDoubleComplex *A, magma_int_t *lda,
    magmaDoubleComplex *B, magma_int_t *ldb,
    magma_int_t *info )
{
    magma_zhegst_m(
        *ngpu, *itype, magma_uplo_const(*uplo), *n,
        A, *lda,
        B, *ldb,
        info );
}

#define magmaf_zhegvd FORTRAN_NAME( magmaf_zhegvd, MAGMAF_ZHEGVD )
void magmaf_zhegvd(
    magma_int_t *itype, const char* jobz, const char* uplo, magma_int_t *n,
    magmaDoubleComplex *A, magma_int_t *lda,
    magmaDoubleComplex *B, magma_int_t *ldb,
    double *w,
    magmaDoubleComplex *work, magma_int_t *lwork,
    double *rwork, magma_int_t *lrwork,
    magma_int_t *iwork, magma_int_t *liwork,
    magma_int_t *info )
{
    magma_zhegvd(
        *itype, magma_vec_const(*jobz), magma_uplo_const(*uplo), *n,
        A, *lda,
        B, *ldb,
        w,
        work, *lwork,
        rwork, *lrwork,
        iwork, *liwork,
        info );
}

#define magmaf_zhegvd_m FORTRAN_NAME( magmaf_zhegvd_m, MAGMAF_ZHEGVD_M )
void magmaf_zhegvd_m(
    magma_int_t *ngpu, magma_int_t *itype, const char* jobz, const char* uplo, magma_int_t *n,
    magmaDoubleComplex *A, magma_int_t *lda,
    magmaDoubleComplex *B, magma_int_t *ldb,
    double *w,
    magmaDoubleComplex *work, magma_int_t *lwork,
    double *rwork, magma_int_t *lrwork,
    magma_int_t *iwork, magma_int_t *liwork,
    magma_int_t *info )
{
    magma_zhegvd_m(
        *ngpu, *itype, magma_vec_const(*jobz), magma_uplo_const(*uplo), *n,
        A, *lda,
        B, *ldb,
        w,
        work, *lwork,
        rwork, *lrwork,
        iwork, *liwork,
        info );
}

#define magmaf_zhegvdx FORTRAN_NAME( magmaf_zhegvdx, MAGMAF_ZHEGVDX )
void magmaf_zhegvdx(
    magma_int_t *itype, const char* jobz, const char* range, const char* uplo, magma_int_t *n,
    magmaDoubleComplex *A, magma_int_t *lda,
    magmaDoubleComplex *B, magma_int_t *ldb, double *vl, double *vu, magma_int_t *il, magma_int_t *iu,
    magma_int_t *mout,
    double *w,
    magmaDoubleComplex *work, magma_int_t *lwork,
    double *rwork, magma_int_t *lrwork,
    magma_int_t *iwork, magma_int_t *liwork,
    magma_int_t *info )
{
    magma_zhegvdx(
        *itype, magma_vec_const(*jobz), magma_range_const(*range), magma_uplo_const(*uplo), *n,
        A, *lda,
        B, *ldb, *vl, *vu, *il, *iu,
        mout,
        w,
        work, *lwork,
        rwork, *lrwork,
        iwork, *liwork,
        info );
}

#define magmaf_zhegvdx_m FORTRAN_NAME( magmaf_zhegvdx_m, MAGMAF_ZHEGVDX_M )
void magmaf_zhegvdx_m(
    magma_int_t *ngpu, magma_int_t *itype, const char* jobz, const char* range, const char* uplo, magma_int_t *n,
    magmaDoubleComplex *A, magma_int_t *lda,
    magmaDoubleComplex *B, magma_int_t *ldb, double *vl, double *vu, magma_int_t *il, magma_int_t *iu,
    magma_int_t *mout,
    double *w,
    magmaDoubleComplex *work, magma_int_t *lwork,
    double *rwork, magma_int_t *lrwork,
    magma_int_t *iwork, magma_int_t *liwork,
    magma_int_t *info )
{
    magma_zhegvdx_m(
        *ngpu, *itype, magma_vec_const(*jobz), magma_range_const(*range), magma_uplo_const(*uplo), *n,
        A, *lda,
        B, *ldb, *vl, *vu, *il, *iu,
        mout,
        w,
        work, *lwork,
        rwork, *lrwork,
        iwork, *liwork,
        info );
}

#define magmaf_zhegvdx_2stage FORTRAN_NAME( magmaf_zhegvdx_2stage, MAGMAF_ZHEGVDX_2STAGE )
void magmaf_zhegvdx_2stage(
    magma_int_t *itype, const char* jobz, const char* range, const char* uplo, magma_int_t *n,
    magmaDoubleComplex *A, magma_int_t *lda,
    magmaDoubleComplex *B, magma_int_t *ldb, double *vl, double *vu, magma_int_t *il, magma_int_t *iu,
    magma_int_t *mout,
    double *w,
    magmaDoubleComplex *work, magma_int_t *lwork,
    double *rwork, magma_int_t *lrwork,
    magma_int_t *iwork, magma_int_t *liwork,
    magma_int_t *info )
{
    magma_zhegvdx_2stage(
        *itype, magma_vec_const(*jobz), magma_range_const(*range), magma_uplo_const(*uplo), *n,
        A, *lda,
        B, *ldb, *vl, *vu, *il, *iu,
        mout,
        w,
        work, *lwork,
        rwork, *lrwork,
        iwork, *liwork,
        info );
}

#define magmaf_zhegvdx_2stage_m FORTRAN_NAME( magmaf_zhegvdx_2stage_m, MAGMAF_ZHEGVDX_2STAGE_M )
void magmaf_zhegvdx_2stage_m(
    magma_int_t *ngpu, magma_int_t *itype, const char* jobz, const char* range, const char* uplo, magma_int_t *n,
    magmaDoubleComplex *A, magma_int_t *lda,
    magmaDoubleComplex *B, magma_int_t *ldb, double *vl, double *vu, magma_int_t *il, magma_int_t *iu,
    magma_int_t *mout,
    double *w,
    magmaDoubleComplex *work, magma_int_t *lwork,
    double *rwork, magma_int_t *lrwork,
    magma_int_t *iwork, magma_int_t *liwork,
    magma_int_t *info )
{
    magma_zhegvdx_2stage_m(
        *ngpu, *itype, magma_vec_const(*jobz), magma_range_const(*range), magma_uplo_const(*uplo), *n,
        A, *lda,
        B, *ldb, *vl, *vu, *il, *iu,
        mout,
        w,
        work, *lwork,
        rwork, *lrwork,
        iwork, *liwork,
        info );
}

#define magmaf_zhegvr FORTRAN_NAME( magmaf_zhegvr, MAGMAF_ZHEGVR )
void magmaf_zhegvr(
    magma_int_t *itype, const char* jobz, const char* range, const char* uplo, magma_int_t *n,
    magmaDoubleComplex *A, magma_int_t *lda,
    magmaDoubleComplex *B, magma_int_t *ldb, double *vl, double *vu, magma_int_t *il, magma_int_t *iu, double *abstol,
    magma_int_t *mout,
    double *w,
    magmaDoubleComplex *Z, magma_int_t *ldz,
    magma_int_t *isuppz,
    magmaDoubleComplex *work, magma_int_t *lwork,
    double *rwork, magma_int_t *lrwork,
    magma_int_t *iwork, magma_int_t *liwork,
    magma_int_t *info )
{
    magma_zhegvr(
        *itype, magma_vec_const(*jobz), magma_range_const(*range), magma_uplo_const(*uplo), *n,
        A, *lda,
        B, *ldb, *vl, *vu, *il, *iu, *abstol,
        mout,
        w,
        Z, *ldz,
        isuppz,
        work, *lwork,
        rwork, *lrwork,
        iwork, *liwork,
        info );
}

#define magmaf_zhegvx FORTRAN_NAME( magmaf_zhegvx, MAGMAF_ZHEGVX )
void magmaf_zhegvx(
    magma_int_t *itype, const char* jobz, const char* range, const char* uplo, magma_int_t *n,
    magmaDoubleComplex *A, magma_int_t *lda,
    magmaDoubleComplex *B, magma_int_t *ldb, double *vl, double *vu, magma_int_t *il, magma_int_t *iu, double *abstol,
    magma_int_t *mout,
    double *w,
    magmaDoubleComplex *Z, magma_int_t *ldz,
    magmaDoubleComplex *work, magma_int_t *lwork,
    double *rwork,
    magma_int_t *iwork,
    magma_int_t *ifail,
    magma_int_t *info )
{
    magma_zhegvx(
        *itype, magma_vec_const(*jobz), magma_range_const(*range), magma_uplo_const(*uplo), *n,
        A, *lda,
        B, *ldb, *vl, *vu, *il, *iu, *abstol,
        mout,
        w,
        Z, *ldz,
        work, *lwork,
        rwork,
        iwork,
        ifail,
        info );
}

#define magmaf_zhesv FORTRAN_NAME( magmaf_zhesv, MAGMAF_ZHESV )
void magmaf_zhesv(
    const char* uplo, magma_int_t *n, magma_int_t *nrhs,
    magmaDoubleComplex *A, magma_int_t *lda,
    magma_int_t *ipiv,
    magmaDoubleComplex *B, magma_int_t *ldb,
    magma_int_t *info )
{
    magma_zhesv(
        magma_uplo_const(*uplo), *n, *nrhs,
        A, *lda,
        ipiv,
        B, *ldb,
        info );
}

#define magmaf_zhesv_nopiv_gpu FORTRAN_NAME( magmaf_zhesv_nopiv_gpu, MAGMAF_ZHESV_NOPIV_GPU )
void magmaf_zhesv_nopiv_gpu(
    const char* uplo, magma_int_t *n, magma_int_t *nrhs,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb,
    magma_int_t *info )
{
    magma_zhesv_nopiv_gpu(
        magma_uplo_const(*uplo), *n, *nrhs,
        magma_zdevptr(dA), *ldda,
        magma_zdevptr(dB), *lddb,
        info );
}

#define magmaf_zhetrd FORTRAN_NAME( magmaf_zhetrd, MAGMAF_ZHETRD )
void magmaf_zhetrd(
    const char* uplo, magma_int_t *n,
    magmaDoubleComplex *A, magma_int_t *lda,
    double *d,
    double *e,
    magmaDoubleComplex *tau,
    magmaDoubleComplex *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_zhetrd(
        magma_uplo_const(*uplo), *n,
        A, *lda,
        d,
        e,
        tau,
        work, *lwork,
        info );
}

#define magmaf_zhetrd_gpu FORTRAN_NAME( magmaf_zhetrd_gpu, MAGMAF_ZHETRD_GPU )
void magmaf_zhetrd_gpu(
    const char* uplo, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    double *d,
    double *e,
    magmaDoubleComplex *tau,
    magmaDoubleComplex *wA, magma_int_t *ldwa,
    magmaDoubleComplex *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_zhetrd_gpu(
        magma_uplo_const(*uplo), *n,
        magma_zdevptr(dA), *ldda,
        d,
        e,
        tau,
        wA, *ldwa,
        work, *lwork,
        info );
}

#define magmaf_zhetrd2_gpu FORTRAN_NAME( magmaf_zhetrd2_gpu, MAGMAF_ZHETRD2_GPU )
void magmaf_zhetrd2_gpu(
    const char* uplo, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    double *d,
    double *e,
    magmaDoubleComplex *tau,
    magmaDoubleComplex *wA, magma_int_t *ldwa,
    magmaDoubleComplex *work, magma_int_t *lwork,
    devptr_t *dwork, magma_int_t *ldwork,
    magma_int_t *info )
{
    magma_zhetrd2_gpu(
        magma_uplo_const(*uplo), *n,
        magma_zdevptr(dA), *ldda,
        d,
        e,
        tau,
        wA, *ldwa,
        work, *lwork,
        magma_zdevptr(dwork), *ldwork,
        info );
}

#define magmaf_zhetrd_hb2st FORTRAN_NAME( magmaf_zhetrd_hb2st, MAGMAF_ZHETRD_HB2ST )
magma_int_t magmaf_zhetrd_hb2st(
    const char* uplo, magma_int_t *n, magma_int_t *nb, magma_int_t *Vblksiz,
    magmaDoubleComplex *A, magma_int_t *lda,
    double *d,
    double *e,
    magmaDoubleComplex *V, magma_int_t *ldv,
    magmaDoubleComplex *TAU, magma_int_t *compT,
    magmaDoubleComplex *T, magma_int_t *ldt )
{
    return magma_zhetrd_hb2st(
        magma_uplo_const(*uplo), *n, *nb, *Vblksiz,
        A, *lda,
        d,
        e,
        V, *ldv,
        TAU, *compT,
        T, *ldt );
}

#define magmaf_zhetrd_he2hb FORTRAN_NAME( magmaf_zhetrd_he2hb, MAGMAF_ZHETRD_HE2HB )
void magmaf_zhetrd_he2hb(
    const char* uplo, magma_int_t *n, magma_int_t *nb,
    magmaDoubleComplex *A, magma_int_t *lda,
    magmaDoubleComplex *tau,
    magmaDoubleComplex *work, magma_int_t *lwork,
    devptr_t *dT,
    magma_int_t *info )
{
    magma_zhetrd_he2hb(
        magma_uplo_const(*uplo), *n, *nb,
        A, *lda,
        tau,
        work, *lwork,
        magma_zdevptr(dT),
        info );
}

#define magmaf_zhetrf FORTRAN_NAME( magmaf_zhetrf, MAGMAF_ZHETRF )
void magmaf_zhetrf(
    const char* uplo, magma_int_t *n,
    magmaDoubleComplex *A, magma_int_t *lda,
    magma_int_t *ipiv,
    magma_int_t *info )
{
    magma_zhetrf(
        magma_uplo_const(*uplo), *n,
        A, *lda,
        ipiv,
        info );
}

#define magmaf_zhetrf_gpu FORTRAN_NAME( magmaf_zhetrf_gpu, MAGMAF_ZHETRF_GPU )
void magmaf_zhetrf_gpu(
    const char* uplo, magma_int_t *n,
    magmaDoubleComplex *dA, magma_int_t *ldda,
    magma_int_t *ipiv,
    magma_int_t *info )
{
    magma_zhetrf_gpu(
        magma_uplo_const(*uplo), *n,
        dA, *ldda,
        ipiv,
        info );
}

#define magmaf_zhetrf_aasen FORTRAN_NAME( magmaf_zhetrf_aasen, MAGMAF_ZHETRF_AASEN )
void magmaf_zhetrf_aasen(
    const char* uplo, magma_int_t *cpu_panel, magma_int_t *n,
    magmaDoubleComplex *A, magma_int_t *lda,
    magma_int_t *ipiv,
    magma_int_t *info )
{
    magma_zhetrf_aasen(
        magma_uplo_const(*uplo), *cpu_panel, *n,
        A, *lda,
        ipiv,
        info );
}

#define magmaf_zhetrf_nopiv FORTRAN_NAME( magmaf_zhetrf_nopiv, MAGMAF_ZHETRF_NOPIV )
void magmaf_zhetrf_nopiv(
    const char* uplo, magma_int_t *n,
    magmaDoubleComplex *A, magma_int_t *lda,
    magma_int_t *info )
{
    magma_zhetrf_nopiv(
        magma_uplo_const(*uplo), *n,
        A, *lda,
        info );
}

#define magmaf_zhetrf_nopiv_cpu FORTRAN_NAME( magmaf_zhetrf_nopiv_cpu, MAGMAF_ZHETRF_NOPIV_CPU )
void magmaf_zhetrf_nopiv_cpu(
    const char* uplo, magma_int_t *n, magma_int_t *ib,
    magmaDoubleComplex *A, magma_int_t *lda,
    magma_int_t *info )
{
    magma_zhetrf_nopiv_cpu(
        magma_uplo_const(*uplo), *n, *ib,
        A, *lda,
        info );
}

#define magmaf_zhetrf_nopiv_gpu FORTRAN_NAME( magmaf_zhetrf_nopiv_gpu, MAGMAF_ZHETRF_NOPIV_GPU )
void magmaf_zhetrf_nopiv_gpu(
    const char* uplo, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t *info )
{
    magma_zhetrf_nopiv_gpu(
        magma_uplo_const(*uplo), *n,
        magma_zdevptr(dA), *ldda,
        info );
}

#define magmaf_zhetrs_nopiv_gpu FORTRAN_NAME( magmaf_zhetrs_nopiv_gpu, MAGMAF_ZHETRS_NOPIV_GPU )
void magmaf_zhetrs_nopiv_gpu(
    const char* uplo, magma_int_t *n, magma_int_t *nrhs,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb,
    magma_int_t *info )
{
    magma_zhetrs_nopiv_gpu(
        magma_uplo_const(*uplo), *n, *nrhs,
        magma_zdevptr(dA), *ldda,
        magma_zdevptr(dB), *lddb,
        info );
}

#define magmaf_zlarf_gpu FORTRAN_NAME( magmaf_zlarf_gpu, MAGMAF_ZLARF_GPU )
magma_int_t magmaf_zlarf_gpu(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dv,
    devptr_t *dtau,
    devptr_t *dC, magma_int_t *lddc, magma_queue_t *queue )
{
    return magma_zlarf_gpu(
        *m, *n,
        magma_zdevptr(dv),
        magma_zdevptr(dtau),
        magma_zdevptr(dC), *lddc, *queue );
}

#define magmaf_zlarfb2_gpu FORTRAN_NAME( magmaf_zlarfb2_gpu, MAGMAF_ZLARFB2_GPU )
magma_int_t magmaf_zlarfb2_gpu(
    magma_int_t *m, magma_int_t *n, magma_int_t *k,
    devptr_t *dV, magma_int_t *lddv,
    devptr_t *dT, magma_int_t *lddt,
    devptr_t *dC, magma_int_t *lddc,
    devptr_t *dwork, magma_int_t *ldwork, magma_queue_t *queue )
{
    return magma_zlarfb2_gpu(
        *m, *n, *k,
        magma_zdevptr(dV), *lddv,
        magma_zdevptr(dT), *lddt,
        magma_zdevptr(dC), *lddc,
        magma_zdevptr(dwork), *ldwork, *queue );
}

#define magmaf_zlatrsd FORTRAN_NAME( magmaf_zlatrsd, MAGMAF_ZLATRSD )
void magmaf_zlatrsd(
    const char* uplo, const char* trans, const char* diag, const char* normin, magma_int_t *n,
    magmaDoubleComplex *A, magma_int_t *lda, magmaDoubleComplex *lambda,
    magmaDoubleComplex *x,
    double *scale,
    double *cnorm,
    magma_int_t *info )
{
    magma_zlatrsd(
        magma_uplo_const(*uplo), magma_trans_const(*trans), magma_diag_const(*diag), magma_bool_const(*normin), *n,
        A, *lda, *lambda,
        x,
        scale,
        cnorm,
        info );
}

#define magmaf_zlauum FORTRAN_NAME( magmaf_zlauum, MAGMAF_ZLAUUM )
void magmaf_zlauum(
    const char* uplo, magma_int_t *n,
    magmaDoubleComplex *A, magma_int_t *lda,
    magma_int_t *info )
{
    magma_zlauum(
        magma_uplo_const(*uplo), *n,
        A, *lda,
        info );
}

#define magmaf_zlauum_gpu FORTRAN_NAME( magmaf_zlauum_gpu, MAGMAF_ZLAUUM_GPU )
void magmaf_zlauum_gpu(
    const char* uplo, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t *info )
{
    magma_zlauum_gpu(
        magma_uplo_const(*uplo), *n,
        magma_zdevptr(dA), *ldda,
        info );
}

#define magmaf_zposv FORTRAN_NAME( magmaf_zposv, MAGMAF_ZPOSV )
void magmaf_zposv(
    const char* uplo, magma_int_t *n, magma_int_t *nrhs,
    magmaDoubleComplex *A, magma_int_t *lda,
    magmaDoubleComplex *B, magma_int_t *ldb,
    magma_int_t *info )
{
    magma_zposv(
        magma_uplo_const(*uplo), *n, *nrhs,
        A, *lda,
        B, *ldb,
        info );
}

#define magmaf_zposv_gpu FORTRAN_NAME( magmaf_zposv_gpu, MAGMAF_ZPOSV_GPU )
void magmaf_zposv_gpu(
    const char* uplo, magma_int_t *n, magma_int_t *nrhs,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb,
    magma_int_t *info )
{
    magma_zposv_gpu(
        magma_uplo_const(*uplo), *n, *nrhs,
        magma_zdevptr(dA), *ldda,
        magma_zdevptr(dB), *lddb,
        info );
}

#define magmaf_zpotf2_gpu FORTRAN_NAME( magmaf_zpotf2_gpu, MAGMAF_ZPOTF2_GPU )
void magmaf_zpotf2_gpu(
    const char* uplo, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda, magma_queue_t *queue,
    magma_int_t *info )
{
    magma_zpotf2_gpu(
        magma_uplo_const(*uplo), *n,
        magma_zdevptr(dA), *ldda, *queue,
        info );
}

#define magmaf_zpotf2_native FORTRAN_NAME( magmaf_zpotf2_native, MAGMAF_ZPOTF2_NATIVE )
magma_int_t magmaf_zpotf2_native(
    const char* uplo, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda, magma_int_t *step,
    magma_int_t *device_info, magma_queue_t *queue )
{
    return magma_zpotf2_native(
        magma_uplo_const(*uplo), *n,
        magma_zdevptr(dA), *ldda, *step,
        device_info, *queue );
}

#define magmaf_zpotrf_rectile_native FORTRAN_NAME( magmaf_zpotrf_rectile_native, MAGMAF_ZPOTRF_RECTILE_NATIVE )
void magmaf_zpotrf_rectile_native(
    const char* uplo, magma_int_t *n, magma_int_t *recnb,
    magmaDoubleComplex* dA, magma_int_t *ldda, magma_int_t *gbstep,
    magma_int_t *dinfo,
    magma_int_t *info, magma_queue_t *queue )
{
    magma_zpotrf_rectile_native(
        magma_uplo_const(*uplo), *n, *recnb,
        dA, *ldda, *gbstep,
        dinfo,
        info, *queue );
}

#define magmaf_zpotrf FORTRAN_NAME( magmaf_zpotrf, MAGMAF_ZPOTRF )
void magmaf_zpotrf(
    const char* uplo, magma_int_t *n,
    magmaDoubleComplex *A, magma_int_t *lda,
    magma_int_t *info )
{
    magma_zpotrf(
        magma_uplo_const(*uplo), *n,
        A, *lda,
        info );
}

#define magmaf_zpotrf_gpu FORTRAN_NAME( magmaf_zpotrf_gpu, MAGMAF_ZPOTRF_GPU )
void magmaf_zpotrf_gpu(
    const char* uplo, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t *info )
{
    magma_zpotrf_gpu(
        magma_uplo_const(*uplo), *n,
        magma_zdevptr(dA), *ldda,
        info );
}

#define magmaf_zpotrf_native FORTRAN_NAME( magmaf_zpotrf_native, MAGMAF_ZPOTRF_NATIVE )
void magmaf_zpotrf_native(
    const char* uplo, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t *info )
{
    magma_zpotrf_native(
        magma_uplo_const(*uplo), *n,
        magma_zdevptr(dA), *ldda,
        info );
}

#define magmaf_zpotrf_m FORTRAN_NAME( magmaf_zpotrf_m, MAGMAF_ZPOTRF_M )
void magmaf_zpotrf_m(
    magma_int_t *ngpu, const char* uplo, magma_int_t *n,
    magmaDoubleComplex *A, magma_int_t *lda,
    magma_int_t *info )
{
    magma_zpotrf_m(
        *ngpu, magma_uplo_const(*uplo), *n,
        A, *lda,
        info );
}

#define magmaf_zpotri FORTRAN_NAME( magmaf_zpotri, MAGMAF_ZPOTRI )
void magmaf_zpotri(
    const char* uplo, magma_int_t *n,
    magmaDoubleComplex *A, magma_int_t *lda,
    magma_int_t *info )
{
    magma_zpotri(
        magma_uplo_const(*uplo), *n,
        A, *lda,
        info );
}

#define magmaf_zpotri_gpu FORTRAN_NAME( magmaf_zpotri_gpu, MAGMAF_ZPOTRI_GPU )
void magmaf_zpotri_gpu(
    const char* uplo, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t *info )
{
    magma_zpotri_gpu(
        magma_uplo_const(*uplo), *n,
        magma_zdevptr(dA), *ldda,
        info );
}

#define magmaf_zpotrs_gpu FORTRAN_NAME( magmaf_zpotrs_gpu, MAGMAF_ZPOTRS_GPU )
void magmaf_zpotrs_gpu(
    const char* uplo, magma_int_t *n, magma_int_t *nrhs,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb,
    magma_int_t *info )
{
    magma_zpotrs_gpu(
        magma_uplo_const(*uplo), *n, *nrhs,
        magma_zdevptr(dA), *ldda,
        magma_zdevptr(dB), *lddb,
        info );
}

#define magmaf_zsysv_nopiv_gpu FORTRAN_NAME( magmaf_zsysv_nopiv_gpu, MAGMAF_ZSYSV_NOPIV_GPU )
void magmaf_zsysv_nopiv_gpu(
    const char* uplo, magma_int_t *n, magma_int_t *nrhs,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb,
    magma_int_t *info )
{
    magma_zsysv_nopiv_gpu(
        magma_uplo_const(*uplo), *n, *nrhs,
        magma_zdevptr(dA), *ldda,
        magma_zdevptr(dB), *lddb,
        info );
}

#define magmaf_zsytrf_nopiv_cpu FORTRAN_NAME( magmaf_zsytrf_nopiv_cpu, MAGMAF_ZSYTRF_NOPIV_CPU )
void magmaf_zsytrf_nopiv_cpu(
    const char* uplo, magma_int_t *n, magma_int_t *ib,
    magmaDoubleComplex *A, magma_int_t *lda,
    magma_int_t *info )
{
    magma_zsytrf_nopiv_cpu(
        magma_uplo_const(*uplo), *n, *ib,
        A, *lda,
        info );
}

#define magmaf_zsytrf_nopiv_gpu FORTRAN_NAME( magmaf_zsytrf_nopiv_gpu, MAGMAF_ZSYTRF_NOPIV_GPU )
void magmaf_zsytrf_nopiv_gpu(
    const char* uplo, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t *info )
{
    magma_zsytrf_nopiv_gpu(
        magma_uplo_const(*uplo), *n,
        magma_zdevptr(dA), *ldda,
        info );
}

#define magmaf_zsytrs_nopiv_gpu FORTRAN_NAME( magmaf_zsytrs_nopiv_gpu, MAGMAF_ZSYTRS_NOPIV_GPU )
void magmaf_zsytrs_nopiv_gpu(
    const char* uplo, magma_int_t *n, magma_int_t *nrhs,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb,
    magma_int_t *info )
{
    magma_zsytrs_nopiv_gpu(
        magma_uplo_const(*uplo), *n, *nrhs,
        magma_zdevptr(dA), *ldda,
        magma_zdevptr(dB), *lddb,
        info );
}

#define magmaf_zstedx FORTRAN_NAME( magmaf_zstedx, MAGMAF_ZSTEDX )
void magmaf_zstedx(
    const char* range, magma_int_t *n, double *vl, double *vu, magma_int_t *il, magma_int_t *iu,
    double *d,
    double *e,
    magmaDoubleComplex *Z, magma_int_t *ldz,
    double *rwork, magma_int_t *lrwork,
    magma_int_t *iwork, magma_int_t *liwork,
    devptr_t *dwork,
    magma_int_t *info )
{
    magma_zstedx(
        magma_range_const(*range), *n, *vl, *vu, *il, *iu,
        d,
        e,
        Z, *ldz,
        rwork, *lrwork,
        iwork, *liwork,
        magma_ddevptr(dwork),
        info );
}

#define magmaf_zstedx_m FORTRAN_NAME( magmaf_zstedx_m, MAGMAF_ZSTEDX_M )
void magmaf_zstedx_m(
    magma_int_t *ngpu, const char* range, magma_int_t *n, double *vl, double *vu, magma_int_t *il, magma_int_t *iu,
    double *d,
    double *e,
    magmaDoubleComplex *Z, magma_int_t *ldz,
    double *rwork, magma_int_t *lrwork,
    magma_int_t *iwork, magma_int_t *liwork,
    magma_int_t *info )
{
    magma_zstedx_m(
        *ngpu, magma_range_const(*range), *n, *vl, *vu, *il, *iu,
        d,
        e,
        Z, *ldz,
        rwork, *lrwork,
        iwork, *liwork,
        info );
}

#define magmaf_ztrevc3 FORTRAN_NAME( magmaf_ztrevc3, MAGMAF_ZTREVC3 )
void magmaf_ztrevc3(
    const char* side, const char* howmany,
    magma_int_t *select, magma_int_t *n,
    magmaDoubleComplex *T, magma_int_t *ldt,
    magmaDoubleComplex *VL, magma_int_t *ldvl,
    magmaDoubleComplex *VR, magma_int_t *ldvr, magma_int_t *mm,
    magma_int_t *mout,
    magmaDoubleComplex *work, magma_int_t *lwork,
    double *rwork,
    magma_int_t *info )
{
    magma_ztrevc3(
        magma_side_const(*side), magma_vec_const(*howmany),
        select, *n,
        T, *ldt,
        VL, *ldvl,
        VR, *ldvr, *mm,
        mout,
        work, *lwork,
        rwork,
        info );
}

#define magmaf_ztrevc3_mt FORTRAN_NAME( magmaf_ztrevc3_mt, MAGMAF_ZTREVC3_MT )
void magmaf_ztrevc3_mt(
    const char* side, const char* howmany,
    magma_int_t *select, magma_int_t *n,
    magmaDoubleComplex *T, magma_int_t *ldt,
    magmaDoubleComplex *VL, magma_int_t *ldvl,
    magmaDoubleComplex *VR, magma_int_t *ldvr, magma_int_t *mm,
    magma_int_t *mout,
    magmaDoubleComplex *work, magma_int_t *lwork,
    double *rwork,
    magma_int_t *info )
{
    magma_ztrevc3_mt(
        magma_side_const(*side), magma_vec_const(*howmany),
        select, *n,
        T, *ldt,
        VL, *ldvl,
        VR, *ldvr, *mm,
        mout,
        work, *lwork,
        rwork,
        info );
}

#define magmaf_ztrsm_m FORTRAN_NAME( magmaf_ztrsm_m, MAGMAF_ZTRSM_M )
magma_int_t magmaf_ztrsm_m(
    magma_int_t *ngpu, const char* side, const char* uplo, const char* transa, const char* diag, magma_int_t *m, magma_int_t *n, magmaDoubleComplex *alpha,
    magmaDoubleComplex *A, magma_int_t *lda,
    magmaDoubleComplex *B, magma_int_t *ldb )
{
    return magma_ztrsm_m(
        *ngpu, magma_side_const(*side), magma_uplo_const(*uplo), magma_trans_const(*transa), magma_diag_const(*diag), *m, *n, *alpha,
        A, *lda,
        B, *ldb );
}

#define magmaf_ztrtri FORTRAN_NAME( magmaf_ztrtri, MAGMAF_ZTRTRI )
void magmaf_ztrtri(
    const char* uplo, const char* diag, magma_int_t *n,
    magmaDoubleComplex *A, magma_int_t *lda,
    magma_int_t *info )
{
    magma_ztrtri(
        magma_uplo_const(*uplo), magma_diag_const(*diag), *n,
        A, *lda,
        info );
}

#define magmaf_ztrtri_gpu FORTRAN_NAME( magmaf_ztrtri_gpu, MAGMAF_ZTRTRI_GPU )
void magmaf_ztrtri_gpu(
    const char* uplo, const char* diag, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t *info )
{
    magma_ztrtri_gpu(
        magma_uplo_const(*uplo), magma_diag_const(*diag), *n,
        magma_zdevptr(dA), *ldda,
        info );
}

#define magmaf_zungbr FORTRAN_NAME( magmaf_zungbr, MAGMAF_ZUNGBR )
void magmaf_zungbr(
    const char* vect, magma_int_t *m, magma_int_t *n, magma_int_t *k,
    magmaDoubleComplex *A, magma_int_t *lda,
    magmaDoubleComplex *tau,
    magmaDoubleComplex *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_zungbr(
        magma_vect_const(*vect), *m, *n, *k,
        A, *lda,
        tau,
        work, *lwork,
        info );
}

#define magmaf_zunghr FORTRAN_NAME( magmaf_zunghr, MAGMAF_ZUNGHR )
void magmaf_zunghr(
    magma_int_t *n, magma_int_t *ilo, magma_int_t *ihi,
    magmaDoubleComplex *A, magma_int_t *lda,
    magmaDoubleComplex *tau,
    devptr_t *dT, magma_int_t *nb,
    magma_int_t *info )
{
    magma_zunghr(
        *n, *ilo, *ihi,
        A, *lda,
        tau,
        magma_zdevptr(dT), *nb,
        info );
}

#define magmaf_zunghr_m FORTRAN_NAME( magmaf_zunghr_m, MAGMAF_ZUNGHR_M )
void magmaf_zunghr_m(
    magma_int_t *n, magma_int_t *ilo, magma_int_t *ihi,
    magmaDoubleComplex *A, magma_int_t *lda,
    magmaDoubleComplex *tau,
    magmaDoubleComplex *T, magma_int_t *nb,
    magma_int_t *info )
{
    magma_zunghr_m(
        *n, *ilo, *ihi,
        A, *lda,
        tau,
        T, *nb,
        info );
}

#define magmaf_zunglq FORTRAN_NAME( magmaf_zunglq, MAGMAF_ZUNGLQ )
void magmaf_zunglq(
    magma_int_t *m, magma_int_t *n, magma_int_t *k,
    magmaDoubleComplex *A, magma_int_t *lda,
    magmaDoubleComplex *tau,
    devptr_t *dT, magma_int_t *nb,
    magma_int_t *info )
{
    magma_zunglq(
        *m, *n, *k,
        A, *lda,
        tau,
        magma_zdevptr(dT), *nb,
        info );
}

#define magmaf_zungqr FORTRAN_NAME( magmaf_zungqr, MAGMAF_ZUNGQR )
void magmaf_zungqr(
    magma_int_t *m, magma_int_t *n, magma_int_t *k,
    magmaDoubleComplex *A, magma_int_t *lda,
    magmaDoubleComplex *tau,
    devptr_t *dT, magma_int_t *nb,
    magma_int_t *info )
{
    magma_zungqr(
        *m, *n, *k,
        A, *lda,
        tau,
        magma_zdevptr(dT), *nb,
        info );
}

#define magmaf_zungqr_gpu FORTRAN_NAME( magmaf_zungqr_gpu, MAGMAF_ZUNGQR_GPU )
void magmaf_zungqr_gpu(
    magma_int_t *m, magma_int_t *n, magma_int_t *k,
    devptr_t *dA, magma_int_t *ldda,
    magmaDoubleComplex *tau,
    devptr_t *dT, magma_int_t *nb,
    magma_int_t *info )
{
    magma_zungqr_gpu(
        *m, *n, *k,
        magma_zdevptr(dA), *ldda,
        tau,
        magma_zdevptr(dT), *nb,
        info );
}

#define magmaf_zungqr_m FORTRAN_NAME( magmaf_zungqr_m, MAGMAF_ZUNGQR_M )
void magmaf_zungqr_m(
    magma_int_t *m, magma_int_t *n, magma_int_t *k,
    magmaDoubleComplex *A, magma_int_t *lda,
    magmaDoubleComplex *tau,
    magmaDoubleComplex *T, magma_int_t *nb,
    magma_int_t *info )
{
    magma_zungqr_m(
        *m, *n, *k,
        A, *lda,
        tau,
        T, *nb,
        info );
}

#define magmaf_zungqr2 FORTRAN_NAME( magmaf_zungqr2, MAGMAF_ZUNGQR2 )
void magmaf_zungqr2(
    magma_int_t *m, magma_int_t *n, magma_int_t *k,
    magmaDoubleComplex *A, magma_int_t *lda,
    magmaDoubleComplex *tau,
    magma_int_t *info )
{
    magma_zungqr2(
        *m, *n, *k,
        A, *lda,
        tau,
        info );
}

#define magmaf_zunmbr FORTRAN_NAME( magmaf_zunmbr, MAGMAF_ZUNMBR )
void magmaf_zunmbr(
    const char* vect, const char* side, const char* trans, magma_int_t *m, magma_int_t *n, magma_int_t *k,
    magmaDoubleComplex *A, magma_int_t *lda,
    magmaDoubleComplex *tau,
    magmaDoubleComplex *C, magma_int_t *ldc,
    magmaDoubleComplex *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_zunmbr(
        magma_vect_const(*vect), magma_side_const(*side), magma_trans_const(*trans), *m, *n, *k,
        A, *lda,
        tau,
        C, *ldc,
        work, *lwork,
        info );
}

#define magmaf_zunmlq FORTRAN_NAME( magmaf_zunmlq, MAGMAF_ZUNMLQ )
void magmaf_zunmlq(
    const char* side, const char* trans, magma_int_t *m, magma_int_t *n, magma_int_t *k,
    magmaDoubleComplex *A, magma_int_t *lda,
    magmaDoubleComplex *tau,
    magmaDoubleComplex *C, magma_int_t *ldc,
    magmaDoubleComplex *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_zunmlq(
        magma_side_const(*side), magma_trans_const(*trans), *m, *n, *k,
        A, *lda,
        tau,
        C, *ldc,
        work, *lwork,
        info );
}

#define magmaf_zunmrq FORTRAN_NAME( magmaf_zunmrq, MAGMAF_ZUNMRQ )
void magmaf_zunmrq(
    const char* side, const char* trans, magma_int_t *m, magma_int_t *n, magma_int_t *k,
    magmaDoubleComplex *A, magma_int_t *lda,
    magmaDoubleComplex *tau,
    magmaDoubleComplex *C, magma_int_t *ldc,
    magmaDoubleComplex *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_zunmrq(
        magma_side_const(*side), magma_trans_const(*trans), *m, *n, *k,
        A, *lda,
        tau,
        C, *ldc,
        work, *lwork,
        info );
}

#define magmaf_zunmql FORTRAN_NAME( magmaf_zunmql, MAGMAF_ZUNMQL )
void magmaf_zunmql(
    const char* side, const char* trans, magma_int_t *m, magma_int_t *n, magma_int_t *k,
    magmaDoubleComplex *A, magma_int_t *lda,
    magmaDoubleComplex *tau,
    magmaDoubleComplex *C, magma_int_t *ldc,
    magmaDoubleComplex *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_zunmql(
        magma_side_const(*side), magma_trans_const(*trans), *m, *n, *k,
        A, *lda,
        tau,
        C, *ldc,
        work, *lwork,
        info );
}

#define magmaf_zunmql2_gpu FORTRAN_NAME( magmaf_zunmql2_gpu, MAGMAF_ZUNMQL2_GPU )
void magmaf_zunmql2_gpu(
    const char* side, const char* trans, magma_int_t *m, magma_int_t *n, magma_int_t *k,
    devptr_t *dA, magma_int_t *ldda,
    magmaDoubleComplex *tau,
    devptr_t *dC, magma_int_t *lddc,
    magmaDoubleComplex *wA, magma_int_t *ldwa,
    magma_int_t *info )
{
    magma_zunmql2_gpu(
        magma_side_const(*side), magma_trans_const(*trans), *m, *n, *k,
        magma_zdevptr(dA), *ldda,
        tau,
        magma_zdevptr(dC), *lddc,
        wA, *ldwa,
        info );
}

#define magmaf_zunmqr FORTRAN_NAME( magmaf_zunmqr, MAGMAF_ZUNMQR )
void magmaf_zunmqr(
    const char* side, const char* trans, magma_int_t *m, magma_int_t *n, magma_int_t *k,
    magmaDoubleComplex *A, magma_int_t *lda,
    magmaDoubleComplex *tau,
    magmaDoubleComplex *C, magma_int_t *ldc,
    magmaDoubleComplex *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_zunmqr(
        magma_side_const(*side), magma_trans_const(*trans), *m, *n, *k,
        A, *lda,
        tau,
        C, *ldc,
        work, *lwork,
        info );
}

#define magmaf_zunmqr_gpu FORTRAN_NAME( magmaf_zunmqr_gpu, MAGMAF_ZUNMQR_GPU )
void magmaf_zunmqr_gpu(
    const char* side, const char* trans, magma_int_t *m, magma_int_t *n, magma_int_t *k,
    devptr_t *dA, magma_int_t *ldda,
    magmaDoubleComplex *tau,
    devptr_t *dC, magma_int_t *lddc,
    magmaDoubleComplex *hwork, magma_int_t *lwork,
    devptr_t *dT, magma_int_t *nb,
    magma_int_t *info )
{
    magma_zunmqr_gpu(
        magma_side_const(*side), magma_trans_const(*trans), *m, *n, *k,
        magma_zdevptr(dA), *ldda,
        tau,
        magma_zdevptr(dC), *lddc,
        hwork, *lwork,
        magma_zdevptr(dT), *nb,
        info );
}

#define magmaf_zunmqr2_gpu FORTRAN_NAME( magmaf_zunmqr2_gpu, MAGMAF_ZUNMQR2_GPU )
void magmaf_zunmqr2_gpu(
    const char* side, const char* trans, magma_int_t *m, magma_int_t *n, magma_int_t *k,
    devptr_t *dA, magma_int_t *ldda,
    magmaDoubleComplex *tau,
    devptr_t *dC, magma_int_t *lddc,
    magmaDoubleComplex *wA, magma_int_t *ldwa,
    magma_int_t *info )
{
    magma_zunmqr2_gpu(
        magma_side_const(*side), magma_trans_const(*trans), *m, *n, *k,
        magma_zdevptr(dA), *ldda,
        tau,
        magma_zdevptr(dC), *lddc,
        wA, *ldwa,
        info );
}

#define magmaf_zunmqr_m FORTRAN_NAME( magmaf_zunmqr_m, MAGMAF_ZUNMQR_M )
void magmaf_zunmqr_m(
    magma_int_t *ngpu, const char* side, const char* trans, magma_int_t *m, magma_int_t *n, magma_int_t *k,
    magmaDoubleComplex *A, magma_int_t *lda,
    magmaDoubleComplex *tau,
    magmaDoubleComplex *C, magma_int_t *ldc,
    magmaDoubleComplex *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_zunmqr_m(
        *ngpu, magma_side_const(*side), magma_trans_const(*trans), *m, *n, *k,
        A, *lda,
        tau,
        C, *ldc,
        work, *lwork,
        info );
}

#define magmaf_zunmtr FORTRAN_NAME( magmaf_zunmtr, MAGMAF_ZUNMTR )
void magmaf_zunmtr(
    const char* side, const char* uplo, const char* trans, magma_int_t *m, magma_int_t *n,
    magmaDoubleComplex *A, magma_int_t *lda,
    magmaDoubleComplex *tau,
    magmaDoubleComplex *C, magma_int_t *ldc,
    magmaDoubleComplex *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_zunmtr(
        magma_side_const(*side), magma_uplo_const(*uplo), magma_trans_const(*trans), *m, *n,
        A, *lda,
        tau,
        C, *ldc,
        work, *lwork,
        info );
}

#define magmaf_zunmtr_gpu FORTRAN_NAME( magmaf_zunmtr_gpu, MAGMAF_ZUNMTR_GPU )
void magmaf_zunmtr_gpu(
    const char* side, const char* uplo, const char* trans, magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magmaDoubleComplex *tau,
    devptr_t *dC, magma_int_t *lddc,
    magmaDoubleComplex *wA, magma_int_t *ldwa,
    magma_int_t *info )
{
    magma_zunmtr_gpu(
        magma_side_const(*side), magma_uplo_const(*uplo), magma_trans_const(*trans), *m, *n,
        magma_zdevptr(dA), *ldda,
        tau,
        magma_zdevptr(dC), *lddc,
        wA, *ldwa,
        info );
}

#define magmaf_zunmtr_m FORTRAN_NAME( magmaf_zunmtr_m, MAGMAF_ZUNMTR_M )
void magmaf_zunmtr_m(
    magma_int_t *ngpu, const char* side, const char* uplo, const char* trans, magma_int_t *m, magma_int_t *n,
    magmaDoubleComplex *A, magma_int_t *lda,
    magmaDoubleComplex *tau,
    magmaDoubleComplex *C, magma_int_t *ldc,
    magmaDoubleComplex *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_zunmtr_m(
        *ngpu, magma_side_const(*side), magma_uplo_const(*uplo), magma_trans_const(*trans), *m, *n,
        A, *lda,
        tau,
        C, *ldc,
        work, *lwork,
        info );
}

#define magmaf_z_isnan FORTRAN_NAME( magmaf_z_isnan, MAGMAF_Z_ISNAN )
int magmaf_z_isnan(
    magmaDoubleComplex *x )
{
    return magma_z_isnan(
        *x );
}

#define magmaf_z_isinf FORTRAN_NAME( magmaf_z_isinf, MAGMAF_Z_ISINF )
int magmaf_z_isinf(
    magmaDoubleComplex *x )
{
    return magma_z_isinf(
        *x );
}

#define magmaf_z_isnan_inf FORTRAN_NAME( magmaf_z_isnan_inf, MAGMAF_Z_ISNAN_INF )
int magmaf_z_isnan_inf(
    magmaDoubleComplex *x )
{
    return magma_z_isnan_inf(
        *x );
}

#define magmaf_znan_inf FORTRAN_NAME( magmaf_znan_inf, MAGMAF_ZNAN_INF )
magma_int_t magmaf_znan_inf(
    const char* uplo, magma_int_t *m, magma_int_t *n,
    magmaDoubleComplex *A, magma_int_t *lda,
    magma_int_t *cnt_nan,
    magma_int_t *cnt_inf )
{
    return magma_znan_inf(
        magma_uplo_const(*uplo), *m, *n,
        A, *lda,
        cnt_nan,
        cnt_inf );
}

#define magmaf_znan_inf_gpu FORTRAN_NAME( magmaf_znan_inf_gpu, MAGMAF_ZNAN_INF_GPU )
magma_int_t magmaf_znan_inf_gpu(
    const char* uplo, magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t *cnt_nan,
    magma_int_t *cnt_inf, magma_queue_t *queue )
{
    return magma_znan_inf_gpu(
        magma_uplo_const(*uplo), *m, *n,
        magma_zdevptr(dA), *ldda,
        cnt_nan,
        cnt_inf, *queue );
}

#define magmaf_zprint FORTRAN_NAME( magmaf_zprint, MAGMAF_ZPRINT )
void magmaf_zprint(
    magma_int_t *m, magma_int_t *n,
    magmaDoubleComplex *A, magma_int_t *lda )
{
    magma_zprint(
        *m, *n,
        A, *lda );
}

#define magmaf_zprint_gpu FORTRAN_NAME( magmaf_zprint_gpu, MAGMAF_ZPRINT_GPU )
void magmaf_zprint_gpu(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda, magma_queue_t *queue )
{
    magma_zprint_gpu(
        *m, *n,
        magma_zdevptr(dA), *ldda, *queue );
}

#define magmaf_zpanel_to_q FORTRAN_NAME( magmaf_zpanel_to_q, MAGMAF_ZPANEL_TO_Q )
void magmaf_zpanel_to_q(
    const char* uplo, magma_int_t *ib,
    magmaDoubleComplex *A, magma_int_t *lda,
    magmaDoubleComplex *work )
{
    magma_zpanel_to_q(
        magma_uplo_const(*uplo), *ib,
        A, *lda,
        work );
}

#define magmaf_zq_to_panel FORTRAN_NAME( magmaf_zq_to_panel, MAGMAF_ZQ_TO_PANEL )
void magmaf_zq_to_panel(
    const char* uplo, magma_int_t *ib,
    magmaDoubleComplex *A, magma_int_t *lda,
    magmaDoubleComplex *work )
{
    magma_zq_to_panel(
        magma_uplo_const(*uplo), *ib,
        A, *lda,
        work );
}

#define magmablasf_zextract_diag_sqrt FORTRAN_NAME( magmablasf_zextract_diag_sqrt, MAGMABLASF_ZEXTRACT_DIAG_SQRT )
void magmablasf_zextract_diag_sqrt(
    magma_int_t *m, magma_int_t *n,
    magmaDoubleComplex* dA, magma_int_t *ldda,
    double* dD, magma_int_t *incd, magma_queue_t *queue )
{
    magmablas_zextract_diag_sqrt(
        *m, *n,
        dA, *ldda,
        dD, *incd, *queue );
}

#define magmablasf_zscal_shift_hpd FORTRAN_NAME( magmablasf_zscal_shift_hpd, MAGMABLASF_ZSCAL_SHIFT_HPD )
void magmablasf_zscal_shift_hpd(
    const char* uplo, int *n,
    magmaDoubleComplex* dA, int *ldda,
    double* dD, int *incd, double *miu, double *cn, double *eps, magma_queue_t *queue )
{
    magmablas_zscal_shift_hpd(
        magma_uplo_const(*uplo), *n,
        dA, *ldda,
        dD, *incd, *miu, *cn, *eps, *queue );
}

#define magmablasf_zdimv_invert FORTRAN_NAME( magmablasf_zdimv_invert, MAGMABLASF_ZDIMV_INVERT )
void magmablasf_zdimv_invert(
    magma_int_t *n, magmaDoubleComplex *alpha,
    magmaDoubleComplex* dD, magma_int_t *incd,
    magmaDoubleComplex* dx, magma_int_t *incx, magmaDoubleComplex *beta,
    magmaDoubleComplex* dy, magma_int_t *incy, magma_queue_t *queue )
{
    magmablas_zdimv_invert(
        *n, *alpha,
        dD, *incd,
        dx, *incx, *beta,
        dy, *incy, *queue );
}


#ifdef __cplusplus
}
#endif
