/*******************************************************************************
 *  This file is AUTOMATICALLY GENERATED by:
 *  tools/fortran_wrappers.pl include/magma_s.i
 *  Do not edit.
 ******************************************************************************/

#include <stdint.h>  // for uintptr_t

#include "magma_v2.h"
#include "magma_mangling.h"

// typedef from CUDADIR/src/fortran.h directory
typedef size_t devptr_t;

#ifdef PGI_FORTRAN
    #define magma_devptr(ptr_)  ((void*)              (ptr_))
    #define magma_idevptr(ptr_) ((magma_int_t*)       (ptr_))
    #define magma_zdevptr(ptr_) ((magmaDoubleComplex*)(ptr_))
    #define magma_cdevptr(ptr_) ((magmaFloatComplex*) (ptr_))
    #define magma_ddevptr(ptr_) ((double*)            (ptr_))
    #define magma_sdevptr(ptr_) ((float*)             (ptr_))
#else
    #define magma_devptr(ptr_)  ((void*)              (uintptr_t)(*(ptr_)))
    #define magma_idevptr(ptr_) ((magma_int_t*)       (uintptr_t)(*(ptr_)))
    #define magma_zdevptr(ptr_) ((magmaDoubleComplex*)(uintptr_t)(*(ptr_)))
    #define magma_cdevptr(ptr_) ((magmaFloatComplex*) (uintptr_t)(*(ptr_)))
    #define magma_ddevptr(ptr_) ((double*)            (uintptr_t)(*(ptr_)))
    #define magma_sdevptr(ptr_) ((float*)             (uintptr_t)(*(ptr_)))
#endif

#ifdef __cplusplus
extern "C" {
#endif

#define magmaf_get_slaex3_m_nb FORTRAN_NAME( magmaf_get_slaex3_m_nb, MAGMAF_GET_SLAEX3_M_NB )
magma_int_t magmaf_get_slaex3_m_nb(
     )
{
    return magma_get_slaex3_m_nb(
         );
}

#define magmaf_get_spotrf_nb FORTRAN_NAME( magmaf_get_spotrf_nb, MAGMAF_GET_SPOTRF_NB )
magma_int_t magmaf_get_spotrf_nb(
    magma_int_t *n )
{
    return magma_get_spotrf_nb(
        *n );
}

#define magmaf_get_sgetrf_nb FORTRAN_NAME( magmaf_get_sgetrf_nb, MAGMAF_GET_SGETRF_NB )
magma_int_t magmaf_get_sgetrf_nb(
    magma_int_t *m, magma_int_t *n )
{
    return magma_get_sgetrf_nb(
        *m, *n );
}

#define magmaf_get_sgetrf_native_nb FORTRAN_NAME( magmaf_get_sgetrf_native_nb, MAGMAF_GET_SGETRF_NATIVE_NB )
magma_int_t magmaf_get_sgetrf_native_nb(
    magma_int_t *m, magma_int_t *n )
{
    return magma_get_sgetrf_native_nb(
        *m, *n );
}

#define magmaf_get_sgetri_nb FORTRAN_NAME( magmaf_get_sgetri_nb, MAGMAF_GET_SGETRI_NB )
magma_int_t magmaf_get_sgetri_nb(
    magma_int_t *n )
{
    return magma_get_sgetri_nb(
        *n );
}

#define magmaf_get_ssytrf_nb FORTRAN_NAME( magmaf_get_ssytrf_nb, MAGMAF_GET_SSYTRF_NB )
magma_int_t magmaf_get_ssytrf_nb(
    magma_int_t *n )
{
    return magma_get_ssytrf_nb(
        *n );
}

#define magmaf_get_ssytrf_nopiv_nb FORTRAN_NAME( magmaf_get_ssytrf_nopiv_nb, MAGMAF_GET_SSYTRF_NOPIV_NB )
magma_int_t magmaf_get_ssytrf_nopiv_nb(
    magma_int_t *n )
{
    return magma_get_ssytrf_nopiv_nb(
        *n );
}

#define magmaf_get_ssytrf_aasen_nb FORTRAN_NAME( magmaf_get_ssytrf_aasen_nb, MAGMAF_GET_SSYTRF_AASEN_NB )
magma_int_t magmaf_get_ssytrf_aasen_nb(
    magma_int_t *n )
{
    return magma_get_ssytrf_aasen_nb(
        *n );
}

#define magmaf_get_sgeqp3_nb FORTRAN_NAME( magmaf_get_sgeqp3_nb, MAGMAF_GET_SGEQP3_NB )
magma_int_t magmaf_get_sgeqp3_nb(
    magma_int_t *m, magma_int_t *n )
{
    return magma_get_sgeqp3_nb(
        *m, *n );
}

#define magmaf_get_sgeqrf_nb FORTRAN_NAME( magmaf_get_sgeqrf_nb, MAGMAF_GET_SGEQRF_NB )
magma_int_t magmaf_get_sgeqrf_nb(
    magma_int_t *m, magma_int_t *n )
{
    return magma_get_sgeqrf_nb(
        *m, *n );
}

#define magmaf_get_sgeqlf_nb FORTRAN_NAME( magmaf_get_sgeqlf_nb, MAGMAF_GET_SGEQLF_NB )
magma_int_t magmaf_get_sgeqlf_nb(
    magma_int_t *m, magma_int_t *n )
{
    return magma_get_sgeqlf_nb(
        *m, *n );
}

#define magmaf_get_sgelqf_nb FORTRAN_NAME( magmaf_get_sgelqf_nb, MAGMAF_GET_SGELQF_NB )
magma_int_t magmaf_get_sgelqf_nb(
    magma_int_t *m, magma_int_t *n )
{
    return magma_get_sgelqf_nb(
        *m, *n );
}

#define magmaf_get_sgehrd_nb FORTRAN_NAME( magmaf_get_sgehrd_nb, MAGMAF_GET_SGEHRD_NB )
magma_int_t magmaf_get_sgehrd_nb(
    magma_int_t *n )
{
    return magma_get_sgehrd_nb(
        *n );
}

#define magmaf_get_ssytrd_nb FORTRAN_NAME( magmaf_get_ssytrd_nb, MAGMAF_GET_SSYTRD_NB )
magma_int_t magmaf_get_ssytrd_nb(
    magma_int_t *n )
{
    return magma_get_ssytrd_nb(
        *n );
}

#define magmaf_get_ssygst_nb FORTRAN_NAME( magmaf_get_ssygst_nb, MAGMAF_GET_SSYGST_NB )
magma_int_t magmaf_get_ssygst_nb(
    magma_int_t *n )
{
    return magma_get_ssygst_nb(
        *n );
}

#define magmaf_get_ssygst_m_nb FORTRAN_NAME( magmaf_get_ssygst_m_nb, MAGMAF_GET_SSYGST_M_NB )
magma_int_t magmaf_get_ssygst_m_nb(
    magma_int_t *n )
{
    return magma_get_ssygst_m_nb(
        *n );
}

#define magmaf_get_sgebrd_nb FORTRAN_NAME( magmaf_get_sgebrd_nb, MAGMAF_GET_SGEBRD_NB )
magma_int_t magmaf_get_sgebrd_nb(
    magma_int_t *m, magma_int_t *n )
{
    return magma_get_sgebrd_nb(
        *m, *n );
}

#define magmaf_get_sgesvd_nb FORTRAN_NAME( magmaf_get_sgesvd_nb, MAGMAF_GET_SGESVD_NB )
magma_int_t magmaf_get_sgesvd_nb(
    magma_int_t *m, magma_int_t *n )
{
    return magma_get_sgesvd_nb(
        *m, *n );
}

#define magmaf_get_sbulge_nb FORTRAN_NAME( magmaf_get_sbulge_nb, MAGMAF_GET_SBULGE_NB )
magma_int_t magmaf_get_sbulge_nb(
    magma_int_t *n, magma_int_t *nbthreads )
{
    return magma_get_sbulge_nb(
        *n, *nbthreads );
}

#define magmaf_get_sbulge_vblksiz FORTRAN_NAME( magmaf_get_sbulge_vblksiz, MAGMAF_GET_SBULGE_VBLKSIZ )
magma_int_t magmaf_get_sbulge_vblksiz(
    magma_int_t *n, magma_int_t *nb, magma_int_t *nbthreads )
{
    return magma_get_sbulge_vblksiz(
        *n, *nb, *nbthreads );
}

#define magmaf_get_sbulge_gcperf FORTRAN_NAME( magmaf_get_sbulge_gcperf, MAGMAF_GET_SBULGE_GCPERF )
magma_int_t magmaf_get_sbulge_gcperf(
     )
{
    return magma_get_sbulge_gcperf(
         );
}

#define magmaf_ssidi FORTRAN_NAME( magmaf_ssidi, MAGMAF_SSIDI )
void magmaf_ssidi(
    const char* uplo,
    float *A, magma_int_t *lda, magma_int_t *n,
    magma_int_t *ipiv,
    float *det,
    magma_int_t *inert,
    float *work, magma_int_t *job,
    magma_int_t *info )
{
    magma_ssidi(
        magma_uplo_const(*uplo),
        A, *lda, *n,
        ipiv,
        det,
        inert,
        work, *job,
        info );
}

#define magmaf_smove_eig FORTRAN_NAME( magmaf_smove_eig, MAGMAF_SMOVE_EIG )
void magmaf_smove_eig(
    const char* range, magma_int_t *n,
    float *w,
    magma_int_t *il,
    magma_int_t *iu, float *vl, float *vu,
    magma_int_t *mout )
{
    magma_smove_eig(
        magma_range_const(*range), *n,
        w,
        il,
        iu, *vl, *vu,
        mout );
}

#define magmaf_svrange FORTRAN_NAME( magmaf_svrange, MAGMAF_SVRANGE )
void magmaf_svrange(
    magma_int_t *k,
    float *d,
    magma_int_t *il,
    magma_int_t *iu, float *vl, float *vu )
{
    magma_svrange(
        *k,
        d,
        il,
        iu, *vl, *vu );
}

#define magmaf_sirange FORTRAN_NAME( magmaf_sirange, MAGMAF_SIRANGE )
void magmaf_sirange(
    magma_int_t *k,
    magma_int_t *indxq,
    magma_int_t *iil,
    magma_int_t *iiu, magma_int_t *il, magma_int_t *iu )
{
    magma_sirange(
        *k,
        indxq,
        iil,
        iiu, *il, *iu );
}

#define magmaf_sgbsv_native FORTRAN_NAME( magmaf_sgbsv_native, MAGMAF_SGBSV_NATIVE )
void magmaf_sgbsv_native(
    magma_int_t *n, magma_int_t *kl, magma_int_t *ku, magma_int_t *nrhs,
    float* dA, magma_int_t *ldda,
    magma_int_t* dipiv,
    float* dB, magma_int_t *lddb,
    magma_int_t *info )
{
    magma_sgbsv_native(
        *n, *kl, *ku, *nrhs,
        dA, *ldda,
        dipiv,
        dB, *lddb,
        info );
}

#define magmaf_sgbtrf_native FORTRAN_NAME( magmaf_sgbtrf_native, MAGMAF_SGBTRF_NATIVE )
void magmaf_sgbtrf_native(
    magma_int_t *m, magma_int_t *n, magma_int_t *kl, magma_int_t *ku,
    float* dAB, magma_int_t *lddab,
    magma_int_t* dipiv,
    magma_int_t *info )
{
    magma_sgbtrf_native(
        *m, *n, *kl, *ku,
        dAB, *lddab,
        dipiv,
        info );
}

#define magmaf_sgebrd FORTRAN_NAME( magmaf_sgebrd, MAGMAF_SGEBRD )
void magmaf_sgebrd(
    magma_int_t *m, magma_int_t *n,
    float *A, magma_int_t *lda,
    float *d,
    float *e,
    float *tauq,
    float *taup,
    float *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_sgebrd(
        *m, *n,
        A, *lda,
        d,
        e,
        tauq,
        taup,
        work, *lwork,
        info );
}

#define magmaf_sgeev FORTRAN_NAME( magmaf_sgeev, MAGMAF_SGEEV )
void magmaf_sgeev(
    const char* jobvl, const char* jobvr, magma_int_t *n,
    float *A, magma_int_t *lda,
    float *wr,
    float *wi,
    float *VL, magma_int_t *ldvl,
    float *VR, magma_int_t *ldvr,
    float *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_sgeev(
        magma_vec_const(*jobvl), magma_vec_const(*jobvr), *n,
        A, *lda,
        wr,
        wi,
        VL, *ldvl,
        VR, *ldvr,
        work, *lwork,
        info );
}

#define magmaf_sgeev_m FORTRAN_NAME( magmaf_sgeev_m, MAGMAF_SGEEV_M )
void magmaf_sgeev_m(
    const char* jobvl, const char* jobvr, magma_int_t *n,
    float *A, magma_int_t *lda,
    float *wr,
    float *wi,
    float *VL, magma_int_t *ldvl,
    float *VR, magma_int_t *ldvr,
    float *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_sgeev_m(
        magma_vec_const(*jobvl), magma_vec_const(*jobvr), *n,
        A, *lda,
        wr,
        wi,
        VL, *ldvl,
        VR, *ldvr,
        work, *lwork,
        info );
}

#define magmaf_sgegqr_gpu FORTRAN_NAME( magmaf_sgegqr_gpu, MAGMAF_SGEGQR_GPU )
void magmaf_sgegqr_gpu(
    magma_int_t *ikind, magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dwork,
    float *work,
    magma_int_t *info )
{
    magma_sgegqr_gpu(
        *ikind, *m, *n,
        magma_sdevptr(dA), *ldda,
        magma_sdevptr(dwork),
        work,
        info );
}

#define magmaf_sgehrd FORTRAN_NAME( magmaf_sgehrd, MAGMAF_SGEHRD )
void magmaf_sgehrd(
    magma_int_t *n, magma_int_t *ilo, magma_int_t *ihi,
    float *A, magma_int_t *lda,
    float *tau,
    float *work, magma_int_t *lwork,
    devptr_t *dT,
    magma_int_t *info )
{
    magma_sgehrd(
        *n, *ilo, *ihi,
        A, *lda,
        tau,
        work, *lwork,
        magma_sdevptr(dT),
        info );
}

#define magmaf_sgehrd_m FORTRAN_NAME( magmaf_sgehrd_m, MAGMAF_SGEHRD_M )
void magmaf_sgehrd_m(
    magma_int_t *n, magma_int_t *ilo, magma_int_t *ihi,
    float *A, magma_int_t *lda,
    float *tau,
    float *work, magma_int_t *lwork,
    float *T,
    magma_int_t *info )
{
    magma_sgehrd_m(
        *n, *ilo, *ihi,
        A, *lda,
        tau,
        work, *lwork,
        T,
        info );
}

#define magmaf_sgehrd2 FORTRAN_NAME( magmaf_sgehrd2, MAGMAF_SGEHRD2 )
void magmaf_sgehrd2(
    magma_int_t *n, magma_int_t *ilo, magma_int_t *ihi,
    float *A, magma_int_t *lda,
    float *tau,
    float *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_sgehrd2(
        *n, *ilo, *ihi,
        A, *lda,
        tau,
        work, *lwork,
        info );
}

#define magmaf_sgelqf FORTRAN_NAME( magmaf_sgelqf, MAGMAF_SGELQF )
void magmaf_sgelqf(
    magma_int_t *m, magma_int_t *n,
    float *A, magma_int_t *lda,
    float *tau,
    float *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_sgelqf(
        *m, *n,
        A, *lda,
        tau,
        work, *lwork,
        info );
}

#define magmaf_sgelqf_gpu FORTRAN_NAME( magmaf_sgelqf_gpu, MAGMAF_SGELQF_GPU )
void magmaf_sgelqf_gpu(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    float *tau,
    float *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_sgelqf_gpu(
        *m, *n,
        magma_sdevptr(dA), *ldda,
        tau,
        work, *lwork,
        info );
}

#define magmaf_sgels FORTRAN_NAME( magmaf_sgels, MAGMAF_SGELS )
void magmaf_sgels(
    const char* trans, magma_int_t *m, magma_int_t *n, magma_int_t *nrhs,
    devptr_t *A, magma_int_t *lda,
    devptr_t *B, magma_int_t *ldb,
    float *hwork, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_sgels(
        magma_trans_const(*trans), *m, *n, *nrhs,
        magma_sdevptr(A), *lda,
        magma_sdevptr(B), *ldb,
        hwork, *lwork,
        info );
}

#define magmaf_sggrqf FORTRAN_NAME( magmaf_sggrqf, MAGMAF_SGGRQF )
void magmaf_sggrqf(
    magma_int_t *m, magma_int_t *p, magma_int_t *n,
    float *A, magma_int_t *lda,
    float *taua,
    float *B, magma_int_t *ldb,
    float *taub,
    float *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_sggrqf(
        *m, *p, *n,
        A, *lda,
        taua,
        B, *ldb,
        taub,
        work, *lwork,
        info );
}

#define magmaf_sgglse FORTRAN_NAME( magmaf_sgglse, MAGMAF_SGGLSE )
void magmaf_sgglse(
    magma_int_t *m, magma_int_t *n, magma_int_t *p,
    float *A, magma_int_t *lda,
    float *B, magma_int_t *ldb,
    float *c,
    float *d,
    float *x,
    float *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_sgglse(
        *m, *n, *p,
        A, *lda,
        B, *ldb,
        c,
        d,
        x,
        work, *lwork,
        info );
}

#define magmaf_sgels_gpu FORTRAN_NAME( magmaf_sgels_gpu, MAGMAF_SGELS_GPU )
void magmaf_sgels_gpu(
    const char* trans, magma_int_t *m, magma_int_t *n, magma_int_t *nrhs,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb,
    float *hwork, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_sgels_gpu(
        magma_trans_const(*trans), *m, *n, *nrhs,
        magma_sdevptr(dA), *ldda,
        magma_sdevptr(dB), *lddb,
        hwork, *lwork,
        info );
}

#define magmaf_sgels3_gpu FORTRAN_NAME( magmaf_sgels3_gpu, MAGMAF_SGELS3_GPU )
void magmaf_sgels3_gpu(
    const char* trans, magma_int_t *m, magma_int_t *n, magma_int_t *nrhs,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb,
    float *hwork, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_sgels3_gpu(
        magma_trans_const(*trans), *m, *n, *nrhs,
        magma_sdevptr(dA), *ldda,
        magma_sdevptr(dB), *lddb,
        hwork, *lwork,
        info );
}

#define magmaf_sgeqlf FORTRAN_NAME( magmaf_sgeqlf, MAGMAF_SGEQLF )
void magmaf_sgeqlf(
    magma_int_t *m, magma_int_t *n,
    float *A, magma_int_t *lda,
    float *tau,
    float *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_sgeqlf(
        *m, *n,
        A, *lda,
        tau,
        work, *lwork,
        info );
}

#define magmaf_sgeqp3 FORTRAN_NAME( magmaf_sgeqp3, MAGMAF_SGEQP3 )
void magmaf_sgeqp3(
    magma_int_t *m, magma_int_t *n,
    float *A, magma_int_t *lda,
    magma_int_t *jpvt,
    float *tau,
    float *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_sgeqp3(
        *m, *n,
        A, *lda,
        jpvt,
        tau,
        work, *lwork,
        info );
}

#define magmaf_sgeqp3_gpu FORTRAN_NAME( magmaf_sgeqp3_gpu, MAGMAF_SGEQP3_GPU )
void magmaf_sgeqp3_gpu(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t *jpvt,
    float *tau,
    devptr_t *dwork, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_sgeqp3_gpu(
        *m, *n,
        magma_sdevptr(dA), *ldda,
        jpvt,
        tau,
        magma_sdevptr(dwork), *lwork,
        info );
}

#define magmaf_sgeqr2x_gpu FORTRAN_NAME( magmaf_sgeqr2x_gpu, MAGMAF_SGEQR2X_GPU )
void magmaf_sgeqr2x_gpu(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dtau,
    devptr_t *dT,
    devptr_t *ddA,
    devptr_t *dwork,
    magma_int_t *info )
{
    magma_sgeqr2x_gpu(
        *m, *n,
        magma_sdevptr(dA), *ldda,
        magma_sdevptr(dtau),
        magma_sdevptr(dT),
        magma_sdevptr(ddA),
        magma_sdevptr(dwork),
        info );
}

#define magmaf_sgeqr2x2_gpu FORTRAN_NAME( magmaf_sgeqr2x2_gpu, MAGMAF_SGEQR2X2_GPU )
void magmaf_sgeqr2x2_gpu(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dtau,
    devptr_t *dT,
    devptr_t *ddA,
    devptr_t *dwork,
    magma_int_t *info )
{
    magma_sgeqr2x2_gpu(
        *m, *n,
        magma_sdevptr(dA), *ldda,
        magma_sdevptr(dtau),
        magma_sdevptr(dT),
        magma_sdevptr(ddA),
        magma_sdevptr(dwork),
        info );
}

#define magmaf_sgeqr2x3_gpu FORTRAN_NAME( magmaf_sgeqr2x3_gpu, MAGMAF_SGEQR2X3_GPU )
void magmaf_sgeqr2x3_gpu(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dtau,
    devptr_t *dT,
    devptr_t *ddA,
    devptr_t *dwork,
    magma_int_t *info )
{
    magma_sgeqr2x3_gpu(
        *m, *n,
        magma_sdevptr(dA), *ldda,
        magma_sdevptr(dtau),
        magma_sdevptr(dT),
        magma_sdevptr(ddA),
        magma_sdevptr(dwork),
        info );
}

#define magmaf_sgeqr2x4_gpu FORTRAN_NAME( magmaf_sgeqr2x4_gpu, MAGMAF_SGEQR2X4_GPU )
void magmaf_sgeqr2x4_gpu(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dtau,
    devptr_t *dT,
    devptr_t *ddA,
    devptr_t *dwork, magma_queue_t *queue,
    magma_int_t *info )
{
    magma_sgeqr2x4_gpu(
        *m, *n,
        magma_sdevptr(dA), *ldda,
        magma_sdevptr(dtau),
        magma_sdevptr(dT),
        magma_sdevptr(ddA),
        magma_sdevptr(dwork), *queue,
        info );
}

#define magmaf_sgeqrf FORTRAN_NAME( magmaf_sgeqrf, MAGMAF_SGEQRF )
void magmaf_sgeqrf(
    magma_int_t *m, magma_int_t *n,
    float *A, magma_int_t *lda,
    float *tau,
    float *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_sgeqrf(
        *m, *n,
        A, *lda,
        tau,
        work, *lwork,
        info );
}

#define magmaf_sgeqrf_gpu FORTRAN_NAME( magmaf_sgeqrf_gpu, MAGMAF_SGEQRF_GPU )
void magmaf_sgeqrf_gpu(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    float *tau,
    devptr_t *dT,
    magma_int_t *info )
{
    magma_sgeqrf_gpu(
        *m, *n,
        magma_sdevptr(dA), *ldda,
        tau,
        magma_sdevptr(dT),
        info );
}

#define magmaf_sgeqrf_m FORTRAN_NAME( magmaf_sgeqrf_m, MAGMAF_SGEQRF_M )
void magmaf_sgeqrf_m(
    magma_int_t *ngpu, magma_int_t *m, magma_int_t *n,
    float *A, magma_int_t *lda,
    float *tau,
    float *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_sgeqrf_m(
        *ngpu, *m, *n,
        A, *lda,
        tau,
        work, *lwork,
        info );
}

#define magmaf_sgeqrf_ooc FORTRAN_NAME( magmaf_sgeqrf_ooc, MAGMAF_SGEQRF_OOC )
void magmaf_sgeqrf_ooc(
    magma_int_t *m, magma_int_t *n,
    float *A, magma_int_t *lda,
    float *tau,
    float *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_sgeqrf_ooc(
        *m, *n,
        A, *lda,
        tau,
        work, *lwork,
        info );
}

#define magmaf_sgeqrf2_gpu FORTRAN_NAME( magmaf_sgeqrf2_gpu, MAGMAF_SGEQRF2_GPU )
void magmaf_sgeqrf2_gpu(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    float *tau,
    magma_int_t *info )
{
    magma_sgeqrf2_gpu(
        *m, *n,
        magma_sdevptr(dA), *ldda,
        tau,
        info );
}

#define magmaf_sgeqrf3_gpu FORTRAN_NAME( magmaf_sgeqrf3_gpu, MAGMAF_SGEQRF3_GPU )
void magmaf_sgeqrf3_gpu(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    float *tau,
    devptr_t *dT,
    magma_int_t *info )
{
    magma_sgeqrf3_gpu(
        *m, *n,
        magma_sdevptr(dA), *ldda,
        tau,
        magma_sdevptr(dT),
        info );
}

#define magmaf_sgeqrs_gpu FORTRAN_NAME( magmaf_sgeqrs_gpu, MAGMAF_SGEQRS_GPU )
void magmaf_sgeqrs_gpu(
    magma_int_t *m, magma_int_t *n, magma_int_t *nrhs,
    devptr_t *dA, magma_int_t *ldda,
    float *tau,
    devptr_t *dT,
    devptr_t *dB, magma_int_t *lddb,
    float *hwork, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_sgeqrs_gpu(
        *m, *n, *nrhs,
        magma_sdevptr(dA), *ldda,
        tau,
        magma_sdevptr(dT),
        magma_sdevptr(dB), *lddb,
        hwork, *lwork,
        info );
}

#define magmaf_sgeqrs3_gpu FORTRAN_NAME( magmaf_sgeqrs3_gpu, MAGMAF_SGEQRS3_GPU )
void magmaf_sgeqrs3_gpu(
    magma_int_t *m, magma_int_t *n, magma_int_t *nrhs,
    devptr_t *dA, magma_int_t *ldda,
    float *tau,
    devptr_t *dT,
    devptr_t *dB, magma_int_t *lddb,
    float *hwork, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_sgeqrs3_gpu(
        *m, *n, *nrhs,
        magma_sdevptr(dA), *ldda,
        tau,
        magma_sdevptr(dT),
        magma_sdevptr(dB), *lddb,
        hwork, *lwork,
        info );
}

#define magmaf_sgerbt_gpu FORTRAN_NAME( magmaf_sgerbt_gpu, MAGMAF_SGERBT_GPU )
void magmaf_sgerbt_gpu(
    const char* gen, magma_int_t *n, magma_int_t *nrhs,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb,
    float *U,
    float *V,
    magma_int_t *info )
{
    magma_sgerbt_gpu(
        magma_bool_const(*gen), *n, *nrhs,
        magma_sdevptr(dA), *ldda,
        magma_sdevptr(dB), *lddb,
        U,
        V,
        info );
}

#define magmaf_sgerfs_nopiv_gpu FORTRAN_NAME( magmaf_sgerfs_nopiv_gpu, MAGMAF_SGERFS_NOPIV_GPU )
void magmaf_sgerfs_nopiv_gpu(
    const char* trans, magma_int_t *n, magma_int_t *nrhs,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb,
    devptr_t *dX, magma_int_t *lddx,
    devptr_t *dworkd,
    devptr_t *dAF,
    magma_int_t *iter,
    magma_int_t *info )
{
    magma_sgerfs_nopiv_gpu(
        magma_trans_const(*trans), *n, *nrhs,
        magma_sdevptr(dA), *ldda,
        magma_sdevptr(dB), *lddb,
        magma_sdevptr(dX), *lddx,
        magma_sdevptr(dworkd),
        magma_sdevptr(dAF),
        iter,
        info );
}

#define magmaf_sgesdd FORTRAN_NAME( magmaf_sgesdd, MAGMAF_SGESDD )
void magmaf_sgesdd(
    const char* jobz, magma_int_t *m, magma_int_t *n,
    float *A, magma_int_t *lda,
    float *s,
    float *U, magma_int_t *ldu,
    float *VT, magma_int_t *ldvt,
    float *work, magma_int_t *lwork,
    magma_int_t *iwork,
    magma_int_t *info )
{
    magma_sgesdd(
        magma_vec_const(*jobz), *m, *n,
        A, *lda,
        s,
        U, *ldu,
        VT, *ldvt,
        work, *lwork,
        iwork,
        info );
}

#define magmaf_sgesv FORTRAN_NAME( magmaf_sgesv, MAGMAF_SGESV )
void magmaf_sgesv(
    magma_int_t *n, magma_int_t *nrhs,
    float *A, magma_int_t *lda,
    magma_int_t *ipiv,
    float *B, magma_int_t *ldb,
    magma_int_t *info )
{
    magma_sgesv(
        *n, *nrhs,
        A, *lda,
        ipiv,
        B, *ldb,
        info );
}

#define magmaf_sgesv_gpu FORTRAN_NAME( magmaf_sgesv_gpu, MAGMAF_SGESV_GPU )
void magmaf_sgesv_gpu(
    magma_int_t *n, magma_int_t *nrhs,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t *ipiv,
    devptr_t *dB, magma_int_t *lddb,
    magma_int_t *info )
{
    magma_sgesv_gpu(
        *n, *nrhs,
        magma_sdevptr(dA), *ldda,
        ipiv,
        magma_sdevptr(dB), *lddb,
        info );
}

#define magmaf_sgesv_nopiv_gpu FORTRAN_NAME( magmaf_sgesv_nopiv_gpu, MAGMAF_SGESV_NOPIV_GPU )
void magmaf_sgesv_nopiv_gpu(
    magma_int_t *n, magma_int_t *nrhs,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb,
    magma_int_t *info )
{
    magma_sgesv_nopiv_gpu(
        *n, *nrhs,
        magma_sdevptr(dA), *ldda,
        magma_sdevptr(dB), *lddb,
        info );
}

#define magmaf_sgesv_rbt FORTRAN_NAME( magmaf_sgesv_rbt, MAGMAF_SGESV_RBT )
void magmaf_sgesv_rbt(
    const char* ref, magma_int_t *n, magma_int_t *nrhs,
    float *A, magma_int_t *lda,
    float *B, magma_int_t *ldb,
    magma_int_t *info )
{
    magma_sgesv_rbt(
        magma_bool_const(*ref), *n, *nrhs,
        A, *lda,
        B, *ldb,
        info );
}

#define magmaf_sgesvd FORTRAN_NAME( magmaf_sgesvd, MAGMAF_SGESVD )
void magmaf_sgesvd(
    const char* jobu, const char* jobvt, magma_int_t *m, magma_int_t *n,
    float *A, magma_int_t *lda,
    float *s,
    float *U, magma_int_t *ldu,
    float *VT, magma_int_t *ldvt,
    float *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_sgesvd(
        magma_vec_const(*jobu), magma_vec_const(*jobvt), *m, *n,
        A, *lda,
        s,
        U, *ldu,
        VT, *ldvt,
        work, *lwork,
        info );
}

#define magmaf_sgesvj_batched_strided FORTRAN_NAME( magmaf_sgesvj_batched_strided, MAGMAF_SGESVJ_BATCHED_STRIDED )
void magmaf_sgesvj_batched_strided(
    const char* jobu, const char* jobv, magma_int_t *morg, magma_int_t *norg,
    devptr_t *dA, magma_int_t *ldda, magma_int_t *strideA,
    devptr_t *dS, magma_int_t *strideS,
    devptr_t *dU, magma_int_t *lddu, magma_int_t *strideU,
    devptr_t *dV, magma_int_t *lddv, magma_int_t *strideV,
    devptr_t *dinfo_array, magma_int_t *batchCount, magma_queue_t *queue )
{
    magma_sgesvj_batched_strided(
        magma_vec_const(*jobu), magma_vec_const(*jobv), *morg, *norg,
        magma_sdevptr(dA), *ldda, *strideA,
        magma_sdevptr(dS), *strideS,
        magma_sdevptr(dU), *lddu, *strideU,
        magma_sdevptr(dV), *lddv, *strideV,
        magma_idevptr(dinfo_array), *batchCount, *queue );
}

#define magmaf_sgetf2_gpu FORTRAN_NAME( magmaf_sgetf2_gpu, MAGMAF_SGETF2_GPU )
void magmaf_sgetf2_gpu(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t *ipiv, magma_queue_t *queue,
    magma_int_t *info )
{
    magma_sgetf2_gpu(
        *m, *n,
        magma_sdevptr(dA), *ldda,
        ipiv, *queue,
        info );
}

#define magmaf_sgetf2_native_fused FORTRAN_NAME( magmaf_sgetf2_native_fused, MAGMAF_SGETF2_NATIVE_FUSED )
void magmaf_sgetf2_native_fused(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t *ipiv, magma_int_t *gbstep,
    magma_int_t *flags,
    magma_int_t *info, magma_queue_t *queue )
{
    magma_sgetf2_native_fused(
        *m, *n,
        magma_sdevptr(dA), *ldda,
        ipiv, *gbstep,
        flags,
        info, *queue );
}

#define magmaf_sgetf2_native FORTRAN_NAME( magmaf_sgetf2_native, MAGMAF_SGETF2_NATIVE )
magma_int_t magmaf_sgetf2_native(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t *dipiv,
    magma_int_t* dipivinfo,
    magma_int_t *dinfo, magma_int_t *gbstep,
    magma_event_t events[2], magma_queue_t *queue, magma_queue_t *update_queue )
{
    return magma_sgetf2_native(
        *m, *n,
        magma_sdevptr(dA), *ldda,
        dipiv,
        dipivinfo,
        dinfo, *gbstep,
        events, *queue, *update_queue );
}

#define magmaf_sgetf2_nopiv FORTRAN_NAME( magmaf_sgetf2_nopiv, MAGMAF_SGETF2_NOPIV )
void magmaf_sgetf2_nopiv(
    magma_int_t *m, magma_int_t *n,
    float *A, magma_int_t *lda,
    magma_int_t *info )
{
    magma_sgetf2_nopiv(
        *m, *n,
        A, *lda,
        info );
}

#define magmaf_sgetrf_recpanel_native FORTRAN_NAME( magmaf_sgetrf_recpanel_native, MAGMAF_SGETRF_RECPANEL_NATIVE )
magma_int_t magmaf_sgetrf_recpanel_native(
    magma_int_t *m, magma_int_t *n, magma_int_t *recnb,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t* dipiv,
    magma_int_t* dipivinfo,
    magma_int_t *dinfo, magma_int_t *gbstep,
    magma_event_t events[2], magma_queue_t *queue, magma_queue_t *update_queue )
{
    return magma_sgetrf_recpanel_native(
        *m, *n, *recnb,
        magma_sdevptr(dA), *ldda,
        dipiv,
        dipivinfo,
        dinfo, *gbstep,
        events, *queue, *update_queue );
}

#define magmaf_sgetrf FORTRAN_NAME( magmaf_sgetrf, MAGMAF_SGETRF )
void magmaf_sgetrf(
    magma_int_t *m, magma_int_t *n,
    float *A, magma_int_t *lda,
    magma_int_t *ipiv,
    magma_int_t *info )
{
    magma_sgetrf(
        *m, *n,
        A, *lda,
        ipiv,
        info );
}

#define magmaf_sgetrf_gpu FORTRAN_NAME( magmaf_sgetrf_gpu, MAGMAF_SGETRF_GPU )
void magmaf_sgetrf_gpu(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t *ipiv,
    magma_int_t *info )
{
    magma_sgetrf_gpu(
        *m, *n,
        magma_sdevptr(dA), *ldda,
        ipiv,
        info );
}

#define magmaf_sgetrf_native FORTRAN_NAME( magmaf_sgetrf_native, MAGMAF_SGETRF_NATIVE )
void magmaf_sgetrf_native(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t *ipiv,
    magma_int_t *info )
{
    magma_sgetrf_native(
        *m, *n,
        magma_sdevptr(dA), *ldda,
        ipiv,
        info );
}

#define magmaf_sgetrf_m FORTRAN_NAME( magmaf_sgetrf_m, MAGMAF_SGETRF_M )
void magmaf_sgetrf_m(
    magma_int_t *ngpu, magma_int_t *m, magma_int_t *n,
    float *A, magma_int_t *lda,
    magma_int_t *ipiv,
    magma_int_t *info )
{
    magma_sgetrf_m(
        *ngpu, *m, *n,
        A, *lda,
        ipiv,
        info );
}

#define magmaf_sgetrf_nopiv FORTRAN_NAME( magmaf_sgetrf_nopiv, MAGMAF_SGETRF_NOPIV )
void magmaf_sgetrf_nopiv(
    magma_int_t *m, magma_int_t *n,
    float *A, magma_int_t *lda,
    magma_int_t *info )
{
    magma_sgetrf_nopiv(
        *m, *n,
        A, *lda,
        info );
}

#define magmaf_sgetrf_nopiv_gpu FORTRAN_NAME( magmaf_sgetrf_nopiv_gpu, MAGMAF_SGETRF_NOPIV_GPU )
void magmaf_sgetrf_nopiv_gpu(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t *info )
{
    magma_sgetrf_nopiv_gpu(
        *m, *n,
        magma_sdevptr(dA), *ldda,
        info );
}

#define magmaf_sgetri_gpu FORTRAN_NAME( magmaf_sgetri_gpu, MAGMAF_SGETRI_GPU )
void magmaf_sgetri_gpu(
    magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t *ipiv,
    devptr_t *dwork, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_sgetri_gpu(
        *n,
        magma_sdevptr(dA), *ldda,
        ipiv,
        magma_sdevptr(dwork), *lwork,
        info );
}

#define magmaf_sgetrs_gpu FORTRAN_NAME( magmaf_sgetrs_gpu, MAGMAF_SGETRS_GPU )
void magmaf_sgetrs_gpu(
    const char* trans, magma_int_t *n, magma_int_t *nrhs,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t *ipiv,
    devptr_t *dB, magma_int_t *lddb,
    magma_int_t *info )
{
    magma_sgetrs_gpu(
        magma_trans_const(*trans), *n, *nrhs,
        magma_sdevptr(dA), *ldda,
        ipiv,
        magma_sdevptr(dB), *lddb,
        info );
}

#define magmaf_sgetrs_nopiv_gpu FORTRAN_NAME( magmaf_sgetrs_nopiv_gpu, MAGMAF_SGETRS_NOPIV_GPU )
void magmaf_sgetrs_nopiv_gpu(
    const char* trans, magma_int_t *n, magma_int_t *nrhs,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb,
    magma_int_t *info )
{
    magma_sgetrs_nopiv_gpu(
        magma_trans_const(*trans), *n, *nrhs,
        magma_sdevptr(dA), *ldda,
        magma_sdevptr(dB), *lddb,
        info );
}

#define magmaf_ssyevd FORTRAN_NAME( magmaf_ssyevd, MAGMAF_SSYEVD )
void magmaf_ssyevd(
    const char* jobz, const char* uplo, magma_int_t *n,
    float *A, magma_int_t *lda,
    float *w,
    float *work, magma_int_t *lwork,
    magma_int_t *iwork, magma_int_t *liwork,
    magma_int_t *info )
{
    magma_ssyevd(
        magma_vec_const(*jobz), magma_uplo_const(*uplo), *n,
        A, *lda,
        w,
        work, *lwork,
        iwork, *liwork,
        info );
}

#define magmaf_ssyevd_gpu FORTRAN_NAME( magmaf_ssyevd_gpu, MAGMAF_SSYEVD_GPU )
void magmaf_ssyevd_gpu(
    const char* jobz, const char* uplo, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    float *w,
    float *wA, magma_int_t *ldwa,
    float *work, magma_int_t *lwork,
    magma_int_t *iwork, magma_int_t *liwork,
    magma_int_t *info )
{
    magma_ssyevd_gpu(
        magma_vec_const(*jobz), magma_uplo_const(*uplo), *n,
        magma_sdevptr(dA), *ldda,
        w,
        wA, *ldwa,
        work, *lwork,
        iwork, *liwork,
        info );
}

#define magmaf_ssyevd_m FORTRAN_NAME( magmaf_ssyevd_m, MAGMAF_SSYEVD_M )
void magmaf_ssyevd_m(
    magma_int_t *ngpu, const char* jobz, const char* uplo, magma_int_t *n,
    float *A, magma_int_t *lda,
    float *w,
    float *work, magma_int_t *lwork,
    magma_int_t *iwork, magma_int_t *liwork,
    magma_int_t *info )
{
    magma_ssyevd_m(
        *ngpu, magma_vec_const(*jobz), magma_uplo_const(*uplo), *n,
        A, *lda,
        w,
        work, *lwork,
        iwork, *liwork,
        info );
}

#define magmaf_ssyevdx FORTRAN_NAME( magmaf_ssyevdx, MAGMAF_SSYEVDX )
void magmaf_ssyevdx(
    const char* jobz, const char* range, const char* uplo, magma_int_t *n,
    float *A, magma_int_t *lda, float *vl, float *vu, magma_int_t *il, magma_int_t *iu,
    magma_int_t *mout,
    float *w,
    float *work, magma_int_t *lwork,
    magma_int_t *iwork, magma_int_t *liwork,
    magma_int_t *info )
{
    magma_ssyevdx(
        magma_vec_const(*jobz), magma_range_const(*range), magma_uplo_const(*uplo), *n,
        A, *lda, *vl, *vu, *il, *iu,
        mout,
        w,
        work, *lwork,
        iwork, *liwork,
        info );
}

#define magmaf_ssyevdx_gpu FORTRAN_NAME( magmaf_ssyevdx_gpu, MAGMAF_SSYEVDX_GPU )
void magmaf_ssyevdx_gpu(
    const char* jobz, const char* range, const char* uplo, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda, float *vl, float *vu, magma_int_t *il, magma_int_t *iu,
    magma_int_t *mout,
    float *w,
    float *wA, magma_int_t *ldwa,
    float *work, magma_int_t *lwork,
    magma_int_t *iwork, magma_int_t *liwork,
    magma_int_t *info )
{
    magma_ssyevdx_gpu(
        magma_vec_const(*jobz), magma_range_const(*range), magma_uplo_const(*uplo), *n,
        magma_sdevptr(dA), *ldda, *vl, *vu, *il, *iu,
        mout,
        w,
        wA, *ldwa,
        work, *lwork,
        iwork, *liwork,
        info );
}

#define magmaf_ssyevdx_m FORTRAN_NAME( magmaf_ssyevdx_m, MAGMAF_SSYEVDX_M )
void magmaf_ssyevdx_m(
    magma_int_t *ngpu, const char* jobz, const char* range, const char* uplo, magma_int_t *n,
    float *A, magma_int_t *lda, float *vl, float *vu, magma_int_t *il, magma_int_t *iu,
    magma_int_t *mout,
    float *w,
    float *work, magma_int_t *lwork,
    magma_int_t *iwork, magma_int_t *liwork,
    magma_int_t *info )
{
    magma_ssyevdx_m(
        *ngpu, magma_vec_const(*jobz), magma_range_const(*range), magma_uplo_const(*uplo), *n,
        A, *lda, *vl, *vu, *il, *iu,
        mout,
        w,
        work, *lwork,
        iwork, *liwork,
        info );
}

#define magmaf_ssyevdx_2stage FORTRAN_NAME( magmaf_ssyevdx_2stage, MAGMAF_SSYEVDX_2STAGE )
void magmaf_ssyevdx_2stage(
    const char* jobz, const char* range, const char* uplo, magma_int_t *n,
    float *A, magma_int_t *lda, float *vl, float *vu, magma_int_t *il, magma_int_t *iu,
    magma_int_t *mout,
    float *w,
    float *work, magma_int_t *lwork,
    magma_int_t *iwork, magma_int_t *liwork,
    magma_int_t *info )
{
    magma_ssyevdx_2stage(
        magma_vec_const(*jobz), magma_range_const(*range), magma_uplo_const(*uplo), *n,
        A, *lda, *vl, *vu, *il, *iu,
        mout,
        w,
        work, *lwork,
        iwork, *liwork,
        info );
}

#define magmaf_ssyevdx_2stage_m FORTRAN_NAME( magmaf_ssyevdx_2stage_m, MAGMAF_SSYEVDX_2STAGE_M )
void magmaf_ssyevdx_2stage_m(
    magma_int_t *ngpu, const char* jobz, const char* range, const char* uplo, magma_int_t *n,
    float *A, magma_int_t *lda, float *vl, float *vu, magma_int_t *il, magma_int_t *iu,
    magma_int_t *mout,
    float *w,
    float *work, magma_int_t *lwork,
    magma_int_t *iwork, magma_int_t *liwork,
    magma_int_t *info )
{
    magma_ssyevdx_2stage_m(
        *ngpu, magma_vec_const(*jobz), magma_range_const(*range), magma_uplo_const(*uplo), *n,
        A, *lda, *vl, *vu, *il, *iu,
        mout,
        w,
        work, *lwork,
        iwork, *liwork,
        info );
}

#define magmaf_ssygst FORTRAN_NAME( magmaf_ssygst, MAGMAF_SSYGST )
void magmaf_ssygst(
    magma_int_t *itype, const char* uplo, magma_int_t *n,
    float *A, magma_int_t *lda,
    float *B, magma_int_t *ldb,
    magma_int_t *info )
{
    magma_ssygst(
        *itype, magma_uplo_const(*uplo), *n,
        A, *lda,
        B, *ldb,
        info );
}

#define magmaf_ssygst_gpu FORTRAN_NAME( magmaf_ssygst_gpu, MAGMAF_SSYGST_GPU )
void magmaf_ssygst_gpu(
    magma_int_t *itype, const char* uplo, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb,
    magma_int_t *info )
{
    magma_ssygst_gpu(
        *itype, magma_uplo_const(*uplo), *n,
        magma_sdevptr(dA), *ldda,
        magma_sdevptr(dB), *lddb,
        info );
}

#define magmaf_ssygst_m FORTRAN_NAME( magmaf_ssygst_m, MAGMAF_SSYGST_M )
void magmaf_ssygst_m(
    magma_int_t *ngpu, magma_int_t *itype, const char* uplo, magma_int_t *n,
    float *A, magma_int_t *lda,
    float *B, magma_int_t *ldb,
    magma_int_t *info )
{
    magma_ssygst_m(
        *ngpu, *itype, magma_uplo_const(*uplo), *n,
        A, *lda,
        B, *ldb,
        info );
}

#define magmaf_ssygvd FORTRAN_NAME( magmaf_ssygvd, MAGMAF_SSYGVD )
void magmaf_ssygvd(
    magma_int_t *itype, const char* jobz, const char* uplo, magma_int_t *n,
    float *A, magma_int_t *lda,
    float *B, magma_int_t *ldb,
    float *w,
    float *work, magma_int_t *lwork,
    magma_int_t *iwork, magma_int_t *liwork,
    magma_int_t *info )
{
    magma_ssygvd(
        *itype, magma_vec_const(*jobz), magma_uplo_const(*uplo), *n,
        A, *lda,
        B, *ldb,
        w,
        work, *lwork,
        iwork, *liwork,
        info );
}

#define magmaf_ssygvd_m FORTRAN_NAME( magmaf_ssygvd_m, MAGMAF_SSYGVD_M )
void magmaf_ssygvd_m(
    magma_int_t *ngpu, magma_int_t *itype, const char* jobz, const char* uplo, magma_int_t *n,
    float *A, magma_int_t *lda,
    float *B, magma_int_t *ldb,
    float *w,
    float *work, magma_int_t *lwork,
    magma_int_t *iwork, magma_int_t *liwork,
    magma_int_t *info )
{
    magma_ssygvd_m(
        *ngpu, *itype, magma_vec_const(*jobz), magma_uplo_const(*uplo), *n,
        A, *lda,
        B, *ldb,
        w,
        work, *lwork,
        iwork, *liwork,
        info );
}

#define magmaf_ssygvdx FORTRAN_NAME( magmaf_ssygvdx, MAGMAF_SSYGVDX )
void magmaf_ssygvdx(
    magma_int_t *itype, const char* jobz, const char* range, const char* uplo, magma_int_t *n,
    float *A, magma_int_t *lda,
    float *B, magma_int_t *ldb, float *vl, float *vu, magma_int_t *il, magma_int_t *iu,
    magma_int_t *mout,
    float *w,
    float *work, magma_int_t *lwork,
    magma_int_t *iwork, magma_int_t *liwork,
    magma_int_t *info )
{
    magma_ssygvdx(
        *itype, magma_vec_const(*jobz), magma_range_const(*range), magma_uplo_const(*uplo), *n,
        A, *lda,
        B, *ldb, *vl, *vu, *il, *iu,
        mout,
        w,
        work, *lwork,
        iwork, *liwork,
        info );
}

#define magmaf_ssygvdx_m FORTRAN_NAME( magmaf_ssygvdx_m, MAGMAF_SSYGVDX_M )
void magmaf_ssygvdx_m(
    magma_int_t *ngpu, magma_int_t *itype, const char* jobz, const char* range, const char* uplo, magma_int_t *n,
    float *A, magma_int_t *lda,
    float *B, magma_int_t *ldb, float *vl, float *vu, magma_int_t *il, magma_int_t *iu,
    magma_int_t *mout,
    float *w,
    float *work, magma_int_t *lwork,
    magma_int_t *iwork, magma_int_t *liwork,
    magma_int_t *info )
{
    magma_ssygvdx_m(
        *ngpu, *itype, magma_vec_const(*jobz), magma_range_const(*range), magma_uplo_const(*uplo), *n,
        A, *lda,
        B, *ldb, *vl, *vu, *il, *iu,
        mout,
        w,
        work, *lwork,
        iwork, *liwork,
        info );
}

#define magmaf_ssygvdx_2stage FORTRAN_NAME( magmaf_ssygvdx_2stage, MAGMAF_SSYGVDX_2STAGE )
void magmaf_ssygvdx_2stage(
    magma_int_t *itype, const char* jobz, const char* range, const char* uplo, magma_int_t *n,
    float *A, magma_int_t *lda,
    float *B, magma_int_t *ldb, float *vl, float *vu, magma_int_t *il, magma_int_t *iu,
    magma_int_t *mout,
    float *w,
    float *work, magma_int_t *lwork,
    magma_int_t *iwork, magma_int_t *liwork,
    magma_int_t *info )
{
    magma_ssygvdx_2stage(
        *itype, magma_vec_const(*jobz), magma_range_const(*range), magma_uplo_const(*uplo), *n,
        A, *lda,
        B, *ldb, *vl, *vu, *il, *iu,
        mout,
        w,
        work, *lwork,
        iwork, *liwork,
        info );
}

#define magmaf_ssygvdx_2stage_m FORTRAN_NAME( magmaf_ssygvdx_2stage_m, MAGMAF_SSYGVDX_2STAGE_M )
void magmaf_ssygvdx_2stage_m(
    magma_int_t *ngpu, magma_int_t *itype, const char* jobz, const char* range, const char* uplo, magma_int_t *n,
    float *A, magma_int_t *lda,
    float *B, magma_int_t *ldb, float *vl, float *vu, magma_int_t *il, magma_int_t *iu,
    magma_int_t *mout,
    float *w,
    float *work, magma_int_t *lwork,
    magma_int_t *iwork, magma_int_t *liwork,
    magma_int_t *info )
{
    magma_ssygvdx_2stage_m(
        *ngpu, *itype, magma_vec_const(*jobz), magma_range_const(*range), magma_uplo_const(*uplo), *n,
        A, *lda,
        B, *ldb, *vl, *vu, *il, *iu,
        mout,
        w,
        work, *lwork,
        iwork, *liwork,
        info );
}

#define magmaf_ssysv FORTRAN_NAME( magmaf_ssysv, MAGMAF_SSYSV )
void magmaf_ssysv(
    const char* uplo, magma_int_t *n, magma_int_t *nrhs,
    float *A, magma_int_t *lda,
    magma_int_t *ipiv,
    float *B, magma_int_t *ldb,
    magma_int_t *info )
{
    magma_ssysv(
        magma_uplo_const(*uplo), *n, *nrhs,
        A, *lda,
        ipiv,
        B, *ldb,
        info );
}

#define magmaf_ssysv_nopiv_gpu FORTRAN_NAME( magmaf_ssysv_nopiv_gpu, MAGMAF_SSYSV_NOPIV_GPU )
void magmaf_ssysv_nopiv_gpu(
    const char* uplo, magma_int_t *n, magma_int_t *nrhs,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb,
    magma_int_t *info )
{
    magma_ssysv_nopiv_gpu(
        magma_uplo_const(*uplo), *n, *nrhs,
        magma_sdevptr(dA), *ldda,
        magma_sdevptr(dB), *lddb,
        info );
}

#define magmaf_ssytrd FORTRAN_NAME( magmaf_ssytrd, MAGMAF_SSYTRD )
void magmaf_ssytrd(
    const char* uplo, magma_int_t *n,
    float *A, magma_int_t *lda,
    float *d,
    float *e,
    float *tau,
    float *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_ssytrd(
        magma_uplo_const(*uplo), *n,
        A, *lda,
        d,
        e,
        tau,
        work, *lwork,
        info );
}

#define magmaf_ssytrd_gpu FORTRAN_NAME( magmaf_ssytrd_gpu, MAGMAF_SSYTRD_GPU )
void magmaf_ssytrd_gpu(
    const char* uplo, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    float *d,
    float *e,
    float *tau,
    float *wA, magma_int_t *ldwa,
    float *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_ssytrd_gpu(
        magma_uplo_const(*uplo), *n,
        magma_sdevptr(dA), *ldda,
        d,
        e,
        tau,
        wA, *ldwa,
        work, *lwork,
        info );
}

#define magmaf_ssytrd2_gpu FORTRAN_NAME( magmaf_ssytrd2_gpu, MAGMAF_SSYTRD2_GPU )
void magmaf_ssytrd2_gpu(
    const char* uplo, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    float *d,
    float *e,
    float *tau,
    float *wA, magma_int_t *ldwa,
    float *work, magma_int_t *lwork,
    devptr_t *dwork, magma_int_t *ldwork,
    magma_int_t *info )
{
    magma_ssytrd2_gpu(
        magma_uplo_const(*uplo), *n,
        magma_sdevptr(dA), *ldda,
        d,
        e,
        tau,
        wA, *ldwa,
        work, *lwork,
        magma_sdevptr(dwork), *ldwork,
        info );
}

#define magmaf_ssytrd_sb2st FORTRAN_NAME( magmaf_ssytrd_sb2st, MAGMAF_SSYTRD_SB2ST )
magma_int_t magmaf_ssytrd_sb2st(
    const char* uplo, magma_int_t *n, magma_int_t *nb, magma_int_t *Vblksiz,
    float *A, magma_int_t *lda,
    float *d,
    float *e,
    float *V, magma_int_t *ldv,
    float *TAU, magma_int_t *compT,
    float *T, magma_int_t *ldt )
{
    return magma_ssytrd_sb2st(
        magma_uplo_const(*uplo), *n, *nb, *Vblksiz,
        A, *lda,
        d,
        e,
        V, *ldv,
        TAU, *compT,
        T, *ldt );
}

#define magmaf_ssytrd_sy2sb FORTRAN_NAME( magmaf_ssytrd_sy2sb, MAGMAF_SSYTRD_SY2SB )
void magmaf_ssytrd_sy2sb(
    const char* uplo, magma_int_t *n, magma_int_t *nb,
    float *A, magma_int_t *lda,
    float *tau,
    float *work, magma_int_t *lwork,
    devptr_t *dT,
    magma_int_t *info )
{
    magma_ssytrd_sy2sb(
        magma_uplo_const(*uplo), *n, *nb,
        A, *lda,
        tau,
        work, *lwork,
        magma_sdevptr(dT),
        info );
}

#define magmaf_ssytrf FORTRAN_NAME( magmaf_ssytrf, MAGMAF_SSYTRF )
void magmaf_ssytrf(
    const char* uplo, magma_int_t *n,
    float *A, magma_int_t *lda,
    magma_int_t *ipiv,
    magma_int_t *info )
{
    magma_ssytrf(
        magma_uplo_const(*uplo), *n,
        A, *lda,
        ipiv,
        info );
}

#define magmaf_ssytrf_gpu FORTRAN_NAME( magmaf_ssytrf_gpu, MAGMAF_SSYTRF_GPU )
void magmaf_ssytrf_gpu(
    const char* uplo, magma_int_t *n,
    float *dA, magma_int_t *ldda,
    magma_int_t *ipiv,
    magma_int_t *info )
{
    magma_ssytrf_gpu(
        magma_uplo_const(*uplo), *n,
        dA, *ldda,
        ipiv,
        info );
}

#define magmaf_ssytrf_aasen FORTRAN_NAME( magmaf_ssytrf_aasen, MAGMAF_SSYTRF_AASEN )
void magmaf_ssytrf_aasen(
    const char* uplo, magma_int_t *cpu_panel, magma_int_t *n,
    float *A, magma_int_t *lda,
    magma_int_t *ipiv,
    magma_int_t *info )
{
    magma_ssytrf_aasen(
        magma_uplo_const(*uplo), *cpu_panel, *n,
        A, *lda,
        ipiv,
        info );
}

#define magmaf_ssytrf_nopiv FORTRAN_NAME( magmaf_ssytrf_nopiv, MAGMAF_SSYTRF_NOPIV )
void magmaf_ssytrf_nopiv(
    const char* uplo, magma_int_t *n,
    float *A, magma_int_t *lda,
    magma_int_t *info )
{
    magma_ssytrf_nopiv(
        magma_uplo_const(*uplo), *n,
        A, *lda,
        info );
}

#define magmaf_ssytrf_nopiv_cpu FORTRAN_NAME( magmaf_ssytrf_nopiv_cpu, MAGMAF_SSYTRF_NOPIV_CPU )
void magmaf_ssytrf_nopiv_cpu(
    const char* uplo, magma_int_t *n, magma_int_t *ib,
    float *A, magma_int_t *lda,
    magma_int_t *info )
{
    magma_ssytrf_nopiv_cpu(
        magma_uplo_const(*uplo), *n, *ib,
        A, *lda,
        info );
}

#define magmaf_ssytrf_nopiv_gpu FORTRAN_NAME( magmaf_ssytrf_nopiv_gpu, MAGMAF_SSYTRF_NOPIV_GPU )
void magmaf_ssytrf_nopiv_gpu(
    const char* uplo, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t *info )
{
    magma_ssytrf_nopiv_gpu(
        magma_uplo_const(*uplo), *n,
        magma_sdevptr(dA), *ldda,
        info );
}

#define magmaf_ssytrs_nopiv_gpu FORTRAN_NAME( magmaf_ssytrs_nopiv_gpu, MAGMAF_SSYTRS_NOPIV_GPU )
void magmaf_ssytrs_nopiv_gpu(
    const char* uplo, magma_int_t *n, magma_int_t *nrhs,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb,
    magma_int_t *info )
{
    magma_ssytrs_nopiv_gpu(
        magma_uplo_const(*uplo), *n, *nrhs,
        magma_sdevptr(dA), *ldda,
        magma_sdevptr(dB), *lddb,
        info );
}

#define magmaf_slaln2 FORTRAN_NAME( magmaf_slaln2, MAGMAF_SLALN2 )
void magmaf_slaln2(
    magma_int_t *trans, magma_int_t *na, magma_int_t *nw, float *smin, float *ca,
    float *A, magma_int_t *lda, float *d1, float *d2,
    float *B, magma_int_t *ldb, float *wr, float *wi,
    float *X, magma_int_t *ldx,
    float *scale,
    float *xnorm,
    magma_int_t *info )
{
    magma_slaln2(
        *trans, *na, *nw, *smin, *ca,
        A, *lda, *d1, *d2,
        B, *ldb, *wr, *wi,
        X, *ldx,
        scale,
        xnorm,
        info );
}

#define magmaf_slaqtrsd FORTRAN_NAME( magmaf_slaqtrsd, MAGMAF_SLAQTRSD )
void magmaf_slaqtrsd(
    const char* trans, magma_int_t *n,
    float *T, magma_int_t *ldt,
    float *x, magma_int_t *ldx,
    float *cnorm,
    magma_int_t *info )
{
    magma_slaqtrsd(
        magma_trans_const(*trans), *n,
        T, *ldt,
        x, *ldx,
        cnorm,
        info );
}

#define magmaf_slarf_gpu FORTRAN_NAME( magmaf_slarf_gpu, MAGMAF_SLARF_GPU )
magma_int_t magmaf_slarf_gpu(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dv,
    devptr_t *dtau,
    devptr_t *dC, magma_int_t *lddc, magma_queue_t *queue )
{
    return magma_slarf_gpu(
        *m, *n,
        magma_sdevptr(dv),
        magma_sdevptr(dtau),
        magma_sdevptr(dC), *lddc, *queue );
}

#define magmaf_slarfb2_gpu FORTRAN_NAME( magmaf_slarfb2_gpu, MAGMAF_SLARFB2_GPU )
magma_int_t magmaf_slarfb2_gpu(
    magma_int_t *m, magma_int_t *n, magma_int_t *k,
    devptr_t *dV, magma_int_t *lddv,
    devptr_t *dT, magma_int_t *lddt,
    devptr_t *dC, magma_int_t *lddc,
    devptr_t *dwork, magma_int_t *ldwork, magma_queue_t *queue )
{
    return magma_slarfb2_gpu(
        *m, *n, *k,
        magma_sdevptr(dV), *lddv,
        magma_sdevptr(dT), *lddt,
        magma_sdevptr(dC), *lddc,
        magma_sdevptr(dwork), *ldwork, *queue );
}

#define magmaf_slauum FORTRAN_NAME( magmaf_slauum, MAGMAF_SLAUUM )
void magmaf_slauum(
    const char* uplo, magma_int_t *n,
    float *A, magma_int_t *lda,
    magma_int_t *info )
{
    magma_slauum(
        magma_uplo_const(*uplo), *n,
        A, *lda,
        info );
}

#define magmaf_slauum_gpu FORTRAN_NAME( magmaf_slauum_gpu, MAGMAF_SLAUUM_GPU )
void magmaf_slauum_gpu(
    const char* uplo, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t *info )
{
    magma_slauum_gpu(
        magma_uplo_const(*uplo), *n,
        magma_sdevptr(dA), *ldda,
        info );
}

#define magmaf_sposv FORTRAN_NAME( magmaf_sposv, MAGMAF_SPOSV )
void magmaf_sposv(
    const char* uplo, magma_int_t *n, magma_int_t *nrhs,
    float *A, magma_int_t *lda,
    float *B, magma_int_t *ldb,
    magma_int_t *info )
{
    magma_sposv(
        magma_uplo_const(*uplo), *n, *nrhs,
        A, *lda,
        B, *ldb,
        info );
}

#define magmaf_sposv_gpu FORTRAN_NAME( magmaf_sposv_gpu, MAGMAF_SPOSV_GPU )
void magmaf_sposv_gpu(
    const char* uplo, magma_int_t *n, magma_int_t *nrhs,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb,
    magma_int_t *info )
{
    magma_sposv_gpu(
        magma_uplo_const(*uplo), *n, *nrhs,
        magma_sdevptr(dA), *ldda,
        magma_sdevptr(dB), *lddb,
        info );
}

#define magmaf_spotf2_gpu FORTRAN_NAME( magmaf_spotf2_gpu, MAGMAF_SPOTF2_GPU )
void magmaf_spotf2_gpu(
    const char* uplo, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda, magma_queue_t *queue,
    magma_int_t *info )
{
    magma_spotf2_gpu(
        magma_uplo_const(*uplo), *n,
        magma_sdevptr(dA), *ldda, *queue,
        info );
}

#define magmaf_spotf2_native FORTRAN_NAME( magmaf_spotf2_native, MAGMAF_SPOTF2_NATIVE )
magma_int_t magmaf_spotf2_native(
    const char* uplo, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda, magma_int_t *step,
    magma_int_t *device_info, magma_queue_t *queue )
{
    return magma_spotf2_native(
        magma_uplo_const(*uplo), *n,
        magma_sdevptr(dA), *ldda, *step,
        device_info, *queue );
}

#define magmaf_spotrf_rectile_native FORTRAN_NAME( magmaf_spotrf_rectile_native, MAGMAF_SPOTRF_RECTILE_NATIVE )
void magmaf_spotrf_rectile_native(
    const char* uplo, magma_int_t *n, magma_int_t *recnb,
    float* dA, magma_int_t *ldda, magma_int_t *gbstep,
    magma_int_t *dinfo,
    magma_int_t *info, magma_queue_t *queue )
{
    magma_spotrf_rectile_native(
        magma_uplo_const(*uplo), *n, *recnb,
        dA, *ldda, *gbstep,
        dinfo,
        info, *queue );
}

#define magmaf_spotrf FORTRAN_NAME( magmaf_spotrf, MAGMAF_SPOTRF )
void magmaf_spotrf(
    const char* uplo, magma_int_t *n,
    float *A, magma_int_t *lda,
    magma_int_t *info )
{
    magma_spotrf(
        magma_uplo_const(*uplo), *n,
        A, *lda,
        info );
}

#define magmaf_spotrf_gpu FORTRAN_NAME( magmaf_spotrf_gpu, MAGMAF_SPOTRF_GPU )
void magmaf_spotrf_gpu(
    const char* uplo, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t *info )
{
    magma_spotrf_gpu(
        magma_uplo_const(*uplo), *n,
        magma_sdevptr(dA), *ldda,
        info );
}

#define magmaf_spotrf_native FORTRAN_NAME( magmaf_spotrf_native, MAGMAF_SPOTRF_NATIVE )
void magmaf_spotrf_native(
    const char* uplo, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t *info )
{
    magma_spotrf_native(
        magma_uplo_const(*uplo), *n,
        magma_sdevptr(dA), *ldda,
        info );
}

#define magmaf_spotrf_m FORTRAN_NAME( magmaf_spotrf_m, MAGMAF_SPOTRF_M )
void magmaf_spotrf_m(
    magma_int_t *ngpu, const char* uplo, magma_int_t *n,
    float *A, magma_int_t *lda,
    magma_int_t *info )
{
    magma_spotrf_m(
        *ngpu, magma_uplo_const(*uplo), *n,
        A, *lda,
        info );
}

#define magmaf_spotri FORTRAN_NAME( magmaf_spotri, MAGMAF_SPOTRI )
void magmaf_spotri(
    const char* uplo, magma_int_t *n,
    float *A, magma_int_t *lda,
    magma_int_t *info )
{
    magma_spotri(
        magma_uplo_const(*uplo), *n,
        A, *lda,
        info );
}

#define magmaf_spotri_gpu FORTRAN_NAME( magmaf_spotri_gpu, MAGMAF_SPOTRI_GPU )
void magmaf_spotri_gpu(
    const char* uplo, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t *info )
{
    magma_spotri_gpu(
        magma_uplo_const(*uplo), *n,
        magma_sdevptr(dA), *ldda,
        info );
}

#define magmaf_spotrs_gpu FORTRAN_NAME( magmaf_spotrs_gpu, MAGMAF_SPOTRS_GPU )
void magmaf_spotrs_gpu(
    const char* uplo, magma_int_t *n, magma_int_t *nrhs,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb,
    magma_int_t *info )
{
    magma_spotrs_gpu(
        magma_uplo_const(*uplo), *n, *nrhs,
        magma_sdevptr(dA), *ldda,
        magma_sdevptr(dB), *lddb,
        info );
}

#define magmaf_sstedx FORTRAN_NAME( magmaf_sstedx, MAGMAF_SSTEDX )
void magmaf_sstedx(
    const char* range, magma_int_t *n, float *vl, float *vu, magma_int_t *il, magma_int_t *iu,
    float *d,
    float *e,
    float *Z, magma_int_t *ldz,
    float *rwork, magma_int_t *lrwork,
    magma_int_t *iwork, magma_int_t *liwork,
    devptr_t *dwork,
    magma_int_t *info )
{
    magma_sstedx(
        magma_range_const(*range), *n, *vl, *vu, *il, *iu,
        d,
        e,
        Z, *ldz,
        rwork, *lrwork,
        iwork, *liwork,
        magma_sdevptr(dwork),
        info );
}

#define magmaf_sstedx_m FORTRAN_NAME( magmaf_sstedx_m, MAGMAF_SSTEDX_M )
void magmaf_sstedx_m(
    magma_int_t *ngpu, const char* range, magma_int_t *n, float *vl, float *vu, magma_int_t *il, magma_int_t *iu,
    float *d,
    float *e,
    float *Z, magma_int_t *ldz,
    float *rwork, magma_int_t *lrwork,
    magma_int_t *iwork, magma_int_t *liwork,
    magma_int_t *info )
{
    magma_sstedx_m(
        *ngpu, magma_range_const(*range), *n, *vl, *vu, *il, *iu,
        d,
        e,
        Z, *ldz,
        rwork, *lrwork,
        iwork, *liwork,
        info );
}

#define magmaf_strevc3 FORTRAN_NAME( magmaf_strevc3, MAGMAF_STREVC3 )
void magmaf_strevc3(
    const char* side, const char* howmany,
    magma_int_t *select, magma_int_t *n,
    float *T, magma_int_t *ldt,
    float *VL, magma_int_t *ldvl,
    float *VR, magma_int_t *ldvr, magma_int_t *mm,
    magma_int_t *mout,
    float *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_strevc3(
        magma_side_const(*side), magma_vec_const(*howmany),
        select, *n,
        T, *ldt,
        VL, *ldvl,
        VR, *ldvr, *mm,
        mout,
        work, *lwork,
        info );
}

#define magmaf_strevc3_mt FORTRAN_NAME( magmaf_strevc3_mt, MAGMAF_STREVC3_MT )
void magmaf_strevc3_mt(
    const char* side, const char* howmany,
    magma_int_t *select, magma_int_t *n,
    float *T, magma_int_t *ldt,
    float *VL, magma_int_t *ldvl,
    float *VR, magma_int_t *ldvr, magma_int_t *mm,
    magma_int_t *mout,
    float *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_strevc3_mt(
        magma_side_const(*side), magma_vec_const(*howmany),
        select, *n,
        T, *ldt,
        VL, *ldvl,
        VR, *ldvr, *mm,
        mout,
        work, *lwork,
        info );
}

#define magmaf_strsm_m FORTRAN_NAME( magmaf_strsm_m, MAGMAF_STRSM_M )
magma_int_t magmaf_strsm_m(
    magma_int_t *ngpu, const char* side, const char* uplo, const char* transa, const char* diag, magma_int_t *m, magma_int_t *n, float *alpha,
    float *A, magma_int_t *lda,
    float *B, magma_int_t *ldb )
{
    return magma_strsm_m(
        *ngpu, magma_side_const(*side), magma_uplo_const(*uplo), magma_trans_const(*transa), magma_diag_const(*diag), *m, *n, *alpha,
        A, *lda,
        B, *ldb );
}

#define magmaf_strtri FORTRAN_NAME( magmaf_strtri, MAGMAF_STRTRI )
void magmaf_strtri(
    const char* uplo, const char* diag, magma_int_t *n,
    float *A, magma_int_t *lda,
    magma_int_t *info )
{
    magma_strtri(
        magma_uplo_const(*uplo), magma_diag_const(*diag), *n,
        A, *lda,
        info );
}

#define magmaf_strtri_gpu FORTRAN_NAME( magmaf_strtri_gpu, MAGMAF_STRTRI_GPU )
void magmaf_strtri_gpu(
    const char* uplo, const char* diag, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t *info )
{
    magma_strtri_gpu(
        magma_uplo_const(*uplo), magma_diag_const(*diag), *n,
        magma_sdevptr(dA), *ldda,
        info );
}

#define magmaf_sorgbr FORTRAN_NAME( magmaf_sorgbr, MAGMAF_SORGBR )
void magmaf_sorgbr(
    const char* vect, magma_int_t *m, magma_int_t *n, magma_int_t *k,
    float *A, magma_int_t *lda,
    float *tau,
    float *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_sorgbr(
        magma_vect_const(*vect), *m, *n, *k,
        A, *lda,
        tau,
        work, *lwork,
        info );
}

#define magmaf_sorghr FORTRAN_NAME( magmaf_sorghr, MAGMAF_SORGHR )
void magmaf_sorghr(
    magma_int_t *n, magma_int_t *ilo, magma_int_t *ihi,
    float *A, magma_int_t *lda,
    float *tau,
    devptr_t *dT, magma_int_t *nb,
    magma_int_t *info )
{
    magma_sorghr(
        *n, *ilo, *ihi,
        A, *lda,
        tau,
        magma_sdevptr(dT), *nb,
        info );
}

#define magmaf_sorghr_m FORTRAN_NAME( magmaf_sorghr_m, MAGMAF_SORGHR_M )
void magmaf_sorghr_m(
    magma_int_t *n, magma_int_t *ilo, magma_int_t *ihi,
    float *A, magma_int_t *lda,
    float *tau,
    float *T, magma_int_t *nb,
    magma_int_t *info )
{
    magma_sorghr_m(
        *n, *ilo, *ihi,
        A, *lda,
        tau,
        T, *nb,
        info );
}

#define magmaf_sorglq FORTRAN_NAME( magmaf_sorglq, MAGMAF_SORGLQ )
void magmaf_sorglq(
    magma_int_t *m, magma_int_t *n, magma_int_t *k,
    float *A, magma_int_t *lda,
    float *tau,
    devptr_t *dT, magma_int_t *nb,
    magma_int_t *info )
{
    magma_sorglq(
        *m, *n, *k,
        A, *lda,
        tau,
        magma_sdevptr(dT), *nb,
        info );
}

#define magmaf_sorgqr FORTRAN_NAME( magmaf_sorgqr, MAGMAF_SORGQR )
void magmaf_sorgqr(
    magma_int_t *m, magma_int_t *n, magma_int_t *k,
    float *A, magma_int_t *lda,
    float *tau,
    devptr_t *dT, magma_int_t *nb,
    magma_int_t *info )
{
    magma_sorgqr(
        *m, *n, *k,
        A, *lda,
        tau,
        magma_sdevptr(dT), *nb,
        info );
}

#define magmaf_sorgqr_gpu FORTRAN_NAME( magmaf_sorgqr_gpu, MAGMAF_SORGQR_GPU )
void magmaf_sorgqr_gpu(
    magma_int_t *m, magma_int_t *n, magma_int_t *k,
    devptr_t *dA, magma_int_t *ldda,
    float *tau,
    devptr_t *dT, magma_int_t *nb,
    magma_int_t *info )
{
    magma_sorgqr_gpu(
        *m, *n, *k,
        magma_sdevptr(dA), *ldda,
        tau,
        magma_sdevptr(dT), *nb,
        info );
}

#define magmaf_sorgqr_m FORTRAN_NAME( magmaf_sorgqr_m, MAGMAF_SORGQR_M )
void magmaf_sorgqr_m(
    magma_int_t *m, magma_int_t *n, magma_int_t *k,
    float *A, magma_int_t *lda,
    float *tau,
    float *T, magma_int_t *nb,
    magma_int_t *info )
{
    magma_sorgqr_m(
        *m, *n, *k,
        A, *lda,
        tau,
        T, *nb,
        info );
}

#define magmaf_sorgqr2 FORTRAN_NAME( magmaf_sorgqr2, MAGMAF_SORGQR2 )
void magmaf_sorgqr2(
    magma_int_t *m, magma_int_t *n, magma_int_t *k,
    float *A, magma_int_t *lda,
    float *tau,
    magma_int_t *info )
{
    magma_sorgqr2(
        *m, *n, *k,
        A, *lda,
        tau,
        info );
}

#define magmaf_sormbr FORTRAN_NAME( magmaf_sormbr, MAGMAF_SORMBR )
void magmaf_sormbr(
    const char* vect, const char* side, const char* trans, magma_int_t *m, magma_int_t *n, magma_int_t *k,
    float *A, magma_int_t *lda,
    float *tau,
    float *C, magma_int_t *ldc,
    float *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_sormbr(
        magma_vect_const(*vect), magma_side_const(*side), magma_trans_const(*trans), *m, *n, *k,
        A, *lda,
        tau,
        C, *ldc,
        work, *lwork,
        info );
}

#define magmaf_sormlq FORTRAN_NAME( magmaf_sormlq, MAGMAF_SORMLQ )
void magmaf_sormlq(
    const char* side, const char* trans, magma_int_t *m, magma_int_t *n, magma_int_t *k,
    float *A, magma_int_t *lda,
    float *tau,
    float *C, magma_int_t *ldc,
    float *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_sormlq(
        magma_side_const(*side), magma_trans_const(*trans), *m, *n, *k,
        A, *lda,
        tau,
        C, *ldc,
        work, *lwork,
        info );
}

#define magmaf_sormrq FORTRAN_NAME( magmaf_sormrq, MAGMAF_SORMRQ )
void magmaf_sormrq(
    const char* side, const char* trans, magma_int_t *m, magma_int_t *n, magma_int_t *k,
    float *A, magma_int_t *lda,
    float *tau,
    float *C, magma_int_t *ldc,
    float *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_sormrq(
        magma_side_const(*side), magma_trans_const(*trans), *m, *n, *k,
        A, *lda,
        tau,
        C, *ldc,
        work, *lwork,
        info );
}

#define magmaf_sormql FORTRAN_NAME( magmaf_sormql, MAGMAF_SORMQL )
void magmaf_sormql(
    const char* side, const char* trans, magma_int_t *m, magma_int_t *n, magma_int_t *k,
    float *A, magma_int_t *lda,
    float *tau,
    float *C, magma_int_t *ldc,
    float *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_sormql(
        magma_side_const(*side), magma_trans_const(*trans), *m, *n, *k,
        A, *lda,
        tau,
        C, *ldc,
        work, *lwork,
        info );
}

#define magmaf_sormql2_gpu FORTRAN_NAME( magmaf_sormql2_gpu, MAGMAF_SORMQL2_GPU )
void magmaf_sormql2_gpu(
    const char* side, const char* trans, magma_int_t *m, magma_int_t *n, magma_int_t *k,
    devptr_t *dA, magma_int_t *ldda,
    float *tau,
    devptr_t *dC, magma_int_t *lddc,
    float *wA, magma_int_t *ldwa,
    magma_int_t *info )
{
    magma_sormql2_gpu(
        magma_side_const(*side), magma_trans_const(*trans), *m, *n, *k,
        magma_sdevptr(dA), *ldda,
        tau,
        magma_sdevptr(dC), *lddc,
        wA, *ldwa,
        info );
}

#define magmaf_sormqr FORTRAN_NAME( magmaf_sormqr, MAGMAF_SORMQR )
void magmaf_sormqr(
    const char* side, const char* trans, magma_int_t *m, magma_int_t *n, magma_int_t *k,
    float *A, magma_int_t *lda,
    float *tau,
    float *C, magma_int_t *ldc,
    float *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_sormqr(
        magma_side_const(*side), magma_trans_const(*trans), *m, *n, *k,
        A, *lda,
        tau,
        C, *ldc,
        work, *lwork,
        info );
}

#define magmaf_sormqr_gpu FORTRAN_NAME( magmaf_sormqr_gpu, MAGMAF_SORMQR_GPU )
void magmaf_sormqr_gpu(
    const char* side, const char* trans, magma_int_t *m, magma_int_t *n, magma_int_t *k,
    devptr_t *dA, magma_int_t *ldda,
    float *tau,
    devptr_t *dC, magma_int_t *lddc,
    float *hwork, magma_int_t *lwork,
    devptr_t *dT, magma_int_t *nb,
    magma_int_t *info )
{
    magma_sormqr_gpu(
        magma_side_const(*side), magma_trans_const(*trans), *m, *n, *k,
        magma_sdevptr(dA), *ldda,
        tau,
        magma_sdevptr(dC), *lddc,
        hwork, *lwork,
        magma_sdevptr(dT), *nb,
        info );
}

#define magmaf_sormqr2_gpu FORTRAN_NAME( magmaf_sormqr2_gpu, MAGMAF_SORMQR2_GPU )
void magmaf_sormqr2_gpu(
    const char* side, const char* trans, magma_int_t *m, magma_int_t *n, magma_int_t *k,
    devptr_t *dA, magma_int_t *ldda,
    float *tau,
    devptr_t *dC, magma_int_t *lddc,
    float *wA, magma_int_t *ldwa,
    magma_int_t *info )
{
    magma_sormqr2_gpu(
        magma_side_const(*side), magma_trans_const(*trans), *m, *n, *k,
        magma_sdevptr(dA), *ldda,
        tau,
        magma_sdevptr(dC), *lddc,
        wA, *ldwa,
        info );
}

#define magmaf_sormqr_m FORTRAN_NAME( magmaf_sormqr_m, MAGMAF_SORMQR_M )
void magmaf_sormqr_m(
    magma_int_t *ngpu, const char* side, const char* trans, magma_int_t *m, magma_int_t *n, magma_int_t *k,
    float *A, magma_int_t *lda,
    float *tau,
    float *C, magma_int_t *ldc,
    float *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_sormqr_m(
        *ngpu, magma_side_const(*side), magma_trans_const(*trans), *m, *n, *k,
        A, *lda,
        tau,
        C, *ldc,
        work, *lwork,
        info );
}

#define magmaf_sormtr FORTRAN_NAME( magmaf_sormtr, MAGMAF_SORMTR )
void magmaf_sormtr(
    const char* side, const char* uplo, const char* trans, magma_int_t *m, magma_int_t *n,
    float *A, magma_int_t *lda,
    float *tau,
    float *C, magma_int_t *ldc,
    float *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_sormtr(
        magma_side_const(*side), magma_uplo_const(*uplo), magma_trans_const(*trans), *m, *n,
        A, *lda,
        tau,
        C, *ldc,
        work, *lwork,
        info );
}

#define magmaf_sormtr_gpu FORTRAN_NAME( magmaf_sormtr_gpu, MAGMAF_SORMTR_GPU )
void magmaf_sormtr_gpu(
    const char* side, const char* uplo, const char* trans, magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    float *tau,
    devptr_t *dC, magma_int_t *lddc,
    float *wA, magma_int_t *ldwa,
    magma_int_t *info )
{
    magma_sormtr_gpu(
        magma_side_const(*side), magma_uplo_const(*uplo), magma_trans_const(*trans), *m, *n,
        magma_sdevptr(dA), *ldda,
        tau,
        magma_sdevptr(dC), *lddc,
        wA, *ldwa,
        info );
}

#define magmaf_sormtr_m FORTRAN_NAME( magmaf_sormtr_m, MAGMAF_SORMTR_M )
void magmaf_sormtr_m(
    magma_int_t *ngpu, const char* side, const char* uplo, const char* trans, magma_int_t *m, magma_int_t *n,
    float *A, magma_int_t *lda,
    float *tau,
    float *C, magma_int_t *ldc,
    float *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_sormtr_m(
        *ngpu, magma_side_const(*side), magma_uplo_const(*uplo), magma_trans_const(*trans), *m, *n,
        A, *lda,
        tau,
        C, *ldc,
        work, *lwork,
        info );
}

#define magmaf_s_isnan FORTRAN_NAME( magmaf_s_isnan, MAGMAF_S_ISNAN )
int magmaf_s_isnan(
    float *x )
{
    return magma_s_isnan(
        *x );
}

#define magmaf_s_isinf FORTRAN_NAME( magmaf_s_isinf, MAGMAF_S_ISINF )
int magmaf_s_isinf(
    float *x )
{
    return magma_s_isinf(
        *x );
}

#define magmaf_s_isnan_inf FORTRAN_NAME( magmaf_s_isnan_inf, MAGMAF_S_ISNAN_INF )
int magmaf_s_isnan_inf(
    float *x )
{
    return magma_s_isnan_inf(
        *x );
}

#define magmaf_smake_lwork FORTRAN_NAME( magmaf_smake_lwork, MAGMAF_SMAKE_LWORK )
float magmaf_smake_lwork(
    magma_int_t *lwork )
{
    return magma_smake_lwork(
        *lwork );
}

#define magmaf_snan_inf FORTRAN_NAME( magmaf_snan_inf, MAGMAF_SNAN_INF )
magma_int_t magmaf_snan_inf(
    const char* uplo, magma_int_t *m, magma_int_t *n,
    float *A, magma_int_t *lda,
    magma_int_t *cnt_nan,
    magma_int_t *cnt_inf )
{
    return magma_snan_inf(
        magma_uplo_const(*uplo), *m, *n,
        A, *lda,
        cnt_nan,
        cnt_inf );
}

#define magmaf_snan_inf_gpu FORTRAN_NAME( magmaf_snan_inf_gpu, MAGMAF_SNAN_INF_GPU )
magma_int_t magmaf_snan_inf_gpu(
    const char* uplo, magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t *cnt_nan,
    magma_int_t *cnt_inf, magma_queue_t *queue )
{
    return magma_snan_inf_gpu(
        magma_uplo_const(*uplo), *m, *n,
        magma_sdevptr(dA), *ldda,
        cnt_nan,
        cnt_inf, *queue );
}

#define magmaf_sprint FORTRAN_NAME( magmaf_sprint, MAGMAF_SPRINT )
void magmaf_sprint(
    magma_int_t *m, magma_int_t *n,
    float *A, magma_int_t *lda )
{
    magma_sprint(
        *m, *n,
        A, *lda );
}

#define magmaf_sprint_gpu FORTRAN_NAME( magmaf_sprint_gpu, MAGMAF_SPRINT_GPU )
void magmaf_sprint_gpu(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda, magma_queue_t *queue )
{
    magma_sprint_gpu(
        *m, *n,
        magma_sdevptr(dA), *ldda, *queue );
}

#define magmaf_spanel_to_q FORTRAN_NAME( magmaf_spanel_to_q, MAGMAF_SPANEL_TO_Q )
void magmaf_spanel_to_q(
    const char* uplo, magma_int_t *ib,
    float *A, magma_int_t *lda,
    float *work )
{
    magma_spanel_to_q(
        magma_uplo_const(*uplo), *ib,
        A, *lda,
        work );
}

#define magmaf_sq_to_panel FORTRAN_NAME( magmaf_sq_to_panel, MAGMAF_SQ_TO_PANEL )
void magmaf_sq_to_panel(
    const char* uplo, magma_int_t *ib,
    float *A, magma_int_t *lda,
    float *work )
{
    magma_sq_to_panel(
        magma_uplo_const(*uplo), *ib,
        A, *lda,
        work );
}

#define magmablasf_sextract_diag_sqrt FORTRAN_NAME( magmablasf_sextract_diag_sqrt, MAGMABLASF_SEXTRACT_DIAG_SQRT )
void magmablasf_sextract_diag_sqrt(
    magma_int_t *m, magma_int_t *n,
    float* dA, magma_int_t *ldda,
    float* dD, magma_int_t *incd, magma_queue_t *queue )
{
    magmablas_sextract_diag_sqrt(
        *m, *n,
        dA, *ldda,
        dD, *incd, *queue );
}

#define magmablasf_sscal_shift_hpd FORTRAN_NAME( magmablasf_sscal_shift_hpd, MAGMABLASF_SSCAL_SHIFT_HPD )
void magmablasf_sscal_shift_hpd(
    const char* uplo, int *n,
    float* dA, int *ldda,
    float* dD, int *incd, float *miu, float *cn, float *eps, magma_queue_t *queue )
{
    magmablas_sscal_shift_hpd(
        magma_uplo_const(*uplo), *n,
        dA, *ldda,
        dD, *incd, *miu, *cn, *eps, *queue );
}

#define magmablasf_sdimv_invert FORTRAN_NAME( magmablasf_sdimv_invert, MAGMABLASF_SDIMV_INVERT )
void magmablasf_sdimv_invert(
    magma_int_t *n, float *alpha,
    float* dD, magma_int_t *incd,
    float* dx, magma_int_t *incx, float *beta,
    float* dy, magma_int_t *incy, magma_queue_t *queue )
{
    magmablas_sdimv_invert(
        *n, *alpha,
        dD, *incd,
        dx, *incx, *beta,
        dy, *incy, *queue );
}


#ifdef __cplusplus
}
#endif
