/*******************************************************************************
 *  This file is AUTOMATICALLY GENERATED by:
 *  tools/fortran_wrappers.pl include/magma_d.i
 *  Do not edit.
 ******************************************************************************/

#include <stdint.h>  // for uintptr_t

#include "magma_v2.h"
#include "magma_mangling.h"

// typedef from CUDADIR/src/fortran.h directory
typedef size_t devptr_t;

#ifdef PGI_FORTRAN
    #define magma_devptr(ptr_)  ((void*)              (ptr_))
    #define magma_idevptr(ptr_) ((magma_int_t*)       (ptr_))
    #define magma_zdevptr(ptr_) ((magmaDoubleComplex*)(ptr_))
    #define magma_cdevptr(ptr_) ((magmaFloatComplex*) (ptr_))
    #define magma_ddevptr(ptr_) ((double*)            (ptr_))
    #define magma_sdevptr(ptr_) ((float*)             (ptr_))
#else
    #define magma_devptr(ptr_)  ((void*)              (uintptr_t)(*(ptr_)))
    #define magma_idevptr(ptr_) ((magma_int_t*)       (uintptr_t)(*(ptr_)))
    #define magma_zdevptr(ptr_) ((magmaDoubleComplex*)(uintptr_t)(*(ptr_)))
    #define magma_cdevptr(ptr_) ((magmaFloatComplex*) (uintptr_t)(*(ptr_)))
    #define magma_ddevptr(ptr_) ((double*)            (uintptr_t)(*(ptr_)))
    #define magma_sdevptr(ptr_) ((float*)             (uintptr_t)(*(ptr_)))
#endif

#ifdef __cplusplus
extern "C" {
#endif

#define magmaf_get_dlaex3_m_nb FORTRAN_NAME( magmaf_get_dlaex3_m_nb, MAGMAF_GET_DLAEX3_M_NB )
magma_int_t magmaf_get_dlaex3_m_nb(
     )
{
    return magma_get_dlaex3_m_nb(
         );
}

#define magmaf_get_dpotrf_nb FORTRAN_NAME( magmaf_get_dpotrf_nb, MAGMAF_GET_DPOTRF_NB )
magma_int_t magmaf_get_dpotrf_nb(
    magma_int_t *n )
{
    return magma_get_dpotrf_nb(
        *n );
}

#define magmaf_get_dgetrf_nb FORTRAN_NAME( magmaf_get_dgetrf_nb, MAGMAF_GET_DGETRF_NB )
magma_int_t magmaf_get_dgetrf_nb(
    magma_int_t *m, magma_int_t *n )
{
    return magma_get_dgetrf_nb(
        *m, *n );
}

#define magmaf_get_dgetrf_native_nb FORTRAN_NAME( magmaf_get_dgetrf_native_nb, MAGMAF_GET_DGETRF_NATIVE_NB )
magma_int_t magmaf_get_dgetrf_native_nb(
    magma_int_t *m, magma_int_t *n )
{
    return magma_get_dgetrf_native_nb(
        *m, *n );
}

#define magmaf_get_dgetri_nb FORTRAN_NAME( magmaf_get_dgetri_nb, MAGMAF_GET_DGETRI_NB )
magma_int_t magmaf_get_dgetri_nb(
    magma_int_t *n )
{
    return magma_get_dgetri_nb(
        *n );
}

#define magmaf_get_dsytrf_nb FORTRAN_NAME( magmaf_get_dsytrf_nb, MAGMAF_GET_DSYTRF_NB )
magma_int_t magmaf_get_dsytrf_nb(
    magma_int_t *n )
{
    return magma_get_dsytrf_nb(
        *n );
}

#define magmaf_get_dsytrf_nopiv_nb FORTRAN_NAME( magmaf_get_dsytrf_nopiv_nb, MAGMAF_GET_DSYTRF_NOPIV_NB )
magma_int_t magmaf_get_dsytrf_nopiv_nb(
    magma_int_t *n )
{
    return magma_get_dsytrf_nopiv_nb(
        *n );
}

#define magmaf_get_dsytrf_aasen_nb FORTRAN_NAME( magmaf_get_dsytrf_aasen_nb, MAGMAF_GET_DSYTRF_AASEN_NB )
magma_int_t magmaf_get_dsytrf_aasen_nb(
    magma_int_t *n )
{
    return magma_get_dsytrf_aasen_nb(
        *n );
}

#define magmaf_get_dgeqp3_nb FORTRAN_NAME( magmaf_get_dgeqp3_nb, MAGMAF_GET_DGEQP3_NB )
magma_int_t magmaf_get_dgeqp3_nb(
    magma_int_t *m, magma_int_t *n )
{
    return magma_get_dgeqp3_nb(
        *m, *n );
}

#define magmaf_get_dgeqrf_nb FORTRAN_NAME( magmaf_get_dgeqrf_nb, MAGMAF_GET_DGEQRF_NB )
magma_int_t magmaf_get_dgeqrf_nb(
    magma_int_t *m, magma_int_t *n )
{
    return magma_get_dgeqrf_nb(
        *m, *n );
}

#define magmaf_get_dgeqlf_nb FORTRAN_NAME( magmaf_get_dgeqlf_nb, MAGMAF_GET_DGEQLF_NB )
magma_int_t magmaf_get_dgeqlf_nb(
    magma_int_t *m, magma_int_t *n )
{
    return magma_get_dgeqlf_nb(
        *m, *n );
}

#define magmaf_get_dgelqf_nb FORTRAN_NAME( magmaf_get_dgelqf_nb, MAGMAF_GET_DGELQF_NB )
magma_int_t magmaf_get_dgelqf_nb(
    magma_int_t *m, magma_int_t *n )
{
    return magma_get_dgelqf_nb(
        *m, *n );
}

#define magmaf_get_dgehrd_nb FORTRAN_NAME( magmaf_get_dgehrd_nb, MAGMAF_GET_DGEHRD_NB )
magma_int_t magmaf_get_dgehrd_nb(
    magma_int_t *n )
{
    return magma_get_dgehrd_nb(
        *n );
}

#define magmaf_get_dsytrd_nb FORTRAN_NAME( magmaf_get_dsytrd_nb, MAGMAF_GET_DSYTRD_NB )
magma_int_t magmaf_get_dsytrd_nb(
    magma_int_t *n )
{
    return magma_get_dsytrd_nb(
        *n );
}

#define magmaf_get_dsygst_nb FORTRAN_NAME( magmaf_get_dsygst_nb, MAGMAF_GET_DSYGST_NB )
magma_int_t magmaf_get_dsygst_nb(
    magma_int_t *n )
{
    return magma_get_dsygst_nb(
        *n );
}

#define magmaf_get_dsygst_m_nb FORTRAN_NAME( magmaf_get_dsygst_m_nb, MAGMAF_GET_DSYGST_M_NB )
magma_int_t magmaf_get_dsygst_m_nb(
    magma_int_t *n )
{
    return magma_get_dsygst_m_nb(
        *n );
}

#define magmaf_get_dgebrd_nb FORTRAN_NAME( magmaf_get_dgebrd_nb, MAGMAF_GET_DGEBRD_NB )
magma_int_t magmaf_get_dgebrd_nb(
    magma_int_t *m, magma_int_t *n )
{
    return magma_get_dgebrd_nb(
        *m, *n );
}

#define magmaf_get_dgesvd_nb FORTRAN_NAME( magmaf_get_dgesvd_nb, MAGMAF_GET_DGESVD_NB )
magma_int_t magmaf_get_dgesvd_nb(
    magma_int_t *m, magma_int_t *n )
{
    return magma_get_dgesvd_nb(
        *m, *n );
}

#define magmaf_get_dbulge_nb FORTRAN_NAME( magmaf_get_dbulge_nb, MAGMAF_GET_DBULGE_NB )
magma_int_t magmaf_get_dbulge_nb(
    magma_int_t *n, magma_int_t *nbthreads )
{
    return magma_get_dbulge_nb(
        *n, *nbthreads );
}

#define magmaf_get_dbulge_vblksiz FORTRAN_NAME( magmaf_get_dbulge_vblksiz, MAGMAF_GET_DBULGE_VBLKSIZ )
magma_int_t magmaf_get_dbulge_vblksiz(
    magma_int_t *n, magma_int_t *nb, magma_int_t *nbthreads )
{
    return magma_get_dbulge_vblksiz(
        *n, *nb, *nbthreads );
}

#define magmaf_get_dbulge_gcperf FORTRAN_NAME( magmaf_get_dbulge_gcperf, MAGMAF_GET_DBULGE_GCPERF )
magma_int_t magmaf_get_dbulge_gcperf(
     )
{
    return magma_get_dbulge_gcperf(
         );
}

#define magmaf_dsidi FORTRAN_NAME( magmaf_dsidi, MAGMAF_DSIDI )
void magmaf_dsidi(
    const char* uplo,
    double *A, magma_int_t *lda, magma_int_t *n,
    magma_int_t *ipiv,
    double *det,
    magma_int_t *inert,
    double *work, magma_int_t *job,
    magma_int_t *info )
{
    magma_dsidi(
        magma_uplo_const(*uplo),
        A, *lda, *n,
        ipiv,
        det,
        inert,
        work, *job,
        info );
}

#define magmaf_dmove_eig FORTRAN_NAME( magmaf_dmove_eig, MAGMAF_DMOVE_EIG )
void magmaf_dmove_eig(
    const char* range, magma_int_t *n,
    double *w,
    magma_int_t *il,
    magma_int_t *iu, double *vl, double *vu,
    magma_int_t *mout )
{
    magma_dmove_eig(
        magma_range_const(*range), *n,
        w,
        il,
        iu, *vl, *vu,
        mout );
}

#define magmaf_dvrange FORTRAN_NAME( magmaf_dvrange, MAGMAF_DVRANGE )
void magmaf_dvrange(
    magma_int_t *k,
    double *d,
    magma_int_t *il,
    magma_int_t *iu, double *vl, double *vu )
{
    magma_dvrange(
        *k,
        d,
        il,
        iu, *vl, *vu );
}

#define magmaf_dirange FORTRAN_NAME( magmaf_dirange, MAGMAF_DIRANGE )
void magmaf_dirange(
    magma_int_t *k,
    magma_int_t *indxq,
    magma_int_t *iil,
    magma_int_t *iiu, magma_int_t *il, magma_int_t *iu )
{
    magma_dirange(
        *k,
        indxq,
        iil,
        iiu, *il, *iu );
}

#define magmaf_dgbsv_native FORTRAN_NAME( magmaf_dgbsv_native, MAGMAF_DGBSV_NATIVE )
void magmaf_dgbsv_native(
    magma_int_t *n, magma_int_t *kl, magma_int_t *ku, magma_int_t *nrhs,
    double* dA, magma_int_t *ldda,
    magma_int_t* dipiv,
    double* dB, magma_int_t *lddb,
    magma_int_t *info )
{
    magma_dgbsv_native(
        *n, *kl, *ku, *nrhs,
        dA, *ldda,
        dipiv,
        dB, *lddb,
        info );
}

#define magmaf_dgbtrf_native FORTRAN_NAME( magmaf_dgbtrf_native, MAGMAF_DGBTRF_NATIVE )
void magmaf_dgbtrf_native(
    magma_int_t *m, magma_int_t *n, magma_int_t *kl, magma_int_t *ku,
    double* dAB, magma_int_t *lddab,
    magma_int_t* dipiv,
    magma_int_t *info )
{
    magma_dgbtrf_native(
        *m, *n, *kl, *ku,
        dAB, *lddab,
        dipiv,
        info );
}

#define magmaf_dgebrd FORTRAN_NAME( magmaf_dgebrd, MAGMAF_DGEBRD )
void magmaf_dgebrd(
    magma_int_t *m, magma_int_t *n,
    double *A, magma_int_t *lda,
    double *d,
    double *e,
    double *tauq,
    double *taup,
    double *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_dgebrd(
        *m, *n,
        A, *lda,
        d,
        e,
        tauq,
        taup,
        work, *lwork,
        info );
}

#define magmaf_dgeev FORTRAN_NAME( magmaf_dgeev, MAGMAF_DGEEV )
void magmaf_dgeev(
    const char* jobvl, const char* jobvr, magma_int_t *n,
    double *A, magma_int_t *lda,
    double *wr,
    double *wi,
    double *VL, magma_int_t *ldvl,
    double *VR, magma_int_t *ldvr,
    double *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_dgeev(
        magma_vec_const(*jobvl), magma_vec_const(*jobvr), *n,
        A, *lda,
        wr,
        wi,
        VL, *ldvl,
        VR, *ldvr,
        work, *lwork,
        info );
}

#define magmaf_dgeev_m FORTRAN_NAME( magmaf_dgeev_m, MAGMAF_DGEEV_M )
void magmaf_dgeev_m(
    const char* jobvl, const char* jobvr, magma_int_t *n,
    double *A, magma_int_t *lda,
    double *wr,
    double *wi,
    double *VL, magma_int_t *ldvl,
    double *VR, magma_int_t *ldvr,
    double *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_dgeev_m(
        magma_vec_const(*jobvl), magma_vec_const(*jobvr), *n,
        A, *lda,
        wr,
        wi,
        VL, *ldvl,
        VR, *ldvr,
        work, *lwork,
        info );
}

#define magmaf_dgegqr_gpu FORTRAN_NAME( magmaf_dgegqr_gpu, MAGMAF_DGEGQR_GPU )
void magmaf_dgegqr_gpu(
    magma_int_t *ikind, magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dwork,
    double *work,
    magma_int_t *info )
{
    magma_dgegqr_gpu(
        *ikind, *m, *n,
        magma_ddevptr(dA), *ldda,
        magma_ddevptr(dwork),
        work,
        info );
}

#define magmaf_dgehrd FORTRAN_NAME( magmaf_dgehrd, MAGMAF_DGEHRD )
void magmaf_dgehrd(
    magma_int_t *n, magma_int_t *ilo, magma_int_t *ihi,
    double *A, magma_int_t *lda,
    double *tau,
    double *work, magma_int_t *lwork,
    devptr_t *dT,
    magma_int_t *info )
{
    magma_dgehrd(
        *n, *ilo, *ihi,
        A, *lda,
        tau,
        work, *lwork,
        magma_ddevptr(dT),
        info );
}

#define magmaf_dgehrd_m FORTRAN_NAME( magmaf_dgehrd_m, MAGMAF_DGEHRD_M )
void magmaf_dgehrd_m(
    magma_int_t *n, magma_int_t *ilo, magma_int_t *ihi,
    double *A, magma_int_t *lda,
    double *tau,
    double *work, magma_int_t *lwork,
    double *T,
    magma_int_t *info )
{
    magma_dgehrd_m(
        *n, *ilo, *ihi,
        A, *lda,
        tau,
        work, *lwork,
        T,
        info );
}

#define magmaf_dgehrd2 FORTRAN_NAME( magmaf_dgehrd2, MAGMAF_DGEHRD2 )
void magmaf_dgehrd2(
    magma_int_t *n, magma_int_t *ilo, magma_int_t *ihi,
    double *A, magma_int_t *lda,
    double *tau,
    double *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_dgehrd2(
        *n, *ilo, *ihi,
        A, *lda,
        tau,
        work, *lwork,
        info );
}

#define magmaf_dgelqf FORTRAN_NAME( magmaf_dgelqf, MAGMAF_DGELQF )
void magmaf_dgelqf(
    magma_int_t *m, magma_int_t *n,
    double *A, magma_int_t *lda,
    double *tau,
    double *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_dgelqf(
        *m, *n,
        A, *lda,
        tau,
        work, *lwork,
        info );
}

#define magmaf_dgelqf_gpu FORTRAN_NAME( magmaf_dgelqf_gpu, MAGMAF_DGELQF_GPU )
void magmaf_dgelqf_gpu(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    double *tau,
    double *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_dgelqf_gpu(
        *m, *n,
        magma_ddevptr(dA), *ldda,
        tau,
        work, *lwork,
        info );
}

#define magmaf_dgels FORTRAN_NAME( magmaf_dgels, MAGMAF_DGELS )
void magmaf_dgels(
    const char* trans, magma_int_t *m, magma_int_t *n, magma_int_t *nrhs,
    devptr_t *A, magma_int_t *lda,
    devptr_t *B, magma_int_t *ldb,
    double *hwork, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_dgels(
        magma_trans_const(*trans), *m, *n, *nrhs,
        magma_ddevptr(A), *lda,
        magma_ddevptr(B), *ldb,
        hwork, *lwork,
        info );
}

#define magmaf_dggrqf FORTRAN_NAME( magmaf_dggrqf, MAGMAF_DGGRQF )
void magmaf_dggrqf(
    magma_int_t *m, magma_int_t *p, magma_int_t *n,
    double *A, magma_int_t *lda,
    double *taua,
    double *B, magma_int_t *ldb,
    double *taub,
    double *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_dggrqf(
        *m, *p, *n,
        A, *lda,
        taua,
        B, *ldb,
        taub,
        work, *lwork,
        info );
}

#define magmaf_dgglse FORTRAN_NAME( magmaf_dgglse, MAGMAF_DGGLSE )
void magmaf_dgglse(
    magma_int_t *m, magma_int_t *n, magma_int_t *p,
    double *A, magma_int_t *lda,
    double *B, magma_int_t *ldb,
    double *c,
    double *d,
    double *x,
    double *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_dgglse(
        *m, *n, *p,
        A, *lda,
        B, *ldb,
        c,
        d,
        x,
        work, *lwork,
        info );
}

#define magmaf_dgels_gpu FORTRAN_NAME( magmaf_dgels_gpu, MAGMAF_DGELS_GPU )
void magmaf_dgels_gpu(
    const char* trans, magma_int_t *m, magma_int_t *n, magma_int_t *nrhs,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb,
    double *hwork, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_dgels_gpu(
        magma_trans_const(*trans), *m, *n, *nrhs,
        magma_ddevptr(dA), *ldda,
        magma_ddevptr(dB), *lddb,
        hwork, *lwork,
        info );
}

#define magmaf_dgels3_gpu FORTRAN_NAME( magmaf_dgels3_gpu, MAGMAF_DGELS3_GPU )
void magmaf_dgels3_gpu(
    const char* trans, magma_int_t *m, magma_int_t *n, magma_int_t *nrhs,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb,
    double *hwork, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_dgels3_gpu(
        magma_trans_const(*trans), *m, *n, *nrhs,
        magma_ddevptr(dA), *ldda,
        magma_ddevptr(dB), *lddb,
        hwork, *lwork,
        info );
}

#define magmaf_dgeqlf FORTRAN_NAME( magmaf_dgeqlf, MAGMAF_DGEQLF )
void magmaf_dgeqlf(
    magma_int_t *m, magma_int_t *n,
    double *A, magma_int_t *lda,
    double *tau,
    double *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_dgeqlf(
        *m, *n,
        A, *lda,
        tau,
        work, *lwork,
        info );
}

#define magmaf_dgeqp3 FORTRAN_NAME( magmaf_dgeqp3, MAGMAF_DGEQP3 )
void magmaf_dgeqp3(
    magma_int_t *m, magma_int_t *n,
    double *A, magma_int_t *lda,
    magma_int_t *jpvt,
    double *tau,
    double *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_dgeqp3(
        *m, *n,
        A, *lda,
        jpvt,
        tau,
        work, *lwork,
        info );
}

#define magmaf_dgeqp3_gpu FORTRAN_NAME( magmaf_dgeqp3_gpu, MAGMAF_DGEQP3_GPU )
void magmaf_dgeqp3_gpu(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t *jpvt,
    double *tau,
    devptr_t *dwork, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_dgeqp3_gpu(
        *m, *n,
        magma_ddevptr(dA), *ldda,
        jpvt,
        tau,
        magma_ddevptr(dwork), *lwork,
        info );
}

#define magmaf_dgeqr2x_gpu FORTRAN_NAME( magmaf_dgeqr2x_gpu, MAGMAF_DGEQR2X_GPU )
void magmaf_dgeqr2x_gpu(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dtau,
    devptr_t *dT,
    devptr_t *ddA,
    devptr_t *dwork,
    magma_int_t *info )
{
    magma_dgeqr2x_gpu(
        *m, *n,
        magma_ddevptr(dA), *ldda,
        magma_ddevptr(dtau),
        magma_ddevptr(dT),
        magma_ddevptr(ddA),
        magma_ddevptr(dwork),
        info );
}

#define magmaf_dgeqr2x2_gpu FORTRAN_NAME( magmaf_dgeqr2x2_gpu, MAGMAF_DGEQR2X2_GPU )
void magmaf_dgeqr2x2_gpu(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dtau,
    devptr_t *dT,
    devptr_t *ddA,
    devptr_t *dwork,
    magma_int_t *info )
{
    magma_dgeqr2x2_gpu(
        *m, *n,
        magma_ddevptr(dA), *ldda,
        magma_ddevptr(dtau),
        magma_ddevptr(dT),
        magma_ddevptr(ddA),
        magma_ddevptr(dwork),
        info );
}

#define magmaf_dgeqr2x3_gpu FORTRAN_NAME( magmaf_dgeqr2x3_gpu, MAGMAF_DGEQR2X3_GPU )
void magmaf_dgeqr2x3_gpu(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dtau,
    devptr_t *dT,
    devptr_t *ddA,
    devptr_t *dwork,
    magma_int_t *info )
{
    magma_dgeqr2x3_gpu(
        *m, *n,
        magma_ddevptr(dA), *ldda,
        magma_ddevptr(dtau),
        magma_ddevptr(dT),
        magma_ddevptr(ddA),
        magma_ddevptr(dwork),
        info );
}

#define magmaf_dgeqr2x4_gpu FORTRAN_NAME( magmaf_dgeqr2x4_gpu, MAGMAF_DGEQR2X4_GPU )
void magmaf_dgeqr2x4_gpu(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dtau,
    devptr_t *dT,
    devptr_t *ddA,
    devptr_t *dwork, magma_queue_t *queue,
    magma_int_t *info )
{
    magma_dgeqr2x4_gpu(
        *m, *n,
        magma_ddevptr(dA), *ldda,
        magma_ddevptr(dtau),
        magma_ddevptr(dT),
        magma_ddevptr(ddA),
        magma_ddevptr(dwork), *queue,
        info );
}

#define magmaf_dgeqrf FORTRAN_NAME( magmaf_dgeqrf, MAGMAF_DGEQRF )
void magmaf_dgeqrf(
    magma_int_t *m, magma_int_t *n,
    double *A, magma_int_t *lda,
    double *tau,
    double *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_dgeqrf(
        *m, *n,
        A, *lda,
        tau,
        work, *lwork,
        info );
}

#define magmaf_dgeqrf_gpu FORTRAN_NAME( magmaf_dgeqrf_gpu, MAGMAF_DGEQRF_GPU )
void magmaf_dgeqrf_gpu(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    double *tau,
    devptr_t *dT,
    magma_int_t *info )
{
    magma_dgeqrf_gpu(
        *m, *n,
        magma_ddevptr(dA), *ldda,
        tau,
        magma_ddevptr(dT),
        info );
}

#define magmaf_dgeqrf_m FORTRAN_NAME( magmaf_dgeqrf_m, MAGMAF_DGEQRF_M )
void magmaf_dgeqrf_m(
    magma_int_t *ngpu, magma_int_t *m, magma_int_t *n,
    double *A, magma_int_t *lda,
    double *tau,
    double *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_dgeqrf_m(
        *ngpu, *m, *n,
        A, *lda,
        tau,
        work, *lwork,
        info );
}

#define magmaf_dgeqrf_ooc FORTRAN_NAME( magmaf_dgeqrf_ooc, MAGMAF_DGEQRF_OOC )
void magmaf_dgeqrf_ooc(
    magma_int_t *m, magma_int_t *n,
    double *A, magma_int_t *lda,
    double *tau,
    double *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_dgeqrf_ooc(
        *m, *n,
        A, *lda,
        tau,
        work, *lwork,
        info );
}

#define magmaf_dgeqrf2_gpu FORTRAN_NAME( magmaf_dgeqrf2_gpu, MAGMAF_DGEQRF2_GPU )
void magmaf_dgeqrf2_gpu(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    double *tau,
    magma_int_t *info )
{
    magma_dgeqrf2_gpu(
        *m, *n,
        magma_ddevptr(dA), *ldda,
        tau,
        info );
}

#define magmaf_dgeqrf3_gpu FORTRAN_NAME( magmaf_dgeqrf3_gpu, MAGMAF_DGEQRF3_GPU )
void magmaf_dgeqrf3_gpu(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    double *tau,
    devptr_t *dT,
    magma_int_t *info )
{
    magma_dgeqrf3_gpu(
        *m, *n,
        magma_ddevptr(dA), *ldda,
        tau,
        magma_ddevptr(dT),
        info );
}

#define magmaf_dgeqrs_gpu FORTRAN_NAME( magmaf_dgeqrs_gpu, MAGMAF_DGEQRS_GPU )
void magmaf_dgeqrs_gpu(
    magma_int_t *m, magma_int_t *n, magma_int_t *nrhs,
    devptr_t *dA, magma_int_t *ldda,
    double *tau,
    devptr_t *dT,
    devptr_t *dB, magma_int_t *lddb,
    double *hwork, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_dgeqrs_gpu(
        *m, *n, *nrhs,
        magma_ddevptr(dA), *ldda,
        tau,
        magma_ddevptr(dT),
        magma_ddevptr(dB), *lddb,
        hwork, *lwork,
        info );
}

#define magmaf_dgeqrs3_gpu FORTRAN_NAME( magmaf_dgeqrs3_gpu, MAGMAF_DGEQRS3_GPU )
void magmaf_dgeqrs3_gpu(
    magma_int_t *m, magma_int_t *n, magma_int_t *nrhs,
    devptr_t *dA, magma_int_t *ldda,
    double *tau,
    devptr_t *dT,
    devptr_t *dB, magma_int_t *lddb,
    double *hwork, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_dgeqrs3_gpu(
        *m, *n, *nrhs,
        magma_ddevptr(dA), *ldda,
        tau,
        magma_ddevptr(dT),
        magma_ddevptr(dB), *lddb,
        hwork, *lwork,
        info );
}

#define magmaf_dgerbt_gpu FORTRAN_NAME( magmaf_dgerbt_gpu, MAGMAF_DGERBT_GPU )
void magmaf_dgerbt_gpu(
    const char* gen, magma_int_t *n, magma_int_t *nrhs,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb,
    double *U,
    double *V,
    magma_int_t *info )
{
    magma_dgerbt_gpu(
        magma_bool_const(*gen), *n, *nrhs,
        magma_ddevptr(dA), *ldda,
        magma_ddevptr(dB), *lddb,
        U,
        V,
        info );
}

#define magmaf_dgerfs_nopiv_gpu FORTRAN_NAME( magmaf_dgerfs_nopiv_gpu, MAGMAF_DGERFS_NOPIV_GPU )
void magmaf_dgerfs_nopiv_gpu(
    const char* trans, magma_int_t *n, magma_int_t *nrhs,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb,
    devptr_t *dX, magma_int_t *lddx,
    devptr_t *dworkd,
    devptr_t *dAF,
    magma_int_t *iter,
    magma_int_t *info )
{
    magma_dgerfs_nopiv_gpu(
        magma_trans_const(*trans), *n, *nrhs,
        magma_ddevptr(dA), *ldda,
        magma_ddevptr(dB), *lddb,
        magma_ddevptr(dX), *lddx,
        magma_ddevptr(dworkd),
        magma_ddevptr(dAF),
        iter,
        info );
}

#define magmaf_dgesdd FORTRAN_NAME( magmaf_dgesdd, MAGMAF_DGESDD )
void magmaf_dgesdd(
    const char* jobz, magma_int_t *m, magma_int_t *n,
    double *A, magma_int_t *lda,
    double *s,
    double *U, magma_int_t *ldu,
    double *VT, magma_int_t *ldvt,
    double *work, magma_int_t *lwork,
    magma_int_t *iwork,
    magma_int_t *info )
{
    magma_dgesdd(
        magma_vec_const(*jobz), *m, *n,
        A, *lda,
        s,
        U, *ldu,
        VT, *ldvt,
        work, *lwork,
        iwork,
        info );
}

#define magmaf_dgesv FORTRAN_NAME( magmaf_dgesv, MAGMAF_DGESV )
void magmaf_dgesv(
    magma_int_t *n, magma_int_t *nrhs,
    double *A, magma_int_t *lda,
    magma_int_t *ipiv,
    double *B, magma_int_t *ldb,
    magma_int_t *info )
{
    magma_dgesv(
        *n, *nrhs,
        A, *lda,
        ipiv,
        B, *ldb,
        info );
}

#define magmaf_dgesv_gpu FORTRAN_NAME( magmaf_dgesv_gpu, MAGMAF_DGESV_GPU )
void magmaf_dgesv_gpu(
    magma_int_t *n, magma_int_t *nrhs,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t *ipiv,
    devptr_t *dB, magma_int_t *lddb,
    magma_int_t *info )
{
    magma_dgesv_gpu(
        *n, *nrhs,
        magma_ddevptr(dA), *ldda,
        ipiv,
        magma_ddevptr(dB), *lddb,
        info );
}

#define magmaf_dgesv_nopiv_gpu FORTRAN_NAME( magmaf_dgesv_nopiv_gpu, MAGMAF_DGESV_NOPIV_GPU )
void magmaf_dgesv_nopiv_gpu(
    magma_int_t *n, magma_int_t *nrhs,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb,
    magma_int_t *info )
{
    magma_dgesv_nopiv_gpu(
        *n, *nrhs,
        magma_ddevptr(dA), *ldda,
        magma_ddevptr(dB), *lddb,
        info );
}

#define magmaf_dgesv_rbt FORTRAN_NAME( magmaf_dgesv_rbt, MAGMAF_DGESV_RBT )
void magmaf_dgesv_rbt(
    const char* ref, magma_int_t *n, magma_int_t *nrhs,
    double *A, magma_int_t *lda,
    double *B, magma_int_t *ldb,
    magma_int_t *info )
{
    magma_dgesv_rbt(
        magma_bool_const(*ref), *n, *nrhs,
        A, *lda,
        B, *ldb,
        info );
}

#define magmaf_dgesvd FORTRAN_NAME( magmaf_dgesvd, MAGMAF_DGESVD )
void magmaf_dgesvd(
    const char* jobu, const char* jobvt, magma_int_t *m, magma_int_t *n,
    double *A, magma_int_t *lda,
    double *s,
    double *U, magma_int_t *ldu,
    double *VT, magma_int_t *ldvt,
    double *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_dgesvd(
        magma_vec_const(*jobu), magma_vec_const(*jobvt), *m, *n,
        A, *lda,
        s,
        U, *ldu,
        VT, *ldvt,
        work, *lwork,
        info );
}

#define magmaf_dgesvj_batched_strided FORTRAN_NAME( magmaf_dgesvj_batched_strided, MAGMAF_DGESVJ_BATCHED_STRIDED )
void magmaf_dgesvj_batched_strided(
    const char* jobu, const char* jobv, magma_int_t *morg, magma_int_t *norg,
    devptr_t *dA, magma_int_t *ldda, magma_int_t *strideA,
    devptr_t *dS, magma_int_t *strideS,
    devptr_t *dU, magma_int_t *lddu, magma_int_t *strideU,
    devptr_t *dV, magma_int_t *lddv, magma_int_t *strideV,
    devptr_t *dinfo_array, magma_int_t *batchCount, magma_queue_t *queue )
{
    magma_dgesvj_batched_strided(
        magma_vec_const(*jobu), magma_vec_const(*jobv), *morg, *norg,
        magma_ddevptr(dA), *ldda, *strideA,
        magma_ddevptr(dS), *strideS,
        magma_ddevptr(dU), *lddu, *strideU,
        magma_ddevptr(dV), *lddv, *strideV,
        magma_idevptr(dinfo_array), *batchCount, *queue );
}

#define magmaf_dgetf2_gpu FORTRAN_NAME( magmaf_dgetf2_gpu, MAGMAF_DGETF2_GPU )
void magmaf_dgetf2_gpu(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t *ipiv, magma_queue_t *queue,
    magma_int_t *info )
{
    magma_dgetf2_gpu(
        *m, *n,
        magma_ddevptr(dA), *ldda,
        ipiv, *queue,
        info );
}

#define magmaf_dgetf2_native_fused FORTRAN_NAME( magmaf_dgetf2_native_fused, MAGMAF_DGETF2_NATIVE_FUSED )
void magmaf_dgetf2_native_fused(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t *ipiv, magma_int_t *gbstep,
    magma_int_t *flags,
    magma_int_t *info, magma_queue_t *queue )
{
    magma_dgetf2_native_fused(
        *m, *n,
        magma_ddevptr(dA), *ldda,
        ipiv, *gbstep,
        flags,
        info, *queue );
}

#define magmaf_dgetf2_native FORTRAN_NAME( magmaf_dgetf2_native, MAGMAF_DGETF2_NATIVE )
magma_int_t magmaf_dgetf2_native(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t *dipiv,
    magma_int_t* dipivinfo,
    magma_int_t *dinfo, magma_int_t *gbstep,
    magma_event_t events[2], magma_queue_t *queue, magma_queue_t *update_queue )
{
    return magma_dgetf2_native(
        *m, *n,
        magma_ddevptr(dA), *ldda,
        dipiv,
        dipivinfo,
        dinfo, *gbstep,
        events, *queue, *update_queue );
}

#define magmaf_dgetf2_nopiv FORTRAN_NAME( magmaf_dgetf2_nopiv, MAGMAF_DGETF2_NOPIV )
void magmaf_dgetf2_nopiv(
    magma_int_t *m, magma_int_t *n,
    double *A, magma_int_t *lda,
    magma_int_t *info )
{
    magma_dgetf2_nopiv(
        *m, *n,
        A, *lda,
        info );
}

#define magmaf_dgetrf_recpanel_native FORTRAN_NAME( magmaf_dgetrf_recpanel_native, MAGMAF_DGETRF_RECPANEL_NATIVE )
magma_int_t magmaf_dgetrf_recpanel_native(
    magma_int_t *m, magma_int_t *n, magma_int_t *recnb,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t* dipiv,
    magma_int_t* dipivinfo,
    magma_int_t *dinfo, magma_int_t *gbstep,
    magma_event_t events[2], magma_queue_t *queue, magma_queue_t *update_queue )
{
    return magma_dgetrf_recpanel_native(
        *m, *n, *recnb,
        magma_ddevptr(dA), *ldda,
        dipiv,
        dipivinfo,
        dinfo, *gbstep,
        events, *queue, *update_queue );
}

#define magmaf_dgetrf FORTRAN_NAME( magmaf_dgetrf, MAGMAF_DGETRF )
void magmaf_dgetrf(
    magma_int_t *m, magma_int_t *n,
    double *A, magma_int_t *lda,
    magma_int_t *ipiv,
    magma_int_t *info )
{
    magma_dgetrf(
        *m, *n,
        A, *lda,
        ipiv,
        info );
}

#define magmaf_dgetrf_gpu FORTRAN_NAME( magmaf_dgetrf_gpu, MAGMAF_DGETRF_GPU )
void magmaf_dgetrf_gpu(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t *ipiv,
    magma_int_t *info )
{
    magma_dgetrf_gpu(
        *m, *n,
        magma_ddevptr(dA), *ldda,
        ipiv,
        info );
}

#define magmaf_dgetrf_native FORTRAN_NAME( magmaf_dgetrf_native, MAGMAF_DGETRF_NATIVE )
void magmaf_dgetrf_native(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t *ipiv,
    magma_int_t *info )
{
    magma_dgetrf_native(
        *m, *n,
        magma_ddevptr(dA), *ldda,
        ipiv,
        info );
}

#define magmaf_dgetrf_m FORTRAN_NAME( magmaf_dgetrf_m, MAGMAF_DGETRF_M )
void magmaf_dgetrf_m(
    magma_int_t *ngpu, magma_int_t *m, magma_int_t *n,
    double *A, magma_int_t *lda,
    magma_int_t *ipiv,
    magma_int_t *info )
{
    magma_dgetrf_m(
        *ngpu, *m, *n,
        A, *lda,
        ipiv,
        info );
}

#define magmaf_dgetrf_nopiv FORTRAN_NAME( magmaf_dgetrf_nopiv, MAGMAF_DGETRF_NOPIV )
void magmaf_dgetrf_nopiv(
    magma_int_t *m, magma_int_t *n,
    double *A, magma_int_t *lda,
    magma_int_t *info )
{
    magma_dgetrf_nopiv(
        *m, *n,
        A, *lda,
        info );
}

#define magmaf_dgetrf_nopiv_gpu FORTRAN_NAME( magmaf_dgetrf_nopiv_gpu, MAGMAF_DGETRF_NOPIV_GPU )
void magmaf_dgetrf_nopiv_gpu(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t *info )
{
    magma_dgetrf_nopiv_gpu(
        *m, *n,
        magma_ddevptr(dA), *ldda,
        info );
}

#define magmaf_dgetri_gpu FORTRAN_NAME( magmaf_dgetri_gpu, MAGMAF_DGETRI_GPU )
void magmaf_dgetri_gpu(
    magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t *ipiv,
    devptr_t *dwork, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_dgetri_gpu(
        *n,
        magma_ddevptr(dA), *ldda,
        ipiv,
        magma_ddevptr(dwork), *lwork,
        info );
}

#define magmaf_dgetrs_gpu FORTRAN_NAME( magmaf_dgetrs_gpu, MAGMAF_DGETRS_GPU )
void magmaf_dgetrs_gpu(
    const char* trans, magma_int_t *n, magma_int_t *nrhs,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t *ipiv,
    devptr_t *dB, magma_int_t *lddb,
    magma_int_t *info )
{
    magma_dgetrs_gpu(
        magma_trans_const(*trans), *n, *nrhs,
        magma_ddevptr(dA), *ldda,
        ipiv,
        magma_ddevptr(dB), *lddb,
        info );
}

#define magmaf_dgetrs_nopiv_gpu FORTRAN_NAME( magmaf_dgetrs_nopiv_gpu, MAGMAF_DGETRS_NOPIV_GPU )
void magmaf_dgetrs_nopiv_gpu(
    const char* trans, magma_int_t *n, magma_int_t *nrhs,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb,
    magma_int_t *info )
{
    magma_dgetrs_nopiv_gpu(
        magma_trans_const(*trans), *n, *nrhs,
        magma_ddevptr(dA), *ldda,
        magma_ddevptr(dB), *lddb,
        info );
}

#define magmaf_dsyevd FORTRAN_NAME( magmaf_dsyevd, MAGMAF_DSYEVD )
void magmaf_dsyevd(
    const char* jobz, const char* uplo, magma_int_t *n,
    double *A, magma_int_t *lda,
    double *w,
    double *work, magma_int_t *lwork,
    magma_int_t *iwork, magma_int_t *liwork,
    magma_int_t *info )
{
    magma_dsyevd(
        magma_vec_const(*jobz), magma_uplo_const(*uplo), *n,
        A, *lda,
        w,
        work, *lwork,
        iwork, *liwork,
        info );
}

#define magmaf_dsyevd_gpu FORTRAN_NAME( magmaf_dsyevd_gpu, MAGMAF_DSYEVD_GPU )
void magmaf_dsyevd_gpu(
    const char* jobz, const char* uplo, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    double *w,
    double *wA, magma_int_t *ldwa,
    double *work, magma_int_t *lwork,
    magma_int_t *iwork, magma_int_t *liwork,
    magma_int_t *info )
{
    magma_dsyevd_gpu(
        magma_vec_const(*jobz), magma_uplo_const(*uplo), *n,
        magma_ddevptr(dA), *ldda,
        w,
        wA, *ldwa,
        work, *lwork,
        iwork, *liwork,
        info );
}

#define magmaf_dsyevd_m FORTRAN_NAME( magmaf_dsyevd_m, MAGMAF_DSYEVD_M )
void magmaf_dsyevd_m(
    magma_int_t *ngpu, const char* jobz, const char* uplo, magma_int_t *n,
    double *A, magma_int_t *lda,
    double *w,
    double *work, magma_int_t *lwork,
    magma_int_t *iwork, magma_int_t *liwork,
    magma_int_t *info )
{
    magma_dsyevd_m(
        *ngpu, magma_vec_const(*jobz), magma_uplo_const(*uplo), *n,
        A, *lda,
        w,
        work, *lwork,
        iwork, *liwork,
        info );
}

#define magmaf_dsyevdx FORTRAN_NAME( magmaf_dsyevdx, MAGMAF_DSYEVDX )
void magmaf_dsyevdx(
    const char* jobz, const char* range, const char* uplo, magma_int_t *n,
    double *A, magma_int_t *lda, double *vl, double *vu, magma_int_t *il, magma_int_t *iu,
    magma_int_t *mout,
    double *w,
    double *work, magma_int_t *lwork,
    magma_int_t *iwork, magma_int_t *liwork,
    magma_int_t *info )
{
    magma_dsyevdx(
        magma_vec_const(*jobz), magma_range_const(*range), magma_uplo_const(*uplo), *n,
        A, *lda, *vl, *vu, *il, *iu,
        mout,
        w,
        work, *lwork,
        iwork, *liwork,
        info );
}

#define magmaf_dsyevdx_gpu FORTRAN_NAME( magmaf_dsyevdx_gpu, MAGMAF_DSYEVDX_GPU )
void magmaf_dsyevdx_gpu(
    const char* jobz, const char* range, const char* uplo, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda, double *vl, double *vu, magma_int_t *il, magma_int_t *iu,
    magma_int_t *mout,
    double *w,
    double *wA, magma_int_t *ldwa,
    double *work, magma_int_t *lwork,
    magma_int_t *iwork, magma_int_t *liwork,
    magma_int_t *info )
{
    magma_dsyevdx_gpu(
        magma_vec_const(*jobz), magma_range_const(*range), magma_uplo_const(*uplo), *n,
        magma_ddevptr(dA), *ldda, *vl, *vu, *il, *iu,
        mout,
        w,
        wA, *ldwa,
        work, *lwork,
        iwork, *liwork,
        info );
}

#define magmaf_dsyevdx_m FORTRAN_NAME( magmaf_dsyevdx_m, MAGMAF_DSYEVDX_M )
void magmaf_dsyevdx_m(
    magma_int_t *ngpu, const char* jobz, const char* range, const char* uplo, magma_int_t *n,
    double *A, magma_int_t *lda, double *vl, double *vu, magma_int_t *il, magma_int_t *iu,
    magma_int_t *mout,
    double *w,
    double *work, magma_int_t *lwork,
    magma_int_t *iwork, magma_int_t *liwork,
    magma_int_t *info )
{
    magma_dsyevdx_m(
        *ngpu, magma_vec_const(*jobz), magma_range_const(*range), magma_uplo_const(*uplo), *n,
        A, *lda, *vl, *vu, *il, *iu,
        mout,
        w,
        work, *lwork,
        iwork, *liwork,
        info );
}

#define magmaf_dsyevdx_2stage FORTRAN_NAME( magmaf_dsyevdx_2stage, MAGMAF_DSYEVDX_2STAGE )
void magmaf_dsyevdx_2stage(
    const char* jobz, const char* range, const char* uplo, magma_int_t *n,
    double *A, magma_int_t *lda, double *vl, double *vu, magma_int_t *il, magma_int_t *iu,
    magma_int_t *mout,
    double *w,
    double *work, magma_int_t *lwork,
    magma_int_t *iwork, magma_int_t *liwork,
    magma_int_t *info )
{
    magma_dsyevdx_2stage(
        magma_vec_const(*jobz), magma_range_const(*range), magma_uplo_const(*uplo), *n,
        A, *lda, *vl, *vu, *il, *iu,
        mout,
        w,
        work, *lwork,
        iwork, *liwork,
        info );
}

#define magmaf_dsyevdx_2stage_m FORTRAN_NAME( magmaf_dsyevdx_2stage_m, MAGMAF_DSYEVDX_2STAGE_M )
void magmaf_dsyevdx_2stage_m(
    magma_int_t *ngpu, const char* jobz, const char* range, const char* uplo, magma_int_t *n,
    double *A, magma_int_t *lda, double *vl, double *vu, magma_int_t *il, magma_int_t *iu,
    magma_int_t *mout,
    double *w,
    double *work, magma_int_t *lwork,
    magma_int_t *iwork, magma_int_t *liwork,
    magma_int_t *info )
{
    magma_dsyevdx_2stage_m(
        *ngpu, magma_vec_const(*jobz), magma_range_const(*range), magma_uplo_const(*uplo), *n,
        A, *lda, *vl, *vu, *il, *iu,
        mout,
        w,
        work, *lwork,
        iwork, *liwork,
        info );
}

#define magmaf_dsygst FORTRAN_NAME( magmaf_dsygst, MAGMAF_DSYGST )
void magmaf_dsygst(
    magma_int_t *itype, const char* uplo, magma_int_t *n,
    double *A, magma_int_t *lda,
    double *B, magma_int_t *ldb,
    magma_int_t *info )
{
    magma_dsygst(
        *itype, magma_uplo_const(*uplo), *n,
        A, *lda,
        B, *ldb,
        info );
}

#define magmaf_dsygst_gpu FORTRAN_NAME( magmaf_dsygst_gpu, MAGMAF_DSYGST_GPU )
void magmaf_dsygst_gpu(
    magma_int_t *itype, const char* uplo, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb,
    magma_int_t *info )
{
    magma_dsygst_gpu(
        *itype, magma_uplo_const(*uplo), *n,
        magma_ddevptr(dA), *ldda,
        magma_ddevptr(dB), *lddb,
        info );
}

#define magmaf_dsygst_m FORTRAN_NAME( magmaf_dsygst_m, MAGMAF_DSYGST_M )
void magmaf_dsygst_m(
    magma_int_t *ngpu, magma_int_t *itype, const char* uplo, magma_int_t *n,
    double *A, magma_int_t *lda,
    double *B, magma_int_t *ldb,
    magma_int_t *info )
{
    magma_dsygst_m(
        *ngpu, *itype, magma_uplo_const(*uplo), *n,
        A, *lda,
        B, *ldb,
        info );
}

#define magmaf_dsygvd FORTRAN_NAME( magmaf_dsygvd, MAGMAF_DSYGVD )
void magmaf_dsygvd(
    magma_int_t *itype, const char* jobz, const char* uplo, magma_int_t *n,
    double *A, magma_int_t *lda,
    double *B, magma_int_t *ldb,
    double *w,
    double *work, magma_int_t *lwork,
    magma_int_t *iwork, magma_int_t *liwork,
    magma_int_t *info )
{
    magma_dsygvd(
        *itype, magma_vec_const(*jobz), magma_uplo_const(*uplo), *n,
        A, *lda,
        B, *ldb,
        w,
        work, *lwork,
        iwork, *liwork,
        info );
}

#define magmaf_dsygvd_m FORTRAN_NAME( magmaf_dsygvd_m, MAGMAF_DSYGVD_M )
void magmaf_dsygvd_m(
    magma_int_t *ngpu, magma_int_t *itype, const char* jobz, const char* uplo, magma_int_t *n,
    double *A, magma_int_t *lda,
    double *B, magma_int_t *ldb,
    double *w,
    double *work, magma_int_t *lwork,
    magma_int_t *iwork, magma_int_t *liwork,
    magma_int_t *info )
{
    magma_dsygvd_m(
        *ngpu, *itype, magma_vec_const(*jobz), magma_uplo_const(*uplo), *n,
        A, *lda,
        B, *ldb,
        w,
        work, *lwork,
        iwork, *liwork,
        info );
}

#define magmaf_dsygvdx FORTRAN_NAME( magmaf_dsygvdx, MAGMAF_DSYGVDX )
void magmaf_dsygvdx(
    magma_int_t *itype, const char* jobz, const char* range, const char* uplo, magma_int_t *n,
    double *A, magma_int_t *lda,
    double *B, magma_int_t *ldb, double *vl, double *vu, magma_int_t *il, magma_int_t *iu,
    magma_int_t *mout,
    double *w,
    double *work, magma_int_t *lwork,
    magma_int_t *iwork, magma_int_t *liwork,
    magma_int_t *info )
{
    magma_dsygvdx(
        *itype, magma_vec_const(*jobz), magma_range_const(*range), magma_uplo_const(*uplo), *n,
        A, *lda,
        B, *ldb, *vl, *vu, *il, *iu,
        mout,
        w,
        work, *lwork,
        iwork, *liwork,
        info );
}

#define magmaf_dsygvdx_m FORTRAN_NAME( magmaf_dsygvdx_m, MAGMAF_DSYGVDX_M )
void magmaf_dsygvdx_m(
    magma_int_t *ngpu, magma_int_t *itype, const char* jobz, const char* range, const char* uplo, magma_int_t *n,
    double *A, magma_int_t *lda,
    double *B, magma_int_t *ldb, double *vl, double *vu, magma_int_t *il, magma_int_t *iu,
    magma_int_t *mout,
    double *w,
    double *work, magma_int_t *lwork,
    magma_int_t *iwork, magma_int_t *liwork,
    magma_int_t *info )
{
    magma_dsygvdx_m(
        *ngpu, *itype, magma_vec_const(*jobz), magma_range_const(*range), magma_uplo_const(*uplo), *n,
        A, *lda,
        B, *ldb, *vl, *vu, *il, *iu,
        mout,
        w,
        work, *lwork,
        iwork, *liwork,
        info );
}

#define magmaf_dsygvdx_2stage FORTRAN_NAME( magmaf_dsygvdx_2stage, MAGMAF_DSYGVDX_2STAGE )
void magmaf_dsygvdx_2stage(
    magma_int_t *itype, const char* jobz, const char* range, const char* uplo, magma_int_t *n,
    double *A, magma_int_t *lda,
    double *B, magma_int_t *ldb, double *vl, double *vu, magma_int_t *il, magma_int_t *iu,
    magma_int_t *mout,
    double *w,
    double *work, magma_int_t *lwork,
    magma_int_t *iwork, magma_int_t *liwork,
    magma_int_t *info )
{
    magma_dsygvdx_2stage(
        *itype, magma_vec_const(*jobz), magma_range_const(*range), magma_uplo_const(*uplo), *n,
        A, *lda,
        B, *ldb, *vl, *vu, *il, *iu,
        mout,
        w,
        work, *lwork,
        iwork, *liwork,
        info );
}

#define magmaf_dsygvdx_2stage_m FORTRAN_NAME( magmaf_dsygvdx_2stage_m, MAGMAF_DSYGVDX_2STAGE_M )
void magmaf_dsygvdx_2stage_m(
    magma_int_t *ngpu, magma_int_t *itype, const char* jobz, const char* range, const char* uplo, magma_int_t *n,
    double *A, magma_int_t *lda,
    double *B, magma_int_t *ldb, double *vl, double *vu, magma_int_t *il, magma_int_t *iu,
    magma_int_t *mout,
    double *w,
    double *work, magma_int_t *lwork,
    magma_int_t *iwork, magma_int_t *liwork,
    magma_int_t *info )
{
    magma_dsygvdx_2stage_m(
        *ngpu, *itype, magma_vec_const(*jobz), magma_range_const(*range), magma_uplo_const(*uplo), *n,
        A, *lda,
        B, *ldb, *vl, *vu, *il, *iu,
        mout,
        w,
        work, *lwork,
        iwork, *liwork,
        info );
}

#define magmaf_dsysv FORTRAN_NAME( magmaf_dsysv, MAGMAF_DSYSV )
void magmaf_dsysv(
    const char* uplo, magma_int_t *n, magma_int_t *nrhs,
    double *A, magma_int_t *lda,
    magma_int_t *ipiv,
    double *B, magma_int_t *ldb,
    magma_int_t *info )
{
    magma_dsysv(
        magma_uplo_const(*uplo), *n, *nrhs,
        A, *lda,
        ipiv,
        B, *ldb,
        info );
}

#define magmaf_dsysv_nopiv_gpu FORTRAN_NAME( magmaf_dsysv_nopiv_gpu, MAGMAF_DSYSV_NOPIV_GPU )
void magmaf_dsysv_nopiv_gpu(
    const char* uplo, magma_int_t *n, magma_int_t *nrhs,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb,
    magma_int_t *info )
{
    magma_dsysv_nopiv_gpu(
        magma_uplo_const(*uplo), *n, *nrhs,
        magma_ddevptr(dA), *ldda,
        magma_ddevptr(dB), *lddb,
        info );
}

#define magmaf_dsytrd FORTRAN_NAME( magmaf_dsytrd, MAGMAF_DSYTRD )
void magmaf_dsytrd(
    const char* uplo, magma_int_t *n,
    double *A, magma_int_t *lda,
    double *d,
    double *e,
    double *tau,
    double *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_dsytrd(
        magma_uplo_const(*uplo), *n,
        A, *lda,
        d,
        e,
        tau,
        work, *lwork,
        info );
}

#define magmaf_dsytrd_gpu FORTRAN_NAME( magmaf_dsytrd_gpu, MAGMAF_DSYTRD_GPU )
void magmaf_dsytrd_gpu(
    const char* uplo, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    double *d,
    double *e,
    double *tau,
    double *wA, magma_int_t *ldwa,
    double *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_dsytrd_gpu(
        magma_uplo_const(*uplo), *n,
        magma_ddevptr(dA), *ldda,
        d,
        e,
        tau,
        wA, *ldwa,
        work, *lwork,
        info );
}

#define magmaf_dsytrd2_gpu FORTRAN_NAME( magmaf_dsytrd2_gpu, MAGMAF_DSYTRD2_GPU )
void magmaf_dsytrd2_gpu(
    const char* uplo, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    double *d,
    double *e,
    double *tau,
    double *wA, magma_int_t *ldwa,
    double *work, magma_int_t *lwork,
    devptr_t *dwork, magma_int_t *ldwork,
    magma_int_t *info )
{
    magma_dsytrd2_gpu(
        magma_uplo_const(*uplo), *n,
        magma_ddevptr(dA), *ldda,
        d,
        e,
        tau,
        wA, *ldwa,
        work, *lwork,
        magma_ddevptr(dwork), *ldwork,
        info );
}

#define magmaf_dsytrd_sb2st FORTRAN_NAME( magmaf_dsytrd_sb2st, MAGMAF_DSYTRD_SB2ST )
magma_int_t magmaf_dsytrd_sb2st(
    const char* uplo, magma_int_t *n, magma_int_t *nb, magma_int_t *Vblksiz,
    double *A, magma_int_t *lda,
    double *d,
    double *e,
    double *V, magma_int_t *ldv,
    double *TAU, magma_int_t *compT,
    double *T, magma_int_t *ldt )
{
    return magma_dsytrd_sb2st(
        magma_uplo_const(*uplo), *n, *nb, *Vblksiz,
        A, *lda,
        d,
        e,
        V, *ldv,
        TAU, *compT,
        T, *ldt );
}

#define magmaf_dsytrd_sy2sb FORTRAN_NAME( magmaf_dsytrd_sy2sb, MAGMAF_DSYTRD_SY2SB )
void magmaf_dsytrd_sy2sb(
    const char* uplo, magma_int_t *n, magma_int_t *nb,
    double *A, magma_int_t *lda,
    double *tau,
    double *work, magma_int_t *lwork,
    devptr_t *dT,
    magma_int_t *info )
{
    magma_dsytrd_sy2sb(
        magma_uplo_const(*uplo), *n, *nb,
        A, *lda,
        tau,
        work, *lwork,
        magma_ddevptr(dT),
        info );
}

#define magmaf_dsytrf FORTRAN_NAME( magmaf_dsytrf, MAGMAF_DSYTRF )
void magmaf_dsytrf(
    const char* uplo, magma_int_t *n,
    double *A, magma_int_t *lda,
    magma_int_t *ipiv,
    magma_int_t *info )
{
    magma_dsytrf(
        magma_uplo_const(*uplo), *n,
        A, *lda,
        ipiv,
        info );
}

#define magmaf_dsytrf_gpu FORTRAN_NAME( magmaf_dsytrf_gpu, MAGMAF_DSYTRF_GPU )
void magmaf_dsytrf_gpu(
    const char* uplo, magma_int_t *n,
    double *dA, magma_int_t *ldda,
    magma_int_t *ipiv,
    magma_int_t *info )
{
    magma_dsytrf_gpu(
        magma_uplo_const(*uplo), *n,
        dA, *ldda,
        ipiv,
        info );
}

#define magmaf_dsytrf_aasen FORTRAN_NAME( magmaf_dsytrf_aasen, MAGMAF_DSYTRF_AASEN )
void magmaf_dsytrf_aasen(
    const char* uplo, magma_int_t *cpu_panel, magma_int_t *n,
    double *A, magma_int_t *lda,
    magma_int_t *ipiv,
    magma_int_t *info )
{
    magma_dsytrf_aasen(
        magma_uplo_const(*uplo), *cpu_panel, *n,
        A, *lda,
        ipiv,
        info );
}

#define magmaf_dsytrf_nopiv FORTRAN_NAME( magmaf_dsytrf_nopiv, MAGMAF_DSYTRF_NOPIV )
void magmaf_dsytrf_nopiv(
    const char* uplo, magma_int_t *n,
    double *A, magma_int_t *lda,
    magma_int_t *info )
{
    magma_dsytrf_nopiv(
        magma_uplo_const(*uplo), *n,
        A, *lda,
        info );
}

#define magmaf_dsytrf_nopiv_cpu FORTRAN_NAME( magmaf_dsytrf_nopiv_cpu, MAGMAF_DSYTRF_NOPIV_CPU )
void magmaf_dsytrf_nopiv_cpu(
    const char* uplo, magma_int_t *n, magma_int_t *ib,
    double *A, magma_int_t *lda,
    magma_int_t *info )
{
    magma_dsytrf_nopiv_cpu(
        magma_uplo_const(*uplo), *n, *ib,
        A, *lda,
        info );
}

#define magmaf_dsytrf_nopiv_gpu FORTRAN_NAME( magmaf_dsytrf_nopiv_gpu, MAGMAF_DSYTRF_NOPIV_GPU )
void magmaf_dsytrf_nopiv_gpu(
    const char* uplo, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t *info )
{
    magma_dsytrf_nopiv_gpu(
        magma_uplo_const(*uplo), *n,
        magma_ddevptr(dA), *ldda,
        info );
}

#define magmaf_dsytrs_nopiv_gpu FORTRAN_NAME( magmaf_dsytrs_nopiv_gpu, MAGMAF_DSYTRS_NOPIV_GPU )
void magmaf_dsytrs_nopiv_gpu(
    const char* uplo, magma_int_t *n, magma_int_t *nrhs,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb,
    magma_int_t *info )
{
    magma_dsytrs_nopiv_gpu(
        magma_uplo_const(*uplo), *n, *nrhs,
        magma_ddevptr(dA), *ldda,
        magma_ddevptr(dB), *lddb,
        info );
}

#define magmaf_dlaln2 FORTRAN_NAME( magmaf_dlaln2, MAGMAF_DLALN2 )
void magmaf_dlaln2(
    magma_int_t *trans, magma_int_t *na, magma_int_t *nw, double *smin, double *ca,
    double *A, magma_int_t *lda, double *d1, double *d2,
    double *B, magma_int_t *ldb, double *wr, double *wi,
    double *X, magma_int_t *ldx,
    double *scale,
    double *xnorm,
    magma_int_t *info )
{
    magma_dlaln2(
        *trans, *na, *nw, *smin, *ca,
        A, *lda, *d1, *d2,
        B, *ldb, *wr, *wi,
        X, *ldx,
        scale,
        xnorm,
        info );
}

#define magmaf_dlaqtrsd FORTRAN_NAME( magmaf_dlaqtrsd, MAGMAF_DLAQTRSD )
void magmaf_dlaqtrsd(
    const char* trans, magma_int_t *n,
    double *T, magma_int_t *ldt,
    double *x, magma_int_t *ldx,
    double *cnorm,
    magma_int_t *info )
{
    magma_dlaqtrsd(
        magma_trans_const(*trans), *n,
        T, *ldt,
        x, *ldx,
        cnorm,
        info );
}

#define magmaf_dlarf_gpu FORTRAN_NAME( magmaf_dlarf_gpu, MAGMAF_DLARF_GPU )
magma_int_t magmaf_dlarf_gpu(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dv,
    devptr_t *dtau,
    devptr_t *dC, magma_int_t *lddc, magma_queue_t *queue )
{
    return magma_dlarf_gpu(
        *m, *n,
        magma_ddevptr(dv),
        magma_ddevptr(dtau),
        magma_ddevptr(dC), *lddc, *queue );
}

#define magmaf_dlarfb2_gpu FORTRAN_NAME( magmaf_dlarfb2_gpu, MAGMAF_DLARFB2_GPU )
magma_int_t magmaf_dlarfb2_gpu(
    magma_int_t *m, magma_int_t *n, magma_int_t *k,
    devptr_t *dV, magma_int_t *lddv,
    devptr_t *dT, magma_int_t *lddt,
    devptr_t *dC, magma_int_t *lddc,
    devptr_t *dwork, magma_int_t *ldwork, magma_queue_t *queue )
{
    return magma_dlarfb2_gpu(
        *m, *n, *k,
        magma_ddevptr(dV), *lddv,
        magma_ddevptr(dT), *lddt,
        magma_ddevptr(dC), *lddc,
        magma_ddevptr(dwork), *ldwork, *queue );
}

#define magmaf_dlauum FORTRAN_NAME( magmaf_dlauum, MAGMAF_DLAUUM )
void magmaf_dlauum(
    const char* uplo, magma_int_t *n,
    double *A, magma_int_t *lda,
    magma_int_t *info )
{
    magma_dlauum(
        magma_uplo_const(*uplo), *n,
        A, *lda,
        info );
}

#define magmaf_dlauum_gpu FORTRAN_NAME( magmaf_dlauum_gpu, MAGMAF_DLAUUM_GPU )
void magmaf_dlauum_gpu(
    const char* uplo, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t *info )
{
    magma_dlauum_gpu(
        magma_uplo_const(*uplo), *n,
        magma_ddevptr(dA), *ldda,
        info );
}

#define magmaf_dposv FORTRAN_NAME( magmaf_dposv, MAGMAF_DPOSV )
void magmaf_dposv(
    const char* uplo, magma_int_t *n, magma_int_t *nrhs,
    double *A, magma_int_t *lda,
    double *B, magma_int_t *ldb,
    magma_int_t *info )
{
    magma_dposv(
        magma_uplo_const(*uplo), *n, *nrhs,
        A, *lda,
        B, *ldb,
        info );
}

#define magmaf_dposv_gpu FORTRAN_NAME( magmaf_dposv_gpu, MAGMAF_DPOSV_GPU )
void magmaf_dposv_gpu(
    const char* uplo, magma_int_t *n, magma_int_t *nrhs,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb,
    magma_int_t *info )
{
    magma_dposv_gpu(
        magma_uplo_const(*uplo), *n, *nrhs,
        magma_ddevptr(dA), *ldda,
        magma_ddevptr(dB), *lddb,
        info );
}

#define magmaf_dpotf2_gpu FORTRAN_NAME( magmaf_dpotf2_gpu, MAGMAF_DPOTF2_GPU )
void magmaf_dpotf2_gpu(
    const char* uplo, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda, magma_queue_t *queue,
    magma_int_t *info )
{
    magma_dpotf2_gpu(
        magma_uplo_const(*uplo), *n,
        magma_ddevptr(dA), *ldda, *queue,
        info );
}

#define magmaf_dpotf2_native FORTRAN_NAME( magmaf_dpotf2_native, MAGMAF_DPOTF2_NATIVE )
magma_int_t magmaf_dpotf2_native(
    const char* uplo, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda, magma_int_t *step,
    magma_int_t *device_info, magma_queue_t *queue )
{
    return magma_dpotf2_native(
        magma_uplo_const(*uplo), *n,
        magma_ddevptr(dA), *ldda, *step,
        device_info, *queue );
}

#define magmaf_dpotrf_rectile_native FORTRAN_NAME( magmaf_dpotrf_rectile_native, MAGMAF_DPOTRF_RECTILE_NATIVE )
void magmaf_dpotrf_rectile_native(
    const char* uplo, magma_int_t *n, magma_int_t *recnb,
    double* dA, magma_int_t *ldda, magma_int_t *gbstep,
    magma_int_t *dinfo,
    magma_int_t *info, magma_queue_t *queue )
{
    magma_dpotrf_rectile_native(
        magma_uplo_const(*uplo), *n, *recnb,
        dA, *ldda, *gbstep,
        dinfo,
        info, *queue );
}

#define magmaf_dpotrf FORTRAN_NAME( magmaf_dpotrf, MAGMAF_DPOTRF )
void magmaf_dpotrf(
    const char* uplo, magma_int_t *n,
    double *A, magma_int_t *lda,
    magma_int_t *info )
{
    magma_dpotrf(
        magma_uplo_const(*uplo), *n,
        A, *lda,
        info );
}

#define magmaf_dpotrf_gpu FORTRAN_NAME( magmaf_dpotrf_gpu, MAGMAF_DPOTRF_GPU )
void magmaf_dpotrf_gpu(
    const char* uplo, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t *info )
{
    magma_dpotrf_gpu(
        magma_uplo_const(*uplo), *n,
        magma_ddevptr(dA), *ldda,
        info );
}

#define magmaf_dpotrf_native FORTRAN_NAME( magmaf_dpotrf_native, MAGMAF_DPOTRF_NATIVE )
void magmaf_dpotrf_native(
    const char* uplo, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t *info )
{
    magma_dpotrf_native(
        magma_uplo_const(*uplo), *n,
        magma_ddevptr(dA), *ldda,
        info );
}

#define magmaf_dpotrf_m FORTRAN_NAME( magmaf_dpotrf_m, MAGMAF_DPOTRF_M )
void magmaf_dpotrf_m(
    magma_int_t *ngpu, const char* uplo, magma_int_t *n,
    double *A, magma_int_t *lda,
    magma_int_t *info )
{
    magma_dpotrf_m(
        *ngpu, magma_uplo_const(*uplo), *n,
        A, *lda,
        info );
}

#define magmaf_dpotri FORTRAN_NAME( magmaf_dpotri, MAGMAF_DPOTRI )
void magmaf_dpotri(
    const char* uplo, magma_int_t *n,
    double *A, magma_int_t *lda,
    magma_int_t *info )
{
    magma_dpotri(
        magma_uplo_const(*uplo), *n,
        A, *lda,
        info );
}

#define magmaf_dpotri_gpu FORTRAN_NAME( magmaf_dpotri_gpu, MAGMAF_DPOTRI_GPU )
void magmaf_dpotri_gpu(
    const char* uplo, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t *info )
{
    magma_dpotri_gpu(
        magma_uplo_const(*uplo), *n,
        magma_ddevptr(dA), *ldda,
        info );
}

#define magmaf_dpotrs_gpu FORTRAN_NAME( magmaf_dpotrs_gpu, MAGMAF_DPOTRS_GPU )
void magmaf_dpotrs_gpu(
    const char* uplo, magma_int_t *n, magma_int_t *nrhs,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb,
    magma_int_t *info )
{
    magma_dpotrs_gpu(
        magma_uplo_const(*uplo), *n, *nrhs,
        magma_ddevptr(dA), *ldda,
        magma_ddevptr(dB), *lddb,
        info );
}

#define magmaf_dstedx FORTRAN_NAME( magmaf_dstedx, MAGMAF_DSTEDX )
void magmaf_dstedx(
    const char* range, magma_int_t *n, double *vl, double *vu, magma_int_t *il, magma_int_t *iu,
    double *d,
    double *e,
    double *Z, magma_int_t *ldz,
    double *rwork, magma_int_t *lrwork,
    magma_int_t *iwork, magma_int_t *liwork,
    devptr_t *dwork,
    magma_int_t *info )
{
    magma_dstedx(
        magma_range_const(*range), *n, *vl, *vu, *il, *iu,
        d,
        e,
        Z, *ldz,
        rwork, *lrwork,
        iwork, *liwork,
        magma_ddevptr(dwork),
        info );
}

#define magmaf_dstedx_m FORTRAN_NAME( magmaf_dstedx_m, MAGMAF_DSTEDX_M )
void magmaf_dstedx_m(
    magma_int_t *ngpu, const char* range, magma_int_t *n, double *vl, double *vu, magma_int_t *il, magma_int_t *iu,
    double *d,
    double *e,
    double *Z, magma_int_t *ldz,
    double *rwork, magma_int_t *lrwork,
    magma_int_t *iwork, magma_int_t *liwork,
    magma_int_t *info )
{
    magma_dstedx_m(
        *ngpu, magma_range_const(*range), *n, *vl, *vu, *il, *iu,
        d,
        e,
        Z, *ldz,
        rwork, *lrwork,
        iwork, *liwork,
        info );
}

#define magmaf_dtrevc3 FORTRAN_NAME( magmaf_dtrevc3, MAGMAF_DTREVC3 )
void magmaf_dtrevc3(
    const char* side, const char* howmany,
    magma_int_t *select, magma_int_t *n,
    double *T, magma_int_t *ldt,
    double *VL, magma_int_t *ldvl,
    double *VR, magma_int_t *ldvr, magma_int_t *mm,
    magma_int_t *mout,
    double *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_dtrevc3(
        magma_side_const(*side), magma_vec_const(*howmany),
        select, *n,
        T, *ldt,
        VL, *ldvl,
        VR, *ldvr, *mm,
        mout,
        work, *lwork,
        info );
}

#define magmaf_dtrevc3_mt FORTRAN_NAME( magmaf_dtrevc3_mt, MAGMAF_DTREVC3_MT )
void magmaf_dtrevc3_mt(
    const char* side, const char* howmany,
    magma_int_t *select, magma_int_t *n,
    double *T, magma_int_t *ldt,
    double *VL, magma_int_t *ldvl,
    double *VR, magma_int_t *ldvr, magma_int_t *mm,
    magma_int_t *mout,
    double *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_dtrevc3_mt(
        magma_side_const(*side), magma_vec_const(*howmany),
        select, *n,
        T, *ldt,
        VL, *ldvl,
        VR, *ldvr, *mm,
        mout,
        work, *lwork,
        info );
}

#define magmaf_dtrsm_m FORTRAN_NAME( magmaf_dtrsm_m, MAGMAF_DTRSM_M )
magma_int_t magmaf_dtrsm_m(
    magma_int_t *ngpu, const char* side, const char* uplo, const char* transa, const char* diag, magma_int_t *m, magma_int_t *n, double *alpha,
    double *A, magma_int_t *lda,
    double *B, magma_int_t *ldb )
{
    return magma_dtrsm_m(
        *ngpu, magma_side_const(*side), magma_uplo_const(*uplo), magma_trans_const(*transa), magma_diag_const(*diag), *m, *n, *alpha,
        A, *lda,
        B, *ldb );
}

#define magmaf_dtrtri FORTRAN_NAME( magmaf_dtrtri, MAGMAF_DTRTRI )
void magmaf_dtrtri(
    const char* uplo, const char* diag, magma_int_t *n,
    double *A, magma_int_t *lda,
    magma_int_t *info )
{
    magma_dtrtri(
        magma_uplo_const(*uplo), magma_diag_const(*diag), *n,
        A, *lda,
        info );
}

#define magmaf_dtrtri_gpu FORTRAN_NAME( magmaf_dtrtri_gpu, MAGMAF_DTRTRI_GPU )
void magmaf_dtrtri_gpu(
    const char* uplo, const char* diag, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t *info )
{
    magma_dtrtri_gpu(
        magma_uplo_const(*uplo), magma_diag_const(*diag), *n,
        magma_ddevptr(dA), *ldda,
        info );
}

#define magmaf_dorgbr FORTRAN_NAME( magmaf_dorgbr, MAGMAF_DORGBR )
void magmaf_dorgbr(
    const char* vect, magma_int_t *m, magma_int_t *n, magma_int_t *k,
    double *A, magma_int_t *lda,
    double *tau,
    double *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_dorgbr(
        magma_vect_const(*vect), *m, *n, *k,
        A, *lda,
        tau,
        work, *lwork,
        info );
}

#define magmaf_dorghr FORTRAN_NAME( magmaf_dorghr, MAGMAF_DORGHR )
void magmaf_dorghr(
    magma_int_t *n, magma_int_t *ilo, magma_int_t *ihi,
    double *A, magma_int_t *lda,
    double *tau,
    devptr_t *dT, magma_int_t *nb,
    magma_int_t *info )
{
    magma_dorghr(
        *n, *ilo, *ihi,
        A, *lda,
        tau,
        magma_ddevptr(dT), *nb,
        info );
}

#define magmaf_dorghr_m FORTRAN_NAME( magmaf_dorghr_m, MAGMAF_DORGHR_M )
void magmaf_dorghr_m(
    magma_int_t *n, magma_int_t *ilo, magma_int_t *ihi,
    double *A, magma_int_t *lda,
    double *tau,
    double *T, magma_int_t *nb,
    magma_int_t *info )
{
    magma_dorghr_m(
        *n, *ilo, *ihi,
        A, *lda,
        tau,
        T, *nb,
        info );
}

#define magmaf_dorglq FORTRAN_NAME( magmaf_dorglq, MAGMAF_DORGLQ )
void magmaf_dorglq(
    magma_int_t *m, magma_int_t *n, magma_int_t *k,
    double *A, magma_int_t *lda,
    double *tau,
    devptr_t *dT, magma_int_t *nb,
    magma_int_t *info )
{
    magma_dorglq(
        *m, *n, *k,
        A, *lda,
        tau,
        magma_ddevptr(dT), *nb,
        info );
}

#define magmaf_dorgqr FORTRAN_NAME( magmaf_dorgqr, MAGMAF_DORGQR )
void magmaf_dorgqr(
    magma_int_t *m, magma_int_t *n, magma_int_t *k,
    double *A, magma_int_t *lda,
    double *tau,
    devptr_t *dT, magma_int_t *nb,
    magma_int_t *info )
{
    magma_dorgqr(
        *m, *n, *k,
        A, *lda,
        tau,
        magma_ddevptr(dT), *nb,
        info );
}

#define magmaf_dorgqr_gpu FORTRAN_NAME( magmaf_dorgqr_gpu, MAGMAF_DORGQR_GPU )
void magmaf_dorgqr_gpu(
    magma_int_t *m, magma_int_t *n, magma_int_t *k,
    devptr_t *dA, magma_int_t *ldda,
    double *tau,
    devptr_t *dT, magma_int_t *nb,
    magma_int_t *info )
{
    magma_dorgqr_gpu(
        *m, *n, *k,
        magma_ddevptr(dA), *ldda,
        tau,
        magma_ddevptr(dT), *nb,
        info );
}

#define magmaf_dorgqr_m FORTRAN_NAME( magmaf_dorgqr_m, MAGMAF_DORGQR_M )
void magmaf_dorgqr_m(
    magma_int_t *m, magma_int_t *n, magma_int_t *k,
    double *A, magma_int_t *lda,
    double *tau,
    double *T, magma_int_t *nb,
    magma_int_t *info )
{
    magma_dorgqr_m(
        *m, *n, *k,
        A, *lda,
        tau,
        T, *nb,
        info );
}

#define magmaf_dorgqr2 FORTRAN_NAME( magmaf_dorgqr2, MAGMAF_DORGQR2 )
void magmaf_dorgqr2(
    magma_int_t *m, magma_int_t *n, magma_int_t *k,
    double *A, magma_int_t *lda,
    double *tau,
    magma_int_t *info )
{
    magma_dorgqr2(
        *m, *n, *k,
        A, *lda,
        tau,
        info );
}

#define magmaf_dormbr FORTRAN_NAME( magmaf_dormbr, MAGMAF_DORMBR )
void magmaf_dormbr(
    const char* vect, const char* side, const char* trans, magma_int_t *m, magma_int_t *n, magma_int_t *k,
    double *A, magma_int_t *lda,
    double *tau,
    double *C, magma_int_t *ldc,
    double *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_dormbr(
        magma_vect_const(*vect), magma_side_const(*side), magma_trans_const(*trans), *m, *n, *k,
        A, *lda,
        tau,
        C, *ldc,
        work, *lwork,
        info );
}

#define magmaf_dormlq FORTRAN_NAME( magmaf_dormlq, MAGMAF_DORMLQ )
void magmaf_dormlq(
    const char* side, const char* trans, magma_int_t *m, magma_int_t *n, magma_int_t *k,
    double *A, magma_int_t *lda,
    double *tau,
    double *C, magma_int_t *ldc,
    double *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_dormlq(
        magma_side_const(*side), magma_trans_const(*trans), *m, *n, *k,
        A, *lda,
        tau,
        C, *ldc,
        work, *lwork,
        info );
}

#define magmaf_dormrq FORTRAN_NAME( magmaf_dormrq, MAGMAF_DORMRQ )
void magmaf_dormrq(
    const char* side, const char* trans, magma_int_t *m, magma_int_t *n, magma_int_t *k,
    double *A, magma_int_t *lda,
    double *tau,
    double *C, magma_int_t *ldc,
    double *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_dormrq(
        magma_side_const(*side), magma_trans_const(*trans), *m, *n, *k,
        A, *lda,
        tau,
        C, *ldc,
        work, *lwork,
        info );
}

#define magmaf_dormql FORTRAN_NAME( magmaf_dormql, MAGMAF_DORMQL )
void magmaf_dormql(
    const char* side, const char* trans, magma_int_t *m, magma_int_t *n, magma_int_t *k,
    double *A, magma_int_t *lda,
    double *tau,
    double *C, magma_int_t *ldc,
    double *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_dormql(
        magma_side_const(*side), magma_trans_const(*trans), *m, *n, *k,
        A, *lda,
        tau,
        C, *ldc,
        work, *lwork,
        info );
}

#define magmaf_dormql2_gpu FORTRAN_NAME( magmaf_dormql2_gpu, MAGMAF_DORMQL2_GPU )
void magmaf_dormql2_gpu(
    const char* side, const char* trans, magma_int_t *m, magma_int_t *n, magma_int_t *k,
    devptr_t *dA, magma_int_t *ldda,
    double *tau,
    devptr_t *dC, magma_int_t *lddc,
    double *wA, magma_int_t *ldwa,
    magma_int_t *info )
{
    magma_dormql2_gpu(
        magma_side_const(*side), magma_trans_const(*trans), *m, *n, *k,
        magma_ddevptr(dA), *ldda,
        tau,
        magma_ddevptr(dC), *lddc,
        wA, *ldwa,
        info );
}

#define magmaf_dormqr FORTRAN_NAME( magmaf_dormqr, MAGMAF_DORMQR )
void magmaf_dormqr(
    const char* side, const char* trans, magma_int_t *m, magma_int_t *n, magma_int_t *k,
    double *A, magma_int_t *lda,
    double *tau,
    double *C, magma_int_t *ldc,
    double *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_dormqr(
        magma_side_const(*side), magma_trans_const(*trans), *m, *n, *k,
        A, *lda,
        tau,
        C, *ldc,
        work, *lwork,
        info );
}

#define magmaf_dormqr_gpu FORTRAN_NAME( magmaf_dormqr_gpu, MAGMAF_DORMQR_GPU )
void magmaf_dormqr_gpu(
    const char* side, const char* trans, magma_int_t *m, magma_int_t *n, magma_int_t *k,
    devptr_t *dA, magma_int_t *ldda,
    double *tau,
    devptr_t *dC, magma_int_t *lddc,
    double *hwork, magma_int_t *lwork,
    devptr_t *dT, magma_int_t *nb,
    magma_int_t *info )
{
    magma_dormqr_gpu(
        magma_side_const(*side), magma_trans_const(*trans), *m, *n, *k,
        magma_ddevptr(dA), *ldda,
        tau,
        magma_ddevptr(dC), *lddc,
        hwork, *lwork,
        magma_ddevptr(dT), *nb,
        info );
}

#define magmaf_dormqr2_gpu FORTRAN_NAME( magmaf_dormqr2_gpu, MAGMAF_DORMQR2_GPU )
void magmaf_dormqr2_gpu(
    const char* side, const char* trans, magma_int_t *m, magma_int_t *n, magma_int_t *k,
    devptr_t *dA, magma_int_t *ldda,
    double *tau,
    devptr_t *dC, magma_int_t *lddc,
    double *wA, magma_int_t *ldwa,
    magma_int_t *info )
{
    magma_dormqr2_gpu(
        magma_side_const(*side), magma_trans_const(*trans), *m, *n, *k,
        magma_ddevptr(dA), *ldda,
        tau,
        magma_ddevptr(dC), *lddc,
        wA, *ldwa,
        info );
}

#define magmaf_dormqr_m FORTRAN_NAME( magmaf_dormqr_m, MAGMAF_DORMQR_M )
void magmaf_dormqr_m(
    magma_int_t *ngpu, const char* side, const char* trans, magma_int_t *m, magma_int_t *n, magma_int_t *k,
    double *A, magma_int_t *lda,
    double *tau,
    double *C, magma_int_t *ldc,
    double *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_dormqr_m(
        *ngpu, magma_side_const(*side), magma_trans_const(*trans), *m, *n, *k,
        A, *lda,
        tau,
        C, *ldc,
        work, *lwork,
        info );
}

#define magmaf_dormtr FORTRAN_NAME( magmaf_dormtr, MAGMAF_DORMTR )
void magmaf_dormtr(
    const char* side, const char* uplo, const char* trans, magma_int_t *m, magma_int_t *n,
    double *A, magma_int_t *lda,
    double *tau,
    double *C, magma_int_t *ldc,
    double *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_dormtr(
        magma_side_const(*side), magma_uplo_const(*uplo), magma_trans_const(*trans), *m, *n,
        A, *lda,
        tau,
        C, *ldc,
        work, *lwork,
        info );
}

#define magmaf_dormtr_gpu FORTRAN_NAME( magmaf_dormtr_gpu, MAGMAF_DORMTR_GPU )
void magmaf_dormtr_gpu(
    const char* side, const char* uplo, const char* trans, magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    double *tau,
    devptr_t *dC, magma_int_t *lddc,
    double *wA, magma_int_t *ldwa,
    magma_int_t *info )
{
    magma_dormtr_gpu(
        magma_side_const(*side), magma_uplo_const(*uplo), magma_trans_const(*trans), *m, *n,
        magma_ddevptr(dA), *ldda,
        tau,
        magma_ddevptr(dC), *lddc,
        wA, *ldwa,
        info );
}

#define magmaf_dormtr_m FORTRAN_NAME( magmaf_dormtr_m, MAGMAF_DORMTR_M )
void magmaf_dormtr_m(
    magma_int_t *ngpu, const char* side, const char* uplo, const char* trans, magma_int_t *m, magma_int_t *n,
    double *A, magma_int_t *lda,
    double *tau,
    double *C, magma_int_t *ldc,
    double *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_dormtr_m(
        *ngpu, magma_side_const(*side), magma_uplo_const(*uplo), magma_trans_const(*trans), *m, *n,
        A, *lda,
        tau,
        C, *ldc,
        work, *lwork,
        info );
}

#define magmaf_d_isnan FORTRAN_NAME( magmaf_d_isnan, MAGMAF_D_ISNAN )
int magmaf_d_isnan(
    double *x )
{
    return magma_d_isnan(
        *x );
}

#define magmaf_d_isinf FORTRAN_NAME( magmaf_d_isinf, MAGMAF_D_ISINF )
int magmaf_d_isinf(
    double *x )
{
    return magma_d_isinf(
        *x );
}

#define magmaf_d_isnan_inf FORTRAN_NAME( magmaf_d_isnan_inf, MAGMAF_D_ISNAN_INF )
int magmaf_d_isnan_inf(
    double *x )
{
    return magma_d_isnan_inf(
        *x );
}

#define magmaf_dmake_lwork FORTRAN_NAME( magmaf_dmake_lwork, MAGMAF_DMAKE_LWORK )
double magmaf_dmake_lwork(
    magma_int_t *lwork )
{
    return magma_dmake_lwork(
        *lwork );
}

#define magmaf_dnan_inf FORTRAN_NAME( magmaf_dnan_inf, MAGMAF_DNAN_INF )
magma_int_t magmaf_dnan_inf(
    const char* uplo, magma_int_t *m, magma_int_t *n,
    double *A, magma_int_t *lda,
    magma_int_t *cnt_nan,
    magma_int_t *cnt_inf )
{
    return magma_dnan_inf(
        magma_uplo_const(*uplo), *m, *n,
        A, *lda,
        cnt_nan,
        cnt_inf );
}

#define magmaf_dnan_inf_gpu FORTRAN_NAME( magmaf_dnan_inf_gpu, MAGMAF_DNAN_INF_GPU )
magma_int_t magmaf_dnan_inf_gpu(
    const char* uplo, magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t *cnt_nan,
    magma_int_t *cnt_inf, magma_queue_t *queue )
{
    return magma_dnan_inf_gpu(
        magma_uplo_const(*uplo), *m, *n,
        magma_ddevptr(dA), *ldda,
        cnt_nan,
        cnt_inf, *queue );
}

#define magmaf_dprint FORTRAN_NAME( magmaf_dprint, MAGMAF_DPRINT )
void magmaf_dprint(
    magma_int_t *m, magma_int_t *n,
    double *A, magma_int_t *lda )
{
    magma_dprint(
        *m, *n,
        A, *lda );
}

#define magmaf_dprint_gpu FORTRAN_NAME( magmaf_dprint_gpu, MAGMAF_DPRINT_GPU )
void magmaf_dprint_gpu(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda, magma_queue_t *queue )
{
    magma_dprint_gpu(
        *m, *n,
        magma_ddevptr(dA), *ldda, *queue );
}

#define magmaf_dpanel_to_q FORTRAN_NAME( magmaf_dpanel_to_q, MAGMAF_DPANEL_TO_Q )
void magmaf_dpanel_to_q(
    const char* uplo, magma_int_t *ib,
    double *A, magma_int_t *lda,
    double *work )
{
    magma_dpanel_to_q(
        magma_uplo_const(*uplo), *ib,
        A, *lda,
        work );
}

#define magmaf_dq_to_panel FORTRAN_NAME( magmaf_dq_to_panel, MAGMAF_DQ_TO_PANEL )
void magmaf_dq_to_panel(
    const char* uplo, magma_int_t *ib,
    double *A, magma_int_t *lda,
    double *work )
{
    magma_dq_to_panel(
        magma_uplo_const(*uplo), *ib,
        A, *lda,
        work );
}

#define magmablasf_dextract_diag_sqrt FORTRAN_NAME( magmablasf_dextract_diag_sqrt, MAGMABLASF_DEXTRACT_DIAG_SQRT )
void magmablasf_dextract_diag_sqrt(
    magma_int_t *m, magma_int_t *n,
    double* dA, magma_int_t *ldda,
    double* dD, magma_int_t *incd, magma_queue_t *queue )
{
    magmablas_dextract_diag_sqrt(
        *m, *n,
        dA, *ldda,
        dD, *incd, *queue );
}

#define magmablasf_dscal_shift_hpd FORTRAN_NAME( magmablasf_dscal_shift_hpd, MAGMABLASF_DSCAL_SHIFT_HPD )
void magmablasf_dscal_shift_hpd(
    const char* uplo, int *n,
    double* dA, int *ldda,
    double* dD, int *incd, double *miu, double *cn, double *eps, magma_queue_t *queue )
{
    magmablas_dscal_shift_hpd(
        magma_uplo_const(*uplo), *n,
        dA, *ldda,
        dD, *incd, *miu, *cn, *eps, *queue );
}

#define magmablasf_ddimv_invert FORTRAN_NAME( magmablasf_ddimv_invert, MAGMABLASF_DDIMV_INVERT )
void magmablasf_ddimv_invert(
    magma_int_t *n, double *alpha,
    double* dD, magma_int_t *incd,
    double* dx, magma_int_t *incx, double *beta,
    double* dy, magma_int_t *incy, magma_queue_t *queue )
{
    magmablas_ddimv_invert(
        *n, *alpha,
        dD, *incd,
        dx, *incx, *beta,
        dy, *incy, *queue );
}


#ifdef __cplusplus
}
#endif
