/*******************************************************************************
 *  This file is AUTOMATICALLY GENERATED by:
 *  tools/fortran_wrappers.pl include/magma_c.i
 *  Do not edit.
 ******************************************************************************/

#include <stdint.h>  // for uintptr_t

#include "magma_v2.h"
#include "magma_mangling.h"

// typedef from CUDADIR/src/fortran.h directory
typedef size_t devptr_t;

#ifdef PGI_FORTRAN
    #define magma_devptr(ptr_)  ((void*)              (ptr_))
    #define magma_idevptr(ptr_) ((magma_int_t*)       (ptr_))
    #define magma_zdevptr(ptr_) ((magmaDoubleComplex*)(ptr_))
    #define magma_cdevptr(ptr_) ((magmaFloatComplex*) (ptr_))
    #define magma_ddevptr(ptr_) ((double*)            (ptr_))
    #define magma_sdevptr(ptr_) ((float*)             (ptr_))
#else
    #define magma_devptr(ptr_)  ((void*)              (uintptr_t)(*(ptr_)))
    #define magma_idevptr(ptr_) ((magma_int_t*)       (uintptr_t)(*(ptr_)))
    #define magma_zdevptr(ptr_) ((magmaDoubleComplex*)(uintptr_t)(*(ptr_)))
    #define magma_cdevptr(ptr_) ((magmaFloatComplex*) (uintptr_t)(*(ptr_)))
    #define magma_ddevptr(ptr_) ((double*)            (uintptr_t)(*(ptr_)))
    #define magma_sdevptr(ptr_) ((float*)             (uintptr_t)(*(ptr_)))
#endif

#ifdef __cplusplus
extern "C" {
#endif

#define magmaf_get_cpotrf_nb FORTRAN_NAME( magmaf_get_cpotrf_nb, MAGMAF_GET_CPOTRF_NB )
magma_int_t magmaf_get_cpotrf_nb(
    magma_int_t *n )
{
    return magma_get_cpotrf_nb(
        *n );
}

#define magmaf_get_cgetrf_nb FORTRAN_NAME( magmaf_get_cgetrf_nb, MAGMAF_GET_CGETRF_NB )
magma_int_t magmaf_get_cgetrf_nb(
    magma_int_t *m, magma_int_t *n )
{
    return magma_get_cgetrf_nb(
        *m, *n );
}

#define magmaf_get_cgetrf_native_nb FORTRAN_NAME( magmaf_get_cgetrf_native_nb, MAGMAF_GET_CGETRF_NATIVE_NB )
magma_int_t magmaf_get_cgetrf_native_nb(
    magma_int_t *m, magma_int_t *n )
{
    return magma_get_cgetrf_native_nb(
        *m, *n );
}

#define magmaf_get_cgetri_nb FORTRAN_NAME( magmaf_get_cgetri_nb, MAGMAF_GET_CGETRI_NB )
magma_int_t magmaf_get_cgetri_nb(
    magma_int_t *n )
{
    return magma_get_cgetri_nb(
        *n );
}

#define magmaf_get_chetrf_nb FORTRAN_NAME( magmaf_get_chetrf_nb, MAGMAF_GET_CHETRF_NB )
magma_int_t magmaf_get_chetrf_nb(
    magma_int_t *n )
{
    return magma_get_chetrf_nb(
        *n );
}

#define magmaf_get_chetrf_nopiv_nb FORTRAN_NAME( magmaf_get_chetrf_nopiv_nb, MAGMAF_GET_CHETRF_NOPIV_NB )
magma_int_t magmaf_get_chetrf_nopiv_nb(
    magma_int_t *n )
{
    return magma_get_chetrf_nopiv_nb(
        *n );
}

#define magmaf_get_chetrf_aasen_nb FORTRAN_NAME( magmaf_get_chetrf_aasen_nb, MAGMAF_GET_CHETRF_AASEN_NB )
magma_int_t magmaf_get_chetrf_aasen_nb(
    magma_int_t *n )
{
    return magma_get_chetrf_aasen_nb(
        *n );
}

#define magmaf_get_cgeqp3_nb FORTRAN_NAME( magmaf_get_cgeqp3_nb, MAGMAF_GET_CGEQP3_NB )
magma_int_t magmaf_get_cgeqp3_nb(
    magma_int_t *m, magma_int_t *n )
{
    return magma_get_cgeqp3_nb(
        *m, *n );
}

#define magmaf_get_cgeqrf_nb FORTRAN_NAME( magmaf_get_cgeqrf_nb, MAGMAF_GET_CGEQRF_NB )
magma_int_t magmaf_get_cgeqrf_nb(
    magma_int_t *m, magma_int_t *n )
{
    return magma_get_cgeqrf_nb(
        *m, *n );
}

#define magmaf_get_cgeqlf_nb FORTRAN_NAME( magmaf_get_cgeqlf_nb, MAGMAF_GET_CGEQLF_NB )
magma_int_t magmaf_get_cgeqlf_nb(
    magma_int_t *m, magma_int_t *n )
{
    return magma_get_cgeqlf_nb(
        *m, *n );
}

#define magmaf_get_cgelqf_nb FORTRAN_NAME( magmaf_get_cgelqf_nb, MAGMAF_GET_CGELQF_NB )
magma_int_t magmaf_get_cgelqf_nb(
    magma_int_t *m, magma_int_t *n )
{
    return magma_get_cgelqf_nb(
        *m, *n );
}

#define magmaf_get_cgehrd_nb FORTRAN_NAME( magmaf_get_cgehrd_nb, MAGMAF_GET_CGEHRD_NB )
magma_int_t magmaf_get_cgehrd_nb(
    magma_int_t *n )
{
    return magma_get_cgehrd_nb(
        *n );
}

#define magmaf_get_chetrd_nb FORTRAN_NAME( magmaf_get_chetrd_nb, MAGMAF_GET_CHETRD_NB )
magma_int_t magmaf_get_chetrd_nb(
    magma_int_t *n )
{
    return magma_get_chetrd_nb(
        *n );
}

#define magmaf_get_chegst_nb FORTRAN_NAME( magmaf_get_chegst_nb, MAGMAF_GET_CHEGST_NB )
magma_int_t magmaf_get_chegst_nb(
    magma_int_t *n )
{
    return magma_get_chegst_nb(
        *n );
}

#define magmaf_get_chegst_m_nb FORTRAN_NAME( magmaf_get_chegst_m_nb, MAGMAF_GET_CHEGST_M_NB )
magma_int_t magmaf_get_chegst_m_nb(
    magma_int_t *n )
{
    return magma_get_chegst_m_nb(
        *n );
}

#define magmaf_get_cgebrd_nb FORTRAN_NAME( magmaf_get_cgebrd_nb, MAGMAF_GET_CGEBRD_NB )
magma_int_t magmaf_get_cgebrd_nb(
    magma_int_t *m, magma_int_t *n )
{
    return magma_get_cgebrd_nb(
        *m, *n );
}

#define magmaf_get_cgesvd_nb FORTRAN_NAME( magmaf_get_cgesvd_nb, MAGMAF_GET_CGESVD_NB )
magma_int_t magmaf_get_cgesvd_nb(
    magma_int_t *m, magma_int_t *n )
{
    return magma_get_cgesvd_nb(
        *m, *n );
}

#define magmaf_get_cbulge_nb FORTRAN_NAME( magmaf_get_cbulge_nb, MAGMAF_GET_CBULGE_NB )
magma_int_t magmaf_get_cbulge_nb(
    magma_int_t *n, magma_int_t *nbthreads )
{
    return magma_get_cbulge_nb(
        *n, *nbthreads );
}

#define magmaf_get_cbulge_vblksiz FORTRAN_NAME( magmaf_get_cbulge_vblksiz, MAGMAF_GET_CBULGE_VBLKSIZ )
magma_int_t magmaf_get_cbulge_vblksiz(
    magma_int_t *n, magma_int_t *nb, magma_int_t *nbthreads )
{
    return magma_get_cbulge_vblksiz(
        *n, *nb, *nbthreads );
}

#define magmaf_get_cbulge_gcperf FORTRAN_NAME( magmaf_get_cbulge_gcperf, MAGMAF_GET_CBULGE_GCPERF )
magma_int_t magmaf_get_cbulge_gcperf(
     )
{
    return magma_get_cbulge_gcperf(
         );
}

#define magmaf_cgbsv_native FORTRAN_NAME( magmaf_cgbsv_native, MAGMAF_CGBSV_NATIVE )
void magmaf_cgbsv_native(
    magma_int_t *n, magma_int_t *kl, magma_int_t *ku, magma_int_t *nrhs,
    magmaFloatComplex* dA, magma_int_t *ldda,
    magma_int_t* dipiv,
    magmaFloatComplex* dB, magma_int_t *lddb,
    magma_int_t *info )
{
    magma_cgbsv_native(
        *n, *kl, *ku, *nrhs,
        dA, *ldda,
        dipiv,
        dB, *lddb,
        info );
}

#define magmaf_cgbtrf_native FORTRAN_NAME( magmaf_cgbtrf_native, MAGMAF_CGBTRF_NATIVE )
void magmaf_cgbtrf_native(
    magma_int_t *m, magma_int_t *n, magma_int_t *kl, magma_int_t *ku,
    magmaFloatComplex* dAB, magma_int_t *lddab,
    magma_int_t* dipiv,
    magma_int_t *info )
{
    magma_cgbtrf_native(
        *m, *n, *kl, *ku,
        dAB, *lddab,
        dipiv,
        info );
}

#define magmaf_cgebrd FORTRAN_NAME( magmaf_cgebrd, MAGMAF_CGEBRD )
void magmaf_cgebrd(
    magma_int_t *m, magma_int_t *n,
    magmaFloatComplex *A, magma_int_t *lda,
    float *d,
    float *e,
    magmaFloatComplex *tauq,
    magmaFloatComplex *taup,
    magmaFloatComplex *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_cgebrd(
        *m, *n,
        A, *lda,
        d,
        e,
        tauq,
        taup,
        work, *lwork,
        info );
}

#define magmaf_cgeev FORTRAN_NAME( magmaf_cgeev, MAGMAF_CGEEV )
void magmaf_cgeev(
    const char* jobvl, const char* jobvr, magma_int_t *n,
    magmaFloatComplex *A, magma_int_t *lda,
    magmaFloatComplex *w,
    magmaFloatComplex *VL, magma_int_t *ldvl,
    magmaFloatComplex *VR, magma_int_t *ldvr,
    magmaFloatComplex *work, magma_int_t *lwork,
    float *rwork,
    magma_int_t *info )
{
    magma_cgeev(
        magma_vec_const(*jobvl), magma_vec_const(*jobvr), *n,
        A, *lda,
        w,
        VL, *ldvl,
        VR, *ldvr,
        work, *lwork,
        rwork,
        info );
}

#define magmaf_cgeev_m FORTRAN_NAME( magmaf_cgeev_m, MAGMAF_CGEEV_M )
void magmaf_cgeev_m(
    const char* jobvl, const char* jobvr, magma_int_t *n,
    magmaFloatComplex *A, magma_int_t *lda,
    magmaFloatComplex *w,
    magmaFloatComplex *VL, magma_int_t *ldvl,
    magmaFloatComplex *VR, magma_int_t *ldvr,
    magmaFloatComplex *work, magma_int_t *lwork,
    float *rwork,
    magma_int_t *info )
{
    magma_cgeev_m(
        magma_vec_const(*jobvl), magma_vec_const(*jobvr), *n,
        A, *lda,
        w,
        VL, *ldvl,
        VR, *ldvr,
        work, *lwork,
        rwork,
        info );
}

#define magmaf_cgegqr_gpu FORTRAN_NAME( magmaf_cgegqr_gpu, MAGMAF_CGEGQR_GPU )
void magmaf_cgegqr_gpu(
    magma_int_t *ikind, magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dwork,
    magmaFloatComplex *work,
    magma_int_t *info )
{
    magma_cgegqr_gpu(
        *ikind, *m, *n,
        magma_cdevptr(dA), *ldda,
        magma_cdevptr(dwork),
        work,
        info );
}

#define magmaf_cgehrd FORTRAN_NAME( magmaf_cgehrd, MAGMAF_CGEHRD )
void magmaf_cgehrd(
    magma_int_t *n, magma_int_t *ilo, magma_int_t *ihi,
    magmaFloatComplex *A, magma_int_t *lda,
    magmaFloatComplex *tau,
    magmaFloatComplex *work, magma_int_t *lwork,
    devptr_t *dT,
    magma_int_t *info )
{
    magma_cgehrd(
        *n, *ilo, *ihi,
        A, *lda,
        tau,
        work, *lwork,
        magma_cdevptr(dT),
        info );
}

#define magmaf_cgehrd_m FORTRAN_NAME( magmaf_cgehrd_m, MAGMAF_CGEHRD_M )
void magmaf_cgehrd_m(
    magma_int_t *n, magma_int_t *ilo, magma_int_t *ihi,
    magmaFloatComplex *A, magma_int_t *lda,
    magmaFloatComplex *tau,
    magmaFloatComplex *work, magma_int_t *lwork,
    magmaFloatComplex *T,
    magma_int_t *info )
{
    magma_cgehrd_m(
        *n, *ilo, *ihi,
        A, *lda,
        tau,
        work, *lwork,
        T,
        info );
}

#define magmaf_cgehrd2 FORTRAN_NAME( magmaf_cgehrd2, MAGMAF_CGEHRD2 )
void magmaf_cgehrd2(
    magma_int_t *n, magma_int_t *ilo, magma_int_t *ihi,
    magmaFloatComplex *A, magma_int_t *lda,
    magmaFloatComplex *tau,
    magmaFloatComplex *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_cgehrd2(
        *n, *ilo, *ihi,
        A, *lda,
        tau,
        work, *lwork,
        info );
}

#define magmaf_cgelqf FORTRAN_NAME( magmaf_cgelqf, MAGMAF_CGELQF )
void magmaf_cgelqf(
    magma_int_t *m, magma_int_t *n,
    magmaFloatComplex *A, magma_int_t *lda,
    magmaFloatComplex *tau,
    magmaFloatComplex *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_cgelqf(
        *m, *n,
        A, *lda,
        tau,
        work, *lwork,
        info );
}

#define magmaf_cgelqf_gpu FORTRAN_NAME( magmaf_cgelqf_gpu, MAGMAF_CGELQF_GPU )
void magmaf_cgelqf_gpu(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magmaFloatComplex *tau,
    magmaFloatComplex *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_cgelqf_gpu(
        *m, *n,
        magma_cdevptr(dA), *ldda,
        tau,
        work, *lwork,
        info );
}

#define magmaf_cgels FORTRAN_NAME( magmaf_cgels, MAGMAF_CGELS )
void magmaf_cgels(
    const char* trans, magma_int_t *m, magma_int_t *n, magma_int_t *nrhs,
    devptr_t *A, magma_int_t *lda,
    devptr_t *B, magma_int_t *ldb,
    magmaFloatComplex *hwork, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_cgels(
        magma_trans_const(*trans), *m, *n, *nrhs,
        magma_cdevptr(A), *lda,
        magma_cdevptr(B), *ldb,
        hwork, *lwork,
        info );
}

#define magmaf_cggrqf FORTRAN_NAME( magmaf_cggrqf, MAGMAF_CGGRQF )
void magmaf_cggrqf(
    magma_int_t *m, magma_int_t *p, magma_int_t *n,
    magmaFloatComplex *A, magma_int_t *lda,
    magmaFloatComplex *taua,
    magmaFloatComplex *B, magma_int_t *ldb,
    magmaFloatComplex *taub,
    magmaFloatComplex *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_cggrqf(
        *m, *p, *n,
        A, *lda,
        taua,
        B, *ldb,
        taub,
        work, *lwork,
        info );
}

#define magmaf_cgglse FORTRAN_NAME( magmaf_cgglse, MAGMAF_CGGLSE )
void magmaf_cgglse(
    magma_int_t *m, magma_int_t *n, magma_int_t *p,
    magmaFloatComplex *A, magma_int_t *lda,
    magmaFloatComplex *B, magma_int_t *ldb,
    magmaFloatComplex *c,
    magmaFloatComplex *d,
    magmaFloatComplex *x,
    magmaFloatComplex *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_cgglse(
        *m, *n, *p,
        A, *lda,
        B, *ldb,
        c,
        d,
        x,
        work, *lwork,
        info );
}

#define magmaf_cgels_gpu FORTRAN_NAME( magmaf_cgels_gpu, MAGMAF_CGELS_GPU )
void magmaf_cgels_gpu(
    const char* trans, magma_int_t *m, magma_int_t *n, magma_int_t *nrhs,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb,
    magmaFloatComplex *hwork, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_cgels_gpu(
        magma_trans_const(*trans), *m, *n, *nrhs,
        magma_cdevptr(dA), *ldda,
        magma_cdevptr(dB), *lddb,
        hwork, *lwork,
        info );
}

#define magmaf_cgels3_gpu FORTRAN_NAME( magmaf_cgels3_gpu, MAGMAF_CGELS3_GPU )
void magmaf_cgels3_gpu(
    const char* trans, magma_int_t *m, magma_int_t *n, magma_int_t *nrhs,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb,
    magmaFloatComplex *hwork, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_cgels3_gpu(
        magma_trans_const(*trans), *m, *n, *nrhs,
        magma_cdevptr(dA), *ldda,
        magma_cdevptr(dB), *lddb,
        hwork, *lwork,
        info );
}

#define magmaf_cgeqlf FORTRAN_NAME( magmaf_cgeqlf, MAGMAF_CGEQLF )
void magmaf_cgeqlf(
    magma_int_t *m, magma_int_t *n,
    magmaFloatComplex *A, magma_int_t *lda,
    magmaFloatComplex *tau,
    magmaFloatComplex *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_cgeqlf(
        *m, *n,
        A, *lda,
        tau,
        work, *lwork,
        info );
}

#define magmaf_cgeqp3 FORTRAN_NAME( magmaf_cgeqp3, MAGMAF_CGEQP3 )
void magmaf_cgeqp3(
    magma_int_t *m, magma_int_t *n,
    magmaFloatComplex *A, magma_int_t *lda,
    magma_int_t *jpvt,
    magmaFloatComplex *tau,
    magmaFloatComplex *work, magma_int_t *lwork,
    float *rwork,
    magma_int_t *info )
{
    magma_cgeqp3(
        *m, *n,
        A, *lda,
        jpvt,
        tau,
        work, *lwork,
        rwork,
        info );
}

#define magmaf_cgeqp3_gpu FORTRAN_NAME( magmaf_cgeqp3_gpu, MAGMAF_CGEQP3_GPU )
void magmaf_cgeqp3_gpu(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t *jpvt,
    magmaFloatComplex *tau,
    devptr_t *dwork, magma_int_t *lwork,
    float *rwork,
    magma_int_t *info )
{
    magma_cgeqp3_gpu(
        *m, *n,
        magma_cdevptr(dA), *ldda,
        jpvt,
        tau,
        magma_cdevptr(dwork), *lwork,
        rwork,
        info );
}

#define magmaf_cgeqr2x_gpu FORTRAN_NAME( magmaf_cgeqr2x_gpu, MAGMAF_CGEQR2X_GPU )
void magmaf_cgeqr2x_gpu(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dtau,
    devptr_t *dT,
    devptr_t *ddA,
    devptr_t *dwork,
    magma_int_t *info )
{
    magma_cgeqr2x_gpu(
        *m, *n,
        magma_cdevptr(dA), *ldda,
        magma_cdevptr(dtau),
        magma_cdevptr(dT),
        magma_cdevptr(ddA),
        magma_sdevptr(dwork),
        info );
}

#define magmaf_cgeqr2x2_gpu FORTRAN_NAME( magmaf_cgeqr2x2_gpu, MAGMAF_CGEQR2X2_GPU )
void magmaf_cgeqr2x2_gpu(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dtau,
    devptr_t *dT,
    devptr_t *ddA,
    devptr_t *dwork,
    magma_int_t *info )
{
    magma_cgeqr2x2_gpu(
        *m, *n,
        magma_cdevptr(dA), *ldda,
        magma_cdevptr(dtau),
        magma_cdevptr(dT),
        magma_cdevptr(ddA),
        magma_sdevptr(dwork),
        info );
}

#define magmaf_cgeqr2x3_gpu FORTRAN_NAME( magmaf_cgeqr2x3_gpu, MAGMAF_CGEQR2X3_GPU )
void magmaf_cgeqr2x3_gpu(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dtau,
    devptr_t *dT,
    devptr_t *ddA,
    devptr_t *dwork,
    magma_int_t *info )
{
    magma_cgeqr2x3_gpu(
        *m, *n,
        magma_cdevptr(dA), *ldda,
        magma_cdevptr(dtau),
        magma_cdevptr(dT),
        magma_cdevptr(ddA),
        magma_sdevptr(dwork),
        info );
}

#define magmaf_cgeqr2x4_gpu FORTRAN_NAME( magmaf_cgeqr2x4_gpu, MAGMAF_CGEQR2X4_GPU )
void magmaf_cgeqr2x4_gpu(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dtau,
    devptr_t *dT,
    devptr_t *ddA,
    devptr_t *dwork, magma_queue_t *queue,
    magma_int_t *info )
{
    magma_cgeqr2x4_gpu(
        *m, *n,
        magma_cdevptr(dA), *ldda,
        magma_cdevptr(dtau),
        magma_cdevptr(dT),
        magma_cdevptr(ddA),
        magma_sdevptr(dwork), *queue,
        info );
}

#define magmaf_cgeqrf FORTRAN_NAME( magmaf_cgeqrf, MAGMAF_CGEQRF )
void magmaf_cgeqrf(
    magma_int_t *m, magma_int_t *n,
    magmaFloatComplex *A, magma_int_t *lda,
    magmaFloatComplex *tau,
    magmaFloatComplex *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_cgeqrf(
        *m, *n,
        A, *lda,
        tau,
        work, *lwork,
        info );
}

#define magmaf_cgeqrf_gpu FORTRAN_NAME( magmaf_cgeqrf_gpu, MAGMAF_CGEQRF_GPU )
void magmaf_cgeqrf_gpu(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magmaFloatComplex *tau,
    devptr_t *dT,
    magma_int_t *info )
{
    magma_cgeqrf_gpu(
        *m, *n,
        magma_cdevptr(dA), *ldda,
        tau,
        magma_cdevptr(dT),
        info );
}

#define magmaf_cgeqrf_m FORTRAN_NAME( magmaf_cgeqrf_m, MAGMAF_CGEQRF_M )
void magmaf_cgeqrf_m(
    magma_int_t *ngpu, magma_int_t *m, magma_int_t *n,
    magmaFloatComplex *A, magma_int_t *lda,
    magmaFloatComplex *tau,
    magmaFloatComplex *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_cgeqrf_m(
        *ngpu, *m, *n,
        A, *lda,
        tau,
        work, *lwork,
        info );
}

#define magmaf_cgeqrf_ooc FORTRAN_NAME( magmaf_cgeqrf_ooc, MAGMAF_CGEQRF_OOC )
void magmaf_cgeqrf_ooc(
    magma_int_t *m, magma_int_t *n,
    magmaFloatComplex *A, magma_int_t *lda,
    magmaFloatComplex *tau,
    magmaFloatComplex *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_cgeqrf_ooc(
        *m, *n,
        A, *lda,
        tau,
        work, *lwork,
        info );
}

#define magmaf_cgeqrf2_gpu FORTRAN_NAME( magmaf_cgeqrf2_gpu, MAGMAF_CGEQRF2_GPU )
void magmaf_cgeqrf2_gpu(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magmaFloatComplex *tau,
    magma_int_t *info )
{
    magma_cgeqrf2_gpu(
        *m, *n,
        magma_cdevptr(dA), *ldda,
        tau,
        info );
}

#define magmaf_cgeqrf3_gpu FORTRAN_NAME( magmaf_cgeqrf3_gpu, MAGMAF_CGEQRF3_GPU )
void magmaf_cgeqrf3_gpu(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magmaFloatComplex *tau,
    devptr_t *dT,
    magma_int_t *info )
{
    magma_cgeqrf3_gpu(
        *m, *n,
        magma_cdevptr(dA), *ldda,
        tau,
        magma_cdevptr(dT),
        info );
}

#define magmaf_cgeqrs_gpu FORTRAN_NAME( magmaf_cgeqrs_gpu, MAGMAF_CGEQRS_GPU )
void magmaf_cgeqrs_gpu(
    magma_int_t *m, magma_int_t *n, magma_int_t *nrhs,
    devptr_t *dA, magma_int_t *ldda,
    magmaFloatComplex *tau,
    devptr_t *dT,
    devptr_t *dB, magma_int_t *lddb,
    magmaFloatComplex *hwork, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_cgeqrs_gpu(
        *m, *n, *nrhs,
        magma_cdevptr(dA), *ldda,
        tau,
        magma_cdevptr(dT),
        magma_cdevptr(dB), *lddb,
        hwork, *lwork,
        info );
}

#define magmaf_cgeqrs3_gpu FORTRAN_NAME( magmaf_cgeqrs3_gpu, MAGMAF_CGEQRS3_GPU )
void magmaf_cgeqrs3_gpu(
    magma_int_t *m, magma_int_t *n, magma_int_t *nrhs,
    devptr_t *dA, magma_int_t *ldda,
    magmaFloatComplex *tau,
    devptr_t *dT,
    devptr_t *dB, magma_int_t *lddb,
    magmaFloatComplex *hwork, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_cgeqrs3_gpu(
        *m, *n, *nrhs,
        magma_cdevptr(dA), *ldda,
        tau,
        magma_cdevptr(dT),
        magma_cdevptr(dB), *lddb,
        hwork, *lwork,
        info );
}

#define magmaf_cgerbt_gpu FORTRAN_NAME( magmaf_cgerbt_gpu, MAGMAF_CGERBT_GPU )
void magmaf_cgerbt_gpu(
    const char* gen, magma_int_t *n, magma_int_t *nrhs,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb,
    magmaFloatComplex *U,
    magmaFloatComplex *V,
    magma_int_t *info )
{
    magma_cgerbt_gpu(
        magma_bool_const(*gen), *n, *nrhs,
        magma_cdevptr(dA), *ldda,
        magma_cdevptr(dB), *lddb,
        U,
        V,
        info );
}

#define magmaf_cgerfs_nopiv_gpu FORTRAN_NAME( magmaf_cgerfs_nopiv_gpu, MAGMAF_CGERFS_NOPIV_GPU )
void magmaf_cgerfs_nopiv_gpu(
    const char* trans, magma_int_t *n, magma_int_t *nrhs,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb,
    devptr_t *dX, magma_int_t *lddx,
    devptr_t *dworkd,
    devptr_t *dAF,
    magma_int_t *iter,
    magma_int_t *info )
{
    magma_cgerfs_nopiv_gpu(
        magma_trans_const(*trans), *n, *nrhs,
        magma_cdevptr(dA), *ldda,
        magma_cdevptr(dB), *lddb,
        magma_cdevptr(dX), *lddx,
        magma_cdevptr(dworkd),
        magma_cdevptr(dAF),
        iter,
        info );
}

#define magmaf_cgesdd FORTRAN_NAME( magmaf_cgesdd, MAGMAF_CGESDD )
void magmaf_cgesdd(
    const char* jobz, magma_int_t *m, magma_int_t *n,
    magmaFloatComplex *A, magma_int_t *lda,
    float *s,
    magmaFloatComplex *U, magma_int_t *ldu,
    magmaFloatComplex *VT, magma_int_t *ldvt,
    magmaFloatComplex *work, magma_int_t *lwork,
    float *rwork,
    magma_int_t *iwork,
    magma_int_t *info )
{
    magma_cgesdd(
        magma_vec_const(*jobz), *m, *n,
        A, *lda,
        s,
        U, *ldu,
        VT, *ldvt,
        work, *lwork,
        rwork,
        iwork,
        info );
}

#define magmaf_cgesv FORTRAN_NAME( magmaf_cgesv, MAGMAF_CGESV )
void magmaf_cgesv(
    magma_int_t *n, magma_int_t *nrhs,
    magmaFloatComplex *A, magma_int_t *lda,
    magma_int_t *ipiv,
    magmaFloatComplex *B, magma_int_t *ldb,
    magma_int_t *info )
{
    magma_cgesv(
        *n, *nrhs,
        A, *lda,
        ipiv,
        B, *ldb,
        info );
}

#define magmaf_cgesv_gpu FORTRAN_NAME( magmaf_cgesv_gpu, MAGMAF_CGESV_GPU )
void magmaf_cgesv_gpu(
    magma_int_t *n, magma_int_t *nrhs,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t *ipiv,
    devptr_t *dB, magma_int_t *lddb,
    magma_int_t *info )
{
    magma_cgesv_gpu(
        *n, *nrhs,
        magma_cdevptr(dA), *ldda,
        ipiv,
        magma_cdevptr(dB), *lddb,
        info );
}

#define magmaf_cgesv_nopiv_gpu FORTRAN_NAME( magmaf_cgesv_nopiv_gpu, MAGMAF_CGESV_NOPIV_GPU )
void magmaf_cgesv_nopiv_gpu(
    magma_int_t *n, magma_int_t *nrhs,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb,
    magma_int_t *info )
{
    magma_cgesv_nopiv_gpu(
        *n, *nrhs,
        magma_cdevptr(dA), *ldda,
        magma_cdevptr(dB), *lddb,
        info );
}

#define magmaf_cgesv_rbt FORTRAN_NAME( magmaf_cgesv_rbt, MAGMAF_CGESV_RBT )
void magmaf_cgesv_rbt(
    const char* ref, magma_int_t *n, magma_int_t *nrhs,
    magmaFloatComplex *A, magma_int_t *lda,
    magmaFloatComplex *B, magma_int_t *ldb,
    magma_int_t *info )
{
    magma_cgesv_rbt(
        magma_bool_const(*ref), *n, *nrhs,
        A, *lda,
        B, *ldb,
        info );
}

#define magmaf_cgesvd FORTRAN_NAME( magmaf_cgesvd, MAGMAF_CGESVD )
void magmaf_cgesvd(
    const char* jobu, const char* jobvt, magma_int_t *m, magma_int_t *n,
    magmaFloatComplex *A, magma_int_t *lda,
    float *s,
    magmaFloatComplex *U, magma_int_t *ldu,
    magmaFloatComplex *VT, magma_int_t *ldvt,
    magmaFloatComplex *work, magma_int_t *lwork,
    float *rwork,
    magma_int_t *info )
{
    magma_cgesvd(
        magma_vec_const(*jobu), magma_vec_const(*jobvt), *m, *n,
        A, *lda,
        s,
        U, *ldu,
        VT, *ldvt,
        work, *lwork,
        rwork,
        info );
}

#define magmaf_cgesvj_batched_strided FORTRAN_NAME( magmaf_cgesvj_batched_strided, MAGMAF_CGESVJ_BATCHED_STRIDED )
void magmaf_cgesvj_batched_strided(
    const char* jobu, const char* jobv, magma_int_t *morg, magma_int_t *norg,
    devptr_t *dA, magma_int_t *ldda, magma_int_t *strideA,
    devptr_t *dS, magma_int_t *strideS,
    devptr_t *dU, magma_int_t *lddu, magma_int_t *strideU,
    devptr_t *dV, magma_int_t *lddv, magma_int_t *strideV,
    devptr_t *dinfo_array, magma_int_t *batchCount, magma_queue_t *queue )
{
    magma_cgesvj_batched_strided(
        magma_vec_const(*jobu), magma_vec_const(*jobv), *morg, *norg,
        magma_cdevptr(dA), *ldda, *strideA,
        magma_sdevptr(dS), *strideS,
        magma_cdevptr(dU), *lddu, *strideU,
        magma_cdevptr(dV), *lddv, *strideV,
        magma_idevptr(dinfo_array), *batchCount, *queue );
}

#define magmaf_cgetf2_gpu FORTRAN_NAME( magmaf_cgetf2_gpu, MAGMAF_CGETF2_GPU )
void magmaf_cgetf2_gpu(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t *ipiv, magma_queue_t *queue,
    magma_int_t *info )
{
    magma_cgetf2_gpu(
        *m, *n,
        magma_cdevptr(dA), *ldda,
        ipiv, *queue,
        info );
}

#define magmaf_cgetf2_native_fused FORTRAN_NAME( magmaf_cgetf2_native_fused, MAGMAF_CGETF2_NATIVE_FUSED )
void magmaf_cgetf2_native_fused(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t *ipiv, magma_int_t *gbstep,
    magma_int_t *flags,
    magma_int_t *info, magma_queue_t *queue )
{
    magma_cgetf2_native_fused(
        *m, *n,
        magma_cdevptr(dA), *ldda,
        ipiv, *gbstep,
        flags,
        info, *queue );
}

#define magmaf_cgetf2_native FORTRAN_NAME( magmaf_cgetf2_native, MAGMAF_CGETF2_NATIVE )
magma_int_t magmaf_cgetf2_native(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t *dipiv,
    magma_int_t* dipivinfo,
    magma_int_t *dinfo, magma_int_t *gbstep,
    magma_event_t events[2], magma_queue_t *queue, magma_queue_t *update_queue )
{
    return magma_cgetf2_native(
        *m, *n,
        magma_cdevptr(dA), *ldda,
        dipiv,
        dipivinfo,
        dinfo, *gbstep,
        events, *queue, *update_queue );
}

#define magmaf_cgetf2_nopiv FORTRAN_NAME( magmaf_cgetf2_nopiv, MAGMAF_CGETF2_NOPIV )
void magmaf_cgetf2_nopiv(
    magma_int_t *m, magma_int_t *n,
    magmaFloatComplex *A, magma_int_t *lda,
    magma_int_t *info )
{
    magma_cgetf2_nopiv(
        *m, *n,
        A, *lda,
        info );
}

#define magmaf_cgetrf_recpanel_native FORTRAN_NAME( magmaf_cgetrf_recpanel_native, MAGMAF_CGETRF_RECPANEL_NATIVE )
magma_int_t magmaf_cgetrf_recpanel_native(
    magma_int_t *m, magma_int_t *n, magma_int_t *recnb,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t* dipiv,
    magma_int_t* dipivinfo,
    magma_int_t *dinfo, magma_int_t *gbstep,
    magma_event_t events[2], magma_queue_t *queue, magma_queue_t *update_queue )
{
    return magma_cgetrf_recpanel_native(
        *m, *n, *recnb,
        magma_cdevptr(dA), *ldda,
        dipiv,
        dipivinfo,
        dinfo, *gbstep,
        events, *queue, *update_queue );
}

#define magmaf_cgetrf FORTRAN_NAME( magmaf_cgetrf, MAGMAF_CGETRF )
void magmaf_cgetrf(
    magma_int_t *m, magma_int_t *n,
    magmaFloatComplex *A, magma_int_t *lda,
    magma_int_t *ipiv,
    magma_int_t *info )
{
    magma_cgetrf(
        *m, *n,
        A, *lda,
        ipiv,
        info );
}

#define magmaf_cgetrf_gpu FORTRAN_NAME( magmaf_cgetrf_gpu, MAGMAF_CGETRF_GPU )
void magmaf_cgetrf_gpu(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t *ipiv,
    magma_int_t *info )
{
    magma_cgetrf_gpu(
        *m, *n,
        magma_cdevptr(dA), *ldda,
        ipiv,
        info );
}

#define magmaf_cgetrf_native FORTRAN_NAME( magmaf_cgetrf_native, MAGMAF_CGETRF_NATIVE )
void magmaf_cgetrf_native(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t *ipiv,
    magma_int_t *info )
{
    magma_cgetrf_native(
        *m, *n,
        magma_cdevptr(dA), *ldda,
        ipiv,
        info );
}

#define magmaf_cgetrf_m FORTRAN_NAME( magmaf_cgetrf_m, MAGMAF_CGETRF_M )
void magmaf_cgetrf_m(
    magma_int_t *ngpu, magma_int_t *m, magma_int_t *n,
    magmaFloatComplex *A, magma_int_t *lda,
    magma_int_t *ipiv,
    magma_int_t *info )
{
    magma_cgetrf_m(
        *ngpu, *m, *n,
        A, *lda,
        ipiv,
        info );
}

#define magmaf_cgetrf_nopiv FORTRAN_NAME( magmaf_cgetrf_nopiv, MAGMAF_CGETRF_NOPIV )
void magmaf_cgetrf_nopiv(
    magma_int_t *m, magma_int_t *n,
    magmaFloatComplex *A, magma_int_t *lda,
    magma_int_t *info )
{
    magma_cgetrf_nopiv(
        *m, *n,
        A, *lda,
        info );
}

#define magmaf_cgetrf_nopiv_gpu FORTRAN_NAME( magmaf_cgetrf_nopiv_gpu, MAGMAF_CGETRF_NOPIV_GPU )
void magmaf_cgetrf_nopiv_gpu(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t *info )
{
    magma_cgetrf_nopiv_gpu(
        *m, *n,
        magma_cdevptr(dA), *ldda,
        info );
}

#define magmaf_cgetri_gpu FORTRAN_NAME( magmaf_cgetri_gpu, MAGMAF_CGETRI_GPU )
void magmaf_cgetri_gpu(
    magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t *ipiv,
    devptr_t *dwork, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_cgetri_gpu(
        *n,
        magma_cdevptr(dA), *ldda,
        ipiv,
        magma_cdevptr(dwork), *lwork,
        info );
}

#define magmaf_cgetrs_gpu FORTRAN_NAME( magmaf_cgetrs_gpu, MAGMAF_CGETRS_GPU )
void magmaf_cgetrs_gpu(
    const char* trans, magma_int_t *n, magma_int_t *nrhs,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t *ipiv,
    devptr_t *dB, magma_int_t *lddb,
    magma_int_t *info )
{
    magma_cgetrs_gpu(
        magma_trans_const(*trans), *n, *nrhs,
        magma_cdevptr(dA), *ldda,
        ipiv,
        magma_cdevptr(dB), *lddb,
        info );
}

#define magmaf_cgetrs_nopiv_gpu FORTRAN_NAME( magmaf_cgetrs_nopiv_gpu, MAGMAF_CGETRS_NOPIV_GPU )
void magmaf_cgetrs_nopiv_gpu(
    const char* trans, magma_int_t *n, magma_int_t *nrhs,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb,
    magma_int_t *info )
{
    magma_cgetrs_nopiv_gpu(
        magma_trans_const(*trans), *n, *nrhs,
        magma_cdevptr(dA), *ldda,
        magma_cdevptr(dB), *lddb,
        info );
}

#define magmaf_cheevd FORTRAN_NAME( magmaf_cheevd, MAGMAF_CHEEVD )
void magmaf_cheevd(
    const char* jobz, const char* uplo, magma_int_t *n,
    magmaFloatComplex *A, magma_int_t *lda,
    float *w,
    magmaFloatComplex *work, magma_int_t *lwork,
    float *rwork, magma_int_t *lrwork,
    magma_int_t *iwork, magma_int_t *liwork,
    magma_int_t *info )
{
    magma_cheevd(
        magma_vec_const(*jobz), magma_uplo_const(*uplo), *n,
        A, *lda,
        w,
        work, *lwork,
        rwork, *lrwork,
        iwork, *liwork,
        info );
}

#define magmaf_cheevd_gpu FORTRAN_NAME( magmaf_cheevd_gpu, MAGMAF_CHEEVD_GPU )
void magmaf_cheevd_gpu(
    const char* jobz, const char* uplo, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    float *w,
    magmaFloatComplex *wA, magma_int_t *ldwa,
    magmaFloatComplex *work, magma_int_t *lwork,
    float *rwork, magma_int_t *lrwork,
    magma_int_t *iwork, magma_int_t *liwork,
    magma_int_t *info )
{
    magma_cheevd_gpu(
        magma_vec_const(*jobz), magma_uplo_const(*uplo), *n,
        magma_cdevptr(dA), *ldda,
        w,
        wA, *ldwa,
        work, *lwork,
        rwork, *lrwork,
        iwork, *liwork,
        info );
}

#define magmaf_cheevd_m FORTRAN_NAME( magmaf_cheevd_m, MAGMAF_CHEEVD_M )
void magmaf_cheevd_m(
    magma_int_t *ngpu, const char* jobz, const char* uplo, magma_int_t *n,
    magmaFloatComplex *A, magma_int_t *lda,
    float *w,
    magmaFloatComplex *work, magma_int_t *lwork,
    float *rwork, magma_int_t *lrwork,
    magma_int_t *iwork, magma_int_t *liwork,
    magma_int_t *info )
{
    magma_cheevd_m(
        *ngpu, magma_vec_const(*jobz), magma_uplo_const(*uplo), *n,
        A, *lda,
        w,
        work, *lwork,
        rwork, *lrwork,
        iwork, *liwork,
        info );
}

#define magmaf_cheevdx FORTRAN_NAME( magmaf_cheevdx, MAGMAF_CHEEVDX )
void magmaf_cheevdx(
    const char* jobz, const char* range, const char* uplo, magma_int_t *n,
    magmaFloatComplex *A, magma_int_t *lda, float *vl, float *vu, magma_int_t *il, magma_int_t *iu,
    magma_int_t *mout,
    float *w,
    magmaFloatComplex *work, magma_int_t *lwork,
    float *rwork, magma_int_t *lrwork,
    magma_int_t *iwork, magma_int_t *liwork,
    magma_int_t *info )
{
    magma_cheevdx(
        magma_vec_const(*jobz), magma_range_const(*range), magma_uplo_const(*uplo), *n,
        A, *lda, *vl, *vu, *il, *iu,
        mout,
        w,
        work, *lwork,
        rwork, *lrwork,
        iwork, *liwork,
        info );
}

#define magmaf_cheevdx_gpu FORTRAN_NAME( magmaf_cheevdx_gpu, MAGMAF_CHEEVDX_GPU )
void magmaf_cheevdx_gpu(
    const char* jobz, const char* range, const char* uplo, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda, float *vl, float *vu, magma_int_t *il, magma_int_t *iu,
    magma_int_t *mout,
    float *w,
    magmaFloatComplex *wA, magma_int_t *ldwa,
    magmaFloatComplex *work, magma_int_t *lwork,
    float *rwork, magma_int_t *lrwork,
    magma_int_t *iwork, magma_int_t *liwork,
    magma_int_t *info )
{
    magma_cheevdx_gpu(
        magma_vec_const(*jobz), magma_range_const(*range), magma_uplo_const(*uplo), *n,
        magma_cdevptr(dA), *ldda, *vl, *vu, *il, *iu,
        mout,
        w,
        wA, *ldwa,
        work, *lwork,
        rwork, *lrwork,
        iwork, *liwork,
        info );
}

#define magmaf_cheevdx_m FORTRAN_NAME( magmaf_cheevdx_m, MAGMAF_CHEEVDX_M )
void magmaf_cheevdx_m(
    magma_int_t *ngpu, const char* jobz, const char* range, const char* uplo, magma_int_t *n,
    magmaFloatComplex *A, magma_int_t *lda, float *vl, float *vu, magma_int_t *il, magma_int_t *iu,
    magma_int_t *mout,
    float *w,
    magmaFloatComplex *work, magma_int_t *lwork,
    float *rwork, magma_int_t *lrwork,
    magma_int_t *iwork, magma_int_t *liwork,
    magma_int_t *info )
{
    magma_cheevdx_m(
        *ngpu, magma_vec_const(*jobz), magma_range_const(*range), magma_uplo_const(*uplo), *n,
        A, *lda, *vl, *vu, *il, *iu,
        mout,
        w,
        work, *lwork,
        rwork, *lrwork,
        iwork, *liwork,
        info );
}

#define magmaf_cheevdx_2stage FORTRAN_NAME( magmaf_cheevdx_2stage, MAGMAF_CHEEVDX_2STAGE )
void magmaf_cheevdx_2stage(
    const char* jobz, const char* range, const char* uplo, magma_int_t *n,
    magmaFloatComplex *A, magma_int_t *lda, float *vl, float *vu, magma_int_t *il, magma_int_t *iu,
    magma_int_t *mout,
    float *w,
    magmaFloatComplex *work, magma_int_t *lwork,
    float *rwork, magma_int_t *lrwork,
    magma_int_t *iwork, magma_int_t *liwork,
    magma_int_t *info )
{
    magma_cheevdx_2stage(
        magma_vec_const(*jobz), magma_range_const(*range), magma_uplo_const(*uplo), *n,
        A, *lda, *vl, *vu, *il, *iu,
        mout,
        w,
        work, *lwork,
        rwork, *lrwork,
        iwork, *liwork,
        info );
}

#define magmaf_cheevdx_2stage_m FORTRAN_NAME( magmaf_cheevdx_2stage_m, MAGMAF_CHEEVDX_2STAGE_M )
void magmaf_cheevdx_2stage_m(
    magma_int_t *ngpu, const char* jobz, const char* range, const char* uplo, magma_int_t *n,
    magmaFloatComplex *A, magma_int_t *lda, float *vl, float *vu, magma_int_t *il, magma_int_t *iu,
    magma_int_t *mout,
    float *w,
    magmaFloatComplex *work, magma_int_t *lwork,
    float *rwork, magma_int_t *lrwork,
    magma_int_t *iwork, magma_int_t *liwork,
    magma_int_t *info )
{
    magma_cheevdx_2stage_m(
        *ngpu, magma_vec_const(*jobz), magma_range_const(*range), magma_uplo_const(*uplo), *n,
        A, *lda, *vl, *vu, *il, *iu,
        mout,
        w,
        work, *lwork,
        rwork, *lrwork,
        iwork, *liwork,
        info );
}

#define magmaf_cheevr FORTRAN_NAME( magmaf_cheevr, MAGMAF_CHEEVR )
void magmaf_cheevr(
    const char* jobz, const char* range, const char* uplo, magma_int_t *n,
    magmaFloatComplex *A, magma_int_t *lda, float *vl, float *vu, magma_int_t *il, magma_int_t *iu, float *abstol,
    magma_int_t *mout,
    float *w,
    magmaFloatComplex *Z, magma_int_t *ldz,
    magma_int_t *isuppz,
    magmaFloatComplex *work, magma_int_t *lwork,
    float *rwork, magma_int_t *lrwork,
    magma_int_t *iwork, magma_int_t *liwork,
    magma_int_t *info )
{
    magma_cheevr(
        magma_vec_const(*jobz), magma_range_const(*range), magma_uplo_const(*uplo), *n,
        A, *lda, *vl, *vu, *il, *iu, *abstol,
        mout,
        w,
        Z, *ldz,
        isuppz,
        work, *lwork,
        rwork, *lrwork,
        iwork, *liwork,
        info );
}

#define magmaf_cheevr_gpu FORTRAN_NAME( magmaf_cheevr_gpu, MAGMAF_CHEEVR_GPU )
void magmaf_cheevr_gpu(
    const char* jobz, const char* range, const char* uplo, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda, float *vl, float *vu, magma_int_t *il, magma_int_t *iu, float *abstol,
    magma_int_t *mout,
    float *w,
    devptr_t *dZ, magma_int_t *lddz,
    magma_int_t *isuppz,
    magmaFloatComplex *wA, magma_int_t *ldwa,
    magmaFloatComplex *wZ, magma_int_t *ldwz,
    magmaFloatComplex *work, magma_int_t *lwork,
    float *rwork, magma_int_t *lrwork,
    magma_int_t *iwork, magma_int_t *liwork,
    magma_int_t *info )
{
    magma_cheevr_gpu(
        magma_vec_const(*jobz), magma_range_const(*range), magma_uplo_const(*uplo), *n,
        magma_cdevptr(dA), *ldda, *vl, *vu, *il, *iu, *abstol,
        mout,
        w,
        magma_cdevptr(dZ), *lddz,
        isuppz,
        wA, *ldwa,
        wZ, *ldwz,
        work, *lwork,
        rwork, *lrwork,
        iwork, *liwork,
        info );
}

#define magmaf_cheevx FORTRAN_NAME( magmaf_cheevx, MAGMAF_CHEEVX )
void magmaf_cheevx(
    const char* jobz, const char* range, const char* uplo, magma_int_t *n,
    magmaFloatComplex *A, magma_int_t *lda, float *vl, float *vu, magma_int_t *il, magma_int_t *iu, float *abstol,
    magma_int_t *mout,
    float *w,
    magmaFloatComplex *Z, magma_int_t *ldz,
    magmaFloatComplex *work, magma_int_t *lwork,
    float *rwork,
    magma_int_t *iwork,
    magma_int_t *ifail,
    magma_int_t *info )
{
    magma_cheevx(
        magma_vec_const(*jobz), magma_range_const(*range), magma_uplo_const(*uplo), *n,
        A, *lda, *vl, *vu, *il, *iu, *abstol,
        mout,
        w,
        Z, *ldz,
        work, *lwork,
        rwork,
        iwork,
        ifail,
        info );
}

#define magmaf_cheevx_gpu FORTRAN_NAME( magmaf_cheevx_gpu, MAGMAF_CHEEVX_GPU )
void magmaf_cheevx_gpu(
    const char* jobz, const char* range, const char* uplo, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda, float *vl, float *vu, magma_int_t *il, magma_int_t *iu, float *abstol,
    magma_int_t *mout,
    float *w,
    devptr_t *dZ, magma_int_t *lddz,
    magmaFloatComplex *wA, magma_int_t *ldwa,
    magmaFloatComplex *wZ, magma_int_t *ldwz,
    magmaFloatComplex *work, magma_int_t *lwork,
    float *rwork,
    magma_int_t *iwork,
    magma_int_t *ifail,
    magma_int_t *info )
{
    magma_cheevx_gpu(
        magma_vec_const(*jobz), magma_range_const(*range), magma_uplo_const(*uplo), *n,
        magma_cdevptr(dA), *ldda, *vl, *vu, *il, *iu, *abstol,
        mout,
        w,
        magma_cdevptr(dZ), *lddz,
        wA, *ldwa,
        wZ, *ldwz,
        work, *lwork,
        rwork,
        iwork,
        ifail,
        info );
}

#define magmaf_chegst FORTRAN_NAME( magmaf_chegst, MAGMAF_CHEGST )
void magmaf_chegst(
    magma_int_t *itype, const char* uplo, magma_int_t *n,
    magmaFloatComplex *A, magma_int_t *lda,
    magmaFloatComplex *B, magma_int_t *ldb,
    magma_int_t *info )
{
    magma_chegst(
        *itype, magma_uplo_const(*uplo), *n,
        A, *lda,
        B, *ldb,
        info );
}

#define magmaf_chegst_gpu FORTRAN_NAME( magmaf_chegst_gpu, MAGMAF_CHEGST_GPU )
void magmaf_chegst_gpu(
    magma_int_t *itype, const char* uplo, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb,
    magma_int_t *info )
{
    magma_chegst_gpu(
        *itype, magma_uplo_const(*uplo), *n,
        magma_cdevptr(dA), *ldda,
        magma_cdevptr(dB), *lddb,
        info );
}

#define magmaf_chegst_m FORTRAN_NAME( magmaf_chegst_m, MAGMAF_CHEGST_M )
void magmaf_chegst_m(
    magma_int_t *ngpu, magma_int_t *itype, const char* uplo, magma_int_t *n,
    magmaFloatComplex *A, magma_int_t *lda,
    magmaFloatComplex *B, magma_int_t *ldb,
    magma_int_t *info )
{
    magma_chegst_m(
        *ngpu, *itype, magma_uplo_const(*uplo), *n,
        A, *lda,
        B, *ldb,
        info );
}

#define magmaf_chegvd FORTRAN_NAME( magmaf_chegvd, MAGMAF_CHEGVD )
void magmaf_chegvd(
    magma_int_t *itype, const char* jobz, const char* uplo, magma_int_t *n,
    magmaFloatComplex *A, magma_int_t *lda,
    magmaFloatComplex *B, magma_int_t *ldb,
    float *w,
    magmaFloatComplex *work, magma_int_t *lwork,
    float *rwork, magma_int_t *lrwork,
    magma_int_t *iwork, magma_int_t *liwork,
    magma_int_t *info )
{
    magma_chegvd(
        *itype, magma_vec_const(*jobz), magma_uplo_const(*uplo), *n,
        A, *lda,
        B, *ldb,
        w,
        work, *lwork,
        rwork, *lrwork,
        iwork, *liwork,
        info );
}

#define magmaf_chegvd_m FORTRAN_NAME( magmaf_chegvd_m, MAGMAF_CHEGVD_M )
void magmaf_chegvd_m(
    magma_int_t *ngpu, magma_int_t *itype, const char* jobz, const char* uplo, magma_int_t *n,
    magmaFloatComplex *A, magma_int_t *lda,
    magmaFloatComplex *B, magma_int_t *ldb,
    float *w,
    magmaFloatComplex *work, magma_int_t *lwork,
    float *rwork, magma_int_t *lrwork,
    magma_int_t *iwork, magma_int_t *liwork,
    magma_int_t *info )
{
    magma_chegvd_m(
        *ngpu, *itype, magma_vec_const(*jobz), magma_uplo_const(*uplo), *n,
        A, *lda,
        B, *ldb,
        w,
        work, *lwork,
        rwork, *lrwork,
        iwork, *liwork,
        info );
}

#define magmaf_chegvdx FORTRAN_NAME( magmaf_chegvdx, MAGMAF_CHEGVDX )
void magmaf_chegvdx(
    magma_int_t *itype, const char* jobz, const char* range, const char* uplo, magma_int_t *n,
    magmaFloatComplex *A, magma_int_t *lda,
    magmaFloatComplex *B, magma_int_t *ldb, float *vl, float *vu, magma_int_t *il, magma_int_t *iu,
    magma_int_t *mout,
    float *w,
    magmaFloatComplex *work, magma_int_t *lwork,
    float *rwork, magma_int_t *lrwork,
    magma_int_t *iwork, magma_int_t *liwork,
    magma_int_t *info )
{
    magma_chegvdx(
        *itype, magma_vec_const(*jobz), magma_range_const(*range), magma_uplo_const(*uplo), *n,
        A, *lda,
        B, *ldb, *vl, *vu, *il, *iu,
        mout,
        w,
        work, *lwork,
        rwork, *lrwork,
        iwork, *liwork,
        info );
}

#define magmaf_chegvdx_m FORTRAN_NAME( magmaf_chegvdx_m, MAGMAF_CHEGVDX_M )
void magmaf_chegvdx_m(
    magma_int_t *ngpu, magma_int_t *itype, const char* jobz, const char* range, const char* uplo, magma_int_t *n,
    magmaFloatComplex *A, magma_int_t *lda,
    magmaFloatComplex *B, magma_int_t *ldb, float *vl, float *vu, magma_int_t *il, magma_int_t *iu,
    magma_int_t *mout,
    float *w,
    magmaFloatComplex *work, magma_int_t *lwork,
    float *rwork, magma_int_t *lrwork,
    magma_int_t *iwork, magma_int_t *liwork,
    magma_int_t *info )
{
    magma_chegvdx_m(
        *ngpu, *itype, magma_vec_const(*jobz), magma_range_const(*range), magma_uplo_const(*uplo), *n,
        A, *lda,
        B, *ldb, *vl, *vu, *il, *iu,
        mout,
        w,
        work, *lwork,
        rwork, *lrwork,
        iwork, *liwork,
        info );
}

#define magmaf_chegvdx_2stage FORTRAN_NAME( magmaf_chegvdx_2stage, MAGMAF_CHEGVDX_2STAGE )
void magmaf_chegvdx_2stage(
    magma_int_t *itype, const char* jobz, const char* range, const char* uplo, magma_int_t *n,
    magmaFloatComplex *A, magma_int_t *lda,
    magmaFloatComplex *B, magma_int_t *ldb, float *vl, float *vu, magma_int_t *il, magma_int_t *iu,
    magma_int_t *mout,
    float *w,
    magmaFloatComplex *work, magma_int_t *lwork,
    float *rwork, magma_int_t *lrwork,
    magma_int_t *iwork, magma_int_t *liwork,
    magma_int_t *info )
{
    magma_chegvdx_2stage(
        *itype, magma_vec_const(*jobz), magma_range_const(*range), magma_uplo_const(*uplo), *n,
        A, *lda,
        B, *ldb, *vl, *vu, *il, *iu,
        mout,
        w,
        work, *lwork,
        rwork, *lrwork,
        iwork, *liwork,
        info );
}

#define magmaf_chegvdx_2stage_m FORTRAN_NAME( magmaf_chegvdx_2stage_m, MAGMAF_CHEGVDX_2STAGE_M )
void magmaf_chegvdx_2stage_m(
    magma_int_t *ngpu, magma_int_t *itype, const char* jobz, const char* range, const char* uplo, magma_int_t *n,
    magmaFloatComplex *A, magma_int_t *lda,
    magmaFloatComplex *B, magma_int_t *ldb, float *vl, float *vu, magma_int_t *il, magma_int_t *iu,
    magma_int_t *mout,
    float *w,
    magmaFloatComplex *work, magma_int_t *lwork,
    float *rwork, magma_int_t *lrwork,
    magma_int_t *iwork, magma_int_t *liwork,
    magma_int_t *info )
{
    magma_chegvdx_2stage_m(
        *ngpu, *itype, magma_vec_const(*jobz), magma_range_const(*range), magma_uplo_const(*uplo), *n,
        A, *lda,
        B, *ldb, *vl, *vu, *il, *iu,
        mout,
        w,
        work, *lwork,
        rwork, *lrwork,
        iwork, *liwork,
        info );
}

#define magmaf_chegvr FORTRAN_NAME( magmaf_chegvr, MAGMAF_CHEGVR )
void magmaf_chegvr(
    magma_int_t *itype, const char* jobz, const char* range, const char* uplo, magma_int_t *n,
    magmaFloatComplex *A, magma_int_t *lda,
    magmaFloatComplex *B, magma_int_t *ldb, float *vl, float *vu, magma_int_t *il, magma_int_t *iu, float *abstol,
    magma_int_t *mout,
    float *w,
    magmaFloatComplex *Z, magma_int_t *ldz,
    magma_int_t *isuppz,
    magmaFloatComplex *work, magma_int_t *lwork,
    float *rwork, magma_int_t *lrwork,
    magma_int_t *iwork, magma_int_t *liwork,
    magma_int_t *info )
{
    magma_chegvr(
        *itype, magma_vec_const(*jobz), magma_range_const(*range), magma_uplo_const(*uplo), *n,
        A, *lda,
        B, *ldb, *vl, *vu, *il, *iu, *abstol,
        mout,
        w,
        Z, *ldz,
        isuppz,
        work, *lwork,
        rwork, *lrwork,
        iwork, *liwork,
        info );
}

#define magmaf_chegvx FORTRAN_NAME( magmaf_chegvx, MAGMAF_CHEGVX )
void magmaf_chegvx(
    magma_int_t *itype, const char* jobz, const char* range, const char* uplo, magma_int_t *n,
    magmaFloatComplex *A, magma_int_t *lda,
    magmaFloatComplex *B, magma_int_t *ldb, float *vl, float *vu, magma_int_t *il, magma_int_t *iu, float *abstol,
    magma_int_t *mout,
    float *w,
    magmaFloatComplex *Z, magma_int_t *ldz,
    magmaFloatComplex *work, magma_int_t *lwork,
    float *rwork,
    magma_int_t *iwork,
    magma_int_t *ifail,
    magma_int_t *info )
{
    magma_chegvx(
        *itype, magma_vec_const(*jobz), magma_range_const(*range), magma_uplo_const(*uplo), *n,
        A, *lda,
        B, *ldb, *vl, *vu, *il, *iu, *abstol,
        mout,
        w,
        Z, *ldz,
        work, *lwork,
        rwork,
        iwork,
        ifail,
        info );
}

#define magmaf_chesv FORTRAN_NAME( magmaf_chesv, MAGMAF_CHESV )
void magmaf_chesv(
    const char* uplo, magma_int_t *n, magma_int_t *nrhs,
    magmaFloatComplex *A, magma_int_t *lda,
    magma_int_t *ipiv,
    magmaFloatComplex *B, magma_int_t *ldb,
    magma_int_t *info )
{
    magma_chesv(
        magma_uplo_const(*uplo), *n, *nrhs,
        A, *lda,
        ipiv,
        B, *ldb,
        info );
}

#define magmaf_chesv_nopiv_gpu FORTRAN_NAME( magmaf_chesv_nopiv_gpu, MAGMAF_CHESV_NOPIV_GPU )
void magmaf_chesv_nopiv_gpu(
    const char* uplo, magma_int_t *n, magma_int_t *nrhs,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb,
    magma_int_t *info )
{
    magma_chesv_nopiv_gpu(
        magma_uplo_const(*uplo), *n, *nrhs,
        magma_cdevptr(dA), *ldda,
        magma_cdevptr(dB), *lddb,
        info );
}

#define magmaf_chetrd FORTRAN_NAME( magmaf_chetrd, MAGMAF_CHETRD )
void magmaf_chetrd(
    const char* uplo, magma_int_t *n,
    magmaFloatComplex *A, magma_int_t *lda,
    float *d,
    float *e,
    magmaFloatComplex *tau,
    magmaFloatComplex *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_chetrd(
        magma_uplo_const(*uplo), *n,
        A, *lda,
        d,
        e,
        tau,
        work, *lwork,
        info );
}

#define magmaf_chetrd_gpu FORTRAN_NAME( magmaf_chetrd_gpu, MAGMAF_CHETRD_GPU )
void magmaf_chetrd_gpu(
    const char* uplo, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    float *d,
    float *e,
    magmaFloatComplex *tau,
    magmaFloatComplex *wA, magma_int_t *ldwa,
    magmaFloatComplex *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_chetrd_gpu(
        magma_uplo_const(*uplo), *n,
        magma_cdevptr(dA), *ldda,
        d,
        e,
        tau,
        wA, *ldwa,
        work, *lwork,
        info );
}

#define magmaf_chetrd2_gpu FORTRAN_NAME( magmaf_chetrd2_gpu, MAGMAF_CHETRD2_GPU )
void magmaf_chetrd2_gpu(
    const char* uplo, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    float *d,
    float *e,
    magmaFloatComplex *tau,
    magmaFloatComplex *wA, magma_int_t *ldwa,
    magmaFloatComplex *work, magma_int_t *lwork,
    devptr_t *dwork, magma_int_t *ldwork,
    magma_int_t *info )
{
    magma_chetrd2_gpu(
        magma_uplo_const(*uplo), *n,
        magma_cdevptr(dA), *ldda,
        d,
        e,
        tau,
        wA, *ldwa,
        work, *lwork,
        magma_cdevptr(dwork), *ldwork,
        info );
}

#define magmaf_chetrd_hb2st FORTRAN_NAME( magmaf_chetrd_hb2st, MAGMAF_CHETRD_HB2ST )
magma_int_t magmaf_chetrd_hb2st(
    const char* uplo, magma_int_t *n, magma_int_t *nb, magma_int_t *Vblksiz,
    magmaFloatComplex *A, magma_int_t *lda,
    float *d,
    float *e,
    magmaFloatComplex *V, magma_int_t *ldv,
    magmaFloatComplex *TAU, magma_int_t *compT,
    magmaFloatComplex *T, magma_int_t *ldt )
{
    return magma_chetrd_hb2st(
        magma_uplo_const(*uplo), *n, *nb, *Vblksiz,
        A, *lda,
        d,
        e,
        V, *ldv,
        TAU, *compT,
        T, *ldt );
}

#define magmaf_chetrd_he2hb FORTRAN_NAME( magmaf_chetrd_he2hb, MAGMAF_CHETRD_HE2HB )
void magmaf_chetrd_he2hb(
    const char* uplo, magma_int_t *n, magma_int_t *nb,
    magmaFloatComplex *A, magma_int_t *lda,
    magmaFloatComplex *tau,
    magmaFloatComplex *work, magma_int_t *lwork,
    devptr_t *dT,
    magma_int_t *info )
{
    magma_chetrd_he2hb(
        magma_uplo_const(*uplo), *n, *nb,
        A, *lda,
        tau,
        work, *lwork,
        magma_cdevptr(dT),
        info );
}

#define magmaf_chetrf FORTRAN_NAME( magmaf_chetrf, MAGMAF_CHETRF )
void magmaf_chetrf(
    const char* uplo, magma_int_t *n,
    magmaFloatComplex *A, magma_int_t *lda,
    magma_int_t *ipiv,
    magma_int_t *info )
{
    magma_chetrf(
        magma_uplo_const(*uplo), *n,
        A, *lda,
        ipiv,
        info );
}

#define magmaf_chetrf_gpu FORTRAN_NAME( magmaf_chetrf_gpu, MAGMAF_CHETRF_GPU )
void magmaf_chetrf_gpu(
    const char* uplo, magma_int_t *n,
    magmaFloatComplex *dA, magma_int_t *ldda,
    magma_int_t *ipiv,
    magma_int_t *info )
{
    magma_chetrf_gpu(
        magma_uplo_const(*uplo), *n,
        dA, *ldda,
        ipiv,
        info );
}

#define magmaf_chetrf_aasen FORTRAN_NAME( magmaf_chetrf_aasen, MAGMAF_CHETRF_AASEN )
void magmaf_chetrf_aasen(
    const char* uplo, magma_int_t *cpu_panel, magma_int_t *n,
    magmaFloatComplex *A, magma_int_t *lda,
    magma_int_t *ipiv,
    magma_int_t *info )
{
    magma_chetrf_aasen(
        magma_uplo_const(*uplo), *cpu_panel, *n,
        A, *lda,
        ipiv,
        info );
}

#define magmaf_chetrf_nopiv FORTRAN_NAME( magmaf_chetrf_nopiv, MAGMAF_CHETRF_NOPIV )
void magmaf_chetrf_nopiv(
    const char* uplo, magma_int_t *n,
    magmaFloatComplex *A, magma_int_t *lda,
    magma_int_t *info )
{
    magma_chetrf_nopiv(
        magma_uplo_const(*uplo), *n,
        A, *lda,
        info );
}

#define magmaf_chetrf_nopiv_cpu FORTRAN_NAME( magmaf_chetrf_nopiv_cpu, MAGMAF_CHETRF_NOPIV_CPU )
void magmaf_chetrf_nopiv_cpu(
    const char* uplo, magma_int_t *n, magma_int_t *ib,
    magmaFloatComplex *A, magma_int_t *lda,
    magma_int_t *info )
{
    magma_chetrf_nopiv_cpu(
        magma_uplo_const(*uplo), *n, *ib,
        A, *lda,
        info );
}

#define magmaf_chetrf_nopiv_gpu FORTRAN_NAME( magmaf_chetrf_nopiv_gpu, MAGMAF_CHETRF_NOPIV_GPU )
void magmaf_chetrf_nopiv_gpu(
    const char* uplo, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t *info )
{
    magma_chetrf_nopiv_gpu(
        magma_uplo_const(*uplo), *n,
        magma_cdevptr(dA), *ldda,
        info );
}

#define magmaf_chetrs_nopiv_gpu FORTRAN_NAME( magmaf_chetrs_nopiv_gpu, MAGMAF_CHETRS_NOPIV_GPU )
void magmaf_chetrs_nopiv_gpu(
    const char* uplo, magma_int_t *n, magma_int_t *nrhs,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb,
    magma_int_t *info )
{
    magma_chetrs_nopiv_gpu(
        magma_uplo_const(*uplo), *n, *nrhs,
        magma_cdevptr(dA), *ldda,
        magma_cdevptr(dB), *lddb,
        info );
}

#define magmaf_clarf_gpu FORTRAN_NAME( magmaf_clarf_gpu, MAGMAF_CLARF_GPU )
magma_int_t magmaf_clarf_gpu(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dv,
    devptr_t *dtau,
    devptr_t *dC, magma_int_t *lddc, magma_queue_t *queue )
{
    return magma_clarf_gpu(
        *m, *n,
        magma_cdevptr(dv),
        magma_cdevptr(dtau),
        magma_cdevptr(dC), *lddc, *queue );
}

#define magmaf_clarfb2_gpu FORTRAN_NAME( magmaf_clarfb2_gpu, MAGMAF_CLARFB2_GPU )
magma_int_t magmaf_clarfb2_gpu(
    magma_int_t *m, magma_int_t *n, magma_int_t *k,
    devptr_t *dV, magma_int_t *lddv,
    devptr_t *dT, magma_int_t *lddt,
    devptr_t *dC, magma_int_t *lddc,
    devptr_t *dwork, magma_int_t *ldwork, magma_queue_t *queue )
{
    return magma_clarfb2_gpu(
        *m, *n, *k,
        magma_cdevptr(dV), *lddv,
        magma_cdevptr(dT), *lddt,
        magma_cdevptr(dC), *lddc,
        magma_cdevptr(dwork), *ldwork, *queue );
}

#define magmaf_clatrsd FORTRAN_NAME( magmaf_clatrsd, MAGMAF_CLATRSD )
void magmaf_clatrsd(
    const char* uplo, const char* trans, const char* diag, const char* normin, magma_int_t *n,
    magmaFloatComplex *A, magma_int_t *lda, magmaFloatComplex *lambda,
    magmaFloatComplex *x,
    float *scale,
    float *cnorm,
    magma_int_t *info )
{
    magma_clatrsd(
        magma_uplo_const(*uplo), magma_trans_const(*trans), magma_diag_const(*diag), magma_bool_const(*normin), *n,
        A, *lda, *lambda,
        x,
        scale,
        cnorm,
        info );
}

#define magmaf_clauum FORTRAN_NAME( magmaf_clauum, MAGMAF_CLAUUM )
void magmaf_clauum(
    const char* uplo, magma_int_t *n,
    magmaFloatComplex *A, magma_int_t *lda,
    magma_int_t *info )
{
    magma_clauum(
        magma_uplo_const(*uplo), *n,
        A, *lda,
        info );
}

#define magmaf_clauum_gpu FORTRAN_NAME( magmaf_clauum_gpu, MAGMAF_CLAUUM_GPU )
void magmaf_clauum_gpu(
    const char* uplo, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t *info )
{
    magma_clauum_gpu(
        magma_uplo_const(*uplo), *n,
        magma_cdevptr(dA), *ldda,
        info );
}

#define magmaf_cposv FORTRAN_NAME( magmaf_cposv, MAGMAF_CPOSV )
void magmaf_cposv(
    const char* uplo, magma_int_t *n, magma_int_t *nrhs,
    magmaFloatComplex *A, magma_int_t *lda,
    magmaFloatComplex *B, magma_int_t *ldb,
    magma_int_t *info )
{
    magma_cposv(
        magma_uplo_const(*uplo), *n, *nrhs,
        A, *lda,
        B, *ldb,
        info );
}

#define magmaf_cposv_gpu FORTRAN_NAME( magmaf_cposv_gpu, MAGMAF_CPOSV_GPU )
void magmaf_cposv_gpu(
    const char* uplo, magma_int_t *n, magma_int_t *nrhs,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb,
    magma_int_t *info )
{
    magma_cposv_gpu(
        magma_uplo_const(*uplo), *n, *nrhs,
        magma_cdevptr(dA), *ldda,
        magma_cdevptr(dB), *lddb,
        info );
}

#define magmaf_cpotf2_gpu FORTRAN_NAME( magmaf_cpotf2_gpu, MAGMAF_CPOTF2_GPU )
void magmaf_cpotf2_gpu(
    const char* uplo, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda, magma_queue_t *queue,
    magma_int_t *info )
{
    magma_cpotf2_gpu(
        magma_uplo_const(*uplo), *n,
        magma_cdevptr(dA), *ldda, *queue,
        info );
}

#define magmaf_cpotf2_native FORTRAN_NAME( magmaf_cpotf2_native, MAGMAF_CPOTF2_NATIVE )
magma_int_t magmaf_cpotf2_native(
    const char* uplo, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda, magma_int_t *step,
    magma_int_t *device_info, magma_queue_t *queue )
{
    return magma_cpotf2_native(
        magma_uplo_const(*uplo), *n,
        magma_cdevptr(dA), *ldda, *step,
        device_info, *queue );
}

#define magmaf_cpotrf_rectile_native FORTRAN_NAME( magmaf_cpotrf_rectile_native, MAGMAF_CPOTRF_RECTILE_NATIVE )
void magmaf_cpotrf_rectile_native(
    const char* uplo, magma_int_t *n, magma_int_t *recnb,
    magmaFloatComplex* dA, magma_int_t *ldda, magma_int_t *gbstep,
    magma_int_t *dinfo,
    magma_int_t *info, magma_queue_t *queue )
{
    magma_cpotrf_rectile_native(
        magma_uplo_const(*uplo), *n, *recnb,
        dA, *ldda, *gbstep,
        dinfo,
        info, *queue );
}

#define magmaf_cpotrf FORTRAN_NAME( magmaf_cpotrf, MAGMAF_CPOTRF )
void magmaf_cpotrf(
    const char* uplo, magma_int_t *n,
    magmaFloatComplex *A, magma_int_t *lda,
    magma_int_t *info )
{
    magma_cpotrf(
        magma_uplo_const(*uplo), *n,
        A, *lda,
        info );
}

#define magmaf_cpotrf_gpu FORTRAN_NAME( magmaf_cpotrf_gpu, MAGMAF_CPOTRF_GPU )
void magmaf_cpotrf_gpu(
    const char* uplo, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t *info )
{
    magma_cpotrf_gpu(
        magma_uplo_const(*uplo), *n,
        magma_cdevptr(dA), *ldda,
        info );
}

#define magmaf_cpotrf_native FORTRAN_NAME( magmaf_cpotrf_native, MAGMAF_CPOTRF_NATIVE )
void magmaf_cpotrf_native(
    const char* uplo, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t *info )
{
    magma_cpotrf_native(
        magma_uplo_const(*uplo), *n,
        magma_cdevptr(dA), *ldda,
        info );
}

#define magmaf_cpotrf_m FORTRAN_NAME( magmaf_cpotrf_m, MAGMAF_CPOTRF_M )
void magmaf_cpotrf_m(
    magma_int_t *ngpu, const char* uplo, magma_int_t *n,
    magmaFloatComplex *A, magma_int_t *lda,
    magma_int_t *info )
{
    magma_cpotrf_m(
        *ngpu, magma_uplo_const(*uplo), *n,
        A, *lda,
        info );
}

#define magmaf_cpotri FORTRAN_NAME( magmaf_cpotri, MAGMAF_CPOTRI )
void magmaf_cpotri(
    const char* uplo, magma_int_t *n,
    magmaFloatComplex *A, magma_int_t *lda,
    magma_int_t *info )
{
    magma_cpotri(
        magma_uplo_const(*uplo), *n,
        A, *lda,
        info );
}

#define magmaf_cpotri_gpu FORTRAN_NAME( magmaf_cpotri_gpu, MAGMAF_CPOTRI_GPU )
void magmaf_cpotri_gpu(
    const char* uplo, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t *info )
{
    magma_cpotri_gpu(
        magma_uplo_const(*uplo), *n,
        magma_cdevptr(dA), *ldda,
        info );
}

#define magmaf_cpotrs_gpu FORTRAN_NAME( magmaf_cpotrs_gpu, MAGMAF_CPOTRS_GPU )
void magmaf_cpotrs_gpu(
    const char* uplo, magma_int_t *n, magma_int_t *nrhs,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb,
    magma_int_t *info )
{
    magma_cpotrs_gpu(
        magma_uplo_const(*uplo), *n, *nrhs,
        magma_cdevptr(dA), *ldda,
        magma_cdevptr(dB), *lddb,
        info );
}

#define magmaf_csysv_nopiv_gpu FORTRAN_NAME( magmaf_csysv_nopiv_gpu, MAGMAF_CSYSV_NOPIV_GPU )
void magmaf_csysv_nopiv_gpu(
    const char* uplo, magma_int_t *n, magma_int_t *nrhs,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb,
    magma_int_t *info )
{
    magma_csysv_nopiv_gpu(
        magma_uplo_const(*uplo), *n, *nrhs,
        magma_cdevptr(dA), *ldda,
        magma_cdevptr(dB), *lddb,
        info );
}

#define magmaf_csytrf_nopiv_cpu FORTRAN_NAME( magmaf_csytrf_nopiv_cpu, MAGMAF_CSYTRF_NOPIV_CPU )
void magmaf_csytrf_nopiv_cpu(
    const char* uplo, magma_int_t *n, magma_int_t *ib,
    magmaFloatComplex *A, magma_int_t *lda,
    magma_int_t *info )
{
    magma_csytrf_nopiv_cpu(
        magma_uplo_const(*uplo), *n, *ib,
        A, *lda,
        info );
}

#define magmaf_csytrf_nopiv_gpu FORTRAN_NAME( magmaf_csytrf_nopiv_gpu, MAGMAF_CSYTRF_NOPIV_GPU )
void magmaf_csytrf_nopiv_gpu(
    const char* uplo, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t *info )
{
    magma_csytrf_nopiv_gpu(
        magma_uplo_const(*uplo), *n,
        magma_cdevptr(dA), *ldda,
        info );
}

#define magmaf_csytrs_nopiv_gpu FORTRAN_NAME( magmaf_csytrs_nopiv_gpu, MAGMAF_CSYTRS_NOPIV_GPU )
void magmaf_csytrs_nopiv_gpu(
    const char* uplo, magma_int_t *n, magma_int_t *nrhs,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb,
    magma_int_t *info )
{
    magma_csytrs_nopiv_gpu(
        magma_uplo_const(*uplo), *n, *nrhs,
        magma_cdevptr(dA), *ldda,
        magma_cdevptr(dB), *lddb,
        info );
}

#define magmaf_cstedx FORTRAN_NAME( magmaf_cstedx, MAGMAF_CSTEDX )
void magmaf_cstedx(
    const char* range, magma_int_t *n, float *vl, float *vu, magma_int_t *il, magma_int_t *iu,
    float *d,
    float *e,
    magmaFloatComplex *Z, magma_int_t *ldz,
    float *rwork, magma_int_t *lrwork,
    magma_int_t *iwork, magma_int_t *liwork,
    devptr_t *dwork,
    magma_int_t *info )
{
    magma_cstedx(
        magma_range_const(*range), *n, *vl, *vu, *il, *iu,
        d,
        e,
        Z, *ldz,
        rwork, *lrwork,
        iwork, *liwork,
        magma_sdevptr(dwork),
        info );
}

#define magmaf_cstedx_m FORTRAN_NAME( magmaf_cstedx_m, MAGMAF_CSTEDX_M )
void magmaf_cstedx_m(
    magma_int_t *ngpu, const char* range, magma_int_t *n, float *vl, float *vu, magma_int_t *il, magma_int_t *iu,
    float *d,
    float *e,
    magmaFloatComplex *Z, magma_int_t *ldz,
    float *rwork, magma_int_t *lrwork,
    magma_int_t *iwork, magma_int_t *liwork,
    magma_int_t *info )
{
    magma_cstedx_m(
        *ngpu, magma_range_const(*range), *n, *vl, *vu, *il, *iu,
        d,
        e,
        Z, *ldz,
        rwork, *lrwork,
        iwork, *liwork,
        info );
}

#define magmaf_ctrevc3 FORTRAN_NAME( magmaf_ctrevc3, MAGMAF_CTREVC3 )
void magmaf_ctrevc3(
    const char* side, const char* howmany,
    magma_int_t *select, magma_int_t *n,
    magmaFloatComplex *T, magma_int_t *ldt,
    magmaFloatComplex *VL, magma_int_t *ldvl,
    magmaFloatComplex *VR, magma_int_t *ldvr, magma_int_t *mm,
    magma_int_t *mout,
    magmaFloatComplex *work, magma_int_t *lwork,
    float *rwork,
    magma_int_t *info )
{
    magma_ctrevc3(
        magma_side_const(*side), magma_vec_const(*howmany),
        select, *n,
        T, *ldt,
        VL, *ldvl,
        VR, *ldvr, *mm,
        mout,
        work, *lwork,
        rwork,
        info );
}

#define magmaf_ctrevc3_mt FORTRAN_NAME( magmaf_ctrevc3_mt, MAGMAF_CTREVC3_MT )
void magmaf_ctrevc3_mt(
    const char* side, const char* howmany,
    magma_int_t *select, magma_int_t *n,
    magmaFloatComplex *T, magma_int_t *ldt,
    magmaFloatComplex *VL, magma_int_t *ldvl,
    magmaFloatComplex *VR, magma_int_t *ldvr, magma_int_t *mm,
    magma_int_t *mout,
    magmaFloatComplex *work, magma_int_t *lwork,
    float *rwork,
    magma_int_t *info )
{
    magma_ctrevc3_mt(
        magma_side_const(*side), magma_vec_const(*howmany),
        select, *n,
        T, *ldt,
        VL, *ldvl,
        VR, *ldvr, *mm,
        mout,
        work, *lwork,
        rwork,
        info );
}

#define magmaf_ctrsm_m FORTRAN_NAME( magmaf_ctrsm_m, MAGMAF_CTRSM_M )
magma_int_t magmaf_ctrsm_m(
    magma_int_t *ngpu, const char* side, const char* uplo, const char* transa, const char* diag, magma_int_t *m, magma_int_t *n, magmaFloatComplex *alpha,
    magmaFloatComplex *A, magma_int_t *lda,
    magmaFloatComplex *B, magma_int_t *ldb )
{
    return magma_ctrsm_m(
        *ngpu, magma_side_const(*side), magma_uplo_const(*uplo), magma_trans_const(*transa), magma_diag_const(*diag), *m, *n, *alpha,
        A, *lda,
        B, *ldb );
}

#define magmaf_ctrtri FORTRAN_NAME( magmaf_ctrtri, MAGMAF_CTRTRI )
void magmaf_ctrtri(
    const char* uplo, const char* diag, magma_int_t *n,
    magmaFloatComplex *A, magma_int_t *lda,
    magma_int_t *info )
{
    magma_ctrtri(
        magma_uplo_const(*uplo), magma_diag_const(*diag), *n,
        A, *lda,
        info );
}

#define magmaf_ctrtri_gpu FORTRAN_NAME( magmaf_ctrtri_gpu, MAGMAF_CTRTRI_GPU )
void magmaf_ctrtri_gpu(
    const char* uplo, const char* diag, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t *info )
{
    magma_ctrtri_gpu(
        magma_uplo_const(*uplo), magma_diag_const(*diag), *n,
        magma_cdevptr(dA), *ldda,
        info );
}

#define magmaf_cungbr FORTRAN_NAME( magmaf_cungbr, MAGMAF_CUNGBR )
void magmaf_cungbr(
    const char* vect, magma_int_t *m, magma_int_t *n, magma_int_t *k,
    magmaFloatComplex *A, magma_int_t *lda,
    magmaFloatComplex *tau,
    magmaFloatComplex *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_cungbr(
        magma_vect_const(*vect), *m, *n, *k,
        A, *lda,
        tau,
        work, *lwork,
        info );
}

#define magmaf_cunghr FORTRAN_NAME( magmaf_cunghr, MAGMAF_CUNGHR )
void magmaf_cunghr(
    magma_int_t *n, magma_int_t *ilo, magma_int_t *ihi,
    magmaFloatComplex *A, magma_int_t *lda,
    magmaFloatComplex *tau,
    devptr_t *dT, magma_int_t *nb,
    magma_int_t *info )
{
    magma_cunghr(
        *n, *ilo, *ihi,
        A, *lda,
        tau,
        magma_cdevptr(dT), *nb,
        info );
}

#define magmaf_cunghr_m FORTRAN_NAME( magmaf_cunghr_m, MAGMAF_CUNGHR_M )
void magmaf_cunghr_m(
    magma_int_t *n, magma_int_t *ilo, magma_int_t *ihi,
    magmaFloatComplex *A, magma_int_t *lda,
    magmaFloatComplex *tau,
    magmaFloatComplex *T, magma_int_t *nb,
    magma_int_t *info )
{
    magma_cunghr_m(
        *n, *ilo, *ihi,
        A, *lda,
        tau,
        T, *nb,
        info );
}

#define magmaf_cunglq FORTRAN_NAME( magmaf_cunglq, MAGMAF_CUNGLQ )
void magmaf_cunglq(
    magma_int_t *m, magma_int_t *n, magma_int_t *k,
    magmaFloatComplex *A, magma_int_t *lda,
    magmaFloatComplex *tau,
    devptr_t *dT, magma_int_t *nb,
    magma_int_t *info )
{
    magma_cunglq(
        *m, *n, *k,
        A, *lda,
        tau,
        magma_cdevptr(dT), *nb,
        info );
}

#define magmaf_cungqr FORTRAN_NAME( magmaf_cungqr, MAGMAF_CUNGQR )
void magmaf_cungqr(
    magma_int_t *m, magma_int_t *n, magma_int_t *k,
    magmaFloatComplex *A, magma_int_t *lda,
    magmaFloatComplex *tau,
    devptr_t *dT, magma_int_t *nb,
    magma_int_t *info )
{
    magma_cungqr(
        *m, *n, *k,
        A, *lda,
        tau,
        magma_cdevptr(dT), *nb,
        info );
}

#define magmaf_cungqr_gpu FORTRAN_NAME( magmaf_cungqr_gpu, MAGMAF_CUNGQR_GPU )
void magmaf_cungqr_gpu(
    magma_int_t *m, magma_int_t *n, magma_int_t *k,
    devptr_t *dA, magma_int_t *ldda,
    magmaFloatComplex *tau,
    devptr_t *dT, magma_int_t *nb,
    magma_int_t *info )
{
    magma_cungqr_gpu(
        *m, *n, *k,
        magma_cdevptr(dA), *ldda,
        tau,
        magma_cdevptr(dT), *nb,
        info );
}

#define magmaf_cungqr_m FORTRAN_NAME( magmaf_cungqr_m, MAGMAF_CUNGQR_M )
void magmaf_cungqr_m(
    magma_int_t *m, magma_int_t *n, magma_int_t *k,
    magmaFloatComplex *A, magma_int_t *lda,
    magmaFloatComplex *tau,
    magmaFloatComplex *T, magma_int_t *nb,
    magma_int_t *info )
{
    magma_cungqr_m(
        *m, *n, *k,
        A, *lda,
        tau,
        T, *nb,
        info );
}

#define magmaf_cungqr2 FORTRAN_NAME( magmaf_cungqr2, MAGMAF_CUNGQR2 )
void magmaf_cungqr2(
    magma_int_t *m, magma_int_t *n, magma_int_t *k,
    magmaFloatComplex *A, magma_int_t *lda,
    magmaFloatComplex *tau,
    magma_int_t *info )
{
    magma_cungqr2(
        *m, *n, *k,
        A, *lda,
        tau,
        info );
}

#define magmaf_cunmbr FORTRAN_NAME( magmaf_cunmbr, MAGMAF_CUNMBR )
void magmaf_cunmbr(
    const char* vect, const char* side, const char* trans, magma_int_t *m, magma_int_t *n, magma_int_t *k,
    magmaFloatComplex *A, magma_int_t *lda,
    magmaFloatComplex *tau,
    magmaFloatComplex *C, magma_int_t *ldc,
    magmaFloatComplex *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_cunmbr(
        magma_vect_const(*vect), magma_side_const(*side), magma_trans_const(*trans), *m, *n, *k,
        A, *lda,
        tau,
        C, *ldc,
        work, *lwork,
        info );
}

#define magmaf_cunmlq FORTRAN_NAME( magmaf_cunmlq, MAGMAF_CUNMLQ )
void magmaf_cunmlq(
    const char* side, const char* trans, magma_int_t *m, magma_int_t *n, magma_int_t *k,
    magmaFloatComplex *A, magma_int_t *lda,
    magmaFloatComplex *tau,
    magmaFloatComplex *C, magma_int_t *ldc,
    magmaFloatComplex *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_cunmlq(
        magma_side_const(*side), magma_trans_const(*trans), *m, *n, *k,
        A, *lda,
        tau,
        C, *ldc,
        work, *lwork,
        info );
}

#define magmaf_cunmrq FORTRAN_NAME( magmaf_cunmrq, MAGMAF_CUNMRQ )
void magmaf_cunmrq(
    const char* side, const char* trans, magma_int_t *m, magma_int_t *n, magma_int_t *k,
    magmaFloatComplex *A, magma_int_t *lda,
    magmaFloatComplex *tau,
    magmaFloatComplex *C, magma_int_t *ldc,
    magmaFloatComplex *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_cunmrq(
        magma_side_const(*side), magma_trans_const(*trans), *m, *n, *k,
        A, *lda,
        tau,
        C, *ldc,
        work, *lwork,
        info );
}

#define magmaf_cunmql FORTRAN_NAME( magmaf_cunmql, MAGMAF_CUNMQL )
void magmaf_cunmql(
    const char* side, const char* trans, magma_int_t *m, magma_int_t *n, magma_int_t *k,
    magmaFloatComplex *A, magma_int_t *lda,
    magmaFloatComplex *tau,
    magmaFloatComplex *C, magma_int_t *ldc,
    magmaFloatComplex *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_cunmql(
        magma_side_const(*side), magma_trans_const(*trans), *m, *n, *k,
        A, *lda,
        tau,
        C, *ldc,
        work, *lwork,
        info );
}

#define magmaf_cunmql2_gpu FORTRAN_NAME( magmaf_cunmql2_gpu, MAGMAF_CUNMQL2_GPU )
void magmaf_cunmql2_gpu(
    const char* side, const char* trans, magma_int_t *m, magma_int_t *n, magma_int_t *k,
    devptr_t *dA, magma_int_t *ldda,
    magmaFloatComplex *tau,
    devptr_t *dC, magma_int_t *lddc,
    magmaFloatComplex *wA, magma_int_t *ldwa,
    magma_int_t *info )
{
    magma_cunmql2_gpu(
        magma_side_const(*side), magma_trans_const(*trans), *m, *n, *k,
        magma_cdevptr(dA), *ldda,
        tau,
        magma_cdevptr(dC), *lddc,
        wA, *ldwa,
        info );
}

#define magmaf_cunmqr FORTRAN_NAME( magmaf_cunmqr, MAGMAF_CUNMQR )
void magmaf_cunmqr(
    const char* side, const char* trans, magma_int_t *m, magma_int_t *n, magma_int_t *k,
    magmaFloatComplex *A, magma_int_t *lda,
    magmaFloatComplex *tau,
    magmaFloatComplex *C, magma_int_t *ldc,
    magmaFloatComplex *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_cunmqr(
        magma_side_const(*side), magma_trans_const(*trans), *m, *n, *k,
        A, *lda,
        tau,
        C, *ldc,
        work, *lwork,
        info );
}

#define magmaf_cunmqr_gpu FORTRAN_NAME( magmaf_cunmqr_gpu, MAGMAF_CUNMQR_GPU )
void magmaf_cunmqr_gpu(
    const char* side, const char* trans, magma_int_t *m, magma_int_t *n, magma_int_t *k,
    devptr_t *dA, magma_int_t *ldda,
    magmaFloatComplex *tau,
    devptr_t *dC, magma_int_t *lddc,
    magmaFloatComplex *hwork, magma_int_t *lwork,
    devptr_t *dT, magma_int_t *nb,
    magma_int_t *info )
{
    magma_cunmqr_gpu(
        magma_side_const(*side), magma_trans_const(*trans), *m, *n, *k,
        magma_cdevptr(dA), *ldda,
        tau,
        magma_cdevptr(dC), *lddc,
        hwork, *lwork,
        magma_cdevptr(dT), *nb,
        info );
}

#define magmaf_cunmqr2_gpu FORTRAN_NAME( magmaf_cunmqr2_gpu, MAGMAF_CUNMQR2_GPU )
void magmaf_cunmqr2_gpu(
    const char* side, const char* trans, magma_int_t *m, magma_int_t *n, magma_int_t *k,
    devptr_t *dA, magma_int_t *ldda,
    magmaFloatComplex *tau,
    devptr_t *dC, magma_int_t *lddc,
    magmaFloatComplex *wA, magma_int_t *ldwa,
    magma_int_t *info )
{
    magma_cunmqr2_gpu(
        magma_side_const(*side), magma_trans_const(*trans), *m, *n, *k,
        magma_cdevptr(dA), *ldda,
        tau,
        magma_cdevptr(dC), *lddc,
        wA, *ldwa,
        info );
}

#define magmaf_cunmqr_m FORTRAN_NAME( magmaf_cunmqr_m, MAGMAF_CUNMQR_M )
void magmaf_cunmqr_m(
    magma_int_t *ngpu, const char* side, const char* trans, magma_int_t *m, magma_int_t *n, magma_int_t *k,
    magmaFloatComplex *A, magma_int_t *lda,
    magmaFloatComplex *tau,
    magmaFloatComplex *C, magma_int_t *ldc,
    magmaFloatComplex *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_cunmqr_m(
        *ngpu, magma_side_const(*side), magma_trans_const(*trans), *m, *n, *k,
        A, *lda,
        tau,
        C, *ldc,
        work, *lwork,
        info );
}

#define magmaf_cunmtr FORTRAN_NAME( magmaf_cunmtr, MAGMAF_CUNMTR )
void magmaf_cunmtr(
    const char* side, const char* uplo, const char* trans, magma_int_t *m, magma_int_t *n,
    magmaFloatComplex *A, magma_int_t *lda,
    magmaFloatComplex *tau,
    magmaFloatComplex *C, magma_int_t *ldc,
    magmaFloatComplex *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_cunmtr(
        magma_side_const(*side), magma_uplo_const(*uplo), magma_trans_const(*trans), *m, *n,
        A, *lda,
        tau,
        C, *ldc,
        work, *lwork,
        info );
}

#define magmaf_cunmtr_gpu FORTRAN_NAME( magmaf_cunmtr_gpu, MAGMAF_CUNMTR_GPU )
void magmaf_cunmtr_gpu(
    const char* side, const char* uplo, const char* trans, magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magmaFloatComplex *tau,
    devptr_t *dC, magma_int_t *lddc,
    magmaFloatComplex *wA, magma_int_t *ldwa,
    magma_int_t *info )
{
    magma_cunmtr_gpu(
        magma_side_const(*side), magma_uplo_const(*uplo), magma_trans_const(*trans), *m, *n,
        magma_cdevptr(dA), *ldda,
        tau,
        magma_cdevptr(dC), *lddc,
        wA, *ldwa,
        info );
}

#define magmaf_cunmtr_m FORTRAN_NAME( magmaf_cunmtr_m, MAGMAF_CUNMTR_M )
void magmaf_cunmtr_m(
    magma_int_t *ngpu, const char* side, const char* uplo, const char* trans, magma_int_t *m, magma_int_t *n,
    magmaFloatComplex *A, magma_int_t *lda,
    magmaFloatComplex *tau,
    magmaFloatComplex *C, magma_int_t *ldc,
    magmaFloatComplex *work, magma_int_t *lwork,
    magma_int_t *info )
{
    magma_cunmtr_m(
        *ngpu, magma_side_const(*side), magma_uplo_const(*uplo), magma_trans_const(*trans), *m, *n,
        A, *lda,
        tau,
        C, *ldc,
        work, *lwork,
        info );
}

#define magmaf_c_isnan FORTRAN_NAME( magmaf_c_isnan, MAGMAF_C_ISNAN )
int magmaf_c_isnan(
    magmaFloatComplex *x )
{
    return magma_c_isnan(
        *x );
}

#define magmaf_c_isinf FORTRAN_NAME( magmaf_c_isinf, MAGMAF_C_ISINF )
int magmaf_c_isinf(
    magmaFloatComplex *x )
{
    return magma_c_isinf(
        *x );
}

#define magmaf_c_isnan_inf FORTRAN_NAME( magmaf_c_isnan_inf, MAGMAF_C_ISNAN_INF )
int magmaf_c_isnan_inf(
    magmaFloatComplex *x )
{
    return magma_c_isnan_inf(
        *x );
}

#define magmaf_cnan_inf FORTRAN_NAME( magmaf_cnan_inf, MAGMAF_CNAN_INF )
magma_int_t magmaf_cnan_inf(
    const char* uplo, magma_int_t *m, magma_int_t *n,
    magmaFloatComplex *A, magma_int_t *lda,
    magma_int_t *cnt_nan,
    magma_int_t *cnt_inf )
{
    return magma_cnan_inf(
        magma_uplo_const(*uplo), *m, *n,
        A, *lda,
        cnt_nan,
        cnt_inf );
}

#define magmaf_cnan_inf_gpu FORTRAN_NAME( magmaf_cnan_inf_gpu, MAGMAF_CNAN_INF_GPU )
magma_int_t magmaf_cnan_inf_gpu(
    const char* uplo, magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    magma_int_t *cnt_nan,
    magma_int_t *cnt_inf, magma_queue_t *queue )
{
    return magma_cnan_inf_gpu(
        magma_uplo_const(*uplo), *m, *n,
        magma_cdevptr(dA), *ldda,
        cnt_nan,
        cnt_inf, *queue );
}

#define magmaf_cprint FORTRAN_NAME( magmaf_cprint, MAGMAF_CPRINT )
void magmaf_cprint(
    magma_int_t *m, magma_int_t *n,
    magmaFloatComplex *A, magma_int_t *lda )
{
    magma_cprint(
        *m, *n,
        A, *lda );
}

#define magmaf_cprint_gpu FORTRAN_NAME( magmaf_cprint_gpu, MAGMAF_CPRINT_GPU )
void magmaf_cprint_gpu(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda, magma_queue_t *queue )
{
    magma_cprint_gpu(
        *m, *n,
        magma_cdevptr(dA), *ldda, *queue );
}

#define magmaf_cpanel_to_q FORTRAN_NAME( magmaf_cpanel_to_q, MAGMAF_CPANEL_TO_Q )
void magmaf_cpanel_to_q(
    const char* uplo, magma_int_t *ib,
    magmaFloatComplex *A, magma_int_t *lda,
    magmaFloatComplex *work )
{
    magma_cpanel_to_q(
        magma_uplo_const(*uplo), *ib,
        A, *lda,
        work );
}

#define magmaf_cq_to_panel FORTRAN_NAME( magmaf_cq_to_panel, MAGMAF_CQ_TO_PANEL )
void magmaf_cq_to_panel(
    const char* uplo, magma_int_t *ib,
    magmaFloatComplex *A, magma_int_t *lda,
    magmaFloatComplex *work )
{
    magma_cq_to_panel(
        magma_uplo_const(*uplo), *ib,
        A, *lda,
        work );
}

#define magmablasf_cextract_diag_sqrt FORTRAN_NAME( magmablasf_cextract_diag_sqrt, MAGMABLASF_CEXTRACT_DIAG_SQRT )
void magmablasf_cextract_diag_sqrt(
    magma_int_t *m, magma_int_t *n,
    magmaFloatComplex* dA, magma_int_t *ldda,
    float* dD, magma_int_t *incd, magma_queue_t *queue )
{
    magmablas_cextract_diag_sqrt(
        *m, *n,
        dA, *ldda,
        dD, *incd, *queue );
}

#define magmablasf_cscal_shift_hpd FORTRAN_NAME( magmablasf_cscal_shift_hpd, MAGMABLASF_CSCAL_SHIFT_HPD )
void magmablasf_cscal_shift_hpd(
    const char* uplo, int *n,
    magmaFloatComplex* dA, int *ldda,
    float* dD, int *incd, float *miu, float *cn, float *eps, magma_queue_t *queue )
{
    magmablas_cscal_shift_hpd(
        magma_uplo_const(*uplo), *n,
        dA, *ldda,
        dD, *incd, *miu, *cn, *eps, *queue );
}

#define magmablasf_cdimv_invert FORTRAN_NAME( magmablasf_cdimv_invert, MAGMABLASF_CDIMV_INVERT )
void magmablasf_cdimv_invert(
    magma_int_t *n, magmaFloatComplex *alpha,
    magmaFloatComplex* dD, magma_int_t *incd,
    magmaFloatComplex* dx, magma_int_t *incx, magmaFloatComplex *beta,
    magmaFloatComplex* dy, magma_int_t *incy, magma_queue_t *queue )
{
    magmablas_cdimv_invert(
        *n, *alpha,
        dD, *incd,
        dx, *incx, *beta,
        dy, *incy, *queue );
}


#ifdef __cplusplus
}
#endif
