#ifndef BATCHED_GESVJ_PARAM_H
#define BATCHED_GESVJ_PARAM_H

// Tuning for batch GESVJ
// Based on batches of 1k matrices on certain GPUs
// TODO: revisit tuning for complex precisions
#ifdef MAGMA_HAVE_CUDA
// Ampere
#define zgesvj_ss_nthreads_sm80 \
1,  2,  2,  2,  2,  2,  2,  2, \
4,  4,  4,  4,  4,  4,  4,  4, \
4,  4,  4,  4,  4,  4,  4,  4, \
4,  4,  4,  4,  4,  4,  4,  4, \
8,  8,  8,  8,  8,  8,  8,  8, \
8,  8,  8,  8,  8,  8,  8,  8, \
8,  8,  8,  8,  8,  8,  8,  8, \
8,  8,  8,  8,  8,  8,  8,  8

#define zgesvj_sn_nthreads_sm80 \
1,  2,  2,  2,  2,  2,  2,  2, \
4,  4,  4,  4,  4,  4,  4,  4, \
4,  4,  4,  4,  4,  4,  4,  4, \
4,  4,  4,  4,  4,  4,  4,  4, \
8,  8,  8,  8,  8,  8,  8,  8, \
8,  8,  8,  8,  8,  8,  8,  8, \
8,  8,  8,  8,  8,  8,  8,  8, \
8,  8,  8,  8,  8,  8,  8,  8

#define cgesvj_ss_nthreads_sm80 \
1,  2,  2,  2,  2,  2,  2,  2, \
4,  4,  4,  4,  4,  4,  4,  4, \
4,  4,  4,  4,  4,  4,  4,  4, \
4,  4,  4,  4,  4,  4,  4,  4, \
8,  8,  8,  8,  8,  8,  8,  8, \
8,  8,  8,  8,  8,  8,  8,  8, \
8,  8,  8,  8,  8,  8,  8,  8, \
8,  8,  8,  8,  8,  8,  8,  8

#define cgesvj_sn_nthreads_sm80 \
1,  2,  2,  2,  2,  2,  2,  2, \
4,  4,  4,  4,  4,  4,  4,  4, \
4,  4,  4,  4,  4,  4,  4,  4, \
4,  4,  4,  4,  4,  4,  4,  4, \
8,  8,  8,  8,  8,  8,  8,  8, \
8,  8,  8,  8,  8,  8,  8,  8, \
8,  8,  8,  8,  8,  8,  8,  8, \
8,  8,  8,  8,  8,  8,  8,  8

#define dgesvj_ss_nthreads_sm80 \
 1,  2,  2,  4,  2,  4,  5,  8, \
 6,  6,  4,  4,  4,  4,  4,  4, \
 3,  3,  3,  3,  4,  2,  2,  2, \
 2,  2,  2,  2,  4,  2,  8,  8, \
 4,  6,  6,  6,  4,  4,  4,  4, \
 4,  3,  6,  6,  4,  8,  4,  2, \
 4,  6,  6,  6,  4,  4,  4,  3, \
 6,  6,  6,  6,  4,  8,  8,  8

#define dgesvj_sn_nthreads_sm80 \
 1,  2,  3,  3,  2,  6,  7,  8, \
 6,  6,  4,  4,  4,  4,  4,  4, \
 3,  3,  3,  3,  2,  2,  2,  2, \
 4,  2,  2,  2,  4,  2,  2,  2, \
 3,  3,  3,  3,  3,  3,  3,  2, \
 4,  6,  2,  2,  4,  2,  2,  2, \
 4,  2,  2,  2,  4,  2,  2,  2, \
 4,  2,  2,  6,  4,  2,  2,  2

#define sgesvj_ss_nthreads_sm80 \
 1,  2,  3,  3,  4,  6,  7,  4, \
 6,  5,  6,  4,  4,  4,  4,  4, \
 6,  6,  5,  3,  5,  5,  5,  5, \
 4,  4,  4,  4,  4,  4,  4,  4, \
 3,  5,  5,  3,  5,  3,  3,  3, \
 6,  6,  4,  4,  4,  4,  4,  4, \
 5,  5,  6,  6,  4,  4,  4,  4, \
 4,  4,  4,  4,  4,  4,  4,  4

#define sgesvj_sn_nthreads_sm80 \
 1,  2,  2,  3,  3,  4,  7,  8, \
 6,  5,  4,  4,  4,  4,  4,  4, \
 3,  3,  3,  3,  5,  5,  5,  5, \
 4,  4,  4,  4,  4,  4,  4,  4, \
 3,  5,  5,  3,  5,  5,  3,  3, \
 3,  3,  4,  4,  4,  4,  4,  4, \
 5,  5,  3,  2,  3,  3,  3,  3, \
 3,  2,  4,  4,  4,  4,  4,  4


// Volta
#define zgesvj_ss_nthreads_sm70 \
1,  2,  2,  2,  2,  2,  2,  2, \
4,  4,  4,  4,  4,  4,  4,  4, \
4,  4,  4,  4,  4,  4,  4,  4, \
4,  4,  4,  4,  4,  4,  4,  4, \
8,  8,  8,  8,  8,  8,  8,  8, \
8,  8,  8,  8,  8,  8,  8,  8, \
8,  8,  8,  8,  8,  8,  8,  8, \
8,  8,  8,  8,  8,  8,  8,  8

#define zgesvj_sn_nthreads_sm70 \
1,  2,  2,  2,  2,  2,  2,  2, \
4,  4,  4,  4,  4,  4,  4,  4, \
4,  4,  4,  4,  4,  4,  4,  4, \
4,  4,  4,  4,  4,  4,  4,  4, \
8,  8,  8,  8,  8,  8,  8,  8, \
8,  8,  8,  8,  8,  8,  8,  8, \
8,  8,  8,  8,  8,  8,  8,  8, \
8,  8,  8,  8,  8,  8,  8,  8

#define cgesvj_ss_nthreads_sm70 \
1,  2,  2,  2,  2,  2,  2,  2, \
4,  4,  4,  4,  4,  4,  4,  4, \
4,  4,  4,  4,  4,  4,  4,  4, \
4,  4,  4,  4,  4,  4,  4,  4, \
8,  8,  8,  8,  8,  8,  8,  8, \
8,  8,  8,  8,  8,  8,  8,  8, \
8,  8,  8,  8,  8,  8,  8,  8, \
8,  8,  8,  8,  8,  8,  8,  8

#define cgesvj_sn_nthreads_sm70 \
1,  2,  2,  2,  2,  2,  2,  2, \
4,  4,  4,  4,  4,  4,  4,  4, \
4,  4,  4,  4,  4,  4,  4,  4, \
4,  4,  4,  4,  4,  4,  4,  4, \
8,  8,  8,  8,  8,  8,  8,  8, \
8,  8,  8,  8,  8,  8,  8,  8, \
8,  8,  8,  8,  8,  8,  8,  8, \
8,  8,  8,  8,  8,  8,  8,  8

#define dgesvj_ss_nthreads_sm70 \
 1,  2,  3,  2,  3,  6,  4,  8, \
 6,  6,  4,  4,  4,  4,  4,  2, \
 3,  3,  6,  4,  4,  2,  4,  4, \
 4,  4,  4,  4,  4,  4,  4,  4, \
 6,  6,  6,  4,  4,  4,  8,  4, \
 4,  5,  6,  6,  4,  8,  8,  8, \
 4,  6,  6,  4,  8,  8,  8,  8, \
 6,  6,  6,  6,  8,  8,  8,  8

#define dgesvj_sn_nthreads_sm70 \
 1,  2,  3,  2,  5,  6,  4,  4, \
 3,  4,  4,  4,  4,  4,  4,  4, \
 3,  3,  3,  3,  2,  2,  2,  2, \
 2,  2,  2,  2,  4,  2,  2,  2, \
 3,  3,  3,  3,  2,  3,  3,  4, \
 4,  6,  4,  4,  4,  4,  4,  4, \
 4,  4,  2,  6,  4,  4,  4,  4, \
 4,  4,  3,  2,  4,  4,  4,  4

#define sgesvj_ss_nthreads_sm70 \
 1,  2,  2,  2,  5,  6,  4,  8, \
 5,  5,  4,  4,  4,  4,  4,  4, \
 3,  3,  3,  3,  5,  5,  5,  5, \
 4,  4,  2,  2,  4,  4,  4,  4, \
 5,  5,  7,  6,  5,  5,  6,  6, \
 6,  6,  4,  4,  4,  4,  4,  4, \
 5,  5,  6,  4,  8,  7,  8,  8, \
 6,  6,  6,  6,  8,  4,  4,  4

#define sgesvj_sn_nthreads_sm70 \
 1,  2,  3,  4,  2,  3,  4,  4, \
 6,  5,  4,  4,  4,  4,  4,  4, \
 3,  3,  3,  3,  2,  2,  5,  5, \
 2,  2,  4,  4,  4,  2,  4,  2, \
 3,  3,  3,  3,  3,  3,  3,  3, \
 3,  3,  4,  4,  4,  4,  4,  4, \
 5,  5,  4,  4,  3,  3,  4,  4, \
 4,  4,  4,  4,  4,  4,  4,  4

//-----------------------------------------------------------------------------
#elif defined(MAGMA_HAVE_HIP)
// MI100
#define zgesvj_ss_nthreads_gfx908 \
1,  2,  2,  2,  2,  2,  2,  2, \
4,  4,  4,  4,  4,  4,  4,  4, \
4,  4,  4,  4,  4,  4,  4,  4, \
4,  4,  4,  4,  4,  4,  4,  4, \
8,  8,  8,  8,  8,  8,  8,  8, \
8,  8,  8,  8,  8,  8,  8,  8, \
8,  8,  8,  8,  8,  8,  8,  8, \
8,  8,  8,  8,  8,  8,  8,  8

#define zgesvj_sn_nthreads_gfx908 \
1,  2,  2,  2,  2,  2,  2,  2, \
4,  4,  4,  4,  4,  4,  4,  4, \
4,  4,  4,  4,  4,  4,  4,  4, \
4,  4,  4,  4,  4,  4,  4,  4, \
8,  8,  8,  8,  8,  8,  8,  8, \
8,  8,  8,  8,  8,  8,  8,  8, \
8,  8,  8,  8,  8,  8,  8,  8, \
8,  8,  8,  8,  8,  8,  8,  8

#define cgesvj_ss_nthreads_gfx908 \
1,  2,  2,  2,  2,  2,  2,  2, \
4,  4,  4,  4,  4,  4,  4,  4, \
4,  4,  4,  4,  4,  4,  4,  4, \
4,  4,  4,  4,  4,  4,  4,  4, \
8,  8,  8,  8,  8,  8,  8,  8, \
8,  8,  8,  8,  8,  8,  8,  8, \
8,  8,  8,  8,  8,  8,  8,  8, \
8,  8,  8,  8,  8,  8,  8,  8

#define cgesvj_sn_nthreads_gfx908 \
1,  2,  2,  2,  2,  2,  2,  2, \
4,  4,  4,  4,  4,  4,  4,  4, \
4,  4,  4,  4,  4,  4,  4,  4, \
4,  4,  4,  4,  4,  4,  4,  4, \
8,  8,  8,  8,  8,  8,  8,  8, \
8,  8,  8,  8,  8,  8,  8,  8, \
8,  8,  8,  8,  8,  8,  8,  8, \
8,  8,  8,  8,  8,  8,  8,  8

#define dgesvj_ss_nthreads_gfx908 \
 1,  2,  2,  4,  4,  4,  7,  3, \
 8,  8,  3,  4,  7,  7,  8,  8, \
 6,  5,  4,  4,  4,  4,  5,  4, \
 3,  2,  4,  4,  4,  4,  8,  4, \
 3,  3,  7,  8,  8,  8,  8,  8, \
 5,  5,  8,  8,  8,  8,  8,  8, \
 7,  8,  8,  8,  8,  8,  8,  8, \
 8,  8,  8,  7,  2,  2,  2,  2

#define dgesvj_sn_nthreads_gfx908 \
 1,  2,  2,  3,  4,  2,  4,  4, \
 7,  4,  4,  6,  7,  7,  7,  8, \
 7,  4,  4,  5,  5,  4,  4,  5, \
 3,  2,  4,  4,  4,  4,  4,  4, \
 3,  3,  3,  2,  6,  6,  3,  4, \
 6,  6,  4,  5,  5,  4,  3,  2, \
 7,  8,  7,  7,  7,  7,  8,  8, \
 4,  4,  3,  2,  2,  2,  2,  2

#define sgesvj_ss_nthreads_gfx908 \
 1,  2,  2,  2,  5,  6,  4,  8, \
 8,  6,  6,  6,  8,  6,  5,  8, \
 6,  6,  6,  5,  4,  5,  4,  4, \
 4,  4,  4,  4,  4,  4,  4,  4, \
 7,  7,  7,  6, 13, 13,  8, 10, \
12, 11, 11,  8,  8,  8,  7,  6, \
10, 10,  8,  8,  8,  8,  8,  7, \
 8,  8,  8,  6,  6,  6,  6,  6

#define sgesvj_sn_nthreads_gfx908 \
 1,  2,  2,  2,  5,  3,  7,  6, \
 4,  5,  7,  3,  7,  7,  8,  4, \
 5,  4,  4,  4,  5,  5,  4,  4, \
 4,  4,  4,  4,  4,  4,  4,  4, \
 3,  7,  3,  3,  3,  2,  3,  3, \
 3,  3,  8,  5,  8,  8,  8,  7, \
 5,  5,  4,  8,  8,  8,  8,  7, \
 4,  4,  8,  8,  8,  8,  8,  8



#endif // MAGMA_HAVE_HIP

#endif // BATCHED_GESVJ_PARAM_H




