/* lfc-config.c
 */

#include <lfc/lfci.h>

static int
ShowLibs() {
  char libdir[] = QLIBDIR;
  char blasLibs[] = QBLAS_LIBS;
  char libs[] = QLIBS;

  printf( "-L%s -llfc -llfclapack -llfcblas -llfcf2c %s %s\n", libdir, blasLibs, libs );
  return 0;
}

static int
ShowCflags() {
  char includedir[] = QINCLUDEDIR;
  printf( "-I%s\n", includedir );
  return 0;
}

static int
ShowVersion() {
  printf( "%s\n", PACKAGE_VERSION );
  return 0;
}

static int
GiveHelp(char *argv0) {
  char *lines[] = {
"Known values for OPTION are:",
" ",
/*
"  --prefix=DIR          change LFC prefix [default /usr]",
"  --exec-prefix=DIR     change LFC executable prefix [default /usr]",
*/
"  --libs                print library linking information",
"  --cflags              print pre-processor and compiler flags",
"  --help                display this help and exit",
"  --version             output version information",
    ""};
  int i;

  printf( "Usage: %s [OPTION]...\n\n", argv0 );

  for (i = 0; lines[i][0]; i++)
    printf( "%s\n", lines[i] );

  return 0;
}

int
main(int argc, char *argv[]) {
  char *opt;

  if (argc != 2) GiveHelp( argv[0] );
  else {
    opt = argv[1];
    if (LFC_strcmp("--libs", opt) == 0)
      ShowLibs();
    else if (LFC_strcmp("--cflags", opt) == 0)
      ShowCflags();
    else if (LFC_strcmp("--version", opt) == 0)
      ShowVersion();
    else
      GiveHelp( argv[0] );
  }
  exit(EXIT_SUCCESS);
  return 0;
}
