/* -*- C -*- */
/* lktester.c
 */

#include <assert.h>
#include <lfc/lfci.h>

#include "lfctests.h"

#define DP(v) do{printf("%s(%d):%s=%g\n",__FILE__,__LINE__,#v,(double)(v));fflush(stdout);}while(0)

LFC_BEGIN_C_DECLS

int
noArgs(void) {
  double aa[12], a[12] = {4, 2, 3, 4,  3, 5, 6, 5,  5, 8, 10, 11};
  double b[4] = {100.1, 0.1, 0.01, 0.01};
  double x[4], xx[4] = {38.49, 21.59, -23.88, -8.843};
  double cd_n1 = -1.0, cd_1 = 1.0;
  double deps, bnorm, rnorm, rcond, sint, cost, tant, errbd;
  int m = 4, n = 3;
  int i, j;

  for (j = 0; j < n; j++)
    for (i = 0; i < m; i++) aa[i + j * m] = a[i + j * m];

  for (i = 0; i < m; i++) x[i] = b[i];

  bnorm = 0.0;
  for (i = 0; i < m; i++) bnorm += b[i] * b[i];
  bnorm = sqrt( bnorm );

  i = 0;
  LFC_dgels( LFC_ColMajor, LFC_NoTrans, m, n, 1, aa, m, x, m, xx, &i, &j );
  DP(j);

  deps = LFC_dlamch( "Epsilon" );
  rnorm = fabs( b[3] );
  rcond = sqrt( deps );
  sint = rnorm / bnorm;
  cost = sqrt( (1.0 - sint)*(1.0 + sint) );
  cost = MAX( cost, deps );
  tant = sint / cost;
  errbd = deps*( 2.0/(rcond*cost) + tant / (rcond*rcond) );

  i = 1;
#if 1 
  lfc_cblas_dgemm( LFC_CblasColMajor, LFC_CblasNoTrans, LFC_CblasNoTrans,
		   m, i, n, cd_n1, a, m, x, n, cd_1, b, m );
#else
  dgemm_( "N", "N", &m, &i, &n, &cd_n1, a, &m, x, &n, &cd_1, b, &m, 1, 1 );
#endif

  for (i = 0; i < m; i++) DP(x[i]-xx[i]);
  for (i = 0; i < m; i++) DP(b[i]);

  DP(rnorm);
  DP(errbd);

  return 0;
}

static int
testAll() {
  int i, j, maxlen, len, info = 0;
  char eot[1] = "", cnul = '\0', *prev, **argvv;
  extern int mainTest(int argc, char *argv[]);

  /* This is description of tests. Each test is described with a sequence of
  strings that ends with an empty string: "". To know where the tests end, two
  empty strings must be encountered: {"", ""}. New tests may be added as long
  the above rules are followed. */
  char *argvs[] = {
    "n=64",   "",
    "n=33",  "nrhs=3",  "",
    "n=64",  "nrhs=7", "",
    "n=64",  "nrhs=64", "",
    "n=64",  "nrhs=90", "",
    "n=150", "nrhs=1",  "",
    "n=150", "nrhs=90",  "",

    "n=33",  "llt=1", "uplo=U", "nrhs=3",  "",
    "n=64",  "llt=1", "uplo=U", "nrhs=1",  "",
    "n=64",  "llt=1", "uplo=U", "nrhs=7", "",
    "n=64",  "llt=1", "uplo=U", "nrhs=64", "",
    "n=64",  "llt=1", "uplo=U", "nrhs=90", "",
    "n=150", "llt=1", "uplo=U", "nrhs=1",  "",
    "n=150", "llt=1", "uplo=U", "nrhs=90",  "",
    "n=33",  "llt=1", "uplo=L", "nrhs=3",  "",
    "n=64",  "llt=1", "uplo=L", "nrhs=1",  "",
    "n=64",  "llt=1", "uplo=L", "nrhs=7", "",
    "n=64",  "llt=1", "uplo=L", "nrhs=64", "",
    "n=150", "llt=1", "uplo=L", "nrhs=1",  "",
    "n=150", "llt=1", "uplo=L", "nrhs=90",  "",
    "m=31", "n=31", "qr=1", "trans=N", "nrhs=3",  "",
    "m=32", "n=32", "qr=1", "trans=N", "nrhs=1",  "",
    "m=32", "n=32", "qr=1", "trans=N", "nrhs=7", "",
    "m=32", "n=32", "qr=1", "trans=N", "nrhs=32", "",
    "m=32", "n=32", "qr=1", "trans=N", "nrhs=90", "",
    "m=50", "n=50", "qr=1", "trans=N", "nrhs=1",  "",
    "m=50", "n=50", "qr=1", "trans=N", "nrhs=90",  "",
    "m=31", "n=31", "qr=1", "trans=T", "nrhs=3",  "",
    "m=32", "n=32", "qr=1", "trans=T", "nrhs=1",  "",
    "m=32", "n=32", "qr=1", "trans=T", "nrhs=7", "",
    "m=32", "n=32", "qr=1", "trans=T", "nrhs=32", "",
    "m=50", "n=50", "qr=1", "trans=T", "nrhs=1",  "",
    "m=50", "n=50", "qr=1", "trans=T", "nrhs=90",  "",
    ""
  };

  maxlen = len = 0;
  prev = eot;
  for (i = 0; argvs[i][0] != cnul || prev[0] != cnul ; i++) {
    prev = argvs[i];

    if (argvs[i][0] == cnul) { /* empty string */
      maxlen = len;
      len = 0;
    }

    len++;
  }

  if (! maxlen)
    return 0;

  argvv = LFC_MALLOC( char*, (maxlen + 2) );
  if (! argvv)
    return -1;

  len = 0;
  prev = eot;
  for (i = 0; argvs[i][0] != cnul || prev[0] != cnul ; i++) {
    prev = argvs[i];

    if (argvs[i][0] == cnul) { /* empty string */
      if (maxlen < len)
	return -1;

      argvv[0] = __FILE__;
      for (j = 0; j < len; j++) {
	argvv[j + 1] = argvs[i - len + j];
      }
      argvv[j + 1] = NULL;

      if (1)
      info = mainTest( len + 1, argvv );
      else {
	for (j=0;j<=len;j++)printf("%s", argvv[j]);
	printf("\n");
      }
      if (info) break;

      len = 0;
    }

    len++;
  }

  LFC_FREE( argvv );

  return info;
}	/* testAll */

int
mainTest(int argc, char *argv[]) {
  int i, m, n, nrhs, use_file, info;
  char uplo, trans, *llt, *qr, *prec, ch;
  char ifmt[] = "%d";
  double resd;
  Options opts;

  if (argc <= 1)
    return testAll();

  if (argc == 2 && argv[1][0] == 'T') {
    noArgs();
    return 0;
  }

  if (! LFC_gopt( argv, "n=", ifmt, &n )) n = 10;
  if (! LFC_gopt( argv, "m=", ifmt, &m )) m = n;
  if (! LFC_gopt( argv, "nrhs=", ifmt, &nrhs )) nrhs = 1;
  if (! LFC_gopt( argv, "use_file=", ifmt, &use_file )) use_file = 0;
  if (! LFC_gopt( argv, "uplo=", "%c", &uplo )) uplo = 'U';
  if (! LFC_gopt( argv, "trans=", "%c", &trans )) trans = 'N';
  llt = LFC_gopt( argv, "llt=", NULL, NULL );
  qr = LFC_gopt( argv, "qr=", NULL, NULL );
  prec = LFC_gopt( argv, "prec=", NULL, NULL );

  switch (uplo) {
    case 'U': case 'u': case 'L': case 'l': break;
    default: uplo = 'U'; break;
  }
  switch (trans) {
    case 'N': case 'n': case 'T': case 't': break;
    default: trans = 'N'; break;
  }

  if (! prec) prec = "sd";

  printf( "#m=%d n=%d nrhs=%d uplo=%c trans=%c solver=%s\n", m, n, nrhs, uplo,
	  trans, llt ? "LLt/UtU" : (qr ? "QR" : "LU" ) );

  opts.use_file = use_file;

  for (i = 0; prec[i]; i++) {
    ch = prec[i];
    info = 0;
    switch (ch) {
      case 's':
	if (llt)     info = tsposv( &uplo, n, nrhs, &opts, &resd );
	else if (qr) info = tsgels( &trans, m, n, nrhs, &opts, &resd );
	else         info = tsgesv( n, nrhs, &opts, &resd );
      break;

      case 'd':
	if (llt)     info = tdposv( &uplo, n, nrhs, &opts, &resd );
	else if (qr) info = tdgels( &trans, m, n, nrhs, &opts, &resd );
	else         info = tdgesv( n, nrhs, &opts, &resd );
      break;
    }
    printf( "(%c) ||A*X-B|| / (||A|| * EPSILON * N)=%g\n", ch, resd );

    if (info) return info;
  }

  return info;
}	/* mainTest */

int
main(int argc, char *argv[]) {
  int info;

  info = mainTest( argc, argv );

  if (info) {
    exit( EXIT_FAILURE );
    return EXIT_FAILURE;
  }

  exit( EXIT_SUCCESS );
  return EXIT_SUCCESS;
}

LFC_END_C_DECLS
