/* -*- C -*- */
/* chksgemm.c
 */

#include <lfc/lfci.h>

int
chksgemm(void) {
  int n = 2, i;
  float a[] = {1.0f, 2.0f, 3.0f, 4.0f}, b[] = { 5.0f,  6.0f,  7.0f,  8.0f},
        c[] = {9.0f, 1.0f, 2.0f, 3.0f}, d[] = {14.0f, 33.0f, 29.0f, 43.0f}, e, f;

  lfc_cblas_sgemm( LFC_CblasColMajor, LFC_CblasNoTrans, LFC_CblasNoTrans, n, n,
		   n, -1.0f, a, n, b, n, 1.0f, c, n );

  e = 0.0;
  for (i = 0; i < n * n; i++) {f = c[i]+d[i]; e += (f<0.0f) ? -f : f;}

  if (e > 1e-10)
    return 1;

  return 0;
}
