/* -*- C -*- */
/* chkdgemm.c
 */

#include <lfc/lfci.h>

int
chkdgemm(void) {
  int n = 2, i;
  double a[] = {1.0, 2.0, 3.0, 4.0}, b[] = {5.0, 6.0, 7.0, 8.0},
         c[] = {9.0, 1.0, 2.0, 3.0}, d[] = {14.0, 33.0, 29.0, 43.0}, e, f;

  lfc_cblas_dgemm( LFC_CblasColMajor, LFC_CblasNoTrans, LFC_CblasNoTrans, n, n,
		   n, -1.0, a, n, b, n, 1.0, c, n );

  e = 0.0;
  for (i = 0; i < n * n; i++) {f = c[i]+d[i]; e += (f<0.0) ? -f : f;}

  if (e > 1e-10)
    return 1;

  return 0;
}
