/* -*- C -*- */

#ifndef LFCPSLVR_H
#define LFCPSLVR_H

LFC_BEGIN_C_DECLS

#define TB0(ctxt, v) do{(v)=MPI_Wtime();}while(0)
#define TB(ctxt, v) do{Cblacs_barrier((ctxt), "All");(v)=MPI_Wtime();}while(0)
#define TE(ctxt, v) ((v) = MPI_Wtime() - (v))
#define P(i,j,v) do{printf("%d@%dx%d:%s=%g\n",__LINE__,i,j,#v,(double)(v));fflush(stdout);}while(0)
#define ICEIL(n,d) ((n)>0 ? ((n)+(d)-1)/(d) : (n)/(d))

extern integer numroc_(integer *n, integer *nb, integer *iproc, integer *isrcproc,
  integer *nprocs);
extern int descinit_(integer *desc, integer *m, integer *n, integer *mb,
  integer *nb, integer *irsrc, integer *icsrc, integer *ictxt, integer *lld,
  integer *info);
extern int infog2l_(integer *grindx, integer *gcindx, integer *desc, integer *nprow,
  integer *npcol, integer *myrow, integer *mycol, integer *lrindx, integer *lcindx,
  integer *rsrc, integer *csrc);

extern int pdgels_(char *trans, integer *m, integer *n, integer *nrhs,
  doublereal *a, integer *ia, integer *ja, integer *desca, doublereal *b,
  integer *ib, integer *jb, integer *descb, doublereal *work, integer *lwork,
  integer *info, ftnlen trans_len);
extern int pdgesv_(integer *n, integer *nrhs, doublereal *a, integer *ia,
  integer *ja, integer *desca, integer *ipiv, doublereal *b, integer *ib,
  integer *jb, integer *descb, integer *info);
extern int pdposv_(char *uplo, integer *n, integer *nrhs, doublereal *a,
  integer *ia, integer *ja, integer *desca, doublereal *b, integer *ib, integer *jb,
  integer *descb, integer *info, ftnlen uplo_len);
extern void pdsymm_(char *SIDE, char *UPLO, int *M, int *N, double *ALPHA,
  double *A, int *IA, int *JA, int *DESCA, double *B, int *IB, int *JB, int *DESCB,
  double *BETA, double *C, int *IC, int *JC, int *DESCC);
extern void pdgemm_(char *TRANSA, char *TRANSB, int *M, int *N, int *K,
  double *ALPHA, double *A, int *IA, int *JA, int *DESCA, double *B, int *IB,
  int *JB, int *DESCB, double *BETA, double *C, int *IC, int *JC, int *DESCC);
extern int pdlaprnt_(integer *m, integer *n, doublereal *a, integer *ia,
  integer *ja, integer *desca, integer *irprnt, integer *icprnt, char *cmatnm,
  integer *nout, doublereal *work, ftnlen cmatnm_len);
extern doublereal pdlamch_(integer *ictxt, char *cmach, ftnlen cmach_len);
extern doublereal pdlange_(char *norm, integer *m, integer *n, doublereal *a,
  integer *ia, integer *ja, integer *desca, doublereal *work, ftnlen norm_len);
extern int pdlacpy_(char *uplo, integer *m, integer *n, doublereal *a, integer *ia,
  integer *ja, integer *desca, doublereal *b, integer *ib, integer *jb,
  integer *descb, ftnlen uplo_len);

extern int psgels_(char *trans, integer *m, integer *n, integer * nrhs, real *a,
  integer *ia, integer *ja, integer *desca, real *b, integer *ib, integer *jb,
  integer *descb, real *work, integer *lwork, integer *info, ftnlen trans_len);
extern int psgesv_(integer *n, integer *nrhs, real *a, integer *ia, integer *ja,
  integer *desca, integer *ipiv, real *b, integer *ib, integer *jb, integer *descb,
  integer *info);
extern int psposv_(char *uplo, integer *n, integer *nrhs, real *a, integer *ia,
  integer *ja, integer *desca, real *b, integer *ib, integer *jb, integer *descb,
  integer *info, ftnlen uplo_len);
extern void pssymm_(char *SIDE, char *UPLO, int * M, int * N, float * ALPHA,
  float * A, int * IA, int * JA, int * DESCA, float * B, int * IB, int * JB,
  int * DESCB, float * BETA, float * C, int * IC, int * JC, int * DESCC);
extern void psgemm_(char *TRANSA, char *TRANSB, int * M, int * N, int * K,
  float * ALPHA, float * A, int * IA, int * JA, int * DESCA, float * B, int * IB,
  int * JB, int * DESCB, float * BETA, float * C, int * IC, int * JC, int * DESCC);
extern int pslaprnt_(integer *m, integer *n, real *a, integer *ia, integer *ja,
  integer *desca, integer *irprnt, integer *icprnt, char *cmatnm, integer *nout,
  real *work, ftnlen cmatnm_len);
extern real pslamch_(integer *ictxt, char *cmach, ftnlen cmach_len);
extern real pslange_(char *norm, integer *m, integer *n, real *a, integer *ia, 
  integer *ja, integer *desca, real *work, ftnlen norm_len);
extern int pslacpy_(char *uplo, integer *m, integer *n, real *a, integer *ia,
  integer *ja, integer *desca, real *b, integer *ib, integer *jb, integer *descb,
  ftnlen uplo_len);

extern void Cblacs_abort(int ConTxt, int ErrNo);
extern void Cblacs_barrier(int ConTxt, char *scope);
extern void Cblacs_exit(int NotDone);
extern void Cblacs_get(int ConTxt, int what, int *val);
extern void Cblacs_gridexit(int ConTxt);
extern void Cblacs_gridmap(int *ConTxt, int *usermap, int ldup, int nprow0,
  int npcol0);
extern int  Cblacs_gridinit(int *ConTxt, char *order, int nprow, int npcol);
extern void Cblacs_pinfo(int *mypnum, int *nprocs);
extern void Cblacs_gridinfo(int ConTxt, int *nprow, int *npcol, int *myrow,
  int *mycol);
extern void Cigsum2d(int ConTxt, char *scope, char *top, int m, int n, int *A,
  int lda, int rdest, int cdest);
extern void Cigebs2d(int ConTxt, char *scope, char *top, int m, int n, int *A,
  int lda);
void Cigebr2d(int ConTxt, char *scope, char *top, int m, int n, int *A, int lda,
  int rsrc, int csrc);
extern void Csgerv2d(int ConTxt, int m, int n, float *A, int lda, int rsrc, int csrc);
extern void Csgesd2d(int ConTxt, int m, int n, float *A, int lda, int rdest, int cdest);
extern void Cdgamx2d(int ConTxt, char *scope, char *top, int m, int n, double *A,
  int lda, int *rA, int *cA, int ldia, int rdest, int cdest);
extern void Cdgerv2d(int ConTxt, int m, int n, double *A, int lda, int rsrc, int csrc);
extern void Cdgesd2d(int ConTxt, int m, int n, double *A, int lda, int rdest, int cdest);

typedef struct {
  float  *sptrA, *sptrB, *sptrX;
  double *dptrA, *dptrB, *dptrX;
  int *ptrP;
  int desca[9], descb[9], descx[9];
  int myrow, mycol;
  int ctxt;
} SLInfo;

typedef struct {
  char *mat_fname, *rhs_fname, *sol_fname, *luf_fname;
  int m, n, nrhs, mb, nb, gp, gq;
  SLInfo sli;
  float  *sptrAcpy, *sptrW;
  double *dptrAcpy, *dptrW;
  int verbose, opcode, sizeW;
  int IOrow, IOcol;
  enum LFC_Datatype dtype;
  enum LFC_UpLo uplo;
  enum LFC_Transpose trans;
  double resid, tread, tcopy, tpdgesv, twrite, tresid;
} PInfo;

extern int LFC_sParallelSolve(PInfo *p);
extern int LFC_dParallelSolve(PInfo *p);

LFC_END_C_DECLS

#endif /* !LFCPSLVR_H */
