/* -*- C -*- */
/* lfcpslvr.c
*/

#include <mpi.h>

#include <lfc/lfci.h>

#include "lfcpslvr.h"

LFC_BEGIN_C_DECLS

static void
parse_argv(int argc, char *uargv[], PInfo *p) {
  int m, n, nrhs, mb, nb, gp, gq, rank, opcode = 1, params[8], verbose = 0;
  char **argv, uplo, trans, tmat, fmt[3] = "%d", cfmt[3] = "%c";

  MPI_Comm_rank( MPI_COMM_WORLD, &rank );

  if (0 == rank) argv = uargv;

  /* FIXME: what if something goes wrong? */
  LFC_argvMpiBcast( &argv, 0 );

  LFC_gopt( argv, "m=",    fmt, &m );
  LFC_gopt( argv, "n=",    fmt, &n );
  LFC_gopt( argv, "nrhs=", fmt, &nrhs );
  LFC_gopt( argv, "mb=",   fmt, &mb );
  LFC_gopt( argv, "nb=",   fmt, &nb );
  LFC_gopt( argv, "gp=",   fmt, &gp );
  LFC_gopt( argv, "gq=",   fmt, &gq );
  LFC_gopt( argv, "verbose=",fmt,&verbose );
  LFC_gopt( argv, "opcode=",fmt,&opcode );
  LFC_gopt( argv, "uplo=",cfmt, &uplo );
  LFC_gopt( argv, "trans=",cfmt,&trans );
  LFC_gopt( argv, "tmat=",cfmt,&tmat );
  p->mat_fname = LFC_gopt( argv, "mat-fname=", NULL, NULL );
  p->rhs_fname = LFC_gopt( argv, "rhs-fname=", NULL, NULL );
  p->sol_fname = LFC_gopt( argv, "sol-fname=", NULL, NULL );
  p->luf_fname = LFC_gopt( argv, "luf-fname=", NULL, NULL );

  /* FIXME: do some sanity checks */

  /* ScaLAPACK's pdgesv() requires the same row and column blocking factors */
  mb = nb;

  p->m    = m;
  p->n    = n;
  p->nrhs = nrhs;
  p->mb = mb;
  p->nb = nb;
  p->gp = gp;
  p->gq = gq;
  p->verbose = verbose;
  if (opcode < 1 || opcode > 6) opcode = 1;
  p->opcode = opcode;
  p->trans = ch2eTrans(trans);
  p->uplo  = ch2eUpLo(uplo);
  p->dtype = ch2eDtype(tmat);

  /* `argv' is not free()'d because there are references to it */

}	/* parse_argv */

int
main(int argc, char *argv[]) {
  int i, rank, size; PInfo p;

  /* Check if MPI's OK */
  if (MPI_Init( &argc, &argv ) || MPI_Initialized( &i ) || ! i) {
    fprintf( stderr, "MPI couldn't initialize.\n" );
    exit( EXIT_FAILURE );
    return 1;
  }

  parse_argv( argc, argv, &p );

  MPI_Comm_rank( MPI_COMM_WORLD, &rank );
  MPI_Comm_size( MPI_COMM_WORLD, &size );
  if (size < p.gp * p.gq) {
    if (0 == rank)
      fprintf( stderr, "Not enough MPI processes: %d < %d * %d\n",
	       size, p.gp, p.gq );
    MPI_Finalize();
    exit( EXIT_FAILURE );
    return 1;
  }

  switch (p.dtype) {
    case LFC_DOUBLE:
      LFC_dParallelSolve( &p );
    break;

    case LFC_FLOAT:
      LFC_sParallelSolve( &p );
    break;
  }

  exit( EXIT_SUCCESS );
  return 0;
}	/* main */

LFC_END_C_DECLS
