/* -*- C -*-
  lfcmpi.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <mpi.h>

#include <lfc/lfci.h>

LFC_BEGIN_C_DECLS

static int pname_len(void) {
  int i = MPI_MAX_PROCESSOR_NAME, j = 80*40; return i > j ? i + 1 : j + 1; }

static int pname_mpi_get_pname(char *buf, int *buflen) { int i;
 i = MPI_Get_processor_name( buf, buflen );
 if (i) buf[0] = '\0';
 return i;
}

static int
report_names(int (*nfunc)(char *, int *), const char *fname, int iorank,
             const char *m) {
  int i, j, rank, size, plen, lus; char *pname, *us; MPI_Status s;

  plen = pname_len() + 1;
  pname = malloc( (sizeof *pname) * plen );

  MPI_Comm_size( MPI_COMM_WORLD, &size );
  MPI_Comm_rank( MPI_COMM_WORLD, &rank );

  i = strlen( m ) + 1;
  MPI_Allreduce( &i, &lus, 1, MPI_INT, MPI_MAX, MPI_COMM_WORLD );
  us = malloc( lus + 1 );
  i = 0;
  if (!pname || ! us) i = 1;

  MPI_Allreduce( &i, &j, 1, MPI_INT, MPI_MAX, MPI_COMM_WORLD );
  if (j > 0) {
    if (pname) free( pname );
    if (us) free( us );
    return -1;
  }

  for (i = 0; i < size; i++) {
    if (rank == i) {
      memset( pname, plen, 0 );
      memset( us,    lus,  0 );
      strcpy( us, m );
      j = plen - 1; /* just in case nfunc() won't store trailing '\0' */
      nfunc( pname, &j );
      pname[plen - 1] = '\0'; /* just in case nfunc() wrote too much */
      if (rank != iorank) {
        MPI_Send( pname, plen, MPI_CHAR, iorank, 0, MPI_COMM_WORLD );
        MPI_Send( us,     lus, MPI_CHAR, iorank, 0, MPI_COMM_WORLD );
      }
    }

    if (rank == iorank) {
      if (rank != i) {
        MPI_Recv( pname, plen, MPI_CHAR, i, 0, MPI_COMM_WORLD, &s );
        MPI_Recv( us,     lus, MPI_CHAR, i, 0, MPI_COMM_WORLD, &s );
      }

      if (fname) printf( "Rank_%d_name_(by_%s)=%s%s\n", i, fname, pname, us );
      else       printf( "Rank_%d_name=%s%s\n", i, pname, us );
    }
  }

  free( us );
  free( pname );

  return 0;
}

int
LFC_report_node_names(const char *s) {
  int iorank = 0;

  if (! s || *s == '\0') s = "";

  report_names( pname_mpi_get_pname, NULL, iorank, s );
  /* report_names( pname_gethostname, "gethostname", iorank ); */

  return 0;
}

static int
irdc(int *src, int *dst, int n, int root) {
  MPI_Reduce( src, dst, n, MPI_INT, MPI_SUM, root, MPI_COMM_WORLD );
  MPI_Bcast( dst, n, MPI_INT, root, MPI_COMM_WORLD );
  return LFC_SUCCESS;
}

int
LFC_argvMpiBcast(char ***uargv, int root) {
  char **argv; int argc, err, gsum, i, len;
  int rank, size;

  MPI_Comm_size( MPI_COMM_WORLD, &size );
  MPI_Comm_rank( MPI_COMM_WORLD, &rank );

  /* FIXME: check if root is the same for all */
  /* if (root < 0 || root >= size) err = 1; */

  err = 0;
  if (! uargv) err = 1;
  irdc( &err, &gsum, 1, root ); if (gsum) return LFC_FAILURE;

  if (rank == root) {
    argv = *uargv;
    for (argc = 0; argv[argc]; argc++) ;
  }
  MPI_Bcast( &argc, 1, MPI_INT, root, MPI_COMM_WORLD );

  if (0 == argc) {
    /* FIXME: make sure all nodes return the same value */
    if (rank == root) {
      return LFC_SUCCESS;
    } else {
      argv = LFC_MALLOC( char*, 1 );
      if (argv) {
	argv[0] = NULL;
	*uargv = argv;
	return LFC_SUCCESS;
      }
      return LFC_FAILURE;
    }
  }

  /* There is at least one entry in `uargv' at process `root' */

  err = 0;
  if (rank != root) {
    argv = LFC_MALLOC( char*, argc + 1 );
    if (! argv) err = 1;
  }
  irdc( &err, &gsum, 1, root ); if (gsum) return LFC_FAILURE;

  /* All processes have memory allocated for argv */

  for (i = 0; i < argc; i++) {
    if (rank == root) len = LFC_strlen( argv[i] );

    MPI_Bcast( &len, 1, MPI_INT, root, MPI_COMM_WORLD );

    err = 0;
    if (rank != root) argv[i] = LFC_MALLOC( char, len + 1 );
    if (! argv[i]) err = 1;
    /* FIXME: clean up memory */
    irdc( &err, &gsum, 1, root ); if (gsum) return LFC_FAILURE;

    MPI_Bcast( argv[i], len, MPI_CHAR, root, MPI_COMM_WORLD );

    if (rank != root) argv[i][len] = '\0';
  }

  if (rank != root) {
    argv[argc] = NULL;
    *uargv = argv;
  }

  return LFC_FAILURE;
}	/* LFC_argvMpiBcast */

LFC_END_C_DECLS
