AC_DEFUN([ACX_SUNWSC],[

acx_sunc=$1
define(m4_sunc_var,$2)dnl

dnl Check for Sun Workshop compiler unless it's specified with CC.
if test "x$m4_sunc_var" = x; then
  acx_sunwspro_C=/opt/SUNWspro/bin/$acx_sunc
  AC_MSG_CHECKING([for Sun Workshop compiler $acx_sunc])
  if ($acx_sunwspro_C -flags) >/dev/null 2>&1; then
     m4_sunc_var=$acx_sunwspro_C
     AC_MSG_RESULT(yes)
  else
     AC_MSG_RESULT(no)
  fi
fi

undefine([m4_sunc_var])dnl
])dnl ACX_SUNWSC

AC_DEFUN([ACX_LFC_INIT],[
AC_ARG_VAR(MPI_CC, [MPI C compiler (if you define CC you need to define MPI_CC)])
AC_ARG_VAR(MPI_CFLAGS, [MPI C compiler flags])
AC_ARG_VAR(MPI_LIBS, [libraries for MPI linker (including BLAS)])

if test -d mpi; then
dnl if MPI_CC was  not  defined
if test "x$MPI_CC" = x; then
dnl output of `config.guess' is changed so `configure' thinks we cross-compile
(cd mpi; ./configure ${1+"[$]@"} CFLAGS="${MPI_CFLAGS-""}" CPPFLAGS=-DHAVE_LFCMPICF_H LIBS="${MPI_LIBS-""}" BLAS_LIBS="" --build=`../config.guess`.1 --host=`../config.guess`)
else
dnl output of `config.guess' is changed so `configure' thinks we cross-compile
(cd mpi; ./configure ${1+"[$]@"} CC="${MPI_CC}" CFLAGS="${MPI_CFLAGS-""}" CPPFLAGS=-DHAVE_LFCMPICF_H LIBS="${MPI_LIBS-""}" BLAS_LIBS="" --build=`../config.guess`.1 --host=`../config.guess`)
fi
if test ! x"$?" = x0; then
  exit 1
fi
fi

dnl ACX_SUNWSC(cc,[CC])
dnl ACX_SUNWSC(f77,[F77])
])dnl ACX_LFC_INIT

dnl One cannot just use AC_TRY_LINK_FUNC or AC_CHECK_LIB because some
dnl BLAS libraries require Fortran I/O. The way around it is to defined
dnl all variants of XERBLA() which removes relience on Fortran I/O.
dnl ACX_LFC_BLAS_FUNC(FUNC,ACTION-IF-FOUND,ACTION-IF-NOT-FOUND)
AC_DEFUN([ACX_LFC_BLAS_FUNC],[
  acx_lfc_blas_func_ok=no
  save_LIBS="$LIBS"; LIBS="$2 $LIBS"
  ifelse($#,4,AC_MSG_CHECKING([for $1 in $2]))

dnl AC_RUN_IFELSE(AC_LANG_PROGRAM(
  AC_LINK_IFELSE(AC_LANG_PROGRAM(
[[#define YYY(n) void n(){}
#ifdef __cplusplus
extern "C"
{    
#endif  
YYY(xerbla)
YYY(xerbla_)
YYY(xerbla__)
YYY(XERBLA)
YYY(XERBLA_)
YYY(XERBLA__)
char $1();
char (*f)()=(char(*)())0;
#ifdef __cplusplus
}
#endif  
]],[[if(!f)f=$1;if(f!=$1)return 1;]]),
[acx_lfc_blas_func_ok=yes ; $3],$4)

  ifelse($#,4,AC_MSG_RESULT($acx_lfc_blas_func_ok))
  LIBS="$save_LIBS"
]) dnl ACX_LFC_BLAS_FUNC

dnl
dnl
dnl
AC_DEFUN([ACX_LFC_MPI], [
AC_PREREQ(2.50)

AC_MSG_CHECKING([if MPI is usable])

acx_lfc_mpi_ok=no

AC_LINK_IFELSE(AC_LANG_PROGRAM(
[[
char MPI_Init();
char (*f)()=(char(*)())((unsigned long)0);
]],[[if(!f)f=MPI_Init;if(f!=MPI_Init)return 1;return 0;]]),
[acx_lfc_mpi_ok=yes])

if test x"$acx_lfc_mpi_ok" = xyes ; then
AC_LINK_IFELSE(AC_LANG_PROGRAM(
[[#include <mpi.h>
]],[[MPI_Finalize();return 0;]]),
[acx_lfc_mpi_ok=yes])
fi

# Finally, execute ACTION-IF-FOUND/ACTION-IF-NOT-FOUND:
if test x"$acx_lfc_mpi_ok" = xyes; then
        AC_MSG_RESULT(yes)
        ifelse([$1],,,[$1])
        :
else
        AC_MSG_RESULT(no)
        acx_mpi_ok=no
        $2
fi

])dnl ACX_LFC_MPI

dnl
dnl
dnl
AC_DEFUN([ACX_LFC_BLAS], [
AC_PREREQ(2.50)

acx_lfc_blas_ok=no
acx_lfc_blas_sfx=_
acx_lfc_blas_ncase=l

AC_ARG_VAR(BLAS_LIBS, [optimized BLAS (or CBLAS) libraries (not for MPI C compiler)])

AC_ARG_WITH(blas,
	[AC_HELP_STRING([--with-blas=<flags_and_libs>], [linker flags required to link with BLAS libraries])])
case $with_blas in
  yes | "") ;;
  no)
    acx_lfc_blas_ok=lfc
    dnl AC_MSG_ERROR([I need BLAS!])
  ;;
  dnl -* | */* | *.a | *.so | *.so.* | *.o) BLAS_LIBS="$with_blas" ;;
  dnl *) BLAS_LIBS="-l$with_blas" ;;
  *) BLAS_LIBS="$with_blas" ;;
esac

# First, check BLAS_LIBS environment variable
if test $acx_lfc_blas_ok = no; then
if test "x$BLAS_LIBS" != x; then
  ACX_LFC_BLAS_FUNC(dgemm_,$BLAS_LIBS,[acx_lfc_blas_ok=yes],[BLAS_LIBS=""])
fi
fi

# BLAS linked to by default?  (happens on some supercomputers, e.g. Cray)
if test $acx_lfc_blas_ok = no; then
  ACX_LFC_BLAS_FUNC(dgemm_,[],[acx_lfc_blas_ok=yes],[BLAS_LIBS=""])
fi

dnl ATLAS library? (http://math-atlas.sourceforge.net/ and http://www.netlib.org/atlas/)
dnl if test $acx_lfc_blas_ok = no; then
dnl   AC_CHECK_LIB(atlas, ATL_xerbla,
dnl     [acx_lfc_blas_ok=yes
dnl     acx_lfc_atlas=yes
dnl     BLAS_LIBS="-latlas"
dnl     AC_DEFINE(HAVE_ATLAS,1,[Define if you have the Atlas library.])],[BLAS_LIBS=""])
dnl fi

# BLAS in ATLAS CBLAS library? (http://math-atlas.sourceforge.net/ and http://www.netlib.org/atlas/)
if test $acx_lfc_blas_ok = no; then
  AC_CHECK_LIB(cblas, cblas_dgemm,
    [acx_lfc_blas_ok=yes
    acx_lfc_cblas=yes
    BLAS_LIBS="-lcblas -latlas"
    AC_DEFINE(HAVE_CBLAS,1,[Define if you have the Atlas and CBLAS library.])],[BLAS_LIBS=""],"-latlas")
fi

# BLAS in ATLAS library? (http://math-atlas.sourceforge.net/ and http://www.netlib.org/atlas/)
if test $acx_lfc_blas_ok = no; then
  BLAS_LIBS="-lf77blas -latlas"
  ACX_LFC_BLAS_FUNC(dgemm_,$BLAS_LIBS,[acx_lfc_blas_ok=yes],[BLAS_LIBS=""])
fi

# BLAS in Alpha CXML library?
if test $acx_lfc_blas_ok = no; then
  BLAS_LIBS="-lcxml"
  ACX_LFC_BLAS_FUNC(dgemm_,$BLAS_LIBS,[acx_lfc_blas_ok=yes],[BLAS_LIBS=""])
fi

# BLAS in Alpha DXML library? (now called CXML, see above)
if test $acx_lfc_blas_ok = no; then
  BLAS_LIBS="-ldxml"
  ACX_LFC_BLAS_FUNC(dgemm_,$BLAS_LIBS,[acx_lfc_blas_ok=yes],[BLAS_LIBS=""])
fi

# BLAS in SCSL library?  (SGI/Cray Scientific Library)
if test $acx_lfc_blas_ok = no; then
  BLAS_LIBS="-lscs"
  ACX_LFC_BLAS_FUNC(dgemm_,$BLAS_LIBS,[acx_lfc_blas_ok=yes],[BLAS_LIBS=""])
fi

# BLAS in SGIMATH library?
if test $acx_lfc_blas_ok = no; then
  BLAS_LIBS="-lcomplib.sgimath"
  ACX_LFC_BLAS_FUNC(dgemm_,$BLAS_LIBS,[acx_lfc_blas_ok=yes],[BLAS_LIBS=""])
fi

# BLAS in IBM ESSL library? (requires generic BLAS lib, too)
if test $acx_lfc_blas_ok = no; then
  BLAS_LIBS="-lessl"
  ACX_LFC_BLAS_FUNC(dgemm,$BLAS_LIBS,[acx_lfc_blas_ok=yes],[BLAS_LIBS=""])
  if test $acx_lfc_blas_ok = yes; then
    acx_lfc_blas_sfx=""
  fi
fi

# BLAS in Sun Performance library?
if test $acx_lfc_blas_ok = no; then
  BLAS_LIBS="-xlic_lib=sunperf"
  ACX_LFC_BLAS_FUNC(dgemm_,$BLAS_LIBS,[acx_lfc_blas_ok=yes],[BLAS_LIBS=""])
fi

# Generic BLAS library?
if test $acx_lfc_blas_ok = no; then
  BLAS_LIBS="-lblas"
  ACX_LFC_BLAS_FUNC(dgemm_,$BLAS_LIBS,[acx_lfc_blas_ok=yes],[BLAS_LIBS=""])
fi

# LFC BLAS: not optimal but for Level 3 better than reference BLAS 
if test $acx_lfc_blas_ok = no -o $acx_lfc_blas_ok = lfc; then
  AC_DEFINE(USE_LFC_BLAS,1,[Define if you want to use LFC BLAS library.])
  BLAS_LIBS=""
  acx_lfc_blas_ok=yes
fi

if test $acx_lfc_blas_ok = yes; then
  dnl All the BLAS libraries I know have the following interface to C
  AC_DEFINE(BLAS_REAL,float,[Define equivalent of BLAS REAL])dnl
  AC_DEFINE(BLAS_DOUBLE_PRECISION,double,[Define equivalent of BLAS DOUBLE PRECISION])dnl
  AC_DEFINE(BLAS_INTEGER,int,[Define equivalent of BLAS INTEGER])dnl

  AC_DEFINE(BLAS_CHARACTER,BLAS_SUN_CHARACTER,
  [Define a way to handle BLAS CHARACTER constants.])dnl
  AC_DEFINE(BLAS_SUN_CHARACTER,1,[Sun style: lengths of each CHARACTER argument after all explicit arguments.])dnl
  AC_DEFINE(BLAS_CRAY_CHARACTER,2,[Cray (before X1) style: special type and header file.])dnl

  if test x"$acx_lfc_blas_ncase" = xl; then
    AC_DEFINE(LFC_BLAS_FNAME_LOWER,1,[BLAS names are in lower case.])dnl
  elif test x"$acx_lfc_blas_ncase" = xu; then
    AC_DEFINE(LFC_BLAS_FNAME_UPPER,1,[BLAS names are in upper case.])dnl
  fi
  if test x"$acx_lfc_blas_sfx" = "x"; then
    AC_DEFINE(LFC_BLAS_FNAME_NO_,1,[BLAS names have no suffix.])dnl
  elif test x"$acx_lfc_blas_sfx" = "x_"; then
    AC_DEFINE(LFC_BLAS_FNAME_ONE_,1,[BLAS names have single _ suffix.])dnl
  fi
fi

# Finally, execute ACTION-IF-FOUND/ACTION-IF-NOT-FOUND:
if test x"$acx_lfc_blas_ok" = xyes; then
        ifelse([$1],,AC_DEFINE(HAVE_BLAS,1,[Define if you have a BLAS library.]),[$1])
        :
else
        acx_blas_ok=no
        $2
fi

])dnl ACX_LFC_BLAS


dnl
dnl
dnl
AC_DEFUN([ACX_LFC_F2C], [
AC_PREREQ(2.50)

if test -d libf2c; then

AC_MSG_CHECKING([for floating-point arithmetic features for libf2c])

acx_lfc_f2c_ok=no
rm -f libf2c/arith.h

dnl AC_LINK_IFELSE(AC_LANG_PROGRAM(
AC_RUN_IFELSE(AC_LANG_PROGRAM(
[[[
/****************************************************************
Copyright (C) 1997, 1998, 2000 Lucent Technologies
All Rights Reserved

Permission to use, copy, modify, and distribute this software and
its documentation for any purpose and without fee is hereby
granted, provided that the above copyright notice appear in all
copies and that both that the copyright notice and this
permission notice and warranty disclaimer appear in supporting
documentation, and that the name of Lucent or any of its entities
not be used in advertising or publicity pertaining to
distribution of the software without specific, written prior
permission.

LUCENT DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS.
IN NO EVENT SHALL LUCENT OR ANY OF ITS ENTITIES BE LIABLE FOR ANY
SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
THIS SOFTWARE.
****************************************************************/

/* Try to deduce arith.h from arithmetic properties. */

#include <stdio.h>
#include <math.h>
#include <errno.h>

/* Piotr Luszczek */
/* this is defined in libf2c's makefile.u */
#define NO_FPINIT 1
/* Piotr Luszczek */

#ifdef NO_FPINIT
#define fpinit_ASL()
#else
#ifndef KR_headers
extern
#ifdef __cplusplus
	"C"
#endif
	void fpinit_ASL(void);
#endif /*KR_headers*/
#endif /*NO_FPINIT*/

 static int dalign;
 typedef struct
Akind {
	char *name;
	int   kind;
	} Akind;

 static Akind
IEEE_8087	= { "IEEE_8087", 1 },
IEEE_MC68k	= { "IEEE_MC68k", 2 },
IBM		= { "IBM", 3 },
VAX		= { "VAX", 4 },
CRAY		= { "CRAY", 5};

 static double t_nan;

 static Akind *
Lcheck()
{
	union {
		double d;
		long L[2];
		} u;
	struct {
		double d;
		long L;
		} x[2];

	if (sizeof(x) > 2*(sizeof(double) + sizeof(long)))
		dalign = 1;
	u.L[0] = u.L[1] = 0;
	u.d = 1e13;
	if (u.L[0] == 1117925532 && u.L[1] == -448790528)
		return &IEEE_MC68k;
	if (u.L[1] == 1117925532 && u.L[0] == -448790528)
		return &IEEE_8087;
	if (u.L[0] == -2065213935 && u.L[1] == 10752)
		return &VAX;
	if (u.L[0] == 1267827943 && u.L[1] == 704643072)
		return &IBM;
	return 0;
	}

 static Akind *
icheck()
{
	union {
		double d;
		int L[2];
		} u;
	struct {
		double d;
		int L;
		} x[2];

	if (sizeof(x) > 2*(sizeof(double) + sizeof(int)))
		dalign = 1;
	u.L[0] = u.L[1] = 0;
	u.d = 1e13;
	if (u.L[0] == 1117925532 && u.L[1] == -448790528)
		return &IEEE_MC68k;
	if (u.L[1] == 1117925532 && u.L[0] == -448790528)
		return &IEEE_8087;
	if (u.L[0] == -2065213935 && u.L[1] == 10752)
		return &VAX;
	if (u.L[0] == 1267827943 && u.L[1] == 704643072)
		return &IBM;
	return 0;
	}

char *emptyfmt = "";	/* avoid possible warning message with printf("") */

 static Akind *
ccheck()
{
	union {
		double d;
		long L;
		} u;
	long Cray1;

	/* Cray1 = 4617762693716115456 -- without overflow on non-Crays */
	Cray1 = printf(emptyfmt) < 0 ? 0 : 4617762;
	if (printf(emptyfmt, Cray1) >= 0)
		Cray1 = 1000000*Cray1 + 693716;
	if (printf(emptyfmt, Cray1) >= 0)
		Cray1 = 1000000*Cray1 + 115456;
	u.d = 1e13;
	if (u.L == Cray1)
		return &CRAY;
	return 0;
	}

 static int
fzcheck()
{
	double a, b;
	int i;

	a = 1.;
	b = .1;
	for(i = 155;; b *= b, i >>= 1) {
		if (i & 1) {
			a *= b;
			if (i == 1)
				break;
			}
		}
	b = a * a;
	return b == 0.;
	}

 static int
need_nancheck()
{
	double t;

	errno = 0;
	t = log(t_nan);
	if (errno == 0)
		return 1;
	errno = 0;
	t = sqrt(t_nan);
	return errno == 0;
	}

/* Piotr Luszczek */
/* It should not hurt to define this function for every system. */
/*
#ifdef __sun
#ifdef __i386
*/
/* kludge for Intel Solaris */
void fpsetprec(int x) { }
/*
#endif
#endif
*/
/* Piotr Luszczek */
]]],[[
	FILE *f;
	Akind *a = 0;
	int Ldef = 0;

	fpinit_ASL();
/* Piotr Luszczek */
/* It doesn't hurt to write it to a file (even if it's not necessary).
   Besides, not writing to a file is only relevant in libf2c's makefile.u
*/
#define WRITE_ARITH_H 1
/* Piotr Luszczek */

#ifdef WRITE_ARITH_H	/* for Symantec's buggy "make" */
	f = fopen("arith.h", "w");
	if (!f) {
		printf("Cannot open arith.h\n");
/* Piotr Luszczek */
		exit(1);
/* Piotr Luszczek */
		return 1;
		}
#else
	f = stdout;
#endif

	if (sizeof(double) == 2*sizeof(long))
		a = Lcheck();
	else if (sizeof(double) == 2*sizeof(int)) {
		Ldef = 1;
		a = icheck();
		}
	else if (sizeof(double) == sizeof(long))
		a = ccheck();
	if (a) {
		fprintf(f, "#define %s\n#define Arith_Kind_ASL %d\n",
			a->name, a->kind);
		if (Ldef)
			fprintf(f, "#define Long int\n#define Intcast (int)(long)\n");
		if (dalign)
			fprintf(f, "#define Double_Align\n");
		if (sizeof(char*) == 8)
			fprintf(f, "#define X64_bit_pointers\n");
#ifndef NO_LONG_LONG
		if (sizeof(long long) < 8)
#endif
			fprintf(f, "#define NO_LONG_LONG\n");
		if (a->kind <= 2) {
			if (fzcheck())
				fprintf(f, "#define Sudden_Underflow\n");
			t_nan = -a->kind;
			if (need_nancheck())
				fprintf(f, "#define NANCHECK\n");
			}
/* Piotr Luszczek */
		exit(0);
/* Piotr Luszczek */
		return 0;
		}
	fprintf(f, "/* Unknown arithmetic */\n");


/* Piotr Luszczek */
#ifdef WRITE_ARITH_H	/* for Symantec's buggy "make" */
	fclose(f);
#endif
	exit(1);
/* Piotr Luszczek */

	return 1;
]]),
[acx_lfc_f2c_ok=yes ; mv -f arith.h libf2c ; $3],$4)

# Finally, execute ACTION-IF-FOUND/ACTION-IF-NOT-FOUND:
if test x"$acx_lfc_f2c_ok" = xyes -a -f libf2c/arith.h; then
        AC_MSG_RESULT(done)
        ifelse([$1],,,[$1])
        :
else
        AC_MSG_RESULT(error)
	:
        $2
fi

dnl if test -d libf2c; then
fi

])dnl ACX_LFC_F2C
