/* /home4/luszczek/mscratch/build/SCALAPACK/TOOLS/sltimer.f -- translated by f2c (version 20031025).
   You must link the resulting object file with libf2c:
	on Microsoft Windows system, link with libf2c.lib;
	on Linux or Unix systems, link with .../path/to/libf2c.a -lm
	or, if you install libf2c.a in a standard place, with -lf2c -lm
	-- in that order, at the end of the command line, as in
		cc *.o -lf2c -lm
	Source for libf2c is in /netlib/f2c/libf2c.zip, e.g.,

		http://www.netlib.org/f2c/libf2c.zip
*/

#include "f2c.h"

/* Common Block Declarations */

struct {
    doublereal cpusec[64], wallsec[64], cpustart[64], wallstart[64];
    logical disabled;
} sltimer00_;

#define sltimer00_1 sltimer00_

/* Table of constant values */

static integer c__1 = 1;
static integer c_n1 = -1;
static integer c__0 = 0;

/* Subroutine */ int slboot_(void)
{
    integer i__;


/*  -- ScaLAPACK tools routine (version 1.7) -- */
/*     University of Tennessee, Knoxville, Oak Ridge National Laboratory, */
/*     and University of California, Berkeley. */
/*     May 1, 1997 */

/*  Purpose */
/*  ======= */

/*  SLBOOT (re)sets all timers to 0, and enables SLtimer. */

/*  ===================================================================== */

/*     .. Parameters .. */
/*     .. */
/*     .. Local Scalars .. */
/*     .. */
/*     .. Common Blocks .. */
/*     .. */
/*     .. Executable Statements .. */

    sltimer00_1.disabled = FALSE_;
    for (i__ = 1; i__ <= 64; ++i__) {
	sltimer00_1.cpusec[i__ - 1] = 0.;
	sltimer00_1.wallsec[i__ - 1] = 0.;
	sltimer00_1.cpustart[i__ - 1] = -5.;
	sltimer00_1.wallstart[i__ - 1] = -5.;
/* L10: */
    }

    return 0;

/*     End of SLBOOT */

} /* slboot_ */


/* Subroutine */ int sltimer_(integer *i__)
{
    extern doublereal dcputime00_(void), dwalltime00_(void);


/*  -- ScaLAPACK tools routine (version 1.7) -- */
/*     University of Tennessee, Knoxville, Oak Ridge National Laboratory, */
/*     and University of California, Berkeley. */
/*     May 1, 1997 */

/*     .. Scalar Arguments .. */
/*     .. */

/*  Purpose */
/*  ======= */

/*  SLtimer provides a "stopwatch" functionality cpu/wall timer */
/*  (in seconds).  Up to 64 separate timers can be functioning at once. */
/*  The first call starts the timer, and the second stops it.  This */
/*  routine can be disenabled, so that calls to the timer are ignored. */
/*  This feature can be used to make sure certain sections of code do */
/*  not affect timings, even if they call routines which have SLtimer */
/*  calls in them. */

/*  Arguments */
/*  ========= */

/*  I       (global input) INTEGER */
/*          The timer to stop/start. */

/*  ===================================================================== */

/*     .. Parameters .. */
/*     .. */
/*     .. External Functions .. */
/*     .. */
/*     .. Common Blocks .. */
/*     .. */
/*     .. Executable Statements .. */

/*     If timing disabled, return */

    if (sltimer00_1.disabled) {
	return 0;
    }

    if (sltimer00_1.wallstart[*i__ - 1] == -5.) {

/*        If timer has not been started, start it */

	sltimer00_1.wallstart[*i__ - 1] = dwalltime00_();
	sltimer00_1.cpustart[*i__ - 1] = dcputime00_();

    } else {

/*        Stop timer and add interval to count */

	sltimer00_1.cpusec[*i__ - 1] = sltimer00_1.cpusec[*i__ - 1] + 
		dcputime00_() - sltimer00_1.cpustart[*i__ - 1];
	sltimer00_1.wallsec[*i__ - 1] = sltimer00_1.wallsec[*i__ - 1] + 
		dwalltime00_() - sltimer00_1.wallstart[*i__ - 1];
	sltimer00_1.wallstart[*i__ - 1] = -5.;

    }

    return 0;

/*     End of SLTIMER */

} /* sltimer_ */


/* Subroutine */ int slenable_(void)
{

/*  -- ScaLAPACK tools routine (version 1.7) -- */
/*     University of Tennessee, Knoxville, Oak Ridge National Laboratory, */
/*     and University of California, Berkeley. */
/*     May 1, 1997 */

/*  Purpose */
/*  ======= */

/*  SLENABLE sets it so calls to SLtimer are not ignored. */

/*  ===================================================================== */

/*     .. Parameters .. */
/*     .. */
/*     .. Common Blocks .. */
/*     .. */
/*     .. Executable Statements .. */

    sltimer00_1.disabled = FALSE_;

    return 0;

} /* slenable_ */


/* Subroutine */ int sldisable_(void)
{

/*  -- ScaLAPACK tools routine (version 1.7) -- */
/*     University of Tennessee, Knoxville, Oak Ridge National Laboratory, */
/*     and University of California, Berkeley. */
/*     May 1, 1997 */

/*  Purpose */
/*  ======= */

/*  SLDISABLE sets it so calls to SLTIMER are ignored. */

/*  ===================================================================== */

/*     .. Parameters .. */
/*     .. */
/*     .. Common Blocks .. */
/*     .. */
/*     .. Executable Statements .. */

    sltimer00_1.disabled = TRUE_;

    return 0;

/*     End of SLDISABLE */

} /* sldisable_ */


doublereal slinquire_(char *timetype, integer *i__, ftnlen timetype_len)
{
    /* System generated locals */
    doublereal ret_val;

    /* Local variables */
    extern doublereal dcputime00_(void), dwalltime00_(void);
    doublereal time;
    extern logical lsame_(char *, char *, ftnlen, ftnlen);


/*  -- ScaLAPACK tools routine (version 1.7) -- */
/*     University of Tennessee, Knoxville, Oak Ridge National Laboratory, */
/*     and University of California, Berkeley. */
/*     May 1, 1997 */

/*     .. Scalar Arguments .. */
/*     .. */

/*  Purpose */
/*  ======= */

/*  SLINQUIRE returns wall or cpu time that has accumulated in timer I. */

/*  Arguments */
/*  ========= */

/*  TIMETYPE (global input) CHARACTER */
/*           Controls what time will be returned: */
/*           = 'W': wall clock time is returned, */
/*           = 'C': CPU time is returned (default). */

/*  I        (global input) INTEGER */
/*           The timer to return. */

/*  ===================================================================== */

/*     .. Parameters .. */
/*     .. */
/*     .. Local Scalars .. */
/*     .. */
/*     .. External Functions .. */
/*     .. */
/*     .. Common Blocks .. */
/*     .. */
/*     .. Executable Statements .. */

    if (lsame_(timetype, "W", (ftnlen)1, (ftnlen)1)) {

/*        If walltime not available on this machine, return -1 flag */

	if (dwalltime00_() == -1.) {
	    time = -1.;
	} else {
	    time = sltimer00_1.wallsec[*i__ - 1];
	}
    } else {
	if (dcputime00_() == -1.) {
	    time = -1.;
	} else {
	    time = sltimer00_1.cpusec[*i__ - 1];
	}
    }

    ret_val = time;

    return ret_val;

/*     End of SLINQUIRE */

} /* slinquire_ */


/* Subroutine */ int slcombine_(integer *ictxt, char *scope, char *op, char *
	timetype, integer *n, integer *ibeg, doublereal *times, ftnlen 
	scope_len, ftnlen op_len, ftnlen timetype_len)
{
    /* System generated locals */
    integer i__1;

    /* Local variables */
    integer i__;
    extern doublereal dcputime00_(void), dwalltime00_(void);
    extern logical lsame_(char *, char *, ftnlen, ftnlen);
    logical tmpdis;
    extern /* Subroutine */ int dgamn2d_(integer *, char *, char *, integer *,
	     integer *, doublereal *, integer *, integer *, integer *, 
	    integer *, integer *, integer *, ftnlen, ftnlen), dgamx2d_(
	    integer *, char *, char *, integer *, integer *, doublereal *, 
	    integer *, integer *, integer *, integer *, integer *, integer *, 
	    ftnlen, ftnlen), dgsum2d_(integer *, char *, char *, integer *, 
	    integer *, doublereal *, integer *, integer *, integer *, ftnlen, 
	    ftnlen);


/*  -- ScaLAPACK tools routine (version 1.7) -- */
/*     University of Tennessee, Knoxville, Oak Ridge National Laboratory, */
/*     and University of California, Berkeley. */
/*     May 1, 1997 */

/*     .. Scalar Arguments .. */
/*     .. */
/*     .. Array Arguments .. */
/*     .. */

/*  Purpose */
/*  ======= */

/*  SLCOMBINE takes the timing information stored on a scope of processes */
/*  and combines them into the user's TIMES array. */

/*  Arguments */
/*  ========= */

/*  ICTXT    (local input) INTEGER */
/*           The BLACS context handle. */

/*  SCOPE    (global input) CHARACTER */
/*           Controls what processes in grid participate in combine. */
/*           Options are 'Rowwise', 'Columnwise', or 'All'. */

/*  OP       (global input) CHARACTER */
/*           Controls what combine should be done: */
/*           = '>': get maximal time on any process (default), */
/*           = '<': get minimal time on any process, */
/*           = '+': get sum of times across processes. */

/*  TIMETYPE (global input) CHARACTER */
/*           Controls what time will be returned in TIMES: */
/*           = 'W': wall clock time, */
/*           = 'C': CPU time (default). */

/*  N        (global input) INTEGER */
/*           The number of timers to combine. */

/*  IBEG     (global input) INTEGER */
/*           The first timer to be combined. */

/*  TIMES    (global output) DOUBLE PRECISION array, dimension (N) */
/*           The requested timing information is returned in this array. */

/*  ===================================================================== */

/*     .. Parameters .. */
/*     .. */
/*     .. Local Scalars .. */
/*     .. */
/*     .. External Subroutines .. */
/*     .. */
/*     .. External Functions .. */
/*     .. */
/*     .. Common Blocks .. */
/*     .. */
/*     .. Executable Statements .. */

/*     Disable timer for combine operation */

    /* Parameter adjustments */
    --times;

    /* Function Body */
    tmpdis = sltimer00_1.disabled;
    sltimer00_1.disabled = TRUE_;

/*     Copy timer information into user's times array */

    if (lsame_(timetype, "W", (ftnlen)1, (ftnlen)1)) {

/*        If walltime not available on this machine, fill in times */
/*        with -1 flag, and return */

	if (dwalltime00_() == -1.) {
	    i__1 = *n;
	    for (i__ = 1; i__ <= i__1; ++i__) {
		times[i__] = -1.;
/* L10: */
	    }
	    return 0;
	} else {
	    i__1 = *n;
	    for (i__ = 1; i__ <= i__1; ++i__) {
		times[i__] = sltimer00_1.wallsec[*ibeg + i__ - 2];
/* L20: */
	    }
	}
    } else {
	if (dcputime00_() == -1.) {
	    i__1 = *n;
	    for (i__ = 1; i__ <= i__1; ++i__) {
		times[i__] = -1.;
/* L30: */
	    }
	    return 0;
	} else {
	    i__1 = *n;
	    for (i__ = 1; i__ <= i__1; ++i__) {
		times[i__] = sltimer00_1.cpusec[*ibeg + i__ - 2];
/* L40: */
	    }
	}
    }

/*     Combine all nodes' information, restore disabled, and return */

    if (*(unsigned char *)op == '>') {
	dgamx2d_(ictxt, scope, " ", n, &c__1, &times[1], n, &c_n1, &c_n1, &
		c_n1, &c_n1, &c__0, (ftnlen)1, (ftnlen)1);
    } else if (*(unsigned char *)op == '<') {
	dgamn2d_(ictxt, scope, " ", n, &c__1, &times[1], n, &c_n1, &c_n1, &
		c_n1, &c_n1, &c__0, (ftnlen)1, (ftnlen)1);
    } else if (*(unsigned char *)op == '+') {
	dgsum2d_(ictxt, scope, " ", n, &c__1, &times[1], n, &c_n1, &c__0, (
		ftnlen)1, (ftnlen)1);
    } else {
	dgamx2d_(ictxt, scope, " ", n, &c__1, &times[1], n, &c_n1, &c_n1, &
		c_n1, &c_n1, &c__0, (ftnlen)1, (ftnlen)1);
    }

    sltimer00_1.disabled = tmpdis;

    return 0;

/*     End of SLCOMBINE */

} /* slcombine_ */

