/* /home4/luszczek/mscratch/build/SCALAPACK/TOOLS/pdtreecomb.f -- translated by f2c (version 20031025).
   You must link the resulting object file with libf2c:
	on Microsoft Windows system, link with libf2c.lib;
	on Linux or Unix systems, link with .../path/to/libf2c.a -lm
	or, if you install libf2c.a in a standard place, with -lf2c -lm
	-- in that order, at the end of the command line, as in
		cc *.o -lf2c -lm
	Source for libf2c is in /netlib/f2c/libf2c.zip, e.g.,

		http://www.netlib.org/f2c/libf2c.zip
*/

#include "f2c.h"

/* Table of constant values */

static integer c__1 = 1;

/* Subroutine */ int pdtreecomb_(integer *ictxt, char *scope, integer *n, 
	doublereal *mine, integer *rdest0, integer *cdest0, S_fp subptr, 
	ftnlen scope_len)
{
    integer i__, np, iam;
    doublereal his[2];
    integer dest, dist;
    logical bcast;
    extern logical lsame_(char *, char *, ftnlen, ftnlen);
    integer npcol, cmssg, mycol, rmssg, nprow, myrow;
    logical cscope;
    integer tcdest;
    logical rscope;
    extern /* Subroutine */ int blacs_gridinfo__(integer *, integer *, 
	    integer *, integer *, integer *);
    integer trdest, mydist;
    extern /* Subroutine */ int dgebr2d_(integer *, char *, char *, integer *,
	     integer *, doublereal *, integer *, integer *, integer *, ftnlen,
	     ftnlen), dgebs2d_(integer *, char *, char *, integer *, integer *
	    , doublereal *, integer *, ftnlen, ftnlen), dgesd2d_(integer *, 
	    integer *, integer *, doublereal *, integer *, integer *, integer 
	    *), dgerv2d_(integer *, integer *, integer *, doublereal *, 
	    integer *, integer *, integer *);
    integer mydist2, hisdist;


/*  -- ScaLAPACK tools routine (version 1.7) -- */
/*     University of Tennessee, Knoxville, Oak Ridge National Laboratory, */
/*     and University of California, Berkeley. */
/*     May 1, 1997 */

/*     .. Scalar Arguments .. */
/*     .. */
/*     .. Array Arguments .. */
/*     .. */
/*     .. Subroutine Arguments .. */
/*     .. */

/*  Purpose */
/*  ======= */

/*  PDTREECOMB does a 1-tree parallel combine operation on scalars, */
/*  using the subroutine indicated by SUBPTR to perform the required */
/*  computation. */

/*  Arguments */
/*  ========= */

/*  ICTXT   (global input) INTEGER */
/*          The BLACS context handle, indicating the global context of */
/*          the operation. The context itself is global. */

/*  SCOPE   (global input) CHARACTER */
/*          The scope of the operation:  'Rowwise', 'Columnwise', or */
/*          'All'. */

/*  N       (global input) INTEGER */
/*          The number of elements in MINE.  N = 1 for the norm-2 */
/*          computation and 2 for the sum of square. */

/*  MINE    (local input/global output) DOUBLE PRECISION array of */
/*          dimension at least equal to N. The local data to use in the */
/*          combine. */

/*  RDEST0  (global input) INTEGER */
/*          The process row to receive the answer. If RDEST0 = -1, */
/*          every process in the scope gets the answer. */

/*  CDEST0  (global input) INTEGER */
/*          The process column to receive the answer. If CDEST0 = -1, */
/*          every process in the scope gets the answer. */

/*  SUBPTR  (local input) Pointer to the subroutine to call to perform */
/*          the required combine. */

/*  ===================================================================== */

/*     .. Local Scalars .. */
/*     .. */
/*     .. Local Arrays .. */
/*     .. */
/*     .. External Subroutines .. */
/*     .. */
/*     .. External Functions .. */
/*     .. */
/*     .. Intrinsic Functions .. */
/*     .. */
/*     .. Executable Statements .. */

/*     See if everyone wants the answer (need to broadcast the answer) */

    /* Parameter adjustments */
    --mine;

    /* Function Body */
    bcast = *rdest0 == -1 || *cdest0 == -1;
    if (bcast) {
	trdest = 0;
	tcdest = 0;
    } else {
	trdest = *rdest0;
	tcdest = *cdest0;
    }

/*     Get grid parameters. */

    blacs_gridinfo__(ictxt, &nprow, &npcol, &myrow, &mycol);

/*     Figure scope-dependant variables, or report illegal scope */

    rscope = lsame_(scope, "R", (ftnlen)1, (ftnlen)1);
    cscope = lsame_(scope, "C", (ftnlen)1, (ftnlen)1);

    if (rscope) {
	if (bcast) {
	    trdest = myrow;
	} else if (myrow != trdest) {
	    return 0;
	}
	np = npcol;
	mydist = (npcol + mycol - tcdest) % npcol;
    } else if (cscope) {
	if (bcast) {
	    tcdest = mycol;
	} else if (mycol != tcdest) {
	    return 0;
	}
	np = nprow;
	mydist = (nprow + myrow - trdest) % nprow;
    } else if (lsame_(scope, "A", (ftnlen)1, (ftnlen)1)) {
	np = nprow * npcol;
	iam = myrow * npcol + mycol;
	dest = trdest * npcol + tcdest;
	mydist = (np + iam - dest) % np;
    } else {
	return 0;
    }

    if (np < 2) {
	return 0;
    }

    mydist2 = mydist;
    rmssg = myrow;
    cmssg = mycol;
    i__ = 1;

L10:

    if (mydist % 2 != 0) {

/*           If I am process that sends information */

	dist = i__ * (mydist - mydist % 2);

/*           Figure coordinates of dest of message */

	if (rscope) {
	    cmssg = (tcdest + dist) % np;
	} else if (cscope) {
	    rmssg = (trdest + dist) % np;
	} else {
	    cmssg = (dest + dist) % np;
	    rmssg = cmssg / npcol;
	    cmssg %= npcol;
	}

	dgesd2d_(ictxt, n, &c__1, &mine[1], n, &rmssg, &cmssg);

	goto L20;

    } else {

/*           If I am a process receiving information, figure coordinates */
/*           of source of message */

	dist = mydist2 + i__;
	if (rscope) {
	    cmssg = (tcdest + dist) % np;
	    hisdist = (np + cmssg - tcdest) % np;
	} else if (cscope) {
	    rmssg = (trdest + dist) % np;
	    hisdist = (np + rmssg - trdest) % np;
	} else {
	    cmssg = (dest + dist) % np;
	    rmssg = cmssg / npcol;
	    cmssg %= npcol;
	    hisdist = (np + rmssg * npcol + cmssg - dest) % np;
	}

	if (mydist2 < hisdist) {

/*              If I have anyone sending to me */

	    dgerv2d_(ictxt, n, &c__1, his, n, &rmssg, &cmssg);
	    (*subptr)(&mine[1], his);

	}
	mydist /= 2;

    }
    i__ <<= 1;

    if (i__ < np) {
	goto L10;
    }

L20:

    if (bcast) {
	if (mydist2 == 0) {
	    dgebs2d_(ictxt, scope, " ", n, &c__1, &mine[1], n, (ftnlen)1, (
		    ftnlen)1);
	} else {
	    dgebr2d_(ictxt, scope, " ", n, &c__1, &mine[1], n, &trdest, &
		    tcdest, (ftnlen)1, (ftnlen)1);
	}
    }

    return 0;

/*     End of PDTREECOMB */

} /* pdtreecomb_ */


/* Subroutine */ int dcombamax_(doublereal *v1, doublereal *v2)
{

/*  -- ScaLAPACK tools routine (version 1.7) -- */
/*     University of Tennessee, Knoxville, Oak Ridge National Laboratory, */
/*     and University of California, Berkeley. */
/*     May 1, 1997 */

/*     .. Array Arguments .. */
/*     .. */

/*  Purpose */
/*  ======= */

/*  DCOMBAMAX finds the element having max. absolute value as well */
/*  as its corresponding globl index. */

/*  Arguments */
/*  ========= */

/*  V1        (local input/local output) DOUBLE PRECISION array of */
/*            dimension 2.  The first maximum absolute value element and */
/*            its global index. V1(1) = AMAX, V1(2) = INDX. */

/*  V2        (local input) DOUBLE PRECISION array of dimension 2. */
/*            The second maximum absolute value element and its global */
/*            index. V2(1) = AMAX, V2(2) = INDX. */

/*  ===================================================================== */

/*     .. Intrinsic Functions .. */
/*     .. */
/*     .. Executable Statements .. */

    /* Parameter adjustments */
    --v2;
    --v1;

    /* Function Body */
    if (abs(v1[1]) < abs(v2[1])) {
	v1[1] = v2[1];
	v1[2] = v2[2];
    }

    return 0;

/*     End of DCOMBAMAX */

} /* dcombamax_ */


/* Subroutine */ int dcombssq_(doublereal *v1, doublereal *v2)
{
    /* System generated locals */
    doublereal d__1;


/*  -- ScaLAPACK tools routine (version 1.7) -- */
/*     University of Tennessee, Knoxville, Oak Ridge National Laboratory, */
/*     and University of California, Berkeley. */
/*     May 1, 1997 */

/*     .. Array Arguments .. */
/*     .. */

/*  Purpose */
/*  ======= */

/*  DCOMBSSQ does a scaled sum of squares on two scalars. */

/*  Arguments */
/*  ========= */

/*  V1        (local input/local output) DOUBLE PRECISION array of */
/*            dimension 2.  The first scaled sum. V1(1) = SCALE, */
/*            V1(2) = SUMSQ. */

/*  V2        (local input) DOUBLE PRECISION array of dimension 2. */
/*            The second scaled sum. V2(1) = SCALE, V2(2) = SUMSQ. */

/*  ===================================================================== */

/*     .. Parameters .. */
/*     .. */
/*     .. Executable Statements .. */

    /* Parameter adjustments */
    --v2;
    --v1;

    /* Function Body */
    if (v1[1] >= v2[1]) {
	if (v1[1] != 0.) {
/* Computing 2nd power */
	    d__1 = v2[1] / v1[1];
	    v1[2] += d__1 * d__1 * v2[2];
	}
    } else {
/* Computing 2nd power */
	d__1 = v1[1] / v2[1];
	v1[2] = v2[2] + d__1 * d__1 * v1[2];
	v1[1] = v2[1];
    }

    return 0;

/*     End of DCOMBSSQ */

} /* dcombssq_ */


/* Subroutine */ int dcombnrm2_(doublereal *x, doublereal *y)
{
    /* System generated locals */
    doublereal d__1;

    /* Builtin functions */
    double sqrt(doublereal);

    /* Local variables */
    doublereal w, z__;


/*  -- ScaLAPACK tools routine (version 1.7) -- */
/*     University of Tennessee, Knoxville, Oak Ridge National Laboratory, */
/*     and University of California, Berkeley. */
/*     May 1, 1997 */

/*     .. Scalar Arguments .. */
/*     .. */

/*  Purpose */
/*  ======= */

/*  DCOMBNRM2 combines local norm 2 results, taking care not to cause */
/*  unnecessary overflow. */

/*  Arguments */
/*  ========= */

/*  X       (local input) DOUBLE PRECISION */
/*  Y       (local input) DOUBLE PRECISION */
/*          X and Y specify the values x and y. X and Y are supposed to */
/*          be >= 0. */

/*  ===================================================================== */

/*     .. Parameters .. */
/*     .. */
/*     .. Local Scalars .. */
/*     .. */
/*     .. Intrinsic Functions .. */
/*     .. */
/*     .. Executable Statements .. */

    w = max(*x,*y);
    z__ = min(*x,*y);

    if (z__ == 0.) {
	*x = w;
    } else {
/* Computing 2nd power */
	d__1 = z__ / w;
	*x = w * sqrt(d__1 * d__1 + 1.);
    }

    return 0;

/*     End of DCOMBNRM2 */

} /* dcombnrm2_ */

