/* /home4/luszczek/mscratch/build/SCALAPACK/TOOLS/pdmatadd.f -- translated by f2c (version 20031025).
   You must link the resulting object file with libf2c:
	on Microsoft Windows system, link with libf2c.lib;
	on Linux or Unix systems, link with .../path/to/libf2c.a -lm
	or, if you install libf2c.a in a standard place, with -lf2c -lm
	-- in that order, at the end of the command line, as in
		cc *.o -lf2c -lm
	Source for libf2c is in /netlib/f2c/libf2c.zip, e.g.,

		http://www.netlib.org/f2c/libf2c.zip
*/

#include "f2c.h"

/* Subroutine */ int pdmatadd_(integer *m, integer *n, doublereal *alpha, 
	doublereal *a, integer *ia, integer *ja, integer *desca, doublereal *
	beta, doublereal *c__, integer *ic, integer *jc, integer *descc)
{
    /* System generated locals */
    integer i__1, i__2;

    /* Local variables */
    integer i__, j, mp, nq, lda, iia, ldc, iic, jja, jjc, ioffa, icoff, iacol,
	     ioffc, iccol, iroff, npcol, iarow, icrow, mycol, nprow, myrow;
    extern /* Subroutine */ int blacs_gridinfo__(integer *, integer *, 
	    integer *, integer *, integer *);
    extern integer numroc_(integer *, integer *, integer *, integer *, 
	    integer *);
    extern /* Subroutine */ int infog2l_(integer *, integer *, integer *, 
	    integer *, integer *, integer *, integer *, integer *, integer *, 
	    integer *, integer *);


/*  -- ScaLAPACK tools routine (version 1.7) -- */
/*     University of Tennessee, Knoxville, Oak Ridge National Laboratory, */
/*     and University of California, Berkeley. */
/*     May 1, 1997 */

/*     .. Scalar Arguments .. */
/*     .. */
/*     .. Array Arguments .. */
/*     .. */

/*  Purpose */
/*  ======= */

/*  PDMATADD performs a distributed matrix-matrix addition */

/*            sub( C ) := alpha * sub( A ) + beta * sub( C ), */

/*  where sub( C ) denotes C(IC:IC+M-1,JC:JC+N-1) and sub( A ) denotes */
/*  A(IA:IA+M-1,JA:JA+N-1). No communications are performed in this */
/*  routine, the arrays are supposed to be aligned. */

/*  Notes */
/*  ===== */

/*  Each global data object is described by an associated description */
/*  vector.  This vector stores the information required to establish */
/*  the mapping between an object element and its corresponding process */
/*  and memory location. */

/*  Let A be a generic term for any 2D block cyclicly distributed array. */
/*  Such a global array has an associated description vector DESCA. */
/*  In the following comments, the character _ should be read as */
/*  "of the global array". */

/*  NOTATION        STORED IN      EXPLANATION */
/*  --------------- -------------- -------------------------------------- */
/*  DTYPE_A(global) DESCA( DTYPE_ )The descriptor type.  In this case, */
/*                                 DTYPE_A = 1. */
/*  CTXT_A (global) DESCA( CTXT_ ) The BLACS context handle, indicating */
/*                                 the BLACS process grid A is distribu- */
/*                                 ted over. The context itself is glo- */
/*                                 bal, but the handle (the integer */
/*                                 value) may vary. */
/*  M_A    (global) DESCA( M_ )    The number of rows in the global */
/*                                 array A. */
/*  N_A    (global) DESCA( N_ )    The number of columns in the global */
/*                                 array A. */
/*  MB_A   (global) DESCA( MB_ )   The blocking factor used to distribute */
/*                                 the rows of the array. */
/*  NB_A   (global) DESCA( NB_ )   The blocking factor used to distribute */
/*                                 the columns of the array. */
/*  RSRC_A (global) DESCA( RSRC_ ) The process row over which the first */
/*                                 row of the array A is distributed. */
/*  CSRC_A (global) DESCA( CSRC_ ) The process column over which the */
/*                                 first column of the array A is */
/*                                 distributed. */
/*  LLD_A  (local)  DESCA( LLD_ )  The leading dimension of the local */
/*                                 array.  LLD_A >= MAX(1,LOCr(M_A)). */

/*  Let K be the number of rows or columns of a distributed matrix, */
/*  and assume that its process grid has dimension p x q. */
/*  LOCr( K ) denotes the number of elements of K that a process */
/*  would receive if K were distributed over the p processes of its */
/*  process column. */
/*  Similarly, LOCc( K ) denotes the number of elements of K that a */
/*  process would receive if K were distributed over the q processes of */
/*  its process row. */
/*  The values of LOCr() and LOCc() may be determined via a call to the */
/*  ScaLAPACK tool function, NUMROC: */
/*          LOCr( M ) = NUMROC( M, MB_A, MYROW, RSRC_A, NPROW ), */
/*          LOCc( N ) = NUMROC( N, NB_A, MYCOL, CSRC_A, NPCOL ). */
/*  An upper bound for these quantities may be computed by: */
/*          LOCr( M ) <= ceil( ceil(M/MB_A)/NPROW )*MB_A */
/*          LOCc( N ) <= ceil( ceil(N/NB_A)/NPCOL )*NB_A */

/*  Arguments */
/*  ========= */

/*  M       (global input) INTEGER */
/*          The number of rows to be operated on i.e the number of rows */
/*          of the distributed submatrices sub( A ) and sub( C ). M >= 0. */

/*  N       (global input) INTEGER */
/*          The number of columns to be operated on i.e the number of */
/*          columns of the distributed submatrices  sub( A ) and */
/*          sub( C ). N >= 0. */

/*  ALPHA   (global input) DOUBLE PRECISION */
/*          The scalar ALPHA. */

/*  A       (local input) DOUBLE PRECISION pointer into the local memory */
/*          to a local array of dimension (LLD_A, LOCc(JA+N-1) ). This */
/*          array contains the local pieces of the distributed matrix */
/*          sub( A ). */

/*  IA      (global input) INTEGER */
/*          The row index in the global array A indicating the first */
/*          row of sub( A ). */

/*  JA      (global input) INTEGER */
/*          The column index in the global array A indicating the */
/*          first column of sub( A ). */

/*  DESCA   (global and local input) INTEGER array of dimension DLEN_. */
/*          The array descriptor for the distributed matrix A. */

/*  BETA    (global input) DOUBLE PRECISION */
/*          The scalar BETA. */

/*  C       (local input/local output) DOUBLE PRECISION pointer into the */
/*          local memory to an array of dimension (LLD_C,LOCc(JC+N-1)). */
/*          This array contains the local pieces of the distributed */
/*          matrix sub( C ).  On exit, this array contains the local */
/*          pieces of the resulting distributed matrix. */

/*  IC      (global input) INTEGER */
/*          The row index in the global array C indicating the first */
/*          row of sub( C ). */

/*  JC      (global input) INTEGER */
/*          The column index in the global array C indicating the */
/*          first column of sub( C ). */

/*  DESCC   (global and local input) INTEGER array of dimension DLEN_. */
/*          The array descriptor for the distributed matrix C. */

/*  ===================================================================== */

/*     .. Parameters .. */
/*     .. */
/*     .. Local Scalars .. */
/*     .. */
/*     .. External Subroutines .. */
/*     .. */
/*     .. External Functions .. */
/*     .. */
/*     .. Executable Statements .. */

/*     Get grid parameters. */

    /* Parameter adjustments */
    --descc;
    --c__;
    --desca;
    --a;

    /* Function Body */
    blacs_gridinfo__(&desca[2], &nprow, &npcol, &myrow, &mycol);

/*     Quick return if possible. */

    if (*m == 0 || *n == 0 || *alpha == 0. && *beta == 1.) {
	return 0;
    }

    infog2l_(ia, ja, &desca[1], &nprow, &npcol, &myrow, &mycol, &iia, &jja, &
	    iarow, &iacol);
    infog2l_(ic, jc, &descc[1], &nprow, &npcol, &myrow, &mycol, &iic, &jjc, &
	    icrow, &iccol);

    iroff = (*ia - 1) % desca[5];
    icoff = (*ja - 1) % desca[6];
    i__1 = *m + iroff;
    mp = numroc_(&i__1, &desca[5], &myrow, &iarow, &nprow);
    i__1 = *n + icoff;
    nq = numroc_(&i__1, &desca[6], &mycol, &iacol, &npcol);
    if (myrow == iarow) {
	mp -= iroff;
    }
    if (mycol == iacol) {
	nq -= icoff;
    }
    lda = desca[9];
    ldc = descc[9];

    if (nq == 1) {
	if (*beta == 0.) {
	    if (*alpha == 0.) {
		ioffc = iic + (jjc - 1) * ldc;
		i__1 = ioffc + mp - 1;
		for (i__ = ioffc; i__ <= i__1; ++i__) {
		    c__[i__] = 0.;
/* L10: */
		}
	    } else {
		ioffa = iia + (jja - 1) * lda;
		ioffc = iic + (jjc - 1) * ldc;
		i__1 = ioffc + mp - 1;
		for (i__ = ioffc; i__ <= i__1; ++i__) {
		    c__[i__] = *alpha * a[ioffa];
		    ++ioffa;
/* L20: */
		}
	    }
	} else {
	    if (*alpha == 1.) {
		if (*beta == 1.) {
		    ioffa = iia + (jja - 1) * lda;
		    ioffc = iic + (jjc - 1) * ldc;
		    i__1 = ioffc + mp - 1;
		    for (i__ = ioffc; i__ <= i__1; ++i__) {
			c__[i__] += a[ioffa];
			++ioffa;
/* L30: */
		    }
		} else {
		    ioffa = iia + (jja - 1) * lda;
		    ioffc = iic + (jjc - 1) * ldc;
		    i__1 = ioffc + mp - 1;
		    for (i__ = ioffc; i__ <= i__1; ++i__) {
			c__[i__] = *beta * c__[i__] + a[ioffa];
			++ioffa;
/* L40: */
		    }
		}
	    } else if (*beta == 1.) {
		ioffa = iia + (jja - 1) * lda;
		ioffc = iic + (jjc - 1) * ldc;
		i__1 = ioffc + mp - 1;
		for (i__ = ioffc; i__ <= i__1; ++i__) {
		    c__[i__] += *alpha * a[ioffa];
		    ++ioffa;
/* L50: */
		}
	    } else {
		ioffa = iia + (jja - 1) * lda;
		ioffc = iic + (jjc - 1) * ldc;
		i__1 = ioffc + mp - 1;
		for (i__ = ioffc; i__ <= i__1; ++i__) {
		    c__[i__] = *beta * c__[i__] + *alpha * a[ioffa];
		    ++ioffa;
/* L60: */
		}
	    }
	}
    } else {
	if (*beta == 0.) {
	    if (*alpha == 0.) {
		ioffc = iic + (jjc - 1) * ldc;
		i__1 = nq;
		for (j = 1; j <= i__1; ++j) {
		    i__2 = ioffc + mp - 1;
		    for (i__ = ioffc; i__ <= i__2; ++i__) {
			c__[i__] = 0.;
/* L70: */
		    }
		    ioffc += ldc;
/* L80: */
		}
	    } else {
		ioffa = iia + (jja - 1) * lda;
		ioffc = iic + (jjc - 1) * ldc;
		i__1 = nq;
		for (j = 1; j <= i__1; ++j) {
		    i__2 = ioffc + mp - 1;
		    for (i__ = ioffc; i__ <= i__2; ++i__) {
			c__[i__] = *alpha * a[ioffa];
			++ioffa;
/* L90: */
		    }
		    ioffa = ioffa + lda - mp;
		    ioffc += ldc;
/* L100: */
		}
	    }
	} else {
	    if (*alpha == 1.) {
		if (*beta == 1.) {
		    ioffa = iia + (jja - 1) * lda;
		    ioffc = iic + (jjc - 1) * ldc;
		    i__1 = nq;
		    for (j = 1; j <= i__1; ++j) {
			i__2 = ioffc + mp - 1;
			for (i__ = ioffc; i__ <= i__2; ++i__) {
			    c__[i__] += a[ioffa];
			    ++ioffa;
/* L110: */
			}
			ioffa = ioffa + lda - mp;
			ioffc += ldc;
/* L120: */
		    }
		} else {
		    ioffa = iia + (jja - 1) * lda;
		    ioffc = iic + (jjc - 1) * ldc;
		    i__1 = nq;
		    for (j = 1; j <= i__1; ++j) {
			i__2 = ioffc + mp - 1;
			for (i__ = ioffc; i__ <= i__2; ++i__) {
			    c__[i__] = *beta * c__[i__] + a[ioffa];
			    ++ioffa;
/* L130: */
			}
			ioffa = ioffa + lda - mp;
			ioffc += ldc;
/* L140: */
		    }
		}
	    } else if (*beta == 1.) {
		ioffa = iia + (jja - 1) * lda;
		ioffc = iic + (jjc - 1) * ldc;
		i__1 = nq;
		for (j = 1; j <= i__1; ++j) {
		    i__2 = ioffc + mp - 1;
		    for (i__ = ioffc; i__ <= i__2; ++i__) {
			c__[i__] += *alpha * a[ioffa];
			++ioffa;
/* L150: */
		    }
		    ioffa = ioffa + lda - mp;
		    ioffc += ldc;
/* L160: */
		}
	    } else {
		ioffa = iia + (jja - 1) * lda;
		ioffc = iic + (jjc - 1) * ldc;
		i__1 = nq;
		for (j = 1; j <= i__1; ++j) {
		    i__2 = ioffc + mp - 1;
		    for (i__ = ioffc; i__ <= i__2; ++i__) {
			c__[i__] = *beta * c__[i__] + *alpha * a[ioffa];
			++ioffa;
/* L170: */
		    }
		    ioffa = ioffa + lda - mp;
		    ioffc += ldc;
/* L180: */
		}
	    }
	}
    }

    return 0;

/*     End of PDMATADD */

} /* pdmatadd_ */

