/* /home4/luszczek/mscratch/build/SCALAPACK/TOOLS/pdcol2row.f -- translated by f2c (version 20031025).
   You must link the resulting object file with libf2c:
	on Microsoft Windows system, link with libf2c.lib;
	on Linux or Unix systems, link with .../path/to/libf2c.a -lm
	or, if you install libf2c.a in a standard place, with -lf2c -lm
	-- in that order, at the end of the command line, as in
		cc *.o -lf2c -lm
	Source for libf2c is in /netlib/f2c/libf2c.zip, e.g.,

		http://www.netlib.org/f2c/libf2c.zip
*/

#include "f2c.h"

/* Table of constant values */

static integer c__1 = 1;

/* Subroutine */ int pdcol2row_(integer *ictxt, integer *m, integer *n, 
	integer *nb, doublereal *vs, integer *ldvs, doublereal *vd, integer *
	ldvd, integer *rsrc, integer *csrc, integer *rdest, integer *cdest, 
	doublereal *work)
{
    /* System generated locals */
    integer vd_dim1, vd_offset, vs_dim1, vs_offset, i__1, i__2, i__3, i__4, 
	    i__5;

    /* Local variables */
    integer cblkskip, rblkskip, k, jb, ii, jj, mp, mq, lcm;
    extern integer ilcm_(integer *, integer *);
    integer icpy, npcol, irsrc, mycol, nprow, myrow, icdest;
    extern /* Subroutine */ int dlacpy_(char *, integer *, integer *, 
	    doublereal *, integer *, doublereal *, integer *, ftnlen), 
	    blacs_gridinfo__(integer *, integer *, integer *, integer *, 
	    integer *);
    extern integer numroc_(integer *, integer *, integer *, integer *, 
	    integer *);
    integer istart, mydist;
    extern /* Subroutine */ int dgesd2d_(integer *, integer *, integer *, 
	    doublereal *, integer *, integer *, integer *), dgerv2d_(integer *
	    , integer *, integer *, doublereal *, integer *, integer *, 
	    integer *);
    integer nblocks;


/*  -- ScaLAPACK tools routine (version 1.7) -- */
/*     University of Tennessee, Knoxville, Oak Ridge National Laboratory, */
/*     and University of California, Berkeley. */
/*     May 1, 1997 */

/*     .. Scalar Arguments .. */
/*     .. */
/*     .. Array Arguments .. */
/*     .. */

/*  Purpose */
/*  ======= */

/*  Take a block of vectors with M total rows which are distributed over */
/*  a column of processes, and distribute those rows over a row of */
/*  processes. This routine minimizes communication by sending all */
/*  information it has that a given process in the RDEST needs at once. */
/*  To do this it uses the least common multiple (LCM) concept.  This is */
/*  simply the realization that if I have part of a vector split over a */
/*  process column consisting of P processes, and I want to send all of */
/*  that vector that I own to a new vector distributed over Q processes */
/*  within a process row, that after I find the process in RDEST that */
/*  owns the row of the vector I'm currently looking at, he will want */
/*  every ( (LCM(P,Q) / P ) block of my vector (the block being of size */
/*  NB x N). */

/*  Arguments */
/*  ========= */

/*  Rem:  MP, resp. NQ, denotes the number of local rows, resp. local */
/*  ====  columns, necessary to store a global vector of dimension M */
/*        across P processes, resp. N over Q processes. */

/*  ICTXT   (global input) INTEGER */
/*          The BLACS context handle, indicating the global context of */
/*          the operation. The context itself is global. */

/*  M       (global input) INTEGER */
/*          The number of global rows each vector has. */

/*  N       (global input) INTEGER */
/*          The number of vectors in the vector block. */

/*  NB      (global input) INTEGER */
/*          The blocking factor used to divide the rows of the vector */
/*          amongst the processes of a column. */

/*  VS      (local input) DOUBLE PRECISION */
/*          Array of dimension (LDVS,N), the block of vectors stored on */
/*          process column CSRC to be put into memory VD, and stored */
/*          on process row RDEST. */

/*  LDVS    (local input) INTEGER */
/*          The leading dimension of VS, LDVS >= MAX( 1, MP ). */

/*  VD      (local output) DOUBLE PRECISION */
/*          Array of dimension (LDVD,N), on output, the contents of VS */
/*          stored on process row RDEST will be here. */

/*  LDVD    (local input) INTEGER */
/*          The leading dimension of VD, LDVD >= MAX( 1, MQ ). */

/*  RSRC    (global input) INTEGER */
/*          The process row the distributed block of vectors VS begins */
/*          on. */

/*  CSRC    (global input) INTEGER */
/*          The process column VS is distributed over. */

/*  RDEST   (global input) INTEGER */
/*          The process row to distribute VD over. */

/*  CDEST   (global input) INTEGER */
/*          The process column that VD begins on. */

/*  WORK    (local workspace) DOUBLE PRECISION */
/*          Array of dimension (LDW), the required size of work varies: */
/*          if( nprow.eq.npcol ) then */
/*             LDW = 0; WORK not accessed. */
/*          else */
/*             lcm = least common multiple of process rows and columns. */
/*             Mp  = number of rows of VS on my process. */
/*             nprow = number of process rows */
/*             CEIL = the ceiling of given operation */
/*             LDW = NB*N*CEIL( CEIL( Mp/NB )/(LCM/nprow) ) */
/*          end if */

/*  ===================================================================== */

/*     .. Local Scalars .. */
/*     .. */
/*     .. External Subroutines .. */
/*     .. */
/*     .. External Functions .. */
/*     .. */
/*     .. Executable Statements .. */

/*     Get grid parameters. */

    /* Parameter adjustments */
    vs_dim1 = *ldvs;
    vs_offset = 1 + vs_dim1;
    vs -= vs_offset;
    vd_dim1 = *ldvd;
    vd_offset = 1 + vd_dim1;
    vd -= vd_offset;
    --work;

    /* Function Body */
    blacs_gridinfo__(ictxt, &nprow, &npcol, &myrow, &mycol);

/*     If we are not in special case for NPROW = NPCOL where there */
/*     is no copying required */

    if (nprow != npcol) {
	lcm = ilcm_(&nprow, &npcol);
	rblkskip = lcm / npcol;
	cblkskip = lcm / nprow;

/*        If I have part of VS, the source vector(s) */

	if (mycol == *csrc) {

	    istart = 1;

/*           Figure my distance from RSRC: the process in RDEST the same */
/*           distance from CDEST will want my first block */

	    mydist = (nprow + myrow - *rsrc) % nprow;
	    mp = numroc_(m, nb, &myrow, rsrc, &nprow);
	    icdest = (*cdest + mydist) % npcol;

/*           Loop over all possible destination processes */

	    i__1 = cblkskip;
	    for (k = 1; k <= i__1; ++k) {
		jj = 1;

/*              If I am not destination process */

		if (mycol != icdest || myrow != *rdest) {

/*                 Pack all data I own that destination needs */

		    i__2 = mp;
		    i__3 = *nb * cblkskip;
		    for (ii = istart; i__3 < 0 ? ii >= i__2 : ii <= i__2; ii 
			    += i__3) {
/* Computing MIN */
			i__4 = *nb, i__5 = mp - ii + 1;
			jb = min(i__4,i__5);
			dlacpy_("G", &jb, n, &vs[ii + vs_dim1], ldvs, &work[
				jj], &jb, (ftnlen)1);
			jj += *nb * *n;
/* L10: */
		    }

/*                 Figure how many rows are to be sent and send them if */
/*                 necessary (NOTE: will send extra if NB > JB) */

		    --jj;
		    if (jj > 0) {
			dgesd2d_(ictxt, &jj, &c__1, &work[1], &jj, rdest, &
				icdest);
		    }

		} else {

/*                 I am both source and destination, save where to start */
/*                 copying from for later use. */

		    icpy = istart;
		}

		istart += *nb;
		icdest = (icdest + nprow) % npcol;
/* L20: */
	    }
	}

/*        If I should receive info into VD */

	if (myrow == *rdest) {

	    istart = 1;

/*           Figure my distance from CDEST: the process in CSRC the same */
/*           distance from RSRC will have my first block. */

	    mydist = (npcol + mycol - *cdest) % npcol;
	    mq = numroc_(m, nb, &mycol, cdest, &npcol);
	    irsrc = (*rsrc + mydist) % nprow;
	    i__1 = rblkskip;
	    for (k = 1; k <= i__1; ++k) {

/*              If I don't already possess the required data */

		if (mycol != *csrc || myrow != irsrc) {

/*                 Figure how many rows to receive, and receive them */
/*                 NOTE: may receive to much -- NB instead of JB */

		    nblocks = (mq - istart + *nb) / *nb;
		    jj = (nblocks + rblkskip - 1) / rblkskip * *nb;
		    if (jj > 0) {
			dgerv2d_(ictxt, &jj, n, &work[1], &jj, &irsrc, csrc);
		    }

/*                 Copy data to destination vector */

		    jj = 1;
		    i__3 = mq;
		    i__2 = *nb * rblkskip;
		    for (ii = istart; i__2 < 0 ? ii >= i__3 : ii <= i__3; ii 
			    += i__2) {
/* Computing MIN */
			i__4 = *nb, i__5 = mq - ii + 1;
			jb = min(i__4,i__5);
			dlacpy_("G", &jb, n, &work[jj], &jb, &vd[ii + vd_dim1]
				, ldvd, (ftnlen)1);
			jj += *nb * *n;
/* L30: */
		    }

/*                 If I am both source and destination */

		} else {
		    jj = icpy;
		    i__2 = mq;
		    i__3 = *nb * rblkskip;
		    for (ii = istart; i__3 < 0 ? ii >= i__2 : ii <= i__2; ii 
			    += i__3) {
/* Computing MIN */
			i__4 = *nb, i__5 = mq - ii + 1;
			jb = min(i__4,i__5);
			dlacpy_("G", &jb, n, &vs[jj + vs_dim1], ldvs, &vd[ii 
				+ vd_dim1], ldvd, (ftnlen)1);
			jj += *nb * cblkskip;
/* L40: */
		    }
		}
		istart += *nb;
		irsrc = (irsrc + npcol) % nprow;
/* L50: */
	    }
	}

/*     If NPROW = NPCOL, there is a one-to-one correspondance between */
/*     process rows and columns, so no work space or copying required */

    } else {

	if (mycol == *csrc) {

/*           Figure my distance from RSRC: the process in RDEST the same */
/*           distance from CDEST will want my piece of the vector. */

	    mydist = (nprow + myrow - *rsrc) % nprow;
	    mp = numroc_(m, nb, &myrow, rsrc, &nprow);
	    icdest = (*cdest + mydist) % npcol;

	    if (mycol != icdest || myrow != *rdest) {
		dgesd2d_(ictxt, &mp, n, &vs[vs_offset], ldvs, rdest, &icdest);
	    } else {
		dlacpy_("G", &mp, n, &vs[vs_offset], ldvs, &vd[vd_offset], 
			ldvd, (ftnlen)1);
	    }
	}

	if (myrow == *rdest) {

/*           Figure my distance from CDEST: the process in CSRC the same */
/*           distance from RSRC will have my piece of the vector. */

	    mydist = (npcol + mycol - *cdest) % npcol;
	    mq = numroc_(m, nb, &mycol, cdest, &npcol);
	    irsrc = (*rsrc + mydist) % nprow;

	    if (myrow != irsrc || mycol != *csrc) {
		dgerv2d_(ictxt, &mq, n, &vd[vd_offset], ldvd, &irsrc, csrc);
	    }

	}

    }

    return 0;

/*     End of PDCOL2ROW */

} /* pdcol2row_ */

