/* /home4/luszczek/mscratch/build/SCALAPACK/TOOLS/numroc.f -- translated by f2c (version 20031025).
   You must link the resulting object file with libf2c:
	on Microsoft Windows system, link with libf2c.lib;
	on Linux or Unix systems, link with .../path/to/libf2c.a -lm
	or, if you install libf2c.a in a standard place, with -lf2c -lm
	-- in that order, at the end of the command line, as in
		cc *.o -lf2c -lm
	Source for libf2c is in /netlib/f2c/libf2c.zip, e.g.,

		http://www.netlib.org/f2c/libf2c.zip
*/

#include "f2c.h"

integer numroc_(integer *n, integer *nb, integer *iproc, integer *isrcproc, 
	integer *nprocs)
{
    /* System generated locals */
    integer ret_val;

    /* Local variables */
    integer extrablks, mydist, nblocks;


/*  -- ScaLAPACK tools routine (version 1.7) -- */
/*     University of Tennessee, Knoxville, Oak Ridge National Laboratory, */
/*     and University of California, Berkeley. */
/*     May 1, 1997 */

/*     .. Scalar Arguments .. */
/*     .. */

/*  Purpose */
/*  ======= */

/*  NUMROC computes the NUMber of Rows Or Columns of a distributed */
/*  matrix owned by the process indicated by IPROC. */

/*  Arguments */
/*  ========= */

/*  N         (global input) INTEGER */
/*            The number of rows/columns in distributed matrix. */

/*  NB        (global input) INTEGER */
/*            Block size, size of the blocks the distributed matrix is */
/*            split into. */

/*  IPROC     (local input) INTEGER */
/*            The coordinate of the process whose local array row or */
/*            column is to be determined. */

/*  ISRCPROC  (global input) INTEGER */
/*            The coordinate of the process that possesses the first */
/*            row or column of the distributed matrix. */

/*  NPROCS    (global input) INTEGER */
/*            The total number processes over which the matrix is */
/*            distributed. */

/*  ===================================================================== */

/*     .. Local Scalars .. */
/*     .. */
/*     .. Intrinsic Functions .. */
/*     .. */
/*     .. Executable Statements .. */

/*     Figure PROC's distance from source process */

    mydist = (*nprocs + *iproc - *isrcproc) % *nprocs;

/*     Figure the total number of whole NB blocks N is split up into */

    nblocks = *n / *nb;

/*     Figure the minimum number of rows/cols a process can have */

    ret_val = nblocks / *nprocs * *nb;

/*     See if there are any extra blocks */

    extrablks = nblocks % *nprocs;

/*     If I have an extra block */

    if (mydist < extrablks) {
	ret_val += *nb;

/*         If I have last block, it may be a partial block */

    } else if (mydist == extrablks) {
	ret_val += *n % *nb;
    }

    return ret_val;

/*     End of NUMROC */

} /* numroc_ */

