/* /home4/luszczek/mscratch/build/SCALAPACK/TOOLS/infog2l.f -- translated by f2c (version 20031025).
   You must link the resulting object file with libf2c:
	on Microsoft Windows system, link with libf2c.lib;
	on Linux or Unix systems, link with .../path/to/libf2c.a -lm
	or, if you install libf2c.a in a standard place, with -lf2c -lm
	-- in that order, at the end of the command line, as in
		cc *.o -lf2c -lm
	Source for libf2c is in /netlib/f2c/libf2c.zip, e.g.,

		http://www.netlib.org/f2c/libf2c.zip
*/

#include "f2c.h"

/* Subroutine */ int infog2l_(integer *grindx, integer *gcindx, integer *desc,
	 integer *nprow, integer *npcol, integer *myrow, integer *mycol, 
	integer *lrindx, integer *lcindx, integer *rsrc, integer *csrc)
{
    integer cblk, rblk, gccpy, grcpy;


/*  -- ScaLAPACK tools routine (version 1.7) -- */
/*     University of Tennessee, Knoxville, Oak Ridge National Laboratory, */
/*     and University of California, Berkeley. */
/*     May 1, 1997 */

/*     .. Scalar Arguments .. */
/*     .. */
/*     .. Array Arguments .. */
/*     .. */

/*  Purpose */
/*  ======= */

/*  INFOG2L computes the starting local indexes LRINDX, LCINDX corres- */
/*  ponding to the distributed submatrix starting globally at the entry */
/*  pointed by GRINDX, GCINDX. This routine returns the coordinates in */
/*  the grid of the process owning the matrix entry of global indexes */
/*  GRINDX, GCINDX, namely RSRC and CSRC. */

/*  Notes */
/*  ===== */

/*  Each global data object is described by an associated description */
/*  vector.  This vector stores the information required to establish */
/*  the mapping between an object element and its corresponding process */
/*  and memory location. */

/*  Let A be a generic term for any 2D block cyclicly distributed array. */
/*  Such a global array has an associated description vector DESCA. */
/*  In the following comments, the character _ should be read as */
/*  "of the global array". */

/*  NOTATION        STORED IN      EXPLANATION */
/*  --------------- -------------- -------------------------------------- */
/*  DTYPE_A(global) DESCA( DTYPE_ )The descriptor type.  In this case, */
/*                                 DTYPE_A = 1. */
/*  CTXT_A (global) DESCA( CTXT_ ) The BLACS context handle, indicating */
/*                                 the BLACS process grid A is distribu- */
/*                                 ted over. The context itself is glo- */
/*                                 bal, but the handle (the integer */
/*                                 value) may vary. */
/*  M_A    (global) DESCA( M_ )    The number of rows in the global */
/*                                 array A. */
/*  N_A    (global) DESCA( N_ )    The number of columns in the global */
/*                                 array A. */
/*  MB_A   (global) DESCA( MB_ )   The blocking factor used to distribute */
/*                                 the rows of the array. */
/*  NB_A   (global) DESCA( NB_ )   The blocking factor used to distribute */
/*                                 the columns of the array. */
/*  RSRC_A (global) DESCA( RSRC_ ) The process row over which the first */
/*                                 row of the array A is distributed. */
/*  CSRC_A (global) DESCA( CSRC_ ) The process column over which the */
/*                                 first column of the array A is */
/*                                 distributed. */
/*  LLD_A  (local)  DESCA( LLD_ )  The leading dimension of the local */
/*                                 array.  LLD_A >= MAX(1,LOCr(M_A)). */

/*  Let K be the number of rows or columns of a distributed matrix, */
/*  and assume that its process grid has dimension p x q. */
/*  LOCr( K ) denotes the number of elements of K that a process */
/*  would receive if K were distributed over the p processes of its */
/*  process column. */
/*  Similarly, LOCc( K ) denotes the number of elements of K that a */
/*  process would receive if K were distributed over the q processes of */
/*  its process row. */
/*  The values of LOCr() and LOCc() may be determined via a call to the */
/*  ScaLAPACK tool function, NUMROC: */
/*          LOCr( M ) = NUMROC( M, MB_A, MYROW, RSRC_A, NPROW ), */
/*          LOCc( N ) = NUMROC( N, NB_A, MYCOL, CSRC_A, NPCOL ). */
/*  An upper bound for these quantities may be computed by: */
/*          LOCr( M ) <= ceil( ceil(M/MB_A)/NPROW )*MB_A */
/*          LOCc( N ) <= ceil( ceil(N/NB_A)/NPCOL )*NB_A */

/*  Arguments */
/*  ========= */

/*  GRINDX    (global input) INTEGER */
/*            The global row starting index of the submatrix. */

/*  GCINDX    (global input) INTEGER */
/*            The global column starting index of the submatrix. */

/*  DESC      (input) INTEGER array of dimension DLEN_. */
/*            The array descriptor for the underlying distributed matrix. */

/*  NPROW     (global input) INTEGER */
/*            The total number of process rows over which the distributed */
/*            matrix is distributed. */

/*  NPCOL     (global input) INTEGER */
/*            The total number of process columns over which the */
/*            distributed matrix is distributed. */

/*  MYROW     (local input) INTEGER */
/*            The row coordinate of the process calling this routine. */

/*  MYCOL     (local input) INTEGER */
/*            The column coordinate of the process calling this routine. */

/*  LRINDX    (local output) INTEGER */
/*            The local rows starting index of the submatrix. */

/*  LCINDX    (local output) INTEGER */
/*            The local columns starting index of the submatrix. */

/*  RSRC      (global output) INTEGER */
/*            The row coordinate of the process that possesses the first */
/*            row and column of the submatrix. */

/*  CSRC      (global output) INTEGER */
/*            The column coordinate of the process that possesses the */
/*            first row and column of the submatrix. */

/*  ===================================================================== */

/*     .. Parameters .. */
/*     .. */
/*     .. Local Scalars .. */
/*     .. */
/*     .. Intrinsic Functions .. */
/*     .. */
/*     .. Executable Statements .. */

    /* Parameter adjustments */
    --desc;

    /* Function Body */
    grcpy = *grindx - 1;
    gccpy = *gcindx - 1;

    rblk = grcpy / desc[5];
    cblk = gccpy / desc[6];
    *rsrc = (rblk + desc[7]) % *nprow;
    *csrc = (cblk + desc[8]) % *npcol;

    *lrindx = (rblk / *nprow + 1) * desc[5] + 1;
    *lcindx = (cblk / *npcol + 1) * desc[6] + 1;

    if ((*myrow + *nprow - desc[7]) % *nprow >= rblk % *nprow) {
	if (*myrow == *rsrc) {
	    *lrindx += grcpy % desc[5];
	}
	*lrindx -= desc[5];
    }

    if ((*mycol + *npcol - desc[8]) % *npcol >= cblk % *npcol) {
	if (*mycol == *csrc) {
	    *lcindx += gccpy % desc[6];
	}
	*lcindx -= desc[6];
    }

    return 0;

/*     End of INFOG2L */

} /* infog2l_ */

