/* /home4/luszczek/mscratch/build/SCALAPACK/TOOLS/infog1l.f -- translated by f2c (version 20031025).
   You must link the resulting object file with libf2c:
	on Microsoft Windows system, link with libf2c.lib;
	on Linux or Unix systems, link with .../path/to/libf2c.a -lm
	or, if you install libf2c.a in a standard place, with -lf2c -lm
	-- in that order, at the end of the command line, as in
		cc *.o -lf2c -lm
	Source for libf2c is in /netlib/f2c/libf2c.zip, e.g.,

		http://www.netlib.org/f2c/libf2c.zip
*/

#include "f2c.h"

/* Subroutine */ int infog1l_(integer *gindx, integer *nb, integer *nprocs, 
	integer *myroc, integer *isrcproc, integer *lindx, integer *rocsrc)
{
    integer iblk, gcpy;


/*  -- ScaLAPACK tools routine (version 1.7) -- */
/*     University of Tennessee, Knoxville, Oak Ridge National Laboratory, */
/*     and University of California, Berkeley. */
/*     May 1, 1997 */

/*     .. Scalar Arguments .. */
/*     .. */

/*  Purpose */
/*  ======= */

/*  INFOG1L computes the starting local indexes LINDX corresponding to */
/*  the distributed submatrix starting globally at the entry pointed by */
/*  GINDX.  This routine returns the coordinates of the process in the */
/*  grid owning the submatrix entry of global index GINDX: ROCSRC. */
/*  INFOG1L is a 1-dimensional version of INFOG2L. */

/*  Arguments */
/*  ========= */

/*  GINDX     (global input) INTEGER */
/*            The global starting index of the submatrix. */

/*  NB        (global input) INTEGER */
/*            The block size. */

/*  NPROCS    (global input) INTEGER */
/*            The total number of processes over which the distributed */
/*            submatrix is distributed. */

/*  MYROC     (local input) INTEGER */
/*            The coordinate of the process calling this routine. */

/*  ISRCPROC  (global input) INTEGER */
/*            The coordinate of the process having the first entry of */
/*            the distributed submatrix. */

/*  LINDX     (local output) INTEGER */
/*            The local starting indexes of the distributed submatrix. */

/*  ROCSRC    (global output) INTEGER */
/*            The coordinate of the process that possesses the first */
/*            row and column of the submatrix. */

/*  ===================================================================== */

/*     .. Local Scalars .. */
/*     .. */
/*     .. Intrinsic Functions .. */
/*     .. */
/*     .. Executable Statements .. */

    gcpy = *gindx - 1;
    iblk = gcpy / *nb;
    *rocsrc = (iblk + *isrcproc) % *nprocs;

    *lindx = (iblk / *nprocs + 1) * *nb + 1;

    if ((*myroc + *nprocs - *isrcproc) % *nprocs >= iblk % *nprocs) {
	if (*myroc == *rocsrc) {
	    *lindx += gcpy % *nb;
	}
	*lindx -= *nb;
    }

    return 0;

/*     End of INFOG1L */

} /* infog1l_ */

