/* /home4/luszczek/mscratch/build/SCALAPACK/TOOLS/desc_convert.f -- translated by f2c (version 20031025).
   You must link the resulting object file with libf2c:
	on Microsoft Windows system, link with libf2c.lib;
	on Linux or Unix systems, link with .../path/to/libf2c.a -lm
	or, if you install libf2c.a in a standard place, with -lf2c -lm
	-- in that order, at the end of the command line, as in
		cc *.o -lf2c -lm
	Source for libf2c is in /netlib/f2c/libf2c.zip, e.g.,

		http://www.netlib.org/f2c/libf2c.zip
*/

#include "f2c.h"

/* Subroutine */ int desc_convert__(integer *desc_in__, integer *desc_out__, 
	integer *info)
{
    integer m, n, desc_type__, mb, nb, llda, csrc, rsrc, desc_type_in__, 
	    idum1, idum2, npcol, ictxt, nprow;
    extern /* Subroutine */ int blacs_gridinfo__(integer *, integer *, 
	    integer *, integer *, integer *);



/*     .. Array Arguments .. */
/*     .. */

/*  Purpose */
/*  ======= */

/*  Converts descriptors from one type to another if they are compatible. */

/*  Supports *ONLY* an output descriptor type of 1D_horizontal (type */
/*     number 501) or 1D_vertical (number 502). */
/*  Supports only one-dimensional 1xP input grids if descriptor_in is 2D. */

/*  Arguments */
/*  ========= */

/*  DESC_IN: (input) input descriptor */

/*  DESC_OUT: (output) output descriptor (required to be 1D_horizontal */
/*            in this release). */

/*  INFO: (output) return code */

/*  ===================================================================== */

/*     .. Parameters .. */
/*     .. */

/*     .. Local Scalars .. */

/*     .. External routines .. */
/*     EXTERNAL        BLACS_GRIDINFO */
/*     .. */
/*     .. Executable Statements .. */

    /* Parameter adjustments */
    --desc_out__;
    --desc_in__;

    /* Function Body */
    *info = 0;

    desc_type_in__ = desc_in__[1];

    if (desc_type_in__ == 1) {
	ictxt = desc_in__[2];
	rsrc = desc_in__[7];
	csrc = desc_in__[8];
	mb = desc_in__[5];
	nb = desc_in__[6];
	llda = desc_in__[9];
	m = desc_in__[3];
	n = desc_in__[4];
	blacs_gridinfo__(&ictxt, &nprow, &npcol, &idum1, &idum2);
    } else if (desc_type_in__ == 502) {
	ictxt = desc_in__[2];
	rsrc = desc_in__[5];
	csrc = 1;
	mb = desc_in__[4];
	nb = 1;
	llda = desc_in__[6];
	m = desc_in__[3];
	n = 1;
	nprow = 0;
	npcol = 1;
    } else if (desc_type_in__ == 501) {
	ictxt = desc_in__[2];
	rsrc = 1;
	csrc = desc_in__[5];
	mb = 1;
	nb = desc_in__[4];
	llda = desc_in__[6];
	m = 1;
	n = desc_in__[3];
	nprow = 1;
	npcol = 0;
    }


    desc_type__ = desc_out__[1];

    if (desc_type__ == 501) {
	if (nprow != 1) {
	    *info = -1;
	    return 0;
	}
	desc_out__[2] = ictxt;
	desc_out__[5] = csrc;
	desc_out__[4] = nb;
	desc_out__[6] = llda;
	desc_out__[3] = n;
    } else if (desc_type__ == 502) {
	if (npcol != 1) {
	    *info = -1;
	    return 0;
	}
	desc_out__[2] = ictxt;
	desc_out__[5] = rsrc;
	desc_out__[4] = mb;
	desc_out__[6] = llda;
	desc_out__[3] = m;
    }

    return 0;

/*     End of DESC_CONVERT */

} /* desc_convert__ */

