/* /home4/luszczek/mscratch/build/SCALAPACK/TESTING/LIN/pzqrt13.f -- translated by f2c (version 20031025).
   You must link the resulting object file with libf2c:
	on Microsoft Windows system, link with libf2c.lib;
	on Linux or Unix systems, link with .../path/to/libf2c.a -lm
	or, if you install libf2c.a in a standard place, with -lf2c -lm
	-- in that order, at the end of the command line, as in
		cc *.o -lf2c -lm
	Source for libf2c is in /netlib/f2c/libf2c.zip, e.g.,

		http://www.netlib.org/f2c/libf2c.zip
*/

#include "f2c.h"

/* Table of constant values */

static integer c__1 = 1;

/* Subroutine */ int pzqrt13_(integer *scale, integer *m, integer *n, 
	doublecomplex *a, integer *ia, integer *ja, integer *desca, 
	doublereal *norma, integer *iseed, doublereal *work)
{
    /* System generated locals */
    integer i__1, i__2;
    doublereal d__1, d__2;
    doublecomplex z__1, z__2;

    /* Builtin functions */
    double d_sign(doublereal *, doublereal *);

    /* Local variables */
    extern /* Subroutine */ int pzmatgen_(integer *, char *, char *, integer *
	    , integer *, integer *, integer *, doublecomplex *, integer *, 
	    integer *, integer *, integer *, integer *, integer *, integer *, 
	    integer *, integer *, integer *, integer *, integer *, ftnlen, 
	    ftnlen);
    integer i__, j, mp, nq, iia, jja;
    doublecomplex ajj;
    integer info;
    doublereal asum;
    integer iacol, npcol, iarow, mycol, ictxt, nprow, myrow, icoffa, iroffa;
    doublereal bignum;
    extern integer numroc_(integer *, integer *, integer *, integer *, 
	    integer *);
    extern /* Subroutine */ int blacs_gridinfo__(integer *, integer *, 
	    integer *, integer *, integer *);
    doublereal smlnum;
    extern /* Subroutine */ int infog2l_(integer *, integer *, integer *, 
	    integer *, integer *, integer *, integer *, integer *, integer *, 
	    integer *, integer *), pdlabad_(integer *, doublereal *, 
	    doublereal *);
    extern doublereal pdlamch_(integer *, char *, ftnlen), pzlange_(char *, 
	    integer *, integer *, doublecomplex *, integer *, integer *, 
	    integer *, doublereal *, ftnlen);
    extern /* Subroutine */ int pzlascl_(char *, doublereal *, doublereal *, 
	    integer *, integer *, doublecomplex *, integer *, integer *, 
	    integer *, integer *, ftnlen), pzelget_(char *, char *, 
	    doublecomplex *, doublecomplex *, integer *, integer *, integer *,
	     ftnlen, ftnlen), pdzasum_(integer *, doublereal *, doublecomplex 
	    *, integer *, integer *, integer *, integer *), pzelset_(
	    doublecomplex *, integer *, integer *, integer *, doublecomplex *)
	    ;


/*  -- ScaLAPACK routine (version 1.7) -- */
/*     University of Tennessee, Knoxville, Oak Ridge National Laboratory, */
/*     and University of California, Berkeley. */
/*     May 1, 1997 */

/*     .. Scalar Arguments .. */
/*     .. */
/*     .. Array Arguments .. */
/*     .. */

/*  Purpose */
/*  ======= */

/*  PZQRT13 generates a full-rank matrix that may be scaled to have */
/*  large or small norm. */

/*  Notes */
/*  ===== */

/*  Each global data object is described by an associated description */
/*  vector.  This vector stores the information required to establish */
/*  the mapping between an object element and its corresponding process */
/*  and memory location. */

/*  Let A be a generic term for any 2D block cyclicly distributed array. */
/*  Such a global array has an associated description vector DESCA. */
/*  In the following comments, the character _ should be read as */
/*  "of the global array". */

/*  NOTATION        STORED IN      EXPLANATION */
/*  --------------- -------------- -------------------------------------- */
/*  DTYPE_A(global) DESCA( DTYPE_ )The descriptor type.  In this case, */
/*                                 DTYPE_A = 1. */
/*  CTXT_A (global) DESCA( CTXT_ ) The BLACS context handle, indicating */
/*                                 the BLACS process grid A is distribu- */
/*                                 ted over. The context itself is glo- */
/*                                 bal, but the handle (the integer */
/*                                 value) may vary. */
/*  M_A    (global) DESCA( M_ )    The number of rows in the global */
/*                                 array A. */
/*  N_A    (global) DESCA( N_ )    The number of columns in the global */
/*                                 array A. */
/*  MB_A   (global) DESCA( MB_ )   The blocking factor used to distribute */
/*                                 the rows of the array. */
/*  NB_A   (global) DESCA( NB_ )   The blocking factor used to distribute */
/*                                 the columns of the array. */
/*  RSRC_A (global) DESCA( RSRC_ ) The process row over which the first */
/*                                 row of the array A is distributed. */
/*  CSRC_A (global) DESCA( CSRC_ ) The process column over which the */
/*                                 first column of the array A is */
/*                                 distributed. */
/*  LLD_A  (local)  DESCA( LLD_ )  The leading dimension of the local */
/*                                 array.  LLD_A >= MAX(1,LOCr(M_A)). */

/*  Let K be the number of rows or columns of a distributed matrix, */
/*  and assume that its process grid has dimension p x q. */
/*  LOCr( K ) denotes the number of elements of K that a process */
/*  would receive if K were distributed over the p processes of its */
/*  process column. */
/*  Similarly, LOCc( K ) denotes the number of elements of K that a */
/*  process would receive if K were distributed over the q processes of */
/*  its process row. */
/*  The values of LOCr() and LOCc() may be determined via a call to the */
/*  ScaLAPACK tool function, NUMROC: */
/*          LOCr( M ) = NUMROC( M, MB_A, MYROW, RSRC_A, NPROW ), */
/*          LOCc( N ) = NUMROC( N, NB_A, MYCOL, CSRC_A, NPCOL ). */
/*  An upper bound for these quantities may be computed by: */
/*          LOCr( M ) <= ceil( ceil(M/MB_A)/NPROW )*MB_A */
/*          LOCc( N ) <= ceil( ceil(N/NB_A)/NPCOL )*NB_A */

/*  Arguments */
/*  ========= */

/*  SCALE   (global input) INTEGER */
/*          SCALE = 1: normally scaled matrix */
/*          SCALE = 2: matrix scaled up */
/*          SCALE = 3: matrix scaled down */

/*  M       (global input) INTEGER */
/*          The number of rows to be operated on, i.e. the number of rows */
/*          of the distributed submatrix sub( A ). M >= 0. */

/*  N       (global input) INTEGER */
/*          The number of columns to be operated on, i.e. the number of */
/*          columns of the distributed submatrix sub( A ). N >= 0. */

/*  A       (local output) COMPLEX*16 pointer into the local memory */
/*          to an array of dimension (LLD_A,LOCc(JA+N-1)). This array */
/*          contains the local pieces of the distributed matrix sub( A ). */

/*  IA      (global input) INTEGER */
/*          The row index in the global array A indicating the first */
/*          row of sub( A ). */

/*  JA      (global input) INTEGER */
/*          The column index in the global array A indicating the */
/*          first column of sub( A ). */

/*  DESCA   (global and local input) INTEGER array of dimension DLEN_. */
/*          The array descriptor for the distributed matrix A. */

/*  NORMA   (global output) DOUBLE PRECISION */
/*          The one-norm of A. */

/*  ISEED   (global input/global output) INTEGER */
/*          Seed for random number generator. */

/*  WORK    (local workspace) DOUBLE PRECISION   array, dimension (LWORK) */
/*          LWORK >= Nq0, where */

/*          ICOFFA = MOD( JA-1, NB_A ), */
/*          IACOL = INDXG2P( JA, NB_A, MYCOL, CSRC_A, NPCOL ), and */
/*          Nq0 = NUMROC( N+ICOFFA, NB_A, MYCOL, IACOL, NPCOL ). */

/*          INDXG2P and NUMROC are ScaLAPACK tool functions; MYROW, */
/*          MYCOL, NPROW and NPCOL can be determined by calling the */
/*          subroutine BLACS_GRIDINFO. */

/*  ===================================================================== */

/*     .. Parameters .. */
/*     .. */
/*     .. Local Scalars .. */
/*     .. */
/*     .. External Functions .. */
/*     .. */
/*     .. External Subroutines .. */
/*     .. */
/*     .. Intrinsic Functions .. */
/*     .. */
/*     .. Executable Statements .. */

    /* Parameter adjustments */
    --work;
    --desca;
    --a;

    /* Function Body */
    ictxt = desca[2];
    blacs_gridinfo__(&ictxt, &nprow, &npcol, &myrow, &mycol);

    if (*m <= 0 || *n <= 0) {
	return 0;
    }

/*     generate the matrix */

    iroffa = (*ia - 1) % desca[5];
    icoffa = (*ja - 1) % desca[6];
    infog2l_(ia, ja, &desca[1], &nprow, &npcol, &myrow, &mycol, &iia, &jja, &
	    iarow, &iacol);
    i__1 = *m + iroffa;
    mp = numroc_(&i__1, &desca[5], &myrow, &iarow, &nprow);
    i__1 = *n + icoffa;
    nq = numroc_(&i__1, &desca[6], &mycol, &iacol, &npcol);
    if (myrow == iarow) {
	mp -= iroffa;
    }
    if (mycol == iacol) {
	nq -= icoffa;
    }

    i__1 = iia - 1;
    i__2 = jja - 1;
    pzmatgen_(&ictxt, "N", "N", &desca[3], &desca[4], &desca[5], &desca[6], &
	    a[1], &desca[9], &desca[7], &desca[8], iseed, &i__1, &mp, &i__2, &
	    nq, &myrow, &mycol, &nprow, &npcol, (ftnlen)1, (ftnlen)1);

    i__1 = *ja + *n - 1;
    for (j = *ja; j <= i__1; ++j) {
	i__ = *ia + j - *ja;
	if (i__ <= *ia + *m - 1) {
	    pdzasum_(m, &asum, &a[1], ia, &j, &desca[1], &c__1);
	    pzelget_("Column", " ", &ajj, &a[1], &i__, &j, &desca[1], (ftnlen)
		    6, (ftnlen)1);
	    d__2 = ajj.r;
	    d__1 = d_sign(&asum, &d__2);
	    z__2.r = d__1, z__2.i = 0.;
	    z__1.r = ajj.r + z__2.r, z__1.i = ajj.i + z__2.i;
	    ajj.r = z__1.r, ajj.i = z__1.i;
	    pzelset_(&a[1], &i__, &j, &desca[1], &ajj);
	}
/* L10: */
    }

/*     scaled versions */

    if (*scale != 1) {

	*norma = pzlange_("M", m, n, &a[1], ia, ja, &desca[1], &work[1], (
		ftnlen)1);
	smlnum = pdlamch_(&ictxt, "Safe minimum", (ftnlen)12);
	bignum = 1. / smlnum;
	pdlabad_(&ictxt, &smlnum, &bignum);
	smlnum /= pdlamch_(&ictxt, "Epsilon", (ftnlen)7);
	bignum = 1. / smlnum;

	if (*scale == 2) {

/*           matrix scaled up */

	    pzlascl_("General", norma, &bignum, m, n, &a[1], ia, ja, &desca[1]
		    , &info, (ftnlen)7);

	} else if (*scale == 3) {

/*           matrix scaled down */

	    pzlascl_("General", norma, &smlnum, m, n, &a[1], ia, ja, &desca[1]
		    , &info, (ftnlen)7);

	}

    }

    *norma = pzlange_("One-norm", m, n, &a[1], ia, ja, &desca[1], &work[1], (
	    ftnlen)8);

    return 0;

/*     End of PZQRT13 */

} /* pzqrt13_ */

