/* /home4/luszczek/mscratch/build/SCALAPACK/TESTING/LIN/psqrt16.f -- translated by f2c (version 20031025).
   You must link the resulting object file with libf2c:
	on Microsoft Windows system, link with libf2c.lib;
	on Linux or Unix systems, link with .../path/to/libf2c.a -lm
	or, if you install libf2c.a in a standard place, with -lf2c -lm
	-- in that order, at the end of the command line, as in
		cc *.o -lf2c -lm
	Source for libf2c is in /netlib/f2c/libf2c.zip, e.g.,

		http://www.netlib.org/f2c/libf2c.zip
*/

#include "f2c.h"

/* Table of constant values */

static real c_b8 = -1.f;
static real c_b9 = 1.f;
static integer c__1 = 1;
static integer c__2 = 2;
static integer c_n1 = -1;

/* Subroutine */ int psqrt16_(char *trans, integer *m, integer *n, integer *
	nrhs, real *a, integer *ia, integer *ja, integer *desca, real *x, 
	integer *ix, integer *jx, integer *descx, real *b, integer *ib, 
	integer *jb, integer *descb, real *rwork, real *resid, ftnlen 
	trans_len)
{
    /* System generated locals */
    integer i__1, i__2;
    real r__1, r__2;

    /* Local variables */
    integer j, n1, n2;
    real eps, temp[2];
    extern logical lsame_(char *, char *, ftnlen, ftnlen);
    integer idumm, npcol;
    real anorm, bnorm;
    integer mycol, ictxt;
    real xnorm;
    integer nprow, myrow;
    extern /* Subroutine */ int psgemm_(char *, char *, integer *, integer *, 
	    integer *, real *, real *, integer *, integer *, integer *, real *
	    , integer *, integer *, integer *, real *, real *, integer *, 
	    integer *, integer *, ftnlen, ftnlen), blacs_gridinfo__(integer *,
	     integer *, integer *, integer *, integer *), psasum_(integer *, 
	    real *, real *, integer *, integer *, integer *, integer *), 
	    sgamx2d_(integer *, char *, char *, integer *, integer *, real *, 
	    integer *, integer *, integer *, integer *, integer *, integer *, 
	    ftnlen, ftnlen);
    extern doublereal pslamch_(integer *, char *, ftnlen), pslange_(char *, 
	    integer *, integer *, real *, integer *, integer *, integer *, 
	    real *, ftnlen);


/*  -- ScaLAPACK routine (version 1.7) -- */
/*     University of Tennessee, Knoxville, Oak Ridge National Laboratory, */
/*     and University of California, Berkeley. */
/*     May 1, 1997 */

/*     .. Scalar Arguments .. */
/*     .. */
/*     .. Array Arguments .. */
/*     .. */

/*  Purpose */
/*  ======= */

/*  PSQRT16 computes the residual for a solution of a system of linear */
/*  equations  sub( A )*sub( X ) = B  or  sub( A' )*sub( X ) = B: */
/*     RESID = norm(B - sub( A )*sub( X ) ) / */
/*             ( max(m,n) * norm(sub( A ) ) * norm(sub( X ) ) * EPS ), */
/*  where EPS is the machine epsilon, sub( A ) denotes */
/*  A(IA:IA+N-1,JA,JA+N-1), and sub( X ) denotes */
/*  X(IX:IX+N-1, JX:JX+NRHS-1). */

/*  Notes */
/*  ===== */

/*  Each global data object is described by an associated description */
/*  vector.  This vector stores the information required to establish */
/*  the mapping between an object element and its corresponding process */
/*  and memory location. */

/*  Let A be a generic term for any 2D block cyclicly distributed array. */
/*  Such a global array has an associated description vector DESCA. */
/*  In the following comments, the character _ should be read as */
/*  "of the global array". */

/*  NOTATION        STORED IN      EXPLANATION */
/*  --------------- -------------- -------------------------------------- */
/*  DTYPE_A(global) DESCA( DTYPE_ )The descriptor type.  In this case, */
/*                                 DTYPE_A = 1. */
/*  CTXT_A (global) DESCA( CTXT_ ) The BLACS context handle, indicating */
/*                                 the BLACS process grid A is distribu- */
/*                                 ted over. The context itself is glo- */
/*                                 bal, but the handle (the integer */
/*                                 value) may vary. */
/*  M_A    (global) DESCA( M_ )    The number of rows in the global */
/*                                 array A. */
/*  N_A    (global) DESCA( N_ )    The number of columns in the global */
/*                                 array A. */
/*  MB_A   (global) DESCA( MB_ )   The blocking factor used to distribute */
/*                                 the rows of the array. */
/*  NB_A   (global) DESCA( NB_ )   The blocking factor used to distribute */
/*                                 the columns of the array. */
/*  RSRC_A (global) DESCA( RSRC_ ) The process row over which the first */
/*                                 row of the array A is distributed. */
/*  CSRC_A (global) DESCA( CSRC_ ) The process column over which the */
/*                                 first column of the array A is */
/*                                 distributed. */
/*  LLD_A  (local)  DESCA( LLD_ )  The leading dimension of the local */
/*                                 array.  LLD_A >= MAX(1,LOCr(M_A)). */

/*  Let K be the number of rows or columns of a distributed matrix, */
/*  and assume that its process grid has dimension p x q. */
/*  LOCr( K ) denotes the number of elements of K that a process */
/*  would receive if K were distributed over the p processes of its */
/*  process column. */
/*  Similarly, LOCc( K ) denotes the number of elements of K that a */
/*  process would receive if K were distributed over the q processes of */
/*  its process row. */
/*  The values of LOCr() and LOCc() may be determined via a call to the */
/*  ScaLAPACK tool function, NUMROC: */
/*          LOCr( M ) = NUMROC( M, MB_A, MYROW, RSRC_A, NPROW ), */
/*          LOCc( N ) = NUMROC( N, NB_A, MYCOL, CSRC_A, NPCOL ). */
/*  An upper bound for these quantities may be computed by: */
/*          LOCr( M ) <= ceil( ceil(M/MB_A)/NPROW )*MB_A */
/*          LOCc( N ) <= ceil( ceil(N/NB_A)/NPCOL )*NB_A */

/*  Arguments */
/*  ========= */

/*  TRANS   (global input) CHARACTER*1 */
/*          Specifies the form of the system of equations: */
/*          = 'N':  sub( A )*sub( X ) = sub( B ) */
/*          = 'T':  sub( A' )*sub( X )= sub( B ), where A' is the */
/*                  transpose of sub( A ). */
/*          = 'C':  sub( A' )*sub( X )= B, where A' is the transpose */
/*                  of sub( A ). */

/*  M       (global input) INTEGER */
/*          The number of rows to be operated on, i.e. the number of rows */
/*          of the distributed submatrix sub( A ). M >= 0. */

/*  N       (global input) INTEGER */
/*          The number of columns to be operated on, i.e. the number of */
/*          columns of the distributed submatrix sub( A ). N >= 0. */

/*  NRHS    (global input) INTEGER */
/*          The number of right hand sides, i.e., the number of columns */
/*          of the distributed submatrix sub( B ). NRHS >= 0. */

/*  A       (local input) REAL pointer into the local */
/*          memory to an array of dimension (LLD_A,LOCc(JA+N-1)). */
/*          The original M x N matrix A. */

/*  IA      (global input) INTEGER */
/*          The row index in the global array A indicating the first */
/*          row of sub( A ). */

/*  JA      (global input) INTEGER */
/*          The column index in the global array A indicating the */
/*          first column of sub( A ). */

/*  DESCA   (global and local input) INTEGER array of dimension DLEN_. */
/*          The array descriptor for the distributed matrix A. */

/*  X       (local input) REAL pointer into the local */
/*          memory to an array of dimension (LLD_X,LOCc(JX+NRHS-1)). This */
/*          array contains the local pieces of the computed solution */
/*          distributed vectors for the system of linear equations. */

/*  IX      (global input) INTEGER */
/*          The row index in the global array X indicating the first */
/*          row of sub( X ). */

/*  JX      (global input) INTEGER */
/*          The column index in the global array X indicating the */
/*          first column of sub( X ). */

/*  DESCX   (global and local input) INTEGER array of dimension DLEN_. */
/*          The array descriptor for the distributed matrix X. */

/*  B       (local input/local output) REAL pointer into */
/*          the local memory to an array of dimension */
/*          (LLD_B,LOCc(JB+NRHS-1)).  On entry, this array contains the */
/*          local pieces of the distributes right hand side vectors for */
/*          the system of linear equations. On exit, sub( B ) is over- */
/*          written with the difference sub( B ) - sub( A )*sub( X ) or */
/*          sub( B ) - sub( A )'*sub( X ). */

/*  IB      (global input) INTEGER */
/*          The row index in the global array B indicating the first */
/*          row of sub( B ). */

/*  JB      (global input) INTEGER */
/*          The column index in the global array B indicating the */
/*          first column of sub( B ). */

/*  DESCB   (global and local input) INTEGER array of dimension DLEN_. */
/*          The array descriptor for the distributed matrix B. */

/*  RWORK   (local workspace) REAL array, dimension (LRWORK) */
/*          LWORK >= Nq0 if TRANS = 'N', and LRWORK >= Mp0 otherwise. */

/*          where */

/*          IROFFA = MOD( IA-1, MB_A ), ICOFFA = MOD( JA-1, NB_A ), */
/*          IAROW = INDXG2P( IA, MB_A, MYROW, RSRC_A, NPROW ), */
/*          IACOL = INDXG2P( JA, NB_A, MYCOL, CSRC_A, NPCOL ), */
/*          Mp0 = NUMROC( M+IROFFA, MB_A, MYROW, IAROW, NPROW ), */
/*          Nq0 = NUMROC( N+ICOFFA, NB_A, MYCOL, IACOL, NPCOL ), */

/*          INDXG2P and NUMROC are ScaLAPACK tool functions; MYROW, */
/*          MYCOL, NPROW and NPCOL can be determined by calling the */
/*          subroutine BLACS_GRIDINFO. */

/*  RESID   (global output) REAL */
/*          The maximum over the number of right hand sides of */
/*          norm( sub( B )- sub( A )*sub( X ) ) / */
/*          ( max(m,n) * norm( sub( A ) ) * norm( sub( X ) ) * EPS ). */

/*  ===================================================================== */

/*     .. Parameters .. */
/*     .. */
/*     .. Local Scalars .. */
/*     .. */
/*     .. Local Arrays .. */
/*     .. */
/*     .. External Functions .. */
/*     .. */
/*     .. External Subroutines .. */
/*     .. */
/*     .. Intrinsic Functions .. */
/*     .. */
/*     .. Executable Statements .. */

/*     Get grid parameters */

    /* Parameter adjustments */
    --rwork;
    --descb;
    --b;
    --descx;
    --x;
    --desca;
    --a;

    /* Function Body */
    ictxt = desca[2];
    blacs_gridinfo__(&ictxt, &nprow, &npcol, &myrow, &mycol);

/*     Quick exit if M = 0 or N = 0 or NRHS = 0 */

    if (*m <= 0 || *n <= 0 || *nrhs == 0) {
	*resid = 0.f;
	return 0;
    }

    if (lsame_(trans, "T", (ftnlen)1, (ftnlen)1) || lsame_(trans, "C", (
	    ftnlen)1, (ftnlen)1)) {
	anorm = pslange_("I", m, n, &a[1], ia, ja, &desca[1], &rwork[1], (
		ftnlen)1);
	n1 = *n;
	n2 = *m;
    } else {
	anorm = pslange_("1", m, n, &a[1], ia, ja, &desca[1], &rwork[1], (
		ftnlen)1);
	n1 = *m;
	n2 = *n;
    }

    eps = pslamch_(&ictxt, "Epsilon", (ftnlen)7);

/*     Compute  B - sub( A )*sub( X )  (or  B - sub( A' )*sub( X ) ) and */
/*     store in B. */

    psgemm_(trans, "No transpose", &n1, nrhs, &n2, &c_b8, &a[1], ia, ja, &
	    desca[1], &x[1], ix, jx, &descx[1], &c_b9, &b[1], ib, jb, &descb[
	    1], (ftnlen)1, (ftnlen)12);

/*     Compute the maximum over the number of right hand sides of */
/*        norm( sub( B ) - sub( A )*sub( X ) ) / */
/*        ( max(m,n) * norm( sub( A ) ) * norm( sub( X ) ) * EPS ). */

    *resid = 0.f;
    i__1 = *nrhs;
    for (j = 1; j <= i__1; ++j) {

	i__2 = *jb + j - 1;
	psasum_(&n1, &bnorm, &b[1], ib, &i__2, &descb[1], &c__1);
	i__2 = *jx + j - 1;
	psasum_(&n2, &xnorm, &x[1], ix, &i__2, &descx[1], &c__1);

/*        Only the process columns owning the vector operands will have */
/*        the correct result, the other will have zero. */

	temp[0] = bnorm;
	temp[1] = xnorm;
	sgamx2d_(&ictxt, "All", " ", &c__2, &c__1, temp, &c__2, &idumm, &
		idumm, &c_n1, &c_n1, &idumm, (ftnlen)3, (ftnlen)1);
	bnorm = temp[0];
	xnorm = temp[1];

/*        Every processes have ANORM, BNORM and XNORM now. */

	if (anorm == 0.f && bnorm == 0.f) {
	    *resid = 0.f;
	} else if (anorm <= 0.f || xnorm <= 0.f) {
	    *resid = 1.f / eps;
	} else {
/* Computing MAX */
	    r__1 = *resid, r__2 = bnorm / anorm / xnorm / (max(*m,*n) * eps);
	    *resid = dmax(r__1,r__2);
	}

/* L10: */
    }

    return 0;

/*     End of PSQRT16 */

} /* psqrt16_ */

