/* /home4/luszczek/mscratch/build/SCALAPACK/TESTING/EIG/pmatgeninc.f -- translated by f2c (version 20031025).
   You must link the resulting object file with libf2c:
	on Microsoft Windows system, link with libf2c.lib;
	on Linux or Unix systems, link with .../path/to/libf2c.a -lm
	or, if you install libf2c.a in a standard place, with -lf2c -lm
	-- in that order, at the end of the command line, as in
		cc *.o -lf2c -lm
	Source for libf2c is in /netlib/f2c/libf2c.zip, e.g.,

		http://www.netlib.org/f2c/libf2c.zip
*/

#include "f2c.h"

/* Common Block Declarations */

struct {
    integer irand[2], ias[2], ics[2];
} rancom_;

#define rancom_1 rancom_

/*  ===================================================================== */
/*     SUBROUTINE LADD */
/*  ===================================================================== */

/* Subroutine */ int ladd_(integer *j, integer *k, integer *i__)
{

/*  -- ScaLAPACK routine (version 1.7) -- */
/*     University of Tennessee, Knoxville, Oak Ridge National Laboratory, */
/*     and University of California, Berkeley. */
/*     May 1, 1997 */

/*     .. Array Arguments .. */
/*     .. */

/*  ===================================================================== */

/*     .. Parameters .. */
/*     .. */
/*     .. Intrinsic Functions .. */
/*     .. */
/*     .. Executable Statements .. */

    /* Parameter adjustments */
    --i__;
    --k;
    --j;

    /* Function Body */
    i__[1] = (k[1] + j[1]) % 65536;
    i__[2] = ((k[1] + j[1]) / 65536 + k[2] + j[2]) % 32768;

    return 0;

/*     End of LADD */

} /* ladd_ */


/*  ===================================================================== */
/*     SUBROUTINE LMUL */
/*  ===================================================================== */

/* Subroutine */ int lmul_(integer *k, integer *j, integer *i__)
{
    integer kt, lt;


/*  -- ScaLAPACK routine (version 1.7) -- */
/*     University of Tennessee, Knoxville, Oak Ridge National Laboratory, */
/*     and University of California, Berkeley. */
/*     May 1, 1997 */

/*     .. Array Arguments .. */
/*     .. */

/*  ===================================================================== */

/*     .. Parameters .. */
/*     .. */
/*     .. Local Scalars .. */
/*     .. */
/*     .. Intrinsic Functions .. */
/*     .. */
/*     .. Executable Statements .. */

    /* Parameter adjustments */
    --i__;
    --j;
    --k;

    /* Function Body */
    kt = k[1] * j[1];
    if (kt < 0) {
	kt += -2147483648;
    }
    i__[1] = kt % 65536;
    lt = k[1] * j[2] + k[2] * j[1];
    if (lt < 0) {
	lt += -2147483648;
    }
    kt = kt / 65536 + lt;
    if (kt < 0) {
	kt += -2147483648;
    }
    i__[2] = kt % 32768;

    return 0;

/*     End of LMUL */

} /* lmul_ */


/*  ===================================================================== */
/*     SUBROUTINE XJUMPM */
/*  ===================================================================== */

/* Subroutine */ int xjumpm_(integer *jumpm, integer *mult, integer *iadd, 
	integer *irann, integer *iranm, integer *iam, integer *icm)
{
    /* System generated locals */
    integer i__1;

    /* Local variables */
    integer i__, j[2];
    extern /* Subroutine */ int ladd_(integer *, integer *, integer *), lmul_(
	    integer *, integer *, integer *);


/*  -- ScaLAPACK routine (version 1.7) -- */
/*     University of Tennessee, Knoxville, Oak Ridge National Laboratory, */
/*     and University of California, Berkeley. */
/*     May 1, 1997 */

/*     .. Scalar Arguments .. */
/*     .. */
/*     .. Array Arguments .. */
/*     .. */

/*  ===================================================================== */

/*     .. Local Scalars .. */
/*     .. */
/*     .. Local Arrays .. */
/*     .. */
/*     .. External Subroutines .. */
/*     .. */
/*     .. Executable Statements .. */

    /* Parameter adjustments */
    --icm;
    --iam;
    --iranm;
    --irann;
    --iadd;
    --mult;

    /* Function Body */
    if (*jumpm > 0) {
	for (i__ = 1; i__ <= 2; ++i__) {
	    iam[i__] = mult[i__];
	    icm[i__] = iadd[i__];
/* L10: */
	}
	i__1 = *jumpm - 1;
	for (i__ = 1; i__ <= i__1; ++i__) {
	    lmul_(&iam[1], &mult[1], j);
	    iam[1] = j[0];
	    iam[2] = j[1];
	    lmul_(&icm[1], &mult[1], j);
	    ladd_(&iadd[1], j, &icm[1]);
/* L20: */
	}
	lmul_(&irann[1], &iam[1], j);
	ladd_(j, &icm[1], &iranm[1]);
    } else {
	iranm[1] = irann[1];
	iranm[2] = irann[2];
    }

    return 0;

/*     End of XJUMPM */

} /* xjumpm_ */


/*  ===================================================================== */
/*     SUBROUTINE SETRAN */
/*  ===================================================================== */

/* Subroutine */ int setran_(integer *iran, integer *ia, integer *ic)
{
    integer i__;


/*  -- ScaLAPACK routine (version 1.7) -- */
/*     University of Tennessee, Knoxville, Oak Ridge National Laboratory, */
/*     and University of California, Berkeley. */
/*     May 1, 1997 */

/*     .. Array Arguments .. */
/*     .. */

/*  ===================================================================== */

/*     .. Local Scalars .. */
/*     .. */
/*     .. Local Arrays .. */
/*     .. */
/*     .. Common Blocks .. */
/*     .. */
/*     .. Executable Statements .. */

    /* Parameter adjustments */
    --ic;
    --ia;
    --iran;

    /* Function Body */
    for (i__ = 1; i__ <= 2; ++i__) {
	rancom_1.irand[i__ - 1] = iran[i__];
	rancom_1.ias[i__ - 1] = ia[i__];
	rancom_1.ics[i__ - 1] = ic[i__];
/* L10: */
    }

    return 0;

/*     End of SETRAN */

} /* setran_ */


/*  ===================================================================== */
/*     SUBROUTINE JUMPIT */
/*  ===================================================================== */

/* Subroutine */ int jumpit_(integer *mult, integer *iadd, integer *irann, 
	integer *iranm)
{
    integer j[2];
    extern /* Subroutine */ int ladd_(integer *, integer *, integer *), lmul_(
	    integer *, integer *, integer *);


/*  -- ScaLAPACK routine (version 1.7) -- */
/*     University of Tennessee, Knoxville, Oak Ridge National Laboratory, */
/*     and University of California, Berkeley. */
/*     May 1, 1997 */

/*     .. Array Arguments .. */
/*     .. */

/*  ===================================================================== */

/*     .. Local Arrays .. */
/*     .. */
/*     .. External Subroutines .. */
/*     .. */
/*     .. Common Blocks .. */
/*     .. */
/*     .. Executable Statements .. */

    /* Parameter adjustments */
    --iranm;
    --irann;
    --iadd;
    --mult;

    /* Function Body */
    lmul_(&irann[1], &mult[1], j);
    ladd_(j, &iadd[1], &iranm[1]);

    rancom_1.irand[0] = iranm[1];
    rancom_1.irand[1] = iranm[2];

    return 0;

/*     End of JUMPIT */

} /* jumpit_ */


/*  ===================================================================== */
/*     REAL FUNCTION PSRAND */
/*  ===================================================================== */

real psrand_(integer *idumm)
{
    /* System generated locals */
    real ret_val;

    /* Local variables */
    integer j[2];
    extern /* Subroutine */ int ladd_(integer *, integer *, integer *), lmul_(
	    integer *, integer *, integer *);


/*  -- ScaLAPACK routine (version 1.7) -- */
/*     University of Tennessee, Knoxville, Oak Ridge National Laboratory, */
/*     and University of California, Berkeley. */
/*     May 1, 1997 */

/*     .. Scalar Arguments .. */
/*     .. */

/*  ===================================================================== */

/*     .. Parameters .. */
/*     .. */
/*     .. Local Arrays .. */
/*     .. */
/*     .. External Subroutines .. */
/*     .. */
/*     .. Intrinsic Functions .. */
/*     .. */
/*     .. Common Blocks .. */
/*     .. */
/*     .. Executable Statements .. */

    ret_val = ((real) rancom_1.irand[0] + (real) rancom_1.irand[1] * 65536.f) 
	    / 2147483648.f;

    lmul_(rancom_1.irand, rancom_1.ias, j);
    ladd_(j, rancom_1.ics, rancom_1.irand);

    return ret_val;

/*     End of PSRAND */

} /* psrand_ */


/*  ===================================================================== */
/*     DOUBLE PRECISION FUNCTION PDRAND */
/*  ===================================================================== */

doublereal pdrand_(integer *idumm)
{
    /* System generated locals */
    doublereal ret_val;

    /* Local variables */
    integer j[2];
    extern /* Subroutine */ int ladd_(integer *, integer *, integer *), lmul_(
	    integer *, integer *, integer *);


/*  -- ScaLAPACK routine (version 1.7) -- */
/*     University of Tennessee, Knoxville, Oak Ridge National Laboratory, */
/*     and University of California, Berkeley. */
/*     May 1, 1997 */

/*     .. Scalar Arguments .. */
/*     .. */

/*  ===================================================================== */

/*     .. Parameters .. */
/*     .. */
/*     .. Local Arrays .. */
/*     .. */
/*     .. External Subroutines .. */
/*     .. */
/*     .. Intrinsic Functions .. */
/*     .. */
/*     .. Common Blocks .. */
/*     .. */
/*     .. Executable Statements .. */

    ret_val = ((doublereal) rancom_1.irand[0] + (doublereal) rancom_1.irand[1]
	     * 65536.) / 2147483648.;

    lmul_(rancom_1.irand, rancom_1.ias, j);
    ladd_(j, rancom_1.ics, rancom_1.irand);

    return ret_val;

/*     End of PDRAND */

} /* pdrand_ */

