/* /home4/luszczek/mscratch/build/SCALAPACK/SRC/zlahqr2.f -- translated by f2c (version 20031025).
   You must link the resulting object file with libf2c:
	on Microsoft Windows system, link with libf2c.lib;
	on Linux or Unix systems, link with .../path/to/libf2c.a -lm
	or, if you install libf2c.a in a standard place, with -lf2c -lm
	-- in that order, at the end of the command line, as in
		cc *.o -lf2c -lm
	Source for libf2c is in /netlib/f2c/libf2c.zip, e.g.,

		http://www.netlib.org/f2c/libf2c.zip
*/

#include "f2c.h"

/* Table of constant values */

static integer c__1 = 1;

/* Subroutine */ int zlahqr2_(logical *wantt, logical *wantz, integer *n, 
	integer *ilo, integer *ihi, doublecomplex *h__, integer *ldh, 
	doublecomplex *w, integer *iloz, integer *ihiz, doublecomplex *z__, 
	integer *ldz, integer *info)
{
    /* System generated locals */
    integer h_dim1, h_offset, z_dim1, z_offset, i__1, i__2, i__3, i__4, i__5, 
	    i__6;
    doublereal d__1, d__2, d__3, d__4, d__5, d__6, d__7, d__8;
    doublecomplex z__1, z__2, z__3, z__4, z__5, z__6, z__7, z__8;

    /* Builtin functions */
    double d_imag(doublecomplex *);
    void z_div(doublecomplex *, doublecomplex *, doublecomplex *);
    double z_abs(doublecomplex *);
    void d_cnjg(doublecomplex *, doublecomplex *);

    /* Local variables */
    integer i__, j, k, l, m;
    doublereal s;
    doublecomplex v[3];
    integer i1, i2;
    doublecomplex t1, t2, t3, v1, v2, v3, h00, h10, h11, h12, h21, h22, h33, 
	    h44;
    integer nh;
    doublereal cs;
    integer nr;
    doublecomplex sn;
    integer nz;
    doublecomplex h33s, h44s;
    integer itn, its;
    doublereal ulp;
    doublecomplex sum;
    doublereal tst1;
    doublecomplex h43h34;
    doublereal unfl, ovfl;
    extern /* Subroutine */ int zrot_(integer *, doublecomplex *, integer *, 
	    doublecomplex *, integer *, doublereal *, doublecomplex *);
    doublereal rwork[1];
    extern /* Subroutine */ int lfc_SLzcopy(integer *, doublecomplex *, integer *, 
	    doublecomplex *, integer *), dlabad_(doublereal *, doublereal *), 
	    zlanv2_(doublecomplex *, doublecomplex *, doublecomplex *, 
	    doublecomplex *, doublecomplex *, doublecomplex *, doublereal *, 
	    doublecomplex *);
    extern doublereal dlamch_(char *, ftnlen);
    extern /* Subroutine */ int zlarfg_(integer *, doublecomplex *, 
	    doublecomplex *, integer *, doublecomplex *);
    extern doublereal zlanhs_(char *, integer *, doublecomplex *, integer *, 
	    doublereal *, ftnlen);
    doublereal smlnum;


/*  -- ScaLAPACK routine (version 1.7) -- */
/*     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd., */
/*     Courant Institute, Argonne National Lab, and Rice University */
/*     June 22, 2000 */

/*     .. Scalar Arguments .. */
/*     .. */
/*     .. Array Arguments .. */
/*     .. */

/*  Purpose */
/*  ======= */

/*  ZLAHQR2 is an auxiliary routine called by ZHSEQR to update the */
/*    eigenvalues and Schur decomposition already computed by ZHSEQR, by */
/*    dealing with the Hessenberg submatrix in rows and columns ILO to IHI. */
/*  This version of ZLAHQR (not the standard LAPACK version) uses a */
/*    double-shift algorithm (like LAPACK's DLAHQR). */
/*  Unlike the standard LAPACK convention, this does not assume the */
/*    subdiagonal is real, nor does it work to preserve this quality if */
/*    given. */

/*  Arguments */
/*  ========= */

/*  WANTT   (input) LOGICAL */
/*          = .TRUE. : the full Schur form T is required; */
/*          = .FALSE.: only eigenvalues are required. */

/*  WANTZ   (input) LOGICAL */
/*          = .TRUE. : the matrix of Schur vectors Z is required; */
/*          = .FALSE.: Schur vectors are not required. */

/*  N       (input) INTEGER */
/*          The order of the matrix H.  N >= 0. */

/*  ILO     (input) INTEGER */
/*  IHI     (input) INTEGER */
/*          It is assumed that H is already upper triangular in rows and */
/*          columns IHI+1:N, and that H(ILO,ILO-1) = 0 (unless ILO = 1). */
/*          ZLAHQR works primarily with the Hessenberg submatrix in rows */
/*          and columns ILO to IHI, but applies transformations to all of */
/*          H if WANTT is .TRUE.. */
/*          1 <= ILO <= max(1,IHI); IHI <= N. */

/*  H       (input/output) COMPLEX*16 array, dimension (LDH,N) */
/*          On entry, the upper Hessenberg matrix H. */
/*          On exit, if WANTT is .TRUE., H is upper triangular in rows */
/*          and columns ILO:IHI.  If WANTT is .FALSE., the contents of H */
/*          are unspecified on exit. */

/*  LDH     (input) INTEGER */
/*          The leading dimension of the array H. LDH >= max(1,N). */

/*  W       (output) COMPLEX*16 array, dimension (N) */
/*          The computed eigenvalues ILO to IHI are stored in the */
/*          corresponding elements of W. If WANTT is .TRUE., the */
/*          eigenvalues are stored in the same order as on the diagonal */
/*          of the Schur form returned in H, with W(i) = H(i,i). */

/*  ILOZ    (input) INTEGER */
/*  IHIZ    (input) INTEGER */
/*          Specify the rows of Z to which transformations must be */
/*          applied if WANTZ is .TRUE.. */
/*          1 <= ILOZ <= ILO; IHI <= IHIZ <= N. */

/*  Z       (input/output) COMPLEX*16 array, dimension (LDZ,N) */
/*          If WANTZ is .TRUE., on entry Z must contain the current */
/*          matrix Z of transformations, and on exit Z has been updated; */
/*          transformations are applied only to the submatrix */
/*          Z(ILOZ:IHIZ,ILO:IHI).  If WANTZ is .FALSE., Z is not */
/*          referenced. */

/*  LDZ     (input) INTEGER */
/*          The leading dimension of the array Z. LDZ >= max(1,N). */

/*  INFO    (output) INTEGER */
/*          = 0: successful exit */
/*          > 0: if INFO = i, ZLAHQR failed to compute all the */
/*               eigenvalues ILO to IHI in a total of 30*(IHI-ILO+1) */
/*               iterations; elements i+1:ihi of W contain those */
/*               eigenvalues which have been successfully computed. */

/*  Further Details */
/*  =============== */

/*  Modified by Mark R. Fahey, June, 2000 */

/*  ===================================================================== */

/*     .. Parameters .. */
/*     .. */
/*     .. Local Scalars .. */
/*     .. */
/*     .. Local Arrays .. */
/*     .. */
/*     .. External Functions .. */
/*     .. */
/*     .. External Subroutines .. */
/*     .. */
/*     .. Intrinsic Functions .. */
/*     .. */
/*     .. Statement Functions .. */
/*     .. */
/*     .. Statement Function definitions .. */
/*     .. */
/*     .. Executable Statements .. */

    /* Parameter adjustments */
    h_dim1 = *ldh;
    h_offset = 1 + h_dim1;
    h__ -= h_offset;
    --w;
    z_dim1 = *ldz;
    z_offset = 1 + z_dim1;
    z__ -= z_offset;

    /* Function Body */
    *info = 0;

/*     Quick return if possible */

    if (*n == 0) {
	return 0;
    }
    if (*ilo == *ihi) {
	i__1 = *ilo;
	i__2 = *ilo + *ilo * h_dim1;
	w[i__1].r = h__[i__2].r, w[i__1].i = h__[i__2].i;
	return 0;
    }

    nh = *ihi - *ilo + 1;
    nz = *ihiz - *iloz + 1;

/*     Set machine-dependent constants for the stopping criterion. */
/*     If norm(H) <= sqrt(OVFL), overflow should not occur. */

    unfl = dlamch_("Safe minimum", (ftnlen)12);
    ovfl = 1. / unfl;
    dlabad_(&unfl, &ovfl);
    ulp = dlamch_("Precision", (ftnlen)9);
    smlnum = unfl * (nh / ulp);

/*     I1 and I2 are the indices of the first row and last column of H */
/*     to which transformations must be applied. If eigenvalues only are */
/*     being computed, I1 and I2 are set inside the main loop. */

    if (*wantt) {
	i1 = 1;
	i2 = *n;
    }

/*     ITN is the total number of QR iterations allowed. */

    itn = nh * 30;

/*     The main loop begins here. I is the loop index and decreases from */
/*     IHI to ILO in steps of 1 or 2. Each iteration of the loop works */
/*     with the active submatrix in rows and columns L to I. */
/*     Eigenvalues I+1 to IHI have already converged. Either L = ILO, or */
/*     H(L,L-1) is negligible so that the matrix splits. */

    i__ = *ihi;
L10:
    l = *ilo;
    if (i__ < *ilo) {
	goto L150;
    }

/*     Perform QR iterations on rows and columns ILO to I until a */
/*     submatrix of order 1 or 2 splits off at the bottom because a */
/*     subdiagonal element has become negligible. */

    i__1 = itn;
    for (its = 0; its <= i__1; ++its) {

/*        Look for a single small subdiagonal element. */

	i__2 = l + 1;
	for (k = i__; k >= i__2; --k) {
	    i__3 = k - 1 + (k - 1) * h_dim1;
	    i__4 = k + k * h_dim1;
	    tst1 = (d__1 = h__[i__3].r, abs(d__1)) + (d__2 = d_imag(&h__[k - 
		    1 + (k - 1) * h_dim1]), abs(d__2)) + ((d__3 = h__[i__4].r,
		     abs(d__3)) + (d__4 = d_imag(&h__[k + k * h_dim1]), abs(
		    d__4)));
	    if (tst1 == 0.) {
		i__3 = i__ - l + 1;
		tst1 = zlanhs_("1", &i__3, &h__[l + l * h_dim1], ldh, rwork, (
			ftnlen)1);
	    }
	    i__3 = k + (k - 1) * h_dim1;
/* Computing MAX */
	    d__3 = ulp * tst1;
	    if ((d__1 = h__[i__3].r, abs(d__1)) + (d__2 = d_imag(&h__[k + (k 
		    - 1) * h_dim1]), abs(d__2)) <= max(d__3,smlnum)) {
		goto L30;
	    }
/* L20: */
	}
L30:
	l = k;
	if (l > *ilo) {

/*           H(L,L-1) is negligible */

	    i__2 = l + (l - 1) * h_dim1;
	    h__[i__2].r = 0., h__[i__2].i = 0.;
	}

/*        Exit from loop if a submatrix of order 1 or 2 has split off. */

	if (l >= i__ - 1) {
	    goto L140;
	}

/*        Now the active submatrix is in rows and columns L to I. If */
/*        eigenvalues only are being computed, only the active submatrix */
/*        need be transformed. */

	if (! (*wantt)) {
	    i1 = l;
	    i2 = i__;
	}

	if (its == 10 || its == 20) {

/*           Exceptional shift. */

/*            S = ABS( DBLE( H( I,I-1 ) ) ) + ABS( DBLE( H( I-1,I-2 ) ) ) */
	    i__2 = i__ + (i__ - 1) * h_dim1;
	    i__3 = i__ - 1 + (i__ - 2) * h_dim1;
	    s = (d__1 = h__[i__2].r, abs(d__1)) + (d__2 = d_imag(&h__[i__ + (
		    i__ - 1) * h_dim1]), abs(d__2)) + ((d__3 = h__[i__3].r, 
		    abs(d__3)) + (d__4 = d_imag(&h__[i__ - 1 + (i__ - 2) * 
		    h_dim1]), abs(d__4)));
	    d__1 = s * .75;
	    h44.r = d__1, h44.i = 0.;
	    h33.r = h44.r, h33.i = h44.i;
	    d__1 = s * -.4375 * s;
	    h43h34.r = d__1, h43h34.i = 0.;
	} else {

/*           Prepare to use Wilkinson's shift. */

	    i__2 = i__ + i__ * h_dim1;
	    h44.r = h__[i__2].r, h44.i = h__[i__2].i;
	    i__2 = i__ - 1 + (i__ - 1) * h_dim1;
	    h33.r = h__[i__2].r, h33.i = h__[i__2].i;
	    i__2 = i__ + (i__ - 1) * h_dim1;
	    i__3 = i__ - 1 + i__ * h_dim1;
	    z__1.r = h__[i__2].r * h__[i__3].r - h__[i__2].i * h__[i__3].i, 
		    z__1.i = h__[i__2].r * h__[i__3].i + h__[i__2].i * h__[
		    i__3].r;
	    h43h34.r = z__1.r, h43h34.i = z__1.i;
	}

/*        Look for two consecutive small subdiagonal elements. */

	i__2 = l;
	for (m = i__ - 2; m >= i__2; --m) {

/*           Determine the effect of starting the double-shift QR */
/*           iteration at row M, and see if this would make H(M,M-1) */
/*           negligible. */

	    i__3 = m + m * h_dim1;
	    h11.r = h__[i__3].r, h11.i = h__[i__3].i;
	    i__3 = m + 1 + (m + 1) * h_dim1;
	    h22.r = h__[i__3].r, h22.i = h__[i__3].i;
	    i__3 = m + 1 + m * h_dim1;
	    h21.r = h__[i__3].r, h21.i = h__[i__3].i;
	    i__3 = m + (m + 1) * h_dim1;
	    h12.r = h__[i__3].r, h12.i = h__[i__3].i;
	    z__1.r = h44.r - h11.r, z__1.i = h44.i - h11.i;
	    h44s.r = z__1.r, h44s.i = z__1.i;
	    z__1.r = h33.r - h11.r, z__1.i = h33.i - h11.i;
	    h33s.r = z__1.r, h33s.i = z__1.i;
	    z__4.r = h33s.r * h44s.r - h33s.i * h44s.i, z__4.i = h33s.r * 
		    h44s.i + h33s.i * h44s.r;
	    z__3.r = z__4.r - h43h34.r, z__3.i = z__4.i - h43h34.i;
	    z_div(&z__2, &z__3, &h21);
	    z__1.r = z__2.r + h12.r, z__1.i = z__2.i + h12.i;
	    v1.r = z__1.r, v1.i = z__1.i;
	    z__3.r = h22.r - h11.r, z__3.i = h22.i - h11.i;
	    z__2.r = z__3.r - h33s.r, z__2.i = z__3.i - h33s.i;
	    z__1.r = z__2.r - h44s.r, z__1.i = z__2.i - h44s.i;
	    v2.r = z__1.r, v2.i = z__1.i;
	    i__3 = m + 2 + (m + 1) * h_dim1;
	    v3.r = h__[i__3].r, v3.i = h__[i__3].i;
	    s = (d__1 = v1.r, abs(d__1)) + (d__2 = d_imag(&v1), abs(d__2)) + (
		    (d__3 = v2.r, abs(d__3)) + (d__4 = d_imag(&v2), abs(d__4))
		    ) + z_abs(&v3);
	    z__1.r = v1.r / s, z__1.i = v1.i / s;
	    v1.r = z__1.r, v1.i = z__1.i;
	    z__1.r = v2.r / s, z__1.i = v2.i / s;
	    v2.r = z__1.r, v2.i = z__1.i;
	    z__1.r = v3.r / s, z__1.i = v3.i / s;
	    v3.r = z__1.r, v3.i = z__1.i;
	    v[0].r = v1.r, v[0].i = v1.i;
	    v[1].r = v2.r, v[1].i = v2.i;
	    v[2].r = v3.r, v[2].i = v3.i;
	    if (m == l) {
		goto L50;
	    }
	    i__3 = m - 1 + (m - 1) * h_dim1;
	    h00.r = h__[i__3].r, h00.i = h__[i__3].i;
	    i__3 = m + (m - 1) * h_dim1;
	    h10.r = h__[i__3].r, h10.i = h__[i__3].i;
	    tst1 = ((d__1 = v1.r, abs(d__1)) + (d__2 = d_imag(&v1), abs(d__2))
		    ) * ((d__3 = h00.r, abs(d__3)) + (d__4 = d_imag(&h00), 
		    abs(d__4)) + ((d__5 = h11.r, abs(d__5)) + (d__6 = d_imag(&
		    h11), abs(d__6))) + ((d__7 = h22.r, abs(d__7)) + (d__8 = 
		    d_imag(&h22), abs(d__8))));
	    if (((d__1 = h10.r, abs(d__1)) + (d__2 = d_imag(&h10), abs(d__2)))
		     * ((d__3 = v2.r, abs(d__3)) + (d__4 = d_imag(&v2), abs(
		    d__4)) + ((d__5 = v3.r, abs(d__5)) + (d__6 = d_imag(&v3), 
		    abs(d__6)))) <= ulp * tst1) {
		goto L50;
	    }
/* L40: */
	}
L50:

/*        Double-shift QR step */

	i__2 = i__ - 1;
	for (k = m; k <= i__2; ++k) {

/*           The first iteration of this loop determines a reflection G */
/*           from the vector V and applies it from left and right to H, */
/*           thus creating a nonzero bulge below the subdiagonal. */

/*           Each subsequent iteration determines a reflection G to */
/*           restore the Hessenberg form in the (K-1)th column, and thus */
/*           chases the bulge one step toward the bottom of the active */
/*           submatrix.  NR is the order of G */

/* Computing MIN */
	    i__3 = 3, i__4 = i__ - k + 1;
	    nr = min(i__3,i__4);
	    if (k > m) {
		lfc_SLzcopy(&nr, &h__[k + (k - 1) * h_dim1], &c__1, v, &c__1);
	    }
	    zlarfg_(&nr, v, &v[1], &c__1, &t1);
	    if (k > m) {
		i__3 = k + (k - 1) * h_dim1;
		h__[i__3].r = v[0].r, h__[i__3].i = v[0].i;
		i__3 = k + 1 + (k - 1) * h_dim1;
		h__[i__3].r = 0., h__[i__3].i = 0.;
		if (k < i__ - 1) {
		    i__3 = k + 2 + (k - 1) * h_dim1;
		    h__[i__3].r = 0., h__[i__3].i = 0.;
		}
	    } else if (m > l) {
/*              The real double-shift code uses H( K, K-1 ) = -H( K, K-1 ) */
/*              instead of the following. */
		i__3 = k + (k - 1) * h_dim1;
		i__4 = k + (k - 1) * h_dim1;
		d_cnjg(&z__3, &t1);
		i__5 = k + (k - 1) * h_dim1;
		z__2.r = z__3.r * h__[i__5].r - z__3.i * h__[i__5].i, z__2.i =
			 z__3.r * h__[i__5].i + z__3.i * h__[i__5].r;
		z__1.r = h__[i__4].r - z__2.r, z__1.i = h__[i__4].i - z__2.i;
		h__[i__3].r = z__1.r, h__[i__3].i = z__1.i;
	    }
	    v2.r = v[1].r, v2.i = v[1].i;
	    z__1.r = t1.r * v2.r - t1.i * v2.i, z__1.i = t1.r * v2.i + t1.i * 
		    v2.r;
	    t2.r = z__1.r, t2.i = z__1.i;
	    if (nr == 3) {
		v3.r = v[2].r, v3.i = v[2].i;
		z__1.r = t1.r * v3.r - t1.i * v3.i, z__1.i = t1.r * v3.i + 
			t1.i * v3.r;
		t3.r = z__1.r, t3.i = z__1.i;

/*              Apply G from the left to transform the rows of the matrix */
/*              in columns K to I2. */

		i__3 = i2;
		for (j = k; j <= i__3; ++j) {
		    d_cnjg(&z__4, &t1);
		    i__4 = k + j * h_dim1;
		    z__3.r = z__4.r * h__[i__4].r - z__4.i * h__[i__4].i, 
			    z__3.i = z__4.r * h__[i__4].i + z__4.i * h__[i__4]
			    .r;
		    d_cnjg(&z__6, &t2);
		    i__5 = k + 1 + j * h_dim1;
		    z__5.r = z__6.r * h__[i__5].r - z__6.i * h__[i__5].i, 
			    z__5.i = z__6.r * h__[i__5].i + z__6.i * h__[i__5]
			    .r;
		    z__2.r = z__3.r + z__5.r, z__2.i = z__3.i + z__5.i;
		    d_cnjg(&z__8, &t3);
		    i__6 = k + 2 + j * h_dim1;
		    z__7.r = z__8.r * h__[i__6].r - z__8.i * h__[i__6].i, 
			    z__7.i = z__8.r * h__[i__6].i + z__8.i * h__[i__6]
			    .r;
		    z__1.r = z__2.r + z__7.r, z__1.i = z__2.i + z__7.i;
		    sum.r = z__1.r, sum.i = z__1.i;
		    i__4 = k + j * h_dim1;
		    i__5 = k + j * h_dim1;
		    z__1.r = h__[i__5].r - sum.r, z__1.i = h__[i__5].i - 
			    sum.i;
		    h__[i__4].r = z__1.r, h__[i__4].i = z__1.i;
		    i__4 = k + 1 + j * h_dim1;
		    i__5 = k + 1 + j * h_dim1;
		    z__2.r = sum.r * v2.r - sum.i * v2.i, z__2.i = sum.r * 
			    v2.i + sum.i * v2.r;
		    z__1.r = h__[i__5].r - z__2.r, z__1.i = h__[i__5].i - 
			    z__2.i;
		    h__[i__4].r = z__1.r, h__[i__4].i = z__1.i;
		    i__4 = k + 2 + j * h_dim1;
		    i__5 = k + 2 + j * h_dim1;
		    z__2.r = sum.r * v3.r - sum.i * v3.i, z__2.i = sum.r * 
			    v3.i + sum.i * v3.r;
		    z__1.r = h__[i__5].r - z__2.r, z__1.i = h__[i__5].i - 
			    z__2.i;
		    h__[i__4].r = z__1.r, h__[i__4].i = z__1.i;
/* L60: */
		}

/*              Apply G from the right to transform the columns of the */
/*              matrix in rows I1 to min(K+3,I). */

/* Computing MIN */
		i__4 = k + 3;
		i__3 = min(i__4,i__);
		for (j = i1; j <= i__3; ++j) {
		    i__4 = j + k * h_dim1;
		    z__3.r = t1.r * h__[i__4].r - t1.i * h__[i__4].i, z__3.i =
			     t1.r * h__[i__4].i + t1.i * h__[i__4].r;
		    i__5 = j + (k + 1) * h_dim1;
		    z__4.r = t2.r * h__[i__5].r - t2.i * h__[i__5].i, z__4.i =
			     t2.r * h__[i__5].i + t2.i * h__[i__5].r;
		    z__2.r = z__3.r + z__4.r, z__2.i = z__3.i + z__4.i;
		    i__6 = j + (k + 2) * h_dim1;
		    z__5.r = t3.r * h__[i__6].r - t3.i * h__[i__6].i, z__5.i =
			     t3.r * h__[i__6].i + t3.i * h__[i__6].r;
		    z__1.r = z__2.r + z__5.r, z__1.i = z__2.i + z__5.i;
		    sum.r = z__1.r, sum.i = z__1.i;
		    i__4 = j + k * h_dim1;
		    i__5 = j + k * h_dim1;
		    z__1.r = h__[i__5].r - sum.r, z__1.i = h__[i__5].i - 
			    sum.i;
		    h__[i__4].r = z__1.r, h__[i__4].i = z__1.i;
		    i__4 = j + (k + 1) * h_dim1;
		    i__5 = j + (k + 1) * h_dim1;
		    d_cnjg(&z__3, &v2);
		    z__2.r = sum.r * z__3.r - sum.i * z__3.i, z__2.i = sum.r *
			     z__3.i + sum.i * z__3.r;
		    z__1.r = h__[i__5].r - z__2.r, z__1.i = h__[i__5].i - 
			    z__2.i;
		    h__[i__4].r = z__1.r, h__[i__4].i = z__1.i;
		    i__4 = j + (k + 2) * h_dim1;
		    i__5 = j + (k + 2) * h_dim1;
		    d_cnjg(&z__3, &v3);
		    z__2.r = sum.r * z__3.r - sum.i * z__3.i, z__2.i = sum.r *
			     z__3.i + sum.i * z__3.r;
		    z__1.r = h__[i__5].r - z__2.r, z__1.i = h__[i__5].i - 
			    z__2.i;
		    h__[i__4].r = z__1.r, h__[i__4].i = z__1.i;
/* L70: */
		}

		if (*wantz) {

/*              Accumulate transformations in the matrix Z */

		    i__3 = *ihiz;
		    for (j = *iloz; j <= i__3; ++j) {
			i__4 = j + k * z_dim1;
			z__3.r = t1.r * z__[i__4].r - t1.i * z__[i__4].i, 
				z__3.i = t1.r * z__[i__4].i + t1.i * z__[i__4]
				.r;
			i__5 = j + (k + 1) * z_dim1;
			z__4.r = t2.r * z__[i__5].r - t2.i * z__[i__5].i, 
				z__4.i = t2.r * z__[i__5].i + t2.i * z__[i__5]
				.r;
			z__2.r = z__3.r + z__4.r, z__2.i = z__3.i + z__4.i;
			i__6 = j + (k + 2) * z_dim1;
			z__5.r = t3.r * z__[i__6].r - t3.i * z__[i__6].i, 
				z__5.i = t3.r * z__[i__6].i + t3.i * z__[i__6]
				.r;
			z__1.r = z__2.r + z__5.r, z__1.i = z__2.i + z__5.i;
			sum.r = z__1.r, sum.i = z__1.i;
			i__4 = j + k * z_dim1;
			i__5 = j + k * z_dim1;
			z__1.r = z__[i__5].r - sum.r, z__1.i = z__[i__5].i - 
				sum.i;
			z__[i__4].r = z__1.r, z__[i__4].i = z__1.i;
			i__4 = j + (k + 1) * z_dim1;
			i__5 = j + (k + 1) * z_dim1;
			d_cnjg(&z__3, &v2);
			z__2.r = sum.r * z__3.r - sum.i * z__3.i, z__2.i = 
				sum.r * z__3.i + sum.i * z__3.r;
			z__1.r = z__[i__5].r - z__2.r, z__1.i = z__[i__5].i - 
				z__2.i;
			z__[i__4].r = z__1.r, z__[i__4].i = z__1.i;
			i__4 = j + (k + 2) * z_dim1;
			i__5 = j + (k + 2) * z_dim1;
			d_cnjg(&z__3, &v3);
			z__2.r = sum.r * z__3.r - sum.i * z__3.i, z__2.i = 
				sum.r * z__3.i + sum.i * z__3.r;
			z__1.r = z__[i__5].r - z__2.r, z__1.i = z__[i__5].i - 
				z__2.i;
			z__[i__4].r = z__1.r, z__[i__4].i = z__1.i;
/* L80: */
		    }
		}
	    } else if (nr == 2) {

/*              Apply G from the left to transform the rows of the matrix */
/*              in columns K to I2. */

		i__3 = i2;
		for (j = k; j <= i__3; ++j) {
		    d_cnjg(&z__3, &t1);
		    i__4 = k + j * h_dim1;
		    z__2.r = z__3.r * h__[i__4].r - z__3.i * h__[i__4].i, 
			    z__2.i = z__3.r * h__[i__4].i + z__3.i * h__[i__4]
			    .r;
		    d_cnjg(&z__5, &t2);
		    i__5 = k + 1 + j * h_dim1;
		    z__4.r = z__5.r * h__[i__5].r - z__5.i * h__[i__5].i, 
			    z__4.i = z__5.r * h__[i__5].i + z__5.i * h__[i__5]
			    .r;
		    z__1.r = z__2.r + z__4.r, z__1.i = z__2.i + z__4.i;
		    sum.r = z__1.r, sum.i = z__1.i;
		    i__4 = k + j * h_dim1;
		    i__5 = k + j * h_dim1;
		    z__1.r = h__[i__5].r - sum.r, z__1.i = h__[i__5].i - 
			    sum.i;
		    h__[i__4].r = z__1.r, h__[i__4].i = z__1.i;
		    i__4 = k + 1 + j * h_dim1;
		    i__5 = k + 1 + j * h_dim1;
		    z__2.r = sum.r * v2.r - sum.i * v2.i, z__2.i = sum.r * 
			    v2.i + sum.i * v2.r;
		    z__1.r = h__[i__5].r - z__2.r, z__1.i = h__[i__5].i - 
			    z__2.i;
		    h__[i__4].r = z__1.r, h__[i__4].i = z__1.i;
/* L90: */
		}

/*              Apply G from the right to transform the columns of the */
/*              matrix in rows I1 to min(K+2,I). */

/* Computing MIN */
		i__4 = k + 2;
		i__3 = min(i__4,i__);
		for (j = i1; j <= i__3; ++j) {
		    i__4 = j + k * h_dim1;
		    z__2.r = t1.r * h__[i__4].r - t1.i * h__[i__4].i, z__2.i =
			     t1.r * h__[i__4].i + t1.i * h__[i__4].r;
		    i__5 = j + (k + 1) * h_dim1;
		    z__3.r = t2.r * h__[i__5].r - t2.i * h__[i__5].i, z__3.i =
			     t2.r * h__[i__5].i + t2.i * h__[i__5].r;
		    z__1.r = z__2.r + z__3.r, z__1.i = z__2.i + z__3.i;
		    sum.r = z__1.r, sum.i = z__1.i;
		    i__4 = j + k * h_dim1;
		    i__5 = j + k * h_dim1;
		    z__1.r = h__[i__5].r - sum.r, z__1.i = h__[i__5].i - 
			    sum.i;
		    h__[i__4].r = z__1.r, h__[i__4].i = z__1.i;
		    i__4 = j + (k + 1) * h_dim1;
		    i__5 = j + (k + 1) * h_dim1;
		    d_cnjg(&z__3, &v2);
		    z__2.r = sum.r * z__3.r - sum.i * z__3.i, z__2.i = sum.r *
			     z__3.i + sum.i * z__3.r;
		    z__1.r = h__[i__5].r - z__2.r, z__1.i = h__[i__5].i - 
			    z__2.i;
		    h__[i__4].r = z__1.r, h__[i__4].i = z__1.i;
/* L100: */
		}

		if (*wantz) {

/*                 Accumulate transformations in the matrix Z */

		    i__3 = *ihiz;
		    for (j = *iloz; j <= i__3; ++j) {
			i__4 = j + k * z_dim1;
			z__2.r = t1.r * z__[i__4].r - t1.i * z__[i__4].i, 
				z__2.i = t1.r * z__[i__4].i + t1.i * z__[i__4]
				.r;
			i__5 = j + (k + 1) * z_dim1;
			z__3.r = t2.r * z__[i__5].r - t2.i * z__[i__5].i, 
				z__3.i = t2.r * z__[i__5].i + t2.i * z__[i__5]
				.r;
			z__1.r = z__2.r + z__3.r, z__1.i = z__2.i + z__3.i;
			sum.r = z__1.r, sum.i = z__1.i;
			i__4 = j + k * z_dim1;
			i__5 = j + k * z_dim1;
			z__1.r = z__[i__5].r - sum.r, z__1.i = z__[i__5].i - 
				sum.i;
			z__[i__4].r = z__1.r, z__[i__4].i = z__1.i;
			i__4 = j + (k + 1) * z_dim1;
			i__5 = j + (k + 1) * z_dim1;
			d_cnjg(&z__3, &v2);
			z__2.r = sum.r * z__3.r - sum.i * z__3.i, z__2.i = 
				sum.r * z__3.i + sum.i * z__3.r;
			z__1.r = z__[i__5].r - z__2.r, z__1.i = z__[i__5].i - 
				z__2.i;
			z__[i__4].r = z__1.r, z__[i__4].i = z__1.i;
/* L110: */
		    }
		}
	    }

/*           Since at the start of the QR step we have for M > L */
/*              H( K, K-1 ) = H( K, K-1 ) - DCONJG( T1 )*H( K, K-1 ) */
/*           then we don't need to do the following */
/*           IF( K.EQ.M .AND. M.GT.L ) THEN */
/*              If the QR step was started at row M > L because two */
/*              consecutive small subdiagonals were found, then H(M,M-1) */
/*              must also be updated by a factor of (1-T1). */
/*              TEMP = ONE - T1 */
/*              H( m, m-1 ) = H( m, m-1 )*DCONJG( TEMP ) */
/*           END IF */
/* L120: */
	}

/*        Ensure that H(I,I-1) is real. */

/* L130: */
    }

/*     Failure to converge in remaining number of iterations */

    *info = i__;
    return 0;

L140:

    if (l == i__) {

/*        H(I,I-1) is negligible: one eigenvalue has converged. */

	i__1 = i__;
	i__2 = i__ + i__ * h_dim1;
	w[i__1].r = h__[i__2].r, w[i__1].i = h__[i__2].i;

    } else if (l == i__ - 1) {

/*        H(I-1,I-2) is negligible: a pair of eigenvalues have converged. */

/*        Transform the 2-by-2 submatrix to standard Schur form, */
/*        and compute and store the eigenvalues. */

	zlanv2_(&h__[i__ - 1 + (i__ - 1) * h_dim1], &h__[i__ - 1 + i__ * 
		h_dim1], &h__[i__ + (i__ - 1) * h_dim1], &h__[i__ + i__ * 
		h_dim1], &w[i__ - 1], &w[i__], &cs, &sn);

	if (*wantt) {

/*           Apply the transformation to the rest of H. */

	    if (i2 > i__) {
		i__1 = i2 - i__;
		zrot_(&i__1, &h__[i__ - 1 + (i__ + 1) * h_dim1], ldh, &h__[
			i__ + (i__ + 1) * h_dim1], ldh, &cs, &sn);
	    }
	    i__1 = i__ - i1 - 1;
	    d_cnjg(&z__1, &sn);
	    zrot_(&i__1, &h__[i1 + (i__ - 1) * h_dim1], &c__1, &h__[i1 + i__ *
		     h_dim1], &c__1, &cs, &z__1);
	}
	if (*wantz) {

/*           Apply the transformation to Z. */

	    d_cnjg(&z__1, &sn);
	    zrot_(&nz, &z__[*iloz + (i__ - 1) * z_dim1], &c__1, &z__[*iloz + 
		    i__ * z_dim1], &c__1, &cs, &z__1);
	}

    }

/*     Decrement number of remaining iterations, and return to start of */
/*     the main loop with new value of I. */

    itn -= its;
    i__ = l - 1;
    goto L10;

L150:
    return 0;

/*     End of ZLAHQR2 */

} /* zlahqr2_ */

