/* /home4/luszczek/mscratch/build/SCALAPACK/SRC/pzlattrs.f -- translated by f2c (version 20031025).
   You must link the resulting object file with libf2c:
	on Microsoft Windows system, link with libf2c.lib;
	on Linux or Unix systems, link with .../path/to/libf2c.a -lm
	or, if you install libf2c.a in a standard place, with -lf2c -lm
	-- in that order, at the end of the command line, as in
		cc *.o -lf2c -lm
	Source for libf2c is in /netlib/f2c/libf2c.zip, e.g.,

		http://www.netlib.org/f2c/libf2c.zip
*/

#include "f2c.h"

/* Table of constant values */

static doublecomplex c_b1 = {0.,0.};
static doublecomplex c_b2 = {1.,0.};
static integer c__1 = 1;
static integer c_n1 = -1;
static doublereal c_b92 = .5;

/* Subroutine */ int pzlattrs_(char *uplo, char *trans, char *diag, char *
	normin, integer *n, doublecomplex *a, integer *ia, integer *ja, 
	integer *desca, doublecomplex *x, integer *ix, integer *jx, integer *
	descx, doublereal *scale, doublereal *cnorm, integer *info, ftnlen 
	uplo_len, ftnlen trans_len, ftnlen diag_len, ftnlen normin_len)
{
    /* System generated locals */
    integer i__1, i__2, i__3, i__4, i__5, i__6;
    doublereal d__1, d__2, d__3, d__4;
    doublecomplex z__1, z__2;

    /* Builtin functions */
    double d_imag(doublecomplex *);
    void d_cnjg(doublecomplex *, doublecomplex *);

    /* Local variables */
    integer i__, j, mb, nb;
    doublereal xj;
    integer lda;
    doublereal rec;
    integer ldx;
    doublereal tjj;
    integer jinc, icol, csrc;
    doublereal xbnd;
    integer imax, rsrc;
    doublereal tmax;
    doublecomplex tjjs;
    doublereal xmax, grow;
    integer irow;
    doublecomplex zdum;
    integer itmp1, itmp2;
    extern /* Subroutine */ int lfc_SLdscal(integer *, doublereal *, doublereal *, 
	    integer *);
    extern logical lsame_(char *, char *, ftnlen, ftnlen);
    doublereal tscal;
    doublecomplex uscal;
    integer npcol, jlast, icolx, mycol;
    doublecomplex csumj;
    logical upper;
    doublecomplex xjtmp;
    integer nprow, irowx, myrow, itmp1x, itmp2x;
    extern integer lfc_SLidamax(integer *, doublereal *, integer *);
    doublereal bignum;
    extern /* Double Complex */ VOID zladiv_(doublecomplex *, doublecomplex *,
	     doublecomplex *);
    extern /* Subroutine */ int pzscal_(integer *, doublecomplex *, 
	    doublecomplex *, integer *, integer *, integer *, integer *), 
	    pzamax_(integer *, doublecomplex *, integer *, doublecomplex *, 
	    integer *, integer *, integer *, integer *);
    logical notran;
    integer jfirst;
    extern /* Subroutine */ int blacs_gridinfo__(integer *, integer *, 
	    integer *, integer *, integer *), pzdotc_(integer *, 
	    doublecomplex *, doublecomplex *, integer *, integer *, integer *,
	     integer *, doublecomplex *, integer *, integer *, integer *, 
	    integer *);
    doublereal smlnum;
    logical nounit;
    integer contxt;
    extern /* Subroutine */ int pzdotu_(integer *, doublecomplex *, 
	    doublecomplex *, integer *, integer *, integer *, integer *, 
	    doublecomplex *, integer *, integer *, integer *, integer *), 
	    pzaxpy_(integer *, doublecomplex *, doublecomplex *, integer *, 
	    integer *, integer *, integer *, doublecomplex *, integer *, 
	    integer *, integer *, integer *), zgebr2d_(integer *, char *, 
	    char *, integer *, integer *, doublecomplex *, integer *, integer 
	    *, integer *, ftnlen, ftnlen), infog2l_(integer *, integer *, 
	    integer *, integer *, integer *, integer *, integer *, integer *, 
	    integer *, integer *, integer *), zgebs2d_(integer *, char *, 
	    char *, integer *, integer *, doublecomplex *, integer *, ftnlen, 
	    ftnlen), dgsum2d_(integer *, char *, char *, integer *, integer *,
	     doublereal *, integer *, integer *, integer *, ftnlen, ftnlen), 
	    pztrsv_(char *, char *, char *, integer *, doublecomplex *, 
	    integer *, integer *, integer *, doublecomplex *, integer *, 
	    integer *, integer *, integer *, ftnlen, ftnlen, ftnlen), 
	    pdlabad_(integer *, doublereal *, doublereal *);
    extern doublereal pdlamch_(integer *, char *, ftnlen);
    extern /* Subroutine */ int pxerbla_(integer *, char *, integer *, ftnlen)
	    , pzdscal_(integer *, doublereal *, doublecomplex *, integer *, 
	    integer *, integer *, integer *), pzlaset_(char *, integer *, 
	    integer *, doublecomplex *, doublecomplex *, doublecomplex *, 
	    integer *, integer *, integer *, ftnlen), pdzasum_(integer *, 
	    doublereal *, doublecomplex *, integer *, integer *, integer *, 
	    integer *);


/*  -- ScaLAPACK routine (version 1.7) -- */
/*     University of Tennessee, Knoxville, Oak Ridge National Laboratory, */
/*     and University of California, Berkeley. */
/*     July 31, 2001 */

/*     .. Scalar Arguments .. */
/*     .. */
/*     .. Array Arguments .. */
/*     .. */

/*  Purpose */
/*  ======= */

/*  PZLATTRS solves one of the triangular systems */

/*     A * x = s*b,  A**T * x = s*b,  or  A**H * x = s*b, */

/*  with scaling to prevent overflow.  Here A is an upper or lower */
/*  triangular matrix, A**T denotes the transpose of A, A**H denotes the */
/*  conjugate transpose of A, x and b are n-element vectors, and s is a */
/*  scaling factor, usually less than or equal to 1, chosen so that the */
/*  components of x will be less than the overflow threshold.  If the */
/*  unscaled problem will not cause overflow, the Level 2 PBLAS routine */
/*  PZTRSV is called. If the matrix A is singular (A(j,j) = 0 for some j) */
/*  then s is set to 0 and a non-trivial solution to A*x = 0 is returned. */

/*  This is very slow relative to PZTRSV.  This should only be used */
/*  when scaling is necessary to control overflow, or when it is modified */
/*  to scale better. */
/*  Notes */

/*  ===== */

/*  Each global data object is described by an associated description */
/*  vector.  This vector stores the information required to establish */
/*  the mapping between an object element and its corresponding process */
/*  and memory location. */

/*  Let A be a generic term for any 2D block cyclicly distributed array. */
/*  Such a global array has an associated description vector DESCA. */
/*  In the following comments, the character _ should be read as */
/*  "of the global array". */

/*  NOTATION        STORED IN      EXPLANATION */
/*  --------------- -------------- -------------------------------------- */
/*  DTYPE_A(global) DESCA( DTYPE_ )The descriptor type.  In this case, */
/*                                 DTYPE_A = 1. */
/*  CTXT_A (global) DESCA( CTXT_ ) The BLACS context handle, indicating */
/*                                 the BLACS process grid A is distribu- */
/*                                 ted over. The context itself is glo- */
/*                                 bal, but the handle (the integer */
/*                                 value) may vary. */
/*  M_A    (global) DESCA( M_ )    The number of rows in the global */
/*                                 array A. */
/*  N_A    (global) DESCA( N_ )    The number of columns in the global */
/*                                 array A. */
/*  MB_A   (global) DESCA( MB_ )   The blocking factor used to distribute */
/*                                 the rows of the array. */
/*  NB_A   (global) DESCA( NB_ )   The blocking factor used to distribute */
/*                                 the columns of the array. */
/*  RSRC_A (global) DESCA( RSRC_ ) The process row over which the first */
/*                                 row of the array A is distributed. */
/*  CSRC_A (global) DESCA( CSRC_ ) The process column over which the */
/*                                 first column of the array A is */
/*                                 distributed. */
/*  LLD_A  (local)  DESCA( LLD_ )  The leading dimension of the local */
/*                                 array.  LLD_A >= MAX(1,LOCr(M_A)). */

/*  Let K be the number of rows or columns of a distributed matrix, */
/*  and assume that its process grid has dimension r x c. */
/*  LOCr( K ) denotes the number of elements of K that a process */
/*  would receive if K were distributed over the r processes of its */
/*  process column. */
/*  Similarly, LOCc( K ) denotes the number of elements of K that a */
/*  process would receive if K were distributed over the c processes of */
/*  its process row. */
/*  The values of LOCr() and LOCc() may be determined via a call to the */
/*  ScaLAPACK tool function, NUMROC: */
/*          LOCr( M ) = NUMROC( M, MB_A, MYROW, RSRC_A, NPROW ), */
/*          LOCc( N ) = NUMROC( N, NB_A, MYCOL, CSRC_A, NPCOL ). */
/*  An upper bound for these quantities may be computed by: */
/*          LOCr( M ) <= ceil( ceil(M/MB_A)/NPROW )*MB_A */
/*          LOCc( N ) <= ceil( ceil(N/NB_A)/NPCOL )*NB_A */

/*  Arguments */
/*  ========= */

/*  UPLO    (global input) CHARACTER*1 */
/*          Specifies whether the matrix A is upper or lower triangular. */
/*          = 'U':  Upper triangular */
/*          = 'L':  Lower triangular */

/*  TRANS   (global input) CHARACTER*1 */
/*          Specifies the operation applied to A. */
/*          = 'N':  Solve A * x = s*b     (No transpose) */
/*          = 'T':  Solve A**T * x = s*b  (Transpose) */
/*          = 'C':  Solve A**H * x = s*b  (Conjugate transpose) */

/*  DIAG    (global input) CHARACTER*1 */
/*          Specifies whether or not the matrix A is unit triangular. */
/*          = 'N':  Non-unit triangular */
/*          = 'U':  Unit triangular */

/*  NORMIN  (global input) CHARACTER*1 */
/*          Specifies whether CNORM has been set or not. */
/*          = 'Y':  CNORM contains the column norms on entry */
/*          = 'N':  CNORM is not set on entry.  On exit, the norms will */
/*                  be computed and stored in CNORM. */

/*  N       (global input) INTEGER */
/*          The order of the matrix A.  N >= 0. */

/*  A       (local input) COMPLEX*16 array, dimension (DESCA(LLD_),*) */
/*          The triangular matrix A.  If UPLO = 'U', the leading n by n */
/*          upper triangular part of the array A contains the upper */
/*          triangular matrix, and the strictly lower triangular part of */
/*          A is not referenced.  If UPLO = 'L', the leading n by n lower */
/*          triangular part of the array A contains the lower triangular */
/*          matrix, and the strictly upper triangular part of A is not */
/*          referenced.  If DIAG = 'U', the diagonal elements of A are */
/*          also not referenced and are assumed to be 1. */

/*  IA      (global input) pointer to INTEGER */
/*          The global row index of the submatrix of the distributed */
/*          matrix A to operate on. */

/*  JA      (global input) pointer to INTEGER */
/*          The global column index of the submatrix of the distributed */
/*          matrix A to operate on. */

/*  DESCA   (global and local input) INTEGER array of dimension DLEN_. */
/*          The array descriptor for the distributed matrix A. */

/*  X       (local input/output) COMPLEX*16 array, */
/*                                             dimension (DESCX(LLD_),*) */
/*          On entry, the right hand side b of the triangular system. */
/*          On exit, X is overwritten by the solution vector x. */

/*  IX      (global input) pointer to INTEGER */
/*          The global row index of the submatrix of the distributed */
/*          matrix X to operate on. */

/*  JX      (global input) pointer to INTEGER */
/*          The global column index of the submatrix of the distributed */
/*          matrix X to operate on. */

/*  DESCX   (global and local input) INTEGER array of dimension DLEN_. */
/*          The array descriptor for the distributed matrix X. */

/*  SCALE   (global output) DOUBLE PRECISION */
/*          The scaling factor s for the triangular system */
/*             A * x = s*b,  A**T * x = s*b,  or  A**H * x = s*b. */
/*          If SCALE = 0, the matrix A is singular or badly scaled, and */
/*          the vector x is an exact or approximate solution to A*x = 0. */

/*  CNORM   (global input or global output) DOUBLE PRECISION array, */
/*                                                       dimension (N) */
/*          If NORMIN = 'Y', CNORM is an input argument and CNORM(j) */
/*          contains the norm of the off-diagonal part of the j-th column */
/*          of A.  If TRANS = 'N', CNORM(j) must be greater than or equal */
/*          to the infinity-norm, and if TRANS = 'T' or 'C', CNORM(j) */
/*          must be greater than or equal to the 1-norm. */

/*          If NORMIN = 'N', CNORM is an output argument and CNORM(j) */
/*          returns the 1-norm of the offdiagonal part of the j-th column */
/*          of A. */

/*  INFO    (global output) INTEGER */
/*          = 0:  successful exit */
/*          < 0:  if INFO = -k, the k-th argument had an illegal value */

/*  Further Details */
/*  ======= ======= */

/*  A rough bound on x is computed; if that is less than overflow, PZTRSV */
/*  is called, otherwise, specific code is used which checks for possible */
/*  overflow or divide-by-zero at every operation. */

/*  A columnwise scheme is used for solving A*x = b.  The basic algorithm */
/*  if A is lower triangular is */

/*       x[1:n] := b[1:n] */
/*       for j = 1, ..., n */
/*            x(j) := x(j) / A(j,j) */
/*            x[j+1:n] := x[j+1:n] - x(j) * A[j+1:n,j] */
/*       end */

/*  Define bounds on the components of x after j iterations of the loop: */
/*     M(j) = bound on x[1:j] */
/*     G(j) = bound on x[j+1:n] */
/*  Initially, let M(0) = 0 and G(0) = max{x(i), i=1,...,n}. */

/*  Then for iteration j+1 we have */
/*     M(j+1) <= G(j) / | A(j+1,j+1) | */
/*     G(j+1) <= G(j) + M(j+1) * | A[j+2:n,j+1] | */
/*            <= G(j) ( 1 + CNORM(j+1) / | A(j+1,j+1) | ) */

/*  where CNORM(j+1) is greater than or equal to the infinity-norm of */
/*  column j+1 of A, not counting the diagonal.  Hence */

/*     G(j) <= G(0) product ( 1 + CNORM(i) / | A(i,i) | ) */
/*                  1<=i<=j */
/*  and */

/*     |x(j)| <= ( G(0) / |A(j,j)| ) product ( 1 + CNORM(i) / |A(i,i)| ) */
/*                                   1<=i< j */

/*  Since |x(j)| <= M(j), we use the Level 2 PBLAS routine PZTRSV if the */
/*  reciprocal of the largest M(j), j=1,..,n, is larger than */
/*  max(underflow, 1/overflow). */

/*  The bound on x(j) is also used to determine when a step in the */
/*  columnwise method can be performed without fear of overflow.  If */
/*  the computed bound is greater than a large constant, x is scaled to */
/*  prevent overflow, but if the bound overflows, x is set to 0, x(j) to */
/*  1, and scale to 0, and a non-trivial solution to A*x = 0 is found. */

/*  Similarly, a row-wise scheme is used to solve A**T *x = b  or */
/*  A**H *x = b.  The basic algorithm for A upper triangular is */

/*       for j = 1, ..., n */
/*            x(j) := ( b(j) - A[1:j-1,j]' * x[1:j-1] ) / A(j,j) */
/*       end */

/*  We simultaneously compute two bounds */
/*       G(j) = bound on ( b(i) - A[1:i-1,i]' * x[1:i-1] ), 1<=i<=j */
/*       M(j) = bound on x(i), 1<=i<=j */

/*  The initial values are G(0) = 0, M(0) = max{b(i), i=1,..,n}, and we */
/*  add the constraint G(j) >= G(j-1) and M(j) >= M(j-1) for j >= 1. */
/*  Then the bound on x(j) is */

/*       M(j) <= M(j-1) * ( 1 + CNORM(j) ) / | A(j,j) | */

/*            <= M(0) * product ( ( 1 + CNORM(i) ) / |A(i,i)| ) */
/*                      1<=i<=j */

/*  and we can safely call PZTRSV if 1/M(n) and 1/G(n) are both greater */
/*  than max(underflow, 1/overflow). */

/*  Last modified by: Mark R. Fahey, August 2000 */

/*  ===================================================================== */

/*     .. Parameters .. */
/*     .. */
/*     .. Local Scalars .. */
/*     .. */
/*     .. External Functions .. */
/*     .. */
/*     .. External Subroutines .. */
/*     .. */
/*     .. Intrinsic Functions .. */
/*     .. */
/*     .. Statement Functions .. */
/*     .. */
/*     .. Statement Function definitions .. */
/*     .. */
/*     .. Executable Statements .. */

    /* Parameter adjustments */
    --cnorm;
    --descx;
    --x;
    --desca;
    --a;

    /* Function Body */
    *info = 0;
    upper = lsame_(uplo, "U", (ftnlen)1, (ftnlen)1);
    notran = lsame_(trans, "N", (ftnlen)1, (ftnlen)1);
    nounit = lsame_(diag, "N", (ftnlen)1, (ftnlen)1);

    contxt = desca[2];
    rsrc = desca[7];
    csrc = desca[8];
    mb = desca[5];
    nb = desca[6];
    lda = desca[9];
    ldx = descx[9];

/*     Test the input parameters. */

    if (! upper && ! lsame_(uplo, "L", (ftnlen)1, (ftnlen)1)) {
	*info = -1;
    } else if (! notran && ! lsame_(trans, "T", (ftnlen)1, (ftnlen)1) && ! 
	    lsame_(trans, "C", (ftnlen)1, (ftnlen)1)) {
	*info = -2;
    } else if (! nounit && ! lsame_(diag, "U", (ftnlen)1, (ftnlen)1)) {
	*info = -3;
    } else if (! lsame_(normin, "Y", (ftnlen)1, (ftnlen)1) && ! lsame_(normin,
	     "N", (ftnlen)1, (ftnlen)1)) {
	*info = -4;
    } else if (*n < 0) {
	*info = -5;
    }

    blacs_gridinfo__(&contxt, &nprow, &npcol, &myrow, &mycol);

    if (*info != 0) {
	i__1 = -(*info);
	pxerbla_(&contxt, "PZLATTRS", &i__1, (ftnlen)8);
	return 0;
    }

/*     Quick return if possible */

    if (*n == 0) {
	return 0;
    }

/*     Determine machine dependent parameters to control overflow. */

    smlnum = pdlamch_(&contxt, "Safe minimum", (ftnlen)12);
    bignum = 1. / smlnum;
    pdlabad_(&contxt, &smlnum, &bignum);
    smlnum /= pdlamch_(&contxt, "Precision", (ftnlen)9);
    bignum = 1. / smlnum;
    *scale = 1.;


    if (lsame_(normin, "N", (ftnlen)1, (ftnlen)1)) {

/*        Compute the 1-norm of each column, not including the diagonal. */

	if (upper) {

/*           A is upper triangular. */

	    cnorm[1] = 0.;
	    i__1 = *n;
	    for (j = 2; j <= i__1; ++j) {
		i__2 = j - 1;
		i__3 = *ja + j - 1;
		pdzasum_(&i__2, &cnorm[j], &a[1], ia, &i__3, &desca[1], &c__1)
			;
/* L10: */
	    }
	} else {

/*           A is lower triangular. */

	    i__1 = *n - 1;
	    for (j = 1; j <= i__1; ++j) {
		i__2 = *n - j;
		i__3 = *ia + j;
		i__4 = *ja + j - 1;
		pdzasum_(&i__2, &cnorm[j], &a[1], &i__3, &i__4, &desca[1], &
			c__1);
/* L20: */
	    }
	    cnorm[*n] = 0.;
	}
	dgsum2d_(&contxt, "Row", " ", n, &c__1, &cnorm[1], &c__1, &c_n1, &
		c_n1, (ftnlen)3, (ftnlen)1);
    }

/*     Scale the column norms by TSCAL if the maximum element in CNORM is */
/*     greater than BIGNUM/2. */

    imax = lfc_SLidamax(n, &cnorm[1], &c__1);
    tmax = cnorm[imax];
    if (tmax <= bignum * .5) {
	tscal = 1.;
    } else {
	tscal = .5 / (smlnum * tmax);
	lfc_SLdscal(n, &tscal, &cnorm[1], &c__1);
    }

/*     Compute a bound on the computed solution vector to see if the */
/*     Level 2 PBLAS routine PZTRSV can be used. */

    xmax = 0.;
    pzamax_(n, &zdum, &imax, &x[1], ix, jx, &descx[1], &c__1);
    xmax = (d__1 = zdum.r / 2., abs(d__1)) + (d__2 = d_imag(&zdum) / 2., abs(
	    d__2));
    dgsum2d_(&contxt, "Row", " ", &c__1, &c__1, &xmax, &c__1, &c_n1, &c_n1, (
	    ftnlen)3, (ftnlen)1);
    xbnd = xmax;

    if (notran) {

/*        Compute the growth in A * x = b. */

	if (upper) {
	    jfirst = *n;
	    jlast = 1;
	    jinc = -1;
	} else {
	    jfirst = 1;
	    jlast = *n;
	    jinc = 1;
	}

	if (tscal != 1.) {
	    grow = 0.;
	    goto L50;
	}

	if (nounit) {

/*           A is non-unit triangular. */

/*           Compute GROW = 1/G(j) and XBND = 1/M(j). */
/*           Initially, G(0) = max{x(i), i=1,...,n}. */

	    grow = .5 / max(xbnd,smlnum);
	    xbnd = grow;
	    i__1 = jlast;
	    i__2 = jinc;
	    for (j = jfirst; i__2 < 0 ? j >= i__1 : j <= i__1; j += i__2) {

/*              Exit the loop if the growth factor is too small. */

		if (grow <= smlnum) {
		    goto L50;
		}

/*              TJJS = A( J, J ) */
		i__3 = *ia + j - 1;
		i__4 = *ja + j - 1;
		infog2l_(&i__3, &i__4, &desca[1], &nprow, &npcol, &myrow, &
			mycol, &irow, &icol, &itmp1, &itmp2);
		if (myrow == itmp1 && mycol == itmp2) {
		    i__3 = (icol - 1) * lda + irow;
		    tjjs.r = a[i__3].r, tjjs.i = a[i__3].i;
		    zgebs2d_(&contxt, "All", " ", &c__1, &c__1, &tjjs, &c__1, 
			    (ftnlen)3, (ftnlen)1);
		} else {
		    zgebr2d_(&contxt, "All", " ", &c__1, &c__1, &tjjs, &c__1, 
			    &itmp1, &itmp2, (ftnlen)3, (ftnlen)1);
		}
		tjj = (d__1 = tjjs.r, abs(d__1)) + (d__2 = d_imag(&tjjs), abs(
			d__2));

		if (tjj >= smlnum) {

/*                 M(j) = G(j-1) / abs(A(j,j)) */

/* Computing MIN */
		    d__1 = xbnd, d__2 = min(1.,tjj) * grow;
		    xbnd = min(d__1,d__2);
		} else {

/*                 M(j) could overflow, set XBND to 0. */

		    xbnd = 0.;
		}

		if (tjj + cnorm[j] >= smlnum) {

/*                 G(j) = G(j-1)*( 1 + CNORM(j) / abs(A(j,j)) ) */

		    grow *= tjj / (tjj + cnorm[j]);
		} else {

/*                 G(j) could overflow, set GROW to 0. */

		    grow = 0.;
		}
/* L30: */
	    }
	    grow = xbnd;
	} else {

/*           A is unit triangular. */

/*           Compute GROW = 1/G(j), where G(0) = max{x(i), i=1,...,n}. */

/* Computing MIN */
	    d__1 = 1., d__2 = .5 / max(xbnd,smlnum);
	    grow = min(d__1,d__2);
	    i__2 = jlast;
	    i__1 = jinc;
	    for (j = jfirst; i__1 < 0 ? j >= i__2 : j <= i__2; j += i__1) {

/*              Exit the loop if the growth factor is too small. */

		if (grow <= smlnum) {
		    goto L50;
		}

/*              G(j) = G(j-1)*( 1 + CNORM(j) ) */

		grow *= 1. / (cnorm[j] + 1.);
/* L40: */
	    }
	}
L50:

	;
    } else {

/*        Compute the growth in A**T * x = b  or  A**H * x = b. */

	if (upper) {
	    jfirst = 1;
	    jlast = *n;
	    jinc = 1;
	} else {
	    jfirst = *n;
	    jlast = 1;
	    jinc = -1;
	}

	if (tscal != 1.) {
	    grow = 0.;
	    goto L80;
	}

	if (nounit) {

/*           A is non-unit triangular. */

/*           Compute GROW = 1/G(j) and XBND = 1/M(j). */
/*           Initially, M(0) = max{x(i), i=1,...,n}. */

	    grow = .5 / max(xbnd,smlnum);
	    xbnd = grow;
	    i__1 = jlast;
	    i__2 = jinc;
	    for (j = jfirst; i__2 < 0 ? j >= i__1 : j <= i__1; j += i__2) {

/*              Exit the loop if the growth factor is too small. */

		if (grow <= smlnum) {
		    goto L80;
		}

/*              G(j) = max( G(j-1), M(j-1)*( 1 + CNORM(j) ) ) */

		xj = cnorm[j] + 1.;
/* Computing MIN */
		d__1 = grow, d__2 = xbnd / xj;
		grow = min(d__1,d__2);

/*              TJJS = A( J, J ) */
		i__3 = *ia + j - 1;
		i__4 = *ja + j - 1;
		infog2l_(&i__3, &i__4, &desca[1], &nprow, &npcol, &myrow, &
			mycol, &irow, &icol, &itmp1, &itmp2);
		if (myrow == itmp1 && mycol == itmp2) {
		    i__3 = (icol - 1) * lda + irow;
		    tjjs.r = a[i__3].r, tjjs.i = a[i__3].i;
		    zgebs2d_(&contxt, "All", " ", &c__1, &c__1, &tjjs, &c__1, 
			    (ftnlen)3, (ftnlen)1);
		} else {
		    zgebr2d_(&contxt, "All", " ", &c__1, &c__1, &tjjs, &c__1, 
			    &itmp1, &itmp2, (ftnlen)3, (ftnlen)1);
		}
		tjj = (d__1 = tjjs.r, abs(d__1)) + (d__2 = d_imag(&tjjs), abs(
			d__2));

		if (tjj >= smlnum) {

/*                 M(j) = M(j-1)*( 1 + CNORM(j) ) / abs(A(j,j)) */

		    if (xj > tjj) {
			xbnd *= tjj / xj;
		    }
		} else {

/*                 M(j) could overflow, set XBND to 0. */

		    xbnd = 0.;
		}
/* L60: */
	    }
	    grow = min(grow,xbnd);
	} else {

/*           A is unit triangular. */

/*           Compute GROW = 1/G(j), where G(0) = max{x(i), i=1,...,n}. */

/* Computing MIN */
	    d__1 = 1., d__2 = .5 / max(xbnd,smlnum);
	    grow = min(d__1,d__2);
	    i__2 = jlast;
	    i__1 = jinc;
	    for (j = jfirst; i__1 < 0 ? j >= i__2 : j <= i__2; j += i__1) {

/*              Exit the loop if the growth factor is too small. */

		if (grow <= smlnum) {
		    goto L80;
		}

/*              G(j) = ( 1 + CNORM(j) )*G(j-1) */

		xj = cnorm[j] + 1.;
		grow /= xj;
/* L70: */
	    }
	}
L80:
	;
    }

    if (grow * tscal > smlnum) {

/*        Use the Level 2 PBLAS solve if the reciprocal of the bound on */
/*        elements of X is not too small. */

	pztrsv_(uplo, trans, diag, n, &a[1], ia, ja, &desca[1], &x[1], ix, jx,
		 &descx[1], &c__1, (ftnlen)1, (ftnlen)1, (ftnlen)1);
    } else {

/*        Use a Level 1 PBLAS solve, scaling intermediate results. */

	if (xmax > bignum * .5) {

/*           Scale X so that its components are less than or equal to */
/*           BIGNUM in absolute value. */

	    *scale = bignum * .5 / xmax;
	    pzdscal_(n, scale, &x[1], ix, jx, &descx[1], &c__1);
	    xmax = bignum;
	} else {
	    xmax *= 2.;
	}

	if (notran) {

/*           Solve A * x = b */

	    i__1 = jlast;
	    i__2 = jinc;
	    for (j = jfirst; i__2 < 0 ? j >= i__1 : j <= i__1; j += i__2) {

/*              Compute x(j) = b(j) / A(j,j), scaling x if necessary. */

/*              XJ = CABS1( X( J ) ) */
		i__3 = *ix + j - 1;
		infog2l_(&i__3, jx, &descx[1], &nprow, &npcol, &myrow, &mycol,
			 &irowx, &icolx, &itmp1x, &itmp2x);
		if (myrow == itmp1x && mycol == itmp2x) {
		    i__3 = irowx;
		    xjtmp.r = x[i__3].r, xjtmp.i = x[i__3].i;
		    zgebs2d_(&contxt, "All", " ", &c__1, &c__1, &xjtmp, &c__1,
			     (ftnlen)3, (ftnlen)1);
		} else {
		    zgebr2d_(&contxt, "All", " ", &c__1, &c__1, &xjtmp, &c__1,
			     &itmp1x, &itmp2x, (ftnlen)3, (ftnlen)1);
		}
		xj = (d__1 = xjtmp.r, abs(d__1)) + (d__2 = d_imag(&xjtmp), 
			abs(d__2));
		if (nounit) {
/*                 TJJS = A( J, J )*TSCAL */
		    i__3 = *ia + j - 1;
		    i__4 = *ja + j - 1;
		    infog2l_(&i__3, &i__4, &desca[1], &nprow, &npcol, &myrow, 
			    &mycol, &irow, &icol, &itmp1, &itmp2);
		    if (myrow == itmp1 && mycol == itmp2) {
			i__3 = (icol - 1) * lda + irow;
			z__1.r = tscal * a[i__3].r, z__1.i = tscal * a[i__3]
				.i;
			tjjs.r = z__1.r, tjjs.i = z__1.i;
			zgebs2d_(&contxt, "All", " ", &c__1, &c__1, &tjjs, &
				c__1, (ftnlen)3, (ftnlen)1);
		    } else {
			zgebr2d_(&contxt, "All", " ", &c__1, &c__1, &tjjs, &
				c__1, &itmp1, &itmp2, (ftnlen)3, (ftnlen)1);
		    }
		} else {
		    tjjs.r = tscal, tjjs.i = 0.;
		    if (tscal == 1.) {
			goto L90;
		    }
		}
		tjj = (d__1 = tjjs.r, abs(d__1)) + (d__2 = d_imag(&tjjs), abs(
			d__2));
		if (tjj > smlnum) {

/*                    abs(A(j,j)) > SMLNUM: */

		    if (tjj < 1.) {
			if (xj > tjj * bignum) {

/*                          Scale x by 1/b(j). */

			    rec = 1. / xj;
			    pzdscal_(n, &rec, &x[1], ix, jx, &descx[1], &c__1)
				    ;
			    z__1.r = rec * xjtmp.r, z__1.i = rec * xjtmp.i;
			    xjtmp.r = z__1.r, xjtmp.i = z__1.i;
			    *scale *= rec;
			    xmax *= rec;
			}
		    }
/*                 X( J ) = ZLADIV( X( J ), TJJS ) */
/*                 XJ = CABS1( X( J ) ) */
		    zladiv_(&z__1, &xjtmp, &tjjs);
		    xjtmp.r = z__1.r, xjtmp.i = z__1.i;
		    xj = (d__1 = xjtmp.r, abs(d__1)) + (d__2 = d_imag(&xjtmp),
			     abs(d__2));
		    if (myrow == itmp1x && mycol == itmp2x) {
			i__3 = irowx;
			x[i__3].r = xjtmp.r, x[i__3].i = xjtmp.i;
		    }
		} else if (tjj > 0.) {

/*                    0 < abs(A(j,j)) <= SMLNUM: */

		    if (xj > tjj * bignum) {

/*                       Scale x by (1/abs(x(j)))*abs(A(j,j))*BIGNUM */
/*                       to avoid overflow when dividing by A(j,j). */

			rec = tjj * bignum / xj;
			if (cnorm[j] > 1.) {

/*                          Scale by 1/CNORM(j) to avoid overflow when */
/*                          multiplying x(j) times column j. */

			    rec /= cnorm[j];
			}
			pzdscal_(n, &rec, &x[1], ix, jx, &descx[1], &c__1);
			z__1.r = rec * xjtmp.r, z__1.i = rec * xjtmp.i;
			xjtmp.r = z__1.r, xjtmp.i = z__1.i;
			*scale *= rec;
			xmax *= rec;
		    }
/*                 X( J ) = ZLADIV( X( J ), TJJS ) */
/*                 XJ = CABS1( X( J ) ) */
		    zladiv_(&z__1, &xjtmp, &tjjs);
		    xjtmp.r = z__1.r, xjtmp.i = z__1.i;
		    xj = (d__1 = xjtmp.r, abs(d__1)) + (d__2 = d_imag(&xjtmp),
			     abs(d__2));
		    if (myrow == itmp1x && mycol == itmp2x) {
			i__3 = irowx;
			x[i__3].r = xjtmp.r, x[i__3].i = xjtmp.i;
		    }
		} else {

/*                    A(j,j) = 0:  Set x(1:n) = 0, x(j) = 1, and */
/*                    scale = 0, and compute a solution to A*x = 0. */

		    pzlaset_(" ", n, &c__1, &c_b1, &c_b1, &x[1], ix, jx, &
			    descx[1], (ftnlen)1);
		    if (myrow == itmp1x && mycol == itmp2x) {
			i__3 = irowx;
			x[i__3].r = 1., x[i__3].i = 0.;
		    }
		    xjtmp.r = 1., xjtmp.i = 0.;
		    xj = 1.;
		    *scale = 0.;
		    xmax = 0.;
		}
L90:

/*              Scale x if necessary to avoid overflow when adding a */
/*              multiple of column j of A. */

		if (xj > 1.) {
		    rec = 1. / xj;
		    if (cnorm[j] > (bignum - xmax) * rec) {

/*                    Scale x by 1/(2*abs(x(j))). */

			rec *= .5;
			pzdscal_(n, &rec, &x[1], ix, jx, &descx[1], &c__1);
			z__1.r = rec * xjtmp.r, z__1.i = rec * xjtmp.i;
			xjtmp.r = z__1.r, xjtmp.i = z__1.i;
			*scale *= rec;
		    }
		} else if (xj * cnorm[j] > bignum - xmax) {

/*                 Scale x by 1/2. */

		    pzdscal_(n, &c_b92, &x[1], ix, jx, &descx[1], &c__1);
		    z__1.r = xjtmp.r * .5, z__1.i = xjtmp.i * .5;
		    xjtmp.r = z__1.r, xjtmp.i = z__1.i;
		    *scale *= .5;
		}

		if (upper) {
		    if (j > 1) {

/*                    Compute the update */
/*                       x(1:j-1) := x(1:j-1) - x(j) * A(1:j-1,j) */

			z__2.r = -xjtmp.r, z__2.i = -xjtmp.i;
			z__1.r = tscal * z__2.r, z__1.i = tscal * z__2.i;
			zdum.r = z__1.r, zdum.i = z__1.i;
			i__3 = j - 1;
			i__4 = *ja + j - 1;
			pzaxpy_(&i__3, &zdum, &a[1], ia, &i__4, &desca[1], &
				c__1, &x[1], ix, jx, &descx[1], &c__1);
			i__3 = j - 1;
			pzamax_(&i__3, &zdum, &imax, &x[1], ix, jx, &descx[1],
				 &c__1);
			xmax = (d__1 = zdum.r, abs(d__1)) + (d__2 = d_imag(&
				zdum), abs(d__2));
			dgsum2d_(&contxt, "Row", " ", &c__1, &c__1, &xmax, &
				c__1, &c_n1, &c_n1, (ftnlen)3, (ftnlen)1);
		    }
		} else {
		    if (j < *n) {

/*                    Compute the update */
/*                       x(j+1:n) := x(j+1:n) - x(j) * A(j+1:n,j) */

			z__2.r = -xjtmp.r, z__2.i = -xjtmp.i;
			z__1.r = tscal * z__2.r, z__1.i = tscal * z__2.i;
			zdum.r = z__1.r, zdum.i = z__1.i;
			i__3 = *n - j;
			i__4 = *ia + j;
			i__5 = *ja + j - 1;
			i__6 = *ix + j;
			pzaxpy_(&i__3, &zdum, &a[1], &i__4, &i__5, &desca[1], 
				&c__1, &x[1], &i__6, jx, &descx[1], &c__1);
			i__3 = *n - j;
			i__4 = *ix + j;
			pzamax_(&i__3, &zdum, &i__, &x[1], &i__4, jx, &descx[
				1], &c__1);
			xmax = (d__1 = zdum.r, abs(d__1)) + (d__2 = d_imag(&
				zdum), abs(d__2));
			dgsum2d_(&contxt, "Row", " ", &c__1, &c__1, &xmax, &
				c__1, &c_n1, &c_n1, (ftnlen)3, (ftnlen)1);
		    }
		}
/* L100: */
	    }

	} else if (lsame_(trans, "T", (ftnlen)1, (ftnlen)1)) {

/*           Solve A**T * x = b */

	    i__2 = jlast;
	    i__1 = jinc;
	    for (j = jfirst; i__1 < 0 ? j >= i__2 : j <= i__2; j += i__1) {

/*              Compute x(j) = b(j) - sum A(k,j)*x(k). */
/*                                    k<>j */

/*              XJ = CABS1( X( J ) ) */
		i__3 = *ix + j - 1;
		infog2l_(&i__3, jx, &descx[1], &nprow, &npcol, &myrow, &mycol,
			 &irowx, &icolx, &itmp1x, &itmp2x);
		if (myrow == itmp1x && mycol == itmp2x) {
		    i__3 = irowx;
		    xjtmp.r = x[i__3].r, xjtmp.i = x[i__3].i;
		    zgebs2d_(&contxt, "All", " ", &c__1, &c__1, &xjtmp, &c__1,
			     (ftnlen)3, (ftnlen)1);
		} else {
		    zgebr2d_(&contxt, "All", " ", &c__1, &c__1, &xjtmp, &c__1,
			     &itmp1x, &itmp2x, (ftnlen)3, (ftnlen)1);
		}
		xj = (d__1 = xjtmp.r, abs(d__1)) + (d__2 = d_imag(&xjtmp), 
			abs(d__2));
		z__1.r = tscal, z__1.i = 0.;
		uscal.r = z__1.r, uscal.i = z__1.i;
		rec = 1. / max(xmax,1.);
		if (cnorm[j] > (bignum - xj) * rec) {

/*                 If x(j) could overflow, scale x by 1/(2*XMAX). */

		    rec *= .5;
		    if (nounit) {
/*                    TJJS = A( J, J )*TSCAL */
			i__3 = *ia + j - 1;
			i__4 = *ja + j - 1;
			infog2l_(&i__3, &i__4, &desca[1], &nprow, &npcol, &
				myrow, &mycol, &irow, &icol, &itmp1, &itmp2);
			if (myrow == itmp1 && mycol == itmp2) {
			    i__3 = (icol - 1) * lda + irow;
			    z__1.r = tscal * a[i__3].r, z__1.i = tscal * a[
				    i__3].i;
			    tjjs.r = z__1.r, tjjs.i = z__1.i;
			    zgebs2d_(&contxt, "All", " ", &c__1, &c__1, &tjjs,
				     &c__1, (ftnlen)3, (ftnlen)1);
			} else {
			    zgebr2d_(&contxt, "All", " ", &c__1, &c__1, &tjjs,
				     &c__1, &itmp1, &itmp2, (ftnlen)3, (
				    ftnlen)1);
			}
		    } else {
			tjjs.r = tscal, tjjs.i = 0.;
		    }
		    tjj = (d__1 = tjjs.r, abs(d__1)) + (d__2 = d_imag(&tjjs), 
			    abs(d__2));
		    if (tjj > 1.) {

/*                       Divide by A(j,j) when scaling x if A(j,j) > 1. */

/* Computing MIN */
			d__1 = 1., d__2 = rec * tjj;
			rec = min(d__1,d__2);
			zladiv_(&z__1, &uscal, &tjjs);
			uscal.r = z__1.r, uscal.i = z__1.i;
		    }
		    if (rec < 1.) {
			pzdscal_(n, &rec, &x[1], ix, jx, &descx[1], &c__1);
			z__1.r = rec * xjtmp.r, z__1.i = rec * xjtmp.i;
			xjtmp.r = z__1.r, xjtmp.i = z__1.i;
			*scale *= rec;
			xmax *= rec;
		    }
		}

		csumj.r = 0., csumj.i = 0.;
		if (uscal.r == 1. && uscal.i == 0.) {

/*                 If the scaling needed for A in the dot product is 1, */
/*                 call PZDOTU to perform the dot product. */

		    if (upper) {
			i__3 = j - 1;
			i__4 = *ja + j - 1;
			pzdotu_(&i__3, &csumj, &a[1], ia, &i__4, &desca[1], &
				c__1, &x[1], ix, jx, &descx[1], &c__1);
		    } else if (j < *n) {
			i__3 = *n - j;
			i__4 = *ia + j;
			i__5 = *ja + j - 1;
			i__6 = *ix + j;
			pzdotu_(&i__3, &csumj, &a[1], &i__4, &i__5, &desca[1],
				 &c__1, &x[1], &i__6, jx, &descx[1], &c__1);
		    }
		    if (mycol == itmp2x) {
			zgebs2d_(&contxt, "Row", " ", &c__1, &c__1, &csumj, &
				c__1, (ftnlen)3, (ftnlen)1);
		    } else {
			zgebr2d_(&contxt, "Row", " ", &c__1, &c__1, &csumj, &
				c__1, &myrow, &itmp2x, (ftnlen)3, (ftnlen)1);
		    }
		} else {

/*                 Otherwise, scale column of A by USCAL before dot */
/*                 product.  Below is not the best way to do it. */

		    if (upper) {
/*                    DO 130 I = 1, J - 1 */
/*                       CSUMJ = CSUMJ + ( A( I, J )*USCAL )*X( I ) */
/* 130                CONTINUE */
			d_cnjg(&z__1, &uscal);
			zdum.r = z__1.r, zdum.i = z__1.i;
			i__3 = j - 1;
			i__4 = *ja + j - 1;
			pzscal_(&i__3, &zdum, &a[1], ia, &i__4, &desca[1], &
				c__1);
			i__3 = j - 1;
			i__4 = *ja + j - 1;
			pzdotu_(&i__3, &csumj, &a[1], ia, &i__4, &desca[1], &
				c__1, &x[1], ix, jx, &descx[1], &c__1);
			zladiv_(&z__1, &zdum, &uscal);
			zdum.r = z__1.r, zdum.i = z__1.i;
			i__3 = j - 1;
			i__4 = *ja + j - 1;
			pzscal_(&i__3, &zdum, &a[1], ia, &i__4, &desca[1], &
				c__1);
		    } else if (j < *n) {
/*                    DO 140 I = J + 1, N */
/*                       CSUMJ = CSUMJ + ( A( I, J )*USCAL )*X( I ) */
/*  140               CONTINUE */
			d_cnjg(&z__1, &uscal);
			zdum.r = z__1.r, zdum.i = z__1.i;
			i__3 = *n - j;
			i__4 = *ia + j;
			i__5 = *ja + j - 1;
			pzscal_(&i__3, &zdum, &a[1], &i__4, &i__5, &desca[1], 
				&c__1);
			i__3 = *n - j;
			i__4 = *ia + j;
			i__5 = *ja + j - 1;
			i__6 = *ix + j;
			pzdotu_(&i__3, &csumj, &a[1], &i__4, &i__5, &desca[1],
				 &c__1, &x[1], &i__6, jx, &descx[1], &c__1);
			zladiv_(&z__1, &zdum, &uscal);
			zdum.r = z__1.r, zdum.i = z__1.i;
			i__3 = *n - j;
			i__4 = *ia + j;
			i__5 = *ja + j - 1;
			pzscal_(&i__3, &zdum, &a[1], &i__4, &i__5, &desca[1], 
				&c__1);
		    }
		    if (mycol == itmp2x) {
			zgebs2d_(&contxt, "Row", " ", &c__1, &c__1, &csumj, &
				c__1, (ftnlen)3, (ftnlen)1);
		    } else {
			zgebr2d_(&contxt, "Row", " ", &c__1, &c__1, &csumj, &
				c__1, &myrow, &itmp2x, (ftnlen)3, (ftnlen)1);
		    }
		}

		z__1.r = tscal, z__1.i = 0.;
		if (uscal.r == z__1.r && uscal.i == z__1.i) {

/*                 Compute x(j) := ( x(j) - CSUMJ ) / A(j,j) if 1/A(j,j) */
/*                 was not used to scale the dotproduct. */

/*                 X( J ) = X( J ) - CSUMJ */
/*                 XJ = CABS1( X( J ) ) */
		    z__1.r = xjtmp.r - csumj.r, z__1.i = xjtmp.i - csumj.i;
		    xjtmp.r = z__1.r, xjtmp.i = z__1.i;
		    xj = (d__1 = xjtmp.r, abs(d__1)) + (d__2 = d_imag(&xjtmp),
			     abs(d__2));
/*                  IF( ( MYROW.EQ.ITMP1X ) .AND. ( MYCOL.EQ.ITMP2X ) ) */
/*     $               X( IROWX ) = XJTMP */
		    if (nounit) {
/*                    TJJS = A( J, J )*TSCAL */
			i__3 = *ia + j - 1;
			i__4 = *ja + j - 1;
			infog2l_(&i__3, &i__4, &desca[1], &nprow, &npcol, &
				myrow, &mycol, &irow, &icol, &itmp1, &itmp2);
			if (myrow == itmp1 && mycol == itmp2) {
			    i__3 = (icol - 1) * lda + irow;
			    z__1.r = tscal * a[i__3].r, z__1.i = tscal * a[
				    i__3].i;
			    tjjs.r = z__1.r, tjjs.i = z__1.i;
			    zgebs2d_(&contxt, "All", " ", &c__1, &c__1, &tjjs,
				     &c__1, (ftnlen)3, (ftnlen)1);
			} else {
			    zgebr2d_(&contxt, "All", " ", &c__1, &c__1, &tjjs,
				     &c__1, &itmp1, &itmp2, (ftnlen)3, (
				    ftnlen)1);
			}
		    } else {
			tjjs.r = tscal, tjjs.i = 0.;
			if (tscal == 1.) {
			    goto L110;
			}
		    }

/*                    Compute x(j) = x(j) / A(j,j), scaling if necessary. */

		    tjj = (d__1 = tjjs.r, abs(d__1)) + (d__2 = d_imag(&tjjs), 
			    abs(d__2));
		    if (tjj > smlnum) {

/*                       abs(A(j,j)) > SMLNUM: */

			if (tjj < 1.) {
			    if (xj > tjj * bignum) {

/*                             Scale X by 1/abs(x(j)). */

				rec = 1. / xj;
				pzdscal_(n, &rec, &x[1], ix, jx, &descx[1], &
					c__1);
				z__1.r = rec * xjtmp.r, z__1.i = rec * 
					xjtmp.i;
				xjtmp.r = z__1.r, xjtmp.i = z__1.i;
				*scale *= rec;
				xmax *= rec;
			    }
			}
/*                    X( J ) = ZLADIV( X( J ), TJJS ) */
			zladiv_(&z__1, &xjtmp, &tjjs);
			xjtmp.r = z__1.r, xjtmp.i = z__1.i;
			if (myrow == itmp1x && mycol == itmp2x) {
			    i__3 = irowx;
			    x[i__3].r = xjtmp.r, x[i__3].i = xjtmp.i;
			}
		    } else if (tjj > 0.) {

/*                       0 < abs(A(j,j)) <= SMLNUM: */

			if (xj > tjj * bignum) {

/*                          Scale x by (1/abs(x(j)))*abs(A(j,j))*BIGNUM. */

			    rec = tjj * bignum / xj;
			    pzdscal_(n, &rec, &x[1], ix, jx, &descx[1], &c__1)
				    ;
			    z__1.r = rec * xjtmp.r, z__1.i = rec * xjtmp.i;
			    xjtmp.r = z__1.r, xjtmp.i = z__1.i;
			    *scale *= rec;
			    xmax *= rec;
			}
/*                    X( J ) = ZLADIV( X( J ), TJJS ) */
			zladiv_(&z__1, &xjtmp, &tjjs);
			xjtmp.r = z__1.r, xjtmp.i = z__1.i;
			if (myrow == itmp1x && mycol == itmp2x) {
			    i__3 = irowx;
			    x[i__3].r = xjtmp.r, x[i__3].i = xjtmp.i;
			}
		    } else {

/*                       A(j,j) = 0:  Set x(1:n) = 0, x(j) = 1, and */
/*                       scale = 0 and compute a solution to A**T *x = 0. */

			pzlaset_(" ", n, &c__1, &c_b1, &c_b1, &x[1], ix, jx, &
				descx[1], (ftnlen)1);
			if (myrow == itmp1x && mycol == itmp2x) {
			    i__3 = irowx;
			    x[i__3].r = 1., x[i__3].i = 0.;
			}
			xjtmp.r = 1., xjtmp.i = 0.;
			*scale = 0.;
			xmax = 0.;
		    }
L110:
		    ;
		} else {

/*                 Compute x(j) := x(j) / A(j,j) - CSUMJ if the dot */
/*                 product has already been divided by 1/A(j,j). */

/*                 X( J ) = ZLADIV( X( J ), TJJS ) - CSUMJ */
		    zladiv_(&z__2, &xjtmp, &tjjs);
		    z__1.r = z__2.r - csumj.r, z__1.i = z__2.i - csumj.i;
		    xjtmp.r = z__1.r, xjtmp.i = z__1.i;
		    if (myrow == itmp1x && mycol == itmp2x) {
			i__3 = irowx;
			x[i__3].r = xjtmp.r, x[i__3].i = xjtmp.i;
		    }
		}
/* Computing MAX */
		d__3 = xmax, d__4 = (d__1 = xjtmp.r, abs(d__1)) + (d__2 = 
			d_imag(&xjtmp), abs(d__2));
		xmax = max(d__3,d__4);
/* L120: */
	    }

	} else {

/*           Solve A**H * x = b */

	    i__1 = jlast;
	    i__2 = jinc;
	    for (j = jfirst; i__2 < 0 ? j >= i__1 : j <= i__1; j += i__2) {

/*              Compute x(j) = b(j) - sum A(k,j)*x(k). */
/*                                    k<>j */

		i__3 = *ix + j - 1;
		infog2l_(&i__3, jx, &descx[1], &nprow, &npcol, &myrow, &mycol,
			 &irowx, &icolx, &itmp1x, &itmp2x);
		if (myrow == itmp1x && mycol == itmp2x) {
		    i__3 = irowx;
		    xjtmp.r = x[i__3].r, xjtmp.i = x[i__3].i;
		    zgebs2d_(&contxt, "All", " ", &c__1, &c__1, &xjtmp, &c__1,
			     (ftnlen)3, (ftnlen)1);
		} else {
		    zgebr2d_(&contxt, "All", " ", &c__1, &c__1, &xjtmp, &c__1,
			     &itmp1x, &itmp2x, (ftnlen)3, (ftnlen)1);
		}
		xj = (d__1 = xjtmp.r, abs(d__1)) + (d__2 = d_imag(&xjtmp), 
			abs(d__2));
		uscal.r = tscal, uscal.i = 0.;
		rec = 1. / max(xmax,1.);
		if (cnorm[j] > (bignum - xj) * rec) {

/*                 If x(j) could overflow, scale x by 1/(2*XMAX). */

		    rec *= .5;
		    if (nounit) {
/*                    TJJS = DCONJG( A( J, J ) )*TSCAL */
			i__3 = *ia + j - 1;
			i__4 = *ja + j - 1;
			infog2l_(&i__3, &i__4, &desca[1], &nprow, &npcol, &
				myrow, &mycol, &irow, &icol, &itmp1, &itmp2);
			if (myrow == itmp1 && mycol == itmp2) {
			    d_cnjg(&z__2, &a[(icol - 1) * lda + irow]);
			    z__1.r = tscal * z__2.r, z__1.i = tscal * z__2.i;
			    tjjs.r = z__1.r, tjjs.i = z__1.i;
			    zgebs2d_(&contxt, "All", " ", &c__1, &c__1, &tjjs,
				     &c__1, (ftnlen)3, (ftnlen)1);
			} else {
			    zgebr2d_(&contxt, "All", " ", &c__1, &c__1, &tjjs,
				     &c__1, &itmp1, &itmp2, (ftnlen)3, (
				    ftnlen)1);
			}
		    } else {
			tjjs.r = tscal, tjjs.i = 0.;
		    }
		    tjj = (d__1 = tjjs.r, abs(d__1)) + (d__2 = d_imag(&tjjs), 
			    abs(d__2));
		    if (tjj > 1.) {

/*                       Divide by A(j,j) when scaling x if A(j,j) > 1. */

/* Computing MIN */
			d__1 = 1., d__2 = rec * tjj;
			rec = min(d__1,d__2);
			zladiv_(&z__1, &uscal, &tjjs);
			uscal.r = z__1.r, uscal.i = z__1.i;
		    }
		    if (rec < 1.) {
			pzdscal_(n, &rec, &x[1], ix, jx, &descx[1], &c__1);
			z__1.r = rec * xjtmp.r, z__1.i = rec * xjtmp.i;
			xjtmp.r = z__1.r, xjtmp.i = z__1.i;
			*scale *= rec;
			xmax *= rec;
		    }
		}

		csumj.r = 0., csumj.i = 0.;
		if (uscal.r == 1. && uscal.i == 0.) {

/*                 If the scaling needed for A in the dot product is 1, */
/*                 call PZDOTC to perform the dot product. */

		    if (upper) {
			i__3 = j - 1;
			i__4 = *ja + j - 1;
			pzdotc_(&i__3, &csumj, &a[1], ia, &i__4, &desca[1], &
				c__1, &x[1], ix, jx, &descx[1], &c__1);
		    } else if (j < *n) {
			i__3 = *n - j;
			i__4 = *ia + j;
			i__5 = *ja + j - 1;
			i__6 = *ix + j;
			pzdotc_(&i__3, &csumj, &a[1], &i__4, &i__5, &desca[1],
				 &c__1, &x[1], &i__6, jx, &descx[1], &c__1);
		    }
		    if (mycol == itmp2x) {
			zgebs2d_(&contxt, "Row", " ", &c__1, &c__1, &csumj, &
				c__1, (ftnlen)3, (ftnlen)1);
		    } else {
			zgebr2d_(&contxt, "Row", " ", &c__1, &c__1, &csumj, &
				c__1, &myrow, &itmp2x, (ftnlen)3, (ftnlen)1);
		    }
		} else {

/*                 Otherwise, scale column of A by USCAL before dot */
/*                 product.  Below is not the best way to do it. */

		    if (upper) {
/*                    DO 180 I = 1, J - 1 */
/*                       CSUMJ = CSUMJ + ( DCONJG( A( I, J ) )*USCAL )* */
/*    $                          X( I ) */
/* 180                CONTINUE */
			d_cnjg(&z__1, &uscal);
			zdum.r = z__1.r, zdum.i = z__1.i;
			i__3 = j - 1;
			i__4 = *ja + j - 1;
			pzscal_(&i__3, &zdum, &a[1], ia, &i__4, &desca[1], &
				c__1);
			i__3 = j - 1;
			i__4 = *ja + j - 1;
			pzdotc_(&i__3, &csumj, &a[1], ia, &i__4, &desca[1], &
				c__1, &x[1], ix, jx, &descx[1], &c__1);
			zladiv_(&z__1, &c_b2, &zdum);
			zdum.r = z__1.r, zdum.i = z__1.i;
			i__3 = j - 1;
			i__4 = *ja + j - 1;
			pzscal_(&i__3, &zdum, &a[1], ia, &i__4, &desca[1], &
				c__1);
		    } else if (j < *n) {
/*                    DO 190 I = J + 1, N */
/*                       CSUMJ = CSUMJ + ( DCONJG( A( I, J ) )*USCAL )* */
/*    $                          X( I ) */
/* 190                CONTINUE */
			d_cnjg(&z__1, &uscal);
			zdum.r = z__1.r, zdum.i = z__1.i;
			i__3 = *n - j;
			i__4 = *ia + j;
			i__5 = *ja + j - 1;
			pzscal_(&i__3, &zdum, &a[1], &i__4, &i__5, &desca[1], 
				&c__1);
			i__3 = *n - j;
			i__4 = *ia + j;
			i__5 = *ja + j - 1;
			i__6 = *ix + j;
			pzdotc_(&i__3, &csumj, &a[1], &i__4, &i__5, &desca[1],
				 &c__1, &x[1], &i__6, jx, &descx[1], &c__1);
			zladiv_(&z__1, &c_b2, &zdum);
			zdum.r = z__1.r, zdum.i = z__1.i;
			i__3 = *n - j;
			i__4 = *ia + j;
			i__5 = *ja + j - 1;
			pzscal_(&i__3, &zdum, &a[1], &i__4, &i__5, &desca[1], 
				&c__1);
		    }
		    if (mycol == itmp2x) {
			zgebs2d_(&contxt, "Row", " ", &c__1, &c__1, &csumj, &
				c__1, (ftnlen)3, (ftnlen)1);
		    } else {
			zgebr2d_(&contxt, "Row", " ", &c__1, &c__1, &csumj, &
				c__1, &myrow, &itmp2x, (ftnlen)3, (ftnlen)1);
		    }
		}

		z__1.r = tscal, z__1.i = 0.;
		if (uscal.r == z__1.r && uscal.i == z__1.i) {

/*                 Compute x(j) := ( x(j) - CSUMJ ) / A(j,j) if 1/A(j,j) */
/*                 was not used to scale the dotproduct. */

/*                 X( J ) = X( J ) - CSUMJ */
/*                 XJ = CABS1( X( J ) ) */
		    z__1.r = xjtmp.r - csumj.r, z__1.i = xjtmp.i - csumj.i;
		    xjtmp.r = z__1.r, xjtmp.i = z__1.i;
		    xj = (d__1 = xjtmp.r, abs(d__1)) + (d__2 = d_imag(&xjtmp),
			     abs(d__2));
/*                  IF( ( MYROW.EQ.ITMP1X ) .AND. ( MYCOL.EQ.ITMP2X ) ) */
/*     $               X( IROWX ) = XJTMP */
		    if (nounit) {
/*                    TJJS = DCONJG( A( J, J ) )*TSCAL */
			i__3 = *ia + j - 1;
			i__4 = *ja + j - 1;
			infog2l_(&i__3, &i__4, &desca[1], &nprow, &npcol, &
				myrow, &mycol, &irow, &icol, &itmp1, &itmp2);
			if (myrow == itmp1 && mycol == itmp2) {
			    d_cnjg(&z__2, &a[(icol - 1) * lda + irow]);
			    z__1.r = tscal * z__2.r, z__1.i = tscal * z__2.i;
			    tjjs.r = z__1.r, tjjs.i = z__1.i;
			    zgebs2d_(&contxt, "All", " ", &c__1, &c__1, &tjjs,
				     &c__1, (ftnlen)3, (ftnlen)1);
			} else {
			    zgebr2d_(&contxt, "All", " ", &c__1, &c__1, &tjjs,
				     &c__1, &itmp1, &itmp2, (ftnlen)3, (
				    ftnlen)1);
			}
		    } else {
			tjjs.r = tscal, tjjs.i = 0.;
			if (tscal == 1.) {
			    goto L130;
			}
		    }

/*                    Compute x(j) = x(j) / A(j,j), scaling if necessary. */

		    tjj = (d__1 = tjjs.r, abs(d__1)) + (d__2 = d_imag(&tjjs), 
			    abs(d__2));
		    if (tjj > smlnum) {

/*                       abs(A(j,j)) > SMLNUM: */

			if (tjj < 1.) {
			    if (xj > tjj * bignum) {

/*                             Scale X by 1/abs(x(j)). */

				rec = 1. / xj;
				pzdscal_(n, &rec, &x[1], ix, jx, &descx[1], &
					c__1);
				z__1.r = rec * xjtmp.r, z__1.i = rec * 
					xjtmp.i;
				xjtmp.r = z__1.r, xjtmp.i = z__1.i;
				*scale *= rec;
				xmax *= rec;
			    }
			}
/*                    X( J ) = ZLADIV( X( J ), TJJS ) */
			zladiv_(&z__1, &xjtmp, &tjjs);
			xjtmp.r = z__1.r, xjtmp.i = z__1.i;
			if (myrow == itmp1x && mycol == itmp2x) {
			    i__3 = irowx;
			    x[i__3].r = xjtmp.r, x[i__3].i = xjtmp.i;
			}
		    } else if (tjj > 0.) {

/*                       0 < abs(A(j,j)) <= SMLNUM: */

			if (xj > tjj * bignum) {

/*                          Scale x by (1/abs(x(j)))*abs(A(j,j))*BIGNUM. */

			    rec = tjj * bignum / xj;
			    pzdscal_(n, &rec, &x[1], ix, jx, &descx[1], &c__1)
				    ;
			    z__1.r = rec * xjtmp.r, z__1.i = rec * xjtmp.i;
			    xjtmp.r = z__1.r, xjtmp.i = z__1.i;
			    *scale *= rec;
			    xmax *= rec;
			}
/*                    X( J ) = ZLADIV( X( J ), TJJS ) */
			zladiv_(&z__1, &xjtmp, &tjjs);
			xjtmp.r = z__1.r, xjtmp.i = z__1.i;
			if (myrow == itmp1x && mycol == itmp2x) {
			    i__3 = irowx;
			    x[i__3].r = xjtmp.r, x[i__3].i = xjtmp.i;
			}
		    } else {

/*                       A(j,j) = 0:  Set x(1:n) = 0, x(j) = 1, and */
/*                       scale = 0 and compute a solution to A**H *x = 0. */

			pzlaset_(" ", n, &c__1, &c_b1, &c_b1, &x[1], ix, jx, &
				descx[1], (ftnlen)1);
			if (myrow == itmp1x && mycol == itmp2x) {
			    i__3 = irowx;
			    x[i__3].r = 1., x[i__3].i = 0.;
			}
			xjtmp.r = 1., xjtmp.i = 0.;
			*scale = 0.;
			xmax = 0.;
		    }
L130:
		    ;
		} else {

/*                 Compute x(j) := x(j) / A(j,j) - CSUMJ if the dot */
/*                 product has already been divided by 1/A(j,j). */

/*                 X( J ) = ZLADIV( X( J ), TJJS ) - CSUMJ */
		    zladiv_(&z__2, &xjtmp, &tjjs);
		    z__1.r = z__2.r - csumj.r, z__1.i = z__2.i - csumj.i;
		    xjtmp.r = z__1.r, xjtmp.i = z__1.i;
		    if (myrow == itmp1x && mycol == itmp2x) {
			i__3 = irowx;
			x[i__3].r = xjtmp.r, x[i__3].i = xjtmp.i;
		    }
		}
/* Computing MAX */
		d__3 = xmax, d__4 = (d__1 = xjtmp.r, abs(d__1)) + (d__2 = 
			d_imag(&xjtmp), abs(d__2));
		xmax = max(d__3,d__4);
/* L140: */
	    }
	}
	*scale /= tscal;
    }

/*     Scale the column norms by 1/TSCAL for return. */

    if (tscal != 1.) {
	d__1 = 1. / tscal;
	lfc_SLdscal(n, &d__1, &cnorm[1], &c__1);
    }

    return 0;

/*     End of PZLATTRS */

} /* pzlattrs_ */

