/* /home4/luszczek/mscratch/build/SCALAPACK/SRC/pzlarfg.f -- translated by f2c (version 20031025).
   You must link the resulting object file with libf2c:
	on Microsoft Windows system, link with libf2c.lib;
	on Linux or Unix systems, link with .../path/to/libf2c.a -lm
	or, if you install libf2c.a in a standard place, with -lf2c -lm
	-- in that order, at the end of the command line, as in
		cc *.o -lf2c -lm
	Source for libf2c is in /netlib/f2c/libf2c.zip, e.g.,

		http://www.netlib.org/f2c/libf2c.zip
*/

#include "f2c.h"

/* Table of constant values */

static integer c__1 = 1;
static doublecomplex c_b24 = {1.,0.};

/* Subroutine */ int pzlarfg_(integer *n, doublecomplex *alpha, integer *iax, 
	integer *jax, doublecomplex *x, integer *ix, integer *jx, integer *
	descx, integer *incx, doublecomplex *tau)
{
    /* System generated locals */
    integer i__1;
    doublereal d__1, d__2;
    doublecomplex z__1, z__2;

    /* Builtin functions */
    double d_imag(doublecomplex *), d_sign(doublereal *, doublereal *);

    /* Local variables */
    integer j, knt;
    doublereal beta;
    integer iiax, jjax;
    doublereal alphi, alphr;
    integer npcol, ixcol, mycol, ictxt;
    doublereal xnorm;
    integer nprow, ixrow, myrow;
    extern doublereal dlapy3_(doublereal *, doublereal *, doublereal *), 
	    dlamch_(char *, ftnlen);
    doublereal safmin, rsafmn;
    extern /* Double Complex */ VOID zladiv_(doublecomplex *, doublecomplex *,
	     doublecomplex *);
    extern /* Subroutine */ int pzscal_(integer *, doublecomplex *, 
	    doublecomplex *, integer *, integer *, integer *, integer *), 
	    blacs_gridinfo__(integer *, integer *, integer *, integer *, 
	    integer *), zgebr2d_(integer *, char *, char *, integer *, 
	    integer *, doublecomplex *, integer *, integer *, integer *, 
	    ftnlen, ftnlen), infog2l_(integer *, integer *, integer *, 
	    integer *, integer *, integer *, integer *, integer *, integer *, 
	    integer *, integer *), zgebs2d_(integer *, char *, char *, 
	    integer *, integer *, doublecomplex *, integer *, ftnlen, ftnlen),
	     pdznrm2_(integer *, doublereal *, doublecomplex *, integer *, 
	    integer *, integer *, integer *), pzdscal_(integer *, doublereal *
	    , doublecomplex *, integer *, integer *, integer *, integer *);
    integer indxtau;


/*  -- ScaLAPACK auxiliary routine (version 1.7) -- */
/*     University of Tennessee, Knoxville, Oak Ridge National Laboratory, */
/*     and University of California, Berkeley. */
/*     May 1, 1997 */

/*     .. Scalar Arguments .. */
/*     .. */
/*     .. Array Arguments .. */
/*     .. */

/*  Purpose */
/*  ======= */

/*  PZLARFG generates a complex elementary reflector H of order n, such */
/*  that */

/*     H * sub( X ) = H * ( x(iax,jax) ) = ( alpha ),   H' * H = I. */
/*                        (      x     )   (   0   ) */

/*  where alpha is a real scalar, and sub( X ) is an (N-1)-element */
/*  complex distributed vector X(IX:IX+N-2,JX) if INCX = 1 and */
/*  X(IX,JX:JX+N-2) if INCX = DESCX(M_).  H is represented in the form */

/*        H = I - tau * ( 1 ) * ( 1 v' ) , */
/*                      ( v ) */

/*  where tau is a complex scalar and v is a complex (N-1)-element */
/*  vector. Note that H is not Hermitian. */

/*  If the elements of sub( X ) are all zero and X(IAX,JAX) is real, */
/*  then tau = 0 and H is taken to be the unit matrix. */

/*  Otherwise  1 <= real(tau) <= 2 and abs(tau-1) <= 1. */

/*  Notes */
/*  ===== */

/*  Each global data object is described by an associated description */
/*  vector.  This vector stores the information required to establish */
/*  the mapping between an object element and its corresponding process */
/*  and memory location. */

/*  Let A be a generic term for any 2D block cyclicly distributed array. */
/*  Such a global array has an associated description vector DESCA. */
/*  In the following comments, the character _ should be read as */
/*  "of the global array". */

/*  NOTATION        STORED IN      EXPLANATION */
/*  --------------- -------------- -------------------------------------- */
/*  DTYPE_A(global) DESCA( DTYPE_ )The descriptor type.  In this case, */
/*                                 DTYPE_A = 1. */
/*  CTXT_A (global) DESCA( CTXT_ ) The BLACS context handle, indicating */
/*                                 the BLACS process grid A is distribu- */
/*                                 ted over. The context itself is glo- */
/*                                 bal, but the handle (the integer */
/*                                 value) may vary. */
/*  M_A    (global) DESCA( M_ )    The number of rows in the global */
/*                                 array A. */
/*  N_A    (global) DESCA( N_ )    The number of columns in the global */
/*                                 array A. */
/*  MB_A   (global) DESCA( MB_ )   The blocking factor used to distribute */
/*                                 the rows of the array. */
/*  NB_A   (global) DESCA( NB_ )   The blocking factor used to distribute */
/*                                 the columns of the array. */
/*  RSRC_A (global) DESCA( RSRC_ ) The process row over which the first */
/*                                 row of the array A is distributed. */
/*  CSRC_A (global) DESCA( CSRC_ ) The process column over which the */
/*                                 first column of the array A is */
/*                                 distributed. */
/*  LLD_A  (local)  DESCA( LLD_ )  The leading dimension of the local */
/*                                 array.  LLD_A >= MAX(1,LOCr(M_A)). */

/*  Let K be the number of rows or columns of a distributed matrix, */
/*  and assume that its process grid has dimension p x q. */
/*  LOCr( K ) denotes the number of elements of K that a process */
/*  would receive if K were distributed over the p processes of its */
/*  process column. */
/*  Similarly, LOCc( K ) denotes the number of elements of K that a */
/*  process would receive if K were distributed over the q processes of */
/*  its process row. */
/*  The values of LOCr() and LOCc() may be determined via a call to the */
/*  ScaLAPACK tool function, NUMROC: */
/*          LOCr( M ) = NUMROC( M, MB_A, MYROW, RSRC_A, NPROW ), */
/*          LOCc( N ) = NUMROC( N, NB_A, MYCOL, CSRC_A, NPCOL ). */
/*  An upper bound for these quantities may be computed by: */
/*          LOCr( M ) <= ceil( ceil(M/MB_A)/NPROW )*MB_A */
/*          LOCc( N ) <= ceil( ceil(N/NB_A)/NPCOL )*NB_A */

/*  Because vectors may be viewed as a subclass of matrices, a */
/*  distributed vector is considered to be a distributed matrix. */

/*  Arguments */
/*  ========= */

/*  N       (global input) INTEGER */
/*          The global order of the elementary reflector. N >= 0. */

/*  ALPHA   (local output) COMPLEX*16 */
/*          On exit, alpha is computed in the process scope having the */
/*          vector sub( X ). */

/*  IAX     (global input) INTEGER */
/*          The global row index in X of X(IAX,JAX). */

/*  JAX     (global input) INTEGER */
/*          The global column index in X of X(IAX,JAX). */

/*  X       (local input/local output) COMPLEX*16, pointer into the */
/*          local memory to an array of dimension (LLD_X,*). This array */
/*          contains the local pieces of the distributed vector sub( X ). */
/*          Before entry, the incremented array sub( X ) must contain */
/*          the vector x. On exit, it is overwritten with the vector v. */

/*  IX      (global input) INTEGER */
/*          The row index in the global array X indicating the first */
/*          row of sub( X ). */

/*  JX      (global input) INTEGER */
/*          The column index in the global array X indicating the */
/*          first column of sub( X ). */

/*  DESCX   (global and local input) INTEGER array of dimension DLEN_. */
/*          The array descriptor for the distributed matrix X. */

/*  INCX    (global input) INTEGER */
/*          The global increment for the elements of X. Only two values */
/*          of INCX are supported in this version, namely 1 and M_X. */
/*          INCX must not be zero. */

/*  TAU     (local output) COMPLEX*16, array, dimension  LOCc(JX) */
/*          if INCX = 1, and LOCr(IX) otherwise. This array contains the */
/*          Householder scalars related to the Householder vectors. */
/*          TAU is tied to the distributed matrix X. */

/*  ===================================================================== */

/*     .. Parameters .. */
/*     .. */
/*     .. Local Scalars .. */
/*     .. */
/*     .. External Subroutines .. */
/*     .. */
/*     .. External Functions .. */
/*     .. */
/*     .. Intrinsic Functions .. */
/*     .. */
/*     .. Executable Statements .. */

/*     Get grid parameters. */

    /* Parameter adjustments */
    --tau;
    --descx;
    --x;

    /* Function Body */
    ictxt = descx[2];
    blacs_gridinfo__(&ictxt, &nprow, &npcol, &myrow, &mycol);

    if (*incx == descx[3]) {

/*        sub( X ) is distributed across a process row. */

	infog2l_(ix, jax, &descx[1], &nprow, &npcol, &myrow, &mycol, &iiax, &
		jjax, &ixrow, &ixcol);

	if (myrow != ixrow) {
	    return 0;
	}

/*        Broadcast X(IAX,JAX) across the process row. */

	if (mycol == ixcol) {
	    j = iiax + (jjax - 1) * descx[9];
	    zgebs2d_(&ictxt, "Rowwise", " ", &c__1, &c__1, &x[j], &c__1, (
		    ftnlen)7, (ftnlen)1);
	    i__1 = j;
	    alpha->r = x[i__1].r, alpha->i = x[i__1].i;
	} else {
	    zgebr2d_(&ictxt, "Rowwise", " ", &c__1, &c__1, alpha, &c__1, &
		    myrow, &ixcol, (ftnlen)7, (ftnlen)1);
	}

	indxtau = iiax;

    } else {

/*        sub( X ) is distributed across a process column. */

	infog2l_(iax, jx, &descx[1], &nprow, &npcol, &myrow, &mycol, &iiax, &
		jjax, &ixrow, &ixcol);

	if (mycol != ixcol) {
	    return 0;
	}

/*        Broadcast X(IAX,JAX) across the process column. */

	if (myrow == ixrow) {
	    j = iiax + (jjax - 1) * descx[9];
	    zgebs2d_(&ictxt, "Columnwise", " ", &c__1, &c__1, &x[j], &c__1, (
		    ftnlen)10, (ftnlen)1);
	    i__1 = j;
	    alpha->r = x[i__1].r, alpha->i = x[i__1].i;
	} else {
	    zgebr2d_(&ictxt, "Columnwise", " ", &c__1, &c__1, alpha, &c__1, &
		    ixrow, &mycol, (ftnlen)10, (ftnlen)1);
	}

	indxtau = jjax;

    }

    if (*n <= 0) {
	i__1 = indxtau;
	tau[i__1].r = 0., tau[i__1].i = 0.;
	return 0;
    }

    i__1 = *n - 1;
    pdznrm2_(&i__1, &xnorm, &x[1], ix, jx, &descx[1], incx);
    alphr = alpha->r;
    alphi = d_imag(alpha);

    if (xnorm == 0. && alphi == 0.) {

/*        H = I */

	i__1 = indxtau;
	tau[i__1].r = 0., tau[i__1].i = 0.;

    } else {

/*        General case */

	d__1 = dlapy3_(&alphr, &alphi, &xnorm);
	beta = -d_sign(&d__1, &alphr);
	safmin = dlamch_("S", (ftnlen)1);
	rsafmn = 1. / safmin;
	if (abs(beta) < safmin) {

/*           XNORM, BETA may be inaccurate; scale X and recompute them */

	    knt = 0;
L10:
	    ++knt;
	    i__1 = *n - 1;
	    pzdscal_(&i__1, &rsafmn, &x[1], ix, jx, &descx[1], incx);
	    beta *= rsafmn;
	    alphi *= rsafmn;
	    alphr *= rsafmn;
	    if (abs(beta) < safmin) {
		goto L10;
	    }

/*           New BETA is at most 1, at least SAFMIN */

	    i__1 = *n - 1;
	    pdznrm2_(&i__1, &xnorm, &x[1], ix, jx, &descx[1], incx);
	    z__1.r = alphr, z__1.i = alphi;
	    alpha->r = z__1.r, alpha->i = z__1.i;
	    d__1 = dlapy3_(&alphr, &alphi, &xnorm);
	    beta = -d_sign(&d__1, &alphr);
	    i__1 = indxtau;
	    d__1 = (beta - alphr) / beta;
	    d__2 = -alphi / beta;
	    z__1.r = d__1, z__1.i = d__2;
	    tau[i__1].r = z__1.r, tau[i__1].i = z__1.i;
	    z__2.r = alpha->r - beta, z__2.i = alpha->i;
	    zladiv_(&z__1, &c_b24, &z__2);
	    alpha->r = z__1.r, alpha->i = z__1.i;
	    i__1 = *n - 1;
	    pzscal_(&i__1, alpha, &x[1], ix, jx, &descx[1], incx);

/*           If ALPHA is subnormal, it may lose relative accuracy */

	    alpha->r = beta, alpha->i = 0.;
	    i__1 = knt;
	    for (j = 1; j <= i__1; ++j) {
		z__1.r = safmin * alpha->r, z__1.i = safmin * alpha->i;
		alpha->r = z__1.r, alpha->i = z__1.i;
/* L20: */
	    }
	} else {
	    i__1 = indxtau;
	    d__1 = (beta - alphr) / beta;
	    d__2 = -alphi / beta;
	    z__1.r = d__1, z__1.i = d__2;
	    tau[i__1].r = z__1.r, tau[i__1].i = z__1.i;
	    z__2.r = alpha->r - beta, z__2.i = alpha->i;
	    zladiv_(&z__1, &c_b24, &z__2);
	    alpha->r = z__1.r, alpha->i = z__1.i;
	    i__1 = *n - 1;
	    pzscal_(&i__1, alpha, &x[1], ix, jx, &descx[1], incx);
	    alpha->r = beta, alpha->i = 0.;
	}
    }

    return 0;

/*     End of PZLARFG */

} /* pzlarfg_ */

