/* /home4/luszczek/mscratch/build/SCALAPACK/SRC/pzlaqsy.f -- translated by f2c (version 20031025).
   You must link the resulting object file with libf2c:
	on Microsoft Windows system, link with libf2c.lib;
	on Linux or Unix systems, link with .../path/to/libf2c.a -lm
	or, if you install libf2c.a in a standard place, with -lf2c -lm
	-- in that order, at the end of the command line, as in
		cc *.o -lf2c -lm
	Source for libf2c is in /netlib/f2c/libf2c.zip, e.g.,

		http://www.netlib.org/f2c/libf2c.zip
*/

#include "f2c.h"

/* Subroutine */ int pzlaqsy_(char *uplo, integer *n, doublecomplex *a, 
	integer *ia, integer *ja, integer *desca, doublereal *sr, doublereal *
	sc, doublereal *scond, doublereal *amax, char *equed, ftnlen uplo_len,
	 ftnlen equed_len)
{
    /* System generated locals */
    integer i__1, i__2, i__3, i__4, i__5, i__6;
    doublereal d__1;
    doublecomplex z__1;

    /* Local variables */
    integer j, jb;
    doublereal cj;
    integer ii, jj, kk, jn, ll, np, lda, iia, jja, ioffa;
    extern integer iceil_(integer *, integer *);
    integer iacol;
    doublereal large;
    extern logical lsame_(char *, char *, ftnlen, ftnlen);
    integer iroff;
    doublereal small;
    integer npcol, iarow, mycol, ictxt, nprow, myrow;
    extern /* Subroutine */ int blacs_gridinfo__(integer *, integer *, 
	    integer *, integer *, integer *);
    extern integer numroc_(integer *, integer *, integer *, integer *, 
	    integer *);
    extern /* Subroutine */ int infog2l_(integer *, integer *, integer *, 
	    integer *, integer *, integer *, integer *, integer *, integer *, 
	    integer *, integer *);
    extern doublereal pdlamch_(integer *, char *, ftnlen);


/*  -- ScaLAPACK auxiliary routine (version 1.7) -- */
/*     University of Tennessee, Knoxville, Oak Ridge National Laboratory, */
/*     and University of California, Berkeley. */
/*     May 1, 1997 */

/*     .. Scalar Arguments .. */
/*     .. */
/*     .. Array Arguments .. */
/*     .. */

/*  Purpose */
/*  ======= */

/*  PZLAQSY equilibrates a symmetric distributed matrix */
/*  sub( A ) = A(IA:IA+N-1,JA:JA+N-1) using the scaling factors in the */
/*  vectors SR and SC. */

/*  Notes */
/*  ===== */

/*  Each global data object is described by an associated description */
/*  vector.  This vector stores the information required to establish */
/*  the mapping between an object element and its corresponding process */
/*  and memory location. */

/*  Let A be a generic term for any 2D block cyclicly distributed array. */
/*  Such a global array has an associated description vector DESCA. */
/*  In the following comments, the character _ should be read as */
/*  "of the global array". */

/*  NOTATION        STORED IN      EXPLANATION */
/*  --------------- -------------- -------------------------------------- */
/*  DTYPE_A(global) DESCA( DTYPE_ )The descriptor type.  In this case, */
/*                                 DTYPE_A = 1. */
/*  CTXT_A (global) DESCA( CTXT_ ) The BLACS context handle, indicating */
/*                                 the BLACS process grid A is distribu- */
/*                                 ted over. The context itself is glo- */
/*                                 bal, but the handle (the integer */
/*                                 value) may vary. */
/*  M_A    (global) DESCA( M_ )    The number of rows in the global */
/*                                 array A. */
/*  N_A    (global) DESCA( N_ )    The number of columns in the global */
/*                                 array A. */
/*  MB_A   (global) DESCA( MB_ )   The blocking factor used to distribute */
/*                                 the rows of the array. */
/*  NB_A   (global) DESCA( NB_ )   The blocking factor used to distribute */
/*                                 the columns of the array. */
/*  RSRC_A (global) DESCA( RSRC_ ) The process row over which the first */
/*                                 row of the array A is distributed. */
/*  CSRC_A (global) DESCA( CSRC_ ) The process column over which the */
/*                                 first column of the array A is */
/*                                 distributed. */
/*  LLD_A  (local)  DESCA( LLD_ )  The leading dimension of the local */
/*                                 array.  LLD_A >= MAX(1,LOCr(M_A)). */

/*  Let K be the number of rows or columns of a distributed matrix, */
/*  and assume that its process grid has dimension p x q. */
/*  LOCr( K ) denotes the number of elements of K that a process */
/*  would receive if K were distributed over the p processes of its */
/*  process column. */
/*  Similarly, LOCc( K ) denotes the number of elements of K that a */
/*  process would receive if K were distributed over the q processes of */
/*  its process row. */
/*  The values of LOCr() and LOCc() may be determined via a call to the */
/*  ScaLAPACK tool function, NUMROC: */
/*          LOCr( M ) = NUMROC( M, MB_A, MYROW, RSRC_A, NPROW ), */
/*          LOCc( N ) = NUMROC( N, NB_A, MYCOL, CSRC_A, NPCOL ). */
/*  An upper bound for these quantities may be computed by: */
/*          LOCr( M ) <= ceil( ceil(M/MB_A)/NPROW )*MB_A */
/*          LOCc( N ) <= ceil( ceil(N/NB_A)/NPCOL )*NB_A */

/*  Arguments */
/*  ========= */

/*  UPLO    (global input) CHARACTER */
/*          Specifies whether the upper or lower triangular part of the */
/*          symmetric distributed matrix sub( A ) is to be referenced: */
/*             = 'U':  Upper triangular */
/*             = 'L':  Lower triangular */

/*  N       (global input) INTEGER */
/*          The number of rows and columns to be operated on, i.e. the */
/*          order of the distributed submatrix sub( A ). N >= 0. */

/*  A       (input/output) COMPLEX*16 pointer into the local */
/*          memory to an array of local dimension (LLD_A,LOCc(JA+N-1)). */
/*          On entry, the local pieces of the distributed symmetric */
/*          matrix sub( A ). If UPLO = 'U', the leading N-by-N upper */
/*          triangular part of sub( A ) contains the upper triangular */
/*          part of the matrix, and the strictly lower triangular part */
/*          of sub( A ) is not referenced.  If UPLO = 'L', the leading */
/*          N-by-N lower triangular part of sub( A ) contains the lower */
/*          triangular part of the matrix, and the strictly upper trian- */
/*          gular part of sub( A ) is not referenced. */
/*          On exit, if EQUED = 'Y', the equilibrated matrix: */
/*              diag(SR(IA:IA+N-1)) * sub( A ) * diag(SC(JA:JA+N-1)). */

/*  IA      (global input) INTEGER */
/*          The row index in the global array A indicating the first */
/*          row of sub( A ). */

/*  JA      (global input) INTEGER */
/*          The column index in the global array A indicating the */
/*          first column of sub( A ). */

/*  DESCA   (global and local input) INTEGER array of dimension DLEN_. */
/*          The array descriptor for the distributed matrix A. */

/*  SR      (local input) DOUBLE PRECISION array, dimension LOCr(M_A) */
/*          The scale factors for A(IA:IA+M-1,JA:JA+N-1). SR is aligned */
/*          with the distributed matrix A, and replicated across every */
/*          process column. SR is tied to the distributed matrix A. */

/*  SC      (local input) DOUBLE PRECISION array, dimension LOCc(N_A) */
/*          The scale factors for sub( A ). SC is aligned with the dis- */
/*          tributed matrix A, and replicated down every process row. */
/*          SC is tied to the distributed matrix A. */

/*  SCOND   (global input) DOUBLE PRECISION */
/*          Ratio of the smallest SR(i) (respectively SC(j)) to the */
/*          largest SR(i) (respectively SC(j)), with IA <= i <= IA+N-1 */
/*          and JA <= j <= JA+N-1. */

/*  AMAX    (global input) DOUBLE PRECISION */
/*          Absolute value of the largest distributed submatrix entry. */

/*  EQUED   (output) CHARACTER*1 */
/*          Specifies whether or not equilibration was done. */
/*          = 'N':  No equilibration. */
/*          = 'Y':  Equilibration was done, i.e., sub( A ) has been re- */
/*                  placed by: */
/*                  diag(SR(IA:IA+N-1)) * sub( A ) * diag(SC(JA:JA+N-1)). */

/*  Internal Parameters */
/*  =================== */

/*  THRESH is a threshold value used to decide if scaling should be done */
/*  based on the ratio of the scaling factors.  If SCOND < THRESH, */
/*  scaling is done. */

/*  LARGE and SMALL are threshold values used to decide if scaling should */
/*  be done based on the absolute size of the largest matrix element. */
/*  If AMAX > LARGE or AMAX < SMALL, scaling is done. */

/*  ===================================================================== */

/*     .. Parameters .. */
/*     .. */
/*     .. Local Scalars .. */
/*     .. */
/*     .. External Subroutines .. */
/*     .. */
/*     .. External Functions .. */
/*     .. */
/*     .. Intrinsic Functions .. */
/*     .. */
/*     .. Executable Statements .. */

/*     Quick return if possible */

    /* Parameter adjustments */
    --sc;
    --sr;
    --desca;
    --a;

    /* Function Body */
    if (*n <= 0) {
	*(unsigned char *)equed = 'N';
	return 0;
    }

/*     Get grid parameters and compute local indexes */

    ictxt = desca[2];
    blacs_gridinfo__(&ictxt, &nprow, &npcol, &myrow, &mycol);
    infog2l_(ia, ja, &desca[1], &nprow, &npcol, &myrow, &mycol, &iia, &jja, &
	    iarow, &iacol);
    lda = desca[9];

/*     Initialize LARGE and SMALL. */

    small = pdlamch_(&ictxt, "Safe minimum", (ftnlen)12) / pdlamch_(&ictxt, 
	    "Precision", (ftnlen)9);
    large = 1. / small;

    if (*scond >= .1 && *amax >= small && *amax <= large) {

/*        No equilibration */

	*(unsigned char *)equed = 'N';

    } else {

	ii = iia;
	jj = jja;
/* Computing MIN */
	i__1 = iceil_(ja, &desca[6]) * desca[6], i__2 = *ja + *n - 1;
	jn = min(i__1,i__2);
	jb = jn - *ja + 1;

/*        Replace A by diag(S) * A * diag(S). */

	if (lsame_(uplo, "U", (ftnlen)1, (ftnlen)1)) {

/*           Upper triangle of A(IA:IA+N-1,JA:JA+N-1) is stored. */
/*           Handle first block separately */

	    ioffa = (jj - 1) * lda;
	    if (mycol == iacol) {
		if (myrow == iarow) {
		    i__1 = jj + jb - 1;
		    for (ll = jj; ll <= i__1; ++ll) {
			cj = sc[ll];
			i__2 = ii + ll - jj + 1;
			for (kk = iia; kk <= i__2; ++kk) {
			    i__3 = ioffa + kk;
			    d__1 = cj * sr[kk];
			    i__4 = ioffa + kk;
			    z__1.r = d__1 * a[i__4].r, z__1.i = d__1 * a[i__4]
				    .i;
			    a[i__3].r = z__1.r, a[i__3].i = z__1.i;
/* L10: */
			}
			ioffa += lda;
/* L20: */
		    }
		} else {
		    ioffa += jb * lda;
		}
		jj += jb;
	    }

	    if (myrow == iarow) {
		ii += jb;
	    }
	    iarow = (iarow + 1) % nprow;
	    iacol = (iacol + 1) % npcol;

/*           Loop over remaining block of columns */

	    i__1 = *ja + *n - 1;
	    i__2 = desca[6];
	    for (j = jn + 1; i__2 < 0 ? j >= i__1 : j <= i__1; j += i__2) {
/* Computing MIN */
		i__3 = *ja + *n - j;
		jb = min(i__3,desca[6]);

		if (mycol == iacol) {
		    if (myrow == iarow) {
			i__3 = jj + jb - 1;
			for (ll = jj; ll <= i__3; ++ll) {
			    cj = sc[ll];
			    i__4 = ii + ll - jj + 1;
			    for (kk = iia; kk <= i__4; ++kk) {
				i__5 = ioffa + kk;
				d__1 = cj * sr[kk];
				i__6 = ioffa + kk;
				z__1.r = d__1 * a[i__6].r, z__1.i = d__1 * a[
					i__6].i;
				a[i__5].r = z__1.r, a[i__5].i = z__1.i;
/* L30: */
			    }
			    ioffa += lda;
/* L40: */
			}
		    } else {
			i__3 = jj + jb - 1;
			for (ll = jj; ll <= i__3; ++ll) {
			    cj = sc[ll];
			    i__4 = ii - 1;
			    for (kk = iia; kk <= i__4; ++kk) {
				i__5 = ioffa + kk;
				d__1 = cj * sr[kk];
				i__6 = ioffa + kk;
				z__1.r = d__1 * a[i__6].r, z__1.i = d__1 * a[
					i__6].i;
				a[i__5].r = z__1.r, a[i__5].i = z__1.i;
/* L50: */
			    }
			    ioffa += lda;
/* L60: */
			}
		    }
		    jj += jb;
		}

		if (myrow == iarow) {
		    ii += jb;
		}
		iarow = (iarow + 1) % nprow;
		iacol = (iacol + 1) % npcol;

/* L70: */
	    }

	} else {

/*           Lower triangle of A(IA:IA+N-1,JA:JA+N-1) is stored. */
/*           Handle first block separately */

	    iroff = (*ia - 1) % desca[5];
	    i__2 = *n + iroff;
	    np = numroc_(&i__2, &desca[5], &myrow, &iarow, &nprow);
	    if (myrow == iarow) {
		np -= iroff;
	    }

	    ioffa = (jj - 1) * lda;
	    if (mycol == iacol) {
		if (myrow == iarow) {
		    i__2 = jj + jb - 1;
		    for (ll = jj; ll <= i__2; ++ll) {
			cj = sc[ll];
			i__1 = iia + np - 1;
			for (kk = ii + ll - jj; kk <= i__1; ++kk) {
			    i__3 = ioffa + kk;
			    d__1 = cj * sr[kk];
			    i__4 = ioffa + kk;
			    z__1.r = d__1 * a[i__4].r, z__1.i = d__1 * a[i__4]
				    .i;
			    a[i__3].r = z__1.r, a[i__3].i = z__1.i;
/* L80: */
			}
			ioffa += lda;
/* L90: */
		    }
		} else {
		    i__2 = jj + jb - 1;
		    for (ll = jj; ll <= i__2; ++ll) {
			cj = sc[ll];
			i__1 = iia + np - 1;
			for (kk = ii; kk <= i__1; ++kk) {
			    i__3 = ioffa + kk;
			    d__1 = cj * sr[kk];
			    i__4 = ioffa + kk;
			    z__1.r = d__1 * a[i__4].r, z__1.i = d__1 * a[i__4]
				    .i;
			    a[i__3].r = z__1.r, a[i__3].i = z__1.i;
/* L100: */
			}
			ioffa += lda;
/* L110: */
		    }
		}
		jj += jb;
	    }

	    if (myrow == iarow) {
		ii += jb;
	    }
	    iarow = (iarow + 1) % nprow;
	    iacol = (iacol + 1) % npcol;

/*           Loop over remaining block of columns */

	    i__2 = *ja + *n - 1;
	    i__1 = desca[6];
	    for (j = jn + 1; i__1 < 0 ? j >= i__2 : j <= i__2; j += i__1) {
/* Computing MIN */
		i__3 = *ja + *n - j;
		jb = min(i__3,desca[6]);

		if (mycol == iacol) {
		    if (myrow == iarow) {
			i__3 = jj + jb - 1;
			for (ll = jj; ll <= i__3; ++ll) {
			    cj = sc[ll];
			    i__4 = iia + np - 1;
			    for (kk = ii + ll - jj; kk <= i__4; ++kk) {
				i__5 = ioffa + kk;
				d__1 = cj * sr[kk];
				i__6 = ioffa + kk;
				z__1.r = d__1 * a[i__6].r, z__1.i = d__1 * a[
					i__6].i;
				a[i__5].r = z__1.r, a[i__5].i = z__1.i;
/* L120: */
			    }
			    ioffa += lda;
/* L130: */
			}
		    } else {
			i__3 = jj + jb - 1;
			for (ll = jj; ll <= i__3; ++ll) {
			    cj = sc[ll];
			    i__4 = iia + np - 1;
			    for (kk = ii; kk <= i__4; ++kk) {
				i__5 = ioffa + kk;
				d__1 = cj * sr[kk];
				i__6 = ioffa + kk;
				z__1.r = d__1 * a[i__6].r, z__1.i = d__1 * a[
					i__6].i;
				a[i__5].r = z__1.r, a[i__5].i = z__1.i;
/* L140: */
			    }
			    ioffa += lda;
/* L150: */
			}
		    }
		    jj += jb;
		}

		if (myrow == iarow) {
		    ii += jb;
		}
		iarow = (iarow + 1) % nprow;
		iacol = (iacol + 1) % npcol;

/* L160: */
	    }

	}

	*(unsigned char *)equed = 'Y';

    }

    return 0;

/*     End of PZLAQSY */

} /* pzlaqsy_ */

