/* /home4/luszczek/mscratch/build/SCALAPACK/SRC/pzlanhe.f -- translated by f2c (version 20031025).
   You must link the resulting object file with libf2c:
	on Microsoft Windows system, link with libf2c.lib;
	on Linux or Unix systems, link with .../path/to/libf2c.a -lm
	or, if you install libf2c.a in a standard place, with -lf2c -lm
	-- in that order, at the end of the command line, as in
		cc *.o -lf2c -lm
	Source for libf2c is in /netlib/f2c/libf2c.zip, e.g.,

		http://www.netlib.org/f2c/libf2c.zip
*/

#include "f2c.h"

/* Table of constant values */

static integer c__1 = 1;
static integer c_n1 = -1;
static doublereal c_b66 = 1.;
static integer c__2 = 2;

doublereal pzlanhe_(char *norm, char *uplo, integer *n, doublecomplex *a, 
	integer *ia, integer *ja, integer *desca, doublereal *work, ftnlen 
	norm_len, ftnlen uplo_len)
{
    /* System generated locals */
    integer i__1, i__2, i__3, i__4, i__5;
    doublereal ret_val, d__1, d__2, d__3;

    /* Builtin functions */
    double z_abs(doublecomplex *), sqrt(doublereal);

    /* Local variables */
    extern /* Subroutine */ int dcombssq_();
    integer i__, k;
    extern /* Subroutine */ int pdcol2row_(integer *, integer *, integer *, 
	    integer *, doublereal *, integer *, doublereal *, integer *, 
	    integer *, integer *, integer *, integer *, doublereal *);
    integer ib, ii, jj, in, ll, np, nq;
    extern /* Subroutine */ int pdtreecomb_(integer *, char *, integer *, 
	    doublereal *, integer *, integer *, U_fp, ftnlen);
    integer lda, iia, jja;
    doublereal sum, absa;
    integer icsr, irsc, irsr, icsr0, irsc0, irsr0, ioffa;
    extern integer iceil_(integer *, integer *);
    integer icoff, iacol;
    doublereal scale;
    extern logical lsame_(char *, char *, ftnlen, ftnlen);
    integer iroff, npcol;
    doublereal value;
    integer iarow, mycol;
    extern /* Subroutine */ int lfc_SLdaxpy(integer *, doublereal *, doublereal *, 
	    integer *, doublereal *, integer *);
    integer ictxt;
    doublereal rwork[2];
    integer nprow, myrow;
    extern integer lfc_SLidamax(integer *, doublereal *, integer *);
    extern /* Subroutine */ int blacs_gridinfo__(integer *, integer *, 
	    integer *, integer *, integer *);
    extern integer numroc_(integer *, integer *, integer *, integer *, 
	    integer *);
    extern /* Subroutine */ int dgebr2d_(integer *, char *, char *, integer *,
	     integer *, doublereal *, integer *, integer *, integer *, ftnlen,
	     ftnlen), dgebs2d_(integer *, char *, char *, integer *, integer *
	    , doublereal *, integer *, ftnlen, ftnlen), zlassq_(integer *, 
	    doublecomplex *, integer *, doublereal *, doublereal *), dgamx2d_(
	    integer *, char *, char *, integer *, integer *, doublereal *, 
	    integer *, integer *, integer *, integer *, integer *, integer *, 
	    ftnlen, ftnlen), infog2l_(integer *, integer *, integer *, 
	    integer *, integer *, integer *, integer *, integer *, integer *, 
	    integer *, integer *), dgsum2d_(integer *, char *, char *, 
	    integer *, integer *, doublereal *, integer *, integer *, integer 
	    *, ftnlen, ftnlen);
    integer icurcol, icurrow;


/*  -- ScaLAPACK auxiliary routine (version 1.7) -- */
/*     University of Tennessee, Knoxville, Oak Ridge National Laboratory, */
/*     and University of California, Berkeley. */
/*     May 1, 1997 */

/*     .. Scalar Arguments .. */
/*     .. */
/*     .. Array Arguments .. */
/*     .. */

/*  Purpose */
/*  ======= */

/*  PZLANHE returns the value of the one norm, or the Frobenius norm, */
/*  or the infinity norm, or the element of largest absolute value of a */
/*  complex hermitian distributed matrix sub(A) = A(IA:IA+N-1,JA:JA+N-1). */

/*  PZLANHE returns the value */

/*     ( max(abs(A(i,j))),  NORM = 'M' or 'm' with IA <= i <= IA+N-1, */
/*     (                                      and  JA <= j <= JA+N-1, */
/*     ( */
/*     ( norm1( sub( A ) ), NORM = '1', 'O' or 'o' */
/*     ( */
/*     ( normI( sub( A ) ), NORM = 'I' or 'i' */
/*     ( */
/*     ( normF( sub( A ) ), NORM = 'F', 'f', 'E' or 'e' */

/*  where norm1  denotes the  one norm of a matrix (maximum column sum), */
/*  normI denotes the  infinity norm  of a matrix  (maximum row sum) and */
/*  normF denotes the  Frobenius norm of a matrix (square root of sum of */
/*  squares).  Note that  max(abs(A(i,j)))  is not a  matrix norm. */

/*  Notes */
/*  ===== */

/*  Each global data object is described by an associated description */
/*  vector.  This vector stores the information required to establish */
/*  the mapping between an object element and its corresponding process */
/*  and memory location. */

/*  Let A be a generic term for any 2D block cyclicly distributed array. */
/*  Such a global array has an associated description vector DESCA. */
/*  In the following comments, the character _ should be read as */
/*  "of the global array". */

/*  NOTATION        STORED IN      EXPLANATION */
/*  --------------- -------------- -------------------------------------- */
/*  DTYPE_A(global) DESCA( DTYPE_ )The descriptor type.  In this case, */
/*                                 DTYPE_A = 1. */
/*  CTXT_A (global) DESCA( CTXT_ ) The BLACS context handle, indicating */
/*                                 the BLACS process grid A is distribu- */
/*                                 ted over. The context itself is glo- */
/*                                 bal, but the handle (the integer */
/*                                 value) may vary. */
/*  M_A    (global) DESCA( M_ )    The number of rows in the global */
/*                                 array A. */
/*  N_A    (global) DESCA( N_ )    The number of columns in the global */
/*                                 array A. */
/*  MB_A   (global) DESCA( MB_ )   The blocking factor used to distribute */
/*                                 the rows of the array. */
/*  NB_A   (global) DESCA( NB_ )   The blocking factor used to distribute */
/*                                 the columns of the array. */
/*  RSRC_A (global) DESCA( RSRC_ ) The process row over which the first */
/*                                 row of the array A is distributed. */
/*  CSRC_A (global) DESCA( CSRC_ ) The process column over which the */
/*                                 first column of the array A is */
/*                                 distributed. */
/*  LLD_A  (local)  DESCA( LLD_ )  The leading dimension of the local */
/*                                 array.  LLD_A >= MAX(1,LOCr(M_A)). */

/*  Let K be the number of rows or columns of a distributed matrix, */
/*  and assume that its process grid has dimension p x q. */
/*  LOCr( K ) denotes the number of elements of K that a process */
/*  would receive if K were distributed over the p processes of its */
/*  process column. */
/*  Similarly, LOCc( K ) denotes the number of elements of K that a */
/*  process would receive if K were distributed over the q processes of */
/*  its process row. */
/*  The values of LOCr() and LOCc() may be determined via a call to the */
/*  ScaLAPACK tool function, NUMROC: */
/*          LOCr( M ) = NUMROC( M, MB_A, MYROW, RSRC_A, NPROW ), */
/*          LOCc( N ) = NUMROC( N, NB_A, MYCOL, CSRC_A, NPCOL ). */
/*  An upper bound for these quantities may be computed by: */
/*          LOCr( M ) <= ceil( ceil(M/MB_A)/NPROW )*MB_A */
/*          LOCc( N ) <= ceil( ceil(N/NB_A)/NPCOL )*NB_A */

/*  Arguments */
/*  ========= */

/*  NORM    (global input) CHARACTER */
/*          Specifies the value to be returned in PZLANHE as described */
/*          above. */

/*  UPLO    (global input) CHARACTER */
/*          Specifies whether the upper or lower triangular part of the */
/*          hermitian matrix sub( A ) is to be referenced. */
/*          = 'U':  Upper triangular part of sub( A ) is referenced, */
/*          = 'L':  Lower triangular part of sub( A ) is referenced. */

/*  N       (global input) INTEGER */
/*          The number of rows and columns to be operated on i.e the */
/*          number of rows and columns of the distributed submatrix */
/*          sub( A ). When N = 0, PZLANHE is set to zero. N >= 0. */

/*  A       (local input) COMPLEX*16 pointer into the local memory */
/*          to an array of dimension (LLD_A, LOCc(JA+N-1)) containing the */
/*          local pieces of the hermitian distributed matrix sub( A ). */
/*          If UPLO = 'U', the leading N-by-N upper triangular part of */
/*          sub( A ) contains the upper triangular matrix which norm is */
/*          to be computed, and the strictly lower triangular part of */
/*          this matrix is not referenced.  If UPLO = 'L', the leading */
/*          N-by-N lower triangular part of sub( A ) contains the lower */
/*          triangular matrix which norm is to be computed, and the */
/*          strictly upper triangular part of sub( A ) is not referenced. */

/*  IA      (global input) INTEGER */
/*          The row index in the global array A indicating the first */
/*          row of sub( A ). */

/*  JA      (global input) INTEGER */
/*          The column index in the global array A indicating the */
/*          first column of sub( A ). */

/*  DESCA   (global and local input) INTEGER array of dimension DLEN_. */
/*          The array descriptor for the distributed matrix A. */

/*  WORK    (local workspace) DOUBLE PRECISION array dimension (LWORK) */
/*          LWORK >= 0 if NORM = 'M' or 'm' (not referenced), */
/*                   2*Nq0+Np0+LDW if NORM = '1', 'O', 'o', 'I' or 'i', */
/*                     where LDW is given by: */
/*                     IF( NPROW.NE.NPCOL ) THEN */
/*                        LDW = MB_A*CEIL(CEIL(Np0/MB_A)/(LCM/NPROW)) */
/*                     ELSE */
/*                        LDW = 0 */
/*                     END IF */
/*                   0 if NORM = 'F', 'f', 'E' or 'e' (not referenced), */

/*          where LCM is the least common multiple of NPROW and NPCOL */
/*          LCM = ILCM( NPROW, NPCOL ) and CEIL denotes the ceiling */
/*          operation (ICEIL). */

/*          IROFFA = MOD( IA-1, MB_A ), ICOFFA = MOD( JA-1, NB_A ), */
/*          IAROW = INDXG2P( IA, MB_A, MYROW, RSRC_A, NPROW ), */
/*          IACOL = INDXG2P( JA, NB_A, MYCOL, CSRC_A, NPCOL ), */
/*          Np0 = NUMROC( N+IROFFA, MB_A, MYROW, IAROW, NPROW ), */
/*          Nq0 = NUMROC( N+ICOFFA, NB_A, MYCOL, IACOL, NPCOL ), */

/*          ICEIL, ILCM, INDXG2P and NUMROC are ScaLAPACK tool functions; */
/*          MYROW, MYCOL, NPROW and NPCOL can be determined by calling */
/*          the subroutine BLACS_GRIDINFO. */

/*  ===================================================================== */

/*     .. Parameters .. */
/*     .. */
/*     .. Local Scalars .. */
/*     .. */
/*     .. Local Arrays .. */
/*     .. */
/*     .. External Subroutines .. */
/*     .. */
/*     .. External Functions .. */
/*     .. */
/*     .. Intrinsic Functions .. */
/*     .. */
/*     .. Executable Statements .. */

/*     Get grid parameters and local indexes. */

    /* Parameter adjustments */
    --work;
    --desca;
    --a;

    /* Function Body */
    ictxt = desca[2];
    blacs_gridinfo__(&ictxt, &nprow, &npcol, &myrow, &mycol);
    infog2l_(ia, ja, &desca[1], &nprow, &npcol, &myrow, &mycol, &iia, &jja, &
	    iarow, &iacol);

    iroff = (*ia - 1) % desca[5];
    icoff = (*ja - 1) % desca[6];
    i__1 = *n + iroff;
    np = numroc_(&i__1, &desca[5], &myrow, &iarow, &nprow);
    i__1 = *n + icoff;
    nq = numroc_(&i__1, &desca[6], &mycol, &iacol, &npcol);
    icsr = 1;
    irsr = icsr + nq;
    irsc = irsr + nq;
    if (myrow == iarow) {
	irsc0 = irsc + iroff;
	np -= iroff;
    } else {
	irsc0 = irsc;
    }
    if (mycol == iacol) {
	icsr0 = icsr + icoff;
	irsr0 = irsr + icoff;
	nq -= icoff;
    } else {
	icsr0 = icsr;
	irsr0 = irsr;
    }
/* Computing MIN */
    i__1 = iceil_(ia, &desca[5]) * desca[5], i__2 = *ia + *n - 1;
    in = min(i__1,i__2);
    lda = desca[9];

/*     If the matrix is Hermitian, we address only a triangular portion */
/*     of the matrix.  A sum of row (column) i of the complete matrix */
/*     can be obtained by adding along row i and column i of the the */
/*     triangular matrix, stopping/starting at the diagonal, which is */
/*     the point of reflection.  The pictures below demonstrate this. */
/*     In the following code, the row sums created by --- rows below are */
/*     refered to as ROWSUMS, and the column sums shown by | are refered */
/*     to as COLSUMS. Infinity-norm = 1-norm = ROWSUMS+COLSUMS. */

/*      UPLO = 'U'                        UPLO = 'L' */
/*      ____i______                       ___________ */
/*     |\   |      |                     |\          | */
/*     | \  |      |                     | \         | */
/*     |  \ |      |                     |  \        | */
/*     |   \|------| i                  i|---\       | */
/*     |    \      |                     |   |\      | */
/*     |     \     |                     |   | \     | */
/*     |      \    |                     |   |  \    | */
/*     |       \   |                     |   |   \   | */
/*     |        \  |                     |   |    \  | */
/*     |         \ |                     |   |     \ | */
/*     |__________\|                     |___|______\| */
/*                                           i */

/*     II, JJ  : local indices into array A */
/*     ICURROW : process row containing diagonal block */
/*     ICURCOL : process column containing diagonal block */
/*     IRSC0   : pointer to part of work used to store the ROWSUMS while */
/*               they are stored along a process column */
/*     IRSR0   : pointer to part of work used to store the ROWSUMS after */
/*               they have been transposed to be along a process row */

    ii = iia;
    jj = jja;

    if (*n == 0) {

	value = 0.;

    } else if (lsame_(norm, "M", (ftnlen)1, (ftnlen)1)) {

/*        Find max(abs(A(i,j))). */

	value = 0.;

	if (lsame_(uplo, "U", (ftnlen)1, (ftnlen)1)) {

/*           Handle first block separately */

	    ib = in - *ia + 1;

/*           Find COLMAXS */

	    if (mycol == iacol) {
		i__1 = (jj + ib - 2) * lda;
		i__2 = lda;
		for (k = (jj - 1) * lda; i__2 < 0 ? k >= i__1 : k <= i__1; k 
			+= i__2) {
		    if (ii > iia) {
			i__3 = ii - 1;
			for (ll = iia; ll <= i__3; ++ll) {
/* Computing MAX */
			    d__1 = value, d__2 = z_abs(&a[ll + k]);
			    value = max(d__1,d__2);
/* L10: */
			}
		    }
		    if (myrow == iarow) {
			++ii;
		    }
/* L20: */
		}

/*              Reset local indices so we can find ROWMAXS */

		if (myrow == iarow) {
		    ii -= ib;
		}

	    }

/*           Find ROWMAXS */

	    if (myrow == iarow) {
		i__2 = ii + ib - 1;
		for (k = ii; k <= i__2; ++k) {
		    if (mycol == iacol) {
			if (jj <= jja + nq - 1) {
/* Computing MAX */
			    i__1 = k + (jj - 1) * lda;
			    d__2 = value, d__3 = (d__1 = a[i__1].r, abs(d__1))
				    ;
			    value = max(d__2,d__3);
			    i__1 = (jja + nq - 2) * lda;
			    i__3 = lda;
			    for (ll = jj * lda; i__3 < 0 ? ll >= i__1 : ll <= 
				    i__1; ll += i__3) {
/* Computing MAX */
				d__1 = value, d__2 = z_abs(&a[k + ll]);
				value = max(d__1,d__2);
/* L30: */
			    }
			}
		    } else {
			if (jj <= jja + nq - 1) {
			    i__3 = (jja + nq - 2) * lda;
			    i__1 = lda;
			    for (ll = (jj - 1) * lda; i__1 < 0 ? ll >= i__3 : 
				    ll <= i__3; ll += i__1) {
/* Computing MAX */
				d__1 = value, d__2 = z_abs(&a[k + ll]);
				value = max(d__1,d__2);
/* L35: */
			    }
			}
		    }
		    if (mycol == iacol) {
			++jj;
		    }
/* L40: */
		}
		ii += ib;
	    } else if (mycol == iacol) {
		jj += ib;
	    }

	    icurrow = (iarow + 1) % nprow;
	    icurcol = (iacol + 1) % npcol;

/*           Loop over the remaining rows/columns of the matrix. */

	    i__2 = *ia + *n - 1;
	    i__1 = desca[5];
	    for (i__ = in + 1; i__1 < 0 ? i__ >= i__2 : i__ <= i__2; i__ += 
		    i__1) {
/* Computing MIN */
		i__3 = desca[5], i__4 = *ia + *n - i__;
		ib = min(i__3,i__4);

/*              Find COLMAXS */

		if (mycol == icurcol) {
		    i__3 = (jj + ib - 2) * lda;
		    i__4 = lda;
		    for (k = (jj - 1) * lda; i__4 < 0 ? k >= i__3 : k <= i__3;
			     k += i__4) {
			if (ii > iia) {
			    i__5 = ii - 1;
			    for (ll = iia; ll <= i__5; ++ll) {
/* Computing MAX */
				d__1 = value, d__2 = z_abs(&a[ll + k]);
				value = max(d__1,d__2);
/* L50: */
			    }
			}
			if (myrow == icurrow) {
			    ++ii;
			}
/* L60: */
		    }

/*                 Reset local indices so we can find ROWMAXS */

		    if (myrow == icurrow) {
			ii -= ib;
		    }
		}

/*              Find ROWMAXS */

		if (myrow == icurrow) {
		    i__4 = ii + ib - 1;
		    for (k = ii; k <= i__4; ++k) {
			if (mycol == icurcol) {
			    if (jj <= jja + nq - 1) {
/* Computing MAX */
				i__3 = k + (jj - 1) * lda;
				d__2 = value, d__3 = (d__1 = a[i__3].r, abs(
					d__1));
				value = max(d__2,d__3);
				i__3 = (jja + nq - 2) * lda;
				i__5 = lda;
				for (ll = jj * lda; i__5 < 0 ? ll >= i__3 : 
					ll <= i__3; ll += i__5) {
/* Computing MAX */
				    d__1 = value, d__2 = z_abs(&a[k + ll]);
				    value = max(d__1,d__2);
/* L70: */
				}
			    }
			} else {
			    if (jj <= jja + nq - 1) {
				i__5 = (jja + nq - 2) * lda;
				i__3 = lda;
				for (ll = (jj - 1) * lda; i__3 < 0 ? ll >= 
					i__5 : ll <= i__5; ll += i__3) {
/* Computing MAX */
				    d__1 = value, d__2 = z_abs(&a[k + ll]);
				    value = max(d__1,d__2);
/* L75: */
				}
			    }
			}
			if (mycol == icurcol) {
			    ++jj;
			}
/* L80: */
		    }
		    ii += ib;
		} else if (mycol == icurcol) {
		    jj += ib;
		}
		icurrow = (icurrow + 1) % nprow;
		icurcol = (icurcol + 1) % npcol;
/* L90: */
	    }

	} else {

/*           Handle first block separately */

	    ib = in - *ia + 1;

/*           Find COLMAXS */

	    if (mycol == iacol) {
		i__1 = (jj + ib - 2) * lda;
		i__2 = lda;
		for (k = (jj - 1) * lda; i__2 < 0 ? k >= i__1 : k <= i__1; k 
			+= i__2) {
		    if (myrow == iarow) {
			if (ii <= iia + np - 1) {
/* Computing MAX */
			    i__4 = ii + k;
			    d__2 = value, d__3 = (d__1 = a[i__4].r, abs(d__1))
				    ;
			    value = max(d__2,d__3);
			    i__4 = iia + np - 1;
			    for (ll = ii + 1; ll <= i__4; ++ll) {
/* Computing MAX */
				d__1 = value, d__2 = z_abs(&a[ll + k]);
				value = max(d__1,d__2);
/* L100: */
			    }
			}
		    } else {
			if (ii <= iia + np - 1) {
			    i__4 = iia + np - 1;
			    for (ll = ii; ll <= i__4; ++ll) {
/* Computing MAX */
				d__1 = value, d__2 = z_abs(&a[ll + k]);
				value = max(d__1,d__2);
/* L105: */
			    }
			}
		    }
		    if (myrow == iarow) {
			++ii;
		    }
/* L110: */
		}

/*              Reset local indices so we can find ROWMAXS */

		if (myrow == iarow) {
		    ii -= ib;
		}
	    }

/*           Find ROWMAXS */

	    if (myrow == iarow) {
		i__2 = ib - 1;
		for (k = 0; k <= i__2; ++k) {
		    if (jj > jja) {
			i__1 = (jj - 2) * lda;
			i__4 = lda;
			for (ll = (jja - 1) * lda; i__4 < 0 ? ll >= i__1 : ll 
				<= i__1; ll += i__4) {
/* Computing MAX */
			    d__1 = value, d__2 = z_abs(&a[ii + ll]);
			    value = max(d__1,d__2);
/* L120: */
			}
		    }
		    ++ii;
		    if (mycol == iacol) {
			++jj;
		    }
/* L130: */
		}
	    } else if (mycol == iacol) {
		jj += ib;
	    }

	    icurrow = (iarow + 1) % nprow;
	    icurcol = (iacol + 1) % npcol;

/*           Loop over rows/columns of global matrix. */

	    i__2 = *ia + *n - 1;
	    i__4 = desca[5];
	    for (i__ = in + 1; i__4 < 0 ? i__ >= i__2 : i__ <= i__2; i__ += 
		    i__4) {
/* Computing MIN */
		i__1 = desca[5], i__3 = *ia + *n - i__;
		ib = min(i__1,i__3);

/*              Find COLMAXS */

		if (mycol == icurcol) {
		    i__1 = (jj + ib - 2) * lda;
		    i__3 = lda;
		    for (k = (jj - 1) * lda; i__3 < 0 ? k >= i__1 : k <= i__1;
			     k += i__3) {
			if (myrow == icurrow) {
			    if (ii <= iia + np - 1) {
/* Computing MAX */
				i__5 = ii + k;
				d__2 = value, d__3 = (d__1 = a[i__5].r, abs(
					d__1));
				value = max(d__2,d__3);
				i__5 = iia + np - 1;
				for (ll = ii + 1; ll <= i__5; ++ll) {
/* Computing MAX */
				    d__1 = value, d__2 = z_abs(&a[ll + k]);
				    value = max(d__1,d__2);
/* L140: */
				}
			    }
			} else {
			    if (ii <= iia + np - 1) {
				i__5 = iia + np - 1;
				for (ll = ii; ll <= i__5; ++ll) {
/* Computing MAX */
				    d__1 = value, d__2 = z_abs(&a[ll + k]);
				    value = max(d__1,d__2);
/* L145: */
				}
			    }
			}
			if (myrow == icurrow) {
			    ++ii;
			}
/* L150: */
		    }

/*                 Reset local indices so we can find ROWMAXS */

		    if (myrow == icurrow) {
			ii -= ib;
		    }
		}

/*              Find ROWMAXS */

		if (myrow == icurrow) {
		    i__3 = ib - 1;
		    for (k = 0; k <= i__3; ++k) {
			if (jj > jja) {
			    i__1 = (jj - 2) * lda;
			    i__5 = lda;
			    for (ll = (jja - 1) * lda; i__5 < 0 ? ll >= i__1 :
				     ll <= i__1; ll += i__5) {
/* Computing MAX */
				d__1 = value, d__2 = z_abs(&a[ii + ll]);
				value = max(d__1,d__2);
/* L160: */
			    }
			}
			++ii;
			if (mycol == icurcol) {
			    ++jj;
			}
/* L170: */
		    }
		} else if (mycol == icurcol) {
		    jj += ib;
		}
		icurrow = (icurrow + 1) % nprow;
		icurcol = (icurcol + 1) % npcol;

/* L180: */
	    }

	}

/*        Gather the result on process (IAROW,IACOL). */

	dgamx2d_(&ictxt, "All", " ", &c__1, &c__1, &value, &c__1, &i__, &k, &
		c_n1, &iarow, &iacol, (ftnlen)3, (ftnlen)1);

    } else if (lsame_(norm, "I", (ftnlen)1, (ftnlen)1) || lsame_(norm, "O", (
	    ftnlen)1, (ftnlen)1) || *(unsigned char *)norm == '1') {

/*        Find normI( sub( A ) ) ( = norm1( sub( A ) ), since sub( A ) is */
/*        hermitian). */

	if (lsame_(uplo, "U", (ftnlen)1, (ftnlen)1)) {

/*           Handle first block separately */

	    ib = in - *ia + 1;

/*           Find COLSUMS */

	    if (mycol == iacol) {
		ioffa = (jj - 1) * lda;
		i__4 = ib - 1;
		for (k = 0; k <= i__4; ++k) {
		    sum = 0.;
		    if (ii > iia) {
			i__2 = ii - 1;
			for (ll = iia; ll <= i__2; ++ll) {
			    sum += z_abs(&a[ll + ioffa]);
/* L190: */
			}
		    }
		    ioffa += lda;
		    work[jj + k - jja + icsr0] = sum;
		    if (myrow == iarow) {
			++ii;
		    }
/* L200: */
		}

/*              Reset local indices so we can find ROWSUMS */

		if (myrow == iarow) {
		    ii -= ib;
		}

	    }

/*           Find ROWSUMS */

	    if (myrow == iarow) {
		i__4 = ii + ib - 1;
		for (k = ii; k <= i__4; ++k) {
		    sum = 0.;
		    if (mycol == iacol) {
			if (jja + nq > jj) {
			    i__2 = k + (jj - 1) * lda;
			    sum = (d__1 = a[i__2].r, abs(d__1));
			    i__2 = (jja + nq - 2) * lda;
			    i__3 = lda;
			    for (ll = jj * lda; i__3 < 0 ? ll >= i__2 : ll <= 
				    i__2; ll += i__3) {
				sum += z_abs(&a[k + ll]);
/* L210: */
			    }
			}
		    } else {
			if (jja + nq > jj) {
			    i__3 = (jja + nq - 2) * lda;
			    i__2 = lda;
			    for (ll = (jj - 1) * lda; i__2 < 0 ? ll >= i__3 : 
				    ll <= i__3; ll += i__2) {
				sum += z_abs(&a[k + ll]);
/* L215: */
			    }
			}
		    }
		    work[k - iia + irsc0] = sum;
		    if (mycol == iacol) {
			++jj;
		    }
/* L220: */
		}
		ii += ib;
	    } else if (mycol == iacol) {
		jj += ib;
	    }

	    icurrow = (iarow + 1) % nprow;
	    icurcol = (iacol + 1) % npcol;

/*           Loop over remaining rows/columns of global matrix. */

	    i__4 = *ia + *n - 1;
	    i__2 = desca[5];
	    for (i__ = in + 1; i__2 < 0 ? i__ >= i__4 : i__ <= i__4; i__ += 
		    i__2) {
/* Computing MIN */
		i__3 = desca[5], i__5 = *ia + *n - i__;
		ib = min(i__3,i__5);

/*              Find COLSUMS */

		if (mycol == icurcol) {
		    ioffa = (jj - 1) * lda;
		    i__3 = ib - 1;
		    for (k = 0; k <= i__3; ++k) {
			sum = 0.;
			if (ii > iia) {
			    i__5 = ii - 1;
			    for (ll = iia; ll <= i__5; ++ll) {
				sum += z_abs(&a[ioffa + ll]);
/* L230: */
			    }
			}
			ioffa += lda;
			work[jj + k - jja + icsr0] = sum;
			if (myrow == icurrow) {
			    ++ii;
			}
/* L240: */
		    }

/*                 Reset local indices so we can find ROWSUMS */

		    if (myrow == icurrow) {
			ii -= ib;
		    }

		}

/*              Find ROWSUMS */

		if (myrow == icurrow) {
		    i__3 = ii + ib - 1;
		    for (k = ii; k <= i__3; ++k) {
			sum = 0.;
			if (mycol == icurcol) {
			    if (jja + nq > jj) {
				i__5 = k + (jj - 1) * lda;
				sum = (d__1 = a[i__5].r, abs(d__1));
				i__5 = (jja + nq - 2) * lda;
				i__1 = lda;
				for (ll = jj * lda; i__1 < 0 ? ll >= i__5 : 
					ll <= i__5; ll += i__1) {
				    sum += z_abs(&a[k + ll]);
/* L250: */
				}
			    }
			} else {
			    if (jja + nq > jj) {
				i__1 = (jja + nq - 2) * lda;
				i__5 = lda;
				for (ll = (jj - 1) * lda; i__5 < 0 ? ll >= 
					i__1 : ll <= i__1; ll += i__5) {
				    sum += z_abs(&a[k + ll]);
/* L255: */
				}
			    }
			}
			work[k - iia + irsc0] = sum;
			if (mycol == icurcol) {
			    ++jj;
			}
/* L260: */
		    }
		    ii += ib;
		} else if (mycol == icurcol) {
		    jj += ib;
		}

		icurrow = (icurrow + 1) % nprow;
		icurcol = (icurcol + 1) % npcol;

/* L270: */
	    }

	} else {

/*           Handle first block separately */

	    ib = in - *ia + 1;

/*           Find COLSUMS */

	    if (mycol == iacol) {
		ioffa = (jj - 1) * lda;
		i__2 = ib - 1;
		for (k = 0; k <= i__2; ++k) {
		    sum = 0.;
		    if (myrow == iarow) {
			if (iia + np > ii) {
			    i__4 = ioffa + ii;
			    sum = (d__1 = a[i__4].r, abs(d__1));
			    i__4 = iia + np - 1;
			    for (ll = ii + 1; ll <= i__4; ++ll) {
				sum += z_abs(&a[ioffa + ll]);
/* L280: */
			    }
			}
		    } else {
			i__4 = iia + np - 1;
			for (ll = ii; ll <= i__4; ++ll) {
			    sum += z_abs(&a[ioffa + ll]);
/* L285: */
			}
		    }
		    ioffa += lda;
		    work[jj + k - jja + icsr0] = sum;
		    if (myrow == iarow) {
			++ii;
		    }
/* L290: */
		}

/*              Reset local indices so we can find ROWSUMS */

		if (myrow == iarow) {
		    ii -= ib;
		}

	    }

/*           Find ROWSUMS */

	    if (myrow == iarow) {
		i__2 = ii + ib - 1;
		for (k = ii; k <= i__2; ++k) {
		    sum = 0.;
		    if (jj > jja) {
			i__4 = (jj - 2) * lda;
			i__3 = lda;
			for (ll = (jja - 1) * lda; i__3 < 0 ? ll >= i__4 : ll 
				<= i__4; ll += i__3) {
			    sum += z_abs(&a[k + ll]);
/* L300: */
			}
		    }
		    work[k - iia + irsc0] = sum;
		    if (mycol == iacol) {
			++jj;
		    }
/* L310: */
		}
		ii += ib;
	    } else if (mycol == iacol) {
		jj += ib;
	    }

	    icurrow = (iarow + 1) % nprow;
	    icurcol = (iacol + 1) % npcol;

/*           Loop over rows/columns of global matrix. */

	    i__2 = *ia + *n - 1;
	    i__3 = desca[5];
	    for (i__ = in + 1; i__3 < 0 ? i__ >= i__2 : i__ <= i__2; i__ += 
		    i__3) {
/* Computing MIN */
		i__4 = desca[5], i__5 = *ia + *n - i__;
		ib = min(i__4,i__5);

/*              Find COLSUMS */

		if (mycol == icurcol) {
		    ioffa = (jj - 1) * lda;
		    i__4 = ib - 1;
		    for (k = 0; k <= i__4; ++k) {
			sum = 0.;
			if (myrow == icurrow) {
			    if (iia + np > ii) {
				i__5 = ii + ioffa;
				sum = (d__1 = a[i__5].r, abs(d__1));
				i__5 = iia + np - 1;
				for (ll = ii + 1; ll <= i__5; ++ll) {
				    sum += z_abs(&a[ll + ioffa]);
/* L320: */
				}
			    } else if (ii == iia + np - 1) {
				i__5 = ii + ioffa;
				sum = (d__1 = a[i__5].r, abs(d__1));
			    }
			} else {
			    i__5 = iia + np - 1;
			    for (ll = ii; ll <= i__5; ++ll) {
				sum += z_abs(&a[ll + ioffa]);
/* L325: */
			    }
			}
			ioffa += lda;
			work[jj + k - jja + icsr0] = sum;
			if (myrow == icurrow) {
			    ++ii;
			}
/* L330: */
		    }

/*                 Reset local indices so we can find ROWSUMS */

		    if (myrow == icurrow) {
			ii -= ib;
		    }

		}

/*              Find ROWSUMS */

		if (myrow == icurrow) {
		    i__4 = ii + ib - 1;
		    for (k = ii; k <= i__4; ++k) {
			sum = 0.;
			if (jj > jja) {
			    i__5 = (jj - 2) * lda;
			    i__1 = lda;
			    for (ll = (jja - 1) * lda; i__1 < 0 ? ll >= i__5 :
				     ll <= i__5; ll += i__1) {
				sum += z_abs(&a[k + ll]);
/* L340: */
			    }
			}
			work[k - iia + irsc0] = sum;
			if (mycol == icurcol) {
			    ++jj;
			}
/* L350: */
		    }
		    ii += ib;
		} else if (mycol == icurcol) {
		    jj += ib;
		}

		icurrow = (icurrow + 1) % nprow;
		icurcol = (icurcol + 1) % npcol;

/* L360: */
	    }
	}

/*        After calls to DGSUM2D, process row 0 will have global */
/*        COLSUMS and process column 0 will have global ROWSUMS. */
/*        Transpose ROWSUMS and add to COLSUMS to get global row/column */
/*        sum, the max of which is the infinity or 1 norm. */

	if (mycol == iacol) {
	    nq += icoff;
	}
	dgsum2d_(&ictxt, "Columnwise", " ", &c__1, &nq, &work[icsr], &c__1, &
		iarow, &mycol, (ftnlen)10, (ftnlen)1);
	if (myrow == iarow) {
	    np += iroff;
	}
	i__3 = max(1,np);
	dgsum2d_(&ictxt, "Rowwise", " ", &np, &c__1, &work[irsc], &i__3, &
		myrow, &iacol, (ftnlen)7, (ftnlen)1);

	i__3 = max(1,np);
	i__2 = max(1,nq);
	pdcol2row_(&ictxt, n, &c__1, &desca[5], &work[irsc], &i__3, &work[
		irsr], &i__2, &iarow, &iacol, &iarow, &iacol, &work[irsc + np]
		);

	if (myrow == iarow) {
	    if (mycol == iacol) {
		nq -= icoff;
	    }
	    lfc_SLdaxpy(&nq, &c_b66, &work[irsr0], &c__1, &work[icsr0], &c__1);
	    if (nq < 1) {
		value = 0.;
	    } else {
		value = work[lfc_SLidamax(&nq, &work[icsr0], &c__1)];
	    }
	    dgamx2d_(&ictxt, "Rowwise", " ", &c__1, &c__1, &value, &c__1, &
		    i__, &k, &c_n1, &iarow, &iacol, (ftnlen)7, (ftnlen)1);
	}

    } else if (lsame_(norm, "F", (ftnlen)1, (ftnlen)1) || lsame_(norm, "E", (
	    ftnlen)1, (ftnlen)1)) {

/*        Find normF( sub( A ) ). */

	scale = 0.;
	sum = 1.;

/*        Add off-diagonal entries, first */

	if (lsame_(uplo, "U", (ftnlen)1, (ftnlen)1)) {

/*           Handle first block separately */

	    ib = in - *ia + 1;

	    if (mycol == iacol) {
		i__3 = (jj + ib - 2) * lda;
		i__2 = lda;
		for (k = (jj - 1) * lda; i__2 < 0 ? k >= i__3 : k <= i__3; k 
			+= i__2) {
		    i__4 = ii - iia;
		    zlassq_(&i__4, &a[iia + k], &c__1, &scale, &sum);
		    i__4 = ii - iia;
		    zlassq_(&i__4, &a[iia + k], &c__1, &scale, &sum);
		    if (myrow == iarow) {
			i__4 = ii + k;
			if (a[i__4].r != 0.) {
			    i__4 = ii + k;
			    absa = (d__1 = a[i__4].r, abs(d__1));
			    if (scale < absa) {
/* Computing 2nd power */
				d__1 = scale / absa;
				sum = sum * (d__1 * d__1) + 1.;
				scale = absa;
			    } else {
/* Computing 2nd power */
				d__1 = absa / scale;
				sum += d__1 * d__1;
			    }
			}
			++ii;
		    }
/* L370: */
		}

		jj += ib;
	    } else if (myrow == iarow) {
		ii += ib;
	    }

	    icurrow = (iarow + 1) % nprow;
	    icurcol = (iacol + 1) % npcol;

/*           Loop over rows/columns of global matrix. */

	    i__2 = *ia + *n - 1;
	    i__3 = desca[5];
	    for (i__ = in + 1; i__3 < 0 ? i__ >= i__2 : i__ <= i__2; i__ += 
		    i__3) {
/* Computing MIN */
		i__4 = desca[5], i__1 = *ia + *n - i__;
		ib = min(i__4,i__1);

		if (mycol == icurcol) {
		    i__4 = (jj + ib - 2) * lda;
		    i__1 = lda;
		    for (k = (jj - 1) * lda; i__1 < 0 ? k >= i__4 : k <= i__4;
			     k += i__1) {
			i__5 = ii - iia;
			zlassq_(&i__5, &a[iia + k], &c__1, &scale, &sum);
			i__5 = ii - iia;
			zlassq_(&i__5, &a[iia + k], &c__1, &scale, &sum);
			if (myrow == icurrow) {
			    i__5 = ii + k;
			    if (a[i__5].r != 0.) {
				i__5 = ii + k;
				absa = (d__1 = a[i__5].r, abs(d__1));
				if (scale < absa) {
/* Computing 2nd power */
				    d__1 = scale / absa;
				    sum = sum * (d__1 * d__1) + 1.;
				    scale = absa;
				} else {
/* Computing 2nd power */
				    d__1 = absa / scale;
				    sum += d__1 * d__1;
				}
			    }
			    ++ii;
			}
/* L380: */
		    }

		    jj += ib;
		} else if (myrow == icurrow) {
		    ii += ib;
		}

		icurrow = (icurrow + 1) % nprow;
		icurcol = (icurcol + 1) % npcol;

/* L390: */
	    }

	} else {

/*           Handle first block separately */

	    ib = in - *ia + 1;

	    if (mycol == iacol) {
		i__3 = (jj + ib - 2) * lda;
		i__2 = lda;
		for (k = (jj - 1) * lda; i__2 < 0 ? k >= i__3 : k <= i__3; k 
			+= i__2) {
		    if (myrow == iarow) {
			i__1 = ii + k;
			if (a[i__1].r != 0.) {
			    i__1 = ii + k;
			    absa = (d__1 = a[i__1].r, abs(d__1));
			    if (scale < absa) {
/* Computing 2nd power */
				d__1 = scale / absa;
				sum = sum * (d__1 * d__1) + 1.;
				scale = absa;
			    } else {
/* Computing 2nd power */
				d__1 = absa / scale;
				sum += d__1 * d__1;
			    }
			}
			++ii;
		    }
		    i__1 = iia + np - ii;
		    zlassq_(&i__1, &a[ii + k], &c__1, &scale, &sum);
		    i__1 = iia + np - ii;
		    zlassq_(&i__1, &a[ii + k], &c__1, &scale, &sum);
/* L400: */
		}

		jj += ib;
	    } else if (myrow == iarow) {
		ii += ib;
	    }

	    icurrow = (iarow + 1) % nprow;
	    icurcol = (iacol + 1) % npcol;

/*           Loop over rows/columns of global matrix. */

	    i__2 = *ia + *n - 1;
	    i__3 = desca[5];
	    for (i__ = in + 1; i__3 < 0 ? i__ >= i__2 : i__ <= i__2; i__ += 
		    i__3) {
/* Computing MIN */
		i__1 = desca[5], i__4 = *ia + *n - i__;
		ib = min(i__1,i__4);

		if (mycol == icurcol) {
		    i__1 = (jj + ib - 2) * lda;
		    i__4 = lda;
		    for (k = (jj - 1) * lda; i__4 < 0 ? k >= i__1 : k <= i__1;
			     k += i__4) {
			if (myrow == icurrow) {
			    i__5 = ii + k;
			    if (a[i__5].r != 0.) {
				i__5 = ii + k;
				absa = (d__1 = a[i__5].r, abs(d__1));
				if (scale < absa) {
/* Computing 2nd power */
				    d__1 = scale / absa;
				    sum = sum * (d__1 * d__1) + 1.;
				    scale = absa;
				} else {
/* Computing 2nd power */
				    d__1 = absa / scale;
				    sum += d__1 * d__1;
				}
			    }
			    ++ii;
			}
			i__5 = iia + np - ii;
			zlassq_(&i__5, &a[ii + k], &c__1, &scale, &sum);
			i__5 = iia + np - ii;
			zlassq_(&i__5, &a[ii + k], &c__1, &scale, &sum);
/* L410: */
		    }

		    jj += ib;
		} else if (myrow == icurrow) {
		    ii += ib;
		}

		icurrow = (icurrow + 1) % nprow;
		icurcol = (icurcol + 1) % npcol;

/* L420: */
	    }

	}

/*        Perform the global scaled sum */

	rwork[0] = scale;
	rwork[1] = sum;

	pdtreecomb_(&ictxt, "All", &c__2, rwork, &iarow, &iacol, (U_fp)
		dcombssq_, (ftnlen)3);
	value = rwork[0] * sqrt(rwork[1]);

    }

/*     Broadcast the result to the other processes */

    if (myrow == iarow && mycol == iacol) {
	dgebs2d_(&ictxt, "All", " ", &c__1, &c__1, &value, &c__1, (ftnlen)3, (
		ftnlen)1);
    } else {
	dgebr2d_(&ictxt, "All", " ", &c__1, &c__1, &value, &c__1, &iarow, &
		iacol, (ftnlen)3, (ftnlen)1);
    }

    ret_val = value;

    return ret_val;

/*     End of PZLANHE */

} /* pzlanhe_ */

