/* /home4/luszczek/mscratch/build/SCALAPACK/SRC/pzlacp2.f -- translated by f2c (version 20031025).
   You must link the resulting object file with libf2c:
	on Microsoft Windows system, link with libf2c.lib;
	on Linux or Unix systems, link with .../path/to/libf2c.a -lm
	or, if you install libf2c.a in a standard place, with -lf2c -lm
	-- in that order, at the end of the command line, as in
		cc *.o -lf2c -lm
	Source for libf2c is in /netlib/f2c/libf2c.zip, e.g.,

		http://www.netlib.org/f2c/libf2c.zip
*/

#include "f2c.h"

/* Subroutine */ int pzlacp2_(char *uplo, integer *m, integer *n, 
	doublecomplex *a, integer *ia, integer *ja, integer *desca, 
	doublecomplex *b, integer *ib, integer *jb, integer *descb, ftnlen 
	uplo_len)
{
    /* System generated locals */
    integer i__1, i__2;

    /* Local variables */
    integer mp, nq, mba, lda, ldb, iia, iib, jja, jjb, nba, iiaa, iibb, jjaa, 
	    jjbb, mpaa, nqaa, wide, itop, ibase;
    extern integer iceil_(integer *, integer *);
    integer iacol, ibcol;
    extern logical lsame_(char *, char *, ftnlen, ftnlen);
    integer ileft, npcol, iarow, ibrow, mycol, nprow, myrow, iibega, iibegb, 
	    jjbega, jjbegb, icoffa, iienda, jjenda, iroffa, height, iright, 
	    iinxta, iinxtb, jjnxta, jjnxtb;
    extern /* Subroutine */ int zlacpy_(char *, integer *, integer *, 
	    doublecomplex *, integer *, doublecomplex *, integer *, ftnlen), 
	    blacs_gridinfo__(integer *, integer *, integer *, integer *, 
	    integer *);
    extern integer numroc_(integer *, integer *, integer *, integer *, 
	    integer *);
    integer mydist;
    extern /* Subroutine */ int infog2l_(integer *, integer *, integer *, 
	    integer *, integer *, integer *, integer *, integer *, integer *, 
	    integer *, integer *);


/*  -- ScaLAPACK auxiliary routine (version 1.7) -- */
/*     University of Tennessee, Knoxville, Oak Ridge National Laboratory, */
/*     and University of California, Berkeley. */
/*     November 15, 1997 */

/*     .. Scalar Arguments .. */
/*     .. */
/*     .. Array Arguments .. */
/*     .. */

/*  Purpose */
/*  ======= */

/*  PZLACP2 copies all or part of a distributed matrix A to another */
/*  distributed matrix B.  No communication is performed, PZLACP2 */
/*  performs a local copy sub( A ) := sub( B ), where sub( A ) denotes */
/*  A(IA:IA+M-1,JA:JA+N-1) and sub( B ) denotes B(IB:IB+M-1,JB:JB+N-1). */
/*  PZLACP2 requires that only dimension of the matrix operands is */
/*  distributed. */

/*  Notes */
/*  ===== */

/*  Each global data object is described by an associated description */
/*  vector.  This vector stores the information required to establish */
/*  the mapping between an object element and its corresponding process */
/*  and memory location. */

/*  Let A be a generic term for any 2D block cyclicly distributed array. */
/*  Such a global array has an associated description vector DESCA. */
/*  In the following comments, the character _ should be read as */
/*  "of the global array". */

/*  NOTATION        STORED IN      EXPLANATION */
/*  --------------- -------------- -------------------------------------- */
/*  DTYPE_A(global) DESCA( DTYPE_ )The descriptor type.  In this case, */
/*                                 DTYPE_A = 1. */
/*  CTXT_A (global) DESCA( CTXT_ ) The BLACS context handle, indicating */
/*                                 the BLACS process grid A is distribu- */
/*                                 ted over. The context itself is glo- */
/*                                 bal, but the handle (the integer */
/*                                 value) may vary. */
/*  M_A    (global) DESCA( M_ )    The number of rows in the global */
/*                                 array A. */
/*  N_A    (global) DESCA( N_ )    The number of columns in the global */
/*                                 array A. */
/*  MB_A   (global) DESCA( MB_ )   The blocking factor used to distribute */
/*                                 the rows of the array. */
/*  NB_A   (global) DESCA( NB_ )   The blocking factor used to distribute */
/*                                 the columns of the array. */
/*  RSRC_A (global) DESCA( RSRC_ ) The process row over which the first */
/*                                 row of the array A is distributed. */
/*  CSRC_A (global) DESCA( CSRC_ ) The process column over which the */
/*                                 first column of the array A is */
/*                                 distributed. */
/*  LLD_A  (local)  DESCA( LLD_ )  The leading dimension of the local */
/*                                 array.  LLD_A >= MAX(1,LOCr(M_A)). */

/*  Let K be the number of rows or columns of a distributed matrix, */
/*  and assume that its process grid has dimension p x q. */
/*  LOCr( K ) denotes the number of elements of K that a process */
/*  would receive if K were distributed over the p processes of its */
/*  process column. */
/*  Similarly, LOCc( K ) denotes the number of elements of K that a */
/*  process would receive if K were distributed over the q processes of */
/*  its process row. */
/*  The values of LOCr() and LOCc() may be determined via a call to the */
/*  ScaLAPACK tool function, NUMROC: */
/*          LOCr( M ) = NUMROC( M, MB_A, MYROW, RSRC_A, NPROW ), */
/*          LOCc( N ) = NUMROC( N, NB_A, MYCOL, CSRC_A, NPCOL ). */
/*  An upper bound for these quantities may be computed by: */
/*          LOCr( M ) <= ceil( ceil(M/MB_A)/NPROW )*MB_A */
/*          LOCc( N ) <= ceil( ceil(N/NB_A)/NPCOL )*NB_A */

/*  Arguments */
/*  ========= */

/*  UPLO    (global input) CHARACTER */
/*          Specifies the part of the distributed matrix sub( A ) to be */
/*          copied: */
/*          = 'U':   Upper triangular part is copied; the strictly */
/*                   lower triangular part of sub( A ) is not referenced; */
/*          = 'L':   Lower triangular part is copied; the strictly */
/*                   upper triangular part of sub( A ) is not referenced; */
/*          Otherwise:  All of the matrix sub( A ) is copied. */

/*  M       (global input) INTEGER */
/*          The number of rows to be operated on i.e the number of rows */
/*          of the distributed submatrix sub( A ). M >= 0. */

/*  N       (global input) INTEGER */
/*          The number of columns to be operated on i.e the number of */
/*          columns of the distributed submatrix sub( A ). N >= 0. */

/*  A       (local input) COMPLEX*16 pointer into the local memory */
/*          to an array of dimension (LLD_A, LOCc(JA+N-1) ). This array */
/*          contains the local pieces of the distributed matrix sub( A ) */
/*          to be copied from. */

/*  IA      (global input) INTEGER */
/*          The row index in the global array A indicating the first */
/*          row of sub( A ). */

/*  JA      (global input) INTEGER */
/*          The column index in the global array A indicating the */
/*          first column of sub( A ). */

/*  DESCA   (global and local input) INTEGER array of dimension DLEN_. */
/*          The array descriptor for the distributed matrix A. */

/*  B       (local output) COMPLEX*16 pointer into the local memory */
/*          to an array of dimension (LLD_B, LOCc(JB+N-1) ). This array */
/*          contains on exit the local pieces of the distributed matrix */
/*          sub( B ) set as follows: */

/*          if UPLO = 'U', B(IB+i-1,JB+j-1) = A(IA+i-1,JA+j-1), */
/*                         1<=i<=j, 1<=j<=N; */
/*          if UPLO = 'L', B(IB+i-1,JB+j-1) = A(IA+i-1,JA+j-1), */
/*                         j<=i<=M, 1<=j<=N; */
/*          otherwise,     B(IB+i-1,JB+j-1) = A(IA+i-1,JA+j-1), */
/*                         1<=i<=M, 1<=j<=N. */

/*  IB      (global input) INTEGER */
/*          The row index in the global array B indicating the first */
/*          row of sub( B ). */

/*  JB      (global input) INTEGER */
/*          The column index in the global array B indicating the */
/*          first column of sub( B ). */

/*  DESCB   (global and local input) INTEGER array of dimension DLEN_. */
/*          The array descriptor for the distributed matrix B. */

/*  ===================================================================== */

/*     .. Parameters .. */
/*     .. */
/*     .. Local Scalars .. */
/*     .. */
/*     .. External Subroutines .. */
/*     .. */
/*     .. External Functions .. */
/*     .. */
/*     .. Intrinsic Functions .. */
/*     .. */
/*     .. Executable Statements .. */

    /* Parameter adjustments */
    --descb;
    --b;
    --desca;
    --a;

    /* Function Body */
    if (*m == 0 || *n == 0) {
	return 0;
    }

/*     Get grid parameters */

    blacs_gridinfo__(&desca[2], &nprow, &npcol, &myrow, &mycol);

    infog2l_(ia, ja, &desca[1], &nprow, &npcol, &myrow, &mycol, &iia, &jja, &
	    iarow, &iacol);
    infog2l_(ib, jb, &descb[1], &nprow, &npcol, &myrow, &mycol, &iib, &jjb, &
	    ibrow, &ibcol);

    mba = desca[5];
    nba = desca[6];
    lda = desca[9];
    iroffa = (*ia - 1) % mba;
    icoffa = (*ja - 1) % nba;
    ldb = descb[9];

    if (*n <= nba - icoffa) {

/*        It is assumed that the local columns JJA:JJA+N-1 of the matrix */
/*        A are in the same process column (IACOL). */

/*                         N */
/*                JJA             JJA+N-1 */
/*         /      ---------------------    \ */
/*   IROFFA|      |                   |    | */
/*         \      |...................|    |          ( IAROW ) */
/*           IIA  |x                  |    |   MBA = DESCA( MB_ ) */
/*                | x                 |    | */
/*                |--x----------------|    / */
/*                |   x               | */
/*                |    x              |        ITOP */
/*                |     x             |          | */
/*                |      x            |      /-------\ */
/*                |-------x-----------|      |-------x-----------| */
/*                |        x          |      |        x          | */
/*                |         x         |      |         x         | */
/*                |          x        |      |          x        | */
/*                |           x       |      |           x       | */
/*                |------------x------|      |------------x------| */
/*                |             x     |      \____________/ */
/*                |              x    |            | */
/*                |               x   |          IBASE */
/*                |                x  | */
/*                |-----------------x-|          Local picture */
/*                |                  x| */
/*                |                   | */
/*                |                   | */
/*                |                   | */
/*                |-------------------| */
/*                |                   | */
/*                .                   . */
/*                .                   . */
/*                .      (IACOL)      . */

	if (mycol == iacol) {

	    i__1 = *m + iroffa;
	    mp = numroc_(&i__1, &mba, &myrow, &iarow, &nprow);
	    if (mp <= 0) {
		return 0;
	    }
	    if (myrow == iarow) {
		mp -= iroffa;
	    }
	    mydist = (myrow - iarow + nprow) % nprow;
	    itop = mydist * mba - iroffa;

	    if (lsame_(uplo, "U", (ftnlen)1, (ftnlen)1)) {

		itop = max(0,itop);
		iibega = iia;
		iienda = iia + mp - 1;
/* Computing MIN */
		i__1 = iceil_(&iibega, &mba) * mba;
		iinxta = min(i__1,iienda);
		iibegb = iib;
		iinxtb = iibegb + iinxta - iibega;

L10:
		if (*n - itop > 0) {
		    i__1 = iinxta - iibega + 1;
		    i__2 = *n - itop;
		    zlacpy_(uplo, &i__1, &i__2, &a[iibega + (jja + itop - 1) *
			     lda], &lda, &b[iibegb + (jjb + itop - 1) * ldb], 
			    &ldb, (ftnlen)1);
		    mydist += nprow;
		    itop = mydist * mba - iroffa;
		    iibega = iinxta + 1;
/* Computing MIN */
		    i__1 = iinxta + mba;
		    iinxta = min(i__1,iienda);
		    iibegb = iinxtb + 1;
		    iinxtb = iibegb + iinxta - iibega;
		    goto L10;
		}

	    } else if (lsame_(uplo, "L", (ftnlen)1, (ftnlen)1)) {

		mpaa = mp;
		iiaa = iia;
		jjaa = jja;
		iibb = iib;
		jjbb = jjb;
/* Computing MIN */
		i__1 = itop + mba;
		ibase = min(i__1,*n);
/* Computing MIN */
		i__1 = max(0,itop);
		itop = min(i__1,*n);

L20:
		if (jjaa <= jja + *n - 1) {
		    height = ibase - itop;
		    i__1 = itop - jjaa + jja;
		    zlacpy_("All", &mpaa, &i__1, &a[iiaa + (jjaa - 1) * lda], 
			    &lda, &b[iibb + (jjbb - 1) * ldb], &ldb, (ftnlen)
			    3);
		    zlacpy_(uplo, &mpaa, &height, &a[iiaa + (jja + itop - 1) *
			     lda], &lda, &b[iibb + (jjb + itop - 1) * ldb], &
			    ldb, (ftnlen)1);
/* Computing MAX */
		    i__1 = 0, i__2 = mpaa - height;
		    mpaa = max(i__1,i__2);
		    iiaa += height;
		    jjaa = jja + ibase;
		    iibb += height;
		    jjbb = jjb + ibase;
		    mydist += nprow;
		    itop = mydist * mba - iroffa;
/* Computing MIN */
		    i__1 = itop + mba;
		    ibase = min(i__1,*n);
		    itop = min(itop,*n);
		    goto L20;
		}

	    } else {

		zlacpy_("All", &mp, n, &a[iia + (jja - 1) * lda], &lda, &b[
			iib + (jjb - 1) * ldb], &ldb, (ftnlen)3);

	    }

	}

    } else if (*m <= mba - iroffa) {

/*        It is assumed that the local rows IIA:IIA+M-1 of the matrix A */
/*        are in the same process row (IAROW). */

/*            ICOFFA */
/*             / \JJA */
/*        IIA  ------------------ ....            -------- */
/*             | .x  |    |    |                 / |    | \ */
/*             | . x |    |    |            ILEFT| |    | | */
/*             | .  x     |    |                 | |    | | */
/*             | .   x    |    |                 \ x    | | */
/*             | .   |x   |    |                   |x   | | IRIGHT */
/*             | .   | x  |    |                   | x  | | */
/*    (IAROW)  | .   |  x |    |                   |  x | | */
/*             | .   |   x|    |                   |   x| | */
/*             | .   |    x    |                   |    x / */
/*             | .   |    |x   |                   |    | */
/*             | .   |    | x  |                   |    | */
/*             | .   |    |  x |                   |    | */
/*             | .   |    |   x|                   |    | */
/*    IIA+M-1  ------------------ ....            ------- */
/*              NB_A */
/*             (IACOL)                          Local picture */

	if (myrow == iarow) {

	    i__1 = *n + icoffa;
	    nq = numroc_(&i__1, &nba, &mycol, &iacol, &npcol);
	    if (nq <= 0) {
		return 0;
	    }
	    if (mycol == iacol) {
		nq -= icoffa;
	    }
	    mydist = (mycol - iacol + npcol) % npcol;
	    ileft = mydist * nba - icoffa;

	    if (lsame_(uplo, "L", (ftnlen)1, (ftnlen)1)) {

		ileft = max(0,ileft);
		jjbega = jja;
		jjenda = jja + nq - 1;
/* Computing MIN */
		i__1 = iceil_(&jjbega, &nba) * nba;
		jjnxta = min(i__1,jjenda);
		jjbegb = jjb;
		jjnxtb = jjbegb + jjnxta - jjbega;

L30:
		if (*m - ileft > 0) {
		    i__1 = *m - ileft;
		    i__2 = jjnxta - jjbega + 1;
		    zlacpy_(uplo, &i__1, &i__2, &a[iia + ileft + (jjbega - 1) 
			    * lda], &lda, &b[iib + ileft + (jjbegb - 1) * ldb]
			    , &ldb, (ftnlen)1);
		    mydist += npcol;
		    ileft = mydist * nba - icoffa;
		    jjbega = jjnxta + 1;
/* Computing MIN */
		    i__1 = jjnxta + nba;
		    jjnxta = min(i__1,jjenda);
		    jjbegb = jjnxtb + 1;
		    jjnxtb = jjbegb + jjnxta - jjbega;
		    goto L30;
		}

	    } else if (lsame_(uplo, "U", (ftnlen)1, (ftnlen)1)) {

		nqaa = nq;
		iiaa = iia;
		jjaa = jja;
		iibb = iib;
		jjbb = jjb;
/* Computing MIN */
		i__1 = ileft + nba;
		iright = min(i__1,*m);
/* Computing MIN */
		i__1 = max(0,ileft);
		ileft = min(i__1,*m);

L40:
		if (iiaa <= iia + *m - 1) {
		    wide = iright - ileft;
		    i__1 = ileft - iiaa + iia;
		    zlacpy_("All", &i__1, &nqaa, &a[iiaa + (jjaa - 1) * lda], 
			    &lda, &b[iibb + (jjbb - 1) * ldb], &ldb, (ftnlen)
			    3);
		    zlacpy_(uplo, &wide, &nqaa, &a[iia + ileft + (jjaa - 1) * 
			    lda], &lda, &b[iib + ileft + (jjbb - 1) * ldb], &
			    ldb, (ftnlen)1);
/* Computing MAX */
		    i__1 = 0, i__2 = nqaa - wide;
		    nqaa = max(i__1,i__2);
		    iiaa = iia + iright;
		    jjaa += wide;
		    iibb = iib + iright;
		    jjbb += wide;
		    mydist += npcol;
		    ileft = mydist * nba - icoffa;
/* Computing MIN */
		    i__1 = ileft + nba;
		    iright = min(i__1,*m);
		    ileft = min(ileft,*m);
		    goto L40;
		}

	    } else {

		zlacpy_("All", m, &nq, &a[iia + (jja - 1) * lda], &lda, &b[
			iib + (jjb - 1) * ldb], &ldb, (ftnlen)3);

	    }

	}

    }

    return 0;

/*     End of PZLACP2 */

} /* pzlacp2_ */

