/* /home4/luszczek/mscratch/build/SCALAPACK/SRC/pslase2.f -- translated by f2c (version 20031025).
   You must link the resulting object file with libf2c:
	on Microsoft Windows system, link with libf2c.lib;
	on Linux or Unix systems, link with .../path/to/libf2c.a -lm
	or, if you install libf2c.a in a standard place, with -lf2c -lm
	-- in that order, at the end of the command line, as in
		cc *.o -lf2c -lm
	Source for libf2c is in /netlib/f2c/libf2c.zip, e.g.,

		http://www.netlib.org/f2c/libf2c.zip
*/

#include "f2c.h"

/* Subroutine */ int pslase2_(char *uplo, integer *m, integer *n, real *alpha,
	 real *beta, real *a, integer *ia, integer *ja, integer *desca, 
	ftnlen uplo_len)
{
    /* System generated locals */
    integer i__1, i__2;

    /* Local variables */
    integer ii, jj, mp, nq, mba, lda, nba, iia, jja, mpa, nqa, wide, itop, 
	    iibeg, jjbeg, ibase;
    extern integer iceil_(integer *, integer *);
    integer iacol, iiend, jjend;
    extern logical lsame_(char *, char *, ftnlen, ftnlen);
    integer ileft, npcol, iarow, mycol, iinxt, jjnxt, nprow, myrow, icoffa, 
	    iroffa, height, iright;
    extern /* Subroutine */ int slaset_(char *, integer *, integer *, real *, 
	    real *, real *, integer *, ftnlen), blacs_gridinfo__(integer *, 
	    integer *, integer *, integer *, integer *);
    extern integer numroc_(integer *, integer *, integer *, integer *, 
	    integer *);
    integer mydist;
    extern /* Subroutine */ int infog2l_(integer *, integer *, integer *, 
	    integer *, integer *, integer *, integer *, integer *, integer *, 
	    integer *, integer *);


/*  -- ScaLAPACK auxiliary routine (version 1.7) -- */
/*     University of Tennessee, Knoxville, Oak Ridge National Laboratory, */
/*     and University of California, Berkeley. */
/*     May 1, 1997 */

/*     .. Scalar Arguments .. */
/*     .. */
/*     .. Array Arguments .. */
/*     .. */

/*  Purpose */
/*  ======= */

/*  PSLASE2 initializes an M-by-N distributed matrix sub( A ) denoting */
/*  A(IA:IA+M-1,JA:JA+N-1) to BETA on the diagonal and ALPHA on the */
/*  offdiagonals.  PSLASE2 requires that only dimension of the matrix */
/*  operand is distributed. */

/*  Notes */
/*  ===== */

/*  Each global data object is described by an associated description */
/*  vector.  This vector stores the information required to establish */
/*  the mapping between an object element and its corresponding process */
/*  and memory location. */

/*  Let A be a generic term for any 2D block cyclicly distributed array. */
/*  Such a global array has an associated description vector DESCA. */
/*  In the following comments, the character _ should be read as */
/*  "of the global array". */

/*  NOTATION        STORED IN      EXPLANATION */
/*  --------------- -------------- -------------------------------------- */
/*  DTYPE_A(global) DESCA( DTYPE_ )The descriptor type.  In this case, */
/*                                 DTYPE_A = 1. */
/*  CTXT_A (global) DESCA( CTXT_ ) The BLACS context handle, indicating */
/*                                 the BLACS process grid A is distribu- */
/*                                 ted over. The context itself is glo- */
/*                                 bal, but the handle (the integer */
/*                                 value) may vary. */
/*  M_A    (global) DESCA( M_ )    The number of rows in the global */
/*                                 array A. */
/*  N_A    (global) DESCA( N_ )    The number of columns in the global */
/*                                 array A. */
/*  MB_A   (global) DESCA( MB_ )   The blocking factor used to distribute */
/*                                 the rows of the array. */
/*  NB_A   (global) DESCA( NB_ )   The blocking factor used to distribute */
/*                                 the columns of the array. */
/*  RSRC_A (global) DESCA( RSRC_ ) The process row over which the first */
/*                                 row of the array A is distributed. */
/*  CSRC_A (global) DESCA( CSRC_ ) The process column over which the */
/*                                 first column of the array A is */
/*                                 distributed. */
/*  LLD_A  (local)  DESCA( LLD_ )  The leading dimension of the local */
/*                                 array.  LLD_A >= MAX(1,LOCr(M_A)). */

/*  Let K be the number of rows or columns of a distributed matrix, */
/*  and assume that its process grid has dimension p x q. */
/*  LOCr( K ) denotes the number of elements of K that a process */
/*  would receive if K were distributed over the p processes of its */
/*  process column. */
/*  Similarly, LOCc( K ) denotes the number of elements of K that a */
/*  process would receive if K were distributed over the q processes of */
/*  its process row. */
/*  The values of LOCr() and LOCc() may be determined via a call to the */
/*  ScaLAPACK tool function, NUMROC: */
/*          LOCr( M ) = NUMROC( M, MB_A, MYROW, RSRC_A, NPROW ), */
/*          LOCc( N ) = NUMROC( N, NB_A, MYCOL, CSRC_A, NPCOL ). */
/*  An upper bound for these quantities may be computed by: */
/*          LOCr( M ) <= ceil( ceil(M/MB_A)/NPROW )*MB_A */
/*          LOCc( N ) <= ceil( ceil(N/NB_A)/NPCOL )*NB_A */

/*  Arguments */
/*  ========= */

/*  UPLO    (global input) CHARACTER */
/*          Specifies the part of the distributed matrix sub( A ) to be */
/*          set: */
/*          = 'U':      Upper triangular part is set; the strictly lower */
/*                      triangular part of sub( A ) is not changed; */
/*          = 'L':      Lower triangular part is set; the strictly upper */
/*                      triangular part of sub( A ) is not changed; */
/*          Otherwise:  All of the matrix sub( A ) is set. */

/*  M       (global input) INTEGER */
/*          The number of rows to be operated on i.e the number of rows */
/*          of the distributed submatrix sub( A ). M >= 0. */

/*  N       (global input) INTEGER */
/*          The number of columns to be operated on i.e the number of */
/*          columns of the distributed submatrix sub( A ). N >= 0. */

/*  ALPHA   (global input) REAL */
/*          The constant to which the offdiagonal elements are to be */
/*          set. */

/*  BETA    (global input) REAL */
/*          The constant to which the diagonal elements are to be set. */

/*  A       (local output) REAL pointer into the local memory */
/*          to an array of dimension (LLD_A,LOCc(JA+N-1)).  This array */
/*          contains the local pieces of the distributed matrix sub( A ) */
/*          to be set.  On exit, the leading M-by-N submatrix sub( A ) */
/*          is set as follows: */

/*          if UPLO = 'U', A(IA+i-1,JA+j-1) = ALPHA, 1<=i<=j-1, 1<=j<=N, */
/*          if UPLO = 'L', A(IA+i-1,JA+j-1) = ALPHA, j+1<=i<=M, 1<=j<=N, */
/*          otherwise,     A(IA+i-1,JA+j-1) = ALPHA, 1<=i<=M, 1<=j<=N, */
/*                                                   IA+i.NE.JA+j, */
/*          and, for all UPLO, A(IA+i-1,JA+i-1) = BETA, 1<=i<=min(M,N). */

/*  IA      (global input) INTEGER */
/*          The row index in the global array A indicating the first */
/*          row of sub( A ). */

/*  JA      (global input) INTEGER */
/*          The column index in the global array A indicating the */
/*          first column of sub( A ). */

/*  DESCA   (global and local input) INTEGER array of dimension DLEN_. */
/*          The array descriptor for the distributed matrix A. */

/*  ===================================================================== */

/*     .. Parameters .. */
/*     .. */
/*     .. Local Scalars .. */
/*     .. */
/*     .. External Subroutines .. */
/*     .. */
/*     .. External Functions .. */
/*     .. */
/*     .. Intrinsic Functions .. */
/*     .. */
/*     .. Executable Statements .. */

    /* Parameter adjustments */
    --desca;
    --a;

    /* Function Body */
    if (*m == 0 || *n == 0) {
	return 0;
    }

/*     Get grid parameters */

    blacs_gridinfo__(&desca[2], &nprow, &npcol, &myrow, &mycol);

    infog2l_(ia, ja, &desca[1], &nprow, &npcol, &myrow, &mycol, &iia, &jja, &
	    iarow, &iacol);
    mba = desca[5];
    nba = desca[6];
    lda = desca[9];
    iroffa = (*ia - 1) % mba;
    icoffa = (*ja - 1) % nba;

    if (*n <= nba - icoffa) {

/*        It is assumed that the local columns JJA:JJA+N-1 of the matrix */
/*        A are in the same process column (IACOL). */

/*                         N */
/*                JJA             JJA+N-1 */
/*         /      ---------------------    \ */
/*   IROFFA|      |                   |    | */
/*         \      |...................|    |       ( IAROW ) */
/*           IIA  |x                  |    | MB_A */
/*                | x                 |    | */
/*                |--x----------------|    / */
/*                |   x               | */
/*                |    x              |        ITOP */
/*                |     x             |          | */
/*                |      x            |      /-------\ */
/*                |-------x-----------|      |-------x-----------| */
/*                |        x          |      |        x          | */
/*                |         x         |      |         x         | */
/*                |          x        |      |          x        | */
/*                |           x       |      |           x       | */
/*                |------------x------|      |------------x------| */
/*                |             x     |      \____________/ */
/*                |              x    |            | */
/*                |               x   |          IBASE */
/*                |                x  | */
/*                |-----------------x-|          Local picture */
/*                |                  x| */
/*                |                   | */
/*                |                   | */
/*                |                   | */
/*                |-------------------| */
/*                |                   | */
/*                .                   . */
/*                .                   . */
/*                .      (IACOL)      . */

	if (mycol == iacol) {

	    i__1 = *m + iroffa;
	    mpa = numroc_(&i__1, &mba, &myrow, &iarow, &nprow);
	    if (mpa <= 0) {
		return 0;
	    }
	    if (myrow == iarow) {
		mpa -= iroffa;
	    }
	    mydist = (myrow - iarow + nprow) % nprow;
	    itop = mydist * mba - iroffa;

	    if (lsame_(uplo, "U", (ftnlen)1, (ftnlen)1)) {

		itop = max(0,itop);
		iibeg = iia;
		iiend = iia + mpa - 1;
/* Computing MIN */
		i__1 = iceil_(&iibeg, &mba) * mba;
		iinxt = min(i__1,iiend);

L10:
		if (*n - itop > 0) {
		    i__1 = iinxt - iibeg + 1;
		    i__2 = *n - itop;
		    slaset_(uplo, &i__1, &i__2, alpha, beta, &a[iibeg + (jja 
			    + itop - 1) * lda], &lda, (ftnlen)1);
		    mydist += nprow;
		    itop = mydist * mba - iroffa;
		    iibeg = iinxt + 1;
/* Computing MIN */
		    i__1 = iinxt + mba;
		    iinxt = min(i__1,iiend);
		    goto L10;
		}

	    } else if (lsame_(uplo, "L", (ftnlen)1, (ftnlen)1)) {

		ii = iia;
		jj = jja;
		mp = mpa;
/* Computing MIN */
		i__1 = itop + mba;
		ibase = min(i__1,*n);
/* Computing MIN */
		i__1 = max(0,itop);
		itop = min(i__1,*n);

L20:
		if (jj <= jja + *n - 1) {
		    height = ibase - itop;
		    i__1 = itop - jj + jja;
		    slaset_("All", &mp, &i__1, alpha, alpha, &a[ii + (jj - 1) 
			    * lda], &lda, (ftnlen)3);
		    slaset_(uplo, &mp, &height, alpha, beta, &a[ii + (jja + 
			    itop - 1) * lda], &lda, (ftnlen)1);
/* Computing MAX */
		    i__1 = 0, i__2 = mp - height;
		    mp = max(i__1,i__2);
		    ii += height;
		    jj = jja + ibase;
		    mydist += nprow;
		    itop = mydist * mba - iroffa;
/* Computing MIN */
		    i__1 = itop + mba;
		    ibase = min(i__1,*n);
		    itop = min(itop,*n);
		    goto L20;
		}

	    } else {

		ii = iia;
		jj = jja;
		mp = mpa;
/* Computing MIN */
		i__1 = itop + mba;
		ibase = min(i__1,*n);
/* Computing MIN */
		i__1 = max(0,itop);
		itop = min(i__1,*n);

L30:
		if (jj <= jja + *n - 1) {
		    height = ibase - itop;
		    i__1 = itop - jj + jja;
		    slaset_("All", &mpa, &i__1, alpha, alpha, &a[iia + (jj - 
			    1) * lda], &lda, (ftnlen)3);
		    i__1 = mpa - mp;
		    slaset_("All", &i__1, &height, alpha, alpha, &a[iia + (
			    jja + itop - 1) * lda], &lda, (ftnlen)3);
		    slaset_("All", &mp, &height, alpha, beta, &a[ii + (jja + 
			    itop - 1) * lda], &lda, (ftnlen)3);
/* Computing MAX */
		    i__1 = 0, i__2 = mp - height;
		    mp = max(i__1,i__2);
		    ii += height;
		    jj = jja + ibase;
		    mydist += nprow;
		    itop = mydist * mba - iroffa;
/* Computing MIN */
		    i__1 = itop + mba;
		    ibase = min(i__1,*n);
		    itop = min(itop,*n);
		    goto L30;
		}

	    }

	}

    } else if (*m <= mba - iroffa) {

/*        It is assumed that the local rows IIA:IIA+M-1 of the matrix A */
/*        are in the same process row (IAROW). */

/*            ICOFFA */
/*             / \JJA */
/*        IIA  ------------------ ....            -------- */
/*             | .x  |    |    |                 / |    | \ */
/*             | . x |    |    |            ILEFT| |    | | */
/*             | .  x     |    |                 | |    | | */
/*             | .   x    |    |                 \ x    | | */
/*             | .   |x   |    |                   |x   | | IRIGHT */
/*             | .   | x  |    |                   | x  | | */
/*    (IAROW)  | .   |  x |    |                   |  x | | */
/*             | .   |   x|    |                   |   x| | */
/*             | .   |    x    |                   |    x / */
/*             | .   |    |x   |                   |    | */
/*             | .   |    | x  |                   |    | */
/*             | .   |    |  x |                   |    | */
/*             | .   |    |   x|                   |    | */
/*    IIA+M-1  ------------------ ....            ------- */
/*              NB_A */
/*             (IACOL)                          Local picture */

	if (myrow == iarow) {

	    i__1 = *n + icoffa;
	    nqa = numroc_(&i__1, &nba, &mycol, &iacol, &npcol);
	    if (nqa <= 0) {
		return 0;
	    }
	    if (mycol == iacol) {
		nqa -= icoffa;
	    }
	    mydist = (mycol - iacol + npcol) % npcol;
	    ileft = mydist * nba - icoffa;

	    if (lsame_(uplo, "L", (ftnlen)1, (ftnlen)1)) {

		ileft = max(0,ileft);
		jjbeg = jja;
		jjend = jja + nqa - 1;
/* Computing MIN */
		i__1 = iceil_(&jjbeg, &nba) * nba;
		jjnxt = min(i__1,jjend);

L40:
		if (*m - ileft > 0) {
		    i__1 = *m - ileft;
		    i__2 = jjnxt - jjbeg + 1;
		    slaset_(uplo, &i__1, &i__2, alpha, beta, &a[iia + ileft + 
			    (jjbeg - 1) * lda], &lda, (ftnlen)1);
		    mydist += npcol;
		    ileft = mydist * nba - icoffa;
		    jjbeg = jjnxt + 1;
/* Computing MIN */
		    i__1 = jjnxt + nba;
		    jjnxt = min(i__1,jjend);
		    goto L40;
		}

	    } else if (lsame_(uplo, "U", (ftnlen)1, (ftnlen)1)) {

		ii = iia;
		jj = jja;
		nq = nqa;
/* Computing MIN */
		i__1 = ileft + nba;
		iright = min(i__1,*m);
/* Computing MIN */
		i__1 = max(0,ileft);
		ileft = min(i__1,*m);

L50:
		if (ii <= iia + *m - 1) {
		    wide = iright - ileft;
		    i__1 = ileft - ii + iia;
		    slaset_("All", &i__1, &nq, alpha, alpha, &a[ii + (jj - 1) 
			    * lda], &lda, (ftnlen)3);
		    slaset_(uplo, &wide, &nq, alpha, beta, &a[iia + ileft + (
			    jj - 1) * lda], &lda, (ftnlen)1);
/* Computing MAX */
		    i__1 = 0, i__2 = nq - wide;
		    nq = max(i__1,i__2);
		    ii = iia + iright;
		    jj += wide;
		    mydist += npcol;
		    ileft = mydist * nba - icoffa;
/* Computing MIN */
		    i__1 = ileft + nba;
		    iright = min(i__1,*m);
		    ileft = min(ileft,*m);
		    goto L50;
		}

	    } else {

		ii = iia;
		jj = jja;
		nq = nqa;
/* Computing MIN */
		i__1 = ileft + nba;
		iright = min(i__1,*m);
/* Computing MIN */
		i__1 = max(0,ileft);
		ileft = min(i__1,*m);

L60:
		if (ii <= iia + *m - 1) {
		    wide = iright - ileft;
		    i__1 = ileft - ii + iia;
		    slaset_("All", &i__1, &nqa, alpha, alpha, &a[ii + (jja - 
			    1) * lda], &lda, (ftnlen)3);
		    i__1 = nqa - nq;
		    slaset_("All", &wide, &i__1, alpha, alpha, &a[iia + ileft 
			    + (jja - 1) * lda], &lda, (ftnlen)3);
		    slaset_("All", &wide, &nq, alpha, beta, &a[iia + ileft + (
			    jj - 1) * lda], &lda, (ftnlen)3);
/* Computing MAX */
		    i__1 = 0, i__2 = nq - wide;
		    nq = max(i__1,i__2);
		    ii = iia + iright;
		    jj += wide;
		    mydist += npcol;
		    ileft = mydist * nba - icoffa;
/* Computing MIN */
		    i__1 = ileft + nba;
		    iright = min(i__1,*m);
		    ileft = min(ileft,*m);
		    goto L60;
		}

	    }

	}

    }

    return 0;

/*     End of PSLASE2 */

} /* pslase2_ */

