/* /home4/luszczek/mscratch/build/SCALAPACK/SRC/pslantr.f -- translated by f2c (version 20031025).
   You must link the resulting object file with libf2c:
	on Microsoft Windows system, link with libf2c.lib;
	on Linux or Unix systems, link with .../path/to/libf2c.a -lm
	or, if you install libf2c.a in a standard place, with -lf2c -lm
	-- in that order, at the end of the command line, as in
		cc *.o -lf2c -lm
	Source for libf2c is in /netlib/f2c/libf2c.zip, e.g.,

		http://www.netlib.org/f2c/libf2c.zip
*/

#include "f2c.h"

/* Table of constant values */

static integer c__1 = 1;
static integer c_n1 = -1;
static integer c__0 = 0;
static integer c__2 = 2;

real pslantr_(char *norm, char *uplo, char *diag, integer *m, integer *
	n, real *a, integer *ia, integer *ja, integer *desca, real *work, 
	ftnlen norm_len, ftnlen uplo_len, ftnlen diag_len)
{
    /* System generated locals */
    integer i__1, i__2, i__3, i__4, i__5, i__6;
    real ret_val, r__1, r__2, r__3;

    /* Builtin functions */
    double sqrt(doublereal);

    /* Local variables */
    extern /* Subroutine */ int scombssq_();
    integer j, jb, ii, jj, kk, jn, ll, mp, np, nq;
    extern /* Subroutine */ int pstreecomb_(integer *, char *, integer *, 
	    real *, integer *, integer *, U_fp, ftnlen);
    integer lda, iia, jja;
    real sum;
    integer ioffa;
    extern integer iceil_(integer *, integer *);
    integer icoff, iacol;
    real scale;
    logical udiag;
    extern logical lsame_(char *, char *, ftnlen, ftnlen);
    integer iroff, npcol;
    real value;
    integer iarow, mycol, ictxt;
    real rwork[2];
    integer nprow, myrow;
    extern integer lfc_SLisamax(integer *, real *, integer *);
    extern /* Subroutine */ int blacs_gridinfo__(integer *, integer *, 
	    integer *, integer *, integer *);
    extern integer numroc_(integer *, integer *, integer *, integer *, 
	    integer *);
    extern /* Subroutine */ int slassq_(integer *, real *, integer *, real *, 
	    real *), sgebr2d_(integer *, char *, char *, integer *, integer *,
	     real *, integer *, integer *, integer *, ftnlen, ftnlen), 
	    sgebs2d_(integer *, char *, char *, integer *, integer *, real *, 
	    integer *, ftnlen, ftnlen), infog2l_(integer *, integer *, 
	    integer *, integer *, integer *, integer *, integer *, integer *, 
	    integer *, integer *, integer *), sgamx2d_(integer *, char *, 
	    char *, integer *, integer *, real *, integer *, integer *, 
	    integer *, integer *, integer *, integer *, ftnlen, ftnlen), 
	    sgsum2d_(integer *, char *, char *, integer *, integer *, real *, 
	    integer *, integer *, integer *, ftnlen, ftnlen);


/*  -- ScaLAPACK auxiliary routine (version 1.7) -- */
/*     University of Tennessee, Knoxville, Oak Ridge National Laboratory, */
/*     and University of California, Berkeley. */
/*     May 1, 1997 */

/*     .. Scalar Arguments .. */
/*     .. */
/*     .. Array Arguments .. */
/*     .. */

/*  Purpose */
/*  ======= */

/*  PSLANTR returns the value of the one norm, or the Frobenius norm, */
/*  or the infinity norm, or the element of largest absolute value of a */
/*  trapezoidal or triangular distributed matrix sub( A ) denoting */
/*  A(IA:IA+M-1, JA:JA+N-1). */

/*  PSLANTR returns the value */

/*     ( max(abs(A(i,j))),  NORM = 'M' or 'm' with ia <= i <= ia+m-1, */
/*     (                                      and  ja <= j <= ja+n-1, */
/*     ( */
/*     ( norm1( sub( A ) ), NORM = '1', 'O' or 'o' */
/*     ( */
/*     ( normI( sub( A ) ), NORM = 'I' or 'i' */
/*     ( */
/*     ( normF( sub( A ) ), NORM = 'F', 'f', 'E' or 'e' */

/*  where norm1 denotes the  one norm of a matrix (maximum column sum), */
/*  normI denotes the  infinity norm  of a matrix  (maximum row sum) and */
/*  normF denotes the  Frobenius norm of a matrix (square root of sum of */
/*  squares).  Note that  max(abs(A(i,j)))  is not a  matrix norm. */

/*  Notes */
/*  ===== */

/*  Each global data object is described by an associated description */
/*  vector.  This vector stores the information required to establish */
/*  the mapping between an object element and its corresponding process */
/*  and memory location. */

/*  Let A be a generic term for any 2D block cyclicly distributed array. */
/*  Such a global array has an associated description vector DESCA. */
/*  In the following comments, the character _ should be read as */
/*  "of the global array". */

/*  NOTATION        STORED IN      EXPLANATION */
/*  --------------- -------------- -------------------------------------- */
/*  DTYPE_A(global) DESCA( DTYPE_ )The descriptor type.  In this case, */
/*                                 DTYPE_A = 1. */
/*  CTXT_A (global) DESCA( CTXT_ ) The BLACS context handle, indicating */
/*                                 the BLACS process grid A is distribu- */
/*                                 ted over. The context itself is glo- */
/*                                 bal, but the handle (the integer */
/*                                 value) may vary. */
/*  M_A    (global) DESCA( M_ )    The number of rows in the global */
/*                                 array A. */
/*  N_A    (global) DESCA( N_ )    The number of columns in the global */
/*                                 array A. */
/*  MB_A   (global) DESCA( MB_ )   The blocking factor used to distribute */
/*                                 the rows of the array. */
/*  NB_A   (global) DESCA( NB_ )   The blocking factor used to distribute */
/*                                 the columns of the array. */
/*  RSRC_A (global) DESCA( RSRC_ ) The process row over which the first */
/*                                 row of the array A is distributed. */
/*  CSRC_A (global) DESCA( CSRC_ ) The process column over which the */
/*                                 first column of the array A is */
/*                                 distributed. */
/*  LLD_A  (local)  DESCA( LLD_ )  The leading dimension of the local */
/*                                 array.  LLD_A >= MAX(1,LOCr(M_A)). */

/*  Let K be the number of rows or columns of a distributed matrix, */
/*  and assume that its process grid has dimension p x q. */
/*  LOCr( K ) denotes the number of elements of K that a process */
/*  would receive if K were distributed over the p processes of its */
/*  process column. */
/*  Similarly, LOCc( K ) denotes the number of elements of K that a */
/*  process would receive if K were distributed over the q processes of */
/*  its process row. */
/*  The values of LOCr() and LOCc() may be determined via a call to the */
/*  ScaLAPACK tool function, NUMROC: */
/*          LOCr( M ) = NUMROC( M, MB_A, MYROW, RSRC_A, NPROW ), */
/*          LOCc( N ) = NUMROC( N, NB_A, MYCOL, CSRC_A, NPCOL ). */
/*  An upper bound for these quantities may be computed by: */
/*          LOCr( M ) <= ceil( ceil(M/MB_A)/NPROW )*MB_A */
/*          LOCc( N ) <= ceil( ceil(N/NB_A)/NPCOL )*NB_A */

/*  Arguments */
/*  ========= */

/*  NORM    (global input) CHARACTER */
/*          Specifies the value to be returned in PSLANTR as described */
/*          above. */

/*  UPLO    (global input) CHARACTER */
/*          Specifies whether the matrix sub( A ) is upper or lower */
/*          trapezoidal. */
/*          = 'U':  Upper trapezoidal */
/*          = 'L':  Lower trapezoidal */
/*          Note that sub( A ) is triangular instead of trapezoidal */
/*          if M = N. */

/*  DIAG    (global input) CHARACTER */
/*          Specifies whether or not the distributed matrix sub( A ) has */
/*          unit diagonal. */
/*          = 'N':  Non-unit diagonal */
/*          = 'U':  Unit diagonal */

/*  M       (global input) INTEGER */
/*          The number of rows to be operated on i.e the number of rows */
/*          of the distributed submatrix sub( A ). When M = 0, PSLANTR is */
/*          set to zero. M >= 0. */

/*  N       (global input) INTEGER */
/*          The number of columns to be operated on i.e the number of */
/*          columns of the distributed submatrix sub( A ). When N = 0, */
/*          PSLANTR is set to zero. N >= 0. */

/*  A       (local input) REAL pointer into the local memory */
/*          to an array of dimension (LLD_A, LOCc(JA+N-1) ) containing */
/*          the local pieces of sub( A ). */

/*  IA      (global input) INTEGER */
/*          The row index in the global array A indicating the first */
/*          row of sub( A ). */

/*  JA      (global input) INTEGER */
/*          The column index in the global array A indicating the */
/*          first column of sub( A ). */

/*  DESCA   (global and local input) INTEGER array of dimension DLEN_. */
/*          The array descriptor for the distributed matrix A. */

/*  WORK    (local workspace) REAL array dimension (LWORK) */
/*          LWORK >=   0 if NORM = 'M' or 'm' (not referenced), */
/*                   Nq0 if NORM = '1', 'O' or 'o', */
/*                   Mp0 if NORM = 'I' or 'i', */
/*                     0 if NORM = 'F', 'f', 'E' or 'e' (not referenced), */
/*          where */

/*          IROFFA = MOD( IA-1, MB_A ), ICOFFA = MOD( JA-1, NB_A ), */
/*          IAROW = INDXG2P( IA, MB_A, MYROW, RSRC_A, NPROW ), */
/*          IACOL = INDXG2P( JA, NB_A, MYCOL, CSRC_A, NPCOL ), */
/*          Mp0 = NUMROC( M+IROFFA, MB_A, MYROW, IAROW, NPROW ), */
/*          Nq0 = NUMROC( N+ICOFFA, NB_A, MYCOL, IACOL, NPCOL ), */

/*          INDXG2P and NUMROC are ScaLAPACK tool functions; MYROW, */
/*          MYCOL, NPROW and NPCOL can be determined by calling the */
/*          subroutine BLACS_GRIDINFO. */

/*  ===================================================================== */

/*     .. Parameters .. */
/*     .. */
/*     .. Local Scalars .. */
/*     .. */
/*     .. Local Arrays .. */
/*     .. */
/*     .. External Subroutines .. */
/*     .. */
/*     .. External Functions .. */
/*     .. */
/*     .. Intrinsic Functions .. */
/*     .. */
/*     .. Executable Statements .. */

/*     Get grid parameters */

    /* Parameter adjustments */
    --work;
    --desca;
    --a;

    /* Function Body */
    ictxt = desca[2];
    blacs_gridinfo__(&ictxt, &nprow, &npcol, &myrow, &mycol);

    udiag = lsame_(diag, "U", (ftnlen)1, (ftnlen)1);
    infog2l_(ia, ja, &desca[1], &nprow, &npcol, &myrow, &mycol, &iia, &jja, &
	    iarow, &iacol);
    iroff = (*ia - 1) % desca[5];
    icoff = (*ja - 1) % desca[6];
    i__1 = *m + iroff;
    mp = numroc_(&i__1, &desca[5], &myrow, &iarow, &nprow);
    i__1 = *n + icoff;
    nq = numroc_(&i__1, &desca[6], &mycol, &iacol, &npcol);
    if (myrow == iarow) {
	mp -= iroff;
    }
    if (mycol == iacol) {
	nq -= icoff;
    }
    lda = desca[9];
    ioffa = (jja - 1) * lda;

    if (min(*m,*n) == 0) {

	value = 0.f;

    } else if (lsame_(norm, "M", (ftnlen)1, (ftnlen)1)) {

/*        Find max(abs(A(i,j))). */

	if (udiag) {
	    value = 1.f;
	} else {
	    value = 0.f;
	}

	if (lsame_(uplo, "U", (ftnlen)1, (ftnlen)1)) {

/*           Upper triangular matrix */

	    ii = iia;
	    jj = jja;
/* Computing MIN */
	    i__1 = iceil_(ja, &desca[6]) * desca[6], i__2 = *ja + *n - 1;
	    jn = min(i__1,i__2);
	    jb = jn - *ja + 1;

	    if (mycol == iacol) {
		if (myrow == iarow) {
		    if (udiag) {
			i__1 = jj + jb - 1;
			for (ll = jj; ll <= i__1; ++ll) {
/* Computing MIN */
			    i__3 = ii + ll - jj + 1, i__4 = iia + mp - 1;
			    i__2 = min(i__3,i__4);
			    for (kk = iia; kk <= i__2; ++kk) {
/* Computing MAX */
				r__2 = value, r__3 = (r__1 = a[ioffa + kk], 
					dabs(r__1));
				value = dmax(r__2,r__3);
/* L10: */
			    }
			    ioffa += lda;
/* L20: */
			}
		    } else {
			i__1 = jj + jb - 1;
			for (ll = jj; ll <= i__1; ++ll) {
/* Computing MIN */
			    i__3 = ii + ll - jj, i__4 = iia + mp - 1;
			    i__2 = min(i__3,i__4);
			    for (kk = iia; kk <= i__2; ++kk) {
/* Computing MAX */
				r__2 = value, r__3 = (r__1 = a[ioffa + kk], 
					dabs(r__1));
				value = dmax(r__2,r__3);
/* L30: */
			    }
			    ioffa += lda;
/* L40: */
			}
		    }
		} else {
		    i__1 = jj + jb - 1;
		    for (ll = jj; ll <= i__1; ++ll) {
/* Computing MIN */
			i__3 = ii - 1, i__4 = iia + mp - 1;
			i__2 = min(i__3,i__4);
			for (kk = iia; kk <= i__2; ++kk) {
/* Computing MAX */
			    r__2 = value, r__3 = (r__1 = a[ioffa + kk], dabs(
				    r__1));
			    value = dmax(r__2,r__3);
/* L50: */
			}
			ioffa += lda;
/* L60: */
		    }
		}
		jj += jb;
	    }

	    if (myrow == iarow) {
		ii += jb;
	    }
	    iarow = (iarow + 1) % nprow;
	    iacol = (iacol + 1) % npcol;

/*           Loop over remaining block of columns */

	    i__1 = *ja + *n - 1;
	    i__2 = desca[6];
	    for (j = jn + 1; i__2 < 0 ? j >= i__1 : j <= i__1; j += i__2) {
/* Computing MIN */
		i__3 = *ja + *n - j;
		jb = min(i__3,desca[6]);

		if (mycol == iacol) {
		    if (myrow == iarow) {
			if (udiag) {
			    i__3 = jj + jb - 1;
			    for (ll = jj; ll <= i__3; ++ll) {
/* Computing MIN */
				i__5 = ii + ll - jj + 1, i__6 = iia + mp - 1;
				i__4 = min(i__5,i__6);
				for (kk = iia; kk <= i__4; ++kk) {
/* Computing MAX */
				    r__2 = value, r__3 = (r__1 = a[ioffa + kk]
					    , dabs(r__1));
				    value = dmax(r__2,r__3);
/* L70: */
				}
				ioffa += lda;
/* L80: */
			    }
			} else {
			    i__3 = jj + jb - 1;
			    for (ll = jj; ll <= i__3; ++ll) {
/* Computing MIN */
				i__5 = ii + ll - jj, i__6 = iia + mp - 1;
				i__4 = min(i__5,i__6);
				for (kk = iia; kk <= i__4; ++kk) {
/* Computing MAX */
				    r__2 = value, r__3 = (r__1 = a[ioffa + kk]
					    , dabs(r__1));
				    value = dmax(r__2,r__3);
/* L90: */
				}
				ioffa += lda;
/* L100: */
			    }
			}
		    } else {
			i__3 = jj + jb - 1;
			for (ll = jj; ll <= i__3; ++ll) {
/* Computing MIN */
			    i__5 = ii - 1, i__6 = iia + mp - 1;
			    i__4 = min(i__5,i__6);
			    for (kk = iia; kk <= i__4; ++kk) {
/* Computing MAX */
				r__2 = value, r__3 = (r__1 = a[ioffa + kk], 
					dabs(r__1));
				value = dmax(r__2,r__3);
/* L110: */
			    }
			    ioffa += lda;
/* L120: */
			}
		    }
		    jj += jb;
		}

		if (myrow == iarow) {
		    ii += jb;
		}
		iarow = (iarow + 1) % nprow;
		iacol = (iacol + 1) % npcol;

/* L130: */
	    }

	} else {

/*           Lower triangular matrix */

	    ii = iia;
	    jj = jja;
/* Computing MIN */
	    i__2 = iceil_(ja, &desca[6]) * desca[6], i__1 = *ja + *n - 1;
	    jn = min(i__2,i__1);
	    jb = jn - *ja + 1;

	    if (mycol == iacol) {
		if (myrow == iarow) {
		    if (udiag) {
			i__2 = jj + jb - 1;
			for (ll = jj; ll <= i__2; ++ll) {
			    i__1 = iia + mp - 1;
			    for (kk = ii + ll - jj + 1; kk <= i__1; ++kk) {
/* Computing MAX */
				r__2 = value, r__3 = (r__1 = a[ioffa + kk], 
					dabs(r__1));
				value = dmax(r__2,r__3);
/* L140: */
			    }
			    ioffa += lda;
/* L150: */
			}
		    } else {
			i__2 = jj + jb - 1;
			for (ll = jj; ll <= i__2; ++ll) {
			    i__1 = iia + mp - 1;
			    for (kk = ii + ll - jj; kk <= i__1; ++kk) {
/* Computing MAX */
				r__2 = value, r__3 = (r__1 = a[ioffa + kk], 
					dabs(r__1));
				value = dmax(r__2,r__3);
/* L160: */
			    }
			    ioffa += lda;
/* L170: */
			}
		    }
		} else {
		    i__2 = jj + jb - 1;
		    for (ll = jj; ll <= i__2; ++ll) {
			i__1 = iia + mp - 1;
			for (kk = ii; kk <= i__1; ++kk) {
/* Computing MAX */
			    r__2 = value, r__3 = (r__1 = a[ioffa + kk], dabs(
				    r__1));
			    value = dmax(r__2,r__3);
/* L180: */
			}
			ioffa += lda;
/* L190: */
		    }
		}
		jj += jb;
	    }

	    if (myrow == iarow) {
		ii += jb;
	    }
	    iarow = (iarow + 1) % nprow;
	    iacol = (iacol + 1) % npcol;

/*           Loop over remaining block of columns */

	    i__2 = *ja + *n - 1;
	    i__1 = desca[6];
	    for (j = jn + 1; i__1 < 0 ? j >= i__2 : j <= i__2; j += i__1) {
/* Computing MIN */
		i__3 = *ja + *n - j;
		jb = min(i__3,desca[6]);

		if (mycol == iacol) {
		    if (myrow == iarow) {
			if (udiag) {
			    i__3 = jj + jb - 1;
			    for (ll = jj; ll <= i__3; ++ll) {
				i__4 = iia + mp - 1;
				for (kk = ii + ll - jj + 1; kk <= i__4; ++kk) 
					{
/* Computing MAX */
				    r__2 = value, r__3 = (r__1 = a[ioffa + kk]
					    , dabs(r__1));
				    value = dmax(r__2,r__3);
/* L200: */
				}
				ioffa += lda;
/* L210: */
			    }
			} else {
			    i__3 = jj + jb - 1;
			    for (ll = jj; ll <= i__3; ++ll) {
				i__4 = iia + mp - 1;
				for (kk = ii + ll - jj; kk <= i__4; ++kk) {
/* Computing MAX */
				    r__2 = value, r__3 = (r__1 = a[ioffa + kk]
					    , dabs(r__1));
				    value = dmax(r__2,r__3);
/* L220: */
				}
				ioffa += lda;
/* L230: */
			    }
			}
		    } else {
			i__3 = jj + jb - 1;
			for (ll = jj; ll <= i__3; ++ll) {
			    i__4 = iia + mp - 1;
			    for (kk = ii; kk <= i__4; ++kk) {
/* Computing MAX */
				r__2 = value, r__3 = (r__1 = a[ioffa + kk], 
					dabs(r__1));
				value = dmax(r__2,r__3);
/* L240: */
			    }
			    ioffa += lda;
/* L250: */
			}
		    }
		    jj += jb;
		}

		if (myrow == iarow) {
		    ii += jb;
		}
		iarow = (iarow + 1) % nprow;
		iacol = (iacol + 1) % npcol;

/* L260: */
	    }

	}

/*        Gather the intermediate results to process (0,0). */

	sgamx2d_(&ictxt, "All", " ", &c__1, &c__1, &value, &c__1, &kk, &ll, &
		c_n1, &c__0, &c__0, (ftnlen)3, (ftnlen)1);

    } else if (lsame_(norm, "O", (ftnlen)1, (ftnlen)1) || *(unsigned char *)
	    norm == '1') {

	value = 0.f;

	if (lsame_(uplo, "U", (ftnlen)1, (ftnlen)1)) {

/*           Upper triangular matrix */

	    ii = iia;
	    jj = jja;
/* Computing MIN */
	    i__1 = iceil_(ja, &desca[6]) * desca[6], i__2 = *ja + *n - 1;
	    jn = min(i__1,i__2);
	    jb = jn - *ja + 1;

	    if (mycol == iacol) {
		if (myrow == iarow) {
		    if (udiag) {
			i__1 = jj + jb - 1;
			for (ll = jj; ll <= i__1; ++ll) {
			    sum = 1.f;
/* Computing MIN */
			    i__3 = ii + ll - jj, i__4 = iia + mp - 1;
			    i__2 = min(i__3,i__4);
			    for (kk = iia; kk <= i__2; ++kk) {
				sum += (r__1 = a[ioffa + kk], dabs(r__1));
/* L270: */
			    }
			    ioffa += lda;
			    work[ll - jja + 1] = sum;
/* L280: */
			}
		    } else {
			i__1 = jj + jb - 1;
			for (ll = jj; ll <= i__1; ++ll) {
			    sum = 0.f;
/* Computing MIN */
			    i__3 = ii + ll - jj + 1, i__4 = iia + mp - 1;
			    i__2 = min(i__3,i__4);
			    for (kk = iia; kk <= i__2; ++kk) {
				sum += (r__1 = a[ioffa + kk], dabs(r__1));
/* L290: */
			    }
			    ioffa += lda;
			    work[ll - jja + 1] = sum;
/* L300: */
			}
		    }
		} else {
		    i__1 = jj + jb - 1;
		    for (ll = jj; ll <= i__1; ++ll) {
			sum = 0.f;
/* Computing MIN */
			i__3 = ii - 1, i__4 = iia + mp - 1;
			i__2 = min(i__3,i__4);
			for (kk = iia; kk <= i__2; ++kk) {
			    sum += (r__1 = a[ioffa + kk], dabs(r__1));
/* L310: */
			}
			ioffa += lda;
			work[ll - jja + 1] = sum;
/* L320: */
		    }
		}
		jj += jb;
	    }

	    if (myrow == iarow) {
		ii += jb;
	    }
	    iarow = (iarow + 1) % nprow;
	    iacol = (iacol + 1) % npcol;

/*           Loop over remaining block of columns */

	    i__1 = *ja + *n - 1;
	    i__2 = desca[6];
	    for (j = jn + 1; i__2 < 0 ? j >= i__1 : j <= i__1; j += i__2) {
/* Computing MIN */
		i__3 = *ja + *n - j;
		jb = min(i__3,desca[6]);

		if (mycol == iacol) {
		    if (myrow == iarow) {
			if (udiag) {
			    i__3 = jj + jb - 1;
			    for (ll = jj; ll <= i__3; ++ll) {
				sum = 1.f;
/* Computing MIN */
				i__5 = ii + ll - jj + 1, i__6 = iia + mp - 1;
				i__4 = min(i__5,i__6);
				for (kk = iia; kk <= i__4; ++kk) {
				    sum += (r__1 = a[ioffa + kk], dabs(r__1));
/* L330: */
				}
				ioffa += lda;
				work[ll - jja + 1] = sum;
/* L340: */
			    }
			} else {
			    i__3 = jj + jb - 1;
			    for (ll = jj; ll <= i__3; ++ll) {
				sum = 0.f;
/* Computing MIN */
				i__5 = ii + ll - jj, i__6 = iia + mp - 1;
				i__4 = min(i__5,i__6);
				for (kk = iia; kk <= i__4; ++kk) {
				    sum += (r__1 = a[ioffa + kk], dabs(r__1));
/* L350: */
				}
				ioffa += lda;
				work[ll - jja + 1] = sum;
/* L360: */
			    }
			}
		    } else {
			i__3 = jj + jb - 1;
			for (ll = jj; ll <= i__3; ++ll) {
			    sum = 0.f;
/* Computing MIN */
			    i__5 = ii - 1, i__6 = iia + mp - 1;
			    i__4 = min(i__5,i__6);
			    for (kk = iia; kk <= i__4; ++kk) {
				sum += (r__1 = a[ioffa + kk], dabs(r__1));
/* L370: */
			    }
			    ioffa += lda;
			    work[ll - jja + 1] = sum;
/* L380: */
			}
		    }
		    jj += jb;
		}

		if (myrow == iarow) {
		    ii += jb;
		}
		iarow = (iarow + 1) % nprow;
		iacol = (iacol + 1) % npcol;

/* L390: */
	    }

	} else {

/*           Lower triangular matrix */

	    ii = iia;
	    jj = jja;
/* Computing MIN */
	    i__2 = iceil_(ja, &desca[6]) * desca[6], i__1 = *ja + *n - 1;
	    jn = min(i__2,i__1);
	    jb = jn - *ja + 1;

	    if (mycol == iacol) {
		if (myrow == iarow) {
		    if (udiag) {
			i__2 = jj + jb - 1;
			for (ll = jj; ll <= i__2; ++ll) {
			    sum = 1.f;
			    i__1 = iia + mp - 1;
			    for (kk = ii + ll - jj + 1; kk <= i__1; ++kk) {
				sum += (r__1 = a[ioffa + kk], dabs(r__1));
/* L400: */
			    }
			    ioffa += lda;
			    work[ll - jja + 1] = sum;
/* L410: */
			}
		    } else {
			i__2 = jj + jb - 1;
			for (ll = jj; ll <= i__2; ++ll) {
			    sum = 0.f;
			    i__1 = iia + mp - 1;
			    for (kk = ii + ll - jj; kk <= i__1; ++kk) {
				sum += (r__1 = a[ioffa + kk], dabs(r__1));
/* L420: */
			    }
			    ioffa += lda;
			    work[ll - jja + 1] = sum;
/* L430: */
			}
		    }
		} else {
		    i__2 = jj + jb - 1;
		    for (ll = jj; ll <= i__2; ++ll) {
			sum = 0.f;
			i__1 = iia + mp - 1;
			for (kk = ii; kk <= i__1; ++kk) {
			    sum += (r__1 = a[ioffa + kk], dabs(r__1));
/* L440: */
			}
			ioffa += lda;
			work[ll - jja + 1] = sum;
/* L450: */
		    }
		}
		jj += jb;
	    }

	    if (myrow == iarow) {
		ii += jb;
	    }
	    iarow = (iarow + 1) % nprow;
	    iacol = (iacol + 1) % npcol;

/*           Loop over remaining block of columns */

	    i__2 = *ja + *n - 1;
	    i__1 = desca[6];
	    for (j = jn + 1; i__1 < 0 ? j >= i__2 : j <= i__2; j += i__1) {
/* Computing MIN */
		i__3 = *ja + *n - j;
		jb = min(i__3,desca[6]);

		if (mycol == iacol) {
		    if (myrow == iarow) {
			if (udiag) {
			    i__3 = jj + jb - 1;
			    for (ll = jj; ll <= i__3; ++ll) {
				sum = 1.f;
				i__4 = iia + mp - 1;
				for (kk = ii + ll - jj + 1; kk <= i__4; ++kk) 
					{
				    sum += (r__1 = a[ioffa + kk], dabs(r__1));
/* L460: */
				}
				ioffa += lda;
				work[ll - jja + 1] = sum;
/* L470: */
			    }
			} else {
			    i__3 = jj + jb - 1;
			    for (ll = jj; ll <= i__3; ++ll) {
				sum = 0.f;
				i__4 = iia + mp - 1;
				for (kk = ii + ll - jj; kk <= i__4; ++kk) {
				    sum += (r__1 = a[ioffa + kk], dabs(r__1));
/* L480: */
				}
				ioffa += lda;
				work[ll - jja + 1] = sum;
/* L490: */
			    }
			}
		    } else {
			i__3 = jj + jb - 1;
			for (ll = jj; ll <= i__3; ++ll) {
			    sum = 0.f;
			    i__4 = iia + mp - 1;
			    for (kk = ii; kk <= i__4; ++kk) {
				sum += (r__1 = a[ioffa + kk], dabs(r__1));
/* L500: */
			    }
			    ioffa += lda;
			    work[ll - jja + 1] = sum;
/* L510: */
			}
		    }
		    jj += jb;
		}

		if (myrow == iarow) {
		    ii += jb;
		}
		iarow = (iarow + 1) % nprow;
		iacol = (iacol + 1) % npcol;

/* L520: */
	    }

	}

/*        Find sum of global matrix columns and store on row 0 of */
/*        process grid */

	sgsum2d_(&ictxt, "Columnwise", " ", &c__1, &nq, &work[1], &c__1, &
		c__0, &mycol, (ftnlen)10, (ftnlen)1);

/*        Find maximum sum of columns for 1-norm */

	if (myrow == 0) {
	    if (nq > 0) {
		value = work[lfc_SLisamax(&nq, &work[1], &c__1)];
	    } else {
		value = 0.f;
	    }
	    sgamx2d_(&ictxt, "Rowwise", " ", &c__1, &c__1, &value, &c__1, &kk,
		     &ll, &c_n1, &c__0, &c__0, (ftnlen)7, (ftnlen)1);
	}

    } else if (lsame_(norm, "I", (ftnlen)1, (ftnlen)1)) {

	if (lsame_(uplo, "U", (ftnlen)1, (ftnlen)1)) {
	    if (udiag) {
		i__1 = iia + mp - 1;
		for (kk = iia; kk <= i__1; ++kk) {
		    work[kk] = 1.f;
/* L530: */
		}
	    } else {
		i__1 = iia + mp - 1;
		for (kk = iia; kk <= i__1; ++kk) {
		    work[kk] = 0.f;
/* L540: */
		}
	    }
	} else {
	    if (udiag) {
		i__1 = *n + iroff;
		np = numroc_(&i__1, &desca[5], &myrow, &iarow, &nprow);
		if (myrow == iarow) {
		    np -= iroff;
		}
		i__1 = iia + np - 1;
		for (kk = iia; kk <= i__1; ++kk) {
		    work[kk] = 1.f;
/* L550: */
		}
		i__1 = iia + mp - 1;
		for (kk = iia + np; kk <= i__1; ++kk) {
		    work[kk] = 0.f;
/* L560: */
		}
	    } else {
		i__1 = iia + mp - 1;
		for (kk = iia; kk <= i__1; ++kk) {
		    work[kk] = 0.f;
/* L570: */
		}
	    }
	}

	if (lsame_(uplo, "U", (ftnlen)1, (ftnlen)1)) {

/*           Upper triangular matrix */

	    ii = iia;
	    jj = jja;
/* Computing MIN */
	    i__1 = iceil_(ja, &desca[6]) * desca[6], i__2 = *ja + *n - 1;
	    jn = min(i__1,i__2);
	    jb = jn - *ja + 1;

	    if (mycol == iacol) {
		if (myrow == iarow) {
		    if (udiag) {
			i__1 = jj + jb - 1;
			for (ll = jj; ll <= i__1; ++ll) {
/* Computing MIN */
			    i__3 = ii + ll - jj, i__4 = iia + mp - 1;
			    i__2 = min(i__3,i__4);
			    for (kk = iia; kk <= i__2; ++kk) {
				work[kk - iia + 1] += (r__1 = a[ioffa + kk], 
					dabs(r__1));
/* L580: */
			    }
			    ioffa += lda;
/* L590: */
			}
		    } else {
			i__1 = jj + jb - 1;
			for (ll = jj; ll <= i__1; ++ll) {
/* Computing MIN */
			    i__3 = ii + ll - jj + 1, i__4 = iia + mp - 1;
			    i__2 = min(i__3,i__4);
			    for (kk = iia; kk <= i__2; ++kk) {
				work[kk - iia + 1] += (r__1 = a[ioffa + kk], 
					dabs(r__1));
/* L600: */
			    }
			    ioffa += lda;
/* L610: */
			}
		    }
		} else {
		    i__1 = jj + jb - 1;
		    for (ll = jj; ll <= i__1; ++ll) {
/* Computing MIN */
			i__3 = ii - 1, i__4 = iia + mp - 1;
			i__2 = min(i__3,i__4);
			for (kk = iia; kk <= i__2; ++kk) {
			    work[kk - iia + 1] += (r__1 = a[ioffa + kk], dabs(
				    r__1));
/* L620: */
			}
			ioffa += lda;
/* L630: */
		    }
		}
		jj += jb;
	    }

	    if (myrow == iarow) {
		ii += jb;
	    }
	    iarow = (iarow + 1) % nprow;
	    iacol = (iacol + 1) % npcol;

/*           Loop over remaining block of columns */

	    i__1 = *ja + *n - 1;
	    i__2 = desca[6];
	    for (j = jn + 1; i__2 < 0 ? j >= i__1 : j <= i__1; j += i__2) {
/* Computing MIN */
		i__3 = *ja + *n - j;
		jb = min(i__3,desca[6]);

		if (mycol == iacol) {
		    if (myrow == iarow) {
			if (udiag) {
			    i__3 = jj + jb - 1;
			    for (ll = jj; ll <= i__3; ++ll) {
/* Computing MIN */
				i__5 = ii + ll - jj + 1, i__6 = iia + mp - 1;
				i__4 = min(i__5,i__6);
				for (kk = iia; kk <= i__4; ++kk) {
				    work[kk - iia + 1] += (r__1 = a[ioffa + 
					    kk], dabs(r__1));
/* L640: */
				}
				ioffa += lda;
/* L650: */
			    }
			} else {
			    i__3 = jj + jb - 1;
			    for (ll = jj; ll <= i__3; ++ll) {
/* Computing MIN */
				i__5 = ii + ll - jj, i__6 = iia + mp - 1;
				i__4 = min(i__5,i__6);
				for (kk = iia; kk <= i__4; ++kk) {
				    work[kk - iia + 1] += (r__1 = a[ioffa + 
					    kk], dabs(r__1));
/* L660: */
				}
				ioffa += lda;
/* L670: */
			    }
			}
		    } else {
			i__3 = jj + jb - 1;
			for (ll = jj; ll <= i__3; ++ll) {
/* Computing MIN */
			    i__5 = ii - 1, i__6 = iia + mp - 1;
			    i__4 = min(i__5,i__6);
			    for (kk = iia; kk <= i__4; ++kk) {
				work[kk - iia + 1] += (r__1 = a[ioffa + kk], 
					dabs(r__1));
/* L680: */
			    }
			    ioffa += lda;
/* L690: */
			}
		    }
		    jj += jb;
		}

		if (myrow == iarow) {
		    ii += jb;
		}
		iarow = (iarow + 1) % nprow;
		iacol = (iacol + 1) % npcol;

/* L700: */
	    }

	} else {

/*           Lower triangular matrix */

	    ii = iia;
	    jj = jja;
/* Computing MIN */
	    i__2 = iceil_(ja, &desca[6]) * desca[6], i__1 = *ja + *n - 1;
	    jn = min(i__2,i__1);
	    jb = jn - *ja + 1;

	    if (mycol == iacol) {
		if (myrow == iarow) {
		    if (udiag) {
			i__2 = jj + jb - 1;
			for (ll = jj; ll <= i__2; ++ll) {
			    i__1 = iia + mp - 1;
			    for (kk = ii + ll - jj + 1; kk <= i__1; ++kk) {
				work[kk - iia + 1] += (r__1 = a[ioffa + kk], 
					dabs(r__1));
/* L710: */
			    }
			    ioffa += lda;
/* L720: */
			}
		    } else {
			i__2 = jj + jb - 1;
			for (ll = jj; ll <= i__2; ++ll) {
			    i__1 = iia + mp - 1;
			    for (kk = ii + ll - jj; kk <= i__1; ++kk) {
				work[kk - iia + 1] += (r__1 = a[ioffa + kk], 
					dabs(r__1));
/* L730: */
			    }
			    ioffa += lda;
/* L740: */
			}
		    }
		} else {
		    i__2 = jj + jb - 1;
		    for (ll = jj; ll <= i__2; ++ll) {
			i__1 = iia + mp - 1;
			for (kk = ii; kk <= i__1; ++kk) {
			    work[kk - iia + 1] += (r__1 = a[ioffa + kk], dabs(
				    r__1));
/* L750: */
			}
			ioffa += lda;
/* L760: */
		    }
		}
		jj += jb;
	    }

	    if (myrow == iarow) {
		ii += jb;
	    }
	    iarow = (iarow + 1) % nprow;
	    iacol = (iacol + 1) % npcol;

/*           Loop over remaining block of columns */

	    i__2 = *ja + *n - 1;
	    i__1 = desca[6];
	    for (j = jn + 1; i__1 < 0 ? j >= i__2 : j <= i__2; j += i__1) {
/* Computing MIN */
		i__3 = *ja + *n - j;
		jb = min(i__3,desca[6]);

		if (mycol == iacol) {
		    if (myrow == iarow) {
			if (udiag) {
			    i__3 = jj + jb - 1;
			    for (ll = jj; ll <= i__3; ++ll) {
				i__4 = iia + mp - 1;
				for (kk = ii + ll - jj + 1; kk <= i__4; ++kk) 
					{
				    work[kk - iia + 1] += (r__1 = a[ioffa + 
					    kk], dabs(r__1));
/* L770: */
				}
				ioffa += lda;
/* L780: */
			    }
			} else {
			    i__3 = jj + jb - 1;
			    for (ll = jj; ll <= i__3; ++ll) {
				i__4 = iia + mp - 1;
				for (kk = ii + ll - jj; kk <= i__4; ++kk) {
				    work[kk - iia + 1] += (r__1 = a[ioffa + 
					    kk], dabs(r__1));
/* L790: */
				}
				ioffa += lda;
/* L800: */
			    }
			}
		    } else {
			i__3 = jj + jb - 1;
			for (ll = jj; ll <= i__3; ++ll) {
			    i__4 = iia + mp - 1;
			    for (kk = ii; kk <= i__4; ++kk) {
				work[kk - iia + 1] += (r__1 = a[ioffa + kk], 
					dabs(r__1));
/* L810: */
			    }
			    ioffa += lda;
/* L820: */
			}
		    }
		    jj += jb;
		}

		if (myrow == iarow) {
		    ii += jb;
		}
		iarow = (iarow + 1) % nprow;
		iacol = (iacol + 1) % npcol;

/* L830: */
	    }

	}

/*        Find sum of global matrix rows and store on column 0 of */
/*        process grid */

	i__1 = max(1,mp);
	sgsum2d_(&ictxt, "Rowwise", " ", &mp, &c__1, &work[1], &i__1, &myrow, 
		&c__0, (ftnlen)7, (ftnlen)1);

/*        Find maximum sum of rows for Infinity-norm */

	if (mycol == 0) {
	    if (mp > 0) {
		value = work[lfc_SLisamax(&mp, &work[1], &c__1)];
	    } else {
		value = 0.f;
	    }
	    sgamx2d_(&ictxt, "Columnwise", " ", &c__1, &c__1, &value, &c__1, &
		    kk, &ll, &c_n1, &c__0, &c__0, (ftnlen)10, (ftnlen)1);
	}

    } else if (lsame_(norm, "F", (ftnlen)1, (ftnlen)1) || lsame_(norm, "E", (
	    ftnlen)1, (ftnlen)1)) {

	if (udiag) {
	    scale = 1.f;
	    sum = (real) min(*m,*n) / (real) (nprow * npcol);
	} else {
	    scale = 0.f;
	    sum = 1.f;
	}

	if (lsame_(uplo, "U", (ftnlen)1, (ftnlen)1)) {

/*           Upper triangular matrix */

	    ii = iia;
	    jj = jja;
/* Computing MIN */
	    i__1 = iceil_(ja, &desca[6]) * desca[6], i__2 = *ja + *n - 1;
	    jn = min(i__1,i__2);
	    jb = jn - *ja + 1;

	    if (mycol == iacol) {
		if (myrow == iarow) {
		    if (udiag) {
			i__1 = jj + jb - 1;
			for (ll = jj; ll <= i__1; ++ll) {
/* Computing MIN */
			    i__3 = ii + ll - jj, i__4 = iia + mp - 1;
			    i__2 = min(i__3,i__4) - iia + 1;
			    slassq_(&i__2, &a[iia + ioffa], &c__1, &scale, &
				    sum);
			    ioffa += lda;
/* L840: */
			}
		    } else {
			i__1 = jj + jb - 1;
			for (ll = jj; ll <= i__1; ++ll) {
/* Computing MIN */
			    i__3 = ii + ll - jj + 1, i__4 = iia + mp - 1;
			    i__2 = min(i__3,i__4) - iia + 1;
			    slassq_(&i__2, &a[iia + ioffa], &c__1, &scale, &
				    sum);
			    ioffa += lda;
/* L850: */
			}
		    }
		} else {
		    i__1 = jj + jb - 1;
		    for (ll = jj; ll <= i__1; ++ll) {
/* Computing MIN */
			i__3 = ii - 1, i__4 = iia + mp - 1;
			i__2 = min(i__3,i__4) - iia + 1;
			slassq_(&i__2, &a[iia + ioffa], &c__1, &scale, &sum);
			ioffa += lda;
/* L860: */
		    }
		}
		jj += jb;
	    }

	    if (myrow == iarow) {
		ii += jb;
	    }
	    iarow = (iarow + 1) % nprow;
	    iacol = (iacol + 1) % npcol;

/*           Loop over remaining block of columns */

	    i__1 = *ja + *n - 1;
	    i__2 = desca[6];
	    for (j = jn + 1; i__2 < 0 ? j >= i__1 : j <= i__1; j += i__2) {
/* Computing MIN */
		i__3 = *ja + *n - j;
		jb = min(i__3,desca[6]);

		if (mycol == iacol) {
		    if (myrow == iarow) {
			if (udiag) {
			    i__3 = jj + jb - 1;
			    for (ll = jj; ll <= i__3; ++ll) {
/* Computing MIN */
				i__5 = ii + ll - jj + 1, i__6 = iia + mp - 1;
				i__4 = min(i__5,i__6) - iia + 1;
				slassq_(&i__4, &a[iia + ioffa], &c__1, &scale,
					 &sum);
				ioffa += lda;
/* L870: */
			    }
			} else {
			    i__3 = jj + jb - 1;
			    for (ll = jj; ll <= i__3; ++ll) {
/* Computing MIN */
				i__5 = ii + ll - jj, i__6 = iia + mp - 1;
				i__4 = min(i__5,i__6) - iia + 1;
				slassq_(&i__4, &a[iia + ioffa], &c__1, &scale,
					 &sum);
				ioffa += lda;
/* L880: */
			    }
			}
		    } else {
			i__3 = jj + jb - 1;
			for (ll = jj; ll <= i__3; ++ll) {
/* Computing MIN */
			    i__5 = ii - 1, i__6 = iia + mp - 1;
			    i__4 = min(i__5,i__6) - iia + 1;
			    slassq_(&i__4, &a[iia + ioffa], &c__1, &scale, &
				    sum);
			    ioffa += lda;
/* L890: */
			}
		    }
		    jj += jb;
		}

		if (myrow == iarow) {
		    ii += jb;
		}
		iarow = (iarow + 1) % nprow;
		iacol = (iacol + 1) % npcol;

/* L900: */
	    }

	} else {

/*           Lower triangular matrix */

	    ii = iia;
	    jj = jja;
/* Computing MIN */
	    i__2 = iceil_(ja, &desca[6]) * desca[6], i__1 = *ja + *n - 1;
	    jn = min(i__2,i__1);
	    jb = jn - *ja + 1;

	    if (mycol == iacol) {
		if (myrow == iarow) {
		    if (udiag) {
			i__2 = jj + jb - 1;
			for (ll = jj; ll <= i__2; ++ll) {
			    i__1 = iia + mp - (ii + ll - jj + 1);
			    slassq_(&i__1, &a[ii + ll - jj + ioffa], &c__1, &
				    scale, &sum);
			    ioffa += lda;
/* L910: */
			}
		    } else {
			i__2 = jj + jb - 1;
			for (ll = jj; ll <= i__2; ++ll) {
			    i__1 = iia + mp - (ii + ll - jj);
			    slassq_(&i__1, &a[ii + ll - jj + ioffa], &c__1, &
				    scale, &sum);
			    ioffa += lda;
/* L920: */
			}
		    }
		} else {
		    i__2 = jj + jb - 1;
		    for (ll = jj; ll <= i__2; ++ll) {
			i__1 = iia + mp - ii;
			slassq_(&i__1, &a[ii + ioffa], &c__1, &scale, &sum);
			ioffa += lda;
/* L930: */
		    }
		}
		jj += jb;
	    }

	    if (myrow == iarow) {
		ii += jb;
	    }
	    iarow = (iarow + 1) % nprow;
	    iacol = (iacol + 1) % npcol;

/*           Loop over remaining block of columns */

	    i__2 = *ja + *n - 1;
	    i__1 = desca[6];
	    for (j = jn + 1; i__1 < 0 ? j >= i__2 : j <= i__2; j += i__1) {
/* Computing MIN */
		i__3 = *ja + *n - j;
		jb = min(i__3,desca[6]);

		if (mycol == iacol) {
		    if (myrow == iarow) {
			if (udiag) {
			    i__3 = jj + jb - 1;
			    for (ll = jj; ll <= i__3; ++ll) {
				i__4 = iia + mp - (ii + ll - jj + 1);
				slassq_(&i__4, &a[ii + ll - jj + ioffa], &
					c__1, &scale, &sum);
				ioffa += lda;
/* L940: */
			    }
			} else {
			    i__3 = jj + jb - 1;
			    for (ll = jj; ll <= i__3; ++ll) {
				i__4 = iia + mp - (ii + ll - jj);
				slassq_(&i__4, &a[ii + ll - jj + ioffa], &
					c__1, &scale, &sum);
				ioffa += lda;
/* L950: */
			    }
			}
		    } else {
			i__3 = jj + jb - 1;
			for (ll = jj; ll <= i__3; ++ll) {
			    i__4 = iia + mp - ii;
			    slassq_(&i__4, &a[ii + ioffa], &c__1, &scale, &
				    sum);
			    ioffa += lda;
/* L960: */
			}
		    }
		    jj += jb;
		}

		if (myrow == iarow) {
		    ii += jb;
		}
		iarow = (iarow + 1) % nprow;
		iacol = (iacol + 1) % npcol;

/* L970: */
	    }

	}

/*        Perform the global scaled sum */

	rwork[0] = scale;
	rwork[1] = sum;
	pstreecomb_(&ictxt, "All", &c__2, rwork, &c__0, &c__0, (U_fp)
		scombssq_, (ftnlen)3);
	value = rwork[0] * sqrt(rwork[1]);

    }

/*     Broadcast the result to every process in the grid. */

    if (myrow == 0 && mycol == 0) {
	sgebs2d_(&ictxt, "All", " ", &c__1, &c__1, &value, &c__1, (ftnlen)3, (
		ftnlen)1);
    } else {
	sgebr2d_(&ictxt, "All", " ", &c__1, &c__1, &value, &c__1, &c__0, &
		c__0, (ftnlen)3, (ftnlen)1);
    }

    ret_val = value;

    return ret_val;

/*     End of PSLANTR */

} /* pslantr_ */

