/* /home4/luszczek/mscratch/build/SCALAPACK/SRC/pscsum1.f -- translated by f2c (version 20031025).
   You must link the resulting object file with libf2c:
	on Microsoft Windows system, link with libf2c.lib;
	on Linux or Unix systems, link with .../path/to/libf2c.a -lm
	or, if you install libf2c.a in a standard place, with -lf2c -lm
	-- in that order, at the end of the command line, as in
		cc *.o -lf2c -lm
	Source for libf2c is in /netlib/f2c/libf2c.zip, e.g.,

		http://www.netlib.org/f2c/libf2c.zip
*/

#include "f2c.h"

/* Table of constant values */

static integer c__1 = 1;
static integer c_n1 = -1;

/* Subroutine */ int pscsum1_(integer *n, real *asum, complex *x, integer *ix,
	 integer *jx, integer *descx, integer *incx)
{
    /* System generated locals */
    integer i__1;

    /* Builtin functions */
    double c_abs(complex *);

    /* Local variables */
    extern /* Subroutine */ int pb_topget__(integer *, char *, char *, char *,
	     ftnlen, ftnlen, ftnlen);
    integer np, nq, ldx, iix, jjx, icoff, iroff;
    char cctop[1];
    integer npcol, ixcol, mycol;
    char rctop[1];
    integer ictxt, nprow, ixrow, myrow;
    extern real scsum1_(integer *, complex *, integer *);
    extern /* Subroutine */ int blacs_gridinfo__(integer *, integer *, 
	    integer *, integer *, integer *);
    extern integer numroc_(integer *, integer *, integer *, integer *, 
	    integer *);
    extern /* Subroutine */ int infog2l_(integer *, integer *, integer *, 
	    integer *, integer *, integer *, integer *, integer *, integer *, 
	    integer *, integer *), sgsum2d_(integer *, char *, char *, 
	    integer *, integer *, real *, integer *, integer *, integer *, 
	    ftnlen, ftnlen);


/*  -- ScaLAPACK auxiliary routine (version 1.7) -- */
/*     University of Tennessee, Knoxville, Oak Ridge National Laboratory, */
/*     and University of California, Berkeley. */
/*     May 1, 1997 */

/*     .. Scalar Arguments .. */
/*     .. */
/*     .. Array Arguments .. */
/*     .. */

/*  Purpose */
/*  ======= */

/*  PSCSUM1 returns the sum of absolute values of a complex */
/*  distributed vector sub( X ) in ASUM, */

/*  where sub( X ) denotes X(IX:IX+N-1,JX:JX), if INCX = 1, */
/*                         X(IX:IX,JX:JX+N-1), if INCX = M_X. */

/*  Based on PSCASUM from the Level 1 PBLAS. The change is */
/*  to use the 'genuine' absolute value. */

/*  The serial version of this routine was originally contributed by */
/*  Nick Higham for use with CLACON. */

/*  Notes */
/*  ===== */

/*  Each global data object is described by an associated description */
/*  vector.  This vector stores the information required to establish */
/*  the mapping between an object element and its corresponding process */
/*  and memory location. */

/*  Let A be a generic term for any 2D block cyclicly distributed array. */
/*  Such a global array has an associated description vector DESCA. */
/*  In the following comments, the character _ should be read as */
/*  "of the global array". */

/*  NOTATION        STORED IN      EXPLANATION */
/*  --------------- -------------- -------------------------------------- */
/*  DTYPE_A(global) DESCA( DTYPE_ )The descriptor type.  In this case, */
/*                                 DTYPE_A = 1. */
/*  CTXT_A (global) DESCA( CTXT_ ) The BLACS context handle, indicating */
/*                                 the BLACS process grid A is distribu- */
/*                                 ted over. The context itself is glo- */
/*                                 bal, but the handle (the integer */
/*                                 value) may vary. */
/*  M_A    (global) DESCA( M_ )    The number of rows in the global */
/*                                 array A. */
/*  N_A    (global) DESCA( N_ )    The number of columns in the global */
/*                                 array A. */
/*  MB_A   (global) DESCA( MB_ )   The blocking factor used to distribute */
/*                                 the rows of the array. */
/*  NB_A   (global) DESCA( NB_ )   The blocking factor used to distribute */
/*                                 the columns of the array. */
/*  RSRC_A (global) DESCA( RSRC_ ) The process row over which the first */
/*                                 row of the array A is distributed. */
/*  CSRC_A (global) DESCA( CSRC_ ) The process column over which the */
/*                                 first column of the array A is */
/*                                 distributed. */
/*  LLD_A  (local)  DESCA( LLD_ )  The leading dimension of the local */
/*                                 array.  LLD_A >= MAX(1,LOCr(M_A)). */

/*  Let K be the number of rows or columns of a distributed matrix, */
/*  and assume that its process grid has dimension p x q. */
/*  LOCr( K ) denotes the number of elements of K that a process */
/*  would receive if K were distributed over the p processes of its */
/*  process column. */
/*  Similarly, LOCc( K ) denotes the number of elements of K that a */
/*  process would receive if K were distributed over the q processes of */
/*  its process row. */
/*  The values of LOCr() and LOCc() may be determined via a call to the */
/*  ScaLAPACK tool function, NUMROC: */
/*          LOCr( M ) = NUMROC( M, MB_A, MYROW, RSRC_A, NPROW ), */
/*          LOCc( N ) = NUMROC( N, NB_A, MYCOL, CSRC_A, NPCOL ). */
/*  An upper bound for these quantities may be computed by: */
/*          LOCr( M ) <= ceil( ceil(M/MB_A)/NPROW )*MB_A */
/*          LOCc( N ) <= ceil( ceil(N/NB_A)/NPCOL )*NB_A */

/*  Because vectors may be viewed as a subclass of matrices, a */
/*  distributed vector is considered to be a distributed matrix. */

/*  When the result of a vector-oriented PBLAS call is a scalar, it will */
/*  be made available only within the scope which owns the vector(s) */
/*  being operated on.  Let X be a generic term for the input vector(s). */
/*  Then, the processes which receive the answer will be (note that if */
/*  an operation involves more than one vector, the processes which re- */
/*  ceive the result will be the union of the following calculation for */
/*  each vector): */

/*  If N = 1, M_X = 1 and INCX = 1, then one can't determine if a process */
/*  row or process column owns the vector operand, therefore only the */
/*  process of coordinate {RSRC_X, CSRC_X} receives the result; */

/*  If INCX = M_X, then sub( X ) is a vector distributed over a process */
/*  row. Each process part of this row receives the result; */

/*  If INCX = 1, then sub( X ) is a vector distributed over a process */
/*  column. Each process part of this column receives the result; */

/*  Parameters */
/*  ========== */

/*  N       (global input) pointer to INTEGER */
/*          The number of components of the distributed vector sub( X ). */
/*          N >= 0. */

/*  ASUM    (local output) pointer to REAL */
/*          The sum of absolute values of the distributed vector sub( X ) */
/*          only in its scope. */

/*  X       (local input) COMPLEX array containing the local */
/*          pieces of a distributed matrix of dimension of at least */
/*              ( (JX-1)*M_X + IX + ( N - 1 )*abs( INCX ) ) */
/*          This array contains the entries of the distributed vector */
/*          sub( X ). */

/*  IX      (global input) pointer to INTEGER */
/*          The global row index of the submatrix of the distributed */
/*          matrix X to operate on. */

/*  JX      (global input) pointer to INTEGER */
/*          The global column index of the submatrix of the distributed */
/*          matrix X to operate on. */

/*  DESCX   (global and local input) INTEGER array of dimension 8. */
/*          The array descriptor of the distributed matrix X. */

/*  INCX    (global input) pointer to INTEGER */
/*          The global increment for the elements of X. Only two values */
/*          of INCX are supported in this version, namely 1 and M_X. */

/*  ===================================================================== */

/*     .. Parameters .. */
/*     .. */
/*     .. Local Scalars .. */
/*     .. */
/*     .. External Subroutines .. */
/*     .. */
/*     .. External Functions .. */
/*     .. */
/*     .. Intrinsic Functions .. */
/*     .. */
/*     .. Executable Statements .. */

    /* Parameter adjustments */
    --descx;
    --x;

    /* Function Body */
    ictxt = descx[2];
    blacs_gridinfo__(&ictxt, &nprow, &npcol, &myrow, &mycol);

/*     Quick return if possible */

    *asum = 0.f;
    if (*n <= 0) {
	return 0;
    }

    ldx = descx[9];
    infog2l_(ix, jx, &descx[1], &nprow, &npcol, &myrow, &mycol, &iix, &jjx, &
	    ixrow, &ixcol);

    if (*incx == 1 && descx[3] == 1 && *n == 1) {
	if (myrow == ixrow && mycol == ixcol) {
	    *asum = c_abs(&x[iix + (jjx - 1) * ldx]);
	}
	return 0;
    }

    if (*incx == descx[3]) {

/*        X is distributed over a process row */

	if (myrow == ixrow) {
	    pb_topget__(&ictxt, "Combine", "Rowwise", rctop, (ftnlen)7, (
		    ftnlen)7, (ftnlen)1);
	    icoff = (*jx - 1) % descx[6];
	    i__1 = *n + icoff;
	    nq = numroc_(&i__1, &descx[6], &mycol, &ixcol, &npcol);
	    if (mycol == ixcol) {
		nq -= icoff;
	    }
	    *asum = scsum1_(&nq, &x[iix + (jjx - 1) * ldx], &ldx);
	    sgsum2d_(&ictxt, "Rowwise", rctop, &c__1, &c__1, asum, &c__1, &
		    c_n1, &mycol, (ftnlen)7, (ftnlen)1);
	}

    } else {

/*        X is distributed over a process column */

	if (mycol == ixcol) {
	    pb_topget__(&ictxt, "Combine", "Columnwise", cctop, (ftnlen)7, (
		    ftnlen)10, (ftnlen)1);
	    iroff = (*ix - 1) % descx[5];
	    i__1 = *n + iroff;
	    np = numroc_(&i__1, &descx[5], &myrow, &ixrow, &nprow);
	    if (myrow == ixrow) {
		np -= iroff;
	    }
	    *asum = scsum1_(&np, &x[iix + (jjx - 1) * ldx], &c__1);
	    sgsum2d_(&ictxt, "Columnwise", cctop, &c__1, &c__1, asum, &c__1, &
		    c_n1, &mycol, (ftnlen)10, (ftnlen)1);
	}

    }

    return 0;

/*     End of PSCSUM1 */

} /* pscsum1_ */

