/* /home4/luszczek/mscratch/build/SCALAPACK/SRC/pdrscl.f -- translated by f2c (version 20031025).
   You must link the resulting object file with libf2c:
	on Microsoft Windows system, link with libf2c.lib;
	on Linux or Unix systems, link with .../path/to/libf2c.a -lm
	or, if you install libf2c.a in a standard place, with -lf2c -lm
	-- in that order, at the end of the command line, as in
		cc *.o -lf2c -lm
	Source for libf2c is in /netlib/f2c/libf2c.zip, e.g.,

		http://www.netlib.org/f2c/libf2c.zip
*/

#include "f2c.h"

/* Subroutine */ int pdrscl_(integer *n, doublereal *sa, doublereal *sx, 
	integer *ix, integer *jx, integer *descx, integer *incx)
{
    doublereal mul, cden;
    logical done;
    doublereal cnum, cden1, cnum1;
    integer npcol, mycol, ictxt, nprow, myrow;
    extern /* Subroutine */ int pdscal_(integer *, doublereal *, doublereal *,
	     integer *, integer *, integer *, integer *);
    doublereal bignum;
    extern /* Subroutine */ int blacs_gridinfo__(integer *, integer *, 
	    integer *, integer *, integer *);
    doublereal smlnum;
    extern /* Subroutine */ int pdlabad_(integer *, doublereal *, doublereal *
	    );
    extern doublereal pdlamch_(integer *, char *, ftnlen);


/*  -- ScaLAPACK auxiliary routine (version 1.7) -- */
/*     University of Tennessee, Knoxville, Oak Ridge National Laboratory, */
/*     and University of California, Berkeley. */
/*     May 1, 1997 */

/*     .. Scalar Arguments .. */
/*     .. */
/*     .. Array Arguments .. */
/*     .. */

/*  Purpose */
/*  ======= */

/*  PDRSCL multiplies an N-element real distributed vector sub( X ) by */
/*  the real scalar 1/a. This is done without overflow or underflow as */
/*  long as the final result sub( X )/a does not overflow or underflow. */

/*  where sub( X ) denotes X(IX:IX+N-1,JX:JX), if INCX = 1, */
/*                         X(IX:IX,JX:JX+N-1), if INCX = M_X. */

/*  Notes */
/*  ===== */

/*  Each global data object is described by an associated description */
/*  vector.  This vector stores the information required to establish */
/*  the mapping between an object element and its corresponding process */
/*  and memory location. */

/*  Let A be a generic term for any 2D block cyclicly distributed array. */
/*  Such a global array has an associated description vector descA. */
/*  In the following comments, the character _ should be read as */
/*  "of the global array". */

/*  NOTATION        STORED IN      EXPLANATION */
/*  --------------- -------------- -------------------------------------- */
/*  DT_A   (global) descA[ DT_ ]   The descriptor type.  In this case, */
/*                                 DT_A = 1. */
/*  CTXT_A (global) descA[ CTXT_ ] The BLACS context handle, indicating */
/*                                 the BLACS process grid A is distribu- */
/*                                 ted over. The context itself is glo- */
/*                                 bal, but the handle (the integer */
/*                                 value) may vary. */
/*  M_A    (global) descA[ M_ ]    The number of rows in the global */
/*                                 array A. */
/*  N_A    (global) descA[ N_ ]    The number of columns in the global */
/*                                 array A. */
/*  MB_A   (global) descA[ MB_ ]   The blocking factor used to distribu- */
/*                                 te the rows of the array. */
/*  NB_A   (global) descA[ NB_ ]   The blocking factor used to distribu- */
/*                                 te the columns of the array. */
/*  RSRC_A (global) descA[ RSRC_ ] The process row over which the first */
/*                                 row of the array A is distributed. */
/*  CSRC_A (global) descA[ CSRC_ ] The process column over which the */
/*                                 first column of the array A is */
/*                                 distributed. */
/*  LLD_A  (local)  descA[ LLD_ ]  The leading dimension of the local */
/*                                 array.  LLD_A >= MAX(1,LOCr(M_A)). */

/*  Let K be the number of rows or columns of a distributed matrix, */
/*  and assume that its process grid has dimension p x q. */
/*  LOCr( K ) denotes the number of elements of K that a process */
/*  would receive if K were distributed over the p processes of its */
/*  process column. */
/*  Similarly, LOCc( K ) denotes the number of elements of K that a */
/*  process would receive if K were distributed over the q processes of */
/*  its process row. */
/*  The values of LOCr() and LOCc() may be determined via a call to the */
/*  ScaLAPACK tool function, NUMROC: */
/*          LOCr( M ) = NUMROC( M, MB_A, MYROW, RSRC_A, NPROW ), */
/*          LOCc( N ) = NUMROC( N, NB_A, MYCOL, CSRC_A, NPCOL ). */
/*  An upper bound for these quantities may be computed by: */
/*          LOCr( M ) <= ceil( ceil(M/MB_A)/NPROW )*MB_A */
/*          LOCc( N ) <= ceil( ceil(N/NB_A)/NPCOL )*NB_A */

/*  Because vectors may be seen as particular matrices, a distributed */
/*  vector is considered to be a distributed matrix. */

/*  Arguments */
/*  ========= */

/*  N       (global input) pointer to INTEGER */
/*          The number of components of the distributed vector sub( X ). */
/*          N >= 0. */

/*  SA      (global input) DOUBLE PRECISION */
/*          The scalar a which is used to divide each component of */
/*          sub( X ).  SA must be >= 0, or the subroutine will divide by */
/*          zero. */

/*  SX      (local input/local output) DOUBLE PRECISION array */
/*          containing the local pieces of a distributed matrix of */
/*          dimension of at least */
/*              ( (JX-1)*M_X + IX + ( N - 1 )*abs( INCX ) ) */
/*          This array contains the entries of the distributed vector */
/*          sub( X ). */

/*  IX      (global input) pointer to INTEGER */
/*          The global row index of the submatrix of the distributed */
/*          matrix X to operate on. */

/*  JX      (global input) pointer to INTEGER */
/*          The global column index of the submatrix of the distributed */
/*          matrix X to operate on. */

/*  DESCX   (global and local input) INTEGER array of dimension 8. */
/*          The array descriptor of the distributed matrix X. */

/*  INCX    (global input) pointer to INTEGER */
/*          The global increment for the elements of X. Only two values */
/*          of INCX are supported in this version, namely 1 and M_X. */

/* ===================================================================== */

/*     .. Parameters .. */
/*     .. */
/*     .. Local Scalars .. */
/*     .. */
/*     .. External Subroutines .. */
/*     .. */
/*     .. External Functions .. */
/*     .. */
/*     .. Intrinsic Functions .. */
/*     .. */
/*     .. Executable Statements .. */

/*     Get grid parameters */

    /* Parameter adjustments */
    --descx;
    --sx;

    /* Function Body */
    ictxt = descx[2];
    blacs_gridinfo__(&ictxt, &nprow, &npcol, &myrow, &mycol);

/*     Quick return if possible */

    if (*n <= 0) {
	return 0;
    }

/*     Get machine parameters */

    smlnum = pdlamch_(&ictxt, "S", (ftnlen)1);
    bignum = 1. / smlnum;
    pdlabad_(&ictxt, &smlnum, &bignum);

/*     Initialize the denominator to SA and the numerator to 1. */

    cden = *sa;
    cnum = 1.;

L10:
    cden1 = cden * smlnum;
    cnum1 = cnum / bignum;
    if (abs(cden1) > abs(cnum) && cnum != 0.) {

/*        Pre-multiply sub( X ) by SMLNUM if CDEN is large compared to */
/*        CNUM. */

	mul = smlnum;
	done = FALSE_;
	cden = cden1;
    } else if (abs(cnum1) > abs(cden)) {

/*        Pre-multiply sub( X ) by BIGNUM if CDEN is small compared to */
/*        CNUM. */

	mul = bignum;
	done = FALSE_;
	cnum = cnum1;
    } else {

/*        Multiply sub( X ) by CNUM / CDEN and return. */

	mul = cnum / cden;
	done = TRUE_;
    }

/*     Scale the vector sub( X ) by MUL */

    pdscal_(n, &mul, &sx[1], ix, jx, &descx[1], incx);

    if (! done) {
	goto L10;
    }

    return 0;

/*     End of PDRSCL */

} /* pdrscl_ */

