/* /home4/luszczek/mscratch/build/SCALAPACK/SRC/pdlarfg.f -- translated by f2c (version 20031025).
   You must link the resulting object file with libf2c:
	on Microsoft Windows system, link with libf2c.lib;
	on Linux or Unix systems, link with .../path/to/libf2c.a -lm
	or, if you install libf2c.a in a standard place, with -lf2c -lm
	-- in that order, at the end of the command line, as in
		cc *.o -lf2c -lm
	Source for libf2c is in /netlib/f2c/libf2c.zip, e.g.,

		http://www.netlib.org/f2c/libf2c.zip
*/

#include "f2c.h"

/* Table of constant values */

static integer c__1 = 1;

/* Subroutine */ int pdlarfg_(integer *n, doublereal *alpha, integer *iax, 
	integer *jax, doublereal *x, integer *ix, integer *jx, integer *descx,
	 integer *incx, doublereal *tau)
{
    /* System generated locals */
    integer i__1;
    doublereal d__1;

    /* Builtin functions */
    double d_sign(doublereal *, doublereal *);

    /* Local variables */
    integer j, knt;
    doublereal beta;
    integer iiax, jjax, npcol, ixcol, mycol, ictxt;
    doublereal xnorm;
    integer nprow, ixrow, myrow;
    extern doublereal dlapy2_(doublereal *, doublereal *);
    extern /* Subroutine */ int pdnrm2_(integer *, doublereal *, doublereal *,
	     integer *, integer *, integer *, integer *);
    extern doublereal dlamch_(char *, ftnlen);
    extern /* Subroutine */ int pdscal_(integer *, doublereal *, doublereal *,
	     integer *, integer *, integer *, integer *);
    doublereal safmin, rsafmn;
    extern /* Subroutine */ int blacs_gridinfo__(integer *, integer *, 
	    integer *, integer *, integer *), dgebr2d_(integer *, char *, 
	    char *, integer *, integer *, doublereal *, integer *, integer *, 
	    integer *, ftnlen, ftnlen), dgebs2d_(integer *, char *, char *, 
	    integer *, integer *, doublereal *, integer *, ftnlen, ftnlen), 
	    infog2l_(integer *, integer *, integer *, integer *, integer *, 
	    integer *, integer *, integer *, integer *, integer *, integer *);
    integer indxtau;


/*  -- ScaLAPACK auxiliary routine (version 1.7) -- */
/*     University of Tennessee, Knoxville, Oak Ridge National Laboratory, */
/*     and University of California, Berkeley. */
/*     May 1, 1997 */

/*     .. Scalar Arguments .. */
/*     .. */
/*     .. Array Arguments .. */
/*     .. */

/*  Purpose */
/*  ======= */

/*  PDLARFG generates a real elementary reflector H of order n, such */
/*  that */

/*     H * sub( X ) = H * ( x(iax,jax) ) = ( alpha ),   H' * H = I. */
/*                        (      x     )   (   0   ) */

/*  where alpha is a scalar, and sub( X ) is an (N-1)-element real */
/*  distributed vector X(IX:IX+N-2,JX) if INCX = 1 and X(IX,JX:JX+N-2) if */
/*  INCX = DESCX(M_).  H is represented in the form */

/*        H = I - tau * ( 1 ) * ( 1 v' ) , */
/*                      ( v ) */

/*  where tau is a real scalar and v is a real (N-1)-element */
/*  vector. */

/*  If the elements of sub( X ) are all zero, then tau = 0 and H is */
/*  taken to be the unit matrix. */

/*  Otherwise  1 <= tau <= 2. */

/*  Notes */
/*  ===== */

/*  Each global data object is described by an associated description */
/*  vector.  This vector stores the information required to establish */
/*  the mapping between an object element and its corresponding process */
/*  and memory location. */

/*  Let A be a generic term for any 2D block cyclicly distributed array. */
/*  Such a global array has an associated description vector DESCA. */
/*  In the following comments, the character _ should be read as */
/*  "of the global array". */

/*  NOTATION        STORED IN      EXPLANATION */
/*  --------------- -------------- -------------------------------------- */
/*  DTYPE_A(global) DESCA( DTYPE_ )The descriptor type.  In this case, */
/*                                 DTYPE_A = 1. */
/*  CTXT_A (global) DESCA( CTXT_ ) The BLACS context handle, indicating */
/*                                 the BLACS process grid A is distribu- */
/*                                 ted over. The context itself is glo- */
/*                                 bal, but the handle (the integer */
/*                                 value) may vary. */
/*  M_A    (global) DESCA( M_ )    The number of rows in the global */
/*                                 array A. */
/*  N_A    (global) DESCA( N_ )    The number of columns in the global */
/*                                 array A. */
/*  MB_A   (global) DESCA( MB_ )   The blocking factor used to distribute */
/*                                 the rows of the array. */
/*  NB_A   (global) DESCA( NB_ )   The blocking factor used to distribute */
/*                                 the columns of the array. */
/*  RSRC_A (global) DESCA( RSRC_ ) The process row over which the first */
/*                                 row of the array A is distributed. */
/*  CSRC_A (global) DESCA( CSRC_ ) The process column over which the */
/*                                 first column of the array A is */
/*                                 distributed. */
/*  LLD_A  (local)  DESCA( LLD_ )  The leading dimension of the local */
/*                                 array.  LLD_A >= MAX(1,LOCr(M_A)). */

/*  Let K be the number of rows or columns of a distributed matrix, */
/*  and assume that its process grid has dimension p x q. */
/*  LOCr( K ) denotes the number of elements of K that a process */
/*  would receive if K were distributed over the p processes of its */
/*  process column. */
/*  Similarly, LOCc( K ) denotes the number of elements of K that a */
/*  process would receive if K were distributed over the q processes of */
/*  its process row. */
/*  The values of LOCr() and LOCc() may be determined via a call to the */
/*  ScaLAPACK tool function, NUMROC: */
/*          LOCr( M ) = NUMROC( M, MB_A, MYROW, RSRC_A, NPROW ), */
/*          LOCc( N ) = NUMROC( N, NB_A, MYCOL, CSRC_A, NPCOL ). */
/*  An upper bound for these quantities may be computed by: */
/*          LOCr( M ) <= ceil( ceil(M/MB_A)/NPROW )*MB_A */
/*          LOCc( N ) <= ceil( ceil(N/NB_A)/NPCOL )*NB_A */

/*  Because vectors may be viewed as a subclass of matrices, a */
/*  distributed vector is considered to be a distributed matrix. */

/*  Arguments */
/*  ========= */

/*  N       (global input) INTEGER */
/*          The global order of the elementary reflector. N >= 0. */

/*  ALPHA   (local output) DOUBLE PRECISION */
/*          On exit, alpha is computed in the process scope having the */
/*          vector sub( X ). */

/*  IAX     (global input) INTEGER */
/*          The global row index in X of X(IAX,JAX). */

/*  JAX     (global input) INTEGER */
/*          The global column index in X of X(IAX,JAX). */

/*  X       (local input/local output) DOUBLE PRECISION, pointer into the */
/*          local memory to an array of dimension (LLD_X,*). This array */
/*          contains the local pieces of the distributed vector sub( X ). */
/*          Before entry, the incremented array sub( X ) must contain */
/*          the vector x. On exit, it is overwritten with the vector v. */

/*  IX      (global input) INTEGER */
/*          The row index in the global array X indicating the first */
/*          row of sub( X ). */

/*  JX      (global input) INTEGER */
/*          The column index in the global array X indicating the */
/*          first column of sub( X ). */

/*  DESCX   (global and local input) INTEGER array of dimension DLEN_. */
/*          The array descriptor for the distributed matrix X. */

/*  INCX    (global input) INTEGER */
/*          The global increment for the elements of X. Only two values */
/*          of INCX are supported in this version, namely 1 and M_X. */
/*          INCX must not be zero. */

/*  TAU     (local output) DOUBLE PRECISION array, dimension  LOCc(JX) */
/*          if INCX = 1, and LOCr(IX) otherwise. This array contains the */
/*          Householder scalars related to the Householder vectors. */
/*          TAU is tied to the distributed matrix X. */

/*  ===================================================================== */

/*     .. Parameters .. */
/*     .. */
/*     .. Local Scalars .. */
/*     .. */
/*     .. External Subroutines .. */
/*     .. */
/*     .. External Functions .. */
/*     .. */
/*     .. Intrinsic Functions .. */
/*     .. */
/*     .. Executable Statements .. */

/*     Get grid parameters. */

    /* Parameter adjustments */
    --tau;
    --descx;
    --x;

    /* Function Body */
    ictxt = descx[2];
    blacs_gridinfo__(&ictxt, &nprow, &npcol, &myrow, &mycol);

    if (*incx == descx[3]) {

/*        sub( X ) is distributed across a process row. */

	infog2l_(ix, jax, &descx[1], &nprow, &npcol, &myrow, &mycol, &iiax, &
		jjax, &ixrow, &ixcol);

	if (myrow != ixrow) {
	    return 0;
	}

/*        Broadcast X(IAX,JAX) across the process row. */

	if (mycol == ixcol) {
	    j = iiax + (jjax - 1) * descx[9];
	    dgebs2d_(&ictxt, "Rowwise", " ", &c__1, &c__1, &x[j], &c__1, (
		    ftnlen)7, (ftnlen)1);
	    *alpha = x[j];
	} else {
	    dgebr2d_(&ictxt, "Rowwise", " ", &c__1, &c__1, alpha, &c__1, &
		    myrow, &ixcol, (ftnlen)7, (ftnlen)1);
	}

	indxtau = iiax;

    } else {

/*        sub( X ) is distributed across a process column. */

	infog2l_(iax, jx, &descx[1], &nprow, &npcol, &myrow, &mycol, &iiax, &
		jjax, &ixrow, &ixcol);

	if (mycol != ixcol) {
	    return 0;
	}

/*        Broadcast X(IAX,JAX) across the process column. */

	if (myrow == ixrow) {
	    j = iiax + (jjax - 1) * descx[9];
	    dgebs2d_(&ictxt, "Columnwise", " ", &c__1, &c__1, &x[j], &c__1, (
		    ftnlen)10, (ftnlen)1);
	    *alpha = x[j];
	} else {
	    dgebr2d_(&ictxt, "Columnwise", " ", &c__1, &c__1, alpha, &c__1, &
		    ixrow, &mycol, (ftnlen)10, (ftnlen)1);
	}

	indxtau = jjax;

    }

    if (*n <= 0) {
	tau[indxtau] = 0.;
	return 0;
    }

    i__1 = *n - 1;
    pdnrm2_(&i__1, &xnorm, &x[1], ix, jx, &descx[1], incx);

    if (xnorm == 0.) {

/*        H = I */

	tau[indxtau] = 0.;

    } else {

/*        General case */

	d__1 = dlapy2_(alpha, &xnorm);
	beta = -d_sign(&d__1, alpha);
	safmin = dlamch_("S", (ftnlen)1);
	rsafmn = 1. / safmin;
	if (abs(beta) < safmin) {

/*           XNORM, BETA may be inaccurate; scale X and recompute them */

	    knt = 0;
L10:
	    ++knt;
	    i__1 = *n - 1;
	    pdscal_(&i__1, &rsafmn, &x[1], ix, jx, &descx[1], incx);
	    beta *= rsafmn;
	    *alpha *= rsafmn;
	    if (abs(beta) < safmin) {
		goto L10;
	    }

/*           New BETA is at most 1, at least SAFMIN */

	    i__1 = *n - 1;
	    pdnrm2_(&i__1, &xnorm, &x[1], ix, jx, &descx[1], incx);
	    d__1 = dlapy2_(alpha, &xnorm);
	    beta = -d_sign(&d__1, alpha);
	    tau[indxtau] = (beta - *alpha) / beta;
	    i__1 = *n - 1;
	    d__1 = 1. / (*alpha - beta);
	    pdscal_(&i__1, &d__1, &x[1], ix, jx, &descx[1], incx);

/*           If ALPHA is subnormal, it may lose relative accuracy */

	    *alpha = beta;
	    i__1 = knt;
	    for (j = 1; j <= i__1; ++j) {
		*alpha *= safmin;
/* L20: */
	    }
	} else {
	    tau[indxtau] = (beta - *alpha) / beta;
	    i__1 = *n - 1;
	    d__1 = 1. / (*alpha - beta);
	    pdscal_(&i__1, &d__1, &x[1], ix, jx, &descx[1], incx);
	    *alpha = beta;
	}
    }

    return 0;

/*     End of PDLARFG */

} /* pdlarfg_ */

