/* /home4/luszczek/mscratch/build/SCALAPACK/SRC/pdlaqge.f -- translated by f2c (version 20031025).
   You must link the resulting object file with libf2c:
	on Microsoft Windows system, link with libf2c.lib;
	on Linux or Unix systems, link with .../path/to/libf2c.a -lm
	or, if you install libf2c.a in a standard place, with -lf2c -lm
	-- in that order, at the end of the command line, as in
		cc *.o -lf2c -lm
	Source for libf2c is in /netlib/f2c/libf2c.zip, e.g.,

		http://www.netlib.org/f2c/libf2c.zip
*/

#include "f2c.h"

/* Subroutine */ int pdlaqge_(integer *m, integer *n, doublereal *a, integer *
	ia, integer *ja, integer *desca, doublereal *r__, doublereal *c__, 
	doublereal *rowcnd, doublereal *colcnd, doublereal *amax, char *equed,
	 ftnlen equed_len)
{
    /* System generated locals */
    integer i__1, i__2;

    /* Local variables */
    integer i__, j;
    doublereal cj;
    integer mp, nq, lda, iia, jja, ioffa, icoff, iacol;
    doublereal large;
    integer iroff;
    doublereal small;
    integer npcol, iarow, mycol, ictxt, nprow, myrow;
    extern /* Subroutine */ int blacs_gridinfo__(integer *, integer *, 
	    integer *, integer *, integer *);
    extern integer numroc_(integer *, integer *, integer *, integer *, 
	    integer *);
    extern /* Subroutine */ int infog2l_(integer *, integer *, integer *, 
	    integer *, integer *, integer *, integer *, integer *, integer *, 
	    integer *, integer *);
    extern doublereal pdlamch_(integer *, char *, ftnlen);


/*  -- ScaLAPACK auxiliary routine (version 1.7) -- */
/*     University of Tennessee, Knoxville, Oak Ridge National Laboratory, */
/*     and University of California, Berkeley. */
/*     May 1, 1997 */

/*     .. Scalar Arguments .. */
/*     .. */
/*     .. Array Arguments .. */
/*     .. */

/*  Purpose */
/*  ======= */

/*  PDLAQGE equilibrates a general M-by-N distributed matrix */
/*  sub( A ) = A(IA:IA+M-1,JA:JA+N-1) using the row and scaling */
/*  factors in the vectors R and C. */

/*  Notes */
/*  ===== */

/*  Each global data object is described by an associated description */
/*  vector.  This vector stores the information required to establish */
/*  the mapping between an object element and its corresponding process */
/*  and memory location. */

/*  Let A be a generic term for any 2D block cyclicly distributed array. */
/*  Such a global array has an associated description vector DESCA. */
/*  In the following comments, the character _ should be read as */
/*  "of the global array". */

/*  NOTATION        STORED IN      EXPLANATION */
/*  --------------- -------------- -------------------------------------- */
/*  DTYPE_A(global) DESCA( DTYPE_ )The descriptor type.  In this case, */
/*                                 DTYPE_A = 1. */
/*  CTXT_A (global) DESCA( CTXT_ ) The BLACS context handle, indicating */
/*                                 the BLACS process grid A is distribu- */
/*                                 ted over. The context itself is glo- */
/*                                 bal, but the handle (the integer */
/*                                 value) may vary. */
/*  M_A    (global) DESCA( M_ )    The number of rows in the global */
/*                                 array A. */
/*  N_A    (global) DESCA( N_ )    The number of columns in the global */
/*                                 array A. */
/*  MB_A   (global) DESCA( MB_ )   The blocking factor used to distribute */
/*                                 the rows of the array. */
/*  NB_A   (global) DESCA( NB_ )   The blocking factor used to distribute */
/*                                 the columns of the array. */
/*  RSRC_A (global) DESCA( RSRC_ ) The process row over which the first */
/*                                 row of the array A is distributed. */
/*  CSRC_A (global) DESCA( CSRC_ ) The process column over which the */
/*                                 first column of the array A is */
/*                                 distributed. */
/*  LLD_A  (local)  DESCA( LLD_ )  The leading dimension of the local */
/*                                 array.  LLD_A >= MAX(1,LOCr(M_A)). */

/*  Let K be the number of rows or columns of a distributed matrix, */
/*  and assume that its process grid has dimension p x q. */
/*  LOCr( K ) denotes the number of elements of K that a process */
/*  would receive if K were distributed over the p processes of its */
/*  process column. */
/*  Similarly, LOCc( K ) denotes the number of elements of K that a */
/*  process would receive if K were distributed over the q processes of */
/*  its process row. */
/*  The values of LOCr() and LOCc() may be determined via a call to the */
/*  ScaLAPACK tool function, NUMROC: */
/*          LOCr( M ) = NUMROC( M, MB_A, MYROW, RSRC_A, NPROW ), */
/*          LOCc( N ) = NUMROC( N, NB_A, MYCOL, CSRC_A, NPCOL ). */
/*  An upper bound for these quantities may be computed by: */
/*          LOCr( M ) <= ceil( ceil(M/MB_A)/NPROW )*MB_A */
/*          LOCc( N ) <= ceil( ceil(N/NB_A)/NPCOL )*NB_A */

/*  Arguments */
/*  ========= */

/*  M       (global input) INTEGER */
/*          The number of rows to be operated on i.e the number of rows */
/*          of the distributed submatrix sub( A ). M >= 0. */

/*  N       (global input) INTEGER */
/*          The number of columns to be operated on i.e the number of */
/*          columns of the distributed submatrix sub( A ). N >= 0. */

/*  A       (local input/local output) DOUBLE PRECISION pointer into the */
/*          local memory to an array of dimension (LLD_A,LOCc(JA+N-1)) */
/*          containing on entry the M-by-N matrix sub( A ). On exit, */
/*          the equilibrated distributed matrix.  See EQUED for the */
/*          form of the equilibrated distributed submatrix. */

/*  IA      (global input) INTEGER */
/*          The row index in the global array A indicating the first */
/*          row of sub( A ). */

/*  JA      (global input) INTEGER */
/*          The column index in the global array A indicating the */
/*          first column of sub( A ). */

/*  DESCA   (global and local input) INTEGER array of dimension DLEN_. */
/*          The array descriptor for the distributed matrix A. */

/*  R       (local input) DOUBLE PRECISION array, dimension LOCr(M_A) */
/*          The row scale factors for sub( A ). R is aligned with the */
/*          distributed matrix A, and replicated across every process */
/*          column. R is tied to the distributed matrix A. */

/*  C       (local input) DOUBLE PRECISION array, dimension LOCc(N_A) */
/*          The column scale factors of sub( A ). C is aligned with the */
/*          distributed matrix A, and replicated down every process */
/*          row. C is tied to the distributed matrix A. */

/*  ROWCND  (global input) DOUBLE PRECISION */
/*          The global ratio of the smallest R(i) to the largest R(i), */
/*          IA <= i <= IA+M-1. */

/*  COLCND  (global input) DOUBLE PRECISION */
/*          The global ratio of the smallest C(i) to the largest C(i), */
/*          JA <= j <= JA+N-1. */

/*  AMAX    (global input) DOUBLE PRECISION */
/*          Absolute value of largest distributed submatrix entry. */

/*  EQUED   (global output) CHARACTER */
/*          Specifies the form of equilibration that was done. */
/*          = 'N':  No equilibration */
/*          = 'R':  Row equilibration, i.e., sub( A ) has been pre- */
/*                  multiplied by diag(R(IA:IA+M-1)), */
/*          = 'C':  Column equilibration, i.e., sub( A ) has been post- */
/*                  multiplied by diag(C(JA:JA+N-1)), */
/*          = 'B':  Both row and column equilibration, i.e., sub( A ) */
/*                  has been replaced by */
/*                  diag(R(IA:IA+M-1)) * sub( A ) * diag(C(JA:JA+N-1)). */

/*  Internal Parameters */
/*  =================== */

/*  THRESH is a threshold value used to decide if row or column scaling */
/*  should be done based on the ratio of the row or column scaling */
/*  factors.  If ROWCND < THRESH, row scaling is done, and if */
/*  COLCND < THRESH, column scaling is done. */

/*  LARGE and SMALL are threshold values used to decide if row scaling */
/*  should be done based on the absolute size of the largest matrix */
/*  element.  If AMAX > LARGE or AMAX < SMALL, row scaling is done. */

/*  ===================================================================== */

/*     .. Parameters .. */
/*     .. */
/*     .. Local Scalars .. */
/*     .. */
/*     .. External Subroutines .. */
/*     .. */
/*     .. External Functions .. */
/*     .. */
/*     .. Intrinsic Functions .. */
/*     .. */
/*     .. Executable Statements .. */

/*     Quick return if possible */

    /* Parameter adjustments */
    --c__;
    --r__;
    --desca;
    --a;

    /* Function Body */
    if (*m <= 0 || *n <= 0) {
	*(unsigned char *)equed = 'N';
	return 0;
    }

/*     Get grid parameters and compute local indexes */

    ictxt = desca[2];
    blacs_gridinfo__(&ictxt, &nprow, &npcol, &myrow, &mycol);
    infog2l_(ia, ja, &desca[1], &nprow, &npcol, &myrow, &mycol, &iia, &jja, &
	    iarow, &iacol);
    iroff = (*ia - 1) % desca[5];
    icoff = (*ja - 1) % desca[6];
    i__1 = *m + iroff;
    mp = numroc_(&i__1, &desca[5], &myrow, &iarow, &nprow);
    i__1 = *n + icoff;
    nq = numroc_(&i__1, &desca[6], &mycol, &iacol, &npcol);
    if (myrow == iarow) {
	mp -= iroff;
    }
    if (mycol == iacol) {
	nq -= icoff;
    }
    lda = desca[9];

/*     Initialize LARGE and SMALL. */

    small = pdlamch_(&ictxt, "Safe minimum", (ftnlen)12) / pdlamch_(&ictxt, 
	    "Precision", (ftnlen)9);
    large = 1. / small;

    if (*rowcnd >= .1 && *amax >= small && *amax <= large) {

/*        No row scaling */

	if (*colcnd >= .1) {

/*           No column scaling */

	    *(unsigned char *)equed = 'N';

	} else {

/*           Column scaling */

	    ioffa = (jja - 1) * lda;
	    i__1 = jja + nq - 1;
	    for (j = jja; j <= i__1; ++j) {
		cj = c__[j];
		i__2 = iia + mp - 1;
		for (i__ = iia; i__ <= i__2; ++i__) {
		    a[ioffa + i__] = cj * a[ioffa + i__];
/* L10: */
		}
		ioffa += lda;
/* L20: */
	    }
	    *(unsigned char *)equed = 'C';
	}

    } else if (*colcnd >= .1) {

/*        Row scaling, no column scaling */

	ioffa = (jja - 1) * lda;
	i__1 = jja + nq - 1;
	for (j = jja; j <= i__1; ++j) {
	    i__2 = iia + mp - 1;
	    for (i__ = iia; i__ <= i__2; ++i__) {
		a[ioffa + i__] = r__[i__] * a[ioffa + i__];
/* L30: */
	    }
	    ioffa += lda;
/* L40: */
	}
	*(unsigned char *)equed = 'R';

    } else {

/*        Row and column scaling */

	ioffa = (jja - 1) * lda;
	i__1 = jja + nq - 1;
	for (j = jja; j <= i__1; ++j) {
	    cj = c__[j];
	    i__2 = iia + mp - 1;
	    for (i__ = iia; i__ <= i__2; ++i__) {
		a[ioffa + i__] = cj * r__[i__] * a[ioffa + i__];
/* L50: */
	    }
	    ioffa += lda;
/* L60: */
	}
	*(unsigned char *)equed = 'B';

    }

    return 0;

/*     End of PDLAQGE */

} /* pdlaqge_ */

