/* /home4/luszczek/mscratch/build/SCALAPACK/SRC/pdlacon.f -- translated by f2c (version 20031025).
   You must link the resulting object file with libf2c:
	on Microsoft Windows system, link with libf2c.lib;
	on Linux or Unix systems, link with .../path/to/libf2c.a -lm
	or, if you install libf2c.a in a standard place, with -lf2c -lm
	-- in that order, at the end of the command line, as in
		cc *.o -lf2c -lm
	Source for libf2c is in /netlib/f2c/libf2c.zip, e.g.,

		http://www.netlib.org/f2c/libf2c.zip
*/

#include "f2c.h"

/* Table of constant values */

static integer c__1 = 1;
static doublereal c_b31 = 1.;
static integer c__2 = 2;
static integer c_n1 = -1;

/* Subroutine */ int pdlacon_(integer *n, doublereal *v, integer *iv, integer 
	*jv, integer *descv, doublereal *x, integer *ix, integer *jx, integer 
	*descx, integer *isgn, doublereal *est, integer *kase)
{
    /* System generated locals */
    integer i__1, i__2;
    doublereal d__1;

    /* Builtin functions */
    double d_sign(doublereal *, doublereal *);
    integer i_dnnt(doublereal *);

    /* Local variables */
    static integer i__, j, k, np, iter;
    static doublereal temp;
    static integer jump;
    static doublereal xmax;
    static integer iivx, jjvx;
    static doublereal work[2];
    static integer iflag, iroff, npcol;
    static doublereal jlmax;
    static integer jlast;
    extern /* Subroutine */ int lfc_SLdcopy(integer *, doublereal *, integer *, 
	    doublereal *, integer *);
    static integer mycol, ictxt, nprow, myrow;
    extern /* Subroutine */ int pdamax_(integer *, doublereal *, integer *, 
	    doublereal *, integer *, integer *, integer *, integer *);
    static doublereal altsgn;
    extern /* Subroutine */ int pdasum_(integer *, doublereal *, doublereal *,
	     integer *, integer *, integer *, integer *);
    static doublereal estold;
    static integer ioffvx;
    extern /* Subroutine */ int blacs_gridinfo__(integer *, integer *, 
	    integer *, integer *, integer *);
    static integer ivxcol;
    extern integer numroc_(integer *, integer *, integer *, integer *, 
	    integer *);
    extern /* Subroutine */ int dgebr2d_(integer *, char *, char *, integer *,
	     integer *, doublereal *, integer *, integer *, integer *, ftnlen,
	     ftnlen), dgebs2d_(integer *, char *, char *, integer *, integer *
	    , doublereal *, integer *, ftnlen, ftnlen);
    static integer ivxrow;
    extern /* Subroutine */ int infog2l_(integer *, integer *, integer *, 
	    integer *, integer *, integer *, integer *, integer *, integer *, 
	    integer *, integer *);
    extern integer indxg2l_(integer *, integer *, integer *, integer *, 
	    integer *), indxl2g_(integer *, integer *, integer *, integer *, 
	    integer *);
    extern /* Subroutine */ int igsum2d_(integer *, char *, char *, integer *,
	     integer *, integer *, integer *, integer *, integer *, ftnlen, 
	    ftnlen);
    extern integer indxg2p_(integer *, integer *, integer *, integer *, 
	    integer *);
    extern /* Subroutine */ int pdelget_(char *, char *, doublereal *, 
	    doublereal *, integer *, integer *, integer *, ftnlen, ftnlen);
    static integer imaxrow;


/*  -- ScaLAPACK auxiliary routine (version 1.7) -- */
/*     University of Tennessee, Knoxville, Oak Ridge National Laboratory, */
/*     and University of California, Berkeley. */
/*     May 1, 1997 */

/*     .. Scalar Arguments .. */
/*     .. */
/*     .. Array Arguments .. */
/*     .. */

/*  Purpose */
/*  ======= */

/*  PDLACON estimates the 1-norm of a square, real distributed matrix A. */
/*  Reverse communication is used for evaluating matrix-vector products. */
/*  X and V are aligned with the distributed matrix A, this information */
/*  is implicitly contained within IV, IX, DESCV, and DESCX. */

/*  Notes */
/*  ===== */

/*  Each global data object is described by an associated description */
/*  vector.  This vector stores the information required to establish */
/*  the mapping between an object element and its corresponding process */
/*  and memory location. */

/*  Let A be a generic term for any 2D block cyclicly distributed array. */
/*  Such a global array has an associated description vector DESCA. */
/*  In the following comments, the character _ should be read as */
/*  "of the global array". */

/*  NOTATION        STORED IN      EXPLANATION */
/*  --------------- -------------- -------------------------------------- */
/*  DTYPE_A(global) DESCA( DTYPE_ )The descriptor type.  In this case, */
/*                                 DTYPE_A = 1. */
/*  CTXT_A (global) DESCA( CTXT_ ) The BLACS context handle, indicating */
/*                                 the BLACS process grid A is distribu- */
/*                                 ted over. The context itself is glo- */
/*                                 bal, but the handle (the integer */
/*                                 value) may vary. */
/*  M_A    (global) DESCA( M_ )    The number of rows in the global */
/*                                 array A. */
/*  N_A    (global) DESCA( N_ )    The number of columns in the global */
/*                                 array A. */
/*  MB_A   (global) DESCA( MB_ )   The blocking factor used to distribute */
/*                                 the rows of the array. */
/*  NB_A   (global) DESCA( NB_ )   The blocking factor used to distribute */
/*                                 the columns of the array. */
/*  RSRC_A (global) DESCA( RSRC_ ) The process row over which the first */
/*                                 row of the array A is distributed. */
/*  CSRC_A (global) DESCA( CSRC_ ) The process column over which the */
/*                                 first column of the array A is */
/*                                 distributed. */
/*  LLD_A  (local)  DESCA( LLD_ )  The leading dimension of the local */
/*                                 array.  LLD_A >= MAX(1,LOCr(M_A)). */

/*  Let K be the number of rows or columns of a distributed matrix, */
/*  and assume that its process grid has dimension p x q. */
/*  LOCr( K ) denotes the number of elements of K that a process */
/*  would receive if K were distributed over the p processes of its */
/*  process column. */
/*  Similarly, LOCc( K ) denotes the number of elements of K that a */
/*  process would receive if K were distributed over the q processes of */
/*  its process row. */
/*  The values of LOCr() and LOCc() may be determined via a call to the */
/*  ScaLAPACK tool function, NUMROC: */
/*          LOCr( M ) = NUMROC( M, MB_A, MYROW, RSRC_A, NPROW ), */
/*          LOCc( N ) = NUMROC( N, NB_A, MYCOL, CSRC_A, NPCOL ). */
/*  An upper bound for these quantities may be computed by: */
/*          LOCr( M ) <= ceil( ceil(M/MB_A)/NPROW )*MB_A */
/*          LOCc( N ) <= ceil( ceil(N/NB_A)/NPCOL )*NB_A */

/*  Arguments */
/*  ========= */

/*  N       (global input) INTEGER */
/*          The length of the distributed vectors V and X.  N >= 0. */

/*  V       (local workspace) DOUBLE PRECISION pointer into the local */
/*          memory to an array of dimension LOCr(N+MOD(IV-1,MB_V)). On */
/*          the final return, V = A*W, where EST = norm(V)/norm(W) */
/*          (W is not returned). */

/*  IV      (global input) INTEGER */
/*          The row index in the global array V indicating the first */
/*          row of sub( V ). */

/*  JV      (global input) INTEGER */
/*          The column index in the global array V indicating the */
/*          first column of sub( V ). */

/*  DESCV   (global and local input) INTEGER array of dimension DLEN_. */
/*          The array descriptor for the distributed matrix V. */

/*  X       (local input/local output) DOUBLE PRECISION pointer into the */
/*          local memory to an array of dimension */
/*          LOCr(N+MOD(IX-1,MB_X)). On an intermediate return, X */
/*          should be overwritten by */
/*                A * X,   if KASE=1, */
/*                A' * X,  if KASE=2, */
/*          PDLACON must be re-called with all the other parameters */
/*          unchanged. */

/*  IX      (global input) INTEGER */
/*          The row index in the global array X indicating the first */
/*          row of sub( X ). */

/*  JX      (global input) INTEGER */
/*          The column index in the global array X indicating the */
/*          first column of sub( X ). */

/*  DESCX   (global and local input) INTEGER array of dimension DLEN_. */
/*          The array descriptor for the distributed matrix X. */

/*  ISGN    (local workspace) INTEGER array, dimension */
/*          LOCr(N+MOD(IX-1,MB_X)). ISGN is aligned with X and V. */


/*  EST     (global output) DOUBLE PRECISION */
/*          An estimate (a lower bound) for norm(A). */

/*  KASE    (local input/local output) INTEGER */
/*          On the initial call to PDLACON, KASE should be 0. */
/*          On an intermediate return, KASE will be 1 or 2, indicating */
/*          whether X should be overwritten by A * X  or A' * X. */
/*          On the final return from PDLACON, KASE will again be 0. */

/*  Further Details */
/*  =============== */

/*  The serial version DLACON has been contributed by Nick Higham, */
/*  University of Manchester. It was originally named SONEST, dated */
/*  March 16, 1988. */

/*  Reference: N.J. Higham, "FORTRAN codes for estimating the one-norm of */
/*  a real or complex matrix, with applications to condition estimation", */
/*  ACM Trans. Math. Soft., vol. 14, no. 4, pp. 381-396, December 1988. */

/*  ===================================================================== */

/*     .. Parameters .. */
/*     .. */
/*     .. Local Scalars .. */
/*     .. */
/*     .. Local Arrays .. */
/*     .. */
/*     .. External Subroutines .. */
/*     .. */
/*     .. External Functions .. */
/*     .. */
/*     .. Intrinsic Functions .. */
/*     .. */
/*     .. Save statement .. */
/*     .. */
/*     .. Executable Statements .. */

/*     Get grid parameters. */

    /* Parameter adjustments */
    --isgn;
    --descx;
    --x;
    --descv;
    --v;

    /* Function Body */
    ictxt = descx[2];
    blacs_gridinfo__(&ictxt, &nprow, &npcol, &myrow, &mycol);

    infog2l_(ix, jx, &descx[1], &nprow, &npcol, &myrow, &mycol, &iivx, &jjvx, 
	    &ivxrow, &ivxcol);
    if (mycol != ivxcol) {
	return 0;
    }
    iroff = (*ix - 1) % descx[5];
    i__1 = *n + iroff;
    np = numroc_(&i__1, &descx[5], &myrow, &ivxrow, &nprow);
    if (myrow == ivxrow) {
	np -= iroff;
    }
    ioffvx = iivx + (jjvx - 1) * descx[9];

    if (*kase == 0) {
	i__1 = ioffvx + np - 1;
	for (i__ = ioffvx; i__ <= i__1; ++i__) {
	    x[i__] = 1. / (doublereal) (*n);
/* L10: */
	}
	*kase = 1;
	jump = 1;
	return 0;
    }

    switch (jump) {
	case 1:  goto L20;
	case 2:  goto L40;
	case 3:  goto L70;
	case 4:  goto L110;
	case 5:  goto L140;
    }

/*     ................ ENTRY   (JUMP = 1) */
/*     FIRST ITERATION.  X HAS BEEN OVERWRITTEN BY A*X */

L20:
    if (*n == 1) {
	if (myrow == ivxrow) {
	    v[ioffvx] = x[ioffvx];
	    *est = (d__1 = v[ioffvx], abs(d__1));
	    dgebs2d_(&ictxt, "Columnwise", " ", &c__1, &c__1, est, &c__1, (
		    ftnlen)10, (ftnlen)1);
	} else {
	    dgebr2d_(&ictxt, "Columnwise", " ", &c__1, &c__1, est, &c__1, &
		    ivxrow, &mycol, (ftnlen)10, (ftnlen)1);
	}
/*        ... QUIT */
	goto L150;
    }
    pdasum_(n, est, &x[1], ix, jx, &descx[1], &c__1);
    if (descx[3] == 1 && *n == 1) {
	if (myrow == ivxrow) {
	    dgebs2d_(&ictxt, "Columnwise", " ", &c__1, &c__1, est, &c__1, (
		    ftnlen)10, (ftnlen)1);
	} else {
	    dgebr2d_(&ictxt, "Columnwise", " ", &c__1, &c__1, est, &c__1, &
		    ivxrow, &mycol, (ftnlen)10, (ftnlen)1);
	}
    }

    i__1 = ioffvx + np - 1;
    for (i__ = ioffvx; i__ <= i__1; ++i__) {
	x[i__] = d_sign(&c_b31, &x[i__]);
	isgn[i__] = i_dnnt(&x[i__]);
/* L30: */
    }
    *kase = 2;
    jump = 2;
    return 0;

/*     ................ ENTRY   (JUMP = 2) */
/*     FIRST ITERATION.  X HAS BEEN OVERWRITTEN BY TRANSPOSE(A)*X */

L40:
    pdamax_(n, &xmax, &j, &x[1], ix, jx, &descx[1], &c__1);
    if (descx[3] == 1 && *n == 1) {
	if (myrow == ivxrow) {
	    work[0] = xmax;
	    work[1] = (doublereal) j;
	    dgebs2d_(&ictxt, "Columnwise", " ", &c__2, &c__1, work, &c__2, (
		    ftnlen)10, (ftnlen)1);
	} else {
	    dgebr2d_(&ictxt, "Columnwise", " ", &c__2, &c__1, work, &c__2, &
		    ivxrow, &mycol, (ftnlen)10, (ftnlen)1);
	    xmax = work[0];
	    j = i_dnnt(&work[1]);
	}
    }
    iter = 2;

/*     MAIN LOOP - ITERATIONS 2, 3,...,ITMAX */

L50:
    i__1 = ioffvx + np - 1;
    for (i__ = ioffvx; i__ <= i__1; ++i__) {
	x[i__] = 0.;
/* L60: */
    }
    imaxrow = indxg2p_(&j, &descx[5], &myrow, &descx[7], &nprow);
    if (myrow == imaxrow) {
	i__ = indxg2l_(&j, &descx[5], &myrow, &descx[7], &nprow);
	x[i__] = 1.;
    }
    *kase = 1;
    jump = 3;
    return 0;

/*     ................ ENTRY   (JUMP = 3) */
/*     X HAS BEEN OVERWRITTEN BY A*X */

L70:
    lfc_SLdcopy(&np, &x[ioffvx], &c__1, &v[ioffvx], &c__1);
    estold = *est;
    pdasum_(n, est, &v[1], iv, jv, &descv[1], &c__1);
    if (descv[3] == 1 && *n == 1) {
	if (myrow == ivxrow) {
	    dgebs2d_(&ictxt, "Columnwise", " ", &c__1, &c__1, est, &c__1, (
		    ftnlen)10, (ftnlen)1);
	} else {
	    dgebr2d_(&ictxt, "Columnwise", " ", &c__1, &c__1, est, &c__1, &
		    ivxrow, &mycol, (ftnlen)10, (ftnlen)1);
	}
    }
    iflag = 0;
    i__1 = ioffvx + np - 1;
    for (i__ = ioffvx; i__ <= i__1; ++i__) {
	d__1 = d_sign(&c_b31, &x[i__]);
	if (i_dnnt(&d__1) != isgn[i__]) {
	    iflag = 1;
	    goto L90;
	}
/* L80: */
    }

L90:
    igsum2d_(&ictxt, "C", " ", &c__1, &c__1, &iflag, &c__1, &c_n1, &mycol, (
	    ftnlen)1, (ftnlen)1);

/*     REPEATED SIGN VECTOR DETECTED, HENCE ALGORITHM HAS CONVERGED. */
/*     ALONG WITH IT, TEST FOR CYCLING. */

    if (iflag == 0 || *est <= estold) {
	goto L120;
    }

    i__1 = ioffvx + np - 1;
    for (i__ = ioffvx; i__ <= i__1; ++i__) {
	x[i__] = d_sign(&c_b31, &x[i__]);
	isgn[i__] = i_dnnt(&x[i__]);
/* L100: */
    }
    *kase = 2;
    jump = 4;
    return 0;

/*     ................ ENTRY   (JUMP = 4) */
/*     X HAS BEEN OVERWRITTEN BY TRANSPOSE(A)*X */

L110:
    jlast = j;
    pdamax_(n, &xmax, &j, &x[1], ix, jx, &descx[1], &c__1);
    if (descx[3] == 1 && *n == 1) {
	if (myrow == ivxrow) {
	    work[0] = xmax;
	    work[1] = (doublereal) j;
	    dgebs2d_(&ictxt, "Columnwise", " ", &c__2, &c__1, work, &c__2, (
		    ftnlen)10, (ftnlen)1);
	} else {
	    dgebr2d_(&ictxt, "Columnwise", " ", &c__2, &c__1, work, &c__2, &
		    ivxrow, &mycol, (ftnlen)10, (ftnlen)1);
	    xmax = work[0];
	    j = i_dnnt(&work[1]);
	}
    }
    pdelget_("Columnwise", " ", &jlmax, &x[1], &jlast, jx, &descx[1], (ftnlen)
	    10, (ftnlen)1);
    if (jlmax != abs(xmax) && iter < 5) {
	++iter;
	goto L50;
    }

/*     ITERATION COMPLETE.  FINAL STAGE. */

L120:
    i__1 = ioffvx + np - 1;
    for (i__ = ioffvx; i__ <= i__1; ++i__) {
	i__2 = i__ - ioffvx + iivx;
	k = indxl2g_(&i__2, &descx[5], &myrow, &descx[7], &nprow) - *ix + 1;
	if (k % 2 == 0) {
	    altsgn = -1.;
	} else {
	    altsgn = 1.;
	}
	x[i__] = altsgn * ((doublereal) (k - 1) / (doublereal) (*n - 1) + 1.);
/* L130: */
    }
    *kase = 1;
    jump = 5;
    return 0;

/*     ................ ENTRY   (JUMP = 5) */
/*     X HAS BEEN OVERWRITTEN BY A*X */

L140:
    pdasum_(n, &temp, &x[1], ix, jx, &descx[1], &c__1);
    if (descx[3] == 1 && *n == 1) {
	if (myrow == ivxrow) {
	    dgebs2d_(&ictxt, "Columnwise", " ", &c__1, &c__1, &temp, &c__1, (
		    ftnlen)10, (ftnlen)1);
	} else {
	    dgebr2d_(&ictxt, "Columnwise", " ", &c__1, &c__1, &temp, &c__1, &
		    ivxrow, &mycol, (ftnlen)10, (ftnlen)1);
	}
    }
    temp = temp / (doublereal) (*n * 3) * 2.;
    if (temp > *est) {
	lfc_SLdcopy(&np, &x[ioffvx], &c__1, &v[ioffvx], &c__1);
	*est = temp;
    }

L150:
    *kase = 0;

    return 0;

/*     End of PDLACON */

} /* pdlacon_ */

