/* /home4/luszczek/mscratch/build/SCALAPACK/SRC/pclattrs.f -- translated by f2c (version 20031025).
   You must link the resulting object file with libf2c:
	on Microsoft Windows system, link with libf2c.lib;
	on Linux or Unix systems, link with .../path/to/libf2c.a -lm
	or, if you install libf2c.a in a standard place, with -lf2c -lm
	-- in that order, at the end of the command line, as in
		cc *.o -lf2c -lm
	Source for libf2c is in /netlib/f2c/libf2c.zip, e.g.,

		http://www.netlib.org/f2c/libf2c.zip
*/

#include "f2c.h"

/* Table of constant values */

static complex c_b1 = {0.f,0.f};
static complex c_b2 = {1.f,0.f};
static integer c__1 = 1;
static integer c_n1 = -1;
static real c_b92 = .5f;

/* Subroutine */ int pclattrs_(char *uplo, char *trans, char *diag, char *
	normin, integer *n, complex *a, integer *ia, integer *ja, integer *
	desca, complex *x, integer *ix, integer *jx, integer *descx, real *
	scale, real *cnorm, integer *info, ftnlen uplo_len, ftnlen trans_len, 
	ftnlen diag_len, ftnlen normin_len)
{
    /* System generated locals */
    integer i__1, i__2, i__3, i__4, i__5, i__6;
    real r__1, r__2, r__3, r__4;
    complex q__1, q__2;

    /* Builtin functions */
    double r_imag(complex *);
    void r_cnjg(complex *, complex *);

    /* Local variables */
    integer i__, j, mb, nb;
    real xj;
    integer lda;
    real rec;
    integer ldx;
    real tjj;
    integer jinc, icol, csrc;
    real xbnd;
    integer imax, rsrc;
    real tmax;
    complex tjjs;
    real xmax, grow;
    integer irow;
    complex zdum;
    integer itmp1, itmp2;
    extern logical lsame_(char *, char *, ftnlen, ftnlen);
    extern /* Subroutine */ int lfc_SLsscal(integer *, real *, real *, integer *);
    real tscal;
    complex uscal;
    integer npcol, jlast, icolx, mycol;
    complex csumj;
    logical upper;
    complex xjtmp;
    integer nprow, irowx, myrow, itmp1x, itmp2x;
    extern /* Complex */ VOID cladiv_(complex *, complex *, complex *);
    extern /* Subroutine */ int pcscal_(integer *, complex *, complex *, 
	    integer *, integer *, integer *, integer *), pcamax_(integer *, 
	    complex *, integer *, complex *, integer *, integer *, integer *, 
	    integer *), pcdotc_(integer *, complex *, complex *, integer *, 
	    integer *, integer *, integer *, complex *, integer *, integer *, 
	    integer *, integer *);
    real bignum;
    extern integer lfc_SLisamax(integer *, real *, integer *);
    extern /* Subroutine */ int pcdotu_(integer *, complex *, complex *, 
	    integer *, integer *, integer *, integer *, complex *, integer *, 
	    integer *, integer *, integer *);
    logical notran;
    integer jfirst;
    extern /* Subroutine */ int blacs_gridinfo__(integer *, integer *, 
	    integer *, integer *, integer *), pcaxpy_(integer *, complex *, 
	    complex *, integer *, integer *, integer *, integer *, complex *, 
	    integer *, integer *, integer *, integer *), cgebr2d_(integer *, 
	    char *, char *, integer *, integer *, complex *, integer *, 
	    integer *, integer *, ftnlen, ftnlen), cgebs2d_(integer *, char *,
	     char *, integer *, integer *, complex *, integer *, ftnlen, 
	    ftnlen);
    real smlnum;
    logical nounit;
    integer contxt;
    extern /* Subroutine */ int pctrsv_(char *, char *, char *, integer *, 
	    complex *, integer *, integer *, integer *, complex *, integer *, 
	    integer *, integer *, integer *, ftnlen, ftnlen, ftnlen), 
	    infog2l_(integer *, integer *, integer *, integer *, integer *, 
	    integer *, integer *, integer *, integer *, integer *, integer *),
	     sgsum2d_(integer *, char *, char *, integer *, integer *, real *,
	     integer *, integer *, integer *, ftnlen, ftnlen), pslabad_(
	    integer *, real *, real *);
    extern doublereal pslamch_(integer *, char *, ftnlen);
    extern /* Subroutine */ int pcsscal_(integer *, real *, complex *, 
	    integer *, integer *, integer *, integer *), pclaset_(char *, 
	    integer *, integer *, complex *, complex *, complex *, integer *, 
	    integer *, integer *, ftnlen), pxerbla_(integer *, char *, 
	    integer *, ftnlen), pscasum_(integer *, real *, complex *, 
	    integer *, integer *, integer *, integer *);


/*  -- ScaLAPACK routine (version 1.7) -- */
/*     University of Tennessee, Knoxville, Oak Ridge National Laboratory, */
/*     and University of California, Berkeley. */
/*     July 31, 2001 */

/*     .. Scalar Arguments .. */
/*     .. */
/*     .. Array Arguments .. */
/*     .. */

/*  Purpose */
/*  ======= */

/*  PCLATTRS solves one of the triangular systems */

/*     A * x = s*b,  A**T * x = s*b,  or  A**H * x = s*b, */

/*  with scaling to prevent overflow.  Here A is an upper or lower */
/*  triangular matrix, A**T denotes the transpose of A, A**H denotes the */
/*  conjugate transpose of A, x and b are n-element vectors, and s is a */
/*  scaling factor, usually less than or equal to 1, chosen so that the */
/*  components of x will be less than the overflow threshold.  If the */
/*  unscaled problem will not cause overflow, the Level 2 PBLAS routine */
/*  PCTRSV is called. If the matrix A is singular (A(j,j) = 0 for some j) */
/*  then s is set to 0 and a non-trivial solution to A*x = 0 is returned. */

/*  This is very slow relative to PCTRSV.  This should only be used */
/*  when scaling is necessary to control overflow, or when it is modified */
/*  to scale better. */
/*  Notes */

/*  ===== */

/*  Each global data object is described by an associated description */
/*  vector.  This vector stores the information required to establish */
/*  the mapping between an object element and its corresponding process */
/*  and memory location. */

/*  Let A be a generic term for any 2D block cyclicly distributed array. */
/*  Such a global array has an associated description vector DESCA. */
/*  In the following comments, the character _ should be read as */
/*  "of the global array". */

/*  NOTATION        STORED IN      EXPLANATION */
/*  --------------- -------------- -------------------------------------- */
/*  DTYPE_A(global) DESCA( DTYPE_ )The descriptor type.  In this case, */
/*                                 DTYPE_A = 1. */
/*  CTXT_A (global) DESCA( CTXT_ ) The BLACS context handle, indicating */
/*                                 the BLACS process grid A is distribu- */
/*                                 ted over. The context itself is glo- */
/*                                 bal, but the handle (the integer */
/*                                 value) may vary. */
/*  M_A    (global) DESCA( M_ )    The number of rows in the global */
/*                                 array A. */
/*  N_A    (global) DESCA( N_ )    The number of columns in the global */
/*                                 array A. */
/*  MB_A   (global) DESCA( MB_ )   The blocking factor used to distribute */
/*                                 the rows of the array. */
/*  NB_A   (global) DESCA( NB_ )   The blocking factor used to distribute */
/*                                 the columns of the array. */
/*  RSRC_A (global) DESCA( RSRC_ ) The process row over which the first */
/*                                 row of the array A is distributed. */
/*  CSRC_A (global) DESCA( CSRC_ ) The process column over which the */
/*                                 first column of the array A is */
/*                                 distributed. */
/*  LLD_A  (local)  DESCA( LLD_ )  The leading dimension of the local */
/*                                 array.  LLD_A >= MAX(1,LOCr(M_A)). */

/*  Let K be the number of rows or columns of a distributed matrix, */
/*  and assume that its process grid has dimension r x c. */
/*  LOCr( K ) denotes the number of elements of K that a process */
/*  would receive if K were distributed over the r processes of its */
/*  process column. */
/*  Similarly, LOCc( K ) denotes the number of elements of K that a */
/*  process would receive if K were distributed over the c processes of */
/*  its process row. */
/*  The values of LOCr() and LOCc() may be determined via a call to the */
/*  ScaLAPACK tool function, NUMROC: */
/*          LOCr( M ) = NUMROC( M, MB_A, MYROW, RSRC_A, NPROW ), */
/*          LOCc( N ) = NUMROC( N, NB_A, MYCOL, CSRC_A, NPCOL ). */
/*  An upper bound for these quantities may be computed by: */
/*          LOCr( M ) <= ceil( ceil(M/MB_A)/NPROW )*MB_A */
/*          LOCc( N ) <= ceil( ceil(N/NB_A)/NPCOL )*NB_A */

/*  Arguments */
/*  ========= */

/*  UPLO    (global input) CHARACTER*1 */
/*          Specifies whether the matrix A is upper or lower triangular. */
/*          = 'U':  Upper triangular */
/*          = 'L':  Lower triangular */

/*  TRANS   (global input) CHARACTER*1 */
/*          Specifies the operation applied to A. */
/*          = 'N':  Solve A * x = s*b     (No transpose) */
/*          = 'T':  Solve A**T * x = s*b  (Transpose) */
/*          = 'C':  Solve A**H * x = s*b  (Conjugate transpose) */

/*  DIAG    (global input) CHARACTER*1 */
/*          Specifies whether or not the matrix A is unit triangular. */
/*          = 'N':  Non-unit triangular */
/*          = 'U':  Unit triangular */

/*  NORMIN  (global input) CHARACTER*1 */
/*          Specifies whether CNORM has been set or not. */
/*          = 'Y':  CNORM contains the column norms on entry */
/*          = 'N':  CNORM is not set on entry.  On exit, the norms will */
/*                  be computed and stored in CNORM. */

/*  N       (global input) INTEGER */
/*          The order of the matrix A.  N >= 0. */

/*  A       (local input) COMPLEX array, dimension (DESCA(LLD_),*) */
/*          The triangular matrix A.  If UPLO = 'U', the leading n by n */
/*          upper triangular part of the array A contains the upper */
/*          triangular matrix, and the strictly lower triangular part of */
/*          A is not referenced.  If UPLO = 'L', the leading n by n lower */
/*          triangular part of the array A contains the lower triangular */
/*          matrix, and the strictly upper triangular part of A is not */
/*          referenced.  If DIAG = 'U', the diagonal elements of A are */
/*          also not referenced and are assumed to be 1. */

/*  IA      (global input) pointer to INTEGER */
/*          The global row index of the submatrix of the distributed */
/*          matrix A to operate on. */

/*  JA      (global input) pointer to INTEGER */
/*          The global column index of the submatrix of the distributed */
/*          matrix A to operate on. */

/*  DESCA   (global and local input) INTEGER array of dimension DLEN_. */
/*          The array descriptor for the distributed matrix A. */

/*  X       (local input/output) COMPLEX array, */
/*                                             dimension (DESCX(LLD_),*) */
/*          On entry, the right hand side b of the triangular system. */
/*          On exit, X is overwritten by the solution vector x. */

/*  IX      (global input) pointer to INTEGER */
/*          The global row index of the submatrix of the distributed */
/*          matrix X to operate on. */

/*  JX      (global input) pointer to INTEGER */
/*          The global column index of the submatrix of the distributed */
/*          matrix X to operate on. */

/*  DESCX   (global and local input) INTEGER array of dimension DLEN_. */
/*          The array descriptor for the distributed matrix X. */

/*  SCALE   (global output) REAL */
/*          The scaling factor s for the triangular system */
/*             A * x = s*b,  A**T * x = s*b,  or  A**H * x = s*b. */
/*          If SCALE = 0, the matrix A is singular or badly scaled, and */
/*          the vector x is an exact or approximate solution to A*x = 0. */

/*  CNORM   (global input or global output) REAL array, */
/*                                                       dimension (N) */
/*          If NORMIN = 'Y', CNORM is an input argument and CNORM(j) */
/*          contains the norm of the off-diagonal part of the j-th column */
/*          of A.  If TRANS = 'N', CNORM(j) must be greater than or equal */
/*          to the infinity-norm, and if TRANS = 'T' or 'C', CNORM(j) */
/*          must be greater than or equal to the 1-norm. */

/*          If NORMIN = 'N', CNORM is an output argument and CNORM(j) */
/*          returns the 1-norm of the offdiagonal part of the j-th column */
/*          of A. */

/*  INFO    (global output) INTEGER */
/*          = 0:  successful exit */
/*          < 0:  if INFO = -k, the k-th argument had an illegal value */

/*  Further Details */
/*  ======= ======= */

/*  A rough bound on x is computed; if that is less than overflow, PCTRSV */
/*  is called, otherwise, specific code is used which checks for possible */
/*  overflow or divide-by-zero at every operation. */

/*  A columnwise scheme is used for solving A*x = b.  The basic algorithm */
/*  if A is lower triangular is */

/*       x[1:n] := b[1:n] */
/*       for j = 1, ..., n */
/*            x(j) := x(j) / A(j,j) */
/*            x[j+1:n] := x[j+1:n] - x(j) * A[j+1:n,j] */
/*       end */

/*  Define bounds on the components of x after j iterations of the loop: */
/*     M(j) = bound on x[1:j] */
/*     G(j) = bound on x[j+1:n] */
/*  Initially, let M(0) = 0 and G(0) = max{x(i), i=1,...,n}. */

/*  Then for iteration j+1 we have */
/*     M(j+1) <= G(j) / | A(j+1,j+1) | */
/*     G(j+1) <= G(j) + M(j+1) * | A[j+2:n,j+1] | */
/*            <= G(j) ( 1 + CNORM(j+1) / | A(j+1,j+1) | ) */

/*  where CNORM(j+1) is greater than or equal to the infinity-norm of */
/*  column j+1 of A, not counting the diagonal.  Hence */

/*     G(j) <= G(0) product ( 1 + CNORM(i) / | A(i,i) | ) */
/*                  1<=i<=j */
/*  and */

/*     |x(j)| <= ( G(0) / |A(j,j)| ) product ( 1 + CNORM(i) / |A(i,i)| ) */
/*                                   1<=i< j */

/*  Since |x(j)| <= M(j), we use the Level 2 PBLAS routine PCTRSV if the */
/*  reciprocal of the largest M(j), j=1,..,n, is larger than */
/*  max(underflow, 1/overflow). */

/*  The bound on x(j) is also used to determine when a step in the */
/*  columnwise method can be performed without fear of overflow.  If */
/*  the computed bound is greater than a large constant, x is scaled to */
/*  prevent overflow, but if the bound overflows, x is set to 0, x(j) to */
/*  1, and scale to 0, and a non-trivial solution to A*x = 0 is found. */

/*  Similarly, a row-wise scheme is used to solve A**T *x = b  or */
/*  A**H *x = b.  The basic algorithm for A upper triangular is */

/*       for j = 1, ..., n */
/*            x(j) := ( b(j) - A[1:j-1,j]' * x[1:j-1] ) / A(j,j) */
/*       end */

/*  We simultaneously compute two bounds */
/*       G(j) = bound on ( b(i) - A[1:i-1,i]' * x[1:i-1] ), 1<=i<=j */
/*       M(j) = bound on x(i), 1<=i<=j */

/*  The initial values are G(0) = 0, M(0) = max{b(i), i=1,..,n}, and we */
/*  add the constraint G(j) >= G(j-1) and M(j) >= M(j-1) for j >= 1. */
/*  Then the bound on x(j) is */

/*       M(j) <= M(j-1) * ( 1 + CNORM(j) ) / | A(j,j) | */

/*            <= M(0) * product ( ( 1 + CNORM(i) ) / |A(i,i)| ) */
/*                      1<=i<=j */

/*  and we can safely call PCTRSV if 1/M(n) and 1/G(n) are both greater */
/*  than max(underflow, 1/overflow). */

/*  Last modified by: Mark R. Fahey, August 2000 */

/*  ===================================================================== */

/*     .. Parameters .. */
/*     .. */
/*     .. Local Scalars .. */
/*     .. */
/*     .. External Functions .. */
/*     .. */
/*     .. External Subroutines .. */
/*     .. */
/*     .. Intrinsic Functions .. */
/*     .. */
/*     .. Statement Functions .. */
/*     .. */
/*     .. Statement Function definitions .. */
/*     .. */
/*     .. Executable Statements .. */

    /* Parameter adjustments */
    --cnorm;
    --descx;
    --x;
    --desca;
    --a;

    /* Function Body */
    *info = 0;
    upper = lsame_(uplo, "U", (ftnlen)1, (ftnlen)1);
    notran = lsame_(trans, "N", (ftnlen)1, (ftnlen)1);
    nounit = lsame_(diag, "N", (ftnlen)1, (ftnlen)1);

    contxt = desca[2];
    rsrc = desca[7];
    csrc = desca[8];
    mb = desca[5];
    nb = desca[6];
    lda = desca[9];
    ldx = descx[9];

/*     Test the input parameters. */

    if (! upper && ! lsame_(uplo, "L", (ftnlen)1, (ftnlen)1)) {
	*info = -1;
    } else if (! notran && ! lsame_(trans, "T", (ftnlen)1, (ftnlen)1) && ! 
	    lsame_(trans, "C", (ftnlen)1, (ftnlen)1)) {
	*info = -2;
    } else if (! nounit && ! lsame_(diag, "U", (ftnlen)1, (ftnlen)1)) {
	*info = -3;
    } else if (! lsame_(normin, "Y", (ftnlen)1, (ftnlen)1) && ! lsame_(normin,
	     "N", (ftnlen)1, (ftnlen)1)) {
	*info = -4;
    } else if (*n < 0) {
	*info = -5;
    }

    blacs_gridinfo__(&contxt, &nprow, &npcol, &myrow, &mycol);

    if (*info != 0) {
	i__1 = -(*info);
	pxerbla_(&contxt, "PCLATTRS", &i__1, (ftnlen)8);
	return 0;
    }

/*     Quick return if possible */

    if (*n == 0) {
	return 0;
    }

/*     Determine machine dependent parameters to control overflow. */

    smlnum = pslamch_(&contxt, "Safe minimum", (ftnlen)12);
    bignum = 1.f / smlnum;
    pslabad_(&contxt, &smlnum, &bignum);
    smlnum /= pslamch_(&contxt, "Precision", (ftnlen)9);
    bignum = 1.f / smlnum;
    *scale = 1.f;


    if (lsame_(normin, "N", (ftnlen)1, (ftnlen)1)) {

/*        Compute the 1-norm of each column, not including the diagonal. */

	if (upper) {

/*           A is upper triangular. */

	    cnorm[1] = 0.f;
	    i__1 = *n;
	    for (j = 2; j <= i__1; ++j) {
		i__2 = j - 1;
		i__3 = *ja + j - 1;
		pscasum_(&i__2, &cnorm[j], &a[1], ia, &i__3, &desca[1], &c__1)
			;
/* L10: */
	    }
	} else {

/*           A is lower triangular. */

	    i__1 = *n - 1;
	    for (j = 1; j <= i__1; ++j) {
		i__2 = *n - j;
		i__3 = *ia + j;
		i__4 = *ja + j - 1;
		pscasum_(&i__2, &cnorm[j], &a[1], &i__3, &i__4, &desca[1], &
			c__1);
/* L20: */
	    }
	    cnorm[*n] = 0.f;
	}
	sgsum2d_(&contxt, "Row", " ", n, &c__1, &cnorm[1], &c__1, &c_n1, &
		c_n1, (ftnlen)3, (ftnlen)1);
    }

/*     Scale the column norms by TSCAL if the maximum element in CNORM is */
/*     greater than BIGNUM/2. */

    imax = lfc_SLisamax(n, &cnorm[1], &c__1);
    tmax = cnorm[imax];
    if (tmax <= bignum * .5f) {
	tscal = 1.f;
    } else {
	tscal = .5f / (smlnum * tmax);
	lfc_SLsscal(n, &tscal, &cnorm[1], &c__1);
    }

/*     Compute a bound on the computed solution vector to see if the */
/*     Level 2 PBLAS routine PCTRSV can be used. */

    xmax = 0.f;
    pcamax_(n, &zdum, &imax, &x[1], ix, jx, &descx[1], &c__1);
    xmax = (r__1 = zdum.r / 2.f, dabs(r__1)) + (r__2 = r_imag(&zdum) / 2.f, 
	    dabs(r__2));
    sgsum2d_(&contxt, "Row", " ", &c__1, &c__1, &xmax, &c__1, &c_n1, &c_n1, (
	    ftnlen)3, (ftnlen)1);
    xbnd = xmax;

    if (notran) {

/*        Compute the growth in A * x = b. */

	if (upper) {
	    jfirst = *n;
	    jlast = 1;
	    jinc = -1;
	} else {
	    jfirst = 1;
	    jlast = *n;
	    jinc = 1;
	}

	if (tscal != 1.f) {
	    grow = 0.f;
	    goto L50;
	}

	if (nounit) {

/*           A is non-unit triangular. */

/*           Compute GROW = 1/G(j) and XBND = 1/M(j). */
/*           Initially, G(0) = max{x(i), i=1,...,n}. */

	    grow = .5f / dmax(xbnd,smlnum);
	    xbnd = grow;
	    i__1 = jlast;
	    i__2 = jinc;
	    for (j = jfirst; i__2 < 0 ? j >= i__1 : j <= i__1; j += i__2) {

/*              Exit the loop if the growth factor is too small. */

		if (grow <= smlnum) {
		    goto L50;
		}

/*              TJJS = A( J, J ) */
		i__3 = *ia + j - 1;
		i__4 = *ja + j - 1;
		infog2l_(&i__3, &i__4, &desca[1], &nprow, &npcol, &myrow, &
			mycol, &irow, &icol, &itmp1, &itmp2);
		if (myrow == itmp1 && mycol == itmp2) {
		    i__3 = (icol - 1) * lda + irow;
		    tjjs.r = a[i__3].r, tjjs.i = a[i__3].i;
		    cgebs2d_(&contxt, "All", " ", &c__1, &c__1, &tjjs, &c__1, 
			    (ftnlen)3, (ftnlen)1);
		} else {
		    cgebr2d_(&contxt, "All", " ", &c__1, &c__1, &tjjs, &c__1, 
			    &itmp1, &itmp2, (ftnlen)3, (ftnlen)1);
		}
		tjj = (r__1 = tjjs.r, dabs(r__1)) + (r__2 = r_imag(&tjjs), 
			dabs(r__2));

		if (tjj >= smlnum) {

/*                 M(j) = G(j-1) / abs(A(j,j)) */

/* Computing MIN */
		    r__1 = xbnd, r__2 = dmin(1.f,tjj) * grow;
		    xbnd = dmin(r__1,r__2);
		} else {

/*                 M(j) could overflow, set XBND to 0. */

		    xbnd = 0.f;
		}

		if (tjj + cnorm[j] >= smlnum) {

/*                 G(j) = G(j-1)*( 1 + CNORM(j) / abs(A(j,j)) ) */

		    grow *= tjj / (tjj + cnorm[j]);
		} else {

/*                 G(j) could overflow, set GROW to 0. */

		    grow = 0.f;
		}
/* L30: */
	    }
	    grow = xbnd;
	} else {

/*           A is unit triangular. */

/*           Compute GROW = 1/G(j), where G(0) = max{x(i), i=1,...,n}. */

/* Computing MIN */
	    r__1 = 1.f, r__2 = .5f / dmax(xbnd,smlnum);
	    grow = dmin(r__1,r__2);
	    i__2 = jlast;
	    i__1 = jinc;
	    for (j = jfirst; i__1 < 0 ? j >= i__2 : j <= i__2; j += i__1) {

/*              Exit the loop if the growth factor is too small. */

		if (grow <= smlnum) {
		    goto L50;
		}

/*              G(j) = G(j-1)*( 1 + CNORM(j) ) */

		grow *= 1.f / (cnorm[j] + 1.f);
/* L40: */
	    }
	}
L50:

	;
    } else {

/*        Compute the growth in A**T * x = b  or  A**H * x = b. */

	if (upper) {
	    jfirst = 1;
	    jlast = *n;
	    jinc = 1;
	} else {
	    jfirst = *n;
	    jlast = 1;
	    jinc = -1;
	}

	if (tscal != 1.f) {
	    grow = 0.f;
	    goto L80;
	}

	if (nounit) {

/*           A is non-unit triangular. */

/*           Compute GROW = 1/G(j) and XBND = 1/M(j). */
/*           Initially, M(0) = max{x(i), i=1,...,n}. */

	    grow = .5f / dmax(xbnd,smlnum);
	    xbnd = grow;
	    i__1 = jlast;
	    i__2 = jinc;
	    for (j = jfirst; i__2 < 0 ? j >= i__1 : j <= i__1; j += i__2) {

/*              Exit the loop if the growth factor is too small. */

		if (grow <= smlnum) {
		    goto L80;
		}

/*              G(j) = max( G(j-1), M(j-1)*( 1 + CNORM(j) ) ) */

		xj = cnorm[j] + 1.f;
/* Computing MIN */
		r__1 = grow, r__2 = xbnd / xj;
		grow = dmin(r__1,r__2);

/*              TJJS = A( J, J ) */
		i__3 = *ia + j - 1;
		i__4 = *ja + j - 1;
		infog2l_(&i__3, &i__4, &desca[1], &nprow, &npcol, &myrow, &
			mycol, &irow, &icol, &itmp1, &itmp2);
		if (myrow == itmp1 && mycol == itmp2) {
		    i__3 = (icol - 1) * lda + irow;
		    tjjs.r = a[i__3].r, tjjs.i = a[i__3].i;
		    cgebs2d_(&contxt, "All", " ", &c__1, &c__1, &tjjs, &c__1, 
			    (ftnlen)3, (ftnlen)1);
		} else {
		    cgebr2d_(&contxt, "All", " ", &c__1, &c__1, &tjjs, &c__1, 
			    &itmp1, &itmp2, (ftnlen)3, (ftnlen)1);
		}
		tjj = (r__1 = tjjs.r, dabs(r__1)) + (r__2 = r_imag(&tjjs), 
			dabs(r__2));

		if (tjj >= smlnum) {

/*                 M(j) = M(j-1)*( 1 + CNORM(j) ) / abs(A(j,j)) */

		    if (xj > tjj) {
			xbnd *= tjj / xj;
		    }
		} else {

/*                 M(j) could overflow, set XBND to 0. */

		    xbnd = 0.f;
		}
/* L60: */
	    }
	    grow = dmin(grow,xbnd);
	} else {

/*           A is unit triangular. */

/*           Compute GROW = 1/G(j), where G(0) = max{x(i), i=1,...,n}. */

/* Computing MIN */
	    r__1 = 1.f, r__2 = .5f / dmax(xbnd,smlnum);
	    grow = dmin(r__1,r__2);
	    i__2 = jlast;
	    i__1 = jinc;
	    for (j = jfirst; i__1 < 0 ? j >= i__2 : j <= i__2; j += i__1) {

/*              Exit the loop if the growth factor is too small. */

		if (grow <= smlnum) {
		    goto L80;
		}

/*              G(j) = ( 1 + CNORM(j) )*G(j-1) */

		xj = cnorm[j] + 1.f;
		grow /= xj;
/* L70: */
	    }
	}
L80:
	;
    }

    if (grow * tscal > smlnum) {

/*        Use the Level 2 PBLAS solve if the reciprocal of the bound on */
/*        elements of X is not too small. */

	pctrsv_(uplo, trans, diag, n, &a[1], ia, ja, &desca[1], &x[1], ix, jx,
		 &descx[1], &c__1, (ftnlen)1, (ftnlen)1, (ftnlen)1);
    } else {

/*        Use a Level 1 PBLAS solve, scaling intermediate results. */

	if (xmax > bignum * .5f) {

/*           Scale X so that its components are less than or equal to */
/*           BIGNUM in absolute value. */

	    *scale = bignum * .5f / xmax;
	    pcsscal_(n, scale, &x[1], ix, jx, &descx[1], &c__1);
	    xmax = bignum;
	} else {
	    xmax *= 2.f;
	}

	if (notran) {

/*           Solve A * x = b */

	    i__1 = jlast;
	    i__2 = jinc;
	    for (j = jfirst; i__2 < 0 ? j >= i__1 : j <= i__1; j += i__2) {

/*              Compute x(j) = b(j) / A(j,j), scaling x if necessary. */

/*              XJ = CABS1( X( J ) ) */
		i__3 = *ix + j - 1;
		infog2l_(&i__3, jx, &descx[1], &nprow, &npcol, &myrow, &mycol,
			 &irowx, &icolx, &itmp1x, &itmp2x);
		if (myrow == itmp1x && mycol == itmp2x) {
		    i__3 = irowx;
		    xjtmp.r = x[i__3].r, xjtmp.i = x[i__3].i;
		    cgebs2d_(&contxt, "All", " ", &c__1, &c__1, &xjtmp, &c__1,
			     (ftnlen)3, (ftnlen)1);
		} else {
		    cgebr2d_(&contxt, "All", " ", &c__1, &c__1, &xjtmp, &c__1,
			     &itmp1x, &itmp2x, (ftnlen)3, (ftnlen)1);
		}
		xj = (r__1 = xjtmp.r, dabs(r__1)) + (r__2 = r_imag(&xjtmp), 
			dabs(r__2));
		if (nounit) {
/*                 TJJS = A( J, J )*TSCAL */
		    i__3 = *ia + j - 1;
		    i__4 = *ja + j - 1;
		    infog2l_(&i__3, &i__4, &desca[1], &nprow, &npcol, &myrow, 
			    &mycol, &irow, &icol, &itmp1, &itmp2);
		    if (myrow == itmp1 && mycol == itmp2) {
			i__3 = (icol - 1) * lda + irow;
			q__1.r = tscal * a[i__3].r, q__1.i = tscal * a[i__3]
				.i;
			tjjs.r = q__1.r, tjjs.i = q__1.i;
			cgebs2d_(&contxt, "All", " ", &c__1, &c__1, &tjjs, &
				c__1, (ftnlen)3, (ftnlen)1);
		    } else {
			cgebr2d_(&contxt, "All", " ", &c__1, &c__1, &tjjs, &
				c__1, &itmp1, &itmp2, (ftnlen)3, (ftnlen)1);
		    }
		} else {
		    tjjs.r = tscal, tjjs.i = 0.f;
		    if (tscal == 1.f) {
			goto L90;
		    }
		}
		tjj = (r__1 = tjjs.r, dabs(r__1)) + (r__2 = r_imag(&tjjs), 
			dabs(r__2));
		if (tjj > smlnum) {

/*                    abs(A(j,j)) > SMLNUM: */

		    if (tjj < 1.f) {
			if (xj > tjj * bignum) {

/*                          Scale x by 1/b(j). */

			    rec = 1.f / xj;
			    pcsscal_(n, &rec, &x[1], ix, jx, &descx[1], &c__1)
				    ;
			    q__1.r = rec * xjtmp.r, q__1.i = rec * xjtmp.i;
			    xjtmp.r = q__1.r, xjtmp.i = q__1.i;
			    *scale *= rec;
			    xmax *= rec;
			}
		    }
/*                 X( J ) = CLADIV( X( J ), TJJS ) */
/*                 XJ = CABS1( X( J ) ) */
		    cladiv_(&q__1, &xjtmp, &tjjs);
		    xjtmp.r = q__1.r, xjtmp.i = q__1.i;
		    xj = (r__1 = xjtmp.r, dabs(r__1)) + (r__2 = r_imag(&xjtmp)
			    , dabs(r__2));
		    if (myrow == itmp1x && mycol == itmp2x) {
			i__3 = irowx;
			x[i__3].r = xjtmp.r, x[i__3].i = xjtmp.i;
		    }
		} else if (tjj > 0.f) {

/*                    0 < abs(A(j,j)) <= SMLNUM: */

		    if (xj > tjj * bignum) {

/*                       Scale x by (1/abs(x(j)))*abs(A(j,j))*BIGNUM */
/*                       to avoid overflow when dividing by A(j,j). */

			rec = tjj * bignum / xj;
			if (cnorm[j] > 1.f) {

/*                          Scale by 1/CNORM(j) to avoid overflow when */
/*                          multiplying x(j) times column j. */

			    rec /= cnorm[j];
			}
			pcsscal_(n, &rec, &x[1], ix, jx, &descx[1], &c__1);
			q__1.r = rec * xjtmp.r, q__1.i = rec * xjtmp.i;
			xjtmp.r = q__1.r, xjtmp.i = q__1.i;
			*scale *= rec;
			xmax *= rec;
		    }
/*                 X( J ) = CLADIV( X( J ), TJJS ) */
/*                 XJ = CABS1( X( J ) ) */
		    cladiv_(&q__1, &xjtmp, &tjjs);
		    xjtmp.r = q__1.r, xjtmp.i = q__1.i;
		    xj = (r__1 = xjtmp.r, dabs(r__1)) + (r__2 = r_imag(&xjtmp)
			    , dabs(r__2));
		    if (myrow == itmp1x && mycol == itmp2x) {
			i__3 = irowx;
			x[i__3].r = xjtmp.r, x[i__3].i = xjtmp.i;
		    }
		} else {

/*                    A(j,j) = 0:  Set x(1:n) = 0, x(j) = 1, and */
/*                    scale = 0, and compute a solution to A*x = 0. */

		    pclaset_(" ", n, &c__1, &c_b1, &c_b1, &x[1], ix, jx, &
			    descx[1], (ftnlen)1);
		    if (myrow == itmp1x && mycol == itmp2x) {
			i__3 = irowx;
			x[i__3].r = 1.f, x[i__3].i = 0.f;
		    }
		    xjtmp.r = 1.f, xjtmp.i = 0.f;
		    xj = 1.f;
		    *scale = 0.f;
		    xmax = 0.f;
		}
L90:

/*              Scale x if necessary to avoid overflow when adding a */
/*              multiple of column j of A. */

		if (xj > 1.f) {
		    rec = 1.f / xj;
		    if (cnorm[j] > (bignum - xmax) * rec) {

/*                    Scale x by 1/(2*abs(x(j))). */

			rec *= .5f;
			pcsscal_(n, &rec, &x[1], ix, jx, &descx[1], &c__1);
			q__1.r = rec * xjtmp.r, q__1.i = rec * xjtmp.i;
			xjtmp.r = q__1.r, xjtmp.i = q__1.i;
			*scale *= rec;
		    }
		} else if (xj * cnorm[j] > bignum - xmax) {

/*                 Scale x by 1/2. */

		    pcsscal_(n, &c_b92, &x[1], ix, jx, &descx[1], &c__1);
		    q__1.r = xjtmp.r * .5f, q__1.i = xjtmp.i * .5f;
		    xjtmp.r = q__1.r, xjtmp.i = q__1.i;
		    *scale *= .5f;
		}

		if (upper) {
		    if (j > 1) {

/*                    Compute the update */
/*                       x(1:j-1) := x(1:j-1) - x(j) * A(1:j-1,j) */

			q__2.r = -xjtmp.r, q__2.i = -xjtmp.i;
			q__1.r = tscal * q__2.r, q__1.i = tscal * q__2.i;
			zdum.r = q__1.r, zdum.i = q__1.i;
			i__3 = j - 1;
			i__4 = *ja + j - 1;
			pcaxpy_(&i__3, &zdum, &a[1], ia, &i__4, &desca[1], &
				c__1, &x[1], ix, jx, &descx[1], &c__1);
			i__3 = j - 1;
			pcamax_(&i__3, &zdum, &imax, &x[1], ix, jx, &descx[1],
				 &c__1);
			xmax = (r__1 = zdum.r, dabs(r__1)) + (r__2 = r_imag(&
				zdum), dabs(r__2));
			sgsum2d_(&contxt, "Row", " ", &c__1, &c__1, &xmax, &
				c__1, &c_n1, &c_n1, (ftnlen)3, (ftnlen)1);
		    }
		} else {
		    if (j < *n) {

/*                    Compute the update */
/*                       x(j+1:n) := x(j+1:n) - x(j) * A(j+1:n,j) */

			q__2.r = -xjtmp.r, q__2.i = -xjtmp.i;
			q__1.r = tscal * q__2.r, q__1.i = tscal * q__2.i;
			zdum.r = q__1.r, zdum.i = q__1.i;
			i__3 = *n - j;
			i__4 = *ia + j;
			i__5 = *ja + j - 1;
			i__6 = *ix + j;
			pcaxpy_(&i__3, &zdum, &a[1], &i__4, &i__5, &desca[1], 
				&c__1, &x[1], &i__6, jx, &descx[1], &c__1);
			i__3 = *n - j;
			i__4 = *ix + j;
			pcamax_(&i__3, &zdum, &i__, &x[1], &i__4, jx, &descx[
				1], &c__1);
			xmax = (r__1 = zdum.r, dabs(r__1)) + (r__2 = r_imag(&
				zdum), dabs(r__2));
			sgsum2d_(&contxt, "Row", " ", &c__1, &c__1, &xmax, &
				c__1, &c_n1, &c_n1, (ftnlen)3, (ftnlen)1);
		    }
		}
/* L100: */
	    }

	} else if (lsame_(trans, "T", (ftnlen)1, (ftnlen)1)) {

/*           Solve A**T * x = b */

	    i__2 = jlast;
	    i__1 = jinc;
	    for (j = jfirst; i__1 < 0 ? j >= i__2 : j <= i__2; j += i__1) {

/*              Compute x(j) = b(j) - sum A(k,j)*x(k). */
/*                                    k<>j */

/*              XJ = CABS1( X( J ) ) */
		i__3 = *ix + j - 1;
		infog2l_(&i__3, jx, &descx[1], &nprow, &npcol, &myrow, &mycol,
			 &irowx, &icolx, &itmp1x, &itmp2x);
		if (myrow == itmp1x && mycol == itmp2x) {
		    i__3 = irowx;
		    xjtmp.r = x[i__3].r, xjtmp.i = x[i__3].i;
		    cgebs2d_(&contxt, "All", " ", &c__1, &c__1, &xjtmp, &c__1,
			     (ftnlen)3, (ftnlen)1);
		} else {
		    cgebr2d_(&contxt, "All", " ", &c__1, &c__1, &xjtmp, &c__1,
			     &itmp1x, &itmp2x, (ftnlen)3, (ftnlen)1);
		}
		xj = (r__1 = xjtmp.r, dabs(r__1)) + (r__2 = r_imag(&xjtmp), 
			dabs(r__2));
		q__1.r = tscal, q__1.i = 0.f;
		uscal.r = q__1.r, uscal.i = q__1.i;
		rec = 1.f / dmax(xmax,1.f);
		if (cnorm[j] > (bignum - xj) * rec) {

/*                 If x(j) could overflow, scale x by 1/(2*XMAX). */

		    rec *= .5f;
		    if (nounit) {
/*                    TJJS = A( J, J )*TSCAL */
			i__3 = *ia + j - 1;
			i__4 = *ja + j - 1;
			infog2l_(&i__3, &i__4, &desca[1], &nprow, &npcol, &
				myrow, &mycol, &irow, &icol, &itmp1, &itmp2);
			if (myrow == itmp1 && mycol == itmp2) {
			    i__3 = (icol - 1) * lda + irow;
			    q__1.r = tscal * a[i__3].r, q__1.i = tscal * a[
				    i__3].i;
			    tjjs.r = q__1.r, tjjs.i = q__1.i;
			    cgebs2d_(&contxt, "All", " ", &c__1, &c__1, &tjjs,
				     &c__1, (ftnlen)3, (ftnlen)1);
			} else {
			    cgebr2d_(&contxt, "All", " ", &c__1, &c__1, &tjjs,
				     &c__1, &itmp1, &itmp2, (ftnlen)3, (
				    ftnlen)1);
			}
		    } else {
			tjjs.r = tscal, tjjs.i = 0.f;
		    }
		    tjj = (r__1 = tjjs.r, dabs(r__1)) + (r__2 = r_imag(&tjjs),
			     dabs(r__2));
		    if (tjj > 1.f) {

/*                       Divide by A(j,j) when scaling x if A(j,j) > 1. */

/* Computing MIN */
			r__1 = 1.f, r__2 = rec * tjj;
			rec = dmin(r__1,r__2);
			cladiv_(&q__1, &uscal, &tjjs);
			uscal.r = q__1.r, uscal.i = q__1.i;
		    }
		    if (rec < 1.f) {
			pcsscal_(n, &rec, &x[1], ix, jx, &descx[1], &c__1);
			q__1.r = rec * xjtmp.r, q__1.i = rec * xjtmp.i;
			xjtmp.r = q__1.r, xjtmp.i = q__1.i;
			*scale *= rec;
			xmax *= rec;
		    }
		}

		csumj.r = 0.f, csumj.i = 0.f;
		if (uscal.r == 1.f && uscal.i == 0.f) {

/*                 If the scaling needed for A in the dot product is 1, */
/*                 call PCDOTU to perform the dot product. */

		    if (upper) {
			i__3 = j - 1;
			i__4 = *ja + j - 1;
			pcdotu_(&i__3, &csumj, &a[1], ia, &i__4, &desca[1], &
				c__1, &x[1], ix, jx, &descx[1], &c__1);
		    } else if (j < *n) {
			i__3 = *n - j;
			i__4 = *ia + j;
			i__5 = *ja + j - 1;
			i__6 = *ix + j;
			pcdotu_(&i__3, &csumj, &a[1], &i__4, &i__5, &desca[1],
				 &c__1, &x[1], &i__6, jx, &descx[1], &c__1);
		    }
		    if (mycol == itmp2x) {
			cgebs2d_(&contxt, "Row", " ", &c__1, &c__1, &csumj, &
				c__1, (ftnlen)3, (ftnlen)1);
		    } else {
			cgebr2d_(&contxt, "Row", " ", &c__1, &c__1, &csumj, &
				c__1, &myrow, &itmp2x, (ftnlen)3, (ftnlen)1);
		    }
		} else {

/*                 Otherwise, scale column of A by USCAL before dot */
/*                 product.  Below is not the best way to do it. */

		    if (upper) {
/*                    DO 130 I = 1, J - 1 */
/*                       CSUMJ = CSUMJ + ( A( I, J )*USCAL )*X( I ) */
/* 130                CONTINUE */
			r_cnjg(&q__1, &uscal);
			zdum.r = q__1.r, zdum.i = q__1.i;
			i__3 = j - 1;
			i__4 = *ja + j - 1;
			pcscal_(&i__3, &zdum, &a[1], ia, &i__4, &desca[1], &
				c__1);
			i__3 = j - 1;
			i__4 = *ja + j - 1;
			pcdotu_(&i__3, &csumj, &a[1], ia, &i__4, &desca[1], &
				c__1, &x[1], ix, jx, &descx[1], &c__1);
			cladiv_(&q__1, &zdum, &uscal);
			zdum.r = q__1.r, zdum.i = q__1.i;
			i__3 = j - 1;
			i__4 = *ja + j - 1;
			pcscal_(&i__3, &zdum, &a[1], ia, &i__4, &desca[1], &
				c__1);
		    } else if (j < *n) {
/*                    DO 140 I = J + 1, N */
/*                       CSUMJ = CSUMJ + ( A( I, J )*USCAL )*X( I ) */
/*  140               CONTINUE */
			r_cnjg(&q__1, &uscal);
			zdum.r = q__1.r, zdum.i = q__1.i;
			i__3 = *n - j;
			i__4 = *ia + j;
			i__5 = *ja + j - 1;
			pcscal_(&i__3, &zdum, &a[1], &i__4, &i__5, &desca[1], 
				&c__1);
			i__3 = *n - j;
			i__4 = *ia + j;
			i__5 = *ja + j - 1;
			i__6 = *ix + j;
			pcdotu_(&i__3, &csumj, &a[1], &i__4, &i__5, &desca[1],
				 &c__1, &x[1], &i__6, jx, &descx[1], &c__1);
			cladiv_(&q__1, &zdum, &uscal);
			zdum.r = q__1.r, zdum.i = q__1.i;
			i__3 = *n - j;
			i__4 = *ia + j;
			i__5 = *ja + j - 1;
			pcscal_(&i__3, &zdum, &a[1], &i__4, &i__5, &desca[1], 
				&c__1);
		    }
		    if (mycol == itmp2x) {
			cgebs2d_(&contxt, "Row", " ", &c__1, &c__1, &csumj, &
				c__1, (ftnlen)3, (ftnlen)1);
		    } else {
			cgebr2d_(&contxt, "Row", " ", &c__1, &c__1, &csumj, &
				c__1, &myrow, &itmp2x, (ftnlen)3, (ftnlen)1);
		    }
		}

		q__1.r = tscal, q__1.i = 0.f;
		if (uscal.r == q__1.r && uscal.i == q__1.i) {

/*                 Compute x(j) := ( x(j) - CSUMJ ) / A(j,j) if 1/A(j,j) */
/*                 was not used to scale the dotproduct. */

/*                 X( J ) = X( J ) - CSUMJ */
/*                 XJ = CABS1( X( J ) ) */
		    q__1.r = xjtmp.r - csumj.r, q__1.i = xjtmp.i - csumj.i;
		    xjtmp.r = q__1.r, xjtmp.i = q__1.i;
		    xj = (r__1 = xjtmp.r, dabs(r__1)) + (r__2 = r_imag(&xjtmp)
			    , dabs(r__2));
/*                  IF( ( MYROW.EQ.ITMP1X ) .AND. ( MYCOL.EQ.ITMP2X ) ) */
/*     $               X( IROWX ) = XJTMP */
		    if (nounit) {
/*                    TJJS = A( J, J )*TSCAL */
			i__3 = *ia + j - 1;
			i__4 = *ja + j - 1;
			infog2l_(&i__3, &i__4, &desca[1], &nprow, &npcol, &
				myrow, &mycol, &irow, &icol, &itmp1, &itmp2);
			if (myrow == itmp1 && mycol == itmp2) {
			    i__3 = (icol - 1) * lda + irow;
			    q__1.r = tscal * a[i__3].r, q__1.i = tscal * a[
				    i__3].i;
			    tjjs.r = q__1.r, tjjs.i = q__1.i;
			    cgebs2d_(&contxt, "All", " ", &c__1, &c__1, &tjjs,
				     &c__1, (ftnlen)3, (ftnlen)1);
			} else {
			    cgebr2d_(&contxt, "All", " ", &c__1, &c__1, &tjjs,
				     &c__1, &itmp1, &itmp2, (ftnlen)3, (
				    ftnlen)1);
			}
		    } else {
			tjjs.r = tscal, tjjs.i = 0.f;
			if (tscal == 1.f) {
			    goto L110;
			}
		    }

/*                    Compute x(j) = x(j) / A(j,j), scaling if necessary. */

		    tjj = (r__1 = tjjs.r, dabs(r__1)) + (r__2 = r_imag(&tjjs),
			     dabs(r__2));
		    if (tjj > smlnum) {

/*                       abs(A(j,j)) > SMLNUM: */

			if (tjj < 1.f) {
			    if (xj > tjj * bignum) {

/*                             Scale X by 1/abs(x(j)). */

				rec = 1.f / xj;
				pcsscal_(n, &rec, &x[1], ix, jx, &descx[1], &
					c__1);
				q__1.r = rec * xjtmp.r, q__1.i = rec * 
					xjtmp.i;
				xjtmp.r = q__1.r, xjtmp.i = q__1.i;
				*scale *= rec;
				xmax *= rec;
			    }
			}
/*                    X( J ) = CLADIV( X( J ), TJJS ) */
			cladiv_(&q__1, &xjtmp, &tjjs);
			xjtmp.r = q__1.r, xjtmp.i = q__1.i;
			if (myrow == itmp1x && mycol == itmp2x) {
			    i__3 = irowx;
			    x[i__3].r = xjtmp.r, x[i__3].i = xjtmp.i;
			}
		    } else if (tjj > 0.f) {

/*                       0 < abs(A(j,j)) <= SMLNUM: */

			if (xj > tjj * bignum) {

/*                          Scale x by (1/abs(x(j)))*abs(A(j,j))*BIGNUM. */

			    rec = tjj * bignum / xj;
			    pcsscal_(n, &rec, &x[1], ix, jx, &descx[1], &c__1)
				    ;
			    q__1.r = rec * xjtmp.r, q__1.i = rec * xjtmp.i;
			    xjtmp.r = q__1.r, xjtmp.i = q__1.i;
			    *scale *= rec;
			    xmax *= rec;
			}
/*                    X( J ) = CLADIV( X( J ), TJJS ) */
			cladiv_(&q__1, &xjtmp, &tjjs);
			xjtmp.r = q__1.r, xjtmp.i = q__1.i;
			if (myrow == itmp1x && mycol == itmp2x) {
			    i__3 = irowx;
			    x[i__3].r = xjtmp.r, x[i__3].i = xjtmp.i;
			}
		    } else {

/*                       A(j,j) = 0:  Set x(1:n) = 0, x(j) = 1, and */
/*                       scale = 0 and compute a solution to A**T *x = 0. */

			pclaset_(" ", n, &c__1, &c_b1, &c_b1, &x[1], ix, jx, &
				descx[1], (ftnlen)1);
			if (myrow == itmp1x && mycol == itmp2x) {
			    i__3 = irowx;
			    x[i__3].r = 1.f, x[i__3].i = 0.f;
			}
			xjtmp.r = 1.f, xjtmp.i = 0.f;
			*scale = 0.f;
			xmax = 0.f;
		    }
L110:
		    ;
		} else {

/*                 Compute x(j) := x(j) / A(j,j) - CSUMJ if the dot */
/*                 product has already been divided by 1/A(j,j). */

/*                 X( J ) = CLADIV( X( J ), TJJS ) - CSUMJ */
		    cladiv_(&q__2, &xjtmp, &tjjs);
		    q__1.r = q__2.r - csumj.r, q__1.i = q__2.i - csumj.i;
		    xjtmp.r = q__1.r, xjtmp.i = q__1.i;
		    if (myrow == itmp1x && mycol == itmp2x) {
			i__3 = irowx;
			x[i__3].r = xjtmp.r, x[i__3].i = xjtmp.i;
		    }
		}
/* Computing MAX */
		r__3 = xmax, r__4 = (r__1 = xjtmp.r, dabs(r__1)) + (r__2 = 
			r_imag(&xjtmp), dabs(r__2));
		xmax = dmax(r__3,r__4);
/* L120: */
	    }

	} else {

/*           Solve A**H * x = b */

	    i__1 = jlast;
	    i__2 = jinc;
	    for (j = jfirst; i__2 < 0 ? j >= i__1 : j <= i__1; j += i__2) {

/*              Compute x(j) = b(j) - sum A(k,j)*x(k). */
/*                                    k<>j */

		i__3 = *ix + j - 1;
		infog2l_(&i__3, jx, &descx[1], &nprow, &npcol, &myrow, &mycol,
			 &irowx, &icolx, &itmp1x, &itmp2x);
		if (myrow == itmp1x && mycol == itmp2x) {
		    i__3 = irowx;
		    xjtmp.r = x[i__3].r, xjtmp.i = x[i__3].i;
		    cgebs2d_(&contxt, "All", " ", &c__1, &c__1, &xjtmp, &c__1,
			     (ftnlen)3, (ftnlen)1);
		} else {
		    cgebr2d_(&contxt, "All", " ", &c__1, &c__1, &xjtmp, &c__1,
			     &itmp1x, &itmp2x, (ftnlen)3, (ftnlen)1);
		}
		xj = (r__1 = xjtmp.r, dabs(r__1)) + (r__2 = r_imag(&xjtmp), 
			dabs(r__2));
		uscal.r = tscal, uscal.i = 0.f;
		rec = 1.f / dmax(xmax,1.f);
		if (cnorm[j] > (bignum - xj) * rec) {

/*                 If x(j) could overflow, scale x by 1/(2*XMAX). */

		    rec *= .5f;
		    if (nounit) {
/*                    TJJS = CONJG( A( J, J ) )*TSCAL */
			i__3 = *ia + j - 1;
			i__4 = *ja + j - 1;
			infog2l_(&i__3, &i__4, &desca[1], &nprow, &npcol, &
				myrow, &mycol, &irow, &icol, &itmp1, &itmp2);
			if (myrow == itmp1 && mycol == itmp2) {
			    r_cnjg(&q__2, &a[(icol - 1) * lda + irow]);
			    q__1.r = tscal * q__2.r, q__1.i = tscal * q__2.i;
			    tjjs.r = q__1.r, tjjs.i = q__1.i;
			    cgebs2d_(&contxt, "All", " ", &c__1, &c__1, &tjjs,
				     &c__1, (ftnlen)3, (ftnlen)1);
			} else {
			    cgebr2d_(&contxt, "All", " ", &c__1, &c__1, &tjjs,
				     &c__1, &itmp1, &itmp2, (ftnlen)3, (
				    ftnlen)1);
			}
		    } else {
			tjjs.r = tscal, tjjs.i = 0.f;
		    }
		    tjj = (r__1 = tjjs.r, dabs(r__1)) + (r__2 = r_imag(&tjjs),
			     dabs(r__2));
		    if (tjj > 1.f) {

/*                       Divide by A(j,j) when scaling x if A(j,j) > 1. */

/* Computing MIN */
			r__1 = 1.f, r__2 = rec * tjj;
			rec = dmin(r__1,r__2);
			cladiv_(&q__1, &uscal, &tjjs);
			uscal.r = q__1.r, uscal.i = q__1.i;
		    }
		    if (rec < 1.f) {
			pcsscal_(n, &rec, &x[1], ix, jx, &descx[1], &c__1);
			q__1.r = rec * xjtmp.r, q__1.i = rec * xjtmp.i;
			xjtmp.r = q__1.r, xjtmp.i = q__1.i;
			*scale *= rec;
			xmax *= rec;
		    }
		}

		csumj.r = 0.f, csumj.i = 0.f;
		if (uscal.r == 1.f && uscal.i == 0.f) {

/*                 If the scaling needed for A in the dot product is 1, */
/*                 call PCDOTC to perform the dot product. */

		    if (upper) {
			i__3 = j - 1;
			i__4 = *ja + j - 1;
			pcdotc_(&i__3, &csumj, &a[1], ia, &i__4, &desca[1], &
				c__1, &x[1], ix, jx, &descx[1], &c__1);
		    } else if (j < *n) {
			i__3 = *n - j;
			i__4 = *ia + j;
			i__5 = *ja + j - 1;
			i__6 = *ix + j;
			pcdotc_(&i__3, &csumj, &a[1], &i__4, &i__5, &desca[1],
				 &c__1, &x[1], &i__6, jx, &descx[1], &c__1);
		    }
		    if (mycol == itmp2x) {
			cgebs2d_(&contxt, "Row", " ", &c__1, &c__1, &csumj, &
				c__1, (ftnlen)3, (ftnlen)1);
		    } else {
			cgebr2d_(&contxt, "Row", " ", &c__1, &c__1, &csumj, &
				c__1, &myrow, &itmp2x, (ftnlen)3, (ftnlen)1);
		    }
		} else {

/*                 Otherwise, scale column of A by USCAL before dot */
/*                 product.  Below is not the best way to do it. */

		    if (upper) {
/*                    DO 180 I = 1, J - 1 */
/*                       CSUMJ = CSUMJ + ( CONJG( A( I, J ) )*USCAL )* */
/*    $                          X( I ) */
/* 180                CONTINUE */
			r_cnjg(&q__1, &uscal);
			zdum.r = q__1.r, zdum.i = q__1.i;
			i__3 = j - 1;
			i__4 = *ja + j - 1;
			pcscal_(&i__3, &zdum, &a[1], ia, &i__4, &desca[1], &
				c__1);
			i__3 = j - 1;
			i__4 = *ja + j - 1;
			pcdotc_(&i__3, &csumj, &a[1], ia, &i__4, &desca[1], &
				c__1, &x[1], ix, jx, &descx[1], &c__1);
			cladiv_(&q__1, &c_b2, &zdum);
			zdum.r = q__1.r, zdum.i = q__1.i;
			i__3 = j - 1;
			i__4 = *ja + j - 1;
			pcscal_(&i__3, &zdum, &a[1], ia, &i__4, &desca[1], &
				c__1);
		    } else if (j < *n) {
/*                    DO 190 I = J + 1, N */
/*                       CSUMJ = CSUMJ + ( CONJG( A( I, J ) )*USCAL )* */
/*    $                          X( I ) */
/* 190                CONTINUE */
			r_cnjg(&q__1, &uscal);
			zdum.r = q__1.r, zdum.i = q__1.i;
			i__3 = *n - j;
			i__4 = *ia + j;
			i__5 = *ja + j - 1;
			pcscal_(&i__3, &zdum, &a[1], &i__4, &i__5, &desca[1], 
				&c__1);
			i__3 = *n - j;
			i__4 = *ia + j;
			i__5 = *ja + j - 1;
			i__6 = *ix + j;
			pcdotc_(&i__3, &csumj, &a[1], &i__4, &i__5, &desca[1],
				 &c__1, &x[1], &i__6, jx, &descx[1], &c__1);
			cladiv_(&q__1, &c_b2, &zdum);
			zdum.r = q__1.r, zdum.i = q__1.i;
			i__3 = *n - j;
			i__4 = *ia + j;
			i__5 = *ja + j - 1;
			pcscal_(&i__3, &zdum, &a[1], &i__4, &i__5, &desca[1], 
				&c__1);
		    }
		    if (mycol == itmp2x) {
			cgebs2d_(&contxt, "Row", " ", &c__1, &c__1, &csumj, &
				c__1, (ftnlen)3, (ftnlen)1);
		    } else {
			cgebr2d_(&contxt, "Row", " ", &c__1, &c__1, &csumj, &
				c__1, &myrow, &itmp2x, (ftnlen)3, (ftnlen)1);
		    }
		}

		q__1.r = tscal, q__1.i = 0.f;
		if (uscal.r == q__1.r && uscal.i == q__1.i) {

/*                 Compute x(j) := ( x(j) - CSUMJ ) / A(j,j) if 1/A(j,j) */
/*                 was not used to scale the dotproduct. */

/*                 X( J ) = X( J ) - CSUMJ */
/*                 XJ = CABS1( X( J ) ) */
		    q__1.r = xjtmp.r - csumj.r, q__1.i = xjtmp.i - csumj.i;
		    xjtmp.r = q__1.r, xjtmp.i = q__1.i;
		    xj = (r__1 = xjtmp.r, dabs(r__1)) + (r__2 = r_imag(&xjtmp)
			    , dabs(r__2));
/*                  IF( ( MYROW.EQ.ITMP1X ) .AND. ( MYCOL.EQ.ITMP2X ) ) */
/*     $               X( IROWX ) = XJTMP */
		    if (nounit) {
/*                    TJJS = CONJG( A( J, J ) )*TSCAL */
			i__3 = *ia + j - 1;
			i__4 = *ja + j - 1;
			infog2l_(&i__3, &i__4, &desca[1], &nprow, &npcol, &
				myrow, &mycol, &irow, &icol, &itmp1, &itmp2);
			if (myrow == itmp1 && mycol == itmp2) {
			    r_cnjg(&q__2, &a[(icol - 1) * lda + irow]);
			    q__1.r = tscal * q__2.r, q__1.i = tscal * q__2.i;
			    tjjs.r = q__1.r, tjjs.i = q__1.i;
			    cgebs2d_(&contxt, "All", " ", &c__1, &c__1, &tjjs,
				     &c__1, (ftnlen)3, (ftnlen)1);
			} else {
			    cgebr2d_(&contxt, "All", " ", &c__1, &c__1, &tjjs,
				     &c__1, &itmp1, &itmp2, (ftnlen)3, (
				    ftnlen)1);
			}
		    } else {
			tjjs.r = tscal, tjjs.i = 0.f;
			if (tscal == 1.f) {
			    goto L130;
			}
		    }

/*                    Compute x(j) = x(j) / A(j,j), scaling if necessary. */

		    tjj = (r__1 = tjjs.r, dabs(r__1)) + (r__2 = r_imag(&tjjs),
			     dabs(r__2));
		    if (tjj > smlnum) {

/*                       abs(A(j,j)) > SMLNUM: */

			if (tjj < 1.f) {
			    if (xj > tjj * bignum) {

/*                             Scale X by 1/abs(x(j)). */

				rec = 1.f / xj;
				pcsscal_(n, &rec, &x[1], ix, jx, &descx[1], &
					c__1);
				q__1.r = rec * xjtmp.r, q__1.i = rec * 
					xjtmp.i;
				xjtmp.r = q__1.r, xjtmp.i = q__1.i;
				*scale *= rec;
				xmax *= rec;
			    }
			}
/*                    X( J ) = CLADIV( X( J ), TJJS ) */
			cladiv_(&q__1, &xjtmp, &tjjs);
			xjtmp.r = q__1.r, xjtmp.i = q__1.i;
			if (myrow == itmp1x && mycol == itmp2x) {
			    i__3 = irowx;
			    x[i__3].r = xjtmp.r, x[i__3].i = xjtmp.i;
			}
		    } else if (tjj > 0.f) {

/*                       0 < abs(A(j,j)) <= SMLNUM: */

			if (xj > tjj * bignum) {

/*                          Scale x by (1/abs(x(j)))*abs(A(j,j))*BIGNUM. */

			    rec = tjj * bignum / xj;
			    pcsscal_(n, &rec, &x[1], ix, jx, &descx[1], &c__1)
				    ;
			    q__1.r = rec * xjtmp.r, q__1.i = rec * xjtmp.i;
			    xjtmp.r = q__1.r, xjtmp.i = q__1.i;
			    *scale *= rec;
			    xmax *= rec;
			}
/*                    X( J ) = CLADIV( X( J ), TJJS ) */
			cladiv_(&q__1, &xjtmp, &tjjs);
			xjtmp.r = q__1.r, xjtmp.i = q__1.i;
			if (myrow == itmp1x && mycol == itmp2x) {
			    i__3 = irowx;
			    x[i__3].r = xjtmp.r, x[i__3].i = xjtmp.i;
			}
		    } else {

/*                       A(j,j) = 0:  Set x(1:n) = 0, x(j) = 1, and */
/*                       scale = 0 and compute a solution to A**H *x = 0. */

			pclaset_(" ", n, &c__1, &c_b1, &c_b1, &x[1], ix, jx, &
				descx[1], (ftnlen)1);
			if (myrow == itmp1x && mycol == itmp2x) {
			    i__3 = irowx;
			    x[i__3].r = 1.f, x[i__3].i = 0.f;
			}
			xjtmp.r = 1.f, xjtmp.i = 0.f;
			*scale = 0.f;
			xmax = 0.f;
		    }
L130:
		    ;
		} else {

/*                 Compute x(j) := x(j) / A(j,j) - CSUMJ if the dot */
/*                 product has already been divided by 1/A(j,j). */

/*                 X( J ) = CLADIV( X( J ), TJJS ) - CSUMJ */
		    cladiv_(&q__2, &xjtmp, &tjjs);
		    q__1.r = q__2.r - csumj.r, q__1.i = q__2.i - csumj.i;
		    xjtmp.r = q__1.r, xjtmp.i = q__1.i;
		    if (myrow == itmp1x && mycol == itmp2x) {
			i__3 = irowx;
			x[i__3].r = xjtmp.r, x[i__3].i = xjtmp.i;
		    }
		}
/* Computing MAX */
		r__3 = xmax, r__4 = (r__1 = xjtmp.r, dabs(r__1)) + (r__2 = 
			r_imag(&xjtmp), dabs(r__2));
		xmax = dmax(r__3,r__4);
/* L140: */
	    }
	}
	*scale /= tscal;
    }

/*     Scale the column norms by 1/TSCAL for return. */

    if (tscal != 1.f) {
	r__1 = 1.f / tscal;
	lfc_SLsscal(n, &r__1, &cnorm[1], &c__1);
    }

    return 0;

/*     End of PCLATTRS */

} /* pclattrs_ */

