/* /home4/luszczek/mscratch/build/SCALAPACK/SRC/pclacon.f -- translated by f2c (version 20031025).
   You must link the resulting object file with libf2c:
	on Microsoft Windows system, link with libf2c.lib;
	on Linux or Unix systems, link with .../path/to/libf2c.a -lm
	or, if you install libf2c.a in a standard place, with -lf2c -lm
	-- in that order, at the end of the command line, as in
		cc *.o -lf2c -lm
	Source for libf2c is in /netlib/f2c/libf2c.zip, e.g.,

		http://www.netlib.org/f2c/libf2c.zip
*/

#include "f2c.h"

/* Table of constant values */

static integer c__1 = 1;
static integer c__2 = 2;

/* Subroutine */ int pclacon_(integer *n, complex *v, integer *iv, integer *
	jv, integer *descv, complex *x, integer *ix, integer *jx, integer *
	descx, real *est, integer *kase)
{
    /* System generated locals */
    integer i__1, i__2;
    real r__1;
    complex q__1, q__2;

    /* Builtin functions */
    double c_abs(complex *);
    void c_div(complex *, complex *, complex *);
    integer i_nint(real *);

    /* Local variables */
    static integer i__, j, k, np, iter;
    static real temp;
    static integer jump;
    static complex xmax;
    static integer iivx, jjvx;
    static complex work[2];
    static integer iroff, npcol;
    static complex jlmax;
    static integer jlast;
    extern /* Subroutine */ int lfc_SLccopy(integer *, complex *, integer *, 
	    complex *, integer *);
    static integer mycol, ictxt, nprow, myrow;
    extern /* Subroutine */ int pcmax1_(integer *, complex *, integer *, 
	    complex *, integer *, integer *, integer *, integer *);
    static real safmin, altsgn, estold;
    static integer ioffvx;
    extern /* Subroutine */ int blacs_gridinfo__(integer *, integer *, 
	    integer *, integer *, integer *);
    static integer ivxcol;
    extern integer numroc_(integer *, integer *, integer *, integer *, 
	    integer *);
    extern /* Subroutine */ int cgebr2d_(integer *, char *, char *, integer *,
	     integer *, complex *, integer *, integer *, integer *, ftnlen, 
	    ftnlen), cgebs2d_(integer *, char *, char *, integer *, integer *,
	     complex *, integer *, ftnlen, ftnlen), sgebr2d_(integer *, char *
	    , char *, integer *, integer *, real *, integer *, integer *, 
	    integer *, ftnlen, ftnlen), sgebs2d_(integer *, char *, char *, 
	    integer *, integer *, real *, integer *, ftnlen, ftnlen);
    static integer ivxrow;
    extern /* Subroutine */ int infog2l_(integer *, integer *, integer *, 
	    integer *, integer *, integer *, integer *, integer *, integer *, 
	    integer *, integer *);
    extern integer indxg2l_(integer *, integer *, integer *, integer *, 
	    integer *), indxl2g_(integer *, integer *, integer *, integer *, 
	    integer *), indxg2p_(integer *, integer *, integer *, integer *, 
	    integer *);
    extern /* Subroutine */ int pscsum1_(integer *, real *, complex *, 
	    integer *, integer *, integer *, integer *), pcelget_(char *, 
	    char *, complex *, complex *, integer *, integer *, integer *, 
	    ftnlen, ftnlen);
    extern doublereal pslamch_(integer *, char *, ftnlen);
    static integer imaxrow;


/*  -- ScaLAPACK auxiliary routine (version 1.7) -- */
/*     University of Tennessee, Knoxville, Oak Ridge National Laboratory, */
/*     and University of California, Berkeley. */
/*     May 1, 1997 */

/*     .. Scalar Arguments .. */
/*     .. */
/*     .. Array Arguments .. */
/*     .. */

/*  Purpose */
/*  ======= */

/*  PCLACON estimates the 1-norm of a square, complex distributed matrix */
/*  A. Reverse communication is used for evaluating matrix-vector */
/*  products. X and V are aligned with the distributed matrix A, this */
/*  information is implicitly contained within IV, IX, DESCV, and DESCX. */

/*  Notes */
/*  ===== */

/*  Each global data object is described by an associated description */
/*  vector.  This vector stores the information required to establish */
/*  the mapping between an object element and its corresponding process */
/*  and memory location. */

/*  Let A be a generic term for any 2D block cyclicly distributed array. */
/*  Such a global array has an associated description vector DESCA. */
/*  In the following comments, the character _ should be read as */
/*  "of the global array". */

/*  NOTATION        STORED IN      EXPLANATION */
/*  --------------- -------------- -------------------------------------- */
/*  DTYPE_A(global) DESCA( DTYPE_ )The descriptor type.  In this case, */
/*                                 DTYPE_A = 1. */
/*  CTXT_A (global) DESCA( CTXT_ ) The BLACS context handle, indicating */
/*                                 the BLACS process grid A is distribu- */
/*                                 ted over. The context itself is glo- */
/*                                 bal, but the handle (the integer */
/*                                 value) may vary. */
/*  M_A    (global) DESCA( M_ )    The number of rows in the global */
/*                                 array A. */
/*  N_A    (global) DESCA( N_ )    The number of columns in the global */
/*                                 array A. */
/*  MB_A   (global) DESCA( MB_ )   The blocking factor used to distribute */
/*                                 the rows of the array. */
/*  NB_A   (global) DESCA( NB_ )   The blocking factor used to distribute */
/*                                 the columns of the array. */
/*  RSRC_A (global) DESCA( RSRC_ ) The process row over which the first */
/*                                 row of the array A is distributed. */
/*  CSRC_A (global) DESCA( CSRC_ ) The process column over which the */
/*                                 first column of the array A is */
/*                                 distributed. */
/*  LLD_A  (local)  DESCA( LLD_ )  The leading dimension of the local */
/*                                 array.  LLD_A >= MAX(1,LOCr(M_A)). */

/*  Let K be the number of rows or columns of a distributed matrix, */
/*  and assume that its process grid has dimension p x q. */
/*  LOCr( K ) denotes the number of elements of K that a process */
/*  would receive if K were distributed over the p processes of its */
/*  process column. */
/*  Similarly, LOCc( K ) denotes the number of elements of K that a */
/*  process would receive if K were distributed over the q processes of */
/*  its process row. */
/*  The values of LOCr() and LOCc() may be determined via a call to the */
/*  ScaLAPACK tool function, NUMROC: */
/*          LOCr( M ) = NUMROC( M, MB_A, MYROW, RSRC_A, NPROW ), */
/*          LOCc( N ) = NUMROC( N, NB_A, MYCOL, CSRC_A, NPCOL ). */
/*  An upper bound for these quantities may be computed by: */
/*          LOCr( M ) <= ceil( ceil(M/MB_A)/NPROW )*MB_A */
/*          LOCc( N ) <= ceil( ceil(N/NB_A)/NPCOL )*NB_A */

/*  Arguments */
/*  ========= */

/*  N       (global input) INTEGER */
/*          The length of the distributed vectors V and X.  N >= 0. */

/*  V       (local workspace) COMPLEX pointer into the local */
/*          memory to an array of dimension LOCr(N+MOD(IV-1,MB_V)). On */
/*          the final return, V = A*W, where EST = norm(V)/norm(W) */
/*          (W is not returned). */

/*  IV      (global input) INTEGER */
/*          The row index in the global array V indicating the first */
/*          row of sub( V ). */

/*  JV      (global input) INTEGER */
/*          The column index in the global array V indicating the */
/*          first column of sub( V ). */

/*  DESCV   (global and local input) INTEGER array of dimension DLEN_. */
/*          The array descriptor for the distributed matrix V. */

/*  X       (local input/local output) COMPLEX pointer into the */
/*          local memory to an array of dimension */
/*          LOCr(N+MOD(IX-1,MB_X)). On an intermediate return, X */
/*          should be overwritten by */
/*                A * X,   if KASE=1, */
/*                A' * X,  if KASE=2, */
/*          where A' is the conjugate transpose of A, and PCLACON must */
/*          be re-called with all the other parameters unchanged. */

/*  IX      (global input) INTEGER */
/*          The row index in the global array X indicating the first */
/*          row of sub( X ). */

/*  JX      (global input) INTEGER */
/*          The column index in the global array X indicating the */
/*          first column of sub( X ). */

/*  DESCX   (global and local input) INTEGER array of dimension DLEN_. */
/*          The array descriptor for the distributed matrix X. */


/*  EST     (global output) REAL */
/*          An estimate (a lower bound) for norm(A). */

/*  KASE    (local input/local output) INTEGER */
/*          On the initial call to PCLACON, KASE should be 0. */
/*          On an intermediate return, KASE will be 1 or 2, indicating */
/*          whether X should be overwritten by A * X  or A' * X. */
/*          On the final return from PCLACON, KASE will again be 0. */

/*  Further Details */
/*  =============== */

/*  The serial version CLACON has been contributed by Nick Higham, */
/*  University of Manchester. It was originally named SONEST, dated */
/*  March 16, 1988. */

/*  Reference: N.J. Higham, "FORTRAN codes for estimating the one-norm of */
/*  a real or complex matrix, with applications to condition estimation", */
/*  ACM Trans. Math. Soft., vol. 14, no. 4, pp. 381-396, December 1988. */

/*  ===================================================================== */

/*     .. Parameters .. */
/*     .. */
/*     .. Local Scalars .. */
/*     .. */
/*     .. Local Arrays .. */
/*     .. */
/*     .. External Subroutines .. */
/*     .. */
/*     .. External Functions .. */
/*     .. */
/*     .. Intrinsic Functions .. */
/*     .. */
/*     .. Save statement .. */
/*     .. */
/*     .. Executable Statements .. */

/*     Get grid parameters. */

    /* Parameter adjustments */
    --descx;
    --x;
    --descv;
    --v;

    /* Function Body */
    ictxt = descx[2];
    blacs_gridinfo__(&ictxt, &nprow, &npcol, &myrow, &mycol);

    infog2l_(ix, jx, &descx[1], &nprow, &npcol, &myrow, &mycol, &iivx, &jjvx, 
	    &ivxrow, &ivxcol);
    if (mycol != ivxcol) {
	return 0;
    }
    iroff = (*ix - 1) % descx[5];
    i__1 = *n + iroff;
    np = numroc_(&i__1, &descx[5], &myrow, &ivxrow, &nprow);
    if (myrow == ivxrow) {
	np -= iroff;
    }
    ioffvx = iivx + (jjvx - 1) * descx[9];

    safmin = pslamch_(&ictxt, "Safe minimum", (ftnlen)12);
    if (*kase == 0) {
	i__1 = ioffvx + np - 1;
	for (i__ = ioffvx; i__ <= i__1; ++i__) {
	    i__2 = i__;
	    r__1 = 1.f / (real) (*n);
	    q__1.r = r__1, q__1.i = 0.f;
	    x[i__2].r = q__1.r, x[i__2].i = q__1.i;
/* L10: */
	}
	*kase = 1;
	jump = 1;
	return 0;
    }

    switch (jump) {
	case 1:  goto L20;
	case 2:  goto L40;
	case 3:  goto L70;
	case 4:  goto L90;
	case 5:  goto L120;
    }

/*     ................ ENTRY   (JUMP = 1) */
/*     FIRST ITERATION.  X HAS BEEN OVERWRITTEN BY A*X */

L20:
    if (*n == 1) {
	if (myrow == ivxrow) {
	    i__1 = ioffvx;
	    i__2 = ioffvx;
	    v[i__1].r = x[i__2].r, v[i__1].i = x[i__2].i;
	    *est = c_abs(&v[ioffvx]);
	    sgebs2d_(&ictxt, "Columnwise", " ", &c__1, &c__1, est, &c__1, (
		    ftnlen)10, (ftnlen)1);
	} else {
	    sgebr2d_(&ictxt, "Columnwise", " ", &c__1, &c__1, est, &c__1, &
		    ivxrow, &mycol, (ftnlen)10, (ftnlen)1);
	}
/*        ... QUIT */
	goto L130;
    }
    pscsum1_(n, est, &x[1], ix, jx, &descx[1], &c__1);
    if (descx[3] == 1 && *n == 1) {
	if (myrow == ivxrow) {
	    sgebs2d_(&ictxt, "Columnwise", " ", &c__1, &c__1, est, &c__1, (
		    ftnlen)10, (ftnlen)1);
	} else {
	    sgebr2d_(&ictxt, "Columnwise", " ", &c__1, &c__1, est, &c__1, &
		    ivxrow, &mycol, (ftnlen)10, (ftnlen)1);
	}
    }

    i__1 = ioffvx + np - 1;
    for (i__ = ioffvx; i__ <= i__1; ++i__) {
	if (c_abs(&x[i__]) > safmin) {
	    i__2 = i__;
	    r__1 = c_abs(&x[i__]);
	    q__2.r = r__1, q__2.i = 0.f;
	    c_div(&q__1, &x[i__], &q__2);
	    x[i__2].r = q__1.r, x[i__2].i = q__1.i;
	} else {
	    i__2 = i__;
	    x[i__2].r = 1.f, x[i__2].i = 0.f;
	}
/* L30: */
    }
    *kase = 2;
    jump = 2;
    return 0;

/*     ................ ENTRY   (JUMP = 2) */
/*     FIRST ITERATION.  X HAS BEEN OVERWRITTEN BY CTRANS(A)*X */

L40:
    pcmax1_(n, &xmax, &j, &x[1], ix, jx, &descx[1], &c__1);
    if (descx[3] == 1 && *n == 1) {
	if (myrow == ivxrow) {
	    work[0].r = xmax.r, work[0].i = xmax.i;
	    r__1 = (real) j;
	    q__1.r = r__1, q__1.i = 0.f;
	    work[1].r = q__1.r, work[1].i = q__1.i;
	    cgebs2d_(&ictxt, "Columnwise", " ", &c__2, &c__1, work, &c__2, (
		    ftnlen)10, (ftnlen)1);
	} else {
	    cgebr2d_(&ictxt, "Columnwise", " ", &c__2, &c__1, work, &c__2, &
		    ivxrow, &mycol, (ftnlen)10, (ftnlen)1);
	    xmax.r = work[0].r, xmax.i = work[0].i;
	    r__1 = work[1].r;
	    j = i_nint(&r__1);
	}
    }
    iter = 2;

/*     MAIN LOOP - ITERATIONS 2, 3,...,ITMAX */

L50:
    i__1 = ioffvx + np - 1;
    for (i__ = ioffvx; i__ <= i__1; ++i__) {
	i__2 = i__;
	x[i__2].r = 0.f, x[i__2].i = 0.f;
/* L60: */
    }
    imaxrow = indxg2p_(&j, &descx[5], &myrow, &descx[7], &nprow);
    if (myrow == imaxrow) {
	i__ = indxg2l_(&j, &descx[5], &myrow, &descx[7], &nprow);
	i__1 = i__;
	x[i__1].r = 1.f, x[i__1].i = 0.f;
    }
    *kase = 1;
    jump = 3;
    return 0;

/*     ................ ENTRY   (JUMP = 3) */
/*     X HAS BEEN OVERWRITTEN BY A*X */

L70:
    lfc_SLccopy(&np, &x[ioffvx], &c__1, &v[ioffvx], &c__1);
    estold = *est;
    pscsum1_(n, est, &v[1], iv, jv, &descv[1], &c__1);
    if (descv[3] == 1 && *n == 1) {
	if (myrow == ivxrow) {
	    sgebs2d_(&ictxt, "Columnwise", " ", &c__1, &c__1, est, &c__1, (
		    ftnlen)10, (ftnlen)1);
	} else {
	    sgebr2d_(&ictxt, "Columnwise", " ", &c__1, &c__1, est, &c__1, &
		    ivxrow, &mycol, (ftnlen)10, (ftnlen)1);
	}
    }

/*     TEST FOR CYCLING */
    if (*est <= estold) {
	goto L100;
    }

    i__1 = ioffvx + np - 1;
    for (i__ = ioffvx; i__ <= i__1; ++i__) {
	if (c_abs(&x[i__]) > safmin) {
	    i__2 = i__;
	    r__1 = c_abs(&x[i__]);
	    q__2.r = r__1, q__2.i = 0.f;
	    c_div(&q__1, &x[i__], &q__2);
	    x[i__2].r = q__1.r, x[i__2].i = q__1.i;
	} else {
	    i__2 = i__;
	    x[i__2].r = 1.f, x[i__2].i = 0.f;
	}
/* L80: */
    }
    *kase = 2;
    jump = 4;
    return 0;

/*     ................ ENTRY   (JUMP = 4) */
/*     X HAS BEEN OVERWRITTEN BY CTRANS(A)*X */

L90:
    jlast = j;
    pcmax1_(n, &xmax, &j, &x[1], ix, jx, &descx[1], &c__1);
    if (descx[3] == 1 && *n == 1) {
	if (myrow == ivxrow) {
	    work[0].r = xmax.r, work[0].i = xmax.i;
	    r__1 = (real) j;
	    q__1.r = r__1, q__1.i = 0.f;
	    work[1].r = q__1.r, work[1].i = q__1.i;
	    cgebs2d_(&ictxt, "Columnwise", " ", &c__2, &c__1, work, &c__2, (
		    ftnlen)10, (ftnlen)1);
	} else {
	    cgebr2d_(&ictxt, "Columnwise", " ", &c__2, &c__1, work, &c__2, &
		    ivxrow, &mycol, (ftnlen)10, (ftnlen)1);
	    xmax.r = work[0].r, xmax.i = work[0].i;
	    r__1 = work[1].r;
	    j = i_nint(&r__1);
	}
    }
    pcelget_("Columnwise", " ", &jlmax, &x[1], &jlast, jx, &descx[1], (ftnlen)
	    10, (ftnlen)1);
    if (jlmax.r != (r__1 = xmax.r, dabs(r__1)) && iter < 5) {
	++iter;
	goto L50;
    }

/*     ITERATION COMPLETE.  FINAL STAGE. */

L100:
    i__1 = ioffvx + np - 1;
    for (i__ = ioffvx; i__ <= i__1; ++i__) {
	i__2 = i__ - ioffvx + iivx;
	k = indxl2g_(&i__2, &descx[5], &myrow, &descx[7], &nprow) - *ix + 1;
	if (k % 2 == 0) {
	    altsgn = -1.f;
	} else {
	    altsgn = 1.f;
	}
	i__2 = i__;
	r__1 = altsgn * ((real) (k - 1) / (real) (*n - 1) + 1.f);
	q__1.r = r__1, q__1.i = 0.f;
	x[i__2].r = q__1.r, x[i__2].i = q__1.i;
/* L110: */
    }
    *kase = 1;
    jump = 5;
    return 0;

/*     ................ ENTRY   (JUMP = 5) */
/*     X HAS BEEN OVERWRITTEN BY A*X */

L120:
    pscsum1_(n, &temp, &x[1], ix, jx, &descx[1], &c__1);
    if (descx[3] == 1 && *n == 1) {
	if (myrow == ivxrow) {
	    sgebs2d_(&ictxt, "Columnwise", " ", &c__1, &c__1, &temp, &c__1, (
		    ftnlen)10, (ftnlen)1);
	} else {
	    sgebr2d_(&ictxt, "Columnwise", " ", &c__1, &c__1, &temp, &c__1, &
		    ivxrow, &mycol, (ftnlen)10, (ftnlen)1);
	}
    }
    temp = temp / (real) (*n * 3) * 2.f;
    if (temp > *est) {
	lfc_SLccopy(&np, &x[ioffvx], &c__1, &v[ioffvx], &c__1);
	*est = temp;
    }

L130:
    *kase = 0;

    return 0;

/*     End of PCLACON */

} /* pclacon_ */

